/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;

public abstract class EntityComparator<E>
implements Comparator<E> {
    protected final String mainProjectName = EntityComparator.getMainProjectName();
    protected final Collection<String> namesOfOpenProjects = EntityComparator.getNamesOfOpenProjects();

    @Override
    protected int compare(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.compareTo(s2);
    }

    protected int compare(String s1, String s2, boolean caseSensitive) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
    }

    protected int compareProjects(String p1Name, String p2Name) {
        boolean isP2Closed;
        if (p1Name == null) {
            p1Name = "";
        }
        if (p2Name == null) {
            p2Name = "";
        }
        if (p1Name.isEmpty()) {
            if (p2Name.isEmpty()) {
                return 0;
            }
            return 1;
        }
        if (p2Name.isEmpty()) {
            return -1;
        }
        boolean isP1Closed = !this.namesOfOpenProjects.contains(p1Name);
        boolean bl = isP2Closed = !this.namesOfOpenProjects.contains(p2Name);
        if (isP1Closed) {
            if (isP2Closed) {
                return 0;
            }
            return 1;
        }
        if (isP2Closed) {
            return -1;
        }
        if (p1Name.equals(this.mainProjectName)) {
            if (p2Name.equals(this.mainProjectName)) {
                return 0;
            }
            return -1;
        }
        if (p2Name.equals(this.mainProjectName)) {
            return 1;
        }
        return 0;
    }

    public String levenshteinPrefix(@NonNull String name, @NonNull String text, boolean caseSensitive) {
        int i;
        if (!caseSensitive) {
            name = name.toLowerCase();
            text = text.toLowerCase();
        }
        int index = 0;
        for (i = 0; i < name.length() && index < text.length(); ++i) {
            if (name.charAt(i) != text.charAt(index)) continue;
            ++index;
        }
        return name.substring(0, i);
    }

    public final int levenshteinDistance(@NonNull String str1, @NonNull String str2, boolean caseSensitive) {
        int i;
        if (!caseSensitive) {
            str1 = str1.toLowerCase();
            str2 = str2.toLowerCase();
        }
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 1; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = EntityComparator.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[str1.length()][str2.length()];
    }

    public static String getMainProjectName() {
        Project mainProject = OpenProjects.getDefault().getMainProject();
        return mainProject == null ? null : ProjectUtils.getInformation((Project)mainProject).getDisplayName();
    }

    private static Collection<String> getNamesOfOpenProjects() {
        ArrayList<String> names = new ArrayList<String>(10);
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            String pName = ProjectUtils.getInformation((Project)p).getDisplayName();
            names.add(pName);
        }
        return names;
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }
}

