/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.javafx2.editor.completion.model.CompoundCharSequence;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxObjectBase;
import org.netbeans.modules.javafx2.editor.completion.model.HasContent;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;

public class PropertySetter
extends PropertyValue
implements HasContent {
    private Object valueContent;
    private boolean implicit;
    private List<FxObjectBase> valueBeans = Collections.emptyList();

    PropertySetter(String propertyName) {
        super(propertyName);
    }

    PropertySetter asImplicitDefault() {
        this.implicit = true;
        return this;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public List<FxObjectBase> getValues() {
        return Collections.unmodifiableList(this.valueBeans);
    }

    @Override
    public CharSequence getContent() {
        CharSequence c = PropertySetter.getValContent(this.valueContent);
        if (c != this.valueContent) {
            this.valueContent = c;
        }
        return c;
    }

    void addValue(FxObjectBase instance) {
        if (this.valueBeans.isEmpty()) {
            this.valueBeans = new ArrayList<FxObjectBase>();
        }
        this.valueBeans.add(instance);
    }

    @Override
    public void accept(FxNodeVisitor v) {
        v.visitPropertySetter(this);
    }

    static Object addCharContent(Object valueContent, CharSequence content) {
        if (valueContent == null) {
            valueContent = content;
        } else if (valueContent instanceof CharSequence) {
            ArrayList<CharSequence> parts = new ArrayList<CharSequence>();
            parts.add((CharSequence)((Object)valueContent));
            parts.add(content);
            valueContent = parts;
        } else if (valueContent instanceof List) {
            ((List)valueContent).add(content);
        }
        return valueContent;
    }

    static CharSequence getValContent(Object valueContent) {
        if (valueContent == null) {
            return null;
        }
        if (valueContent instanceof CharSequence) {
            return (CharSequence)valueContent;
        }
        if (valueContent instanceof List) {
            return new CompoundCharSequence(0, (List)valueContent, -1);
        }
        throw new IllegalStateException();
    }

    void addContent(CharSequence content) {
        this.valueContent = PropertySetter.addCharContent(this.valueContent, content);
    }

    @Override
    void addChild(FxNode child) {
        super.addChild(child);
        if (!(child instanceof FxObjectBase)) {
            throw new IllegalArgumentException();
        }
        this.addValue((FxObjectBase)child);
    }
}

