/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDbHomeRequest
extends BmcRequest<Void> {
    private String dbHomeId;
    private String ifMatch;
    private Boolean performFinalBackup;

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getPerformFinalBackup() {
        return this.performFinalBackup;
    }

    public Builder toBuilder() {
        return new Builder().dbHomeId(this.dbHomeId).ifMatch(this.ifMatch).performFinalBackup(this.performFinalBackup);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",performFinalBackup=").append(String.valueOf(this.performFinalBackup));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDbHomeRequest)) {
            return false;
        }
        DeleteDbHomeRequest other = (DeleteDbHomeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbHomeId, other.dbHomeId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.performFinalBackup, other.performFinalBackup);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.performFinalBackup == null ? 43 : this.performFinalBackup.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDbHomeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbHomeId = null;
        private String ifMatch = null;
        private Boolean performFinalBackup = null;

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder performFinalBackup(Boolean performFinalBackup) {
            this.performFinalBackup = performFinalBackup;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDbHomeRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.ifMatch(o.getIfMatch());
            this.performFinalBackup(o.getPerformFinalBackup());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDbHomeRequest build() {
            DeleteDbHomeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDbHomeRequest buildWithoutInvocationCallback() {
            DeleteDbHomeRequest request = new DeleteDbHomeRequest();
            request.dbHomeId = this.dbHomeId;
            request.ifMatch = this.ifMatch;
            request.performFinalBackup = this.performFinalBackup;
            return request;
        }
    }
}

