/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.completion.DefaultContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class SyntaxQueryHelper {
    public static final int COMPLETION_TYPE_UNKNOWN = 0;
    public static final int COMPLETION_TYPE_ATTRIBUTE = 1;
    public static final int COMPLETION_TYPE_VALUE = 2;
    public static final int COMPLETION_TYPE_ELEMENT = 3;
    public static final int COMPLETION_TYPE_ENTITY = 4;
    public static final int COMPLETION_TYPE_NOTATION = 5;
    public static final int COMPLETION_TYPE_DTD = 6;
    private XMLSyntaxSupport support;
    private Token<XMLTokenId> token = null;
    private int tokenOffset;
    private String preText = "";
    private int erase = 0;
    private int tunedOffset = 0;
    private SyntaxElement element;
    private int completionType = 0;
    private boolean tokenBoundary;
    private DefaultContext ctx = new DefaultContext();

    public SyntaxQueryHelper(XMLSyntaxSupport sup, int offset) throws BadLocationException, IllegalStateException {
        this.support = sup;
        this.tunedOffset = offset;
        sup.runWithSequence(this.tunedOffset, seq -> {
            this.token = sup.getPreviousToken(this.tunedOffset);
            this.tokenOffset = seq.offset();
            return null;
        });
        if (this.token == null) {
            throw new BadLocationException("No token found at current position", offset);
        }
        this.tokenBoundary = this.tokenOffset + this.token.length() == this.tunedOffset;
        int itemOffset = this.tokenOffset;
        this.preText = "";
        this.erase = 0;
        int eraseRight = 0;
        XMLTokenId id = (XMLTokenId)this.token.id();
        if (!this.tokenBoundary) {
            this.preText = this.token.text().toString().substring(0, this.tunedOffset - this.tokenOffset);
            if ("".equals(this.preText)) {
                throw new IllegalStateException("Cannot get token prefix at " + this.tunedOffset);
            }
            if (sup.lastTypedChar() != '<' && sup.lastTypedChar() != '&') {
                switch (id) {
                    case TAG: 
                    case CHARACTER: 
                    case ARGUMENT: {
                        int i = this.token.length();
                        int tail = i - (this.tunedOffset - itemOffset);
                        this.tunedOffset += tail;
                        eraseRight = tail;
                    }
                }
            }
        } else {
            switch (id) {
                case TAG: 
                case CHARACTER: 
                case ARGUMENT: 
                case TEXT: 
                case PI_CONTENT: {
                    this.preText = this.token.text().toString();
                }
            }
        }
        switch (id) {
            case TAG: {
                this.erase = this.preText.length() - 1 + eraseRight;
                break;
            }
            case CHARACTER: {
                this.erase = this.preText.length() + -1 + eraseRight;
                break;
            }
            case ARGUMENT: {
                this.erase = this.preText.length() + eraseRight;
                break;
            }
            case VALUE: {
                this.erase = this.preText.length();
                if (this.erase <= 0 || this.preText.charAt(0) != '\'' && this.preText.charAt(0) != '\"') break;
                --this.erase;
            }
        }
        this.element = sup.getElementChain(this.tunedOffset);
        if (this.element == null) {
            throw new IllegalStateException("There exists a token therefore a syntax element must exist at " + offset + ", too.");
        }
        this.completionType = this.element.getType() != -1 && this.element.getType() != 10 ? this.support.runLocked(this::initContext) : 6;
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    private int initContext() throws BadLocationException {
        XMLTokenId id = (XMLTokenId)this.token.id();
        Object syntaxNode = this.element.getNode();
        switch (id) {
            case TEXT: {
                if (this.preText.endsWith("<") || this.preText.endsWith("</")) {
                    this.ctx.init((Node)syntaxNode, "");
                    return 3;
                }
                if (this.preText.startsWith("&")) {
                    this.ctx.init((Node)syntaxNode, this.preText.substring(1));
                    return 4;
                }
                this.ctx.init((Node)syntaxNode, this.preText);
                return 2;
            }
            case TAG: {
                if (this.support.isNormalTag(this.element)) {
                    if (this.preText.equals("")) {
                        if (this.token.text().toString().endsWith(">")) {
                            this.ctx.init((Node)syntaxNode, this.preText);
                            return 2;
                        }
                        this.ctx.init((Node)syntaxNode, this.preText);
                        return 3;
                    }
                    if (this.preText.endsWith("/>")) {
                        this.ctx.init((Node)syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.endsWith(">")) {
                        this.ctx.init((Node)syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.startsWith("</")) {
                        this.ctx.init((Node)syntaxNode, this.preText.substring(2));
                        return 3;
                    }
                    if (!this.preText.startsWith("<")) break;
                    this.ctx.init((Node)syntaxNode, this.preText.substring(1));
                    return 3;
                }
                if (this.support.isEndTag(this.element) && this.preText.startsWith("</")) {
                    this.ctx.init((Node)syntaxNode, this.preText.substring(2));
                    return 3;
                }
                if (!"".equals(this.preText) || !this.token.text().toString().endsWith(">")) break;
                this.ctx.init((Node)syntaxNode, this.preText);
                return 2;
            }
            case VALUE: {
                if (this.preText.endsWith("&")) {
                    this.ctx.init((Node)syntaxNode, "");
                    return 4;
                }
                if ("".equals(this.preText)) {
                    String image = this.token.text().toString();
                    char ch = image.charAt(image.length() - 1);
                    if (ch == '\'' || ch == '\"') {
                        if (image.charAt(0) == ch && image.length() > 1) {
                            return 0;
                        }
                        int res = this.support.runWithSequence(this.tokenOffset, seq -> {
                            Token prev = this.support.getPreviousToken(this.tokenOffset);
                            boolean closing = false;
                            while (prev != null) {
                                XMLTokenId tid = (XMLTokenId)prev.id();
                                if (tid == XMLTokenId.VALUE) {
                                    closing = true;
                                    break;
                                }
                                if (tid != XMLTokenId.CHARACTER) break;
                                if (!seq.movePrevious()) {
                                    return 0;
                                }
                                prev = seq.token();
                            }
                            if (!closing) {
                                this.ctx.init((Node)syntaxNode, this.preText);
                                return 2;
                            }
                            return 0;
                        });
                        if (res == 0) break;
                        return res;
                    }
                    this.ctx.init((Node)syntaxNode, this.preText);
                    return 2;
                }
                NamedNodeMap attrs = syntaxNode.getAttributes();
                int maxOffsetLessThanCurrent = -1;
                Node curAttrNode = null;
                for (int ind = 0; ind < attrs.getLength(); ++ind) {
                    SyntaxElement attr = (SyntaxElement)((Object)attrs.item(ind));
                    int attrTokOffset = attr.getElementOffset();
                    if (attrTokOffset <= maxOffsetLessThanCurrent || attrTokOffset >= this.tokenOffset) continue;
                    maxOffsetLessThanCurrent = attrTokOffset;
                    curAttrNode = (Node)((Object)attr);
                }
                if (this.preText.length() > 0) {
                    this.preText = this.preText.substring(1);
                }
                if (curAttrNode != null) {
                    this.ctx.init(curAttrNode, this.preText);
                } else {
                    this.ctx.init((Node)syntaxNode, this.preText);
                }
                return 2;
            }
            case OPERATOR: {
                if (!"".equals(this.preText) || !"=".equals(this.token.text())) break;
                this.ctx.init((Node)syntaxNode, "");
                return 2;
            }
            case WS: {
                if (this.support.isNormalTag(this.element) && !this.token.text().toString().startsWith("/")) {
                    this.ctx.init((Element)syntaxNode, "");
                    return 1;
                }
                return 0;
            }
            case ARGUMENT: {
                if (!this.support.isStartTag(this.element) && !this.support.isEmptyTag(this.element)) break;
                NamedNodeMap nnm = syntaxNode.getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    Attr attrNode = (Attr)nnm.item(i);
                    if (this.support.getNodeOffset(attrNode) != this.tokenOffset) continue;
                    this.ctx.init(attrNode, this.preText);
                }
                if (!this.ctx.isInitialized()) {
                    this.ctx.init((Element)syntaxNode, this.preText);
                }
                return 1;
            }
            case CHARACTER: {
                if (this.preText.startsWith("&#")) {
                    return 0;
                }
                if (this.preText.endsWith(";")) {
                    this.ctx.init((Node)syntaxNode, "");
                    return 2;
                }
                if (this.preText.startsWith("&")) {
                    this.ctx.init((Node)syntaxNode, this.preText.substring(1));
                    return 4;
                }
                if (!"".equals(this.preText) || !this.token.text().toString().endsWith(";")) break;
                this.ctx.init((Node)syntaxNode, this.preText);
                return 2;
            }
        }
        return 0;
    }

    public HintContext getContext() {
        if (this.completionType != 0 && this.completionType != 6) {
            return this.ctx;
        }
        return null;
    }

    public Token<XMLTokenId> getToken() {
        return this.token;
    }

    public String getPreText() {
        return this.preText;
    }

    public int getEraseCount() {
        return this.erase;
    }

    public int getOffset() {
        return this.tunedOffset;
    }

    public SyntaxElement getSyntaxElement() {
        return this.element;
    }

    public int getCompletionType() {
        return this.completionType;
    }

    public boolean isBoundary() {
        return this.tokenBoundary;
    }
}

