/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.refactoring.dependency.DocumentChangesConverter;
import org.netbeans.modules.maven.refactoring.dependency.MavenDependencyModifierImpl;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.lookup.Lookups;

public class RewriteContext {
    private final Project project;
    private final FileObject pomFile;
    private POMModel mutableModel;
    private Document documentCopy;
    private DocumentChangesConverter converter;

    public RewriteContext(Project project) {
        this.project = project;
        this.pomFile = (FileObject)project.getLookup().lookup(FileObject.class);
    }

    public FileObject getPomFile() {
        return this.pomFile;
    }

    public POMModel getWriteModel() throws IOException {
        if (this.mutableModel == null) {
            this.createModel();
        }
        return this.mutableModel;
    }

    public List<TextEdit> createEdits() {
        return this.converter.makeTextEdits();
    }

    public String mavenScope(Dependency d) {
        if (d.getScope() == null) {
            return "compile";
        }
        String ms = MavenDependencyModifierImpl.scope2Maven.get(d.getScope().name());
        if (ms == null) {
            return "compile";
        }
        return ms;
    }

    private void createModel() throws IOException {
        NbMavenProject mp = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        FileObject pomFile = (FileObject)this.project.getLookup().lookup(FileObject.class);
        EditorCookie cake = (EditorCookie)pomFile.getLookup().lookup(EditorCookie.class);
        StyledDocument d = cake.openDocument();
        LineDocument copy = LineDocumentUtils.createDocument((String)"text/pom+xml");
        try {
            copy.insertString(0, d.getText(0, d.getLength()), null);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        copy.putProperty("stream", d.getProperty("stream"));
        this.documentCopy = copy;
        this.converter = new DocumentChangesConverter(this.documentCopy);
        copy.addDocumentListener(this.converter);
        ArrayList<Object> lkpContents = new ArrayList<Object>();
        lkpContents.add(pomFile);
        lkpContents.add(copy);
        File f = FileUtil.toFile((FileObject)pomFile);
        if (f != null) {
            lkpContents.add(f);
        }
        ModelSource ms = new ModelSource(Lookups.fixed((Object[])lkpContents.toArray()), true);
        this.mutableModel = POMModelFactory.getDefault().getModel(ms);
    }
}

