/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.HttpMethodNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class HttpMethodsChildren
extends ChildFactory<HttpMethodNode>
implements PropertyChangeListener {
    private static final Comparator<HttpMethodNode> COMPARATOR = new HttpMethodsComparator();
    private Project project;
    private RestServicesModel model;
    private String serviceName;

    public HttpMethodsChildren(Project project, RestServicesModel model, String serviceName) {
        this.project = project;
        this.model = model;
        this.serviceName = serviceName;
        model.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected boolean createKeys(final List<HttpMethodNode> keys) {
        try {
            this.model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){
                final /* synthetic */ HttpMethodsChildren this$0;
                {
                    this.this$0 = this$0;
                }

                public Void run(RestServicesMetadata metadata) throws IOException {
                    RestServices root = metadata.getRoot();
                    RestServiceDescription desc = root.getRestServiceDescription(this.this$0.serviceName);
                    if (desc != null) {
                        for (RestMethodDescription method : desc.getMethods()) {
                            if (!(method instanceof HttpMethod)) continue;
                            keys.add(new HttpMethodNode(this.this$0.project, desc, (HttpMethod)method));
                        }
                        keys.sort(COMPARATOR);
                    }
                    return null;
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    protected Node createNodeForKey(HttpMethodNode node) {
        return node;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("/restservices".equals(evt.getPropertyName())) {
            this.refresh(false);
        }
    }

    static class HttpMethodsComparator
    implements Comparator<HttpMethodNode> {
        HttpMethodsComparator() {
        }

        @Override
        public int compare(HttpMethodNode node1, HttpMethodNode node2) {
            String key1 = node1.getKey();
            String key2 = node2.getKey();
            return key1.compareTo(key2);
        }
    }
}

