/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class UnnecessaryClosingDelimiterHint
extends HintRule {
    private static final String HINT_ID = "unnecessary.closing.delimiter.hint";
    private FileObject fileObject;
    private BaseDocument baseDocument;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null) {
            this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
            this.baseDocument = context.doc;
            if (this.fileObject != null) {
                int startOffset;
                TokenSequence<PHPTokenId> ts;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                TokenHierarchy th = phpParseResult.getSnapshot().getTokenHierarchy();
                if (th != null && (ts = LexUtilities.getPHPTokenSequence(th, startOffset = phpParseResult.getProgram().getStartOffset())) != null) {
                    ts.move(startOffset);
                    CloseTagWrapper closeTagWrapper = this.createCloseTagWrapper(ts);
                    if (closeTagWrapper.shouldBeRemoved()) {
                        closeTagWrapper.createHint(result);
                    }
                }
            }
        }
    }

    private CloseTagWrapper createCloseTagWrapper(TokenSequence<PHPTokenId> ts) {
        CloseTagWrapper result = CloseTagWrapper.NONE;
        boolean inOpenTagWithEcho = false;
        block5: while (ts.moveNext()) {
            Token token = ts.token();
            if (token == null) continue;
            PHPTokenId id = (PHPTokenId)token.id();
            switch (id) {
                case T_OPEN_TAG_WITH_ECHO: {
                    inOpenTagWithEcho = true;
                    continue block5;
                }
                case PHP_CLOSETAG: {
                    result = new CloseTagWrapperImpl(ts.offset(), inOpenTagWithEcho);
                    continue block5;
                }
                case T_INLINE_HTML: {
                    result.setHtmlPart((Token<PHPTokenId>)token);
                    continue block5;
                }
            }
            result = CloseTagWrapper.NONE;
        }
        return result;
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UnnecessaryClosingDelimiterHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UnnecessaryClosingDelimiterHintDisp();
    }

    private static interface CloseTagWrapper {
        public static final CloseTagWrapper NONE = new CloseTagWrapper(){

            @Override
            public void setHtmlPart(Token<PHPTokenId> inlineHtmlTag) {
            }

            @Override
            public boolean shouldBeRemoved() {
                return false;
            }

            @Override
            public void createHint(List<Hint> result) {
            }
        };

        public void setHtmlPart(Token<PHPTokenId> var1);

        public boolean shouldBeRemoved();

        public void createHint(List<Hint> var1);
    }

    private final class CloseTagWrapperImpl
    implements CloseTagWrapper {
        private static final String CLOSING_TAG = "?>";
        private final int closeTagOffset;
        private final boolean startsWithOpenTagWithEcho;
        private Token<PHPTokenId> inlineHtmlTag;

        private CloseTagWrapperImpl(int closeTagOffset, boolean startsWithOpenTagWithEcho) {
            this.closeTagOffset = closeTagOffset;
            this.startsWithOpenTagWithEcho = startsWithOpenTagWithEcho;
        }

        @Override
        public void setHtmlPart(Token<PHPTokenId> inlineHtmlTag) {
            this.inlineHtmlTag = inlineHtmlTag;
        }

        @Override
        public boolean shouldBeRemoved() {
            return !this.startsWithOpenTagWithEcho && (this.inlineHtmlTag == null || TokenUtilities.trim((CharSequence)this.inlineHtmlTag.text()).length() == 0);
        }

        @Override
        public void createHint(List<Hint> result) {
            OffsetRange hintRange = new OffsetRange(this.closeTagOffset, this.closeTagOffset + CLOSING_TAG.length());
            result.add(new Hint((Rule)UnnecessaryClosingDelimiterHint.this, Bundle.UnnecessaryClosingDelimiterHintText(), UnnecessaryClosingDelimiterHint.this.fileObject, hintRange, Collections.singletonList(new Fix(hintRange, UnnecessaryClosingDelimiterHint.this.baseDocument)), 500));
        }
    }

    private static final class Fix
    implements HintFix {
        private final OffsetRange hintRange;
        private final BaseDocument baseDocument;

        public Fix(OffsetRange hintRange, BaseDocument baseDocument) {
            this.hintRange = hintRange;
            this.baseDocument = baseDocument;
        }

        public String getDescription() {
            return Bundle.UnnecessaryClosingDelimiterHintFix();
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.baseDocument);
            editList.replace(this.hintRange.getStart(), this.hintRange.getLength(), "", true, 0);
            editList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

