/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug;

import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.netbeans.lib.v8debug.PropertyBoolean;
import org.netbeans.lib.v8debug.PropertyLong;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Body;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Event;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Scope;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.V8ScriptLocation;
import org.netbeans.lib.v8debug.V8Type;
import org.netbeans.lib.v8debug.commands.Backtrace;
import org.netbeans.lib.v8debug.commands.ChangeBreakpoint;
import org.netbeans.lib.v8debug.commands.ChangeLive;
import org.netbeans.lib.v8debug.commands.ClearBreakpoint;
import org.netbeans.lib.v8debug.commands.ClearBreakpointGroup;
import org.netbeans.lib.v8debug.commands.Continue;
import org.netbeans.lib.v8debug.commands.Evaluate;
import org.netbeans.lib.v8debug.commands.Flags;
import org.netbeans.lib.v8debug.commands.Frame;
import org.netbeans.lib.v8debug.commands.GC;
import org.netbeans.lib.v8debug.commands.ListBreakpoints;
import org.netbeans.lib.v8debug.commands.Lookup;
import org.netbeans.lib.v8debug.commands.References;
import org.netbeans.lib.v8debug.commands.RestartFrame;
import org.netbeans.lib.v8debug.commands.Scope;
import org.netbeans.lib.v8debug.commands.Scopes;
import org.netbeans.lib.v8debug.commands.Scripts;
import org.netbeans.lib.v8debug.commands.SetBreakpoint;
import org.netbeans.lib.v8debug.commands.SetExceptionBreak;
import org.netbeans.lib.v8debug.commands.SetVariableValue;
import org.netbeans.lib.v8debug.commands.Source;
import org.netbeans.lib.v8debug.commands.Threads;
import org.netbeans.lib.v8debug.commands.V8Flags;
import org.netbeans.lib.v8debug.commands.Version;
import org.netbeans.lib.v8debug.connection.LinkedJSONObject;
import org.netbeans.lib.v8debug.events.AfterCompileEventBody;
import org.netbeans.lib.v8debug.events.BreakEventBody;
import org.netbeans.lib.v8debug.events.CompileErrorEventBody;
import org.netbeans.lib.v8debug.events.ExceptionEventBody;
import org.netbeans.lib.v8debug.events.ScriptCollectedEventBody;
import org.netbeans.lib.v8debug.vars.NewValue;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Boolean;
import org.netbeans.lib.v8debug.vars.V8Function;
import org.netbeans.lib.v8debug.vars.V8Generator;
import org.netbeans.lib.v8debug.vars.V8Number;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8ScriptValue;
import org.netbeans.lib.v8debug.vars.V8String;
import org.netbeans.lib.v8debug.vars.V8Value;

public class JSONWriter {
    private JSONWriter() {
    }

    public static JSONObject store(V8Request request) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"seq", (Object)request.getSequence());
        obj.put((Object)"type", (Object)V8Type.request.toString());
        V8Command command = request.getCommand();
        obj.put((Object)"command", (Object)command.toString());
        V8Arguments arguments = request.getArguments();
        if (arguments != null) {
            obj.put((Object)"arguments", JSONWriter.store(command, arguments));
        }
        return obj;
    }

    public static JSONObject store(V8Response response) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"seq", (Object)response.getSequence());
        obj.put((Object)"request_seq", (Object)response.getRequestSequence());
        obj.put((Object)"type", (Object)V8Type.response.toString());
        V8Command command = response.getCommand();
        obj.put((Object)"command", (Object)command.toString());
        boolean success = response.isSuccess();
        obj.put((Object)"success", (Object)success);
        if (success) {
            V8Body body = response.getBody();
            if (body != null) {
                obj.put((Object)"body", (Object)JSONWriter.store(command, body));
            }
        } else {
            obj.put((Object)"message", (Object)response.getErrorMessage());
        }
        ReferencedValue[] referencedValues = response.getReferencedValues();
        if (referencedValues != null) {
            obj.put((Object)"refs", (Object)JSONWriter.store(referencedValues));
        }
        obj.put((Object)"running", (Object)response.isRunning());
        return obj;
    }

    public static JSONObject store(V8Event event) {
        PropertyBoolean running;
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"seq", (Object)event.getSequence());
        obj.put((Object)"type", (Object)V8Type.event.toString());
        V8Event.Kind eventKind = event.getKind();
        obj.put((Object)"event", (Object)eventKind.toString());
        V8Body body = event.getBody();
        JSONObject bodyObj = JSONWriter.newJSONObject();
        switch (eventKind) {
            case AfterCompile: {
                AfterCompileEventBody aceb = (AfterCompileEventBody)body;
                bodyObj.put((Object)"script", (Object)JSONWriter.store(aceb.getScript()));
                break;
            }
            case CompileError: {
                CompileErrorEventBody ceeb = (CompileErrorEventBody)body;
                bodyObj.put((Object)"script", (Object)JSONWriter.store(ceeb.getScript()));
                break;
            }
            case ScriptCollected: {
                ScriptCollectedEventBody sceb = (ScriptCollectedEventBody)body;
                bodyObj.put((Object)"script", (Object)sceb.getScriptId());
                break;
            }
            case Break: {
                long[] breakpoints;
                BreakEventBody beb = (BreakEventBody)body;
                JSONWriter.storeIf(beb.getInvocationText(), bodyObj, "invocationText");
                bodyObj.put((Object)"sourceLine", (Object)beb.getSourceLine());
                bodyObj.put((Object)"sourceColumn", (Object)beb.getSourceColumn());
                JSONWriter.storeIf(beb.getSourceLineText(), bodyObj, "sourceLineText");
                V8ScriptLocation scriptLocation = beb.getScript();
                if (scriptLocation != null) {
                    bodyObj.put((Object)"script", (Object)JSONWriter.store(scriptLocation));
                }
                if ((breakpoints = beb.getBreakpoints()) == null) break;
                bodyObj.put((Object)"breakpoints", (Object)JSONWriter.array(breakpoints));
                break;
            }
            case Exception: {
                ExceptionEventBody eeb = (ExceptionEventBody)body;
                bodyObj.put((Object)"uncaught", (Object)eeb.isUncaught());
                bodyObj.put((Object)"exception", (Object)JSONWriter.store(eeb.getException()));
                bodyObj.put((Object)"sourceLine", (Object)eeb.getSourceLine());
                bodyObj.put((Object)"sourceColumn", (Object)eeb.getSourceColumn());
                JSONWriter.storeIf(eeb.getSourceLineText(), bodyObj, "sourceLineText");
                bodyObj.put((Object)"script", (Object)JSONWriter.store(eeb.getScript(), false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event kind: " + (Object)((Object)eventKind));
            }
        }
        if (event.getSuccess().hasValue()) {
            obj.put((Object)"success", (Object)event.getSuccess().getValue());
        }
        obj.put((Object)"body", (Object)bodyObj);
        ReferencedValue[] referencedValues = event.getReferencedValues();
        if (referencedValues != null) {
            obj.put((Object)"refs", (Object)JSONWriter.store(referencedValues));
        }
        if ((running = event.isRunning()).hasValue()) {
            obj.put((Object)"running", (Object)running.getValue());
        }
        return obj;
    }

    private static JSONObject newJSONObject() {
        return new LinkedJSONObject();
    }

    private static Object store(V8Command command, V8Arguments arguments) {
        JSONObject obj = JSONWriter.newJSONObject();
        switch (command) {
            case Backtrace: {
                Backtrace.Arguments btargs = (Backtrace.Arguments)arguments;
                JSONWriter.storeIf(btargs.getFromFrame(), obj, "fromFrame");
                JSONWriter.storeIf(btargs.getToFrame(), obj, "toFrame");
                JSONWriter.storeIf(btargs.isBottom(), obj, "bottom");
                JSONWriter.storeIf(btargs.isInlineRefs(), obj, "inlineRefs");
                return obj;
            }
            case Continue: {
                Continue.Arguments cargs = (Continue.Arguments)arguments;
                obj.put((Object)"stepaction", (Object)cargs.getStepAction().toString());
                JSONWriter.storeIf(cargs.getStepCount(), obj, "stepcount");
                return obj;
            }
            case Setbreakpoint: {
                SetBreakpoint.Arguments sbargs = (SetBreakpoint.Arguments)arguments;
                String bpType = V8Breakpoint.Type.scriptName.equals((Object)sbargs.getType()) ? "script" : sbargs.getType().toString();
                obj.put((Object)"type", (Object)bpType);
                obj.put((Object)"target", (Object)sbargs.getTarget());
                JSONWriter.storeIf(sbargs.getLine(), obj, "line");
                JSONWriter.storeIf(sbargs.getColumn(), obj, "column");
                JSONWriter.storeIf(sbargs.isEnabled(), obj, "enabled");
                JSONWriter.storeIf(sbargs.getCondition(), obj, "condition");
                JSONWriter.storeIf(sbargs.getIgnoreCount(), obj, "ignoreCount");
                JSONWriter.storeIf(sbargs.getGroupId(), obj, "groupId");
                return obj;
            }
            case Changebreakpoint: {
                ChangeBreakpoint.Arguments chbargs = (ChangeBreakpoint.Arguments)arguments;
                obj.put((Object)"breakpoint", (Object)chbargs.getBreakpoint());
                JSONWriter.storeIf(chbargs.isEnabled(), obj, "enabled");
                obj.put((Object)"condition", (Object)chbargs.getCondition());
                JSONWriter.storeIf(chbargs.getIgnoreCount(), obj, "ignoreCount");
                return obj;
            }
            case Clearbreakpoint: {
                ClearBreakpoint.Arguments cbargs = (ClearBreakpoint.Arguments)arguments;
                obj.put((Object)"breakpoint", (Object)cbargs.getBreakpoint());
                return obj;
            }
            case Clearbreakpointgroup: {
                ClearBreakpointGroup.Arguments cbgargs = (ClearBreakpointGroup.Arguments)arguments;
                obj.put((Object)"groupId", (Object)cbgargs.getGroupId());
                return obj;
            }
            case Setexceptionbreak: {
                SetExceptionBreak.Arguments sebargs = (SetExceptionBreak.Arguments)arguments;
                obj.put((Object)"type", (Object)sebargs.getType().toString());
                obj.put((Object)"enabled", (Object)sebargs.isEnabled());
                return obj;
            }
            case Evaluate: {
                Evaluate.Arguments eargs = (Evaluate.Arguments)arguments;
                obj.put((Object)"expression", (Object)eargs.getExpression());
                JSONWriter.storeIf(eargs.getFrame(), obj, "frame");
                JSONWriter.storeIf(eargs.isGlobal(), obj, "global");
                JSONWriter.storeIf(eargs.isDisableBreak(), obj, "disable_break");
                JSONArray additionalContexts = JSONWriter.store(eargs.getAdditionalContext());
                if (additionalContexts != null) {
                    obj.put((Object)"additional_context", (Object)additionalContexts);
                }
                return obj;
            }
            case Frame: {
                Frame.Arguments fargs = (Frame.Arguments)arguments;
                JSONWriter.storeIf(fargs.getFrameNumber(), obj, "number");
                return obj;
            }
            case Restartframe: {
                RestartFrame.Arguments ra = (RestartFrame.Arguments)arguments;
                PropertyLong frame = ra.getFrame();
                if (frame.hasValue()) {
                    obj.put((Object)"frame", (Object)frame.getValue());
                }
                return obj;
            }
            case Lookup: {
                Lookup.Arguments largs = (Lookup.Arguments)arguments;
                obj.put((Object)"handles", (Object)JSONWriter.array(largs.getHandles()));
                JSONWriter.storeIf(largs.isIncludeSource(), obj, "includeSource");
                return obj;
            }
            case References: {
                References.Arguments rargs = (References.Arguments)arguments;
                obj.put((Object)"type", (Object)rargs.getType().name());
                obj.put((Object)"handle", (Object)rargs.getHandle());
                return obj;
            }
            case Scope: {
                Scope.Arguments sargs = (Scope.Arguments)arguments;
                obj.put((Object)"number", (Object)sargs.getScopeNumber());
                JSONWriter.storeIf(sargs.getFrameNumber(), obj, "frameNumber");
                return obj;
            }
            case Scopes: {
                Scopes.Arguments ssargs = (Scopes.Arguments)arguments;
                JSONWriter.storeIf(ssargs.getFrameNumber(), obj, "frameNumber");
                return obj;
            }
            case Scripts: {
                Scripts.Arguments scargs = (Scripts.Arguments)arguments;
                if (scargs.getTypes() != null) {
                    obj.put((Object)"types", (Object)scargs.getTypes().getIntTypes());
                }
                if (scargs.getIds() != null) {
                    obj.put((Object)"ids", (Object)JSONWriter.array(scargs.getIds()));
                }
                JSONWriter.storeIf(scargs.isIncludeSource(), obj, "includeSource");
                JSONWriter.storeIf(scargs.getNameFilter(), obj, "filter");
                JSONWriter.storeIf(scargs.getIdFilter(), obj, "filter");
                return obj;
            }
            case Source: {
                Source.Arguments srcargs = (Source.Arguments)arguments;
                JSONWriter.storeIf(srcargs.getFrame(), obj, "frame");
                JSONWriter.storeIf(srcargs.getFromLine(), obj, "fromLine");
                JSONWriter.storeIf(srcargs.getToLine(), obj, "toLine");
                return obj;
            }
            case SetVariableValue: {
                SetVariableValue.Arguments svargs = (SetVariableValue.Arguments)arguments;
                obj.put((Object)"name", (Object)svargs.getName());
                obj.put((Object)"newValue", (Object)JSONWriter.store(svargs.getNewValue()));
                JSONObject scope = JSONWriter.newJSONObject();
                scope.put((Object)"number", (Object)svargs.getScopeNumber());
                JSONWriter.storeIf(svargs.getScopeFrameNumber(), scope, "frameNumber");
                obj.put((Object)"scope", (Object)scope);
                return obj;
            }
            case Changelive: {
                ChangeLive.Arguments chlargs = (ChangeLive.Arguments)arguments;
                obj.put((Object)"script_id", (Object)chlargs.getScriptId());
                JSONWriter.storeIf(chlargs.isPreviewOnly(), obj, "preview_only");
                obj.put((Object)"new_source", (Object)chlargs.getNewSource());
                return obj;
            }
            case Gc: {
                GC.Arguments gcargs = (GC.Arguments)arguments;
                obj.put((Object)"type", (Object)gcargs.getType());
                return obj;
            }
            case V8flags: {
                V8Flags.Arguments v8flargs = (V8Flags.Arguments)arguments;
                obj.put((Object)"flags", (Object)v8flargs.getFlags());
                return obj;
            }
            case Flags: {
                Flags.Arguments flargs = (Flags.Arguments)arguments;
                Map<String, Boolean> flags = flargs.getFlags();
                if (flags != null) {
                    JSONArray arr = new JSONArray();
                    for (Map.Entry<String, Boolean> flagEntry : flags.entrySet()) {
                        JSONObject f = JSONWriter.newJSONObject();
                        f.put((Object)"name", (Object)flagEntry.getKey());
                        f.put((Object)"value", (Object)flagEntry.getValue());
                        arr.add((Object)f);
                    }
                    obj.put((Object)"flags", (Object)arr);
                }
                return obj;
            }
        }
        return null;
    }

    private static JSONAware store(V8Command command, V8Body body) {
        switch (command) {
            case Listbreakpoints: {
                JSONObject obj = JSONWriter.newJSONObject();
                ListBreakpoints.ResponseBody lbrb = (ListBreakpoints.ResponseBody)body;
                obj.put((Object)"breakpoints", (Object)JSONWriter.store(lbrb.getBreakpoints()));
                obj.put((Object)"breakOnExceptions", (Object)lbrb.isBreakOnExceptions());
                obj.put((Object)"breakOnUncaughtExceptions", (Object)lbrb.isBreakOnUncaughtExceptions());
                return obj;
            }
            case Setbreakpoint: {
                JSONObject obj = JSONWriter.newJSONObject();
                SetBreakpoint.ResponseBody sbrb = (SetBreakpoint.ResponseBody)body;
                obj.put((Object)"type", (Object)sbrb.getType().toString());
                obj.put((Object)"breakpoint", (Object)sbrb.getBreakpoint());
                if (V8Breakpoint.Type.scriptId.equals((Object)sbrb.getType())) {
                    JSONWriter.storeIf(sbrb.getScriptName(), obj, "script_id");
                } else {
                    JSONWriter.storeIf(sbrb.getScriptName(), obj, "script_name");
                }
                obj.put((Object)"line", JSONWriter.getLongOrNull(sbrb.getLine()));
                obj.put((Object)"column", JSONWriter.getLongOrNull(sbrb.getColumn()));
                obj.put((Object)"actual_locations", (Object)JSONWriter.store(sbrb.getActualLocations()));
                return obj;
            }
            case Setexceptionbreak: {
                JSONObject obj = JSONWriter.newJSONObject();
                SetExceptionBreak.ResponseBody sebrb = (SetExceptionBreak.ResponseBody)body;
                obj.put((Object)"type", (Object)sebrb.getType().toString());
                obj.put((Object)"enabled", (Object)sebrb.isEnabled());
                return obj;
            }
            case Clearbreakpoint: {
                JSONObject obj = JSONWriter.newJSONObject();
                ClearBreakpoint.ResponseBody cbrb = (ClearBreakpoint.ResponseBody)body;
                obj.put((Object)"breakpoint", (Object)cbrb.getBreakpoint());
                return obj;
            }
            case Clearbreakpointgroup: {
                JSONObject obj = JSONWriter.newJSONObject();
                ClearBreakpointGroup.ResponseBody cbgrb = (ClearBreakpointGroup.ResponseBody)body;
                obj.put((Object)"breakpoints", (Object)JSONWriter.array(cbgrb.getBreakpointsCleared()));
                return obj;
            }
            case Backtrace: {
                JSONObject obj = JSONWriter.newJSONObject();
                Backtrace.ResponseBody brb = (Backtrace.ResponseBody)body;
                obj.put((Object)"fromFrame", (Object)brb.getFromFrame());
                obj.put((Object)"toFrame", (Object)brb.getToFrame());
                obj.put((Object)"totalFrames", (Object)brb.getTotalFrames());
                if (brb.getFrames() != null) {
                    obj.put((Object)"frames", (Object)JSONWriter.store(brb.getFrames()));
                }
                return obj;
            }
            case Frame: {
                Frame.ResponseBody frb = (Frame.ResponseBody)body;
                JSONObject obj = JSONWriter.store(frb.getFrame());
                return obj;
            }
            case Restartframe: {
                JSONObject obj = JSONWriter.newJSONObject();
                RestartFrame.ResponseBody rfrb = (RestartFrame.ResponseBody)body;
                obj.put((Object)"result", (Object)JSONWriter.store(rfrb.getResult()));
                return obj;
            }
            case Changelive: {
                JSONObject obj = JSONWriter.newJSONObject();
                ChangeLive.ResponseBody clrb = (ChangeLive.ResponseBody)body;
                obj.put((Object)"change_log", (Object)JSONWriter.store(clrb.getChangeLog()));
                obj.put((Object)"result", (Object)JSONWriter.store(clrb.getResult()));
                JSONWriter.storeIf(clrb.getStepInRecommended(), obj, "stepin_recommended");
                return obj;
            }
            case Lookup: {
                Lookup.ResponseBody lrb = (Lookup.ResponseBody)body;
                JSONObject obj = JSONWriter.storeValues(lrb.getValuesByHandle());
                return obj;
            }
            case Evaluate: {
                Evaluate.ResponseBody erb = (Evaluate.ResponseBody)body;
                JSONObject obj = JSONWriter.store(erb.getValue());
                return obj;
            }
            case References: {
                References.ResponseBody rrb = (References.ResponseBody)body;
                JSONArray arrayRefs = new JSONArray();
                for (V8Value vr : rrb.getReferences()) {
                    arrayRefs.add((Object)JSONWriter.store(vr));
                }
                return arrayRefs;
            }
            case Scripts: {
                Scripts.ResponseBody scrrb = (Scripts.ResponseBody)body;
                return JSONWriter.store(scrrb.getScripts());
            }
            case SetVariableValue: {
                JSONObject obj = JSONWriter.newJSONObject();
                SetVariableValue.ResponseBody svvrb = (SetVariableValue.ResponseBody)body;
                obj.put((Object)"newValue", (Object)JSONWriter.store(svvrb.getNewValue()));
                return obj;
            }
            case Scope: {
                Scope.ResponseBody srb = (Scope.ResponseBody)body;
                JSONObject obj = JSONWriter.store(srb.getScope());
                return obj;
            }
            case Scopes: {
                JSONObject obj = JSONWriter.newJSONObject();
                Scopes.ResponseBody ssrb = (Scopes.ResponseBody)body;
                obj.put((Object)"fromScope", (Object)ssrb.getFromScope());
                obj.put((Object)"toScope", (Object)ssrb.getToScope());
                obj.put((Object)"totalScopes", (Object)ssrb.getTotalScopes());
                obj.put((Object)"scopes", (Object)JSONWriter.store(ssrb.getScopes()));
                return obj;
            }
            case Source: {
                JSONObject obj = JSONWriter.newJSONObject();
                Source.ResponseBody srcrb = (Source.ResponseBody)body;
                JSONWriter.storeIf(srcrb.getSource(), obj, "source");
                obj.put((Object)"fromLine", (Object)srcrb.getFromLine());
                obj.put((Object)"toLine", (Object)srcrb.getToLine());
                obj.put((Object)"fromPosition", (Object)srcrb.getFromPosition());
                obj.put((Object)"toPosition", (Object)srcrb.getToPosition());
                obj.put((Object)"totalLines", (Object)srcrb.getTotalLines());
                return obj;
            }
            case Threads: {
                JSONObject obj = JSONWriter.newJSONObject();
                Threads.ResponseBody trb = (Threads.ResponseBody)body;
                obj.put((Object)"totalThreads", (Object)trb.getNumThreads());
                obj.put((Object)"threads", (Object)JSONWriter.storeThreads(trb.getIds()));
                return obj;
            }
            case Gc: {
                JSONObject obj = JSONWriter.newJSONObject();
                GC.ResponseBody gcrb = (GC.ResponseBody)body;
                obj.put((Object)"before", (Object)gcrb.getBefore());
                obj.put((Object)"after", (Object)gcrb.getAfter());
                return obj;
            }
            case Version: {
                JSONObject obj = JSONWriter.newJSONObject();
                Version.ResponseBody vrb = (Version.ResponseBody)body;
                obj.put((Object)"V8Version", (Object)vrb.getVersion());
                return obj;
            }
            case Flags: {
                JSONObject obj = JSONWriter.newJSONObject();
                Flags.ResponseBody flrb = (Flags.ResponseBody)body;
                obj.put((Object)"flags", (Object)JSONWriter.storeFlags(flrb.getFlags()));
                return obj;
            }
        }
        return null;
    }

    private static Object getLongOrNull(PropertyLong pl) {
        if (pl.hasValue()) {
            return pl.getValue();
        }
        return null;
    }

    private static JSONArray store(ReferencedValue[] rvs) {
        JSONArray array = new JSONArray();
        for (ReferencedValue rv : rvs) {
            array.add((Object)JSONWriter.store(rv, false, false));
        }
        return array;
    }

    private static JSONObject store(ReferencedValue rv, boolean storeRefNotHandle, boolean noTextAndLength) {
        JSONObject obj = JSONWriter.newJSONObject();
        if (rv.hasValue()) {
            if (storeRefNotHandle) {
                obj.put((Object)"ref", (Object)rv.getReference());
                JSONWriter.store(rv.getValue(), obj, false, noTextAndLength);
            } else {
                JSONWriter.store(rv.getValue(), obj, true, noTextAndLength);
            }
        } else {
            obj.put((Object)"ref", (Object)rv.getReference());
        }
        return obj;
    }

    private static JSONArray store(V8Script[] scripts) {
        JSONArray array = new JSONArray();
        for (V8Script scr : scripts) {
            array.add((Object)JSONWriter.store(scr));
        }
        return array;
    }

    private static JSONObject store(V8Script script) {
        return JSONWriter.store(script, true);
    }

    private static JSONObject store(V8Script script, boolean storeHandle) {
        JSONObject obj = JSONWriter.newJSONObject();
        JSONWriter.storeTo(script, obj, storeHandle);
        return obj;
    }

    private static void storeTo(V8Script script, JSONObject obj, boolean storeHandle) {
        V8Script.CompilationType compilationType;
        if (storeHandle) {
            obj.put((Object)"handle", (Object)script.getHandle());
            obj.put((Object)"type", (Object)script.getType().toString());
        }
        if (storeHandle) {
            if (script.getName() != null) {
                obj.put((Object)"name", (Object)script.getName());
            }
            obj.put((Object)"id", (Object)script.getId());
        } else {
            obj.put((Object)"id", (Object)script.getId());
            if (script.getName() != null) {
                obj.put((Object)"name", (Object)script.getName());
            }
        }
        obj.put((Object)"lineOffset", (Object)script.getLineOffset());
        obj.put((Object)"columnOffset", (Object)script.getColumnOffset());
        obj.put((Object)"lineCount", (Object)script.getLineCount());
        if (script.getData() != null) {
            obj.put((Object)"data", script.getData());
        }
        JSONWriter.storeIf(script.getSource(), obj, "source");
        JSONWriter.storeIf(script.getSourceStart(), obj, "sourceStart");
        JSONWriter.storeIf(script.getSourceLength(), obj, "sourceLength");
        V8Script.Type scriptType = script.getScriptType();
        if (scriptType != null) {
            obj.put((Object)"scriptType", (Object)scriptType.ordinal());
        }
        if ((compilationType = script.getCompilationType()) != null) {
            obj.put((Object)"compilationType", (Object)compilationType.ordinal());
        }
        JSONWriter.storeIf(script.getContext(), obj, "context");
        if (script.getText() != null) {
            obj.put((Object)"text", (Object)script.getText());
        }
        JSONWriter.storeIf(script.getEvalFromScript(), obj, "evalFromScript");
        if (V8Script.CompilationType.EVAL.equals((Object)compilationType) && script.getEvalFromLocation() != null) {
            obj.put((Object)"line", (Object)script.getEvalFromLocation().getLine());
            obj.put((Object)"column", (Object)script.getEvalFromLocation().getColumn());
        }
    }

    private static JSONObject store(V8ScriptLocation scriptLocation) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"id", (Object)scriptLocation.getId());
        obj.put((Object)"name", (Object)scriptLocation.getName());
        obj.put((Object)"lineOffset", (Object)scriptLocation.getLine());
        obj.put((Object)"columnOffset", (Object)scriptLocation.getColumn());
        obj.put((Object)"lineCount", (Object)scriptLocation.getLineCount());
        return obj;
    }

    private static JSONArray store(V8Breakpoint[] breakpoints) {
        JSONArray array = new JSONArray();
        for (V8Breakpoint bp : breakpoints) {
            array.add((Object)JSONWriter.store(bp));
        }
        return array;
    }

    private static JSONObject store(V8Breakpoint bp) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"number", (Object)bp.getNumber());
        JSONWriter.storeIf(bp.getLine(), obj, "line");
        obj.put((Object)"column", JSONWriter.getLongOrNull(bp.getColumn()));
        PropertyLong groupId = bp.getGroupId();
        obj.put((Object)"groupId", JSONWriter.getLongOrNull(groupId));
        if (bp.getHitCount() != 0L) {
            obj.put((Object)"hit_count", (Object)bp.getHitCount());
        }
        obj.put((Object)"active", (Object)bp.isActive());
        obj.put((Object)"condition", (Object)bp.getCondition());
        if (bp.getIgnoreCount() != 0L) {
            obj.put((Object)"ignoreCount", (Object)bp.getIgnoreCount());
        }
        obj.put((Object)"actual_locations", (Object)JSONWriter.store(bp.getActualLocations()));
        obj.put((Object)"type", (Object)bp.getType().toString());
        JSONWriter.storeIf(bp.getScriptId(), obj, "script_id");
        JSONWriter.storeIf(bp.getScriptName(), obj, "script_name");
        return obj;
    }

    private static JSONArray store(V8Breakpoint.ActualLocation[] actualLocations) {
        JSONArray array = new JSONArray();
        if (actualLocations != null) {
            for (V8Breakpoint.ActualLocation al : actualLocations) {
                JSONObject obj = JSONWriter.newJSONObject();
                obj.put((Object)"line", (Object)al.getLine());
                obj.put((Object)"column", (Object)al.getColumn());
                JSONWriter.storeIf(al.getScriptId(), obj, "script_id");
                JSONWriter.storeIf(al.getScriptName(), obj, "script_name");
                array.add((Object)obj);
            }
        }
        return array;
    }

    private static JSONArray store(V8Frame[] frames) {
        JSONArray array = new JSONArray();
        for (V8Frame frame : frames) {
            array.add((Object)JSONWriter.store(frame));
        }
        return array;
    }

    private static JSONObject store(V8Frame frame) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"type", (Object)V8Value.Type.Frame.toString());
        PropertyLong index = frame.getIndex();
        obj.put((Object)"index", JSONWriter.getLongOrNull(index));
        obj.put((Object)"receiver", (Object)JSONWriter.store(frame.getReceiver(), true, false));
        obj.put((Object)"func", (Object)JSONWriter.store(frame.getFunction(), true, false));
        JSONWriter.storeReference(frame.getScriptRef(), obj, "script");
        obj.put((Object)"constructCall", (Object)frame.isConstructCall());
        obj.put((Object)"atReturn", (Object)frame.isAtReturn());
        obj.put((Object)"debuggerFrame", (Object)frame.isDebuggerFrame());
        JSONWriter.storeReferences(frame.getArgumentRefs(), obj, "arguments", true);
        JSONWriter.storeReferences(frame.getLocalRefs(), obj, "locals", true);
        obj.put((Object)"position", (Object)frame.getPosition());
        obj.put((Object)"line", (Object)frame.getLine());
        obj.put((Object)"column", (Object)frame.getColumn());
        obj.put((Object)"sourceLineText", (Object)frame.getSourceLineText());
        obj.put((Object)"scopes", (Object)JSONWriter.store(frame.getScopes()));
        obj.put((Object)"text", (Object)frame.getText());
        return obj;
    }

    private static JSONArray store(ChangeLive.ChangeLog changeLog) {
        JSONArray array = new JSONArray();
        if (changeLog != null) {
            ChangeLive.ChangeLog.PositionPatched[] patchedPositions;
            ChangeLive.ChangeLog.FunctionPatched functionPatched;
            String[] namesLinkedToOldScript;
            String[] droppedFrames;
            ChangeLive.ChangeLog.BreakpointUpdate[] breakpointsUpdate = changeLog.getBreakpointsUpdate();
            if (breakpointsUpdate != null) {
                JSONObject obj = JSONWriter.newJSONObject();
                obj.put((Object)"break_points_update", (Object)JSONWriter.store(breakpointsUpdate));
                array.add((Object)obj);
            }
            if ((droppedFrames = changeLog.getDroppedFrames()) != null) {
                JSONObject obj = JSONWriter.newJSONObject();
                obj.put((Object)"dropped_from_stack", (Object)JSONWriter.storeStringValues(droppedFrames, "name"));
                array.add((Object)obj);
            }
            if ((namesLinkedToOldScript = changeLog.getNamesLinkedToOldScript()) != null) {
                JSONObject obj = JSONWriter.newJSONObject();
                obj.put((Object)"linked_to_old_script", (Object)JSONWriter.storeStringValues(namesLinkedToOldScript, "name"));
                array.add((Object)obj);
            }
            if ((functionPatched = changeLog.getFunctionPatched()) != null) {
                JSONObject obj = JSONWriter.newJSONObject();
                obj.put((Object)"function_patched", (Object)functionPatched.getFunction());
                JSONWriter.storeIf(functionPatched.getFunctionInfoNotFound(), obj, "function_info_not_found");
                array.add((Object)obj);
            }
            if ((patchedPositions = changeLog.getPatchedPositions()) != null) {
                JSONObject obj = JSONWriter.newJSONObject();
                obj.put((Object)"position_patched", (Object)JSONWriter.store(patchedPositions));
                array.add((Object)obj);
            }
        }
        return array;
    }

    private static JSONArray store(ChangeLive.ChangeLog.BreakpointUpdate[] breakpointsUpdate) {
        JSONArray array = new JSONArray();
        for (ChangeLive.ChangeLog.BreakpointUpdate bpu : breakpointsUpdate) {
            JSONObject obj = JSONWriter.newJSONObject();
            obj.put((Object)"id", (Object)bpu.getId());
            JSONWriter.storeIf(bpu.getNewId(), obj, "new_id");
            JSONWriter.storeIf(bpu.getNewPositions(), obj, "new_positions");
            JSONWriter.storeIf(bpu.getOldPositions(), obj, "positions");
            obj.put((Object)"type", (Object)bpu.getType().toString());
            array.add((Object)obj);
        }
        return array;
    }

    private static JSONArray store(ChangeLive.ChangeLog.PositionPatched[] patchedPositions) {
        JSONArray array = new JSONArray();
        for (ChangeLive.ChangeLog.PositionPatched pp : patchedPositions) {
            JSONObject obj = JSONWriter.newJSONObject();
            JSONWriter.storeIf(pp.getName(), obj, "name");
            JSONWriter.storeIf(pp.getInfoNotFound(), obj, "info_not_found");
            array.add((Object)obj);
        }
        return array;
    }

    private static JSONObject store(ChangeLive.Result result) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"change_tree", (Object)JSONWriter.store(result.getChangeTree()));
        obj.put((Object)"textual_diff", (Object)JSONWriter.store(result.getDiff()));
        obj.put((Object)"updated", (Object)result.isUpdated());
        JSONWriter.storeIf(result.getStackModified(), obj, "stack_modified");
        JSONWriter.storeIf(result.getStackUpdateNeedsStepIn(), obj, "stack_update_needs_step_in");
        JSONWriter.storeIf(result.getCreatedScriptName(), obj, "created_script_name");
        return obj;
    }

    private static JSONObject store(ChangeLive.Result.ChangeTree changeTree) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"name", (Object)changeTree.getName());
        JSONWriter.storeIf(changeTree.getPositions(), obj, "positions");
        if (changeTree.getStatus() != null) {
            obj.put((Object)"status", (Object)changeTree.getStatus().toString());
        }
        obj.put((Object)"children", (Object)JSONWriter.store(changeTree.getChildren()));
        if (changeTree.getNewChildren() != null) {
            obj.put((Object)"new_children", (Object)JSONWriter.store(changeTree.getNewChildren()));
        }
        JSONWriter.storeIf(changeTree.getStatusExplanation(), obj, "status_explanation");
        JSONWriter.storeIf(changeTree.getNewPositions(), obj, "new_positions");
        return obj;
    }

    private static JSONObject store(ChangeLive.Result.TextualDiff diff) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"old_len", (Object)diff.getOldLength());
        obj.put((Object)"new_len", (Object)diff.getNewLength());
        obj.put((Object)"chunks", (Object)JSONWriter.array(diff.getChunks()));
        return obj;
    }

    private static void storeIf(ChangeLive.ChangeLog.BreakpointUpdate.Position position, JSONObject obj, String propName) {
        if (position != null) {
            JSONObject pos = JSONWriter.newJSONObject();
            pos.put((Object)"position", (Object)position.getPosition());
            pos.put((Object)"line", (Object)position.getLine());
            pos.put((Object)"column", (Object)position.getColumn());
            obj.put((Object)propName, (Object)pos);
        }
    }

    private static JSONArray store(ChangeLive.Result.ChangeTree[] children) {
        JSONArray array = new JSONArray();
        if (children != null) {
            for (ChangeLive.Result.ChangeTree ct : children) {
                array.add((Object)JSONWriter.store(ct));
            }
        }
        return array;
    }

    private static void storeIf(ChangeLive.Result.ChangeTree.Positions positions, JSONObject obj, String propName) {
        if (positions != null) {
            JSONObject pos = JSONWriter.newJSONObject();
            pos.put((Object)"start_position", (Object)positions.getStartPosition());
            pos.put((Object)"end_position", (Object)positions.getEndPosition());
            obj.put((Object)propName, (Object)pos);
        }
    }

    private static JSONObject storeValues(Map<Long, V8Value> values) {
        JSONObject obj = JSONWriter.newJSONObject();
        for (V8Value vv : values.values()) {
            obj.put((Object)Long.toString(vv.getHandle()), (Object)JSONWriter.store(vv));
        }
        return obj;
    }

    private static JSONArray store(V8Scope[] scopes) {
        JSONArray array = new JSONArray();
        for (V8Scope scope : scopes) {
            array.add((Object)JSONWriter.store(scope));
        }
        return array;
    }

    private static JSONObject store(V8Scope scope) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"type", (Object)scope.getType().ordinal());
        obj.put((Object)"index", (Object)scope.getIndex());
        JSONWriter.storeIf(scope.getFrameIndex(), obj, "frameIndex");
        if (scope.getObject() != null) {
            obj.put((Object)"object", (Object)JSONWriter.store(scope.getObject(), false, true));
        }
        JSONWriter.storeIf(scope.getText(), obj, "text");
        return obj;
    }

    private static JSONArray storeThreads(Map<Long, Boolean> threads) {
        JSONArray array = new JSONArray();
        for (Map.Entry<Long, Boolean> thread : threads.entrySet()) {
            JSONObject obj = JSONWriter.newJSONObject();
            obj.put((Object)"current", (Object)thread.getValue());
            obj.put((Object)"id", (Object)thread.getKey());
            array.add((Object)obj);
        }
        return array;
    }

    private static JSONArray storeFlags(Map<String, Boolean> flags) {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, Boolean> flag : flags.entrySet()) {
            JSONObject obj = JSONWriter.newJSONObject();
            obj.put((Object)"name", (Object)flag.getKey());
            obj.put((Object)"value", (Object)flag.getValue());
            array.add((Object)obj);
        }
        return array;
    }

    private static JSONObject store(Map<String, Object> map) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.putAll(map);
        return obj;
    }

    private static JSONArray array(long[] array) {
        JSONArray jsArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            jsArray.add((Object)array[i]);
        }
        return jsArray;
    }

    private static JSONArray storeStringValues(String[] ss, String propName) {
        JSONArray array = new JSONArray();
        for (String s : ss) {
            JSONObject obj = JSONWriter.newJSONObject();
            obj.put((Object)"name", (Object)s);
            array.add((Object)obj);
        }
        return array;
    }

    private static void storeIf(PropertyBoolean prop, JSONObject obj, String propertyName) {
        if (prop.hasValue()) {
            obj.put((Object)propertyName, (Object)prop.getValue());
        }
    }

    private static void storeIf(PropertyLong prop, JSONObject obj, String propertyName) {
        if (prop.hasValue()) {
            obj.put((Object)propertyName, (Object)prop.getValue());
        }
    }

    private static void storeIf(String prop, JSONObject obj, String propertyName) {
        if (prop != null) {
            obj.put((Object)propertyName, (Object)prop);
        }
    }

    private static void storeIf(ReferencedValue rv, JSONObject obj, String propertyName) {
        if (rv == null) {
            return;
        }
        JSONObject ref = JSONWriter.newJSONObject();
        ref.put((Object)"ref", (Object)rv.getReference());
        if (rv.hasValue()) {
            JSONWriter.store(rv.getValue(), ref, false, false);
        }
        obj.put((Object)propertyName, (Object)ref);
    }

    private static JSONArray store(Evaluate.Arguments.Context[] contexts) {
        if (contexts == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        for (Evaluate.Arguments.Context c : contexts) {
            array.add((Object)JSONWriter.store(c));
        }
        return array;
    }

    private static JSONObject store(Evaluate.Arguments.Context context) {
        JSONObject obj = JSONWriter.newJSONObject();
        obj.put((Object)"name", (Object)context.getName());
        obj.put((Object)"handle", (Object)context.getHandle());
        return obj;
    }

    private static JSONObject store(NewValue value) {
        JSONObject obj = JSONWriter.newJSONObject();
        if (value.getHandle().hasValue()) {
            obj.put((Object)"handle", (Object)value.getHandle().getValue());
        } else {
            obj.put((Object)"type", (Object)value.getType().toString());
            JSONWriter.storeIf(value.getDescription(), obj, "stringDescription");
        }
        return obj;
    }

    private static JSONObject store(V8Value value) {
        JSONObject obj = JSONWriter.newJSONObject();
        JSONWriter.store(value, obj, true, false);
        return obj;
    }

    private static void store(V8Value value, JSONObject obj, boolean storeHandle, boolean noTextAndLength) {
        if (storeHandle) {
            obj.put((Object)"handle", (Object)value.getHandle());
        }
        V8Value.Type type = value.getType();
        obj.put((Object)"type", (Object)type.toString());
        block0 : switch (type) {
            case Boolean: {
                V8Boolean vb = (V8Boolean)value;
                obj.put((Object)"value", (Object)vb.getValue());
                break;
            }
            case Number: {
                V8Number vn = (V8Number)value;
                V8Number.Kind kind = vn.getKind();
                switch (kind) {
                    case Double: {
                        double dv = vn.getDoubleValue();
                        if (dv == Double.POSITIVE_INFINITY) {
                            obj.put((Object)"value", (Object)"Infinity");
                            break block0;
                        }
                        if (dv == Double.NEGATIVE_INFINITY) {
                            obj.put((Object)"value", (Object)"-Infinity");
                            break block0;
                        }
                        if (Double.isNaN(dv)) {
                            obj.put((Object)"value", (Object)"NaN");
                            break block0;
                        }
                        obj.put((Object)"value", (Object)dv);
                        break block0;
                    }
                    case Long: {
                        obj.put((Object)"value", (Object)vn.getLongValue());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unhandled number kind: " + (Object)((Object)kind));
            }
            case String: {
                V8String vs = (V8String)value;
                String vss = vs.getValue();
                obj.put((Object)"value", (Object)vss);
                if (noTextAndLength) break;
                obj.put((Object)"length", (Object)vss.length());
                break;
            }
            case Function: {
                V8Function vf = (V8Function)value;
                if (vf.isResolved().hasValue()) {
                    obj.put((Object)"className", (Object)vf.getClassName());
                }
                JSONWriter.storeReferenceIf(vf.getConstructorFunctionHandle(), obj, "constructorFunction");
                JSONWriter.storeReferenceIf(vf.getProtoObjectHandle(), obj, "protoObject");
                JSONWriter.storeReferenceIf(vf.getPrototypeObjectHandle(), obj, "prototypeObject");
                JSONWriter.storeIf(vf.getName(), obj, "name");
                JSONWriter.storeIf(vf.getInferredName(), obj, "inferredName");
                JSONWriter.storeIf(vf.isResolved(), obj, "resolved");
                JSONWriter.storeIf(vf.getSource(), obj, "source");
                JSONWriter.storeReferenceIf(vf.getScriptRef(), obj, "script");
                JSONWriter.storeIf(vf.getScriptId(), obj, "scriptId");
                JSONWriter.storeIf(vf.getPosition(), obj, "position");
                JSONWriter.storeIf(vf.getLine(), obj, "line");
                JSONWriter.storeIf(vf.getColumn(), obj, "column");
                V8Scope[] scopes = vf.getScopes();
                if (scopes != null) {
                    obj.put((Object)"scopes", (Object)JSONWriter.store(scopes));
                }
                if (vf.getProperties() == null && (vf.getArray() == null || vf.getArray().getLength() <= 0L)) break;
                obj.put((Object)"properties", (Object)JSONWriter.storeProperties(vf.getProperties(), vf.getArray()));
                break;
            }
            case Generator: {
                V8Generator gf = (V8Generator)value;
                obj.put((Object)"className", (Object)gf.getClassName());
                JSONWriter.storeReferenceIf(gf.getConstructorFunctionHandle(), obj, "constructorFunction");
                JSONWriter.storeReferenceIf(gf.getProtoObjectHandle(), obj, "protoObject");
                JSONWriter.storeReferenceIf(gf.getPrototypeObjectHandle(), obj, "prototypeObject");
                JSONWriter.storeReferenceIf(gf.getFunctionHandle(), obj, "func");
                JSONWriter.storeReferenceIf(gf.getReceiverHandle(), obj, "receiver");
                if (gf.getProperties() == null) break;
                obj.put((Object)"properties", (Object)JSONWriter.storeProperties(gf.getProperties(), null));
                break;
            }
            case Object: 
            case Error: 
            case Regexp: {
                V8Object vo = (V8Object)value;
                obj.put((Object)"className", (Object)vo.getClassName());
                JSONWriter.storeReferenceIf(vo.getConstructorFunctionHandle(), obj, "constructorFunction");
                JSONWriter.storeReferenceIf(vo.getProtoObjectHandle(), obj, "protoObject");
                JSONWriter.storeReferenceIf(vo.getPrototypeObjectHandle(), obj, "prototypeObject");
                if (vo.getProperties() == null && (vo.getArray() == null || vo.getArray().getLength() <= 0L)) break;
                obj.put((Object)"properties", (Object)JSONWriter.storeProperties(vo.getProperties(), vo.getArray()));
                break;
            }
            case Frame: {
                break;
            }
            case Script: {
                V8ScriptValue vsv = (V8ScriptValue)value;
                JSONWriter.storeTo(vsv.getScript(), obj, true);
                break;
            }
            case Null: {
                if (!noTextAndLength) break;
                obj.put((Object)"value", null);
            }
        }
        if (value.getText() != null && !noTextAndLength) {
            obj.put((Object)"text", (Object)value.getText());
        }
    }

    private static void storeReferenceIf(PropertyLong ref, JSONObject obj, String propertyName) {
        if (ref.hasValue()) {
            JSONWriter.storeReference(ref.getValue(), obj, propertyName);
        }
    }

    private static void storeReference(long ref, JSONObject obj, String propertyName) {
        JSONObject refObj = JSONWriter.newJSONObject();
        refObj.put((Object)"ref", (Object)ref);
        obj.put((Object)propertyName, (Object)refObj);
    }

    private static void storeReferences(Map<String, ReferencedValue> rvals, JSONObject obj, String propertyName, boolean storeRefNotHandle) {
        if (rvals == null) {
            return;
        }
        JSONArray array = new JSONArray();
        for (Map.Entry<String, ReferencedValue> rval : rvals.entrySet()) {
            JSONObject elm = JSONWriter.newJSONObject();
            if (rval.getKey() != null) {
                elm.put((Object)"name", (Object)rval.getKey());
            }
            elm.put((Object)"value", (Object)JSONWriter.store(rval.getValue(), storeRefNotHandle, true));
            array.add((Object)elm);
        }
        obj.put((Object)propertyName, (Object)array);
    }

    private static JSONArray storeProperties(Map<String, V8Object.Property> properties, V8Object.Array array) {
        JSONArray arrObj = new JSONArray();
        if (properties != null) {
            for (Map.Entry<String, V8Object.Property> entry : properties.entrySet()) {
                V8Object.Property.Type type;
                String propName = entry.getKey();
                V8Object.Property prop = entry.getValue();
                JSONObject propObj = JSONWriter.newJSONObject();
                propObj.put((Object)"name", (Object)propName);
                if (prop.getAttributes() != 0) {
                    propObj.put((Object)"attributes", (Object)prop.getAttributes());
                }
                if ((type = prop.getType()) != null) {
                    propObj.put((Object)"propertyType", (Object)type.ordinal());
                } else {
                    propObj.put((Object)"propertyType", (Object)0);
                }
                propObj.put((Object)"ref", (Object)prop.getReference());
                arrObj.add((Object)propObj);
            }
        }
        if (array != null) {
            V8Object.IndexIterator indexIterator = array.getIndexIterator();
            while (indexIterator.hasNextIndex()) {
                JSONObject arrElm = JSONWriter.newJSONObject();
                long index = indexIterator.nextIndex();
                arrElm.put((Object)"name", (Object)index);
                arrElm.put((Object)"propertyType", (Object)0);
                arrElm.put((Object)"ref", (Object)array.getReferenceAt(index));
                arrObj.add((Object)arrElm);
            }
        }
        return arrObj;
    }
}

