/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minidev.json.JSONArray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;
import org.opensearch.ml.engine.processor.ProcessorChain;

@Processor(value=MLProcessorType.CONDITIONAL)
public class MLConditionalProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLConditionalProcessor.class);
    private final String path;
    private final List<Map.Entry<String, List<MLProcessor>>> conditionalProcessors;
    private final List<MLProcessor> defaultProcessors;

    public MLConditionalProcessor(Map<String, Object> config) {
        super(config);
        this.path = (String)config.get("path");
        Object routesObj = config.get("routes");
        if (routesObj == null) {
            throw new IllegalArgumentException("'routes' is required for conditional processor");
        }
        List routesList = (List)routesObj;
        this.conditionalProcessors = new ArrayList<Map.Entry<String, List<MLProcessor>>>();
        for (Object routeObj : routesList) {
            if (!(routeObj instanceof Map)) continue;
            Map routeMap = (Map)routeObj;
            for (Map.Entry routeEntry : routeMap.entrySet()) {
                List<MLProcessor> processors = ProcessorChain.parseProcessorConfigs(routeEntry.getValue());
                this.conditionalProcessors.add(new AbstractMap.SimpleEntry<String, List<MLProcessor>>((String)routeEntry.getKey(), processors));
            }
        }
        if (this.conditionalProcessors.isEmpty()) {
            throw new IllegalArgumentException("'routes' must contain at least one route for conditional processor");
        }
        this.defaultProcessors = config.containsKey("default") ? ProcessorChain.parseProcessorConfigs(config.get("default")) : Collections.emptyList();
    }

    @Override
    protected void validateConfig() {
        if (!this.config.containsKey("routes")) {
            throw new IllegalArgumentException("'routes' is required for conditional processor");
        }
    }

    @Override
    public Object process(Object input) {
        Object valueToCheck = input;
        if (this.path != null && !this.path.isEmpty()) {
            try {
                String jsonStr = StringUtils.toJson((Object)input);
                try {
                    valueToCheck = JsonPath.read((String)jsonStr, (String)this.path, (Predicate[])new Predicate[0]);
                }
                catch (PathNotFoundException e) {
                    valueToCheck = null;
                }
            }
            catch (Exception e) {
                log.warn("Error evaluating path {}: {}", (Object)this.path, (Object)e.getMessage());
            }
        }
        for (Map.Entry<String, List<MLProcessor>> entry : this.conditionalProcessors) {
            String condition = entry.getKey();
            if (!this.matchesCondition(condition, valueToCheck)) continue;
            return ProcessorChain.applyProcessors(input, entry.getValue());
        }
        return ProcessorChain.applyProcessors(input, this.defaultProcessors);
    }

    private boolean matchesCondition(String condition, Object value) {
        if (value == null) {
            return "null".equals(condition) || "not_exists".equals(condition);
        }
        if (value instanceof JSONArray && ((JSONArray)value).isEmpty()) {
            return "null".equals(condition) || "not_exists".equals(condition);
        }
        if ("exists".equals(condition)) {
            return true;
        }
        String strValue = value.toString();
        if (condition.equals(strValue)) {
            return true;
        }
        if (value instanceof Number || this.canParseAsNumber(strValue)) {
            try {
                double numValue;
                double d = numValue = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(strValue);
                if (condition.startsWith(">=")) {
                    return numValue >= Double.parseDouble(condition.substring(2));
                }
                if (condition.startsWith("<=")) {
                    return numValue <= Double.parseDouble(condition.substring(2));
                }
                if (condition.startsWith(">")) {
                    return numValue > Double.parseDouble(condition.substring(1));
                }
                if (condition.startsWith("<")) {
                    return numValue < Double.parseDouble(condition.substring(1));
                }
                if (condition.startsWith("==")) {
                    return Math.abs(numValue - Double.parseDouble(condition.substring(2))) < 1.0E-10;
                }
            }
            catch (NumberFormatException e) {
                log.debug("Invalid numeric condition '{}': {}", (Object)condition, (Object)e.getMessage());
                return false;
            }
        }
        if (condition.startsWith("regex:")) {
            try {
                return Pattern.matches(condition.substring(6), strValue);
            }
            catch (Exception e) {
                log.debug("Invalid regex pattern '{}': {}", (Object)condition, (Object)e.getMessage());
                return false;
            }
        }
        if (condition.startsWith("contains:")) {
            return strValue.contains(condition.substring(9));
        }
        return false;
    }

    private boolean canParseAsNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

