/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.search.join.ScoreMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u0005J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/opensearch/notifications/index/ConfigQueryHelper;", "", "()V", "ALL_FIELDS", "", "", "BOOLEAN_FIELDS", "CONFIG_FIELDS", "FILTER_PARAMS", "getFILTER_PARAMS", "()Ljava/util/Set;", "KEYWORD_FIELDS", "KEYWORD_SUFFIX", "KEY_PREFIX", "METADATA_FIELDS", "METADATA_RANGE_FIELDS", "NESTED_FIELDS", "NESTED_KEYWORD_FIELDS", "NESTED_PATHS", "", "NESTED_TEXT_FIELDS", "TEXT_FIELDS", "addQueryFilters", "", "query", "Lorg/opensearch/index/query/BoolQueryBuilder;", "filterParams", "", "getMatchQueryBuilder", "Lorg/opensearch/index/query/QueryBuilder;", "queryKey", "queryValue", "getNestedMatchQueryBuilder", "getQueryAllBuilder", "getRangeQueryBuilder", "getSortField", "sortField", "getTermQueryBuilder", "getTermsQueryBuilder", "getTextQueryAllBuilder", "opensearch-notifications"})
@SourceDebugExtension(value={"SMAP\nConfigQueryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigQueryHelper.kt\norg/opensearch/notifications/index/ConfigQueryHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n215#2,2:224\n1855#3,2:226\n1855#3:228\n766#3:229\n857#3,2:230\n1855#3,2:232\n1856#3:234\n1855#3,2:235\n1855#3:237\n766#3:238\n857#3,2:239\n1855#3,2:241\n1856#3:243\n223#3,2:244\n*S KotlinDebug\n*F\n+ 1 ConfigQueryHelper.kt\norg/opensearch/notifications/index/ConfigQueryHelper\n*L\n128#1:224,2\n146#1:226,2\n150#1:228\n153#1:229\n153#1:230,2\n154#1:232,2\n150#1:234\n168#1:235,2\n172#1:237\n175#1:238\n175#1:239,2\n176#1:241,2\n172#1:243\n219#1:244,2\n*E\n"})
public final class ConfigQueryHelper {
    @NotNull
    public static final ConfigQueryHelper INSTANCE = new ConfigQueryHelper();
    @NotNull
    private static final String KEY_PREFIX = "config";
    @NotNull
    private static final String KEYWORD_SUFFIX = "keyword";
    @NotNull
    private static final List<String> NESTED_PATHS;
    @NotNull
    private static final Set<String> METADATA_RANGE_FIELDS;
    @NotNull
    private static final Set<String> BOOLEAN_FIELDS;
    @NotNull
    private static final Set<String> KEYWORD_FIELDS;
    @NotNull
    private static final Set<String> TEXT_FIELDS;
    @NotNull
    private static final Set<String> NESTED_KEYWORD_FIELDS;
    @NotNull
    private static final Set<String> NESTED_TEXT_FIELDS;
    @NotNull
    private static final Set<String> METADATA_FIELDS;
    @NotNull
    private static final Set<String> CONFIG_FIELDS;
    @NotNull
    private static final Set<String> NESTED_FIELDS;
    @NotNull
    private static final Set<String> ALL_FIELDS;
    @NotNull
    private static final Set<String> FILTER_PARAMS;

    private ConfigQueryHelper() {
    }

    @NotNull
    public final Set<String> getFILTER_PARAMS() {
        return FILTER_PARAMS;
    }

    @NotNull
    public final String getSortField(@Nullable String sortField) {
        Object object;
        if (sortField == null) {
            object = "metadata.last_updated_time_ms";
        } else if (METADATA_RANGE_FIELDS.contains(sortField)) {
            object = "metadata." + sortField;
        } else if (BOOLEAN_FIELDS.contains(sortField)) {
            object = "config." + sortField;
        } else if (KEYWORD_FIELDS.contains(sortField)) {
            object = "config." + sortField;
        } else if (TEXT_FIELDS.contains(sortField)) {
            object = "config." + sortField + ".keyword";
        } else {
            throw new OpenSearchStatusException("Sort on " + sortField + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        }
        return object;
    }

    public final void addQueryFilters(@NotNull BoolQueryBuilder query, @NotNull Map<String, String> filterParams) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(filterParams, (String)"filterParams");
        Map<String, String> $this$forEach$iv = filterParams;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            if (Intrinsics.areEqual((Object)"query", (Object)it.getKey())) {
                query.filter(INSTANCE.getQueryAllBuilder(it.getValue()));
                continue;
            }
            if (Intrinsics.areEqual((Object)"text_query", (Object)it.getKey())) {
                query.filter(INSTANCE.getTextQueryAllBuilder(it.getValue()));
                continue;
            }
            if (METADATA_RANGE_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getRangeQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (BOOLEAN_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getTermQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (KEYWORD_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getTermsQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (TEXT_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getMatchQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (NESTED_TEXT_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getNestedMatchQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            throw new OpenSearchStatusException("Query on " + it.getKey() + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final QueryBuilder getQueryAllBuilder(String queryValue) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        Iterable $this$forEach$iv = CONFIG_FIELDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            allQuery.field("config." + it);
        }
        boolQuery.should((QueryBuilder)allQuery);
        $this$forEach$iv = NESTED_PATHS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            String path = (String)element$iv;
            boolean bl = false;
            ConfigQueryHelper $this$getQueryAllBuilder_u24lambda_u245_u24lambda_u244 = INSTANCE;
            boolean bl2 = false;
            QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
            Iterable $this$filter$iv = NESTED_FIELDS;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)it, (String)path, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fields = (List)destination$iv$iv;
            Iterable $this$forEach$iv2 = fields;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl4 = false;
                allNestedQuery.field("config." + it);
            }
            NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)("config." + path), (QueryBuilder)((QueryBuilder)allNestedQuery), (ScoreMode)ScoreMode.None);
            boolQuery.should((QueryBuilder)nestedFieldQuery);
        }
        Intrinsics.checkNotNull((Object)boolQuery);
        return (QueryBuilder)boolQuery;
    }

    /*
     * WARNING - void declaration
     */
    private final QueryBuilder getTextQueryAllBuilder(String queryValue) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        Iterable $this$forEach$iv = TEXT_FIELDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            allQuery.field("config." + it);
        }
        boolQuery.should((QueryBuilder)allQuery);
        $this$forEach$iv = NESTED_PATHS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            String path = (String)element$iv;
            boolean bl = false;
            ConfigQueryHelper $this$getTextQueryAllBuilder_u24lambda_u2410_u24lambda_u249 = INSTANCE;
            boolean bl2 = false;
            QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
            Iterable $this$filter$iv = NESTED_TEXT_FIELDS;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)it, (String)path, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fields = (List)destination$iv$iv;
            Iterable $this$forEach$iv2 = fields;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl4 = false;
                allNestedQuery.field("config." + it);
            }
            NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)("config." + path), (QueryBuilder)((QueryBuilder)allNestedQuery), (ScoreMode)ScoreMode.None);
            boolQuery.should((QueryBuilder)nestedFieldQuery);
        }
        Intrinsics.checkNotNull((Object)boolQuery);
        return (QueryBuilder)boolQuery;
    }

    private final QueryBuilder getRangeQueryBuilder(String queryKey, String queryValue) {
        String[] stringArray = new String[]{".."};
        List range = StringsKt.split$default((CharSequence)queryValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return switch (range.size()) {
            case 1 -> {
                TermQueryBuilder v0 = QueryBuilders.termQuery((String)("metadata." + queryKey), (String)queryValue);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"termQuery(...)");
                yield (QueryBuilder)v0;
            }
            case 2 -> {
                RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)("metadata." + queryKey));
                rangeQuery.from(range.get(0));
                rangeQuery.to(range.get(1));
                RangeQueryBuilder var5_6 = rangeQuery;
                Intrinsics.checkNotNull((Object)var5_6);
                yield (QueryBuilder)var5_6;
            }
            default -> throw new OpenSearchStatusException("Invalid Range format " + queryValue + ", allowed format 'exact' or 'from..to'", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        };
    }

    private final QueryBuilder getTermQueryBuilder(String queryKey, String queryValue) {
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)("config." + queryKey), (String)queryValue);
        Intrinsics.checkNotNullExpressionValue((Object)termQueryBuilder, (String)"termQuery(...)");
        return (QueryBuilder)termQueryBuilder;
    }

    private final QueryBuilder getTermsQueryBuilder(String queryKey, String queryValue) {
        String[] stringArray = new String[]{","};
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)("config." + queryKey), (Collection)StringsKt.split$default((CharSequence)queryValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)termsQueryBuilder, (String)"termsQuery(...)");
        return (QueryBuilder)termsQueryBuilder;
    }

    private final QueryBuilder getMatchQueryBuilder(String queryKey, String queryValue) {
        MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)("config." + queryKey), (Object)queryValue);
        Intrinsics.checkNotNullExpressionValue((Object)matchQueryBuilder, (String)"matchQuery(...)");
        return (QueryBuilder)matchQueryBuilder;
    }

    private final QueryBuilder getNestedMatchQueryBuilder(String queryKey, String queryValue) {
        Object element$iv2;
        MatchQueryBuilder query;
        block1: {
            query = QueryBuilders.matchQuery((String)("config." + queryKey), (Object)queryValue);
            Iterable $this$first$iv = NESTED_PATHS;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)queryKey, (String)it, (boolean)false, (int)2, null)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String nestedPath = (String)element$iv2;
        NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery((String)("config." + nestedPath), (QueryBuilder)((QueryBuilder)query), (ScoreMode)ScoreMode.None);
        Intrinsics.checkNotNullExpressionValue((Object)nestedQueryBuilder, (String)"nestedQuery(...)");
        return (QueryBuilder)nestedQueryBuilder;
    }

    static {
        Object[] objectArray = new String[]{ConfigType.EMAIL.getTag() + ".recipient_list", ConfigType.EMAIL_GROUP.getTag() + ".recipient_list"};
        NESTED_PATHS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"last_updated_time_ms", "created_time_ms"};
        METADATA_RANGE_FIELDS = SetsKt.setOf((Object[])objectArray);
        BOOLEAN_FIELDS = SetsKt.setOf((Object)"is_enabled");
        objectArray = new String[]{"config_type", ConfigType.EMAIL.getTag() + ".email_account_id", ConfigType.EMAIL.getTag() + ".email_group_id_list", ConfigType.SMTP_ACCOUNT.getTag() + ".method", ConfigType.SES_ACCOUNT.getTag() + ".region", "name.keyword", "description.keyword", ConfigType.SLACK.getTag() + ".url.keyword", ConfigType.CHIME.getTag() + ".url.keyword", ConfigType.MICROSOFT_TEAMS.getTag() + ".url.keyword", ConfigType.WEBHOOK.getTag() + ".url.keyword", ConfigType.SMTP_ACCOUNT.getTag() + ".host.keyword", ConfigType.SMTP_ACCOUNT.getTag() + ".from_address.keyword", ConfigType.SNS.getTag() + ".topic_arn.keyword", ConfigType.SNS.getTag() + ".role_arn.keyword", ConfigType.SES_ACCOUNT.getTag() + ".role_arn.keyword", ConfigType.SES_ACCOUNT.getTag() + ".from_address.keyword"};
        KEYWORD_FIELDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"name", "description", ConfigType.SLACK.getTag() + ".url", ConfigType.CHIME.getTag() + ".url", ConfigType.MICROSOFT_TEAMS.getTag() + ".url", ConfigType.WEBHOOK.getTag() + ".url", ConfigType.SMTP_ACCOUNT.getTag() + ".host", ConfigType.SMTP_ACCOUNT.getTag() + ".from_address", ConfigType.SNS.getTag() + ".topic_arn", ConfigType.SNS.getTag() + ".role_arn", ConfigType.SES_ACCOUNT.getTag() + ".role_arn", ConfigType.SES_ACCOUNT.getTag() + ".from_address"};
        TEXT_FIELDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{ConfigType.EMAIL.getTag() + ".recipient_list.recipient.keyword", ConfigType.EMAIL_GROUP.getTag() + ".recipient_list.recipient.keyword"};
        NESTED_KEYWORD_FIELDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{ConfigType.EMAIL.getTag() + ".recipient_list.recipient", ConfigType.EMAIL_GROUP.getTag() + ".recipient_list.recipient"};
        NESTED_TEXT_FIELDS = SetsKt.setOf((Object[])objectArray);
        METADATA_FIELDS = METADATA_RANGE_FIELDS;
        CONFIG_FIELDS = CollectionsKt.union((Iterable)KEYWORD_FIELDS, (Iterable)TEXT_FIELDS);
        NESTED_FIELDS = CollectionsKt.union((Iterable)NESTED_KEYWORD_FIELDS, (Iterable)NESTED_TEXT_FIELDS);
        ALL_FIELDS = CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)METADATA_FIELDS, (Iterable)CONFIG_FIELDS), (Iterable)BOOLEAN_FIELDS), (Iterable)NESTED_FIELDS);
        objectArray = new String[]{"query", "text_query"};
        FILTER_PARAMS = CollectionsKt.union((Iterable)ALL_FIELDS, (Iterable)SetsKt.setOf((Object[])objectArray));
    }
}

