/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.MessageTag;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.StaxUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;

public class MessageTagStaxUnmarshaller
implements Unmarshaller<MessageTag, StaxUnmarshallerContext> {
    private static MessageTagStaxUnmarshaller instance;

    @Override
    public MessageTag unmarshall(StaxUnmarshallerContext context) throws Exception {
        MessageTag messageTag = new MessageTag();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return messageTag;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    messageTag.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                messageTag.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return messageTag;
    }

    public static MessageTagStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageTagStaxUnmarshaller();
        }
        return instance;
    }
}

