/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.CoordsGeoBounds;
import org.opensearch.client.opensearch._types.TopLeftBottomRightGeoBounds;
import org.opensearch.client.opensearch._types.TopRightBottomLeftGeoBounds;
import org.opensearch.client.opensearch._types.WktGeoBounds;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class GeoBounds
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<GeoBounds> _DESERIALIZER = JsonpDeserializer.lazy(GeoBounds::buildGeoBoundsDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private GeoBounds(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private GeoBounds(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static GeoBounds of(Function<Builder, ObjectBuilder<GeoBounds>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCoords() {
        return this._kind == Kind.Coords;
    }

    public CoordsGeoBounds coords() {
        return (CoordsGeoBounds)TaggedUnionUtils.get(this, Kind.Coords);
    }

    public boolean isTlbr() {
        return this._kind == Kind.Tlbr;
    }

    public TopLeftBottomRightGeoBounds tlbr() {
        return (TopLeftBottomRightGeoBounds)TaggedUnionUtils.get(this, Kind.Tlbr);
    }

    public boolean isTrbl() {
        return this._kind == Kind.Trbl;
    }

    public TopRightBottomLeftGeoBounds trbl() {
        return (TopRightBottomLeftGeoBounds)TaggedUnionUtils.get(this, Kind.Trbl);
    }

    public boolean isWkt() {
        return this._kind == Kind.Wkt;
    }

    public WktGeoBounds wkt() {
        return (WktGeoBounds)TaggedUnionUtils.get(this, Kind.Wkt);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<GeoBounds> buildGeoBoundsDeserializer() {
        return new UnionDeserializer.Builder<GeoBounds, Kind, Object>(GeoBounds::new, false).addMember(Kind.Coords, CoordsGeoBounds._DESERIALIZER).addMember(Kind.Tlbr, TopLeftBottomRightGeoBounds._DESERIALIZER).addMember(Kind.Trbl, TopRightBottomLeftGeoBounds._DESERIALIZER).addMember(Kind.Wkt, WktGeoBounds._DESERIALIZER).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoBounds other = (GeoBounds)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoBounds> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(GeoBounds o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<GeoBounds> coords(CoordsGeoBounds v) {
            this._kind = Kind.Coords;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> coords(Function<CoordsGeoBounds.Builder, ObjectBuilder<CoordsGeoBounds>> fn) {
            return this.coords(fn.apply(new CoordsGeoBounds.Builder()).build());
        }

        public ObjectBuilder<GeoBounds> tlbr(TopLeftBottomRightGeoBounds v) {
            this._kind = Kind.Tlbr;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> tlbr(Function<TopLeftBottomRightGeoBounds.Builder, ObjectBuilder<TopLeftBottomRightGeoBounds>> fn) {
            return this.tlbr(fn.apply(new TopLeftBottomRightGeoBounds.Builder()).build());
        }

        public ObjectBuilder<GeoBounds> trbl(TopRightBottomLeftGeoBounds v) {
            this._kind = Kind.Trbl;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> trbl(Function<TopRightBottomLeftGeoBounds.Builder, ObjectBuilder<TopRightBottomLeftGeoBounds>> fn) {
            return this.trbl(fn.apply(new TopRightBottomLeftGeoBounds.Builder()).build());
        }

        public ObjectBuilder<GeoBounds> wkt(WktGeoBounds v) {
            this._kind = Kind.Wkt;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> wkt(Function<WktGeoBounds.Builder, ObjectBuilder<WktGeoBounds>> fn) {
            return this.wkt(fn.apply(new WktGeoBounds.Builder()).build());
        }

        @Override
        public GeoBounds build() {
            this._checkSingleUse();
            return new GeoBounds(this);
        }
    }

    public static enum Kind {
        Coords,
        Tlbr,
        Trbl,
        Wkt;

    }
}

