/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.IcuCollationAlternate;
import org.opensearch.client.opensearch._types.analysis.IcuCollationCaseFirst;
import org.opensearch.client.opensearch._types.analysis.IcuCollationDecomposition;
import org.opensearch.client.opensearch._types.analysis.IcuCollationStrength;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IcuCollationTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, IcuCollationTokenFilter> {
    @Nullable
    private final IcuCollationAlternate alternate;
    @Nullable
    private final IcuCollationCaseFirst caseFirst;
    @Nullable
    private final Boolean caseLevel;
    @Nullable
    private final String country;
    @Nullable
    private final IcuCollationDecomposition decomposition;
    @Nullable
    private final Boolean hiraganaQuaternaryMode;
    @Nullable
    private final String language;
    @Nullable
    private final Boolean numeric;
    @Nullable
    private final String rules;
    @Nullable
    private final IcuCollationStrength strength;
    @Nullable
    private final String variableTop;
    @Nullable
    private final String variant;
    public static final JsonpDeserializer<IcuCollationTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuCollationTokenFilter::setupIcuCollationTokenFilterDeserializer);

    private IcuCollationTokenFilter(Builder builder) {
        super(builder);
        this.alternate = builder.alternate;
        this.caseFirst = builder.caseFirst;
        this.caseLevel = builder.caseLevel;
        this.country = builder.country;
        this.decomposition = builder.decomposition;
        this.hiraganaQuaternaryMode = builder.hiraganaQuaternaryMode;
        this.language = builder.language;
        this.numeric = builder.numeric;
        this.rules = builder.rules;
        this.strength = builder.strength;
        this.variableTop = builder.variableTop;
        this.variant = builder.variant;
    }

    public static IcuCollationTokenFilter of(Function<Builder, ObjectBuilder<IcuCollationTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuCollation;
    }

    @Nullable
    public final IcuCollationAlternate alternate() {
        return this.alternate;
    }

    @Nullable
    public final IcuCollationCaseFirst caseFirst() {
        return this.caseFirst;
    }

    @Nullable
    public final Boolean caseLevel() {
        return this.caseLevel;
    }

    @Nullable
    public final String country() {
        return this.country;
    }

    @Nullable
    public final IcuCollationDecomposition decomposition() {
        return this.decomposition;
    }

    @Nullable
    public final Boolean hiraganaQuaternaryMode() {
        return this.hiraganaQuaternaryMode;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Nullable
    public final Boolean numeric() {
        return this.numeric;
    }

    @Nullable
    public final String rules() {
        return this.rules;
    }

    @Nullable
    public final IcuCollationStrength strength() {
        return this.strength;
    }

    @Nullable
    public final String variableTop() {
        return this.variableTop;
    }

    @Nullable
    public final String variant() {
        return this.variant;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_collation");
        super.serializeInternal(generator, mapper);
        if (this.alternate != null) {
            generator.writeKey("alternate");
            this.alternate.serialize(generator, mapper);
        }
        if (this.caseFirst != null) {
            generator.writeKey("caseFirst");
            this.caseFirst.serialize(generator, mapper);
        }
        if (this.caseLevel != null) {
            generator.writeKey("caseLevel");
            generator.write(this.caseLevel.booleanValue());
        }
        if (this.country != null) {
            generator.writeKey("country");
            generator.write(this.country);
        }
        if (this.decomposition != null) {
            generator.writeKey("decomposition");
            this.decomposition.serialize(generator, mapper);
        }
        if (this.hiraganaQuaternaryMode != null) {
            generator.writeKey("hiraganaQuaternaryMode");
            generator.write(this.hiraganaQuaternaryMode.booleanValue());
        }
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
        if (this.numeric != null) {
            generator.writeKey("numeric");
            generator.write(this.numeric.booleanValue());
        }
        if (this.rules != null) {
            generator.writeKey("rules");
            generator.write(this.rules);
        }
        if (this.strength != null) {
            generator.writeKey("strength");
            this.strength.serialize(generator, mapper);
        }
        if (this.variableTop != null) {
            generator.writeKey("variableTop");
            generator.write(this.variableTop);
        }
        if (this.variant != null) {
            generator.writeKey("variant");
            generator.write(this.variant);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIcuCollationTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        IcuCollationTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::alternate, IcuCollationAlternate._DESERIALIZER, "alternate");
        op.add(Builder::caseFirst, IcuCollationCaseFirst._DESERIALIZER, "caseFirst");
        op.add(Builder::caseLevel, JsonpDeserializer.booleanDeserializer(), "caseLevel");
        op.add(Builder::country, JsonpDeserializer.stringDeserializer(), "country");
        op.add(Builder::decomposition, IcuCollationDecomposition._DESERIALIZER, "decomposition");
        op.add(Builder::hiraganaQuaternaryMode, JsonpDeserializer.booleanDeserializer(), "hiraganaQuaternaryMode");
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.add(Builder::numeric, JsonpDeserializer.booleanDeserializer(), "numeric");
        op.add(Builder::rules, JsonpDeserializer.stringDeserializer(), "rules");
        op.add(Builder::strength, IcuCollationStrength._DESERIALIZER, "strength");
        op.add(Builder::variableTop, JsonpDeserializer.stringDeserializer(), "variableTop");
        op.add(Builder::variant, JsonpDeserializer.stringDeserializer(), "variant");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.alternate);
        result = 31 * result + Objects.hashCode(this.caseFirst);
        result = 31 * result + Objects.hashCode(this.caseLevel);
        result = 31 * result + Objects.hashCode(this.country);
        result = 31 * result + Objects.hashCode(this.decomposition);
        result = 31 * result + Objects.hashCode(this.hiraganaQuaternaryMode);
        result = 31 * result + Objects.hashCode(this.language);
        result = 31 * result + Objects.hashCode(this.numeric);
        result = 31 * result + Objects.hashCode(this.rules);
        result = 31 * result + Objects.hashCode(this.strength);
        result = 31 * result + Objects.hashCode(this.variableTop);
        result = 31 * result + Objects.hashCode(this.variant);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcuCollationTokenFilter other = (IcuCollationTokenFilter)o;
        return Objects.equals(this.alternate, other.alternate) && Objects.equals(this.caseFirst, other.caseFirst) && Objects.equals(this.caseLevel, other.caseLevel) && Objects.equals(this.country, other.country) && Objects.equals(this.decomposition, other.decomposition) && Objects.equals(this.hiraganaQuaternaryMode, other.hiraganaQuaternaryMode) && Objects.equals(this.language, other.language) && Objects.equals(this.numeric, other.numeric) && Objects.equals(this.rules, other.rules) && Objects.equals(this.strength, other.strength) && Objects.equals(this.variableTop, other.variableTop) && Objects.equals(this.variant, other.variant);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IcuCollationTokenFilter> {
        @Nullable
        private IcuCollationAlternate alternate;
        @Nullable
        private IcuCollationCaseFirst caseFirst;
        @Nullable
        private Boolean caseLevel;
        @Nullable
        private String country;
        @Nullable
        private IcuCollationDecomposition decomposition;
        @Nullable
        private Boolean hiraganaQuaternaryMode;
        @Nullable
        private String language;
        @Nullable
        private Boolean numeric;
        @Nullable
        private String rules;
        @Nullable
        private IcuCollationStrength strength;
        @Nullable
        private String variableTop;
        @Nullable
        private String variant;

        public Builder() {
        }

        private Builder(IcuCollationTokenFilter o) {
            super(o);
            this.alternate = o.alternate;
            this.caseFirst = o.caseFirst;
            this.caseLevel = o.caseLevel;
            this.country = o.country;
            this.decomposition = o.decomposition;
            this.hiraganaQuaternaryMode = o.hiraganaQuaternaryMode;
            this.language = o.language;
            this.numeric = o.numeric;
            this.rules = o.rules;
            this.strength = o.strength;
            this.variableTop = o.variableTop;
            this.variant = o.variant;
        }

        private Builder(Builder o) {
            super(o);
            this.alternate = o.alternate;
            this.caseFirst = o.caseFirst;
            this.caseLevel = o.caseLevel;
            this.country = o.country;
            this.decomposition = o.decomposition;
            this.hiraganaQuaternaryMode = o.hiraganaQuaternaryMode;
            this.language = o.language;
            this.numeric = o.numeric;
            this.rules = o.rules;
            this.strength = o.strength;
            this.variableTop = o.variableTop;
            this.variant = o.variant;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder alternate(@Nullable IcuCollationAlternate value) {
            this.alternate = value;
            return this;
        }

        @Nonnull
        public final Builder caseFirst(@Nullable IcuCollationCaseFirst value) {
            this.caseFirst = value;
            return this;
        }

        @Nonnull
        public final Builder caseLevel(@Nullable Boolean value) {
            this.caseLevel = value;
            return this;
        }

        @Nonnull
        public final Builder country(@Nullable String value) {
            this.country = value;
            return this;
        }

        @Nonnull
        public final Builder decomposition(@Nullable IcuCollationDecomposition value) {
            this.decomposition = value;
            return this;
        }

        @Nonnull
        public final Builder hiraganaQuaternaryMode(@Nullable Boolean value) {
            this.hiraganaQuaternaryMode = value;
            return this;
        }

        @Nonnull
        public final Builder language(@Nullable String value) {
            this.language = value;
            return this;
        }

        @Nonnull
        public final Builder numeric(@Nullable Boolean value) {
            this.numeric = value;
            return this;
        }

        @Nonnull
        public final Builder rules(@Nullable String value) {
            this.rules = value;
            return this;
        }

        @Nonnull
        public final Builder strength(@Nullable IcuCollationStrength value) {
            this.strength = value;
            return this;
        }

        @Nonnull
        public final Builder variableTop(@Nullable String value) {
            this.variableTop = value;
            return this;
        }

        @Nonnull
        public final Builder variant(@Nullable String value) {
            this.variant = value;
            return this;
        }

        @Override
        @Nonnull
        public IcuCollationTokenFilter build() {
            this._checkSingleUse();
            return new IcuCollationTokenFilter(this);
        }
    }
}

