/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.stats.ClusterProcessCpu;
import org.opensearch.client.opensearch.cluster.stats.ClusterProcessOpenFileDescriptors;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterProcess
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterProcess> {
    @Nonnull
    private final ClusterProcessCpu cpu;
    @Nonnull
    private final ClusterProcessOpenFileDescriptors openFileDescriptors;
    public static final JsonpDeserializer<ClusterProcess> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterProcess::setupClusterProcessDeserializer);

    private ClusterProcess(Builder builder) {
        this.cpu = ApiTypeHelper.requireNonNull(builder.cpu, this, "cpu");
        this.openFileDescriptors = ApiTypeHelper.requireNonNull(builder.openFileDescriptors, this, "openFileDescriptors");
    }

    public static ClusterProcess of(Function<Builder, ObjectBuilder<ClusterProcess>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final ClusterProcessCpu cpu() {
        return this.cpu;
    }

    @Nonnull
    public final ClusterProcessOpenFileDescriptors openFileDescriptors() {
        return this.openFileDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu");
        this.cpu.serialize(generator, mapper);
        generator.writeKey("open_file_descriptors");
        this.openFileDescriptors.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterProcessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, ClusterProcessCpu._DESERIALIZER, "cpu");
        op.add(Builder::openFileDescriptors, ClusterProcessOpenFileDescriptors._DESERIALIZER, "open_file_descriptors");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.cpu.hashCode();
        result = 31 * result + this.openFileDescriptors.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterProcess other = (ClusterProcess)o;
        return this.cpu.equals(other.cpu) && this.openFileDescriptors.equals(other.openFileDescriptors);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterProcess> {
        private ClusterProcessCpu cpu;
        private ClusterProcessOpenFileDescriptors openFileDescriptors;

        public Builder() {
        }

        private Builder(ClusterProcess o) {
            this.cpu = o.cpu;
            this.openFileDescriptors = o.openFileDescriptors;
        }

        private Builder(Builder o) {
            this.cpu = o.cpu;
            this.openFileDescriptors = o.openFileDescriptors;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cpu(ClusterProcessCpu value) {
            this.cpu = value;
            return this;
        }

        @Nonnull
        public final Builder cpu(Function<ClusterProcessCpu.Builder, ObjectBuilder<ClusterProcessCpu>> fn) {
            return this.cpu(fn.apply(new ClusterProcessCpu.Builder()).build());
        }

        @Nonnull
        public final Builder openFileDescriptors(ClusterProcessOpenFileDescriptors value) {
            this.openFileDescriptors = value;
            return this;
        }

        @Nonnull
        public final Builder openFileDescriptors(Function<ClusterProcessOpenFileDescriptors.Builder, ObjectBuilder<ClusterProcessOpenFileDescriptors>> fn) {
            return this.openFileDescriptors(fn.apply(new ClusterProcessOpenFileDescriptors.Builder()).build());
        }

        @Override
        @Nonnull
        public ClusterProcess build() {
            this._checkSingleUse();
            return new ClusterProcess(this);
        }
    }
}

