/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ism.RetryIndexResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class RetryIndexRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RetryIndexRequest> {
    @Nullable
    private final String index;
    @Nonnull
    private final String state;
    public static final JsonpDeserializer<RetryIndexRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RetryIndexRequest::setupRetryIndexRequestDeserializer);
    public static final Endpoint<RetryIndexRequest, RetryIndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RetryIndexRequest, RetryIndexResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_ism/retry";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ism/retry/");
            SimpleEndpoint.pathEncode(request.index, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, RetryIndexResponse._DESERIALIZER);

    private RetryIndexRequest(Builder builder) {
        super(builder);
        this.index = builder.index;
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static RetryIndexRequest of(Function<Builder, ObjectBuilder<RetryIndexRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final String state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("state");
        generator.write(this.state);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRetryIndexRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryIndexRequest other = (RetryIndexRequest)o;
        return Objects.equals(this.index, other.index) && this.state.equals(other.state);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RetryIndexRequest> {
        @Nullable
        private String index;
        private String state;

        public Builder() {
        }

        private Builder(RetryIndexRequest o) {
            super(o);
            this.index = o.index;
            this.state = o.state;
        }

        private Builder(Builder o) {
            super(o);
            this.index = o.index;
            this.state = o.state;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder state(String value) {
            this.state = value;
            return this;
        }

        @Override
        @Nonnull
        public RetryIndexRequest build() {
            this._checkSingleUse();
            return new RetryIndexRequest(this);
        }
    }
}

