/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.ICompoundType;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import java.util.ArrayList;
import java.util.Collections;

public class IntersectionType
extends AstType {
    public static final TokenRole INTERSECTION_TOKEN = new TokenRole("&", 2);

    public IntersectionType(AstType baseType, AstType ... interfaceTypes) {
        this.setBaseType(baseType);
        for (AstType ifType : interfaceTypes) {
            this.addChild(ifType, Roles.IMPLEMENTED_INTERFACE);
        }
    }

    public final AstType getBaseType() {
        return this.getChildByRole(Roles.BASE_TYPE);
    }

    public final void setBaseType(AstType value) {
        this.setChildByRole(Roles.BASE_TYPE, value);
    }

    public final AstNodeCollection<AstType> getInterfaces() {
        return this.getChildrenByRole(Roles.IMPLEMENTED_INTERFACE);
    }

    @Override
    public TypeReference toTypeReference() {
        TypeReference baseType = this.getBaseType().toTypeReference();
        AstNodeCollection<AstType> interfaces = this.getInterfaces();
        ArrayList<TypeReference> interfaceTypes = interfaces.isEmpty() ? Collections.emptyList() : new ArrayList<TypeReference>();
        for (AstType ifType : interfaces) {
            interfaceTypes.add(ifType.toTypeReference());
        }
        IMetadataResolver resolver = null;
        TypeReference t = this.getUserData(Keys.TYPE_REFERENCE);
        if (t != null) {
            TypeDefinition resolved;
            if (t instanceof ICompoundType) {
                resolver = ((ICompoundType)((Object)t)).getResolver();
            }
            if (resolver == null && (resolved = t.resolve()) != null) {
                resolver = resolved.getResolver();
            }
        }
        return new CompoundTypeReference(baseType, interfaceTypes, resolver);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitIntersectionType(this, data);
    }

    @Override
    public String toString() {
        AstNodeCollection<AstType> ifTypes = this.getInterfaces();
        StringBuilder sb = new StringBuilder();
        AstType baseType = this.getBaseType();
        boolean needToken = true;
        if (baseType.isNull()) {
            needToken = false;
        } else {
            sb.append(baseType);
        }
        for (AstType ifType : ifTypes) {
            if (needToken) {
                sb.append(" & ");
            }
            sb.append(ifType);
            needToken = true;
        }
        return sb.toString();
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof IntersectionType && this.getInterfaces().matches(((IntersectionType)other).getInterfaces(), match);
    }
}

