/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public final class ThisReferenceExpression
extends Expression {
    private static final String THIS_TEXT = "this";
    private TextLocation _startLocation;
    private TextLocation _endLocation;

    public ThisReferenceExpression() {
        this(-34, TextLocation.EMPTY);
    }

    public ThisReferenceExpression(int offset) {
        this(offset, TextLocation.EMPTY);
    }

    public ThisReferenceExpression(int offset, TextLocation startLocation) {
        super(offset);
        this._startLocation = VerifyArgument.notNull(startLocation, "startLocation");
        this._endLocation = new TextLocation(startLocation.line(), startLocation.column() + THIS_TEXT.length());
    }

    @Override
    public final TextLocation getStartLocation() {
        return this._startLocation;
    }

    @Override
    public final TextLocation getEndLocation() {
        return this._endLocation;
    }

    public final Expression getTarget() {
        return this.getChildByRole(Roles.TARGET_EXPRESSION);
    }

    public final void setTarget(Expression value) {
        this.setChildByRole(Roles.TARGET_EXPRESSION, value);
    }

    public final void setStartLocation(TextLocation startLocation) {
        this._startLocation = VerifyArgument.notNull(startLocation, "startLocation");
        this._endLocation = new TextLocation(startLocation.line(), startLocation.column() + THIS_TEXT.length());
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitThisReferenceExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof ThisReferenceExpression && this.getTarget().matches(((ThisReferenceExpression)other).getTarget(), match);
    }
}

