/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;

public class FlattenSwitchBlocksTransform
extends ContextTrackingVisitor<AstNode>
implements IAstTransform {
    public FlattenSwitchBlocksTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public void run(AstNode compilationUnit) {
        if (this.context.getSettings().getFlattenSwitchBlocks()) {
            compilationUnit.acceptVisitor(this, null);
        }
    }

    @Override
    public AstNode visitSwitchSection(SwitchSection node, Void p) {
        if (node.getStatements().size() != 1) {
            return (AstNode)super.visitSwitchSection(node, p);
        }
        Statement firstStatement = node.getStatements().firstOrNullObject();
        if (firstStatement instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)firstStatement;
            if (CollectionUtilities.any(CollectionUtilities.ofType(block.getStatements(), VariableDeclarationStatement.class))) {
                return (AstNode)super.visitSwitchSection(node, p);
            }
            block.remove();
            block.getStatements().moveTo(node.getStatements());
        }
        return (AstNode)super.visitSwitchSection(node, p);
    }
}

