/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.history;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.history.HistoryManager;
import org.protege.editor.owl.model.history.ReverseChangeGenerator;
import org.protege.editor.owl.model.history.UndoManagerListener;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryManagerImpl
implements HistoryManager {
    private ChangeType typeOfChangeInProgress = ChangeType.NORMAL;
    private static final Logger logger = LoggerFactory.getLogger(HistoryManager.class);
    private final OWLOntologyManager manager;
    private final Stack<List<OWLOntologyChange>> undoStack = new Stack();
    private final Stack<List<OWLOntologyChange>> redoStack = new Stack();
    private final List<UndoManagerListener> listeners = new ArrayList<UndoManagerListener>();

    public HistoryManagerImpl(OWLModelManager owlModelManager) {
        this(owlModelManager.getOWLOntologyManager());
    }

    public HistoryManagerImpl(OWLOntologyManager manager) {
        this.manager = manager;
        this.typeOfChangeInProgress = ChangeType.NORMAL;
    }

    @Override
    public boolean canRedo() {
        return this.redoStack.size() > 0;
    }

    @Override
    public boolean canUndo() {
        return this.undoStack.size() > 0;
    }

    @Override
    public void logChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        switch (this.typeOfChangeInProgress.ordinal()) {
            case 2: {
                this.redoStack.clear();
            }
            case 1: {
                this.undoStack.push(new ArrayList<OWLOntologyChange>(changes));
                break;
            }
            case 0: {
                this.redoStack.push(this.reverseChanges(changes));
            }
        }
        this.fireStateChanged();
    }

    @Override
    public void redo() {
        if (this.canRedo()) {
            try {
                this.typeOfChangeInProgress = ChangeType.REDOING;
                List<OWLOntologyChange> redoChanges = this.redoStack.pop();
                this.manager.applyChanges(redoChanges);
            }
            catch (Exception e) {
                logger.error("An error occurred whilst redoing the last set of undone changes.", (Throwable)e);
            }
            finally {
                this.typeOfChangeInProgress = ChangeType.NORMAL;
            }
        }
    }

    @Override
    public void undo() {
        if (this.canUndo()) {
            try {
                this.typeOfChangeInProgress = ChangeType.UNDOING;
                List<OWLOntologyChange> changes = this.undoStack.pop();
                this.manager.applyChanges(this.reverseChanges(changes));
            }
            catch (Exception e) {
                logger.error("An error occurred whilst attempting to undo the last set of changes.", (Throwable)e);
            }
            finally {
                this.typeOfChangeInProgress = ChangeType.NORMAL;
            }
        }
    }

    @Override
    public void clear() {
        this.redoStack.clear();
        this.undoStack.clear();
        this.fireStateChanged();
    }

    @Override
    public void addUndoManagerListener(@Nonnull UndoManagerListener listener) {
        this.listeners.add((UndoManagerListener)Preconditions.checkNotNull((Object)listener));
    }

    @Override
    public void removeUndoManagerListener(@Nonnull UndoManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @Nonnull
    public List<List<OWLOntologyChange>> getLoggedChanges() {
        ArrayList<List<OWLOntologyChange>> copyOfLog = new ArrayList<List<OWLOntologyChange>>();
        for (List list : this.undoStack) {
            copyOfLog.add(new ArrayList(list));
        }
        return copyOfLog;
    }

    public void fireStateChanged() {
        for (UndoManagerListener listener : new ArrayList<UndoManagerListener>(this.listeners)) {
            listener.stateChanged(this);
        }
    }

    private List<OWLOntologyChange> reverseChanges(List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> reversedChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            ReverseChangeGenerator gen = new ReverseChangeGenerator();
            oWLOntologyChange.accept((OWLOntologyChangeVisitor)gen);
            reversedChanges.add(0, gen.getReverseChange());
        }
        return reversedChanges;
    }

    private static enum ChangeType {
        UNDOING,
        REDOING,
        NORMAL;

    }
}

