/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddSelfQuickFix;
import com.jetbrains.python.inspections.quickfix.RenameParameterQuickFix;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyMethodParametersInspection
extends PyInspection {
    @Nullable
    public static PyMethodParametersInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(0);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String toolName = PyMethodParametersInspection.class.getSimpleName();
        return (PyMethodParametersInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(2);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyMethodParametersInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                if (!extension.ignoreMethodParameters(node, this.myTypeEvalContext)) continue;
                return;
            }
            PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(node);
            if (flags != null) {
                PyAstParameterList plist = node.getParameterList();
                PyParameter[] params = plist.getParameters();
                String methodName = node.getName();
                if (params.length == 0) {
                    if (flags.isStaticMethod()) {
                        return;
                    }
                    ASTNode name_node = node.getNameNode();
                    if (name_node != null) {
                        PsiElement open_paren = plist.getFirstChild();
                        PsiElement close_paren = plist.getLastChild();
                        if (open_paren != null && close_paren != null && "(".equals(open_paren.getText()) && ")".equals(close_paren.getText())) {
                            String paramName = flags.isMetaclassMethod() || flags.isClassMethod() ? "cls" : "self";
                            this.registerProblem((PsiElement)plist, PyPsiBundle.message("INSP.must.have.first.parameter", paramName), ProblemHighlightType.GENERIC_ERROR, null, new LocalQuickFix[]{new AddSelfQuickFix(paramName)});
                        }
                    }
                } else {
                    PyNamedParameter first_param = params[0].getAsNamed();
                    if (first_param != null) {
                        String pname = first_param.getName();
                        if (pname == null) {
                            return;
                        }
                        String[] mangled = new String[]{"eslf", "sself", "elf", "felf", "slef", "seelf", "slf", "sslf", "sefl", "sellf", "sef", "seef"};
                        if (PyUtil.among(pname, mangled)) {
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.probably.mistyped.self", new Object[0]), new LocalQuickFix[]{new RenameParameterQuickFix("self")});
                            return;
                        }
                        if (flags.isMetaclassMethod()) {
                            Set<String> alternativeNames;
                            String expectedName;
                            if (flags.isStaticMethod() && !"__new__".equals(methodName)) {
                                return;
                            }
                            if ("__new__".equals(methodName) || flags.isClassMethod()) {
                                expectedName = "cls";
                                alternativeNames = Set.of("mcs", "mcls", "metacls");
                            } else if (flags.isSpecialMetaclassMethod()) {
                                expectedName = "cls";
                                alternativeNames = Set.of();
                            } else {
                                expectedName = "self";
                                alternativeNames = Set.of("cls");
                            }
                            if (!expectedName.equals(pname) && !alternativeNames.contains(pname)) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.usually.named", expectedName), new LocalQuickFix[]{new RenameParameterQuickFix(expectedName)});
                            }
                        } else if (flags.isClassMethod() || "__new__".equals(methodName)) {
                            if (!"cls".equals(pname)) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.usually.named", "cls"), new LocalQuickFix[]{new RenameParameterQuickFix("cls")});
                            }
                        } else if (!(flags.isStaticMethod() || first_param.isPositionalContainer() || "self".equals(pname))) {
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.usually.named.self", new Object[0]), new LocalQuickFix[]{new RenameParameterQuickFix("self")});
                        }
                    } else if (!flags.isStaticMethod()) {
                        this.registerProblem((PsiElement)plist, PyPsiBundle.message("INSP.first.param.must.not.be.tuple", new Object[0]));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyMethodParametersInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

