/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.repository;

import com.intellij.codeWithMe.ClientId;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.python.Result;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.cache.PythonSimpleRepositoryCache;
import com.jetbrains.python.packaging.common.PythonPackageDetails;
import com.jetbrains.python.packaging.common.PythonRepositoryPackageSpecification;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryAuthenticationType;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.net.URL;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 82\u00020\u0001:\u00018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\bJ \u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0005J\u0006\u0010%\u001a\u00020#J\u001e\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u00052\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0007J(\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u00052\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010-\u001a\u00020.H\u0007J\u001a\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010*H\u0014J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u000502H\u0016J&\u00103\u001a\u0018\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020604j\b\u0012\u0004\u0012\u000205`72\u0006\u0010(\u001a\u00020\u0005H\u0016R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR(\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0012@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00069"}, d2={"Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "", "<init>", "()V", "name", "", "repositoryUrl", "login", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "value", "getName", "()Ljava/lang/String;", "setName$intellij_python_community_impl", "(Ljava/lang/String;)V", "getRepositoryUrl", "setRepositoryUrl$intellij_python_community_impl", "getLogin", "setLogin$intellij_python_community_impl", "Lcom/jetbrains/python/packaging/repository/PyPackageRepositoryAuthenticationType;", "authorizationType", "getAuthorizationType", "()Lcom/jetbrains/python/packaging/repository/PyPackageRepositoryAuthenticationType;", "setAuthorizationType$intellij_python_community_impl", "(Lcom/jetbrains/python/packaging/repository/PyPackageRepositoryAuthenticationType;)V", "serviceName", "getServiceName", "urlForInstallation", "Ljava/net/URL;", "getUrlForInstallation", "()Ljava/net/URL;", "buildAuthenticatedUrl", "baseUrl", "password", "getPassword", "setPassword", "", "pass", "clearCredentials", "findPackageSpecificationWithSpec", "Lcom/jetbrains/python/packaging/common/PythonRepositoryPackageSpecification;", "packageName", "versionSpecs", "Lcom/jetbrains/python/packaging/requirement/PyRequirementVersionSpec;", "findPackageSpecification", "version", "relation", "Lcom/jetbrains/python/packaging/requirement/PyRequirementRelation;", "hasPackage", "", "getPackages", "", "buildPackageDetails", "Lcom/jetbrains/python/Result;", "Lcom/jetbrains/python/packaging/common/PythonPackageDetails;", "Lcom/jetbrains/python/errorProcessing/PyError;", "Lcom/jetbrains/python/errorProcessing/PyResult;", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyPackageRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackageRepository.kt\ncom/jetbrains/python/packaging/repository/PyPackageRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,140:1\n1#2:141\n40#3,3:142\n*S KotlinDebug\n*F\n+ 1 PyPackageRepository.kt\ncom/jetbrains/python/packaging/repository/PyPackageRepository\n*L\n131#1:142,3\n*E\n"})
public class PyPackageRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @Nullable
    private String repositoryUrl;
    @Nullable
    private String login;
    @NotNull
    private PyPackageRepositoryAuthenticationType authorizationType;
    @NotNull
    private static final String SUBSYSTEM_NAME = "PyCharm";

    public PyPackageRepository() {
        this.name = "";
        this.authorizationType = PyPackageRepositoryAuthenticationType.NONE;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName$intellij_python_community_impl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public final String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public final void setRepositoryUrl$intellij_python_community_impl(@Nullable String string) {
        this.repositoryUrl = string;
    }

    @Nullable
    public final String getLogin() {
        return this.login;
    }

    public final void setLogin$intellij_python_community_impl(@Nullable String string) {
        this.login = string;
    }

    @NotNull
    public final PyPackageRepositoryAuthenticationType getAuthorizationType() {
        return this.authorizationType;
    }

    public final void setAuthorizationType$intellij_python_community_impl(@NotNull PyPackageRepositoryAuthenticationType pyPackageRepositoryAuthenticationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)pyPackageRepositoryAuthenticationType), (String)"<set-?>");
        this.authorizationType = pyPackageRepositoryAuthenticationType;
    }

    public PyPackageRepository(@NotNull String name2, @Nullable String repositoryUrl, @Nullable String login) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this();
        this.name = name2;
        this.repositoryUrl = repositoryUrl;
        this.login = login;
    }

    private final String getServiceName() {
        return CredentialAttributesKt.generateServiceName((String)SUBSYSTEM_NAME, (String)this.name);
    }

    @Nullable
    public final URL getUrlForInstallation() {
        String string;
        String string2 = this.repositoryUrl;
        if (string2 == null) {
            return null;
        }
        String baseUrl = string2;
        String it = string = this.login;
        boolean bl = false;
        CharSequence charSequence = it;
        String string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        if (string3 == null) {
            return new URL(baseUrl);
        }
        String userLogin = string3;
        String string4 = this.getPassword();
        if (string4 == null) {
            return new URL(baseUrl);
        }
        String userPassword = string4;
        return this.buildAuthenticatedUrl(baseUrl, userLogin, userPassword);
    }

    private final URL buildAuthenticatedUrl(String baseUrl, String login, String password) {
        URL uRL = new URIBuilder(baseUrl).setUserInfo(login, password).build().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @Transient
    @Nullable
    public final String getPassword() {
        CredentialAttributes attributes = new CredentialAttributes(this.getServiceName(), this.login);
        return PasswordSafe.Companion.getInstance().getPassword(attributes);
    }

    public final void setPassword(@Nullable String pass) {
        CredentialAttributes attributes = new CredentialAttributes(this.getServiceName(), this.login);
        PasswordSafe.Companion.getInstance().set(attributes, new Credentials(this.login, pass));
    }

    public final void clearCredentials() {
        CredentialAttributes attributes = new CredentialAttributes(this.getServiceName(), this.login);
        PasswordSafe.Companion.getInstance().set(attributes, null);
    }

    @ApiStatus.Internal
    @Nullable
    public final PythonRepositoryPackageSpecification findPackageSpecificationWithSpec(@NotNull String packageName, @Nullable PyRequirementVersionSpec versionSpecs) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.hasPackage(packageName, versionSpecs) ? new PythonRepositoryPackageSpecification(this, packageName, versionSpecs) : null;
    }

    public static /* synthetic */ PythonRepositoryPackageSpecification findPackageSpecificationWithSpec$default(PyPackageRepository pyPackageRepository, String string, PyRequirementVersionSpec pyRequirementVersionSpec, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPackageSpecificationWithSpec");
        }
        if ((n & 2) != 0) {
            pyRequirementVersionSpec = null;
        }
        return pyPackageRepository.findPackageSpecificationWithSpec(string, pyRequirementVersionSpec);
    }

    @ApiStatus.Internal
    @Nullable
    public final PythonRepositoryPackageSpecification findPackageSpecification(@NotNull String packageName, @Nullable String version2, @NotNull PyRequirementRelation relation) {
        PyRequirementVersionSpec pyRequirementVersionSpec;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        String string = version2;
        if (string != null) {
            String it = string;
            boolean bl = false;
            pyRequirementVersionSpec = PyRequirementsKt.pyRequirementVersionSpec(relation, version2);
        } else {
            pyRequirementVersionSpec = null;
        }
        PyRequirementVersionSpec versionSpec = pyRequirementVersionSpec;
        return this.findPackageSpecificationWithSpec(packageName, versionSpec);
    }

    public static /* synthetic */ PythonRepositoryPackageSpecification findPackageSpecification$default(PyPackageRepository pyPackageRepository, String string, String string2, PyRequirementRelation pyRequirementRelation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPackageSpecification");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            pyRequirementRelation = PyRequirementRelation.EQ;
        }
        return pyPackageRepository.findPackageSpecification(string, string2, pyRequirementRelation);
    }

    protected boolean hasPackage(@NotNull String packageName, @Nullable PyRequirementVersionSpec versionSpecs) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.getPackages().contains(packageName);
    }

    @NotNull
    public Set<String> getPackages() {
        boolean $i$f$service = false;
        Class<PythonSimpleRepositoryCache> serviceClass$iv = PythonSimpleRepositoryCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Set set = ((PythonSimpleRepositoryCache)object).get(this);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public Result<PythonPackageDetails, PyError> buildPackageDetails(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return PyPackageRepositoryKt.buildPackageDetailsBySimpleDetailsProtocol(this, packageName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/packaging/repository/PyPackageRepository$Companion;", "", "<init>", "()V", "SUBSYSTEM_NAME", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

