\name{GrayscaleGeodesicErodeImageFilter}
\alias{GrayscaleGeodesicErodeImageFilter}
\title{GrayscaleGeodesicErodeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
geodesic gray scale erosion of an image
GrayscaleGeodesicErodeImageFilter}
\details{
Geodesic erosion operates on a "marker" image and a "mask" image.
The marker image is eroded using an elementary structuring element
(neighborhood of radius one using only the face connected neighbors).
The resulting image is then compared with the mask image. The output
image is the pixelwise maximum of the eroded marker image and the mask
image.
Geodesic erosion is run either one iteration or until convergence. In
the convergence case, the filter is equivalent to "reconstruction by
erosion". This filter is implemented to handle both scenarios. The
one iteration case is multi-threaded. The convergence case is
delegated to another instance of the same filter (but configured to
run a single iteration).
The marker image must be greater than or equal to the mask image (on a
pixel by pixel basis).
Geodesic morphology is described in Chapter 6 of Pierre Soille's book
"Morphological Image Analysis: Principles and Applications", Second
Edition, Springer, 2003.
A noniterative version of this algorithm can be found in the ReconstructionByErosionImageFilter . This noniterative solution is much faster than the implementation
provided here. All ITK filters that previously used GrayscaleGeodesicErodeImageFilter as part of their implementation have been converted to use the ReconstructionByErosionImageFilter . The GrayscaleGeodesicErodeImageFilter is maintained for backward compatibility.
See:
MorphologyImageFilter , GrayscaleErodeImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter , ReconstructionByErosionImageFilter
GrayscaleGeodesicErode for the procedural interface
itk::GrayscaleGeodesicErodeImageFilter for the Doxygen on the original ITK class.
GrayscaleGeodesicErodeImageFilter}
%C++ includes: sitkGrayscaleGeodesicErodeImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetRunOneIteration() const:}{
Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by erosion". Default is off.
}
\item{ GrayscaleGeodesicErodeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self RunOneIterationOff():}{}
\item{Self RunOneIterationOn():}{
Set the value of RunOneIteration to true or false respectfully.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetRunOneIteration(bool RunOneIteration):}{
Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by erosion". Default is off.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GrayscaleGeodesicErodeImageFilter():}{
Destructor
}
}
}
