\name{PermuteAxesImageFilter}
\alias{PermuteAxesImageFilter}
\title{PermuteAxesImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Permutes the image axes according to a user specified order.
PermuteAxesImageFilter}
\details{
PermuateAxesImageFilter permutes the image axes according to a user
specified order. The permutation order is set via method SetOrder(
order ) where the input is an array of ImageDimension number of
unsigned int. The elements of the array must be a rearrangement of the
numbers from 0 to ImageDimension - 1.
The i-th axis of the output image corresponds with the order[i]-th
axis of the input image.
The output meta image information (LargestPossibleRegion, spacing,
origin) is computed by permuting the corresponding input meta
information.
See:
PermuteAxes for the procedural interface
itk::PermuteAxesImageFilter for the Doxygen on the original ITK class.
PermuteAxesImageFilter}
%C++ includes: sitkPermuteAxesImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetOrder() const:}{
Get the permutation order.
}
\item{ PermuteAxesImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetOrder(std::vector< unsigned int > Order):}{
Set the permutation order. The elements of order must be a
rearrangement of the numbers from 0 to ImageDimension - 1.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~PermuteAxesImageFilter():}{
Destructor
}
}
}
