\name{ShapeDetectionLevelSetImageFilter}
\alias{ShapeDetectionLevelSetImageFilter}
\title{ShapeDetectionLevelSetImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Segments structures in images based on a user supplied edge potential
map.
ShapeDetectionLevelSetImageFilter}
\details{
IMPORTANT
The SegmentationLevelSetImageFilter class and the ShapeDetectionLevelSetFunction class contain additional information necessary to gain full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. An initial
contour is propagated outwards (or inwards) until it ''sticks'' to the
shape boundaries. This is done by using a level set speed function
based on a user supplied edge potential map. This approach for
segmentation follows that of Malladi et al (1995).
INPUTS
This filter requires two inputs. The first input is a initial level
set. The initial level set is a real image which contains the initial
contour/surface as the zero level set. For example, a signed distance
function from the initial contour/surface is typically used. Note that
for this algorithm the initial contour has to be wholly within (or
wholly outside) the structure to be segmented.
The second input is the feature image. For this filter, this is the
edge potential map. General characteristics of an edge potential map
is that it has values close to zero in regions near the edges and
values close to one inside the shape itself. Typically, the edge
potential map is compute from the image gradient, for example:
 \deqn{ g(I) = 1 / ( 1 + | (\nabla * G)(I)| ) } \deqn{ g(I) = \exp^{-|(\nabla * G)(I)|} }
where \eqn{ I } is image intensity and \eqn{ (\nabla * G) } is the derivative of Gaussian operator.
See SegmentationLevelSetImageFilter and SparseFieldLevelSetImageFilter for more information on Inputs.
PARAMETERS
The PropagationScaling parameter can be used to switch from
propagation outwards (POSITIVE scaling parameter) versus propagating
inwards (NEGATIVE scaling parameter).
 The smoothness of the resulting contour/surface can be adjusted using
a combination of PropagationScaling and CurvatureScaling parameters.
The larger the CurvatureScaling parameter, the smoother the resulting
contour. The CurvatureScaling parameter should be non-negative for
proper operation of this algorithm. To follow the implementation in
Malladi et al paper, set the PropagationScaling to \eqn{\pm 1.0} and CurvatureScaling to \eqn{ \epsilon } .
Note that there is no advection term for this filter. Setting the
advection scaling will have no effect.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Negative
values in the output image represent the inside of the segmented
region and positive values in the image represent the outside of the
segmented region. The zero crossings of the image correspond to the
position of the propagating front.
See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
REFERENCES
"Shape Modeling with Front Propagation: A Level Set Approach", R.
Malladi, J. A. Sethian and B. C. Vermuri. IEEE Trans. on Pattern
Analysis and Machine Intelligence, Vol 17, No. 2, pp 158-174, February
1995
See:
SegmentationLevelSetImageFilter
ShapeDetectionLevelSetFunction
SparseFieldLevelSetImageFilter
ShapeDetectionLevelSet for the procedural interface
itk::ShapeDetectionLevelSetImageFilter for the Doxygen on the original ITK class.
ShapeDetectionLevelSetImageFilter}
%C++ includes: sitkShapeDetectionLevelSetImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &initialImage, const Image &featureImage):}{}
\item{Image Execute(Image &&initialImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{double GetCurvatureScaling() const:}{}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMaximumRMSError() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetPropagationScaling() const:}{}
\item{bool GetReverseExpansionDirection() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self ReverseExpansionDirectionOff():}{}
\item{Self ReverseExpansionDirectionOn():}{
Set the value of ReverseExpansionDirection to true or false
respectfully.
}
\item{Self SetCurvatureScaling(double CurvatureScaling):}{}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetPropagationScaling(double PropagationScaling):}{}
\item{Self SetReverseExpansionDirection(bool ReverseExpansionDirection):}{}
\item{ ShapeDetectionLevelSetImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ShapeDetectionLevelSetImageFilter():}{
Destructor
}
}
}
