/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis.reflection.util;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;

public class ReflectionUtils {
    private static ImmutableBiMap<String, String> primitiveMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("boolean", "Z")).put("int", "I")).put("long", "J")).put("double", "D")).put("void", "V")).put("float", "F")).put("char", "C")).put("short", "S")).put("byte", "B")).build();

    public static String javaToDexName(String javaName) {
        if (javaName.charAt(0) == '[') {
            return javaName.replace('.', '/');
        }
        if (primitiveMap.containsKey(javaName)) {
            return (String)primitiveMap.get(javaName);
        }
        return 'L' + javaName.replace('.', '/') + ';';
    }

    public static String dexToJavaName(String dexName) {
        if (dexName.charAt(0) == '[') {
            return dexName.replace('/', '.');
        }
        if (((ImmutableMap)((Object)primitiveMap.inverse())).containsKey(dexName)) {
            return (String)((ImmutableMap)((Object)primitiveMap.inverse())).get(dexName);
        }
        return dexName.replace('/', '.').substring(1, dexName.length() - 2);
    }
}

