/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Vec3f;

public final class Vec4f {
    private float x;
    private float y;
    private float z;
    private float w;

    public Vec4f() {
    }

    public Vec4f(Vec4f vec4f) {
        this.set(vec4f);
    }

    public Vec4f(Vec3f vec3f, float f) {
        this.set(vec3f, f);
    }

    public Vec4f copy() {
        return new Vec4f(this);
    }

    public Vec4f(float[] fArray) {
        this.set(fArray);
    }

    public Vec4f(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public Vec4f set(Vec4f vec4f) {
        this.x = vec4f.x;
        this.y = vec4f.y;
        this.z = vec4f.z;
        this.w = vec4f.w;
        return this;
    }

    public Vec4f set(Vec3f vec3f, float f) {
        this.x = vec3f.x();
        this.y = vec3f.y();
        this.z = vec3f.z();
        this.w = f;
        return this;
    }

    public Vec4f set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Vec4f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
        return this;
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
                break;
            }
            case 3: {
                this.w = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float[] get(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
        fArray[3] = this.w;
        return fArray;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public void setW(float f) {
        this.w = f;
    }

    public Vec4f max(Vec4f vec4f) {
        this.x = Math.max(this.x, vec4f.x);
        this.y = Math.max(this.y, vec4f.y);
        this.z = Math.max(this.z, vec4f.z);
        this.w = Math.max(this.w, vec4f.w);
        return this;
    }

    public Vec4f min(Vec4f vec4f) {
        this.x = Math.min(this.x, vec4f.x);
        this.y = Math.min(this.y, vec4f.y);
        this.z = Math.min(this.z, vec4f.z);
        this.w = Math.min(this.w, vec4f.w);
        return this;
    }

    public Vec4f mul(float f) {
        return new Vec4f(this).scale(f);
    }

    public Vec4f mul(Vec4f vec4f, Vec4f vec4f2) {
        this.x = vec4f.x * vec4f2.x;
        this.y = vec4f.y * vec4f2.y;
        this.z = vec4f.z * vec4f2.z;
        this.w = vec4f.w * vec4f2.w;
        return this;
    }

    public Vec4f scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    public Vec4f scale(float f, float f2, float f3, float f4) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        this.w *= f4;
        return this;
    }

    public Vec4f plus(Vec4f vec4f) {
        return new Vec4f(this).add(vec4f);
    }

    public Vec4f plus(Vec4f vec4f, Vec4f vec4f2) {
        this.x = vec4f.x + vec4f2.x;
        this.y = vec4f.y + vec4f2.y;
        this.z = vec4f.z + vec4f2.z;
        this.w = vec4f.w + vec4f2.w;
        return this;
    }

    public Vec4f add(float f, float f2, float f3, float f4) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        this.w += f4;
        return this;
    }

    public Vec4f add(Vec4f vec4f) {
        this.x += vec4f.x;
        this.y += vec4f.y;
        this.z += vec4f.z;
        this.w += vec4f.w;
        return this;
    }

    public Vec4f minus(Vec4f vec4f) {
        return new Vec4f(this).sub(vec4f);
    }

    public Vec4f minus(Vec4f vec4f, Vec4f vec4f2) {
        this.x = vec4f.x - vec4f2.x;
        this.y = vec4f.y - vec4f2.y;
        this.z = vec4f.z - vec4f2.z;
        this.w = vec4f.w - vec4f2.w;
        return this;
    }

    public Vec4f sub(Vec4f vec4f) {
        this.x -= vec4f.x;
        this.y -= vec4f.y;
        this.z -= vec4f.z;
        this.w -= vec4f.w;
        return this;
    }

    public boolean isZero() {
        return FloatUtil.isZero(this.x) && FloatUtil.isZero(this.y) && FloatUtil.isZero(this.z) && FloatUtil.isZero(this.w);
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSq());
    }

    public float lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Vec4f normalize() {
        float f = this.lengthSq();
        if (FloatUtil.isZero(f)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.w = 0.0f;
        } else {
            float f2 = 1.0f / (float)Math.sqrt(f);
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
            this.w *= f2;
        }
        return this;
    }

    public float distSq(Vec4f vec4f) {
        float f = this.x - vec4f.x;
        float f2 = this.y - vec4f.y;
        float f3 = this.z - vec4f.z;
        float f4 = this.w - vec4f.w;
        return f * f + f2 * f2 + f3 * f3 + f4 * f4;
    }

    public float dist(Vec4f vec4f) {
        return (float)Math.sqrt(this.distSq(vec4f));
    }

    public float dot(Vec4f vec4f) {
        return this.x * vec4f.x + this.y * vec4f.y + this.z * vec4f.z + this.w * vec4f.w;
    }

    public float cosAngle(Vec4f vec4f) {
        return this.dot(vec4f) / (this.length() * vec4f.length());
    }

    public float angle(Vec4f vec4f) {
        return (float)Math.acos(this.cosAngle(vec4f));
    }

    public boolean isEqual(Vec4f vec4f, float f) {
        if (this == vec4f) {
            return true;
        }
        return FloatUtil.isEqual(this.x, vec4f.x, f) && FloatUtil.isEqual(this.y, vec4f.y, f) && FloatUtil.isEqual(this.z, vec4f.z, f) && FloatUtil.isEqual(this.w, vec4f.w, f);
    }

    public boolean isEqual(Vec4f vec4f) {
        return this.isEqual(vec4f, 1.1920929E-7f);
    }

    public boolean equals(Object object) {
        if (object instanceof Vec4f) {
            return this.isEqual((Vec4f)object, 1.1920929E-7f);
        }
        return false;
    }

    public String toString() {
        return this.x + " / " + this.y + " / " + this.z + " / " + this.w;
    }
}

