/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class DirectionalSpotlight
implements LightSource {
    private Point3 src = new Point3(0.0f, 0.0f, 0.0f);
    private Vector3 dir = new Vector3(0.0f, 0.0f, -1.0f);
    private OrthoNormalBasis basis;
    private float r;
    private float r2;
    private Color radiance;

    public DirectionalSpotlight() {
        this.dir.normalize();
        this.basis = OrthoNormalBasis.makeFromW(this.dir);
        this.r = 1.0f;
        this.r2 = this.r * this.r;
        this.radiance = Color.WHITE;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.src = parameterList.getPoint("source", this.src);
        this.dir = parameterList.getVector("dir", this.dir);
        this.dir.normalize();
        this.r = parameterList.getFloat("radius", this.r);
        this.basis = OrthoNormalBasis.makeFromW(this.dir);
        this.r2 = this.r * this.r;
        this.radiance = parameterList.getColor("radiance", this.radiance);
        return true;
    }

    public int getNumSamples() {
        return 1;
    }

    public int getLowSamples() {
        return 1;
    }

    public void getSamples(ShadingState shadingState) {
        float f;
        float f2;
        float f3;
        float f4;
        if (Vector3.dot(this.dir, shadingState.getGeoNormal()) < 0.0f && Vector3.dot(this.dir, shadingState.getNormal()) < 0.0f && (double)(f4 = (f3 = shadingState.getPoint().x - this.src.x) * this.dir.x + (f2 = shadingState.getPoint().y - this.src.y) * this.dir.y + (f = shadingState.getPoint().z - this.src.z) * this.dir.z) >= 0.0 && (f3 -= f4 * this.dir.x) * f3 + (f2 -= f4 * this.dir.y) * f2 + (f -= f4 * this.dir.z) * f <= this.r2) {
            Point3 point3 = new Point3();
            point3.x = this.src.x + f3;
            point3.y = this.src.y + f2;
            point3.z = this.src.z + f;
            LightSample lightSample = new LightSample();
            lightSample.setShadowRay(new Ray(shadingState.getPoint(), point3));
            lightSample.setRadiance(this.radiance, this.radiance);
            lightSample.traceShadow(shadingState);
            shadingState.addSample(lightSample);
        }
    }

    public void getPhoton(double d, double d2, double d3, double d4, Point3 point3, Vector3 vector3, Color color) {
        float f = (float)(Math.PI * 2 * d);
        float f2 = (float)Math.sqrt(1.0 - d2);
        vector3.x = this.r * (float)Math.cos(f) * f2;
        vector3.y = this.r * (float)Math.sin(f) * f2;
        vector3.z = 0.0f;
        this.basis.transform(vector3);
        Point3.add(this.src, vector3, point3);
        vector3.set(this.dir);
        color.set(this.radiance).mul((float)Math.PI * this.r2);
    }

    public float getPower() {
        return this.radiance.copy().mul((float)Math.PI * this.r2).getLuminance();
    }

    public Instance createInstance() {
        return null;
    }
}

