/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicFilterModule;
import com.sun.media.BasicModule;
import com.sun.media.BasicMuxModule;
import com.sun.media.BasicRendererModule;
import com.sun.media.BasicSourceModule;
import com.sun.media.InputConnector;
import com.sun.media.JMD;
import com.sun.media.Module;
import com.sun.media.OutputConnector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Controls;
import javax.media.Format;
import javax.media.PlugIn;

public final class BasicJMD
extends Panel
implements JMD,
WindowListener {
    Vector modList = new Vector();
    Vector conList = new Vector();
    boolean graphic = true;
    Panel center;
    Label status;
    Frame frame = null;
    boolean activated = false;
    Button button = null;
    Dimension preferredSize = new Dimension(512, 140);
    int ro;
    int col;
    int colMax = 1;
    int roMax = 1;
    int wrapWidth = 200;
    int wrapHeight = 50;
    int offX = 0;
    int offY = 0;
    int fill = 10;
    int cSize = 10;

    public BasicJMD(String title) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.center = new Panel(){

            public Dimension getPreferredSize() {
                return BasicJMD.this.preferredSize;
            }
        };
        this.center.setLayout(null);
        this.add("North", this.center);
        this.status = new Label();
        this.add("South", this.status);
        this.setSize(512, 200);
    }

    public Component getControlComponent() {
        if (this.button == null) {
            this.button = new Button("PlugIn Viewer"){

                public void removeNotify() {
                    super.removeNotify();
                    BasicJMD.this.dispose();
                }
            };
            this.button.setName("PlugIns");
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    BasicJMD.this.setVisible(true);
                }
            });
        }
        return this.button;
    }

    public synchronized void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public synchronized void setVisible(boolean visible) {
        if (this.getParent() == null) {
            if (visible && this.frame == null) {
                this.frame = new Frame("PlugIn Viewer");
                this.frame.setLayout(new BorderLayout());
                this.frame.add("Center", this);
                this.frame.addWindowListener(this);
                this.frame.pack();
                ((Component)this.frame).setVisible(true);
            }
        } else if (this.getParent() == this.frame) {
            ((Component)this.frame).setVisible(visible);
        } else {
            super.setVisible(visible);
        }
    }

    public void initGraph(BasicModule source) {
        this.center.removeAll();
        this.modList = new Vector();
        this.conList = new Vector();
        this.drawGraph(source);
        this.ro = 0;
        this.col = 0;
        this.preferredSize = new Dimension((this.colMax + 1) * this.wrapWidth + this.offX * 2, this.roMax * this.wrapHeight + this.offY * 2);
    }

    public void drawGraph(BasicModule source) {
        String[] names = source.getOutputConnectorNames();
        int height = names.length;
        if (height == 0) {
            height = 1;
        }
        this.createModuleWrap(source, this.ro, this.col, height);
        if (this.roMax < names.length) {
            this.roMax = names.length;
        }
        int i = 0;
        while (i < names.length) {
            OutputConnector oc = source.getOutputConnector(names[i]);
            InputConnector ic = oc.getInputConnector();
            if (ic == null) {
                if (this.col == 0) {
                    ++this.ro;
                }
            } else {
                Module m = ic.getModule();
                if (m == null) {
                    if (this.col == 0) {
                        ++this.ro;
                    }
                } else {
                    ++this.col;
                    if (this.col > this.colMax) {
                        this.colMax = this.col;
                    }
                    this.drawGraph((BasicModule)m);
                    --this.col;
                    if (this.col == 0) {
                        ++this.ro;
                    }
                }
            }
            ++i;
        }
    }

    public void createModuleWrap(BasicModule m, int row, int column, int h) {
        Controls plugin = m;
        if (m instanceof BasicSourceModule) {
            plugin = ((BasicSourceModule)m).getDemultiplexer();
        } else if (m instanceof BasicFilterModule) {
            plugin = ((BasicFilterModule)m).getCodec();
        } else if (m instanceof BasicRendererModule) {
            plugin = ((BasicRendererModule)m).getRenderer();
        } else if (m instanceof BasicMuxModule) {
            plugin = ((BasicMuxModule)m).getMultiplexer();
        }
        String name = ((PlugIn)plugin).getName();
        ModButton b = new ModButton(name, m, (PlugIn)plugin);
        b.setName("M" + m.hashCode());
        this.modList.addElement(b);
        b.setBackground(new Color(192, 192, 128));
        b.setForeground(Color.black);
        this.center.add(b);
        b.setBounds(this.offX + column * this.wrapWidth + this.fill, this.offY + row * this.wrapHeight + this.fill, this.wrapWidth - this.fill * 2, h * this.wrapHeight - this.fill * 2);
        b.setVisible(true);
        this.center.invalidate();
    }

    public void moduleIn(BasicModule bm, int index, Buffer d, boolean here) {
        this.updateConnector(bm, index, d, here, 0);
    }

    public void updateConnector(BasicModule bm, int index, Buffer d, boolean here, int inOut) {
        if (!this.activated) {
            return;
        }
        Con c = this.findConnector(bm, index, inOut);
        if (c == null) {
            return;
        }
        c.setData(d);
        if (here) {
            if (d.isEOM()) {
                c.flash(Color.red);
            } else if (d.isDiscard()) {
                c.flash(Color.yellow);
            } else {
                c.flash(Color.green);
            }
        } else {
            c.flash(Color.gray);
        }
    }

    public void moduleOut(BasicModule bm, int index, Buffer d, boolean here) {
        this.updateConnector(bm, index, d, here, 1);
    }

    public Con findConnector(BasicModule bm, int index, int inOut) {
        String name = "C" + bm.hashCode() + index + inOut;
        Enumeration e = this.conList.elements();
        while (e.hasMoreElements()) {
            Con c = (Con)e.nextElement();
            if (!c.getName().equals(name)) continue;
            return c;
        }
        Component m = this.findModule(bm);
        if (m == null) {
            return null;
        }
        Point p = m.getLocation();
        Con c = new Con();
        this.center.add(c);
        c.setBounds(p.x - this.fill + (this.wrapWidth - this.fill) * inOut, p.y + (this.wrapHeight - 2 * this.fill - this.cSize) / 2 + this.wrapHeight * index, this.cSize, this.cSize);
        c.setName(name);
        this.conList.addElement(c);
        return c;
    }

    public Component findModule(BasicModule bm) {
        String name = "M" + bm.hashCode();
        Enumeration e = this.modList.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public void windowActivated(WindowEvent we) {
        this.activated = true;
    }

    public void windowOpened(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowClosing(WindowEvent we) {
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
        this.activated = false;
    }

    class Con
    extends Button {
        Graphics g = null;
        Buffer data = null;
        boolean mouseHere = false;

        public Con() {
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Con this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseEntered(MouseEvent me) {
                    this.this$1.updateStatus();
                    this.this$1.mouseHere = true;
                }

                public void mouseExited(MouseEvent me) {
                    this.this$1.mouseHere = false;
                }
            });
        }

        public void flash(Color c) {
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            g.setColor(c);
            g.fillRect(1, 1, BasicJMD.this.cSize - 2, BasicJMD.this.cSize - 2);
        }

        public Graphics getGraphics() {
            this.g = super.getGraphics();
            return this.g;
        }

        public void paint(Graphics g) {
            g.setColor(Color.black);
            g.drawRect(0, 0, BasicJMD.this.cSize - 1, BasicJMD.this.cSize - 1);
            g.setColor(Color.gray);
            g.fillRect(1, 1, BasicJMD.this.cSize - 2, BasicJMD.this.cSize - 2);
        }

        public void setData(Buffer d) {
            if (this.mouseHere) {
                this.updateStatus();
            }
            this.data = d;
        }

        void updateStatus() {
            Format f = this.data.getFormat();
            String s = f == null ? "null" : f.toString();
            BasicJMD.this.status.setText(s + ", Length = " + this.data.getLength());
        }
    }

    class ModButton
    extends Button {
        BasicModule module;
        boolean mouseHere = false;
        PlugIn plugin;

        public String cropName(String name) {
            String cropped;
            int box_width = 120;
            FontMetrics fm = this.getFontMetrics(new Font("Dialog", 0, 11));
            int width = fm.stringWidth(cropped = name);
            boolean appendDots = width > box_width;
            while (width > box_width) {
                int length = cropped.length();
                cropped = name.substring(0, length - 1);
                width = fm.stringWidth(cropped);
            }
            if (appendDots) {
                cropped = cropped + "...";
            }
            return cropped;
        }

        public ModButton(String name, BasicModule m, PlugIn p) {
            name = this.cropName(name);
            super.setLabel(name);
            this.module = m;
            this.plugin = p;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ModButton this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseEntered(MouseEvent me) {
                    this.this$1.updateStatus();
                    this.this$1.mouseHere = true;
                }

                public void mouseExited(MouseEvent me) {
                    this.this$1.mouseHere = false;
                }
            });
        }

        public void updateStatus() {
            BasicJMD.this.status.setText(this.plugin.getClass().getName() + " , " + this.plugin.getName());
        }
    }
}

