/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.TriangleBasedShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

abstract class GouraudShadingContext
extends TriangleBasedShadingContext
implements PaintContext {
    private static final Log LOG = LogFactory.getLog(GouraudShadingContext.class);
    protected ArrayList<ShadedTriangle> triangleList = new ArrayList();
    protected float[] background;
    protected int rgbBackground;
    protected HashMap<Point, Integer> pixelTable;

    protected GouraudShadingContext(PDShadingResources shading, ColorModel colorModel, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, ctm, pageHeight, dBounds);
        LOG.debug("Background: " + shading.getBackground());
        COSArray bg = shading.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
            this.rgbBackground = this.convertToRGB(this.background);
        }
    }

    protected Vertex readVertex(ImageInputStream input, long maxSrcCoord, long maxSrcColor, PDRange rangeX, PDRange rangeY, PDRange[] colRangeTab, Matrix ctm, AffineTransform xform) throws IOException {
        float[] colorComponentTab = new float[this.numberOfColorComponents];
        long x = input.readBits(this.bitsPerCoordinate);
        long y = input.readBits(this.bitsPerCoordinate);
        double dstX = this.interpolate(x, maxSrcCoord, rangeX.getMin(), rangeX.getMax());
        double dstY = this.interpolate(y, maxSrcCoord, rangeY.getMin(), rangeY.getMax());
        LOG.debug("coord: " + String.format("[%06X,%06X] -> [%f,%f]", x, y, dstX, dstY));
        Point2D.Double tmp = new Point2D.Double(dstX, dstY);
        this.transformPoint(tmp, ctm, xform);
        for (int n = 0; n < this.numberOfColorComponents; ++n) {
            int color = (int)input.readBits(this.bitsPerColorComponent);
            colorComponentTab[n] = this.interpolate(color, maxSrcColor, colRangeTab[n].getMin(), colRangeTab[n].getMax());
            LOG.debug("color[" + n + "]: " + color + "/" + String.format("%02x", color) + "-> color[" + n + "]: " + colorComponentTab[n]);
        }
        int bitOffset = input.getBitOffset();
        if (bitOffset != 0) {
            input.readBits(8 - bitOffset);
        }
        return new Vertex(tmp, colorComponentTab);
    }

    protected HashMap<Point, Integer> calcPixelTable() {
        HashMap<Point, Integer> map = new HashMap<Point, Integer>();
        super.calcPixelTable(this.triangleList, map);
        return map;
    }

    @Override
    public void dispose() {
        this.triangleList = null;
        this.outputColorModel = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
    }

    @Override
    public final ColorModel getColorModel() {
        return this.outputColorModel;
    }

    private float interpolate(float src, long srcMax, float dstMin, float dstMax) {
        return dstMin + src * (dstMax - dstMin) / (float)srcMax;
    }

    @Override
    public final Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        if (!this.triangleList.isEmpty() || this.background != null) {
            for (int row = 0; row < h; ++row) {
                int currentY = y + row;
                if (this.bboxRect != null && ((float)currentY < this.minBBoxY || (float)currentY > this.maxBBoxY)) continue;
                for (int col = 0; col < w; ++col) {
                    int value;
                    int currentX = x + col;
                    if (this.bboxRect != null && ((float)currentX < this.minBBoxX || (float)currentX > this.maxBBoxX)) continue;
                    Point p = new Point(currentX, currentY);
                    if (this.pixelTable.containsKey(p)) {
                        value = this.pixelTable.get(p);
                    } else {
                        if (this.background == null) continue;
                        value = this.rgbBackground;
                    }
                    int index = (row * w + col) * 4;
                    data[index] = value & 0xFF;
                    data[index + 1] = (value >>= 8) & 0xFF;
                    data[index + 2] = (value >>= 8) & 0xFF;
                    data[index + 3] = 255;
                }
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

