/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.model.EditorSplitSubModel;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.openide.util.WeakSet;

class SplitSubModel {
    protected final Model parentModel;
    private final Set<ModeNode> nodes = new WeakSet(20);
    protected Node root;
    private static final boolean DEBUG = Debug.isLoggable(SplitSubModel.class);

    public SplitSubModel(Model model) {
        this.parentModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModeNode getModeNode(ModeImpl modeImpl) {
        ModeNode modeNode = null;
        Set<ModeNode> set = this.nodes;
        synchronized (set) {
            for (ModeNode modeNode2 : this.nodes) {
                if (!modeNode2.getMode().equals(modeImpl)) continue;
                modeNode = modeNode2;
                break;
            }
            if (null == modeNode) {
                modeNode = new ModeNode(modeImpl);
                this.nodes.add(modeNode);
            }
            return modeNode;
        }
    }

    public SplitConstraint[] getModelElementConstraints(ModelElement modelElement) {
        if (modelElement instanceof Node) {
            Node node = (Node)modelElement;
            if (!this.isInTree(node)) {
                return null;
            }
            return node.getNodeConstraints();
        }
        return null;
    }

    public SplitConstraint[] getModeConstraints(ModeImpl modeImpl) {
        ModeNode modeNode = this.getModeNode(modeImpl);
        return modeNode.getNodeConstraints();
    }

    public String getSlideSideForMode(ModeImpl modeImpl) {
        ModeNode modeNode = this.getModeNode(modeImpl);
        return this.getPositionRelativeToEditor(modeNode, modeNode.getParent());
    }

    private String getPositionRelativeToEditor(Node node, SplitNode splitNode) {
        if (null == splitNode) {
            return "left";
        }
        Node node2 = this.getEditorChildNode(splitNode);
        if (null != node2) {
            int n = splitNode.getOrientation();
            int n2 = splitNode.getChildIndex(node);
            int n3 = splitNode.getChildIndex(node2);
            if (n == 0) {
                if (n2 > n3) {
                    return "bottom";
                }
                return "top";
            }
            if (n2 < n3) {
                return "left";
            }
            return "right";
        }
        return this.getPositionRelativeToEditor(splitNode, splitNode.getParent());
    }

    private Node getEditorChildNode(SplitNode splitNode) {
        List<Node> list = splitNode.getChildren();
        for (Node node : list) {
            if (!(node instanceof EditorSplitSubModel.EditorNode) && (!(node instanceof SplitNode) || null == this.getEditorChildNode((SplitNode)node))) continue;
            return node;
        }
        return null;
    }

    public boolean addMode(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        if (modeImpl == null || splitConstraintArray == null) {
            Logger.getLogger(SplitSubModel.class.getName()).log(Level.WARNING, null, new IllegalArgumentException("Mode=" + modeImpl + " constraints=" + Arrays.toString(splitConstraintArray)));
            return false;
        }
        ModeNode modeNode = this.getModeNode(modeImpl);
        if (DEBUG) {
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("==========================================");
            SplitSubModel.debugLog("Adding mode to tree=" + modeImpl);
            SplitSubModel.debugLog("constraints=" + Arrays.asList(splitConstraintArray));
            SplitSubModel.debugLog("modeNode=" + modeNode);
        }
        return this.addNodeToTree(modeNode, splitConstraintArray);
    }

    public boolean addModeToSide(ModeImpl modeImpl, ModeImpl modeImpl2, String string) {
        if (modeImpl == null || modeImpl.getState() == 1) {
            Logger.getLogger(SplitSubModel.class.getName()).log(Level.WARNING, null, new IllegalArgumentException("Mode=" + modeImpl));
            return false;
        }
        ModeNode modeNode = this.getModeNode(modeImpl);
        ModeNode modeNode2 = this.getModeNode(modeImpl2);
        if (DEBUG) {
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("==========================================");
            SplitSubModel.debugLog("Adding mode to between=" + modeImpl);
            SplitSubModel.debugLog("attachMode=" + modeImpl2);
            SplitSubModel.debugLog("side=" + string);
        }
        return this.addNodeToTreeToSide(modeNode, modeNode2, string);
    }

    public boolean addModeToSideRoot(ModeImpl modeImpl, String string) {
        if (modeImpl == null || modeImpl.getState() == 1) {
            Logger.getLogger(SplitSubModel.class.getName()).log(Level.WARNING, null, new IllegalArgumentException("Mode=" + modeImpl));
            return false;
        }
        ModeNode modeNode = this.getModeNode(modeImpl);
        if (DEBUG) {
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("==========================================");
            SplitSubModel.debugLog("Adding mode to root's side=" + modeImpl);
            SplitSubModel.debugLog("side=" + string);
        }
        return this.addNodeToTreeToSide(modeNode, this.root, string);
    }

    public boolean addModeAround(ModeImpl modeImpl, String string) {
        if (modeImpl == null || modeImpl.getState() == 1) {
            Logger.getLogger(SplitSubModel.class.getName()).log(Level.WARNING, null, new IllegalArgumentException("Mode=" + modeImpl));
            return false;
        }
        ModeNode modeNode = this.getModeNode(modeImpl);
        if (DEBUG) {
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("==========================================");
            SplitSubModel.debugLog("Adding mode to around=" + modeImpl);
            SplitSubModel.debugLog("side=" + string);
        }
        return this.addNodeToTreeAround(modeNode, string);
    }

    public boolean addModeAroundEditor(ModeImpl modeImpl, String string) {
        if (modeImpl == null || modeImpl.getState() == 1) {
            Logger.getLogger(SplitSubModel.class.getName()).log(Level.WARNING, null, new IllegalArgumentException("Mode=" + modeImpl));
            return false;
        }
        ModeNode modeNode = this.getModeNode(modeImpl);
        if (DEBUG) {
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("==========================================");
            SplitSubModel.debugLog("Adding mode to around=" + modeImpl);
            SplitSubModel.debugLog("side=" + string);
        }
        return this.addNodeToTreeAroundEditor(modeNode, string);
    }

    private boolean isInTree(Node node) {
        if (this.root == null) {
            return false;
        }
        if (node == this.root) {
            return true;
        }
        for (SplitNode splitNode = node.getParent(); splitNode != null; splitNode = splitNode.getParent()) {
            if (splitNode != this.root) continue;
            return true;
        }
        return false;
    }

    protected boolean addNodeToTree(Node node, SplitConstraint[] splitConstraintArray) {
        SplitNode splitNode;
        if (this.isInTree(node)) {
            return false;
        }
        if (this.root == null) {
            if (splitConstraintArray.length == 0) {
                this.root = node;
                return true;
            }
            splitNode = new SplitNode(splitConstraintArray[0].orientation);
            this.root = splitNode;
        } else if (this.root instanceof SplitNode) {
            splitNode = (SplitNode)this.root;
        } else {
            splitNode = new SplitNode(0);
            splitNode.setChildAt(-1, 0.5, this.root);
            this.root = splitNode;
        }
        for (int i = 0; i < splitConstraintArray.length; ++i) {
            int n = splitConstraintArray[i].orientation;
            if (n != splitNode.getOrientation()) {
                SplitNode splitNode2 = new SplitNode(n);
                if (splitNode == this.root) {
                    splitNode2.setChildAt(-1, 0.5, splitNode);
                    this.root = splitNode2;
                } else {
                    SplitNode splitNode3 = splitNode.getParent();
                    int n2 = splitNode3.getChildIndex(splitNode);
                    double d = splitNode3.getChildSplitWeight(splitNode);
                    splitNode3.removeChild(splitNode);
                    splitNode2.setChildAt(-1, 0.5, splitNode);
                    splitNode3.setChildAt(n2, d, splitNode2);
                }
                splitNode = splitNode2;
            }
            if (i >= splitConstraintArray.length - 1) continue;
            int n3 = splitConstraintArray[i].index;
            double d = splitConstraintArray[i].splitWeight;
            Node node2 = splitNode.getChildAt(n3);
            if (node2 instanceof SplitNode) {
                splitNode = (SplitNode)node2;
                continue;
            }
            SplitNode splitNode4 = new SplitNode(splitConstraintArray[i + 1].orientation);
            splitNode.setChildAt(n3, d, splitNode4);
            splitNode = splitNode4;
        }
        if (splitConstraintArray.length == 0) {
            splitNode.setChildAt(-1, 0.5, node);
        } else {
            splitNode.setChildAt(splitConstraintArray[splitConstraintArray.length - 1].index, splitConstraintArray[splitConstraintArray.length - 1].splitWeight, node);
        }
        this.verifyNode(this.root);
        return true;
    }

    private boolean addNodeToTreeToSide(Node node, Node node2, String string) {
        if (this.isInTree(node)) {
            return false;
        }
        if (!this.isInTree(node2)) {
            return false;
        }
        if (DEBUG) {
            SplitSubModel.debugLog("");
            SplitSubModel.debugLog("Inserting to side=" + string);
        }
        if (node2 == this.root) {
            int n = string == "top" || string == "left" ? 0 : -1;
            int n2 = n == 0 ? -1 : 0;
            int n3 = string == "top" || string == "bottom" ? 0 : 1;
            SplitNode splitNode = new SplitNode(n3);
            splitNode.setChildAt(n, 0.5, node);
            splitNode.setChildAt(n2, 0.5, node2);
            this.root = splitNode;
        } else {
            int n;
            SplitNode splitNode = node2.getParent();
            if (splitNode == null) {
                return false;
            }
            int n4 = splitNode.getChildIndex(node2);
            double d = splitNode.getChildSplitWeight(node2);
            int n5 = n = string == "top" || string == "bottom" ? 0 : 1;
            if (n == splitNode.getOrientation()) {
                if (string == "bottom" || string == "right") {
                    ++n4;
                }
                if (splitNode.getChildren().size() == 1) {
                    splitNode.setChildSplitWeight(node2, 0.5);
                }
                splitNode.setChildAt(n4, 0.5, node);
            } else {
                SplitNode splitNode2 = new SplitNode(n);
                splitNode.removeChild(node2);
                int n6 = string == "top" || string == "left" ? 0 : -1;
                int n7 = n6 == 0 ? -1 : 0;
                splitNode2.setChildAt(n6, 0.5, node);
                splitNode2.setChildAt(n7, 0.5, node2);
                splitNode.setChildAt(n4, d, splitNode2);
            }
        }
        return true;
    }

    private boolean addNodeToTreeAround(Node node, String string) {
        SplitConstraint[] splitConstraintArray;
        Node node2 = this.root;
        if (node2 instanceof SplitNode) {
            SplitNode splitNode = (SplitNode)node2;
            if (splitNode.getOrientation() == 0 && (string == "top" || string == "bottom") || splitNode.getOrientation() == 1 && (string == "left" || string == "right")) {
                double d = 0.0;
                for (Node node3 : splitNode.getChildren()) {
                    d += splitNode.getChildSplitWeight(node3);
                }
                double d2 = d * 0.25;
                int n = string == "top" || string == "left" ? 0 : -1;
                splitNode.setChildAt(n, d2, node);
                if (d2 > 1.0) {
                    double d3 = 1.0 / d2;
                    splitNode.normalizeWeights(d3);
                }
                return true;
            }
            int n = string == "top" || string == "bottom" ? 0 : 1;
            SplitNode splitNode2 = new SplitNode(n);
            int n2 = string == "top" || string == "left" ? 0 : -1;
            int n3 = n2 == 0 ? -1 : 0;
            splitNode2.setChildAt(n2, 0.25, node);
            splitNode2.setChildAt(n3, 0.75, splitNode);
            this.root = splitNode2;
            return true;
        }
        if (string == "top") {
            splitConstraintArray = new SplitConstraint[]{new SplitConstraint(0, 0, 0.25)};
        } else if (string == "bottom") {
            splitConstraintArray = new SplitConstraint[]{new SplitConstraint(0, -1, 0.25)};
        } else if (string == "left") {
            splitConstraintArray = new SplitConstraint[]{new SplitConstraint(1, 0, 0.25)};
        } else if (string == "right") {
            splitConstraintArray = new SplitConstraint[]{new SplitConstraint(1, -1, 0.25)};
        } else {
            return false;
        }
        return this.addNodeToTree(node, splitConstraintArray);
    }

    protected boolean addNodeToTreeAroundEditor(Node node, String string) {
        return false;
    }

    public boolean removeMode(ModeImpl modeImpl) {
        if (modeImpl == null) {
            throw new NullPointerException("Cannot remove null mode!");
        }
        return this.removeNodeFromTree(this.getModeNode(modeImpl));
    }

    protected boolean removeNodeFromTree(Node node) {
        if (!this.isInTree(node)) {
            return false;
        }
        SplitNode splitNode = node.getParent();
        if (splitNode == null && node != this.root) {
            return false;
        }
        if (node == this.root) {
            this.root = null;
        } else {
            splitNode.removeChild(node);
            List<Node> list = splitNode.getChildren();
            if (list.isEmpty()) {
                if (splitNode == this.root) {
                    this.root = null;
                } else {
                    SplitNode splitNode2 = splitNode.getParent();
                    splitNode2.removeChild(splitNode);
                }
            } else if (list.size() == 1) {
                Node node2 = list.get(0);
                if (splitNode == this.root) {
                    node2.setParent(null);
                    this.root = node2;
                } else {
                    SplitNode splitNode3 = splitNode.getParent();
                    int n = splitNode3.getChildIndex(splitNode);
                    double d = splitNode3.getChildSplitWeight(splitNode);
                    splitNode3.removeChild(splitNode);
                    splitNode3.setChildAt(n, d, node2);
                }
            }
        }
        this.verifyNode(this.root);
        return true;
    }

    private void verifyNode(Node node) {
        if (node instanceof SplitNode) {
            SplitNode splitNode = (SplitNode)node;
            for (Node node2 : splitNode.getChildren()) {
                if (node2.getParent() != splitNode) {
                    Logger.getLogger(SplitSubModel.class.getName()).log(Level.WARNING, null, new IllegalStateException("Node->" + node2 + " has wrong parent->" + node2.getParent() + " is has to be->" + splitNode + " \nModel: " + this.toString()));
                    node2.setParent(splitNode);
                }
                this.verifyNode(node2);
            }
        }
    }

    public void reset() {
        SplitSubModel.detachNodes(this.root);
        this.root = null;
    }

    private static void detachNodes(Node node) {
        if (node instanceof SplitNode) {
            SplitNode splitNode = (SplitNode)node;
            for (Node node2 : splitNode.getChildren()) {
                splitNode.removeChild(node2);
                SplitSubModel.detachNodes(node2);
            }
        }
    }

    public boolean setSplitWeights(ModelElement[] modelElementArray, double[] dArray) {
        Node node;
        if (0 == modelElementArray.length) {
            return false;
        }
        for (int i = 0; i < modelElementArray.length; ++i) {
            node = (Node)modelElementArray[i];
            if (null != node && null != node.getParent()) continue;
            return false;
        }
        Node node2 = (Node)modelElementArray[0];
        node = node2.getParent();
        if (node == null || !this.isInTree(node)) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < modelElementArray.length; ++i) {
            Node node3 = (Node)modelElementArray[i];
            double d = dArray[i];
            SplitNode splitNode = node3.getParent();
            if (null == splitNode || !this.isInTree(splitNode)) {
                bl = false;
                continue;
            }
            splitNode.setChildSplitWeight(node3, d);
        }
        return bl;
    }

    public ModeStructureSnapshot.ElementSnapshot createSplitSnapshot() {
        return this.root == null ? null : this.root.createSnapshot();
    }

    public Set<ModeStructureSnapshot.ModeSnapshot> createSeparateSnapshots() {
        return this.findSeparateModeSnapshots(this.root);
    }

    private Set<ModeStructureSnapshot.ModeSnapshot> findSeparateModeSnapshots(Node node) {
        HashSet<ModeStructureSnapshot.ModeSnapshot> hashSet = new HashSet<ModeStructureSnapshot.ModeSnapshot>();
        if (node instanceof ModeNode) {
            ModeNode modeNode = (ModeNode)node;
            if (modeNode.isVisibleSeparate()) {
                hashSet.add((ModeStructureSnapshot.ModeSnapshot)modeNode.createSnapshot());
            }
        } else if (node instanceof SplitNode) {
            SplitNode splitNode = (SplitNode)node;
            for (Node node2 : splitNode.getChildren()) {
                hashSet.addAll(this.findSeparateModeSnapshots(node2));
            }
        }
        return hashSet;
    }

    public String toString() {
        return SplitSubModel.dumpNode(this.root, 0, null);
    }

    private static String dumpNode(Node node, int n, String string) {
        ++n;
        if (node == null) {
            return "NULL NODE\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append("\n");
        }
        StringBuffer stringBuffer2 = SplitSubModel.getOffset(n);
        if (node instanceof ModeNode) {
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("<mode-node");
            stringBuffer.append(" [" + Integer.toHexString(System.identityHashCode(node)) + "]");
            stringBuffer.append(" index=\"");
            if (node.getParent() != null) {
                stringBuffer.append(node.getParent().getChildIndex(node));
            }
            stringBuffer.append(" splitWeight=");
            if (node.getParent() != null) {
                stringBuffer.append(node.getParent().getChildSplitWeight(node));
            }
            stringBuffer.append("\"");
            stringBuffer.append(" state=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
            stringBuffer.append(" name=\"" + ((ModeNode)node).getMode().getName() + "\"");
            stringBuffer.append(" parent=");
            stringBuffer.append(node.getParent() == null ? null : "[" + Integer.toHexString(node.getParent().hashCode()) + "]");
            stringBuffer.append(" constraints='" + Arrays.asList(node.getNodeConstraints()) + "\"");
            stringBuffer.append("</mode-node>\n");
        } else if (node instanceof SplitNode) {
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("<split-node");
            stringBuffer.append(" [" + Integer.toHexString(System.identityHashCode(node)) + "]");
            stringBuffer.append(" index=\"");
            if (node.getParent() != null) {
                stringBuffer.append(node.getParent().getChildIndex(node));
            }
            stringBuffer.append(" splitWeight=");
            if (node.getParent() != null) {
                stringBuffer.append(node.getParent().getChildSplitWeight(node));
            }
            stringBuffer.append("\"");
            SplitNode splitNode = (SplitNode)node;
            stringBuffer.append(" state=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" orientation=\"");
            stringBuffer.append(splitNode.getOrientation());
            stringBuffer.append("\">\n");
            int n2 = 0;
            for (Node node2 : splitNode.getChildren()) {
                stringBuffer.append(SplitSubModel.dumpNode(node2, n, "child[" + n2 + "]"));
                ++n2;
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("</split-node>\n");
        } else {
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("<editor-node");
            stringBuffer.append(" [" + Integer.toHexString(System.identityHashCode(node)) + "]");
            stringBuffer.append(" index=\"");
            if (node.getParent() != null) {
                stringBuffer.append(node.getParent().getChildIndex(node));
            }
            stringBuffer.append("\"");
            stringBuffer.append(" splitWeight=");
            if (node.getParent() != null) {
                stringBuffer.append(node.getParent().getChildSplitWeight(node));
            }
            stringBuffer.append(" parent=");
            stringBuffer.append(node.getParent() == null ? null : "[" + Integer.toHexString(node.getParent().hashCode()) + "]");
            stringBuffer.append("</editor-node>\n");
        }
        return stringBuffer.toString();
    }

    private static StringBuffer getOffset(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("\t");
        }
        return stringBuffer;
    }

    public ModeImpl getModeForOriginator(ModelElement modelElement) {
        if (modelElement instanceof ModeNode) {
            return ((ModeNode)modelElement).getMode();
        }
        return null;
    }

    private static void debugLog(String string) {
        Debug.log(SplitSubModel.class, string);
    }

    private static class ModeNode
    extends Node {
        private final ModeImpl mode;

        public ModeNode(ModeImpl modeImpl) {
            this.mode = modeImpl;
        }

        public ModeImpl getMode() {
            return this.mode;
        }

        @Override
        public boolean isVisibleInSplit() {
            WindowManagerImpl windowManagerImpl;
            if (this.mode.getOpenedTopComponents().isEmpty()) {
                return false;
            }
            if (this.mode.getState() == 1) {
                return false;
            }
            return this.mode.getKind() != 1 || null == (windowManagerImpl = WindowManagerImpl.getInstance()).getEditorMaximizedMode() || windowManagerImpl.getEditorMaximizedMode() == this.mode;
        }

        public boolean isVisibleSeparate() {
            if (this.mode.getOpenedTopComponents().isEmpty()) {
                return false;
            }
            return this.mode.getState() != 0;
        }

        @Override
        public double getResizeWeight() {
            return 0.0;
        }

        @Override
        public ModeStructureSnapshot.ElementSnapshot createSnapshot() {
            return new ModeStructureSnapshot.ModeSnapshot(this, null, this.mode, this.getResizeWeight());
        }
    }

    protected static class SplitNode
    extends Node {
        private final int orientation;
        private final TreeMap<Integer, Node> index2child = new TreeMap();
        private final Map<Node, Double> child2splitWeight = new HashMap<Node, Double>();

        public SplitNode(int n) {
            this.orientation = n;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            for (Integer n : this.index2child.keySet()) {
                Node node = this.index2child.get(n);
                stringBuffer.append("child[" + n + "]=" + node.getClass() + "@" + Integer.toHexString(node.hashCode()));
            }
            return stringBuffer.toString();
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setChildAt(int n, double d, Node node) {
            if (n == -1) {
                n = this.index2child.isEmpty() ? 0 : this.index2child.lastKey() + 1;
            }
            Integer n2 = n;
            Node node2 = this.index2child.get(n2);
            int n3 = n2 + 1;
            while (node2 != null) {
                node2 = this.index2child.put(n3, node2);
                ++n3;
            }
            this.index2child.put(n2, node);
            this.setChildSplitWeightImpl(node, d);
            node.setParent(this);
            this.verifyChildren();
        }

        public Node getChildAt(int n) {
            return this.index2child.get(n);
        }

        private void verifyChildren() {
            for (Node node : this.index2child.values()) {
                if (node.getParent() == this) continue;
                Logger.getLogger(SplitSubModel.class.getName()).log(Level.WARNING, null, new IllegalStateException("Node " + node + " is a child in split " + this + " but his parent is " + node.getParent() + ". Repairing"));
                node.setParent(this);
            }
        }

        public double getChildSplitWeight(Node node) {
            Double d = this.child2splitWeight.get(node);
            if (d != null) {
                return d;
            }
            return -1.0;
        }

        public void setChildSplitWeight(Node node, double d) {
            if (node == null || !this.child2splitWeight.containsKey(node)) {
                return;
            }
            this.setChildSplitWeightImpl(node, d);
        }

        private void setChildSplitWeightImpl(Node node, double d) {
            this.child2splitWeight.put(node, d);
        }

        private void normalizeWeights(double d) {
            for (Map.Entry<Node, Double> entry : this.child2splitWeight.entrySet()) {
                double d2 = entry.getValue();
                d2 = d * d2;
                entry.setValue(d2);
            }
        }

        public int getChildIndex(Node node) {
            for (Integer n : this.index2child.keySet()) {
                if (node != this.index2child.get(n)) continue;
                return n;
            }
            return -1;
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.index2child.values());
        }

        public List<Node> getVisibleChildren() {
            List<Node> list = this.getChildren();
            Iterator<Node> iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                if (node.hasVisibleDescendant()) continue;
                iterator.remove();
            }
            return list;
        }

        protected boolean removeChild(Node node) {
            boolean bl = this.index2child.values().remove(node);
            this.child2splitWeight.remove(node);
            node.setParent(null);
            return bl;
        }

        @Override
        public boolean isVisibleInSplit() {
            int n = 0;
            for (Node node : this.index2child.values()) {
                if (!node.hasVisibleDescendant() || ++n < 2) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasVisibleDescendant() {
            for (Node node : this.index2child.values()) {
                if (!node.hasVisibleDescendant()) continue;
                return true;
            }
            return false;
        }

        @Override
        public double getResizeWeight() {
            List<Node> list = this.getVisibleChildren();
            double d = 0.0;
            Iterator<Node> iterator = list.iterator();
            while (iterator.hasNext()) {
                double d2 = iterator.next().getResizeWeight();
                d = Math.max(d, d2);
            }
            return d;
        }

        @Override
        public ModeStructureSnapshot.ElementSnapshot createSnapshot() {
            ArrayList<ModeStructureSnapshot.ElementSnapshot> arrayList = new ArrayList<ModeStructureSnapshot.ElementSnapshot>();
            HashMap<ModeStructureSnapshot.ElementSnapshot, Double> hashMap = new HashMap<ModeStructureSnapshot.ElementSnapshot, Double>();
            for (Node object : this.getChildren()) {
                ModeStructureSnapshot.ElementSnapshot elementSnapshot = object.createSnapshot();
                arrayList.add(elementSnapshot);
                hashMap.put(elementSnapshot, this.child2splitWeight.get(object));
            }
            ModeStructureSnapshot.SplitSnapshot splitSnapshot = new ModeStructureSnapshot.SplitSnapshot(this, null, this.getOrientation(), arrayList, hashMap, this.getResizeWeight());
            for (ModeStructureSnapshot.ElementSnapshot elementSnapshot : arrayList) {
                elementSnapshot.setParent(splitSnapshot);
            }
            return splitSnapshot;
        }
    }

    protected static abstract class Node
    implements ModelElement {
        private SplitNode parent;

        public String toString() {
            return super.toString() + "[parent=" + (this.parent == null ? null : this.parent.getClass() + "@" + Integer.toHexString(this.parent.hashCode())) + "]";
        }

        public void setParent(SplitNode splitNode) {
            if (this.parent == splitNode) {
                return;
            }
            this.parent = splitNode;
        }

        public SplitNode getParent() {
            return this.parent;
        }

        public abstract double getResizeWeight();

        public SplitConstraint[] getNodeConstraints() {
            Node node = this;
            ArrayList<SplitConstraint> arrayList = new ArrayList<SplitConstraint>(5);
            do {
                SplitConstraint splitConstraint;
                if ((splitConstraint = Node.getConstraintForNode(node)) == null) continue;
                arrayList.add(splitConstraint);
            } while ((node = node.getParent()) != null);
            Collections.reverse(arrayList);
            return arrayList.toArray(new SplitConstraint[0]);
        }

        private static SplitConstraint getConstraintForNode(Node node) {
            SplitNode splitNode = node.getParent();
            if (splitNode != null) {
                return new SplitConstraint(splitNode.getOrientation(), splitNode.getChildIndex(node), splitNode.getChildSplitWeight(node));
            }
            return null;
        }

        public boolean isVisibleInSplit() {
            return false;
        }

        public boolean hasVisibleDescendant() {
            return this.isVisibleInSplit();
        }

        public abstract ModeStructureSnapshot.ElementSnapshot createSnapshot();
    }
}

