//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Glacier2;

/**
 * The Glacier2 specialization of the <code>Ice::Router</code> interface.
 **/
public interface RouterPrx extends com.zeroc.Ice.RouterPrx
{
    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @return The category.
     **/
    default String getCategoryForClient()
    {
        return getCategoryForClient(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @return The category.
     **/
    default String getCategoryForClient(java.util.Map<String, String> context)
    {
        return _iceI_getCategoryForClientAsync(context, true).waitForResponse();
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @return The category.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getCategoryForClientAsync()
    {
        return _iceI_getCategoryForClientAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @return The category.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getCategoryForClientAsync(java.util.Map<String, String> context)
    {
        return _iceI_getCategoryForClientAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.String> _iceI_getCategoryForClientAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.String> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getCategoryForClient", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String ret;
                     ret = istr.readString();
                     return ret;
                 });
        return f;
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default SessionPrx createSession(String userId, String password)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        return createSession(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default SessionPrx createSession(String userId, String password, java.util.Map<String, String> context)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        try
        {
            return _iceI_createSessionAsync(userId, password, context, true).waitForResponseOrUserEx();
        }
        catch(CannotCreateSessionException ex)
        {
            throw ex;
        }
        catch(PermissionDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionAsync(String userId, String password)
    {
        return _iceI_createSessionAsync(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionAsync(String userId, String password, java.util.Map<String, String> context)
    {
        return _iceI_createSessionAsync(userId, password, context, false);
    }

    /**
     * @hidden
     * @param iceP_userId -
     * @param iceP_password -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<SessionPrx> _iceI_createSessionAsync(String iceP_userId, String iceP_password, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<SessionPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "createSession", null, sync, _iceE_createSession);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_userId);
                     ostr.writeString(iceP_password);
                 }, istr -> {
                     SessionPrx ret;
                     ret = SessionPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_createSession =
    {
        CannotCreateSessionException.class,
        PermissionDeniedException.class
    };

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default SessionPrx createSessionFromSecureConnection()
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        return createSessionFromSecureConnection(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default SessionPrx createSessionFromSecureConnection(java.util.Map<String, String> context)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        try
        {
            return _iceI_createSessionFromSecureConnectionAsync(context, true).waitForResponseOrUserEx();
        }
        catch(CannotCreateSessionException ex)
        {
            throw ex;
        }
        catch(PermissionDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionFromSecureConnectionAsync()
    {
        return _iceI_createSessionFromSecureConnectionAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     *
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     **/
    default java.util.concurrent.CompletableFuture<SessionPrx> createSessionFromSecureConnectionAsync(java.util.Map<String, String> context)
    {
        return _iceI_createSessionFromSecureConnectionAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<SessionPrx> _iceI_createSessionFromSecureConnectionAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<SessionPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "createSessionFromSecureConnection", null, sync, _iceE_createSessionFromSecureConnection);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, null, istr -> {
                     SessionPrx ret;
                     ret = SessionPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_createSessionFromSecureConnection =
    {
        CannotCreateSessionException.class,
        PermissionDeniedException.class
    };

    /**
     * Keep the calling client's session with this router alive.
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     **/
    default void refreshSession()
        throws SessionNotExistException
    {
        refreshSession(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     **/
    default void refreshSession(java.util.Map<String, String> context)
        throws SessionNotExistException
    {
        try
        {
            _iceI_refreshSessionAsync(context, true).waitForResponseOrUserEx();
        }
        catch(SessionNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Keep the calling client's session with this router alive.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> refreshSessionAsync()
    {
        return _iceI_refreshSessionAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> refreshSessionAsync(java.util.Map<String, String> context)
    {
        return _iceI_refreshSessionAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_refreshSessionAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "refreshSession", null, sync, _iceE_refreshSession);
        f.invoke(true, context, null, null, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_refreshSession =
    {
        SessionNotExistException.class
    };

    /**
     * Destroy the calling client's session with this router.
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     **/
    default void destroySession()
        throws SessionNotExistException
    {
        destroySession(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     **/
    default void destroySession(java.util.Map<String, String> context)
        throws SessionNotExistException
    {
        try
        {
            _iceI_destroySessionAsync(context, true).waitForResponseOrUserEx();
        }
        catch(SessionNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Destroy the calling client's session with this router.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> destroySessionAsync()
    {
        return _iceI_destroySessionAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> destroySessionAsync(java.util.Map<String, String> context)
    {
        return _iceI_destroySessionAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_destroySessionAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "destroySession", null, sync, _iceE_destroySession);
        f.invoke(true, context, null, null, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_destroySession =
    {
        SessionNotExistException.class
    };

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @return The timeout (in seconds).
     **/
    default long getSessionTimeout()
    {
        return getSessionTimeout(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     **/
    default long getSessionTimeout(java.util.Map<String, String> context)
    {
        return _iceI_getSessionTimeoutAsync(context, true).waitForResponse();
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @return The timeout (in seconds).
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Long> getSessionTimeoutAsync()
    {
        return _iceI_getSessionTimeoutAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Long> getSessionTimeoutAsync(java.util.Map<String, String> context)
    {
        return _iceI_getSessionTimeoutAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Long> _iceI_getSessionTimeoutAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Long> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getSessionTimeout", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     long ret;
                     ret = istr.readLong();
                     return ret;
                 });
        return f;
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @return The timeout (in seconds).
     **/
    default int getACMTimeout()
    {
        return getACMTimeout(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     **/
    default int getACMTimeout(java.util.Map<String, String> context)
    {
        return _iceI_getACMTimeoutAsync(context, true).waitForResponse();
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @return The timeout (in seconds).
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getACMTimeoutAsync()
    {
        return _iceI_getACMTimeoutAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> getACMTimeoutAsync(java.util.Map<String, String> context)
    {
        return _iceI_getACMTimeoutAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> _iceI_getACMTimeoutAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getACMTimeout", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     int ret;
                     ret = istr.readInt();
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RouterPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static RouterPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static RouterPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, RouterPrx.class, _RouterPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default RouterPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (RouterPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default RouterPrx ice_adapterId(String newAdapterId)
    {
        return (RouterPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default RouterPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (RouterPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default RouterPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (RouterPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default RouterPrx ice_invocationTimeout(int newTimeout)
    {
        return (RouterPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default RouterPrx ice_connectionCached(boolean newCache)
    {
        return (RouterPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default RouterPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (RouterPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RouterPrx ice_secure(boolean b)
    {
        return (RouterPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default RouterPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (RouterPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RouterPrx ice_preferSecure(boolean b)
    {
        return (RouterPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default RouterPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (RouterPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default RouterPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (RouterPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default RouterPrx ice_collocationOptimized(boolean b)
    {
        return (RouterPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default RouterPrx ice_twoway()
    {
        return (RouterPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default RouterPrx ice_oneway()
    {
        return (RouterPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default RouterPrx ice_batchOneway()
    {
        return (RouterPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default RouterPrx ice_datagram()
    {
        return (RouterPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default RouterPrx ice_batchDatagram()
    {
        return (RouterPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default RouterPrx ice_compress(boolean co)
    {
        return (RouterPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default RouterPrx ice_timeout(int t)
    {
        return (RouterPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default RouterPrx ice_connectionId(String connectionId)
    {
        return (RouterPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default RouterPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (RouterPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::Glacier2::Router";
    }
}
