import buble from 'rollup-plugin-buble'
import {resolve} from 'path'

var acorn = resolve('src/index.js')
var paths = {}, globals = {}
paths[acorn] = './acorn'
globals[acorn] = 'acorn'

export default {
  entry: 'src/loose/index.js',
  moduleName: 'acorn.loose',
  external: [ acorn ],
  paths: paths,
  globals: globals,
  targets: [
    { dest: 'dist/acorn_loose.js', format: 'umd' }
  ],
  plugins: [
    buble({
      transforms: {
	dangerousForOf: true
      }
    })
  ]
}
