/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.dsl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.sourceforge.cobertura.check.CoverageThreshold;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.dsl.Arguments;
import net.sourceforge.cobertura.instrument.CoberturaFile;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.RegexUtil;
import org.apache.oro.text.regex.Pattern;

public class ArgumentsBuilder {
    static final String DEFAULT_ENCODING = "UTF-8";
    static final double DEFAULT_THRESHOLD = 0.0;
    static final boolean DEFAULT_CALCULATE_METHOD_COMPLEXITY = false;
    static final boolean DEFAULT_FAIL_ON_ERROR = false;
    static final boolean DEFAULT_IGNORE_TRIVIAL = false;
    static final boolean DEFAULT_THREADSAFE_RIGOROUS = false;
    private Arguments arguments;
    private String baseDirectory;
    private File dataFile;
    private File destinationDirectory;
    private File commandsFile;
    private List<CodeSource> sources;
    private Collection ignoreRegexes;
    private Collection<Pattern> ignoreBranchesRegexes;
    private Collection<Pattern> classPatternIncludeClassesRegexes;
    private Collection<Pattern> classPatternExcludeClassesRegexes;
    private boolean calculateMethodComplexity;
    private boolean failOnError;
    private boolean ignoreTrivial;
    private boolean threadsafeRigorous;
    private String encoding;
    private Set<CoverageThreshold> minimumCoverageThresholds;
    private double classLineThreshold;
    private double classBranchThreshold;
    private double packageLineThreshold;
    private double packageBranchThreshold;
    private double totalLineThreshold;
    private double totalBranchThreshold;
    private Set<CoberturaFile> filesToInstrument;
    private Set<File> filesToMerge;
    private Set<String> ignoreMethodAnnotations;
    private Set<String> ignoreClassAnnotations;

    public ArgumentsBuilder() {
        this.initVariables();
    }

    public ArgumentsBuilder setBaseDirectory(String baseDir) {
        this.baseDirectory = baseDir;
        return this;
    }

    public ArgumentsBuilder setDataFile(String dataFile) {
        this.dataFile = new File(dataFile);
        return this;
    }

    public ArgumentsBuilder setDestinationDirectory(String destinationDir) {
        this.destinationDirectory = new File(destinationDir);
        return this;
    }

    public ArgumentsBuilder setCommandsFile(String commandsFile) {
        this.commandsFile = new File(commandsFile);
        return this;
    }

    public ArgumentsBuilder addIgnoreRegex(String regex) {
        RegexUtil.addRegex(this.ignoreRegexes, regex);
        return this;
    }

    public ArgumentsBuilder addIgnoreBranchRegex(String regex) {
        RegexUtil.addRegex(this.ignoreBranchesRegexes, regex);
        return this;
    }

    public ArgumentsBuilder addIgnoreMethodAnnotation(String ignoreMethodAnnotation) {
        this.ignoreMethodAnnotations.add(ignoreMethodAnnotation);
        return this;
    }

    public ArgumentsBuilder addIgnoreClassAnnotation(String ignoreClassAnnotation) {
        this.ignoreClassAnnotations.add(ignoreClassAnnotation);
        return this;
    }

    public ArgumentsBuilder addExcludeClassesRegex(String regex) {
        RegexUtil.addRegex(this.classPatternExcludeClassesRegexes, regex);
        return this;
    }

    public ArgumentsBuilder addIncludeClassesRegex(String regex) {
        RegexUtil.addRegex(this.classPatternIncludeClassesRegexes, regex);
        return this;
    }

    public ArgumentsBuilder calculateMethodComplexity(boolean calculateMethodComplexity) {
        this.calculateMethodComplexity = calculateMethodComplexity;
        return this;
    }

    public ArgumentsBuilder failOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public ArgumentsBuilder ignoreTrivial(boolean ignoreTrivial) {
        this.ignoreTrivial = ignoreTrivial;
        return this;
    }

    public ArgumentsBuilder threadsafeRigorous(boolean threadsafeRigorous) {
        this.threadsafeRigorous = threadsafeRigorous;
        return this;
    }

    public ArgumentsBuilder listOfFilesToInstrument(String listFileName) {
        String baseDir = this.getBaseDirectory();
        try {
            String line;
            File file = new File(listFileName);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                line = line.replace(baseDir, "");
                this.filesToInstrument.add(new CoberturaFile(baseDir, line));
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public ArgumentsBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public ArgumentsBuilder addMinimumCoverageRates(String regex, double branchPercentage, double linePercentage) {
        this.minimumCoverageThresholds.add(new CoverageThreshold(regex, branchPercentage, linePercentage));
        return this;
    }

    public ArgumentsBuilder setClassBranchCoverageThreshold(double coverageThreshold) {
        this.classBranchThreshold = this.inRange(coverageThreshold);
        return this;
    }

    public ArgumentsBuilder setClassLineCoverageThreshold(double coverageThreshold) {
        this.classLineThreshold = this.inRange(coverageThreshold);
        return this;
    }

    public ArgumentsBuilder setPackageBranchCoverageThreshold(double coverageThreshold) {
        this.packageBranchThreshold = this.inRange(coverageThreshold);
        return this;
    }

    public ArgumentsBuilder setPackageLineCoverageThreshold(double coverageThreshold) {
        this.packageLineThreshold = this.inRange(coverageThreshold);
        return this;
    }

    public ArgumentsBuilder setTotalBranchCoverageThreshold(double coverageThreshold) {
        this.totalBranchThreshold = this.inRange(coverageThreshold);
        return this;
    }

    public ArgumentsBuilder setTotalLineCoverageThreshold(double coverageThreshold) {
        this.totalLineThreshold = this.inRange(coverageThreshold);
        return this;
    }

    public ArgumentsBuilder addFileToInstrument(String file) {
        String baseDir = this.getBaseDirectory();
        if (baseDir != null) {
            file = file.replace(baseDir, "");
        }
        this.filesToInstrument.add(new CoberturaFile(baseDir, file));
        return this;
    }

    public ArgumentsBuilder addFileToMerge(String file) {
        this.filesToMerge.add(new File(file));
        return this;
    }

    public ArgumentsBuilder addSources(String sourcePath, boolean isDirectory) {
        if (this.sources == null) {
            this.sources = new ArrayList<CodeSource>();
        }
        this.sources.add(new CodeSource(isDirectory, sourcePath));
        return this;
    }

    public Arguments build() {
        FileFinder sources = new FileFinder();
        if (this.sources != null) {
            for (CodeSource codeSource : this.sources) {
                if (codeSource.isDirectory()) {
                    sources.addSourceDirectory(codeSource.getPath());
                    continue;
                }
                sources.addSourceFile(this.getBaseDirectory(), codeSource.getPath());
            }
        }
        return new Arguments(this.baseDirectory, this.dataFile, this.destinationDirectory, this.commandsFile, this.ignoreRegexes, this.ignoreBranchesRegexes, this.classPatternIncludeClassesRegexes, this.classPatternExcludeClassesRegexes, this.calculateMethodComplexity, this.failOnError, this.ignoreTrivial, this.threadsafeRigorous, this.encoding, this.minimumCoverageThresholds, this.classLineThreshold, this.classBranchThreshold, this.packageLineThreshold, this.packageBranchThreshold, this.totalLineThreshold, this.totalBranchThreshold, this.filesToInstrument, this.filesToMerge, this.ignoreMethodAnnotations, this.ignoreClassAnnotations, sources);
    }

    private double inRange(double coverageRate) {
        if (coverageRate >= 0.0 && coverageRate <= 1.0) {
            return coverageRate;
        }
        throw new IllegalArgumentException(String.format("The value %s is invalid.  Rates must be between 0.0 and 1.0", coverageRate));
    }

    private void initVariables() {
        this.dataFile = CoverageDataFileHandler.getDefaultDataFile();
        this.ignoreRegexes = new Vector();
        this.ignoreBranchesRegexes = new Vector<Pattern>();
        this.ignoreMethodAnnotations = new HashSet<String>();
        this.ignoreClassAnnotations = new HashSet<String>();
        this.classPatternExcludeClassesRegexes = new HashSet<Pattern>();
        this.classPatternIncludeClassesRegexes = new HashSet<Pattern>();
        this.filesToInstrument = new HashSet<CoberturaFile>();
        this.filesToMerge = new HashSet<File>();
        this.minimumCoverageThresholds = new HashSet<CoverageThreshold>();
        this.classBranchThreshold = 0.0;
        this.classLineThreshold = 0.0;
        this.packageBranchThreshold = 0.0;
        this.packageLineThreshold = 0.0;
        this.totalBranchThreshold = 0.0;
        this.totalLineThreshold = 0.0;
        this.calculateMethodComplexity = false;
        this.failOnError = false;
        this.ignoreTrivial = false;
        this.threadsafeRigorous = false;
        this.encoding = DEFAULT_ENCODING;
    }

    private String getBaseDirectory() {
        return this.baseDirectory;
    }

    private static class CodeSource {
        private boolean directory;
        private String path;

        private CodeSource(boolean directory, String path) {
            this.directory = directory;
            this.path = path;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public String getPath() {
            return this.path;
        }
    }
}

