/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.aspectj.internal.tools.build.Sample;
import org.aspectj.internal.tools.build.SampleUtil;
import org.aspectj.internal.tools.build.Samples;
import org.aspectj.internal.tools.build.SamplesRenderer;

class HTMLSamplesRenderer
extends SamplesRenderer {
    public static SamplesRenderer ME = new HTMLSamplesRenderer();
    public static boolean doHierarchical = true;
    public static boolean doFlags = false;
    final StringBuffer tableOfContents;
    final StringBuffer sampleSection;
    String[] lastAnchor = new String[0];
    String currentAnchor;
    String currentAuthor;

    protected HTMLSamplesRenderer() {
        this.sampleSection = new StringBuffer();
        this.tableOfContents = new StringBuffer();
    }

    protected void startAnchorName(String name, String title, StringBuffer sink) {
        if (doHierarchical) {
            this.doContentTree(name);
        }
        this.tableOfContents.append("        <li><a href=\"#" + name);
        if (null == title || 0 == title.length()) {
            title = name;
        }
        this.tableOfContents.append("\">" + title + "</a></li>");
        this.tableOfContents.append("\n");
        this.currentAnchor = name;
    }

    protected void startList(Samples samples, StringBuffer sink) {
    }

    protected void render(Sample sample, StringBuffer sink) {
        if (null != this.currentAnchor) {
            if (!this.currentAnchor.equals(sample.anchorName)) {
                String m = "expected " + this.currentAnchor + " got " + sample.anchorName;
                throw new Error(m);
            }
            this.currentAnchor = null;
        }
        this.renderHeading(sample.anchorName, sample.anchorTitle, this.sampleSection);
        if (sample.kind == Sample.Kind.HTML) {
            this.renderHTML(sample);
        } else if (sample.kind == Sample.Kind.XML) {
            this.renderXML(sample);
        } else {
            this.renderPre(sample);
        }
    }

    protected boolean doRenderAuthor(Sample sample) {
        return null != sample.author;
    }

    protected void renderStandardHeader(Sample sample) {
        if (this.doRenderAuthor(sample)) {
            this.currentAuthor = sample.author;
            this.sampleSection.append("    <p>| &nbsp; " + this.currentAuthor);
            this.sampleSection.append("\n");
        }
        this.sampleSection.append(" &nbsp;|&nbsp; ");
        this.sampleSection.append(SampleUtil.renderCodePath(sample.sourcePath));
        this.sampleSection.append(":" + sample.startLine);
        this.sampleSection.append(" &nbsp;|");
        this.sampleSection.append("\n");
        this.sampleSection.append("<p>");
        this.sampleSection.append("\n");
        if (doFlags) {
            boolean flagHeaderDone = false;
            Iterator iter = sample.flags.iterator();
            while (iter.hasNext()) {
                String flag = (String)iter.next();
                if (!flagHeaderDone) {
                    this.sampleSection.append("<p>Comments flagged:<ul>");
                    this.sampleSection.append("\n");
                    flagHeaderDone = true;
                }
                this.sampleSection.append("<li>");
                this.sampleSection.append(flag);
                this.sampleSection.append("</li>");
            }
            if (flagHeaderDone) {
                this.sampleSection.append("</ul>");
                this.sampleSection.append("\n");
            }
        }
    }

    protected void renderXML(Sample sample) {
        this.renderStandardHeader(sample);
        this.sampleSection.append("    <pre>");
        this.sampleSection.append("\n");
        this.sampleSection.append(this.prepareXMLSample(sample.sampleCode));
        this.sampleSection.append("\n");
        this.sampleSection.append("    </pre>");
        this.sampleSection.append("\n");
    }

    protected void renderHTML(Sample sample) {
        this.renderStandardHeader(sample);
        this.sampleSection.append("\n");
        this.sampleSection.append(this.prepareHTMLSample(sample.sampleCode));
        this.sampleSection.append("\n");
    }

    protected void renderPre(Sample sample) {
        this.renderStandardHeader(sample);
        this.sampleSection.append("    <pre>");
        this.sampleSection.append("\n");
        this.sampleSection.append(this.prepareCodeSample(sample.sampleCode));
        this.sampleSection.append("    </pre>");
        this.sampleSection.append("\n");
    }

    protected void endAnchorName(String name, StringBuffer sink) {
        if (null == name) {
            return;
        }
        this.currentAnchor = null;
        this.currentAuthor = null;
    }

    protected void endList(Samples samples, StringBuffer sink) {
        sink.append("<html>");
        sink.append("\n");
        sink.append("<title>AspectJ sample code</title>");
        sink.append("\n");
        sink.append("<body>");
        sink.append("\n");
        sink.append("    <a name=\"top\"></a>");
        sink.append("\n");
        sink.append("    <h1>AspectJ sample code</h1>");
        sink.append("<p>This contains contributions from the AspectJ community of <ul><li>sample code for AspectJ programs,</li><li>sample code for extensions to AspectJ tools using the public API's,</li><li>sample scripts for invoking AspectJ tools, and </li> <li>documentation trails showing how to do given tasks    using AspectJ, AJDT, or various IDE or deployment    environments.</li></ul></p><p>Find complete source files in the AspectJ CVS repository at <code>org.aspectj/modules/docs/sandbox</code>. For instructions on downloading code from the CVS repository, see the <a href=\"doc/faq.html#q:buildingsource\">FAQ entry \"buildingsource\"</a>.</p>");
        sink.append("\n");
        sink.append("<p><small>Copyright 2003 Contributors. All Rights Reserved. This sample code is made available under the Common Public License version 1.0 available at <a href=\"http://www.eclipse.org/legal/epl-v10.html\">http://www.eclipse.org/legal/epl-v10.html</a>.Contributors are listed in this document as authors. Permission to republish portions of this sample code is hereby granted if the publication acknowledges the author by name and the source by reference to the AspectJ project home page  at http://eclipse.org/aspectj.</small></p>\n");
        sink.append("\n");
        sink.append("<p><small>Generated on ");
        sink.append(DateFormat.getDateInstance().format(new Date()));
        sink.append(" by SamplesGatherer</small>");
        sink.append("\n");
        sink.append("    <h2>Contents</h2>");
        sink.append("\n");
        sink.append("    <ul>");
        sink.append("\n");
        sink.append(this.tableOfContents.toString());
        for (int i = 0; i < this.lastAnchor.length; ++i) {
            sink.append("        </ul>");
        }
        sink.append("    <li><a href=\"#authorIndex\">Author Index</a></li>");
        sink.append("    </ul>");
        sink.append("    <h2>Listings</h2>");
        sink.append("\n");
        sink.append(this.sampleSection.toString());
        this.renderAuthorIndex(samples, sink);
        sink.append("</body></html>");
        sink.append("\n");
    }

    protected String prepareXMLSample(String sampleCode) {
        String[] from = new String[]{"\t", "<"};
        String[] to = new String[]{"    ", "&lt;"};
        return SampleUtil.replace(sampleCode, from, to);
    }

    protected String prepareHTMLSample(String sampleCode) {
        String[] from = new String[20];
        String[] to = new String[20];
        for (int i = 0; i < to.length; ++i) {
            String h = "h" + i + ">";
            from[i] = "<" + h;
            to[i] = "<p><b>";
            from[++i] = "</" + h;
            to[i] = "</b></p><p>";
        }
        return SampleUtil.replace(sampleCode, from, to);
    }

    protected String prepareCodeSample(String sampleCode) {
        String[] from = new String[]{"<pre>", "</pre>"};
        String[] to = new String[]{"&lt;pre>", "&lt;/pre>"};
        return SampleUtil.replace(sampleCode, from, to);
    }

    protected void renderHeading(String anchor, String title, StringBuffer sink) {
        sink.append("    <a name=\"" + anchor + "\"></a>");
        sink.append("\n");
        if (null == title || 0 == title.length()) {
            title = anchor;
        }
        sink.append("    <h3>" + title + "</h3>");
        sink.append("\n");
        sink.append("<a href=\"#top\">back to top</a>");
        sink.append("\n");
    }

    protected void doContentTree(String name) {
        int i;
        if (name.equals(this.lastAnchor)) {
            return;
        }
        String[] parts = SampleUtil.splitAnchorName(name);
        int firstDiff = SampleUtil.commonPrefix(parts, this.lastAnchor);
        if (firstDiff + 1 < this.lastAnchor.length) {
            for (int i2 = 1; i2 < this.lastAnchor.length - firstDiff; ++i2) {
                this.tableOfContents.append("        </ul>");
                this.tableOfContents.append("\n");
            }
        }
        StringBuffer branchAnchor = new StringBuffer();
        for (i = 0; i < firstDiff; ++i) {
            branchAnchor.append(parts[i]);
            branchAnchor.append("-");
        }
        for (i = firstDiff; i < parts.length - 1; ++i) {
            branchAnchor.append(parts[i]);
            String prefixName = branchAnchor.toString();
            branchAnchor.append("-");
            this.tableOfContents.append("        <li><a href=\"#");
            this.tableOfContents.append(prefixName);
            this.tableOfContents.append("\">" + prefixName + "</a></li>");
            this.tableOfContents.append("\n");
            this.tableOfContents.append("        <ul>");
            this.tableOfContents.append("\n");
            this.renderHeading(prefixName, prefixName, this.sampleSection);
        }
        this.lastAnchor = parts;
    }

    protected void renderAuthorIndex(Samples samples, StringBuffer sink) {
        sink.append("<h2><a name=\"authorIndex\"></a>Author Index</h2>");
        List list = samples.getSortedSamples(Sample.AUTHOR_NAME_SOURCE_COMPARER);
        String lastAuthor = null;
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            Sample sample = (Sample)iter.next();
            String author = sample.author;
            if (!author.equals(lastAuthor)) {
                if (null != lastAuthor) {
                    sink.append("</li></ul>");
                }
                sink.append("<li>");
                sink.append(author);
                sink.append("\n");
                sink.append("<ul>");
                sink.append("\n");
                lastAuthor = author;
            }
            sink.append("    <li><a href=\"#");
            sink.append(sample.anchorName);
            sink.append("\">");
            if (null == sample.anchorTitle) {
                sink.append(sample.anchorName);
            } else {
                sink.append(sample.anchorTitle);
            }
            sink.append("</a></li>");
        }
    }
}

