/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class StripNonBodyHtml
extends MatchingTask {
    private File srcDir;
    private File destDir = null;
    private ByteArrayOutputStream temp = new ByteArrayOutputStream();
    private byte[] buf = new byte[2048];

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        this.log("stripping " + files.length + " files");
        int stripped = 0;
        int len = files.length;
        for (int i = 0; i < len; ++i) {
            if (this.processFile(files[i])) {
                ++stripped;
                continue;
            }
            this.log(files[i] + " not stripped");
        }
        this.log(stripped + " files successfully stripped");
    }

    boolean processFile(String filename) throws BuildException {
        File destFile;
        File srcFile = new File(this.srcDir, filename);
        if (this.destDir == null) {
            destFile = srcFile;
        } else {
            destFile = new File(this.destDir, filename);
            destFile.getParentFile().mkdirs();
        }
        try {
            return this.strip(srcFile, destFile);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean strip(File f, File g) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        String s = this.readToString(in);
        in.close();
        return this.writeBodyTo(s, g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readToString(InputStream in) throws IOException {
        ByteArrayOutputStream temp = this.temp;
        byte[] buf = this.buf;
        String s = "";
        try {
            int i;
            while ((i = in.read(buf, 0, 2048)) != -1) {
                temp.write(buf, 0, i);
            }
            s = temp.toString();
        }
        finally {
            temp.reset();
        }
        return s;
    }

    private boolean writeBodyTo(String s, File f) throws IOException {
        try {
            int start = this.findStart(s);
            this.findEnd(s, start);
        }
        catch (ParseException e) {
            return false;
        }
        s = this.processBody(s, f);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        out.write(s.getBytes());
        out.close();
        return true;
    }

    private String processBody(String body, File file) {
        if (null == body) {
            return body;
        }
        String START = "<!-- start strip -->";
        String END = "<!-- end strip -->";
        return this.stripTags(body, file.toString(), "<!-- start strip -->", "<!-- end strip -->");
    }

    String stripTags(String input, String SOURCE, String START, String END) {
        if (null == input) {
            return input;
        }
        StringBuffer buffer = new StringBuffer(input.length());
        String result = input;
        int curLoc = 0;
        while (true) {
            int startLoc;
            if (-1 == (startLoc = input.indexOf(START, curLoc))) {
                buffer.append(input.substring(curLoc));
                result = buffer.toString();
                break;
            }
            int endLoc = input.indexOf(END, startLoc);
            if (-1 == endLoc) {
                this.log(SOURCE + " stripTags - no end tag - startLoc=" + startLoc);
                break;
            }
            if (endLoc < startLoc) {
                this.log(SOURCE + " stripTags - impossible: startLoc=" + startLoc + " > endLoc=" + endLoc);
                break;
            }
            buffer.append(input.substring(curLoc, startLoc));
            curLoc = endLoc + END.length();
        }
        return result;
    }

    private int findStart(String s) throws ParseException {
        char ch;
        int len = s.length();
        int start = 0;
        do {
            if ((start = s.indexOf("<body", start)) == -1 && (start = s.indexOf("<BODY", start)) == -1) {
                throw StripNonBodyHtml.barf();
            }
            if ((start += 5) >= len) {
                throw StripNonBodyHtml.barf();
            }
            ch = s.charAt(start);
            if (ch != '>') continue;
            return start + 1;
        } while (!Character.isWhitespace(ch));
        if ((start = s.indexOf(62, start)) == -1) {
            return -1;
        }
        return start + 1;
    }

    private int findEnd(String s, int start) throws ParseException {
        int end = s.indexOf("</body>", start);
        if (end == -1 && (end = s.indexOf("</BODY>", start)) == -1) {
            throw StripNonBodyHtml.barf();
        }
        return end;
    }

    private static ParseException barf() {
        return new ParseException();
    }

    private static class ParseException
    extends Exception {
        private static final long serialVersionUID = -1L;

        private ParseException() {
        }
    }
}

