# Hardware Info

总体的硬件信息可以通过 `dmidecode`, `lshw` 和 `hwinfo` 这些命令获取

## CPU

+ 通过文件 `/proc/cpuinfo` 获取，但是里面没有序列号
+ 安装 `cpuid`, 然后执行 `cpuid` 获取信息


## 硬盘

+ 通过文件 `/proc/scsi/scsi` 获取，但没有序列号，其它的 `scsi` 工具(lsscsi, sginfo(sg3-utils), scsiinfo(scsitools))也是如此
+ 通过 `lsblk` 命令, 如 `lsblk --nodeps -no name,serial,type,tran,vendor,model,mountpoint`, 有所有信息，若需要其他信息请见 `lsblk -h`
+ 通过 `udevadm` 命令, 如 `udevadm info --query=all --name=/dev/sda| grep -E 'ID_SERIAL_SHORT|ID_MODEL'` 获取名称和序列号
+ 通过 `udisks2 dbus`, 在 `/org/freedesktop/UDisks2/dirvers/<model>_<serial>` 对象下的 `org.freedesktop.UDisks2.Drive` 接口中的 `Model` 和 `Serial`
+ 按照 `hdparm`，然后执行 `sudo hdparm -I /dev/sda |grep -E 'Model|Serial'` 获取
+ 按照 `smartmontools`，然后执行 `sudo smartctl -i /dev/sda |grep -E 'Model|Serial'` 获取
+ 按照 `lshw`，然后执行 `sudo lshw -class disk` 获取


## 内存信息

文件 `/proc/meminfo` 中只有容量信息，所以只能通过 `dmidecode` 获取


## 网卡

网卡一般不是在 `pci` 上就是 `usb`，所以可以通过 `lspci` 或 `lsusb` 来获取，如：

`lspci | grep -i -E 'network|wire'`


## 电源信息

+ 通过 `sysfs` 获取，在 `/sys/class/power_supply/<device name>` 下
+ 通过命令 `upower -d` 获取或者使用 `upower` 提供的 `dbus` 接口获取


## BIOS/主板/产品信息

通过读取 `/sys/class/dmi/id` 目录可获取到这些信息
