package updater

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

type Data struct {
	Version             string `json:"version"`
	AutoClean           bool   `json:"auto_clean"`
	AutoCheckUpdates    bool   `json:"auto_check_updates"`
	AutoDownloadUpdates bool   `json:"auto_download_updates"`
	SmartMirrorEnabled  bool   `json:"smart_mirror_enabled"`
	SourceCheckEnabled  bool   `json:"source_check_enabled"`
}

const (
	Name = "updater"
)

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeBool(&core.AutoCheckUpdates, curInfo.AutoCheckUpdates,
		cacheInfo.AutoCheckUpdates)
	utils.MergeBool(&core.AutoDownloadUpdates, curInfo.AutoDownloadUpdates,
		cacheInfo.AutoDownloadUpdates)
	utils.MergeBool(&core.AutoClean, curInfo.AutoClean,
		cacheInfo.AutoClean)
	utils.MergeBool(&core.SmartMirrorEnabled, curInfo.SmartMirrorEnabled,
		cacheInfo.SmartMirrorEnabled)
	utils.MergeBool(&core.SourceCheckEnabled, curInfo.SourceCheckEnabled,
		cacheInfo.SourceCheckEnabled)
}
