/*******************************************************************************
 * Copyright (c) 2000, 2010 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.runtime.CoreException;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

import org.eclipse.ltk.core.refactoring.Change;

import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;

public class LaunchConfigSetAttributeChange extends LaunchConfigChange {

	private String fNewValue;

	private final String fAttributeName;

	public LaunchConfigSetAttributeChange(LaunchConfigurationContainer config, String attributeName, String newValue, boolean shouldFlagWarning) {
		super(config, shouldFlagWarning);
		fNewValue= newValue;
		fAttributeName= attributeName;
	}

	@Override
	protected Change getUndo(String oldValue) throws CoreException {
		return new LaunchConfigSetAttributeChange(fConfig, fAttributeName, oldValue, shouldFlagWarning());
	}

	public String getChangedAttributeName() {
		return fAttributeName;
	}

	@Override
	protected void alterLaunchConfiguration(ILaunchConfigurationWorkingCopy copy) throws CoreException {
		copy.setAttribute(fAttributeName, fNewValue);
	}

	@Override
	protected String getOldValue(ILaunchConfiguration config) throws CoreException {
		return config.getAttribute(fAttributeName, (String) null);
	}

	@Override
	public String getName() {
		return Messages.format(JUnitMessages.LaunchConfigSetAttributeChange_name, new Object[] {fAttributeName, fConfig.getName()});
	}
}