/*
 * Copyright (C) 2014-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define COUNT	0

#define SETS	(CONFIG_ASSOC)
#define LINES	(CONFIG_SIZE / CONFIG_CPU_CACHE_LINE_SIZE / SETS)

#ifdef STATE

struct {
#ifdef CONFIG_SIZE
	struct {
		struct NAME_(entry) {
			vaddr_t vaddr;
			paddr_t paddr;
			unsigned int wflag;
			unsigned int uflag;
			int (*rcf)(void *, paddr_t, unsigned int, udata_t *);
			void *rcs;
			char *rhaddr;
			int (*wcf)(void *, paddr_t, unsigned int, udata_t);
			void *wcs;
			char *whaddr;
			int (*xcf)(void *, paddr_t, unsigned int, udata_t *);
			void *xcs;
			char *xhaddr;
		} set[SETS];
		LRU_DECL(SETS, lru);
	} line[LINES];
#if COUNT
	int hit;
	int remap;
	int miss;
#endif
#endif /* CONFIG_SIZE */
} NAME;

#endif /* STATE */
#ifdef EXPORT

#ifdef CONFIG_CODE
/*forward*/ static int
NAME_(map_x)(struct cpssp *cpssp,
		vaddr_t vaddr,
		int user,
		paddr_t *paddrp,
		int (**cfp)(void *, paddr_t, unsigned int, udata_t *),
		void **csp,
		char **haddrp,
		uint16_t *errp);
#endif /* CONFIG_CODE */
#ifdef CONFIG_DATA
/*forward*/ static int
NAME_(map_r)(struct cpssp *cpssp,
		vaddr_t vaddr,
		int user,
		paddr_t *paddrp,
		int (**cfp)(void *, paddr_t, unsigned int, udata_t *),
		void **csp,
		char **haddrp,
		uint16_t *errp);
/*forward*/ static int
NAME_(map_w)(struct cpssp *cpssp,
		vaddr_t vaddr,
		int user,
		paddr_t *paddrp,
		int (**cfp)(void *, paddr_t, unsigned int, udata_t),
		void **csp,
		char **haddrp,
		uint16_t *errp);
#endif /* CONFIG_DATA */
#if 80486 <= CONFIG_CPU
/*forward*/ static void
NAME_(invlpg)(struct cpssp *cpssp, vaddr_t vaddr);
#endif
/*forward*/ static void
NAME_(tlb_flush)(struct cpssp *cpssp, int all);
/*forward*/ static void
NAME_(unmap)(struct cpssp *cpssp, paddr_t paddr, paddr_t len);
/*forward*/ static void
NAME_(n_reset_set)(struct cpssp *cpssp, unsigned int val);
/*forward*/ static void
NAME_(create)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(destroy)(struct cpssp *cpssp);

#endif /* EXPORT */
#ifdef BEHAVIOR

#ifdef CONFIG_SIZE
static struct NAME_(entry) *
NAME_(entry)(struct cpssp *cpssp, vaddr_t vaddr, int wflag, int uflag, uint16_t *errp)
{
	int line;
	int set;
	struct NAME_(entry) *entry;
	paddr_t paddr;

	line = (vaddr / CONFIG_CPU_CACHE_LINE_SIZE) % LINES;

	for (set = 0; ; set++) {
		if (set == SETS) {
			/* Miss */
#if COUNT
			cpssp->NAME.miss++;
#endif
			set = lru_oldest(SETS, cpssp->NAME.line[line].lru);
			entry = &cpssp->NAME.line[line].set[set];

		remap:	;
			if (unlikely(NAME_(mmu_map)(cpssp, vaddr, wflag, uflag, &paddr, errp))) {
				return NULL;
			}

			entry->vaddr = vaddr;
			entry->paddr = paddr;
			entry->wflag = wflag;
			entry->uflag = uflag;
			entry->rcf = NULL;
			entry->rhaddr = NULL;
			entry->wcf = NULL;
			entry->whaddr = NULL;
			entry->xcf = NULL;
			entry->xhaddr = NULL;
			break;
		}
		entry = &cpssp->NAME.line[line].set[set];
		if (entry->vaddr == vaddr) {
			/* Hit */
			if (entry->wflag < wflag
			 || entry->uflag < uflag) {
#if COUNT
				cpssp->NAME.remap++;
#endif
				goto remap;
			}
#if COUNT
			cpssp->NAME.hit++;
#endif
			break;
		}
	}

	lru_use(SETS, cpssp->NAME.line[line].lru, set);

	return entry;
}
#endif /* CONFIG_SIZE */

#ifdef CONFIG_CODE
static int
NAME_(map_x)(
	struct cpssp *cpssp,
	vaddr_t vaddr,
	int user,
	paddr_t *paddrp,
	int (**cfp)(void *, paddr_t, unsigned int, udata_t *),
	void **csp,
	char **haddrp,
	uint16_t *errp
)
{
#ifdef CONFIG_SIZE
	struct NAME_(entry) *entry;

	entry = NAME_(entry)(cpssp, vaddr, 0, user, errp);
	if (unlikely(! entry)) {
		return 1;
	}
	if (unlikely(! entry->xcf && ! entry->xhaddr)) {
		NAME_(a20gate_map_x)(cpssp, entry->paddr, &entry->xcf, &entry->xcs, &entry->xhaddr);
	}
	*paddrp = entry->paddr;
	*cfp = entry->xcf;
	*csp = entry->xcs;
	*haddrp = entry->xhaddr;

#else /* ! CONFIG_SIZE */
	if (NAME_(mmu_map)(cpssp, vaddr, 0, user, paddrp, errp)) {
		return 1;
	}
	NAME_(a20gate_map_x)(cpssp, *paddrp, cfp, csp, haddrp);
#endif /* ! CONFIG_SIZE */

	return 0;
}
#endif /* CONFIG_CODE */

#ifdef CONFIG_DATA
static int
NAME_(map_r)(
	struct cpssp *cpssp,
	vaddr_t vaddr,
	int user,
	paddr_t *paddrp,
	int (**cfp)(void *, paddr_t, unsigned int, udata_t *),
	void **csp,
	char **haddrp,
	uint16_t *errp
)
{
#ifdef CONFIG_SIZE
	struct NAME_(entry) *entry;

	entry = NAME_(entry)(cpssp, vaddr, 0, user, errp);
	if (unlikely(! entry)) {
		return 1;
	}
	if (unlikely(! entry->rcf && ! entry->rhaddr)) {
		NAME_(a20gate_map_r)(cpssp, entry->paddr, &entry->rcf, &entry->rcs, &entry->rhaddr);
	}
	*paddrp = entry->paddr;
	*cfp = entry->rcf;
	*csp = entry->rcs;
	*haddrp = entry->rhaddr;

#else /* ! CONFIG_SIZE */
	if (NAME_(mmu_map)(cpssp, vaddr, 0, user, paddrp, errp)) {
		return 1;
	}
	NAME_(a20gate_map_r)(cpssp, *paddrp, cfp, csp, haddrp);
#endif /* ! CONFIG_SIZE */

	return 0;
}

static int
NAME_(map_w)(
	struct cpssp *cpssp,
	vaddr_t vaddr,
	int user,
	paddr_t *paddrp,
	int (**cfp)(void *, paddr_t, unsigned int, udata_t),
	void **csp,
	char **haddrp,
	uint16_t *errp
)
{
#ifdef CONFIG_SIZE
	struct NAME_(entry) *entry;

	entry = NAME_(entry)(cpssp, vaddr, 1, user, errp);
	if (unlikely(! entry)) {
		return 1;
	}
	if (unlikely(! entry->wcf && ! entry->whaddr)) {
		NAME_(a20gate_map_w)(cpssp, entry->paddr, &entry->wcf, &entry->wcs, &entry->whaddr);
	}
	*paddrp = entry->paddr;
	*cfp = entry->wcf;
	*csp = entry->wcs;
	*haddrp = entry->whaddr;

#else /* ! CONFIG_SIZE */
	if (NAME_(mmu_map)(cpssp, vaddr, 1, user, paddrp, errp)) {
		return 1;
	}
	NAME_(a20gate_map_w)(cpssp, *paddrp, cfp, csp, haddrp);
#endif /* ! CONFIG_SIZE */

	return 0;
}
#endif /* CONFIG_DATA */

#if 80486 <= CONFIG_CPU
static void
NAME_(invlpg)(struct cpssp *cpssp, vaddr_t vaddr)
{
#ifdef CONFIG_SIZE
	int line;
	int set;

	for (line = 0; line < LINES; line++) {
		for (set = 0; set < SETS; set++) {
			if ((cpssp->NAME.line[line].set[set].vaddr & ~0xfff) == (vaddr & ~0xfff)) {
				cpssp->NAME.line[line].set[set].vaddr = -1; /* Invalid */
			}
		}
	}
#endif /* CONFIG_SIZE */

	NAME_(align_invlpg)(cpssp, vaddr);
}
#endif /* 80486 <= CONFIG_CPU */

static void
NAME_(tlb_flush)(struct cpssp *cpssp, int all)
{
#ifdef CONFIG_SIZE
	int line;
	int set;

	for (line = 0; line < LINES; line++) {
		for (set = 0; set < SETS; set++) {
			cpssp->NAME.line[line].set[set].vaddr = -1; /* Invalid */
		}
	}
#endif

	NAME_(align_tlb_flush)(cpssp, all);
}

static void
NAME_(unmap)(struct cpssp *cpssp, paddr_t paddr, paddr_t len)
{
#ifdef CONFIG_SIZE
	int line;
	int set;

	len--;

	for (line = 0; line < LINES; line++) {
		for (set = 0; set < SETS; set++) {
			if (paddr <= cpssp->NAME.line[line].set[set].paddr
			 && cpssp->NAME.line[line].set[set].paddr < paddr + len) {
				cpssp->NAME.line[line].set[set].xcf = NULL;
				cpssp->NAME.line[line].set[set].xhaddr = NULL;
				cpssp->NAME.line[line].set[set].wcf = NULL;
				cpssp->NAME.line[line].set[set].whaddr = NULL;
				cpssp->NAME.line[line].set[set].rcf = NULL;
				cpssp->NAME.line[line].set[set].rhaddr = NULL;
			}
		}
	}
#endif /* CONFIG_SIZE */

	NAME_(align_unmap)(cpssp, paddr, len);
}

static void
NAME_(n_reset_set)(struct cpssp *cpssp, unsigned int n_val)
{
#ifdef CONFIG_SIZE
	int line;
	int set;

	for (line = 0; line < LINES; line++) {
		for (set = 0; set < SETS; set++) {
			cpssp->NAME.line[line].set[set].vaddr = -1; /* Invalid */
		}
		lru_reset(SETS, cpssp->NAME.line[line].lru);
	}
#endif /* CONFIG_SIZE */
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef LINES
#undef SETS

#undef COUNT
