/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.sheet;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import org.dbdoclet.format.FormattedObject;
import org.w3c.dom.Element;

public interface Part extends FormattedObject {

    public void appendChild(Part newChild);
    public int computeFontHeight(Graphics2D g2d, Font font);
    public void copyProperties(Part toPart);
    public Part deepCopy(Sheet sheet);
    public ArrayList<Part> getChildren();
    public String getId();
    public Rectangle2D.Double getMarginBox();
    public int getIndex();
    public double getNormalizedHeight();
    public Part getParent();
    public Sheet getSheet();
    public Margin getMargin();
    public Padding getPadding();
    public void setMargin(Margin margin);
    public void setPadding(Padding padding);
    public String getTagName();
    public void insertChild(int index, Part part);
    public boolean isSelected();
    public void paintPart(Graphics2D g2d);
    public boolean removeChild(Part part);
    public int rzoom(double value);
    public void setBoundingBox(Rectangle2D.Double bb);
    public void setIndex(int index);
    public void setParent(Part part);
    public void setSelected(boolean b);
    public void writeElement(Element element);
    public double zoom(double value);
	public double getSpaceBefore();
	public double getSpaceAfter();
	public Rectangle2D.Double getCopyOfContentBox();

}
