/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.widget;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.SortedMap;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class EncodingChooser extends JComboBox<String> {

    private static final long serialVersionUID = 1L;

    public EncodingChooser() {

        SortedMap<String, Charset> map = Charset.availableCharsets();
        Iterator<String> iterator = map.keySet().iterator();

        String[] encodings = new String[map.size()];

        int index = 0;
        while (iterator.hasNext()) {
            encodings[index++] = iterator.next();
        }

        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<>(encodings);
        setModel(model);
        setSelectedItem("UTF-8");
    }

    public String getEncoding() {

        return (String) getSelectedItem();
    }

    public void setEncoding(String encoding) {

        if (encoding == null) {
            return;
        }
 
        setSelectedItem(encoding);
    }
}