/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.widget;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberTextField extends AbstractTextField {

	private static final long serialVersionUID = 1L;

	/**
	 * Konstruktor mit Angabe der gewünschten Anzahl an Spalten für die Eingabe.
	 * 
	 * @param cols
	 */
	public NumberTextField(int cols) {
		super(cols);
	}

	public Integer getNumber() {
	
		String buffer = getText();
		
		if (buffer == null || buffer.trim().length() == 0) {
			return null;
		}
		
		return Integer.parseInt(buffer); 
	}
	
	@Override
	protected Document createDefaultModel() {
		return new NumberDocument();
	}
	
	class NumberDocument extends PlainDocument {

		private static final long serialVersionUID = 1L;

		@Override
		public void insertString(int offset, String str, AttributeSet a)
				throws BadLocationException {

			char[] buffer = str.toCharArray();

			boolean valid = true;
			boolean fit = true;

			if (buffer.length + getLength() <= getMaxLength()) {

				for (int i = 0; i < buffer.length; i++) {

					if (Character.isDigit(buffer[i]) == false) {
						valid = false;
						break;
					}
				}

			} else {

				fit = false;
			}

			if (valid && fit) {
				super.insertString(offset, str, a);
			} else {
				getToolkit().beep();
			}
		}
	}
}
