{- This module was generated from data in the Kate syntax
   highlighting file ats.xml, version 0.01, by Kiwamu Okabe (kiwamu@debian.or.jp) -}

module Text.Highlighting.Kate.Syntax.Ats
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "ATS"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.dats;*.sats;*.hats"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("ATS","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("ATS","Normal") -> return ()
      ("ATS","Rest-of-file Comment") -> return ()
      ("ATS","Multiline Comment") -> return ()
      ("ATS","Multiline C-style Comment") -> return ()
      ("ATS","Singleline C++ style Comment") -> (popContext) >> pEndLine
      ("ATS","String Context") -> return ()
      ("ATS","Termination Metrics Context") -> return ()
      ("ATS","Function Keyword Context") -> return ()
      ("ATS","Universal Context") -> return ()
      ("ATS","Existential Context") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "abstype abst0ype absprop absview absvtype absviewtype absvt0ype absviewt0ype and as assume begin break continue classdec datasort datatype dataprop dataview datavtype dataviewtype do dynload else end exception extern extype extval if in infix infixl infixr prefix postfix let local macdef macrodef nonfix overload of op rec scase sif sortdef sta stacst stadef stavar staload symelim symintr then try tkindef type typedef propdef viewdef vtypedef viewtypedef val prval var prvar when where for while with withtype withprop withview withvtype withviewtype"
list_special_keywords = Set.fromList $ words $ "$arrpsz $arrptrsize $delay $ldelay $effmask $effmask_ntm $effmask_exn $effmask_ref $effmask_wrt $effmask_all $extern $extkind $extype $extype_struct $extval $lst $lst_t $lst_vt $list $list_t $list_vt $rec $rec_t $rec_vt $record $record_t $record_vt $tup $tup_t $tup_vt $tuple $tuple_t $tuple_vt $raise $showtype $myfilename $mylocation $myfunction #assert #define #elif #elifdef #elifndef #else #endif #error #if #ifdef #ifndef #include #print #then #undef"
list_function_keywords = Set.fromList $ words $ "fn fnx fun prfn prfun praxi castfn implmnt implement primplmnt primplement lam llam fix"

regex_'60'5cs'2a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a = compileRegex True "`\\s*[A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\0377_][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*"
regex_'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a = compileRegex True "[A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\0377_][A-Za-z\\0300-\\0326\\0330-\\0366\\0370-\\03770-9_']*"
regex_'7e'3f0'5bxX'5d'5b0'2d9A'2dFa'2df'5f'5d'2b = compileRegex True "~?0[xX][0-9A-Fa-f_]+"
regex_'7e'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'28'28'5c'2e'28'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'29'7c'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'29 = compileRegex True "~?[0-9][0-9_]*((\\.([0-9][0-9_]*)?([eE][-+]?[0-9][0-9_]*)?)|([eE][-+]?[0-9][0-9_]*))"
regex_'7e'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a = compileRegex True "~?[0-9][0-9_]*"
regex_'28'5c'5c'5bntbr'27'22'5c'5c'5d'7c'5c'5c'5b0'2d9'5d'7b3'7d'7c'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b2'7d'29 = compileRegex True "(\\\\[ntbr'\"\\\\]|\\\\[0-9]{3}|\\\\x[0-9A-Fa-f]{2})"
regex_'5c'5c'24 = compileRegex True "\\\\$"

parseRules ("ATS","Normal") =
  (((pString False "////" >>= withAttribute CommentTok) >>~ pushContext ("ATS","Rest-of-file Comment"))
   <|>
   ((pDetect2Chars False '(' '*' >>= withAttribute CommentTok) >>~ pushContext ("ATS","Multiline Comment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("ATS","Multiline C-style Comment"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("ATS","Singleline C++ style Comment"))
   <|>
   ((pDetect2Chars False '.' '<' >>= withAttribute DataTypeTok) >>~ pushContext ("ATS","Termination Metrics Context"))
   <|>
   ((pRegExpr regex_'60'5cs'2a'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_function_keywords >>= withAttribute KeywordTok) >>~ pushContext ("ATS","Function Keyword Context"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_special_keywords >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c0377'5f'5d'5bA'2dZa'2dz'5c0300'2d'5c0326'5c0330'2d'5c0366'5c0370'2d'5c03770'2d9'5f'27'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'7e'3f0'5bxX'5d'5b0'2d9A'2dFa'2df'5f'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'7e'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'28'28'5c'2e'28'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'3f'29'7c'28'5beE'5d'5b'2d'2b'5d'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'7e'3f'5b0'2d9'5d'5b0'2d9'5f'5d'2a >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ATS","Rest-of-file Comment") =
  (currentContext >>= \x -> guard (x == ("ATS","Rest-of-file Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("ATS","Multiline Comment") =
  (((pDetect2Chars False '*' ')' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '(' '*' >>= withAttribute CommentTok) >>~ pushContext ("ATS","Multiline Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","Multiline Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ATS","Multiline C-style Comment") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","Multiline C-style Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("ATS","Singleline C++ style Comment") =
  (currentContext >>= \x -> guard (x == ("ATS","Singleline C++ style Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("ATS","String Context") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28'5c'5c'5bntbr'27'22'5c'5c'5d'7c'5c'5c'5b0'2d9'5d'7b3'7d'7c'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b2'7d'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'5c'24 >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","String Context")) >> pDefault >>= withAttribute StringTok))

parseRules ("ATS","Termination Metrics Context") =
  (((pDetect2Chars False '>' '.' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","Termination Metrics Context")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("ATS","Function Keyword Context") =
  (((pDetectChar False '=' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '{' >>= withAttribute DataTypeTok) >>~ pushContext ("ATS","Universal Context"))
   <|>
   ((pDetectChar False '[' >>= withAttribute DataTypeTok) >>~ pushContext ("ATS","Existential Context"))
   <|>
   ((parseRules ("ATS","Normal")))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","Function Keyword Context")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ATS","Universal Context") =
  (((pDetectChar False '}' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","Universal Context")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("ATS","Existential Context") =
  (((pDetectChar False ']' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("ATS","Existential Context")) >> pDefault >>= withAttribute DataTypeTok))


parseRules x = parseRules ("ATS","Normal") <|> fail ("Unknown context" ++ show x)
