#ifndef __obj_generator
#define __obj_generator

#define render_generator { \
    glInterleavedArrays (GL_N3F_V3F, 0, generatorInterleavedQuads); \
    glDrawArrays (GL_QUADS, 0, generatorNumQuads*4); \
    glInterleavedArrays (GL_N3F_V3F, 0, generatorInterleavedQuadStrips); \
    for (int i = 0; i < generatorNumQuadStrips; i++) { \
        glDrawArrays (GL_QUAD_STRIP, generatorQuadStripIndices[i]/6, \
                        (generatorQuadStripIndices[i+1] - generatorQuadStripIndices[i])/6); \
    } \
    glInterleavedArrays (GL_N3F_V3F, 0, generatorInterleavedTriangleFans); \
    for (int ii = 0; ii < generatorNumTriangleFans; ii++) { \
        glDrawArrays (GL_TRIANGLE_FAN, generatorTriangleFanIndices[ii]/6, \
                        (generatorTriangleFanIndices[ii+1] - generatorTriangleFanIndices[ii])/6); \
    } \
}

static int generatorNumQuads = 8;
static float generatorInterleavedQuads[192] = {
 0.924,  0.383,  0.000, 0.383,  0.330,  0.155,
 0.924,  0.383,  0.000, 0.500,  0.047,  0.155,
 0.924,  0.383,  0.000, 0.500,  0.047, -0.153,
 0.924,  0.383,  0.000, 0.383,  0.330, -0.153,

-0.924, -0.383,  0.000,-0.387, -0.321,  0.155,
-0.924, -0.383,  0.000,-0.504, -0.038,  0.155,
-0.924, -0.383,  0.000,-0.504, -0.038, -0.153,
-0.924, -0.383,  0.000,-0.387, -0.321, -0.153,

 0.924, -0.383,  0.000, 0.500, -0.038,  0.155,
 0.924, -0.383,  0.000, 0.383, -0.321,  0.155,
 0.924, -0.383,  0.000, 0.383, -0.321, -0.153,
 0.924, -0.383,  0.000, 0.500, -0.038, -0.153,

-0.383,  0.924,  0.000,-0.327,  0.389,  0.155,
-0.383,  0.924,  0.000,-0.044,  0.506,  0.155,
-0.383,  0.924,  0.000,-0.044,  0.506, -0.153,
-0.383,  0.924,  0.000,-0.327,  0.389, -0.153,

 0.383, -0.924,  0.000, 0.323, -0.380,  0.155,
 0.383, -0.924,  0.000, 0.040, -0.498,  0.155,
 0.383, -0.924,  0.000, 0.040, -0.498, -0.153,
 0.383, -0.924,  0.000, 0.323, -0.380, -0.153,

 0.383,  0.924,  0.000, 0.040,  0.506,  0.155,
 0.383,  0.924,  0.000, 0.323,  0.389,  0.155,
 0.383,  0.924,  0.000, 0.323,  0.389, -0.153,
 0.383,  0.924,  0.000, 0.040,  0.506, -0.153,

-0.924,  0.383,  0.000,-0.504,  0.047,  0.155,
-0.924,  0.383,  0.000,-0.387,  0.330,  0.155,
-0.924,  0.383,  0.000,-0.387,  0.330, -0.153,
-0.924,  0.383,  0.000,-0.504,  0.047, -0.153,

-0.383, -0.924,  0.000,-0.044, -0.498,  0.155,
-0.383, -0.924,  0.000,-0.327, -0.380,  0.155,
-0.383, -0.924,  0.000,-0.327, -0.380, -0.153,
-0.383, -0.924,  0.000,-0.044, -0.498, -0.153,

};

static int generatorNumQuadStrips = 12;

static int generatorQuadStripIndices[13] = { 0, 120, 240, 360, 480, 552, 624, 696, 768, 840, 912, 984, 1056 };

static float generatorInterleavedQuadStrips[1056] = {
 0.707,  0.707,  0.000,  0.141,  0.141, -0.076,  0.707,  0.707,  0.000,  0.141,  0.141,  0.078,
 1.000,  0.000, -0.000,  0.200,  0.000, -0.076, 
 1.000,  0.000, -0.000,  0.200,  0.000,  0.078, 
 0.707, -0.707, -0.000,  0.141, -0.141, -0.076, 
 0.707, -0.707, -0.000,  0.141, -0.141,  0.078, 
 0.000, -1.000, -0.000,  0.000, -0.200, -0.076, 
 0.000, -1.000, -0.000,  0.000, -0.200,  0.078, 
-0.707, -0.707, -0.000, -0.141, -0.141, -0.076, 
-0.707, -0.707, -0.000, -0.141, -0.141,  0.078, 
-1.000, -0.000,  0.000, -0.200,  0.000, -0.076, 
-1.000, -0.000,  0.000, -0.200,  0.000,  0.078, 
-0.707,  0.707,  0.000, -0.141,  0.141, -0.076, 
-0.707,  0.707,  0.000, -0.141,  0.141,  0.078, 
-0.000,  1.000,  0.000, -0.000,  0.200, -0.076, 
-0.000,  1.000,  0.000, -0.000,  0.200,  0.078, 
 0.707,  0.707,  0.000,  0.141,  0.141, -0.076, 
 0.707,  0.707,  0.000,  0.141,  0.141,  0.078, 
 1.000,  0.000, -0.000,  0.200,  0.000, -0.076, 
 1.000,  0.000, -0.000,  0.200,  0.000,  0.078, 
-0.000,  0.710,  0.704, -0.000,  0.200,  0.078, -0.000,  0.710,  0.704, -0.000,  0.059,  0.220,
 0.502,  0.502,  0.704,  0.141,  0.141,  0.078, 
 0.502,  0.502,  0.704,  0.042,  0.042,  0.220, 
 0.710, -0.000,  0.704,  0.200,  0.000,  0.078, 
 0.710, -0.000,  0.704,  0.059, -0.000,  0.220, 
 0.502, -0.502,  0.704,  0.141, -0.141,  0.078, 
 0.502, -0.502,  0.704,  0.042, -0.042,  0.220, 
 0.000, -0.710,  0.704,  0.000, -0.200,  0.078, 
 0.000, -0.710,  0.704,  0.000, -0.059,  0.220, 
-0.502, -0.502,  0.704, -0.141, -0.141,  0.078, 
-0.502, -0.502,  0.704, -0.042, -0.042,  0.220, 
-0.710, -0.000,  0.704, -0.200,  0.000,  0.078, 
-0.710, -0.000,  0.704, -0.059, -0.000,  0.220, 
-0.502,  0.502,  0.704, -0.141,  0.141,  0.078, 
-0.502,  0.502,  0.704, -0.042,  0.042,  0.220, 
-0.000,  0.710,  0.704, -0.000,  0.200,  0.078, 
-0.000,  0.710,  0.704, -0.000,  0.059,  0.220, 
 0.502,  0.502,  0.704,  0.141,  0.141,  0.078, 
 0.502,  0.502,  0.704,  0.042,  0.042,  0.220, 
-0.000,  1.000,  0.000, -0.000,  0.100,  0.354, -0.000,  1.000,  0.000, -0.000,  0.100,  0.500,
 0.707,  0.707,  0.000,  0.071,  0.071,  0.354, 
 0.707,  0.707,  0.000,  0.071,  0.071,  0.500, 
 1.000,  0.000, -0.000,  0.100, -0.000,  0.354, 
 1.000,  0.000, -0.000,  0.100, -0.000,  0.500, 
 0.707, -0.707, -0.000,  0.071, -0.071,  0.354, 
 0.707, -0.707, -0.000,  0.071, -0.071,  0.500, 
 0.000, -1.000, -0.000,  0.000, -0.100,  0.354, 
 0.000, -1.000, -0.000,  0.000, -0.100,  0.500, 
-0.707, -0.707, -0.000, -0.071, -0.071,  0.354, 
-0.707, -0.707, -0.000, -0.071, -0.071,  0.500, 
-1.000, -0.000,  0.000, -0.100, -0.000,  0.354, 
-1.000, -0.000,  0.000, -0.100, -0.000,  0.500, 
-0.707,  0.707,  0.000, -0.071,  0.071,  0.354, 
-0.707,  0.707,  0.000, -0.071,  0.071,  0.500, 
-0.000,  1.000,  0.000, -0.000,  0.100,  0.354, 
-0.000,  1.000,  0.000, -0.000,  0.100,  0.500, 
 0.707,  0.707,  0.000,  0.071,  0.071,  0.354, 
 0.707,  0.707,  0.000,  0.071,  0.071,  0.500, 
 0.676,  0.676, -0.291,  0.042,  0.042,  0.220,  0.676,  0.676, -0.291,  0.071,  0.071,  0.354,
 0.957,  0.000, -0.291,  0.059, -0.000,  0.220, 
 0.957,  0.000, -0.291,  0.100, -0.000,  0.354, 
 0.676, -0.676, -0.291,  0.042, -0.042,  0.220, 
 0.676, -0.676, -0.291,  0.071, -0.071,  0.354, 
 0.000, -0.957, -0.291,  0.000, -0.059,  0.220, 
 0.000, -0.957, -0.291,  0.000, -0.100,  0.354, 
-0.676, -0.676, -0.291, -0.042, -0.042,  0.220, 
-0.676, -0.676, -0.291, -0.071, -0.071,  0.354, 
-0.957,  0.000, -0.291, -0.059, -0.000,  0.220, 
-0.957,  0.000, -0.291, -0.100, -0.000,  0.354, 
-0.676,  0.676, -0.291, -0.042,  0.042,  0.220, 
-0.676,  0.676, -0.291, -0.071,  0.071,  0.354, 
 0.000,  0.957, -0.291, -0.000,  0.059,  0.220, 
 0.000,  0.957, -0.291, -0.000,  0.100,  0.354, 
 0.676,  0.676, -0.291,  0.042,  0.042,  0.220, 
 0.676,  0.676, -0.291,  0.071,  0.071,  0.354, 
 0.957,  0.000, -0.291,  0.059, -0.000,  0.220, 
 0.957,  0.000, -0.291,  0.100, -0.000,  0.354, 
 0.756,  0.295,  0.585, -0.044, -0.498,  0.155,  0.756,  0.295,  0.585, -0.054, -0.321,  0.078,
-0.326,  0.743,  0.585, -0.327, -0.380,  0.155, 
-0.326,  0.743,  0.585, -0.195, -0.262,  0.078, 
-0.326,  0.743, -0.585, -0.327, -0.380, -0.153, 
-0.326,  0.743, -0.585, -0.195, -0.262, -0.076, 
 0.756,  0.295, -0.585, -0.044, -0.498, -0.153, 
 0.756,  0.295, -0.585, -0.054, -0.321, -0.076, 
 0.756,  0.295,  0.585, -0.044, -0.498,  0.155, 
 0.756,  0.295,  0.585, -0.054, -0.321,  0.078, 
-0.326,  0.743,  0.585, -0.327, -0.380,  0.155, 
-0.326,  0.743,  0.585, -0.195, -0.262,  0.078, 
 0.295, -0.756,  0.585, -0.504,  0.047,  0.155,  0.295, -0.756,  0.585, -0.327,  0.056,  0.078,
 0.743,  0.326,  0.585, -0.387,  0.330,  0.155, 
 0.743,  0.326,  0.585, -0.268,  0.198,  0.078, 
 0.743,  0.326, -0.585, -0.387,  0.330, -0.153, 
 0.743,  0.326, -0.585, -0.268,  0.198, -0.076, 
 0.295, -0.756, -0.585, -0.504,  0.047, -0.153, 
 0.295, -0.756, -0.585, -0.327,  0.056, -0.076, 
 0.295, -0.756,  0.585, -0.504,  0.047,  0.155, 
 0.295, -0.756,  0.585, -0.327,  0.056,  0.078, 
 0.743,  0.326,  0.585, -0.387,  0.330,  0.155, 
 0.743,  0.326,  0.585, -0.268,  0.198,  0.078, 
-0.756, -0.295,  0.585,  0.040,  0.506,  0.155, -0.756, -0.295,  0.585,  0.050,  0.329,  0.078,
 0.326, -0.743,  0.585,  0.323,  0.389,  0.155, 
 0.326, -0.743,  0.585,  0.191,  0.271,  0.078, 
 0.326, -0.743, -0.585,  0.323,  0.389, -0.153, 
 0.326, -0.743, -0.585,  0.191,  0.271, -0.076, 
-0.756, -0.295, -0.585,  0.040,  0.506, -0.153, 
-0.756, -0.295, -0.585,  0.050,  0.329, -0.076, 
-0.756, -0.295,  0.585,  0.040,  0.506,  0.155, 
-0.756, -0.295,  0.585,  0.050,  0.329,  0.078, 
 0.326, -0.743,  0.585,  0.323,  0.389,  0.155, 
 0.326, -0.743,  0.585,  0.191,  0.271,  0.078, 
 0.326,  0.743,  0.585,  0.323, -0.380,  0.155,  0.326,  0.743,  0.585,  0.191, -0.262,  0.078,
-0.756,  0.295,  0.585,  0.040, -0.498,  0.155, 
-0.756,  0.295,  0.585,  0.050, -0.321,  0.078, 
-0.756,  0.295, -0.585,  0.040, -0.498, -0.153, 
-0.756,  0.295, -0.585,  0.050, -0.321, -0.076, 
 0.326,  0.743, -0.585,  0.323, -0.380, -0.153, 
 0.326,  0.743, -0.585,  0.191, -0.262, -0.076, 
 0.326,  0.743,  0.585,  0.323, -0.380,  0.155, 
 0.326,  0.743,  0.585,  0.191, -0.262,  0.078, 
-0.756,  0.295,  0.585,  0.040, -0.498,  0.155, 
-0.756,  0.295,  0.585,  0.050, -0.321,  0.078, 
-0.326, -0.743,  0.585, -0.327,  0.389,  0.155, -0.326, -0.743,  0.585, -0.195,  0.271,  0.078,
 0.756, -0.295,  0.585, -0.044,  0.506,  0.155, 
 0.756, -0.295,  0.585, -0.054,  0.329,  0.078, 
 0.756, -0.295, -0.585, -0.044,  0.506, -0.153, 
 0.756, -0.295, -0.585, -0.054,  0.329, -0.076, 
-0.326, -0.743, -0.585, -0.327,  0.389, -0.153, 
-0.326, -0.743, -0.585, -0.195,  0.271, -0.076, 
-0.326, -0.743,  0.585, -0.327,  0.389,  0.155, 
-0.326, -0.743,  0.585, -0.195,  0.271,  0.078, 
 0.756, -0.295,  0.585, -0.044,  0.506,  0.155, 
 0.756, -0.295,  0.585, -0.054,  0.329,  0.078, 
-0.295,  0.756,  0.585,  0.500, -0.038,  0.155, -0.295,  0.756,  0.585,  0.323, -0.047,  0.078,
-0.743, -0.326,  0.585,  0.383, -0.321,  0.155, 
-0.743, -0.326,  0.585,  0.265, -0.189,  0.078, 
-0.743, -0.326, -0.585,  0.383, -0.321, -0.153, 
-0.743, -0.326, -0.585,  0.265, -0.189, -0.076, 
-0.295,  0.756, -0.585,  0.500, -0.038, -0.153, 
-0.295,  0.756, -0.585,  0.323, -0.047, -0.076, 
-0.295,  0.756,  0.585,  0.500, -0.038,  0.155, 
-0.295,  0.756,  0.585,  0.323, -0.047,  0.078, 
-0.743, -0.326,  0.585,  0.383, -0.321,  0.155, 
-0.743, -0.326,  0.585,  0.265, -0.189,  0.078, 
 0.743, -0.326,  0.585, -0.387, -0.321,  0.155,  0.743, -0.326,  0.585, -0.268, -0.189,  0.078,
 0.295,  0.756,  0.585, -0.504, -0.038,  0.155, 
 0.295,  0.756,  0.585, -0.327, -0.047,  0.078, 
 0.295,  0.756, -0.585, -0.504, -0.038, -0.153, 
 0.295,  0.756, -0.585, -0.327, -0.047, -0.076, 
 0.743, -0.326, -0.585, -0.387, -0.321, -0.153, 
 0.743, -0.326, -0.585, -0.268, -0.189, -0.076, 
 0.743, -0.326,  0.585, -0.387, -0.321,  0.155, 
 0.743, -0.326,  0.585, -0.268, -0.189,  0.078, 
 0.295,  0.756,  0.585, -0.504, -0.038,  0.155, 
 0.295,  0.756,  0.585, -0.327, -0.047,  0.078, 
-0.743,  0.326,  0.585,  0.383,  0.330,  0.155, -0.743,  0.326,  0.585,  0.265,  0.198,  0.078,
-0.295, -0.756,  0.585,  0.500,  0.047,  0.155, 
-0.295, -0.756,  0.585,  0.323,  0.056,  0.078, 
-0.295, -0.756, -0.585,  0.500,  0.047, -0.153, 
-0.295, -0.756, -0.585,  0.323,  0.056, -0.076, 
-0.743,  0.326, -0.585,  0.383,  0.330, -0.153, 
-0.743,  0.326, -0.585,  0.265,  0.198, -0.076, 
-0.743,  0.326,  0.585,  0.383,  0.330,  0.155, 
-0.743,  0.326,  0.585,  0.265,  0.198,  0.078, 
-0.295, -0.756,  0.585,  0.500,  0.047,  0.155, 
-0.295, -0.756,  0.585,  0.323,  0.056,  0.078, 
};

static int generatorNumTriangleFans = 12;

static int generatorTriangleFanIndices[13] = { 0, 36, 72, 108, 138, 162, 186, 210, 234, 258, 282, 306, 330 };

static float generatorInterleavedTriangleFans[330] = {
-0.000, -0.000,  1.000,  0.000, -0.100,  0.500,  0.000, -0.000,  1.000,  0.071, -0.071,  0.500, 
 0.000, -0.000,  1.000, -0.000,  0.100,  0.500, 
-0.000, -0.000,  1.000, -0.071,  0.071,  0.500, 
-0.000, -0.000,  1.000, -0.100, -0.000,  0.500, 
-0.000, -0.000,  1.000, -0.071, -0.071,  0.500, 
-0.000,  0.000, -1.000,  0.141, -0.141, -0.076,  0.000,  0.000, -1.000,  0.000, -0.200, -0.076, 
 0.000,  0.000, -1.000, -0.141, -0.141, -0.076, 
 0.000,  0.000, -1.000, -0.200,  0.000, -0.076, 
-0.000,  0.000, -1.000, -0.141,  0.141, -0.076, 
-0.000,  0.000, -1.000,  0.200,  0.000, -0.076, 
-0.000,  0.000, -1.000, -0.141,  0.141, -0.076, -0.000,  0.000, -1.000, -0.000,  0.200, -0.076, 
-0.000,  0.000, -1.000,  0.141,  0.141, -0.076, 
-0.000,  0.000, -1.000,  0.200,  0.000, -0.076, 
-0.000,  0.000, -1.000,  0.141, -0.141, -0.076, 
 0.000,  0.000, -1.000, -0.200,  0.000, -0.076, 
 0.000, -0.000,  1.000, -0.000,  0.100,  0.500, -0.000, -0.000,  1.000,  0.000, -0.100,  0.500, 
 0.000, -0.000,  1.000,  0.071, -0.071,  0.500, 
 0.000, -0.000,  1.000,  0.100, -0.000,  0.500, 
 0.000, -0.000,  1.000,  0.071,  0.071,  0.500, 
-0.924, -0.383, -0.000,  0.265,  0.198, -0.076, -0.924, -0.383, -0.000,  0.323,  0.056, -0.076, 
-0.924, -0.383, -0.000,  0.323,  0.056,  0.078, 
-0.924, -0.383, -0.000,  0.265,  0.198,  0.078, 
 0.924,  0.383, -0.000, -0.268, -0.189, -0.076,  0.924,  0.383, -0.000, -0.327, -0.047, -0.076, 
 0.924,  0.383, -0.000, -0.327, -0.047,  0.078, 
 0.924,  0.383, -0.000, -0.268, -0.189,  0.078, 
-0.924,  0.383, -0.000,  0.323, -0.047, -0.076, -0.924,  0.383, -0.000,  0.265, -0.189, -0.076, 
-0.924,  0.383, -0.000,  0.265, -0.189,  0.078, 
-0.924,  0.383, -0.000,  0.323, -0.047,  0.078, 
 0.383, -0.924, -0.000, -0.195,  0.271, -0.076,  0.383, -0.924, -0.000, -0.054,  0.329, -0.076, 
 0.383, -0.924, -0.000, -0.054,  0.329,  0.078, 
 0.383, -0.924, -0.000, -0.195,  0.271,  0.078, 
-0.383,  0.924, -0.000,  0.191, -0.262, -0.076, -0.383,  0.924, -0.000,  0.050, -0.321, -0.076, 
-0.383,  0.924, -0.000,  0.050, -0.321,  0.078, 
-0.383,  0.924, -0.000,  0.191, -0.262,  0.078, 
-0.383, -0.924, -0.000,  0.050,  0.329, -0.076, -0.383, -0.924, -0.000,  0.191,  0.271, -0.076, 
-0.383, -0.924, -0.000,  0.191,  0.271,  0.078, 
-0.383, -0.924, -0.000,  0.050,  0.329,  0.078, 
 0.924, -0.383, -0.000, -0.327,  0.056, -0.076,  0.924, -0.383, -0.000, -0.268,  0.198, -0.076, 
 0.924, -0.383, -0.000, -0.268,  0.198,  0.078, 
 0.924, -0.383, -0.000, -0.327,  0.056,  0.078, 
 0.383,  0.924, -0.000, -0.054, -0.321, -0.076,  0.383,  0.924, -0.000, -0.195, -0.262, -0.076, 
 0.383,  0.924, -0.000, -0.195, -0.262,  0.078, 
 0.383,  0.924, -0.000, -0.054, -0.321,  0.078, 
};

#endif // __obj_generator
