.\"
.\" $Id: rfio_write.man,v 1.1 2005/03/31 13:13:04 baud Exp $
.\"
.\" @(#)$RCSfile: rfio_write.man,v $ $Revision: 1.1 $ $Date: 2005/03/31 13:13:04 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2001 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH RFIO_WRITE 3 "$Date: 2005/03/31 13:13:04 $" CASTOR "Rfio Library Functions"
.SH NAME
rfio_write \- writes to a file
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "int rfio_write (int " s ", const void *" ptr ", int " size ");"
.SH DESCRIPTION
.B rfio_write
stores in a file the bytes starting at
.BR ptr ,
a pointer to the memory location in which resides the information,
.BI size
bytes, using the descriptor
.BI s
generated by a previous
.BR rfio_open .
.SH RETURN VALUE
This routine returns -1 if the operation failed or the number of items actually writen. In case of failure, 
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
.I s
is not a valid descriptor.
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SETIMEDOUT
Timed out.
.TP
.B SEBADVERSION
Version ID mismatch.
.TP
.B SECONNDROP
Connection closed by remote end.
.TP
.B SECOMERR
Communication error.
.TP
.B SENORCODE
Host did not return error number.
.SH SEE ALSO
.BR Castor_limits(4) ,
.BR rfio_open(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
