/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>

#include "evaluationmanager.h"
#include "pdl.h"
#include "pdl_variable.h"


int main(int argc, char *argv[])
{
  char *argvv[2];
  int rc;
  int counter;
  lcmaps_db_entry_t* plugin;

  struct timeval tv;
  gettimeofday(&tv, NULL);
  srand48((tv.tv_sec>>2)+(tv.tv_usec>>2));

  if (argc==2)
    rc = lcmaps_startEvaluationManager(argv[1], 0, 0);
  else
    rc = lcmaps_startEvaluationManager(0, 0, 0);

  if (rc != 0) {
    printf("There have been errors...\n");
    lcmaps_stopEvaluationManager();
    return -1;
  }

  printf("path = '%s'.\n", lcmaps_pdl_path());

  lcmaps_show_variables();

  printf("\npolicies after reduction.\n\n");
  lcmaps_show_policies();

  lcmaps_getPluginNameAndArgs(&plugin);

  printf("Got plugin names and args.\n");

  counter = 0;
  while (plugin) {
    printf("plugin nr: %2d  ", ++counter);
    printf("%s %s\n", plugin->pluginname, plugin->pluginargs);
    plugin = plugin->next;
  }

  argvv[0] = "bogus";
  argvv[1] = "tweede";

  printf("End result: ");
  /* if (lcmaps_runEvaluationManager(2, argvv)==0) */
  if (lcmaps_runEvaluationManager(0, 0)==0)
    printf("success\n");
  else
    printf("failure\n");

  return 0;
}


/*
 *  Stubs...
 *
 */
int lcmaps_runPlugin(const char* name)
{
  switch (name[strlen(name)-1]) {
  case 'a':  return 0;
  case 'b':  return 0;
  case 'c':  return 1;
  case 'd':  return 0;
  case 'e':  return 1;
  case 'p':  return 0;
  case 'q':  return 0;
  }

  return 0;
  return (drand48()>0.5) ? 0 : 1;
}

int lcmaps_log(int p, char* f, ...)
{
  va_list args;

  va_start(args, f);
  vfprintf(stderr, f, args);
  va_end(args);

  return 0;
}

int lcmaps_log_debug(int p, char* f, ...)
{
  va_list args;

  va_start(args, f);
  vfprintf(stderr, f, args);
  va_end(args);

  return 0;
}

int resetCredentialData()
{
  return 0;
}
