; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=hawaii < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=fiji < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdhsa -mcpu=hawaii < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdhsa -mcpu=fiji < %s | FileCheck -check-prefix=GCN %s

define float @v_sqrt_f32(float %src)  {
; GCN-LABEL: v_sqrt_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sqrt_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call float @llvm.amdgcn.sqrt.f32(float %src)
  ret float %sqrt
}

define float @v_fabs_sqrt_f32(float %src)  {
; GCN-LABEL: v_fabs_sqrt_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sqrt_f32_e64 v0, |v0|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call float @llvm.fabs.f32(float %src)
  %sqrt = call float @llvm.amdgcn.sqrt.f32(float %fabs.src)
  ret float %sqrt
}

define float @v_fneg_fabs_sqrt_f32(float %src)  {
; GCN-LABEL: v_fneg_fabs_sqrt_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sqrt_f32_e64 v0, -|v0|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call float @llvm.fabs.f32(float %src)
  %neg.fabs.src = fneg float %fabs.src
  %sqrt = call float @llvm.amdgcn.sqrt.f32(float %neg.fabs.src)
  ret float %sqrt
}

define double @v_sqrt_f64(double %src)  {
; GCN-LABEL: v_sqrt_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call double @llvm.amdgcn.sqrt.f64(double %src)
  ret double %sqrt
}

define double @v_fabs_sqrt_f64(double %src)  {
; GCN-LABEL: v_fabs_sqrt_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sqrt_f64_e64 v[0:1], |v[0:1]|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call double @llvm.fabs.f64(double %src)
  %sqrt = call double @llvm.amdgcn.sqrt.f64(double %fabs.src)
  ret double %sqrt
}

define double @v_fneg_fabs_sqrt_f64(double %src)  {
; GCN-LABEL: v_fneg_fabs_sqrt_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sqrt_f64_e64 v[0:1], -|v[0:1]|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call double @llvm.fabs.f64(double %src)
  %neg.fabs.src = fneg double %fabs.src
  %sqrt = call double @llvm.amdgcn.sqrt.f64(double %neg.fabs.src)
  ret double %sqrt
}

declare float @llvm.amdgcn.sqrt.f32(float) #0
declare double @llvm.amdgcn.sqrt.f64(double) #0
declare float @llvm.fabs.f32(float) #0
declare double @llvm.fabs.f64(double) #0

attributes #0 = { nounwind readnone speculatable willreturn }
