/*
  vs_tab.h
	
	Copyright 2006 David Yeh <dtyeh@ccrma.stanford.edu>
	
	http://quitte.de/dsp/

	Tone Stack emulation coefficient table for lattice filter.

*/
/*
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA or point your web browser to http://www.gnu.org.
*/


#ifndef _VS_TAB_H_
#define _VS_TAB_H_

namespace DSP {

double ToneStackVS[] = {
  -9.45385446026598e-06,-0.00655412425867525,0.0132200144354443,0.0102188726276126,
  -1.24191436832038e-05,-0.00586705925752717,0.0294688298274704,-0.0216003374232777,
  -1.53844329061348e-05,-0.00517999425637911,0.0457176452194964,-0.053419547474168,
  -1.83497221290796e-05,-0.00449292925523104,0.0619664606115225,-0.0852387575250582,
  -2.13150113519966e-05,-0.00380586425408297,0.0782152760035486,-0.117057967575949,
  -2.42803005748859e-05,-0.00311879925293479,0.0944640913955747,-0.148877177626839,
  -2.72455897978585e-05,-0.00243173425178678,0.110712906787601,-0.180696387677729,
  -3.02108790207201e-05,-0.00174466925063865,0.126961722179627,-0.212515597728619,
  -3.31761682436094e-05,-0.00105760424949042,0.143210537571653,-0.24433480777951,
  -3.61414574664987e-05,-0.000370539248342183,0.159459352963679,-0.2761540178304,
  -3.9106746689721e-05,0.000316525752805275,0.175708168355705,-0.30797322788129,
  -4.20720359125548e-05,0.0010035907539534,0.191956983747731,-0.339792437932181,
  -4.50373251356662e-05,0.00169065575510152,0.208205799139757,-0.371611647983071,
  -4.80026143581114e-05,0.00237772075625009,0.224454614531783,-0.403430858033961,
  -5.09679035813893e-05,0.00306478575739821,0.24070342992381,-0.435250068084851,
  -5.3933192804112e-05,0.00375185075854612,0.256952245315835,-0.467069278135742,
  -5.68984820269458e-05,0.00443891575969446,0.273201060707862,-0.498888488186632,
  -5.98637712498906e-05,0.00512598076084236,0.289449876099888,-0.530707698237522,
  -6.28290604727244e-05,0.00581304576199071,0.305698691491914,-0.562526908288412,
  -6.57943496960023e-05,0.00650011076313839,0.32194750688394,-0.594346118339303,
  -6.87596389189471e-05,0.00718717576428629,0.338196322275966,-0.626165328390193,
  -7.17249281420029e-05,0.00787424076543397,0.354445137667992,-0.657984538441083,
  -7.46902173648367e-05,0.00856130576658254,0.370693953060018,-0.689803748491973,
  -7.76555065876705e-05,0.00924837076773066,0.386942768452044,-0.721622958542864,
  -8.06207958105043e-05,0.00993543576887879,0.40319158384407,-0.753442168593754,
  -9.41939857081013e-06,-0.00655319504622455,0.0132268917091642,0.0102210248142172,
  -1.23601628603601e-05,-0.00586780948081826,0.0294548118993129,-0.0216122564867453,
  -1.53009271499499e-05,-0.00518242391541199,0.0456827320894617,-0.0534455377877077,
  -1.82416914396022e-05,-0.00449703835000587,0.0619106522796104,-0.0852788190886702,
  -2.11824557291018e-05,-0.0038116527845995,0.0781385724697592,-0.117112100389633,
  -2.41232200187957e-05,-0.00312626721919329,0.094366492659908,-0.148945381690595,
  -2.70639843083231e-05,-0.00244088165378709,0.110594412850057,-0.180778662991558,
  -3.00047485976007e-05,-0.00175549608838033,0.126822333040206,-0.21261194429252,
  -3.29455128875722e-05,-0.00107011052297457,0.143050253230354,-0.244445225593482,
  -3.58862771771551e-05,-0.000384724957568361,0.159278173420503,-0.276278506894445,
  -3.8827041466738e-05,0.000300660607837733,0.175506093610652,-0.308111788195407,
  -4.17678057565429e-05,0.000986046173243826,0.191734013800801,-0.33994506949637,
  -4.47085700459038e-05,0.00167143173865036,0.207961933990949,-0.371778350797332,
  -4.76493343355422e-05,0.00235681730405624,0.224189854181098,-0.403611632098295,
  -5.05900986250696e-05,0.00304220286946277,0.240417774371247,-0.435444913399257,
  -5.35308629144859e-05,0.00372758843486909,0.256645694561396,-0.46727819470022,
  -5.64716272042354e-05,0.00441297400027518,0.272873614751544,-0.499111476001182,
  -5.94123914935407e-05,0.00509835956568172,0.289101534941693,-0.530944757302145,
  -6.23531557831791e-05,0.00578374513108781,0.305329455131842,-0.562778038603107,
  -6.52939200728175e-05,0.00646913069649413,0.32155737532199,-0.594611319904069,
  -6.8234684362567e-05,0.00715451626190022,0.337785295512139,-0.626444601205032,
  -7.11754486519833e-05,0.00783990182730676,0.354013215702288,-0.658277882505994,
  -7.41162129419548e-05,0.00852528739271241,0.370241135892437,-0.690111163806957,
  -7.70569772319263e-05,0.00921067295811806,0.386469056082585,-0.721944445107919,
  -7.99977415204545e-05,0.00989605852352593,0.402696976272735,-0.753777726408882,
  -9.37160003060961e-06,-0.00655190758967857,0.0132364072721412,0.0102240017427008,
  -1.22785730753069e-05,-0.00586885694194833,0.0294354064091315,-0.0216287430680944,
  -1.51855461200251e-05,-0.00518580629421808,0.0456344055461219,-0.0534814878788896,
  -1.80925191646669e-05,-0.00450275564648778,0.0618334046831123,-0.0853342326896848,
  -2.09994922094614e-05,-0.00381970499875756,0.0780324038201028,-0.11718697750048,
  -2.3906465254131e-05,-0.00313665435102717,0.0942314029570933,-0.149039722311275,
  -2.68134382989116e-05,-0.00245360370329706,0.110430402094084,-0.18089246712207,
  -2.97204113434146e-05,-0.0017705530555665,0.126629401231074,-0.212745211932866,
  -3.26273843883063e-05,-0.00108750240783662,0.142828400368064,-0.244597956743661,
  -3.55343574329758e-05,-0.000404451760106284,0.159027399505055,-0.276450701554456,
  -3.84413304777564e-05,0.000278598887623938,0.175226398642045,-0.308303446365251,
  -4.1348303522426e-05,0.000961649535354159,0.191425397779036,-0.340156191176046,
  -4.42552765669846e-05,0.0016447001830846,0.207624396916026,-0.372008935986842,
  -4.71622496115987e-05,0.00232775083081505,0.223823396053016,-0.403861680797637,
  -5.00692226566013e-05,0.0030108014785446,0.240022395190006,-0.435714425608432,
  -5.29761957012154e-05,0.00369385212627549,0.256221394326997,-0.467567170419227,
  -5.58831687457184e-05,0.00437690277400571,0.272420393463988,-0.499419915230022,
  -5.87901417908876e-05,0.00505995342173526,0.288619392600978,-0.531272660040818,
  -6.16971148355017e-05,0.00574300406946571,0.304818391737968,-0.563125404851613,
  -6.46040878798937e-05,0.00642605471719659,0.321017390874959,-0.594978149662408,
  -6.75110609249518e-05,0.00710910536492637,0.337216390011949,-0.626830894473203,
  -7.04180339694549e-05,0.00779215601265681,0.35341538914894,-0.658683639283998,
  -7.33250070134028e-05,0.0084752066603877,0.36961438828593,-0.690536384094793,
  -7.62319800590161e-05,0.0091582573081177,0.385813387422921,-0.722389128905589,
  -7.91389531040743e-05,0.00984130795584681,0.40201238655991,-0.754241873716384,
  -9.30551244646138e-06,-0.00655013053761504,0.0132495164937455,0.0102281012526002,
  -1.21662034849382e-05,-0.00587031791026438,0.0294086533311691,-0.0216514466378377,
  -1.5026894523415e-05,-0.00519050528291368,0.0455677901685926,-0.0535309945282756,
  -1.78875855619126e-05,-0.00451069265556314,0.0617269270060161,-0.0854105424187135,
  -2.07482766004519e-05,-0.00383088002821247,0.0778860638434397,-0.117290090309151,
  -2.36089676389495e-05,-0.00315106740086191,0.0940452006808631,-0.149169638199589,
  -2.64696586773916e-05,-0.00247125477351118,0.110204337518287,-0.181049186090027,
  -2.93303497158059e-05,-0.00179144214616056,0.12636347435571,-0.212928733980465,
  -3.21910407543036e-05,-0.00111162951880983,0.142522611193134,-0.244808281870903,
  -3.50517317928567e-05,-0.000431816891459214,0.158681748030557,-0.276687829761341,
  -3.79124228314653e-05,0.000247995735891182,0.174840884867981,-0.308567377651779,
  -4.07731138695744e-05,0.000927808363242466,0.191000021705405,-0.340446925542217,
  -4.36338049084051e-05,0.00160762099059264,0.207159158542828,-0.372326473432655,
  -4.64944959466806e-05,0.00228743361794348,0.223318295380251,-0.404206021323093,
  -4.93551869851228e-05,0.0029672462452941,0.239477432217675,-0.436085569213531,
  -5.22158780237314e-05,0.00364705887264472,0.255636569055099,-0.467965117103969,
  -5.50765690616739e-05,0.00432687149999578,0.271795705892522,-0.499844664994407,
  -5.79372601006156e-05,0.00500668412734617,0.287954842729946,-0.531724212884844,
  -6.07979511390022e-05,0.00568649675469701,0.304113979567369,-0.563603760775282,
  -6.36586421778329e-05,0.00636630938204696,0.320273116404793,-0.59548330866572,
  -6.65193332161085e-05,0.00704612200939803,0.336432253242216,-0.627362856556158,
  -6.93800242546061e-05,0.00772593463674864,0.35259139007964,-0.659242404446596,
  -7.22407152924376e-05,0.00840574726410015,0.368750526917063,-0.691121952337034,
  -7.51014063312683e-05,0.00908555989145032,0.384909663754487,-0.723001500227472,
  -7.79620973696549e-05,0.00976537251880094,0.40106880059191,-0.75488104811791,
  -9.21455795741509e-06,-0.00654769054013065,0.0132674694997489,0.01023371233782,
  -1.20123774072986e-05,-0.00587235235406242,0.0293719796792397,-0.0216825214901362,
  -1.48101968571318e-05,-0.00519701416799415,0.0454764898587305,-0.0535987553180923,
  -1.76080163070691e-05,-0.00452167598192593,0.0615810000382213,-0.0855149891460485,
  -2.04058357570203e-05,-0.0038463377958578,0.0776855102177121,-0.117431222974005,
  -2.32036552068604e-05,-0.0031709996097895,0.0937900203972029,-0.149347456801961,
  -2.60014746567283e-05,-0.00249566142372137,0.109894530576694,-0.181263690629917,
  -2.87992941066517e-05,-0.00182032323765302,0.125999040756185,-0.213179924457873,
  -3.15971135562698e-05,-0.00114498505158456,0.142103550935675,-0.245096158285829,
  -3.4394933006443e-05,-0.000469646865516538,0.158208061115166,-0.277012392113785,
  -3.71927524563387e-05,0.000205691320551926,0.174312571294657,-0.308928625941742,
  -3.99905719063454e-05,0.000881029506619724,0.190417081474148,-0.340844859769698,
  -4.27883913557969e-05,0.00155636769268885,0.206521591653639,-0.372761093597654,
  -4.55862108061367e-05,0.00223170587875599,0.222626101833129,-0.40467732742561,
  -4.83840302557548e-05,0.00290704406482489,0.23873061201262,-0.436593561253566,
  -5.11818497057615e-05,0.00358238225089269,0.254835122192111,-0.468509795081522,
  -5.39796691556571e-05,0.00425772043696138,0.270939632371602,-0.500426028909479,
  -5.67774886057748e-05,0.00493305862302873,0.287044142551092,-0.532342262737435,
  -5.95753080553374e-05,0.00560839680909742,0.303148652730583,-0.564258496565391,
  -6.2373127505011e-05,0.00628373499516632,0.319253162910074,-0.596174730393347,
  -6.51709469547956e-05,0.00695907318123457,0.335357673089565,-0.628090964221303,
  -6.79687664046913e-05,0.00763441136730281,0.351462183269056,-0.660007198049259,
  -7.07665858552531e-05,0.00830974955337016,0.367566693448546,-0.691923431877215,
  -7.35644053048157e-05,0.00898508773943885,0.383671203628037,-0.723839665705172,
  -7.63622247547113e-05,0.00966042592550664,0.399775713807528,-0.755755899533128,
  -9.0901720242835e-06,-0.00654436433726225,0.0132918568674893,0.0102413285781499,
  -1.18035387460871e-05,-0.00587517815686124,0.0293220966544303,-0.0217247011281304,
  -1.45169054678873e-05,-0.00520599197646027,0.0453523364413711,-0.0536907308344107,
  -1.72302721896667e-05,-0.00453680579605925,0.061382576228312,-0.0856567605406909,
  -1.99436389114738e-05,-0.00386761961565824,0.077412816015253,-0.117622790246971,
  -2.26570056333086e-05,-0.00319843343525739,0.0934430558021937,-0.149588819953251,
  -2.53703723551435e-05,-0.00252924725485637,0.109473295589135,-0.181554849659532,
  -2.80837390769784e-05,-0.00186006107445547,0.125503535376076,-0.213520879365812,
  -3.07971057986745e-05,-0.00119087489405445,0.141533775163016,-0.245486909072092,
  -3.35104725203705e-05,-0.000521688713653212,0.157564014949957,-0.277452938778373,
  -3.62238392423997e-05,0.00014749746674747,0.173594254736898,-0.309418968484653,
  -3.89372059641513e-05,0.000816683647148375,0.189624494523839,-0.341384998190933,
  -4.16505726857919e-05,0.00148586982754972,0.20565473431078,-0.373351027897213,
  -4.43639394076545e-05,0.00215505600795085,0.221684974097721,-0.405317057603494,
  -4.70773061294061e-05,0.00282424218835153,0.237715213884662,-0.437283087309774,
  -4.97906728511577e-05,0.00349342836875288,0.253745453671603,-0.469249117016054,
  -5.25040395730203e-05,0.00416261454915356,0.269775693458544,-0.501215146722335,
  -5.52174062947719e-05,0.00483180072955491,0.285805933245485,-0.533181176428615,
  -5.79307730167455e-05,0.00550098690995537,0.301836173032425,-0.565147206134895,
  -6.06441397383861e-05,0.00617017309035606,0.317866412819366,-0.597113235841175,
  -6.33575064603598e-05,0.00683935927075741,0.333896652606307,-0.629079265547456,
  -6.60708731822224e-05,0.00750854545115809,0.349926892393248,-0.661045295253736,
  -6.87842399037519e-05,0.00817773163155922,0.365957132180188,-0.693011324960016,
  -7.14976066260586e-05,0.0088469178119599,0.38198737196713,-0.724977354666296,
  -7.42109733471441e-05,0.00951610399236191,0.398017611754071,-0.756943384372577,
  -8.92153915172701e-06,-0.00653987441482468,0.013324621159271,0.0102515503577533,
  -1.15231835207535e-05,-0.00587908717616796,0.0292549605824841,-0.021781310550188,
  -1.41248278898304e-05,-0.00521829993751122,0.0451853000056971,-0.0538141714581293,
  -1.67264722587823e-05,-0.00455751269885435,0.0611156394289102,-0.0858470323660706,
  -1.93281166278592e-05,-0.0038967254601977,0.0770459788521232,-0.117879893274012,
  -2.1929760996936e-05,-0.003235938221541,0.0929763182753361,-0.149912754181953,
  -2.45314053658185e-05,-0.00257515098288408,0.108906657698549,-0.181945615089894,
  -2.71330497349509e-05,-0.00191436374422738,0.124836997121762,-0.213978475997836,
  -2.97346941040555e-05,-0.00125357650557101,0.140767336544975,-0.246011336905777,
  -3.23363384731046e-05,-0.000592789266914084,0.156697675968188,-0.278044197813718,
  -3.49379828420981e-05,6.79979717426171e-05,0.172628015391401,-0.31007705872166,
  -3.75396272110917e-05,0.00072878521039943,0.188558354814614,-0.342109919629601,
  -4.01412715799743e-05,0.00138957244905646,0.204488694237827,-0.374142780537542,
  -4.27429159494674e-05,0.00205035968771239,0.22041903366104,-0.406175641445483,
  -4.5344560318239e-05,0.00271114692636965,0.236349373084253,-0.438208502353425,
  -4.79462046875101e-05,0.00337193416502601,0.252279712507466,-0.470241363261366,
  -5.05478490560041e-05,0.00403272140368327,0.268210051930679,-0.502274224169307,
  -5.31494934248311e-05,0.0046935086423403,0.284140391353892,-0.534307085077249,
  -5.57511377943243e-05,0.00535429588099645,0.300070730777105,-0.56633994598519,
  -5.83527821632623e-05,0.00601508311965326,0.316001070200318,-0.598372806893131,
  -6.09544265320894e-05,0.00667587035831074,0.331931409623532,-0.630405667801072,
  -6.35560709016936e-05,0.00733665759696622,0.347861749046744,-0.662438528709014,
  -6.61577152706316e-05,0.00799744483562348,0.363792088469957,-0.694471389616955,
  -6.87593596394587e-05,0.00865823207428029,0.379722427893171,-0.726504250524896,
  -7.13610040086188e-05,0.00931901931293666,0.395652767316383,-0.758537111432838,
  -8.69560363404333e-06,-0.00653389357768309,0.0133679932546893,0.0102650629330693,
  -1.1152452480033e-05,-0.00588445970216538,0.0291658802327748,-0.0218561447873589,
  -1.36093013259897e-05,-0.00523502582664756,0.0449637672108603,-0.0539773525077871,
  -1.60661501719533e-05,-0.00458559195112979,0.0607616541889458,-0.0860985602282153,
  -1.85229990179725e-05,-0.0039361580756121,0.0765595411670313,-0.118219767948644,
  -2.09798478638945e-05,-0.00328672420009424,0.0923574281451169,-0.150340975669072,
  -2.34366967097333e-05,-0.00263729032457627,0.108155315123202,-0.1824621833895,
  -2.58935455558218e-05,-0.00198785644905874,0.123953202101288,-0.214583391109928,
  -2.83503944018548e-05,-0.00133842257354089,0.139751089079374,-0.246704598830356,
  -3.08072432478879e-05,-0.000688988698023363,0.155548976057459,-0.278825806550785,
  -3.32640920938099e-05,-3.95548225053943e-05,0.171346863035544,-0.310947014271213,
  -3.57209409400649e-05,0.000609879053012019,0.18714475001363,-0.343068221991641,
  -3.81777897856539e-05,0.0012593129285301,0.202942636991715,-0.375189429712069,
  -4.06346386317979e-05,0.00190874680404773,0.218740523969801,-0.407310637432497,
  -4.30914874776089e-05,0.00255818067956581,0.234538410947887,-0.439431845152926,
  -4.55483363235309e-05,0.00320761455508323,0.250336297925972,-0.471553052873354,
  -4.8005185169453e-05,0.00385704843060108,0.266134184904057,-0.503674260593782,
  -5.0462034015486e-05,0.00450648230611894,0.281932071882143,-0.53579546831421,
  -5.2918882861519e-05,0.0051559161816368,0.297729958860229,-0.567916676034638,
  -5.53757317078851e-05,0.00580535005715377,0.313527845838314,-0.600037883755067,
  -5.78325805538071e-05,0.00645478393267185,0.329325732816399,-0.632159091475495,
  -6.02894293996181e-05,0.00710421780819015,0.345123619794485,-0.664280299195923,
  -6.27462782459842e-05,0.00775365168370667,0.36092150677257,-0.696401506916351,
  -6.52031270920173e-05,0.00840308555922498,0.376719393750656,-0.72852271463678,
  -6.76599759376062e-05,0.00905251943474328,0.392517280728742,-0.760643922357208,
  -8.3976552870263e-06,-0.00652606653885501,0.0134242963979835,0.0102825726841942,
  -1.0671874045888e-05,-0.00589176903631011,0.029049889087214,-0.0219531158559996,
  -1.29460928047914e-05,-0.0052574715337653,0.0446754817764445,-0.0541888043961935,
  -1.52203115635907e-05,-0.00462317403122031,0.060301074465675,-0.0864244929363873,
  -1.74945303223761e-05,-0.0039888765286753,0.0759266671549055,-0.118660181476581,
  -1.97687490813003e-05,-0.00335457902613046,0.091552259844136,-0.150895870016775,
  -2.2042967840058e-05,-0.0027202815235855,0.107177852533366,-0.183131558556969,
  -2.43171865989544e-05,-0.00208598402104065,0.122803445222597,-0.215367247097163,
  -2.65914053579897e-05,-0.00145168651849592,0.138429037911827,-0.247602935637357,
  -2.88656241165808e-05,-0.000817389015950853,0.154054630601058,-0.27983862417755,
  -3.11398428753384e-05,-0.000183091513405786,0.169680223290288,-0.312074312717744,
  -3.34140616344847e-05,0.000451205989138836,0.185305815979519,-0.344310001257938,
  -3.56882803931313e-05,0.00108550349168413,0.200931408668749,-0.376545689798132,
  -3.7962499152e-05,0.00171980099422875,0.21655700135798,-0.408781378338326,
  -4.02367179110907e-05,0.00235409849677359,0.23218259404721,-0.44101706687852,
  -4.25109366696264e-05,0.00298839599931844,0.24780818673644,-0.473252755418713,
  -4.47851554288281e-05,0.00362269350186306,0.263433779425671,-0.505488443958907,
  -4.70593741874747e-05,0.00425699100440813,0.279059372114901,-0.537724132499101,
  -4.93335929462324e-05,0.00489128850695342,0.294684964804132,-0.569959821039295,
  -5.16078117052121e-05,0.00552558600949804,0.310310557493362,-0.602195509579489,
  -5.38820304641918e-05,0.00615988351204289,0.325936150182593,-0.634431198119683,
  -5.61562492230605e-05,0.00679418101458751,0.341561742871823,-0.666666886659877,
  -5.84304679815961e-05,0.00742847851713302,0.357187335561054,-0.69890257520007,
  -6.07046867409089e-05,0.00806277601967764,0.372812928250285,-0.731138263740264,
  -6.29789054994445e-05,0.00869707352222271,0.388438520939515,-0.763373952280458,
  -8.01288922574507e-06,-0.00651605811818941,0.0134955599712367,0.0103046842885544,
  -1.00647415169075e-05,-0.00590156051043475,0.0289025106675619,-0.0220755725310754,
  -1.21165938081064e-05,-0.00528706290268011,0.0443094613638871,-0.0544558293507052,
  -1.41684460992636e-05,-0.00467256529492538,0.0597164120602123,-0.0868360861703351,
  -1.62202983903792e-05,-0.00405806768717071,0.0751233627565375,-0.119216342989965,
  -1.82721506816752e-05,-0.0034435700794162,0.0905303134528626,-0.151596599809595,
  -2.03240029728324e-05,-0.00282907247166142,0.105937264149188,-0.183976856629224,
  -2.23758552639897e-05,-0.00221457486390686,0.121344214845513,-0.216357113448854,
  -2.44277075554522e-05,-0.00160007725615263,0.136751165541838,-0.248737370268484,
  -2.64795598463041e-05,-0.000985579648397295,0.152158116238164,-0.281117627088114,
  -2.85314121376001e-05,-0.000371082040642845,0.167565066934489,-0.313497883907744,
  -3.05832644285076e-05,0.000243415567112271,0.182972017630814,-0.345878140727373,
  -3.26351167200811e-05,0.000857913174866054,0.198378968327139,-0.378258397547003,
  -3.46869690107665e-05,0.00147241078262139,0.213785919023464,-0.410638654366633,
  -3.67388213020625e-05,0.00208690839037606,0.22919286971979,-0.443018911186263,
  -3.87906735930255e-05,0.00270140599813096,0.244599820416115,-0.475399168005893,
  -4.08425258842104e-05,0.00331590360588563,0.26000677111244,-0.507779424825523,
  -4.28943781759505e-05,0.00393040121363963,0.275413721808765,-0.540159681645152,
  -4.49462304674686e-05,0.00454489882139342,0.29082067250509,-0.572539938464782,
  -4.69980827583205e-05,0.00515939642914853,0.306227623201415,-0.604920195284412,
  -4.90499350497275e-05,0.0057738940369032,0.321634573897741,-0.637300452104042,
  -5.11017873406905e-05,0.00638839164465788,0.337041524594066,-0.669680708923672,
  -5.31536396312093e-05,0.00700288925241388,0.352448475290392,-0.702060965743301,
  -5.52054919231715e-05,0.00761738686016722,0.367855425986716,-0.734441222562931,
  -5.72573442142454e-05,0.00823188446792233,0.383262376683042,-0.766821479382561,
  -7.52930152583819e-06,-0.00650363431344411,0.013582925522093,0.0103317153026516,
  -9.32223570344892e-06,-0.00591438229124575,0.0287209743777398,-0.0222252734779792,
  -1.11151698810596e-05,-0.00532513026904735,0.0438590232333866,-0.0547822622586099,
  -1.29081040586843e-05,-0.00473587824684896,0.0589970720890334,-0.0873392510392406,
  -1.47010382363366e-05,-0.00414662622465067,0.0741351209446801,-0.119896239819871,
  -1.6493972413878e-05,-0.00355737420245217,0.089273169800327,-0.152453228600502,
  -1.82869065915581e-05,-0.002968122180254,0.104411218655974,-0.185010217381133,
  -2.00798407690717e-05,-0.00237887015805549,0.11954926751162,-0.217567206161764,
  -2.18727749466407e-05,-0.00178961813585721,0.134687316367267,-0.250124194942394,
  -2.36657091243209e-05,-0.0012003661136587,0.149825365222914,-0.282681183723025,
  -2.54586433019455e-05,-0.000611114091460196,0.164963414078561,-0.315238172503656,
  -2.72515774794035e-05,-2.18620692618021e-05,0.180101462934208,-0.347795161284287,
  -2.90445116573057e-05,0.000567389952936148,0.195239511789854,-0.380352150064917,
  -3.08374458347638e-05,0.00115664197513499,0.210377560645501,-0.412909138845548,
  -3.26303800124439e-05,0.00174589399733294,0.225515609501148,-0.445466127626179,
  -3.44233141897909e-05,0.00233514601953178,0.240653658356795,-0.478023116406809,
  -3.62162483674711e-05,0.00292439804172973,0.255791707212441,-0.51058010518744,
  -3.80091825449291e-05,0.00351365006392879,0.270929756068088,-0.543137093968071,
  -3.98021167228313e-05,0.00410290208612651,0.286067804923735,-0.575694082748702,
  -4.15950509007335e-05,0.00469215410832424,0.301205853779381,-0.608251071529333,
  -4.33879850779695e-05,0.00528140613052308,0.316343902635028,-0.640808060309963,
  -4.51809192555386e-05,0.00587065815272148,0.331481951490675,-0.673365049090594,
  -4.69738534332187e-05,0.00645991017492031,0.346620000346322,-0.705922037871225,
  -4.87667876102327e-05,0.0070491621971196,0.361758049201969,-0.738479026651855,
  -5.05597217874687e-05,0.00763841421931799,0.376896098057616,-0.771036015432486,
  -6.94191090454613e-06,-0.00648876962972663,0.0136859348298208,0.0103634789907996,
  -8.44945441232786e-06,-0.00593064844059443,0.0285057295183049,-0.0224011845324374,
  -9.95699792012694e-06,-0.00537252725146228,0.0433255242067889,-0.0551658480556743,
  -1.14645414278775e-05,-0.00481440606233002,0.058145318895273,-0.0879305115789112,
  -1.29720849357529e-05,-0.0042562848731979,0.072965113583757,-0.120695175102148,
  -1.44796284435034e-05,-0.00369816368406561,0.0877849082722411,-0.153459838625385,
  -1.59871719514204e-05,-0.00314004249493371,0.102604702960725,-0.186224502148622,
  -1.74947154590321e-05,-0.00258192130580115,0.117424497649209,-0.218989165671859,
  -1.90022589668382e-05,-0.00202380011666892,0.132244292337693,-0.251753829195096,
  -2.05098024746442e-05,-0.00146567892753702,0.147064087026177,-0.284518492718333,
  -2.20173459823392e-05,-0.000907557738404785,0.161883881714661,-0.31728315624157,
  -2.35248894902007e-05,-0.00034943654927222,0.176703676403146,-0.350047819764807,
  -2.50324329980067e-05,0.00020868463985968,0.191523471091629,-0.382812483288044,
  -2.65399765057572e-05,0.000766805828992023,0.206343265780114,-0.41557714681128,
  -2.80475200135077e-05,0.00132492701812392,0.221163060468597,-0.448341810334518,
  -2.95550635217579e-05,0.00188304820725582,0.235982855157082,-0.481106473857754,
  -3.10626070293418e-05,0.00244116939638794,0.250802649845565,-0.513871137380991,
  -3.25701505368148e-05,0.00299929058552095,0.26562244453405,-0.546635800904228,
  -3.40776940450649e-05,0.00355741177465219,0.280442239222533,-0.579400464427465,
  -3.55852375527599e-05,0.00411553296378475,0.295262033911018,-0.612165127950702,
  -3.70927810602328e-05,0.00467365415291665,0.310081828599501,-0.644929791473939,
  -3.86003245683719e-05,0.00523177534204899,0.324901623287986,-0.677694454997176,
  -4.01078680751787e-05,0.00578989653118223,0.33972141797647,-0.710459118520413,
  -4.16154115836509e-05,0.00634801772031368,0.354541212664954,-0.74322378204365,
  -4.31229550911238e-05,0.00690613890944647,0.369361007353438,-0.775988445566887,
  -6.25744233416145e-06,-0.00647175054085835,0.0138019486649254,0.0103991149008061,
  -7.47014513666905e-06,-0.00595044294930479,0.0282617694880461,-0.0225985404086382,
  -8.68284793918705e-06,-0.00542913535775125,0.0427215903111668,-0.0555961957180824,
  -9.89555074168424e-06,-0.00490782776619769,0.0571814111342875,-0.0885938510275267,
  -1.11082535440843e-05,-0.00438652017464386,0.0716412319574083,-0.121591506336971,
  -1.23209563467896e-05,-0.00386521258309058,0.0861010527805289,-0.154589161646415,
  -1.35336591492452e-05,-0.00334390499153692,0.10056087360365,-0.187586816955859,
  -1.47463619518118e-05,-0.00282259739998358,0.11502069442677,-0.220584472265304,
  -1.59590647544339e-05,-0.00230128980843014,0.129480515249891,-0.253582127574748,
  -1.71717675567229e-05,-0.00177998221687636,0.143940336073011,-0.286579782884192,
  -1.8384470359234e-05,-0.0012586746253227,0.158400156896132,-0.319577438193636,
  -1.95971731619116e-05,-0.000737367033769365,0.172859977719253,-0.352575093503081,
  -2.08098759644781e-05,-0.00021605944221581,0.187319798542374,-0.385572748812525,
  -2.20225787666006e-05,0.000305248149338189,0.201779619365494,-0.418570404121969,
  -2.32352815692227e-05,0.000826555740891521,0.216239440188615,-0.451568059431413,
  -2.44479843719558e-05,0.00134786333244508,0.230699261011736,-0.484565714740858,
  -2.56606871742449e-05,0.00186917092399863,0.245159081834856,-0.517563370050302,
  -2.68733899767559e-05,0.00239047851555263,0.259618902657977,-0.550561025359746,
  -2.8086092779267e-05,0.00291178610710552,0.274078723481097,-0.58355868066919,
  -2.92987955821111e-05,0.00343309369865907,0.288538544304218,-0.616556335978635,
  -3.05114983847332e-05,0.00395440129021241,0.302998365127339,-0.649553991288079,
  -3.17242011863561e-05,0.00447570888176729,0.31745818595046,-0.682551646597523,
  -3.29369039892002e-05,0.00499701647331996,0.33191800677358,-0.715549301906967,
  -3.41496067919334e-05,0.00551832406487396,0.346377827596702,-0.748546957216412,
  -3.53623095941114e-05,0.00603963165642796,0.360837648419822,-0.781544612525856,
  -5.49750577741662e-06,-0.00645322180163136,0.0139260535767921,0.0104370764441712,
  -6.42707927860781e-06,-0.00597333040810041,0.0279990091067501,-0.0228087759169046,
  -7.35665277980246e-06,-0.00549343901456942,0.0420719646367081,-0.0560546282779804,
  -8.28622628097631e-06,-0.00501354762103851,0.0561449201666661,-0.0893004806390561,
  -9.21579978216402e-06,-0.00453365622750751,0.0702178756966241,-0.122546333000132,
  -1.01453732834489e-05,-0.00405376483397657,0.0842908312265822,-0.155792185361208,
  -1.10749467846227e-05,-0.00357387344044569,0.0983637867565402,-0.189038037722283,
  -1.20045202858798e-05,-0.00309398204691469,0.112436742286498,-0.222283890083359,
  -1.29340937870537e-05,-0.0026140906533838,0.126509697816456,-0.255529742444435,
  -1.3863667288283e-05,-0.0021341992598527,0.140582653346414,-0.288775594805511,
  -1.47932407890683e-05,-0.00165430786632137,0.154655608876372,-0.322021447166586,
  -1.57228142906307e-05,-0.00117441647279093,0.16872856440633,-0.355267299527662,
  -1.66523877918601e-05,-0.000694525079260044,0.182801519936288,-0.388513151888738,
  -1.75819612930894e-05,-0.000214633685728938,0.196874475466246,-0.421759004249814,
  -1.85115347942633e-05,0.000265257707802169,0.210947430996204,-0.455004856610889,
  -1.94411082952151e-05,0.000745149101333054,0.225020386526162,-0.488250708971965,
  -2.0370681796722e-05,0.00122504049486372,0.23909334205612,-0.521496561333041,
  -2.13002552978958e-05,0.00170493188839482,0.253166297586078,-0.554742413694117,
  -2.22298287995137e-05,0.00218482328192504,0.267239253116036,-0.587988266055192,
  -2.31594023003545e-05,0.00266471467545659,0.281312208645994,-0.621234118416268,
  -2.40889758015284e-05,0.0031446060689877,0.295385164175952,-0.654479970777344,
  -2.50185493027022e-05,0.00362449746251858,0.30945811970591,-0.68772582313842,
  -2.59481228042091e-05,0.00410438885604991,0.323531075235869,-0.720971675499495,
  -2.68776963047168e-05,0.0045842802495808,0.337604030765826,-0.754217527860571,
  -2.78072698055576e-05,0.00506417164311257,0.351676986295785,-0.787463380221647,
  -4.69784619103707e-06,-0.0064341244487738,0.0140517132106779,0.0104753474836021,
  -5.37602596115128e-06,-0.00599828914833316,0.0277310997761066,-0.0230207254509178,
  -6.05420573124293e-06,-0.00556245384789256,0.0414104863415353,-0.0565167983854377,
  -6.73238550133459e-06,-0.00512661854745189,0.055089872906964,-0.0900128713199576,
  -7.41056527139849e-06,-0.00469078324701117,0.0687692594723927,-0.123508944254477,
  -8.08874504160118e-06,-0.00425494794657066,0.0824486460378213,-0.157005017188997,
  -8.76692481163732e-06,-0.00381911264613,0.09612803260325,-0.190501090123517,
  -9.44510458161796e-06,-0.00338327734568933,0.109807419168679,-0.223997163058037,
  -1.01232843517374e-05,-0.00294744204524844,0.123486805734108,-0.257493235992557,
  -1.08014641220233e-05,-0.0025116067448081,0.137166192299536,-0.290989308927077,
  -1.14796438921427e-05,-0.00207577144436755,0.150845578864965,-0.324485381861597,
  -1.21578236620956e-05,-0.00163993614392677,0.164524965430393,-0.357981454796117,
  -1.28360034322705e-05,-0.00120410084348621,0.178204351995822,-0.391477527730637,
  -1.35141832023344e-05,-0.000768265543045654,0.191883738561251,-0.424973600665156,
  -1.41923629719543e-05,-0.000332430242603987,0.20556312512668,-0.458469673599677,
  -1.48705427427398e-05,0.000103405057835682,0.219242511692108,-0.491965746534196,
  -1.55487225127482e-05,0.000539240358276238,0.232921898257537,-0.525461819468717,
  -1.62269022826456e-05,0.000975075658717017,0.246601284822966,-0.558957892403236,
  -1.6905082053098e-05,0.00141091095915735,0.260280671388394,-0.592453965337756,
  -1.75832618231064e-05,0.00184674625959835,0.273960057953823,-0.625950038272276,
  -1.82614415930038e-05,0.00228258156003891,0.287639444519251,-0.659446111206796,
  -1.89396213633453e-05,0.00271841686047924,0.30131883108468,-0.692942184141316,
  -1.96178011332426e-05,0.00315425216092047,0.314998217650109,-0.726438257075836,
  -2.0295980903362e-05,0.0035900874613608,0.328677604215537,-0.759934330010356,
  -2.09741606734815e-05,0.00402592276180158,0.342356990780966,-0.793430402944876,
  -3.90250082043207e-06,-0.00641552001996264,0.0141720613176397,0.01051184617282,
  -4.37448407007712e-06,-0.0060238585272803,0.0274727850268507,-0.0232228595002366,
  -4.8464673197135e-06,-0.00563219703459794,0.0407735087360618,-0.0569575651732933,
  -5.318450569336e-06,-0.00524053554191556,0.0540742324452729,-0.0906922708463499,
  -5.79043381904176e-06,-0.00484887404923323,0.067374956154484,-0.124426976519407,
  -6.26241706871977e-06,-0.00445721255655085,0.0806756798636952,-0.158161682192463,
  -6.73440031839778e-06,-0.00406555106386863,0.0939764035729062,-0.19189638786552,
  -7.20638356799252e-06,-0.00367388957118608,0.107277127282117,-0.225631093538576,
  -7.67836681758727e-06,-0.00328222807850376,0.120577850991328,-0.259365799211633,
  -8.1503500671265e-06,-0.00289056658582132,0.13387857470054,-0.29310050488469,
  -8.62233331710982e-06,-0.00249890509313921,0.147179298409751,-0.326835210557746,
  -9.09431656642701e-06,-0.00210724360045633,0.160480022118962,-0.360569916230803,
  -9.56629981629931e-06,-0.00171558210777478,0.173780745828172,-0.39430462190386,
  -1.00382830660051e-05,-0.00132392061509212,0.187081469537384,-0.428039327576916,
  -1.05102663158219e-05,-0.00093225912241035,0.200382193246595,-0.461774033249973,
  -1.09822495653056e-05,-0.00054059762972769,0.213682916955806,-0.495508738923029,
  -1.14542328149003e-05,-0.000148936137044808,0.226983640665017,-0.529243444596086,
  -1.19262160646061e-05,0.000242725355637186,0.240284364374228,-0.562978150269143,
  -1.23981993140898e-05,0.000634386848319846,0.253585088083439,-0.596712855942199,
  -1.28701825636846e-05,0.00102604834100251,0.266885811792651,-0.630447561615256,
  -1.33421658133903e-05,0.00141770983368428,0.280186535501861,-0.664182267288313,
  -1.38141490630961e-05,0.00180937132636672,0.293487259211072,-0.697916972961369,
  -1.42861323125798e-05,0.00220103281904915,0.306787982920284,-0.731651678634426,
  -1.47581155621745e-05,0.00259269431173204,0.320088706629495,-0.765386384307482,
  -1.52300988118803e-05,0.00298435580441403,0.333389430338706,-0.799121089980539,
  -3.15450593771707e-06,-0.00639836367314161,0.0142813348790851,0.0105448567245102,
  -3.46966136174215e-06,-0.00604847237755808,0.0272367924321802,-0.0234056758321753,
  -3.78481678578457e-06,-0.00569858108197457,0.0401922499852753,-0.0573562083888607,
  -4.09997220975067e-06,-0.00534868978639097,0.0531477075383705,-0.0913067409455462,
  -4.41512763380003e-06,-0.00499879849080748,0.0661031650914656,-0.125257273502232,
  -4.73028305778e-06,-0.00464890719522393,0.0790586226445607,-0.159207806058917,
  -5.04543848189876e-06,-0.00429901589964066,0.0920140801976557,-0.193158338615603,
  -5.36059390598975e-06,-0.00394912460405705,0.104969537750751,-0.227108871172288,
  -5.6757493298587e-06,-0.00359923330847345,0.117924995303846,-0.261059403728973,
  -5.99090475406072e-06,-0.00324934201289007,0.130880452856941,-0.295009936285659,
  -6.30606017787416e-06,-0.00289945071730635,0.143835910410036,-0.328960468842344,
  -6.62121560207618e-06,-0.00254955942172308,0.156791367963131,-0.36291100139903,
  -6.93637102644473e-06,-0.00219966812614003,0.169746825516226,-0.396861533955715,
  -7.25152645009164e-06,-0.00184977683055632,0.182702283069321,-0.430812066512401,
  -7.56668187429366e-06,-0.0014998855349726,0.195657740622417,-0.464762599069086,
  -7.8818372976075e-06,-0.00114999423938844,0.208613198175512,-0.498713131625771,
  -8.19699272203156e-06,-0.000800102943805614,0.221568655728607,-0.532663664182457,
  -8.51214814623358e-06,-0.000450211648221899,0.234524113281702,-0.566614196739142,
  -8.82730357021355e-06,-0.000100320352638184,0.247479570834797,-0.600564729295828,
  -9.14245899419353e-06,0.00024957094294531,0.260435028387892,-0.634515261852513,
  -9.45761441828452e-06,0.000599462238529025,0.273390485940988,-0.668465794409199,
  -9.77276984193143e-06,0.000949353534112074,0.286345943494082,-0.702416326965884,
  -1.00879252662445e-05,0.00129924482969601,0.299301401047178,-0.736366859522569,
  -1.04030806905575e-05,0.00164913612527906,0.312256858600273,-0.770317392079255,
  -1.07182361138713e-05,0.00199902742086389,0.325212316153368,-0.80426792463594,
  -2.48707302702086e-06,-0.00638332336523917,0.0143758510640176,0.010573310890299,
  -2.6907122829406e-06,-0.00607082502746692,0.0270315710667872,-0.0235632583611409,
  -2.89435153885687e-06,-0.00575832668969467,0.0396872910695568,-0.0576998276125807,
  -3.09799079484252e-06,-0.00544582835192253,0.0523430110723264,-0.0918363968640206,
  -3.30163005066164e-06,-0.00513333001415006,0.0649987310750962,-0.12597296611546,
  -3.50526930659179e-06,-0.00482083167637792,0.0776544510778657,-0.1601095353669,
  -3.70890856268846e-06,-0.00450833333860579,0.0903101710806353,-0.19424610461834,
  -3.91254781845207e-06,-0.00419583500083331,0.102965891083405,-0.22838267386978,
  -4.11618707457651e-06,-0.00388333666306151,0.115621611086174,-0.26251924312122,
  -4.31982633031236e-06,-0.00357083832528893,0.128277331088944,-0.29665581237266,
  -4.52346558621475e-06,-0.00325833998751657,0.140933051091714,-0.330792381624099,
  -4.72710484206162e-06,-0.00294584164974432,0.153588771094483,-0.364928950875539,
  -4.93074409807503e-06,-0.00263334331197229,0.166244491097253,-0.399065520126979,
  -5.13438335397742e-06,-0.00232084497420004,0.178900211100022,-0.433202089378419,
  -5.33802260993532e-06,-0.00200834663642757,0.191555931102792,-0.467338658629859,
  -5.54166186605975e-06,-0.00169584829865554,0.204211651105562,-0.501475227881299,
  -5.74530112196214e-06,-0.0013833499608833,0.216867371108332,-0.535611797132738,
  -5.94894037775351e-06,-0.00107085162311127,0.229523091111101,-0.569748366384178,
  -6.15257963398896e-06,-0.00075835328533902,0.242178811113871,-0.603884935635618,
  -6.3562188901134e-06,-0.000445854947567215,0.25483453111664,-0.638021504887058,
  -6.55985814479454e-06,-0.000133356609793189,0.26749025111941,-0.672158074138498,
  -6.76349740114102e-06,0.000179141727978838,0.28014597112218,-0.706294643389937,
  -6.96713665748749e-06,0.000491640065749976,0.292801691124949,-0.740431212641378,
  -7.17077591305681e-06,0.000804138403522892,0.305457411127719,-0.774567781892817,
  -7.37441516918125e-06,0.00111663674129536,0.318113131130489,-0.808704351144257,
  -1.91880374737774e-06,-0.00637071049791407,0.0144542306593313,0.010596838608799,
  -2.04745307910009e-06,-0.00609010333634319,0.0268606205517252,-0.0236935576434862,
  -2.17610241076693e-06,-0.00580949617477219,0.039267010444119,-0.0579839538957713,
  -2.30475174253786e-06,-0.00552888901320142,0.0516734003365128,-0.0922743501480565,
  -2.43340107419776e-06,-0.00524828185163051,0.0640797902289066,-0.126564746400342,
  -2.56205040591317e-06,-0.00496767469005954,0.0764861801213005,-0.160855142652627,
  -2.69069973776737e-06,-0.00468706752848891,0.0888925700136942,-0.195145538904912,
  -2.81934906937176e-06,-0.00440646036691783,0.101298959906088,-0.229435935157197,
  -2.94799840105942e-06,-0.00412585320534686,0.113705349798482,-0.263726331409482,
  -3.07664773291361e-06,-0.00384524604377612,0.126111739690876,-0.298016727661768,
  -3.20529706449024e-06,-0.00356463888220526,0.138518129583269,-0.332307123914053,
  -3.33394639612239e-06,-0.00328403172063418,0.150924519475663,-0.366597520166338,
  -3.46259572781005e-06,-0.00300342455906311,0.163330909368057,-0.400887916418623,
  -3.59124505938668e-06,-0.00272281739749203,0.175737299260451,-0.435178312670908,
  -3.71989439118536e-06,-0.00244221023592117,0.188143689152845,-0.469468708923193,
  -3.84854372315058e-06,-0.00216160307435098,0.200550079045239,-0.503759105175478,
  -3.9771930546717e-06,-0.00188099591277968,0.212956468937633,-0.538049501427764,
  -4.10584238630385e-06,-0.0016003887512086,0.225362858830026,-0.572339897680049,
  -4.23449171838008e-06,-0.00131978158963819,0.23776924872242,-0.606630293932334,
  -4.36314105001223e-06,-0.00103917442806711,0.250175638614814,-0.640920690184619,
  -4.49179038197745e-06,-0.000758567266496257,0.262582028507208,-0.675211086436904,
  -4.62043971394266e-06,-0.000477960104926289,0.274988418399601,-0.70950148268919,
  -4.74908904568583e-06,-0.000197352943354989,0.287394808291995,-0.743791878941474,
  -4.8777383764298e-06,8.32542182171991e-05,0.29980119818439,-0.778082275193759,
  -5.00638770906114e-06,0.000363861379786723,0.312207588076783,-0.812372671446045,
  -1.45389860190144e-06,-0.00636052006542933,0.0145169897682612,0.0106156329919655,
  -1.5342204134558e-06,-0.00610602135183713,0.0267232423360384,-0.0237976431560157,
  -1.61454222499802e-06,-0.00585152263824487,0.0389294949038155,-0.0582109193039968,
  -1.69486403653329e-06,-0.00559702392465261,0.0511357474715926,-0.092624195451978,
  -1.77518584815184e-06,-0.00534252521106054,0.0633420000393697,-0.127037471599959,
  -1.85550765968712e-06,-0.0050880264974682,0.0755482526071469,-0.16145074774794,
  -1.93582947105586e-06,-0.00483352778387569,0.0877545051749241,-0.195864023895922,
  -2.01615128270216e-06,-0.00457902907028362,0.0999607577427012,-0.230277300043903,
  -2.09647309451499e-06,-0.00432453035669189,0.112167010310478,-0.264690576191884,
  -2.17679490566169e-06,-0.00407003164309883,0.124373262878256,-0.299103852339865,
  -2.25711671741902e-06,-0.00381553292950687,0.136579515446033,-0.333517128487846,
  -2.33743852889878e-06,-0.00356103421591469,0.14878576801381,-0.367930404635827,
  -2.41776034054508e-06,-0.00330653550232296,0.160992020581586,-0.402343680783809,
  -2.49808215185832e-06,-0.00305203678873034,0.173198273149364,-0.43675695693179,
  -2.57840396378217e-06,-0.00279753807513861,0.185404525717141,-0.471170233079771,
  -2.65872577520643e-06,-0.00254303936154598,0.197610778284918,-0.505583509227752,
  -2.73904758663068e-06,-0.00228854064795381,0.209817030852695,-0.539996785375733,
  -2.81936939827698e-06,-0.00203404193436163,0.222023283420472,-0.574410061523714,
  -2.89969120970124e-06,-0.00177954322076901,0.23422953598825,-0.608823337671696,
  -2.98001302112549e-06,-0.00152504450717683,0.246435788556027,-0.643236613819677,
  -3.06033483299384e-06,-0.00127054579358532,0.258642041123804,-0.677649889967658,
  -3.14065664452912e-06,-0.00101604707999314,0.27084829369158,-0.712063166115639,
  -3.22097845628644e-06,-0.000761548366400522,0.283054546259358,-0.74647644226362,
  -3.30130026793274e-06,-0.000507049652809233,0.295260798827135,-0.780889718411602,
  -3.38162207935699e-06,-0.000252550939216167,0.307467051394912,-0.815302994559583,
  -1.08578119911891e-06,-0.00635253118688859,0.0145658460555481,0.0106302367361743,
  -1.13584146603507e-06,-0.00611870810443864,0.0266159930967423,-0.0238785204153202,
  -1.18590173298072e-06,-0.00588488502198872,0.0386661401379365,-0.0583872775668148,
  -1.235961999968e-06,-0.00565106193953885,0.0507162871791307,-0.0928960347183094,
  -1.28602226689978e-06,-0.00541723885708889,0.0627664342203249,-0.127404791869804,
  -1.33608253385931e-06,-0.00518341577463888,0.0748165812615192,-0.161913549021298,
  -1.38614280068006e-06,-0.00494959269218886,0.0868667283027134,-0.196422306172793,
  -1.43620306752856e-06,-0.00471576960973885,0.0989168753439076,-0.230931063324288,
  -1.48626333462687e-06,-0.00448194652728928,0.110967022385102,-0.265439820475782,
  -1.53632360161415e-06,-0.00424812344483938,0.123017169426296,-0.299948577627277,
  -1.58638386832388e-06,-0.00401430036238914,0.13506731646749,-0.334457334778771,
  -1.63644413542219e-06,-0.00378047727993924,0.147117463508684,-0.368966091930266,
  -1.68650440246498e-06,-0.00354665419748956,0.159167610549878,-0.40347484908176,
  -1.73656466923022e-06,-0.00331283111503944,0.171217757591073,-0.437983606233255,
  -1.78662493610648e-06,-0.00307900803258931,0.183267904632267,-0.472492363384749,
  -1.83668520314928e-06,-0.00284518495013963,0.195318051673461,-0.507001120536244,
  -1.88674546974799e-06,-0.00261136186768929,0.207368198714655,-0.541509877687739,
  -1.93680573701283e-06,-0.00237753878523961,0.21941834575585,-0.576018634839233,
  -1.98686600383358e-06,-0.00214371570278971,0.231468492797044,-0.610527391990728,
  -2.03692627120944e-06,-0.00190989262034003,0.243518639838238,-0.645036149142222,
  -2.08698653780814e-06,-0.0016760695378899,0.255568786879432,-0.679544906293717,
  -2.13704680429583e-06,-0.00144224645543956,0.267618933920626,-0.714053663445211,
  -2.18710707189373e-06,-0.00120842337299054,0.27966908096182,-0.748562420596706,
  -2.23716733871449e-06,-0.000974600290540639,0.291719228003014,-0.783071177748201,
  -2.28722760542421e-06,-0.000740777208089849,0.303769375044209,-0.817579934899695,
  -8.01749084474931e-07,-0.00634641460551702,0.0146030522148104,0.0106413422327158,
  -8.33154617373155e-07,-0.0061285421207572,0.026534140588,-0.0239400239660976,
  -8.64560150290461e-07,-0.0059106696359974,0.0384652289611896,-0.058521390164911,
  -8.95965683117561e-07,-0.00569279715123744,0.0503963173343792,-0.0931027563637243,
  -9.27371216069561e-07,-0.00547492466647775,0.0623274057075687,-0.127684122562538,
  -9.58776749049317e-07,-0.00525705218171801,0.0742584940807582,-0.162265488761351,
  -9.90182281696006e-07,-0.00503917969695777,0.086189582453948,-0.196846854960164,
  -1.02158781478678e-06,-0.00482130721219831,0.0981206708271374,-0.231428221158978,
  -1.05299334757225e-06,-0.00460343472743818,0.110051759200327,-0.266009587357791,
  -1.08439888063527e-06,-0.00438556224267872,0.121982847573517,-0.300590953556605,
  -1.11580441347625e-06,-0.00416768975791881,0.133913935946706,-0.335172319755418,
  -1.14720994603967e-06,-0.00394981727315846,0.145845024319896,-0.369753685954231,
  -1.1786154791027e-06,-0.00373194478839878,0.157776112693085,-0.404335052153045,
  -1.21002101216572e-06,-0.00351407230363954,0.169707201066275,-0.438916418351858,
  -1.24142654478465e-06,-0.00329619981887919,0.181638289439465,-0.473497784550671,
  -1.2728320779587e-06,-0.00307832733411972,0.193569377812654,-0.508079150749485,
  -1.3042376109107e-06,-0.00286045484935982,0.205500466185844,-0.542660516948298,
  -1.33564314341861e-06,-0.00264258236459969,0.217431554559033,-0.577241883147111,
  -1.36704867637061e-06,-0.00242470987983978,0.229362642932223,-0.611823249345925,
  -1.39845420954465e-06,-0.00220683739508032,0.241293731305412,-0.646404615544738,
  -1.42985974205256e-06,-0.00198896491031997,0.253224819678602,-0.680985981743551,
  -1.46126527522661e-06,-0.00177109242556028,0.265155908051792,-0.715567347942365,
  -1.49267080773452e-06,-0.00155321994080015,0.277086996424981,-0.750148714141178,
  -1.52407634146368e-06,-0.00133534745604136,0.289018084798171,-0.784730080339991,
  -1.5554818745267e-06,-0.00111747497128167,0.30094917317136,-0.819311446538805,
  -5.86931568026181e-07,-0.00634181563994453,0.0146309146236483,0.0106496497979511,
  -6.06883570793137e-07,-0.00613600384126378,0.0264727438866888,-0.0239860322430245,
  -6.2683557355836e-07,-0.00593019204258308,0.0383145731497292,-0.0586217142840001,
  -6.46787576316643e-07,-0.00572438024390237,0.0501564024127696,-0.0932573963249758,
  -6.66739579130438e-07,-0.00551856844522158,0.0619982316758101,-0.127893078365951,
  -6.86691581791576e-07,-0.00531275664654074,0.0738400609388505,-0.162528760406927,
  -7.06643584563738e-07,-0.00510694484786001,0.085681890201891,-0.197164442447903,
  -7.26595587474677e-07,-0.00490113304917938,0.0975237194649314,-0.231800124488878,
  -7.46547590246838e-07,-0.00469532125049865,0.109365548727972,-0.266435806529854,
  -7.66499592796954e-07,-0.0044895094518177,0.121207377991012,-0.301071488570829,
  -7.86451595680138e-07,-0.00428369765313708,0.133049207254053,-0.335707170611805,
  -8.06403598618832e-07,-0.00407788585445656,0.144891036517093,-0.370342852652781,
  -8.26355601335482e-07,-0.00387207405577561,0.156732865780134,-0.404978534693756,
  -8.46307603830088e-07,-0.00366626225709465,0.168574695043174,-0.439614216734732,
  -8.66259606935316e-07,-0.00346045045841414,0.180416524306215,-0.474249898775708,
  -8.86211609540943e-07,-0.00325463865973341,0.192258353569255,-0.508885580816683,
  -9.06163611924526e-07,-0.00304882686105201,0.204100182832296,-0.543521262857659,
  -9.2611561530731e-07,-0.00284301506237239,0.215942012095335,-0.578156944898634,
  -9.46067617912938e-07,-0.00263720326369166,0.227783841358376,-0.61279262693961,
  -9.66019620407543e-07,-0.00243139146501004,0.239625670621417,-0.647428308980586,
  -9.85971624234416e-07,-0.00222557966633108,0.251467499884457,-0.682063991021561,
  -1.00592362628493e-06,-0.00201976786764924,0.263309329147497,-0.716699673062537,
  -1.02587562866852e-06,-0.00181395606896784,0.275151158410538,-0.751335355103513,
  -1.04582763171823e-06,-0.00160814427028777,0.286992987673578,-0.785971037144488,
  -1.06577963476795e-06,-0.00140233247160682,0.298834816936619,-0.820606719185464,
  -4.26900618001602e-07,-0.00633840459239337,0.0146515186331716,0.0106557882501934,
  -4.39781620190094e-07,-0.00614157522153411,0.0264272865338625,-0.0240200277161461,
  -4.52662622371647e-07,-0.00594474585067487,0.0382030544345534,-0.0586958436824856,
  -4.65543624594833e-07,-0.00574791647981565,0.0499788223352442,-0.093371659648825,
  -4.78424626804141e-07,-0.00555108710895635,0.0617545902359352,-0.128047475615164,
  -4.9130562901345e-07,-0.00535425773809706,0.0735303581366261,-0.162723291581504,
  -5.04186631056225e-07,-0.00515742836723765,0.085306126037317,-0.197399107547843,
  -5.17067633265533e-07,-0.00496059899637835,0.0970818939380079,-0.232074923514183,
  -5.29948635419331e-07,-0.00476376962551905,0.108857661838699,-0.266750739480522,
  -5.4282963768415e-07,-0.00456694025466009,0.12063342973939,-0.301426555446862,
  -5.55710639671414e-07,-0.00437011088380057,0.13240919764008,-0.336102371413201,
  -5.68591641880722e-07,-0.00417328151294116,0.144184965540771,-0.370778187379541,
  -5.81472643867986e-07,-0.00397645214208131,0.155960733441463,-0.40545400334588,
  -5.94353646410362e-07,-0.00377962277122301,0.167736501342153,-0.44012981931222,
  -6.07234648897226e-07,-0.00358279340036405,0.179512269242844,-0.474805635278559,
  -6.20115650717956e-07,-0.0033859640295042,0.191288037143535,-0.509481451244898,
  -6.32996653093798e-07,-0.00318913465864501,0.203063805044226,-0.544157267211238,
  -6.45877655136573e-07,-0.00299230528778582,0.214839572944917,-0.578833083177577,
  -6.58758658067526e-07,-0.0027954759169273,0.226615340845607,-0.613508899143917,
  -6.7163965955519e-07,-0.00259864654606745,0.238391108746298,-0.648184715110256,
  -6.84520662264099e-07,-0.00240181717520871,0.250166876646989,-0.682860531076596,
  -6.97401664084829e-07,-0.00220498780434886,0.26194264454768,-0.717536347042935,
  -7.10282666016582e-07,-0.00200815843348945,0.273718412448371,-0.752212163009275,
  -7.23163668614468e-07,-0.00181132906263048,0.285494180349062,-0.786887978975615,
  -7.36044670879288e-07,-0.00161449969177152,0.297269948249753,-0.821563794941954,
  -3.09019888160983e-07,-0.00633590010679615,0.0146666136241614,0.0106602827778752,
  -3.17480487545263e-07,-0.0061456857691984,0.0263939537572725,-0.0240449189409974,
  -3.25941086926074e-07,-0.00595547143160066,0.0381212938903837,-0.0587501206598701,
  -3.34401686341579e-07,-0.005765257094003,0.0498486340234948,-0.0934553223787428,
  -3.42862285673817e-07,-0.00557504275640514,0.061575974156606,-0.128160524097615,
  -3.51322885255856e-07,-0.00538482841880761,0.0733033142897171,-0.162865725816488,
  -3.59783484560339e-07,-0.0051946140812098,0.0850306544228283,-0.197570927535361,
  -3.68244083837066e-07,-0.00500439974361189,0.0967579945559395,-0.232276129254233,
  -3.76704683280327e-07,-0.00481418540601419,0.108485334689051,-0.266981330973106,
  -3.85165282723587e-07,-0.00462397106841672,0.120212674822162,-0.301686532691979,
  -3.93625882055826e-07,-0.00443375673081881,0.131940014955273,-0.336391734410851,
  -4.02086481221531e-07,-0.00424354239322056,0.143667355088384,-0.371096936129724,
  -4.10547080831325e-07,-0.00405332805562342,0.155394695221495,-0.405802137848597,
  -4.19007680385608e-07,-0.00386311371802539,0.167122035354607,-0.440507339567469,
  -4.27468279773358e-07,-0.00367289938042781,0.178849375487718,-0.475212541286342,
  -4.35928879327641e-07,-0.00348268504283045,0.190576715620828,-0.509917743005214,
  -4.44389478770901e-07,-0.00329247070523264,0.20230405575394,-0.544622944724087,
  -4.52850077770073e-07,-0.00310225636763461,0.214031395887051,-0.57932814644296,
  -4.613106775464e-07,-0.00291204203003748,0.225758736020162,-0.614033348161833,
  -4.69771276545572e-07,-0.00272182769243856,0.237486076153274,-0.648738549880705,
  -4.78231875988833e-07,-0.00253161335484098,0.249213416286385,-0.683443751599578,
  -4.86692475432093e-07,-0.00234139901724317,0.260940756419496,-0.718148953318451,
  -4.95153074764332e-07,-0.00215118467964581,0.272668096552607,-0.752854155037323,
  -5.03613673874526e-07,-0.00196097034204756,0.284395436685718,-0.787559356756195,
  -5.12074273428809e-07,-0.0017707560044502,0.296122776818829,-0.822264558475068,
  -1.41195823768342e-05,-0.0066893430151478,0.025440415439077,-0.00442004566760469,
  -1.7169243624951e-05,-0.00600675280697524,0.0414703510037193,-0.0354395098086673,
  -2.02189048730678e-05,-0.0053241625988027,0.0575002865683616,-0.0664589739497299,
  -2.32685661212539e-05,-0.00464157239063018,0.0735302221330039,-0.0974784380907926,
  -2.6318227369343e-05,-0.00395898218245755,0.0895601576976463,-0.128497902231855,
  -2.93678886174598e-05,-0.00327639197428509,0.105590093262288,-0.159517366372918,
  -3.24175498653823e-05,-0.00259380176611212,0.121620028826931,-0.19053683051398,
  -3.54672111138044e-05,-0.00191121155794005,0.137649964391573,-0.221556294655043,
  -3.85168723618934e-05,-0.00122862134976742,0.153679899956215,-0.252575758796106,
  -4.15665336098714e-05,-0.000546031141594794,0.169709835520858,-0.283595222937168,
  -4.46161948580714e-05,0.000136559066577835,0.1857397710855,-0.314614687078231,
  -4.7665856106105e-05,0.000819149274750464,0.201769706650142,-0.345634151219294,
  -5.07155173544716e-05,0.00150173948292287,0.217799642214785,-0.376653615360356,
  -5.37651786025606e-05,0.00218432969109505,0.233829577779427,-0.407673079501419,
  -5.68148398503165e-05,0.00286691989926813,0.249859513344069,-0.438692543642481,
  -5.98645010989607e-05,0.00354951010744053,0.265889448908712,-0.469712007783544,
  -6.29141623466056e-05,0.00423210031561339,0.281919384473354,-0.500731471924607,
  -6.59638235951387e-05,0.00491469052378535,0.297949320037996,-0.531750936065669,
  -6.90134848431168e-05,0.00559728073195842,0.313979255602639,-0.562770400206732,
  -7.20631460909837e-05,0.00627987094013061,0.33000919116728,-0.593789864347795,
  -7.51128073391838e-05,0.00696246114830368,0.346039126731923,-0.624809328488857,
  -7.81624685877169e-05,0.00764505135647564,0.362069062296565,-0.65582879262992,
  -8.12121298358059e-05,0.00832764156464849,0.378098997861208,-0.686848256770982,
  -8.42617910836729e-05,0.0090102317728209,0.39412893342585,-0.717867720912045,
  -8.7311452331762e-05,0.00969282198099375,0.410158868990493,-0.748887185053108,
  -1.40610073333589e-05,-0.00668638968518565,0.0254398211250674,-0.00442471458540301,
  -1.70844765248895e-05,-0.00600551598731253,0.0414476775710687,-0.035459099814681,
  -2.01079457164133e-05,-0.00532464228943946,0.05745553401707,-0.066493485043959,
  -2.31314149080064e-05,-0.00464376859156634,0.0734633904630713,-0.097527870273237,
  -2.61548840995163e-05,-0.00396289489369323,0.0894712469090727,-0.128562255502515,
  -2.91783532910816e-05,-0.00328202119582033,0.105479103355074,-0.159596640731793,
  -3.22018224826748e-05,-0.00260114749794726,0.121486959801075,-0.190631025961071,
  -3.52252916742124e-05,-0.00192027380007431,0.137494816247076,-0.221665411190349,
  -3.82487608656112e-05,-0.0012394001022008,0.153502672693078,-0.252699796419627,
  -4.12722300570656e-05,-0.00055852640432752,0.169510529139079,-0.283734181648905,
  -4.4295699248742e-05,0.000122347293545211,0.18551838558508,-0.314768566878183,
  -4.73191684401408e-05,0.000803220991418607,0.201526242031082,-0.345802952107461,
  -5.03426376317062e-05,0.00148409468929134,0.217534098477083,-0.376837337336739,
  -5.33661068234936e-05,0.00216496838716429,0.233541954923084,-0.407871722566017,
  -5.6389576014948e-05,0.00284584208503746,0.249549811369085,-0.438906107795295,
  -5.94130452066244e-05,0.00352671578291042,0.265557667815087,-0.469940493024573,
  -6.24365143978567e-05,0.00420758948078381,0.281565524261088,-0.500974878253851,
  -6.54599835895331e-05,0.00488846317865677,0.297573380707089,-0.532009263483129,
  -6.84834527810985e-05,0.00556933687653038,0.313581237153091,-0.563043648712407,
  -7.15069219722198e-05,0.00625021057440334,0.329589093599092,-0.594078033941685,
  -7.45303911640072e-05,0.00693108427227607,0.345596950045093,-0.625112419170963,
  -7.75538603551285e-05,0.00761195797014969,0.361604806491094,-0.656146804400241,
  -8.0577329547582e-05,0.00829283166802153,0.377612662937095,-0.687181189629519,
  -8.36007987393694e-05,0.0089737053658947,0.393620519383097,-0.718215574858797,
  -8.66242679299356e-05,0.00965457906376921,0.409628375829099,-0.749249960088075,
  -1.39798650033995e-05,-0.00668230991677934,0.0254389927688464,-0.00443116968810527,
  -1.69672664514647e-05,-0.00600382301715574,0.0414163019668647,-0.0354861843567995,
  -1.99546678995577e-05,-0.00532533611753216,0.0573936111648831,-0.0665411990254936,
  -2.29420693475813e-05,-0.00464684921790859,0.0733709203629014,-0.0975962136941878,
  -2.5929470795466e-05,-0.00396836231828462,0.08934822956092,-0.128651228362882,
  -2.89168722435451e-05,-0.0032898754186611,0.105325538758938,-0.159706243031576,
  -3.19042736915964e-05,-0.00261138851903753,0.121302847956957,-0.19076125770027,
  -3.48916751397033e-05,-0.00193290161941406,0.137280157154975,-0.221816272368965,
  -3.7879076587588e-05,-0.00125441471979015,0.153257466352994,-0.252871287037659,
  -4.08664780357504e-05,-0.000575927820166688,0.169234775551012,-0.283926301706353,
  -4.38538794837462e-05,0.000102559079456999,0.18521208474903,-0.314981316375047,
  -4.68412809319085e-05,0.000781045979080464,0.201189393947049,-0.346036331043741,
  -4.98286823799043e-05,0.00145953287870415,0.217166703145067,-0.377091345712435,
  -5.28160838279002e-05,0.00213801977832784,0.233144012343085,-0.40814636038113,
  -5.58034852756739e-05,0.00281650667795197,0.249121321541104,-0.439201375049824,
  -5.87908867240028e-05,0.00349499357757521,0.265098630739122,-0.470256389718518,
  -6.17782881719986e-05,0.00417348047719868,0.281075939937141,-0.501311404387212,
  -6.47656896201054e-05,0.00485196737682236,0.297053249135159,-0.532366419055906,
  -6.77530910681012e-05,0.00553045427644605,0.313030558333177,-0.563421433724601,
  -7.07404925162081e-05,0.00620894117606952,0.329007867531196,-0.594476448393295,
  -7.37278939644259e-05,0.00688742807569298,0.344985176729214,-0.625531463061989,
  -7.67152954114225e-05,0.00756591497531778,0.360962485927233,-0.656586477730683,
  -7.97026968605286e-05,0.00824440187494035,0.376939795125251,-0.687641492399377,
  -8.26900983079693e-05,0.00892288877456471,0.39291710432327,-0.718696507068071,
  -8.56774997564091e-05,0.00960137567418817,0.408894413521288,-0.749751521736766,
  -1.38678946849796e-05,-0.00667670177047548,0.0254378401061605,-0.00444005328214347,
  -1.68059349148764e-05,-0.00600152543255097,0.0413730693088682,-0.0355234584464598,
  -1.9743975144787e-05,-0.00532634909462648,0.057308298511576,-0.0666068636107761,
  -2.26820153746976e-05,-0.00465117275670196,0.0732435277142837,-0.0976902687750925,
  -2.56200556044694e-05,-0.00397599641877727,0.0891787569169916,-0.128773673939409,
  -2.85580958342968e-05,-0.00330082008085264,0.105113986119699,-0.159857079103725,
  -3.1496136064374e-05,-0.00262564374292829,0.121049215322407,-0.190940484268042,
  -3.44341762942291e-05,-0.00195046740500393,0.136984444525115,-0.222023889432358,
  -3.73722165241119e-05,-0.00127529106707902,0.152919673727823,-0.253107294596674,
  -4.03102567537728e-05,-0.000600114729154333,0.168854902930531,-0.284190699760991,
  -4.32482969839887e-05,7.50616087696887e-05,0.184790132133238,-0.315274104925307,
  -4.6186337213816e-05,0.000750237946694376,0.200725361335946,-0.346357510089623,
  -4.91243774436434e-05,0.00142541428461884,0.216660590538653,-0.37744091525394,
  -5.20624176734152e-05,0.00210059062254353,0.232595819741361,-0.408524320418256,
  -5.50004579031871e-05,0.00277576696046822,0.248531048944069,-0.439607725582572,
  -5.79384981336251e-05,0.00345094329839224,0.264466278146777,-0.470691130746889,
  -6.08765383636189e-05,0.00412611963631648,0.280401507349484,-0.501774535911205,
  -6.38145785933908e-05,0.00480129597424139,0.296336736552192,-0.532857941075521,
  -6.67526188231626e-05,0.00547647231216586,0.3122719657549,-0.563941346239838,
  -6.96906590524904e-05,0.00615164865009121,0.328207194957608,-0.595024751404154,
  -7.26286992830394e-05,0.00682682498801501,0.344142424160316,-0.62610815656847,
  -7.55667395130333e-05,0.00750200132593903,0.360077653363023,-0.657191561732787,
  -7.85047797425831e-05,0.00817717766386439,0.376012882565731,-0.688274966897103,
  -8.14428199723549e-05,0.00885235400178885,0.391948111768439,-0.719358372061419,
  -8.43808602027929e-05,0.00952753033971243,0.407883340971146,-0.750441777225736,
  -1.37142059711895e-05,-0.00666904468042966,0.0254362400625622,-0.00445220177231932,
  -1.65852639968794e-05,-0.00599844402853861,0.0413138481253304,-0.0355744314997202,
  -1.94563220225624e-05,-0.00532784337664755,0.0571914561880986,-0.066696661227121,
  -2.23273800482593e-05,-0.00465724272475654,0.0730690642508667,-0.0978188909545219,
  -2.51984380738868e-05,-0.00398664207286542,0.088946672313635,-0.128941120681923,
  -2.80694960997918e-05,-0.00331604142097464,0.104824280376403,-0.160063350409323,
  -3.09405541254748e-05,-0.00264544076908357,0.120701888439171,-0.191185580136724,
  -3.38116121509913e-05,-0.00197484011719229,0.136579496501939,-0.222307809864125,
  -3.66826701768685e-05,-0.00130423946530156,0.152457104564708,-0.253430039591526,
  -3.95537282024128e-05,-0.000633638813410164,0.168334712627476,-0.284552269318927,
  -4.24247862281235e-05,3.69618384810089e-05,0.184212320690244,-0.315674499046328,
  -4.52958442538898e-05,0.000707562490371627,0.200089928753012,-0.346796728773729,
  -4.81669022798226e-05,0.00137816314226247,0.21596753681578,-0.377918958501129,
  -5.10379603049227e-05,0.0020487637941542,0.231845144878549,-0.40904118822853,
  -5.39090183308e-05,0.00271936444604526,0.247722752941317,-0.440163417955931,
  -5.67800763565662e-05,0.0033899650979361,0.263600361004085,-0.471285647683332,
  -5.96511343823325e-05,0.00406056574982716,0.279477969066853,-0.502407877410733,
  -6.25221924084318e-05,0.00473116640171733,0.295355577129621,-0.533530107138134,
  -6.53932504333099e-05,0.00540176705360973,0.31123318519239,-0.564652336865534,
  -6.82643084587431e-05,0.00607236770550101,0.327110793255158,-0.595774566592935,
  -7.11353664847314e-05,0.00674296835739163,0.342988401317926,-0.626896796320336,
  -7.40064245108307e-05,0.00741356900928247,0.358866009380694,-0.658019026047737,
  -7.68774825360419e-05,0.00808416966117376,0.374743617443462,-0.689141255775138,
  -7.97485405619192e-05,0.00875477031306504,0.390621225506231,-0.720263485502539,
  -8.26195985879075e-05,0.00942537096495499,0.406498833568998,-0.75138571522994,
  -1.35047929589946e-05,-0.00665868614607887,0.0254340270066494,-0.00446867189890189,
  -1.628600905626e-05,-0.00599437827861751,0.0412333760583813,-0.0356435374237771,
  -1.90672251536017e-05,-0.0053300704111563,0.0570327251101131,-0.0668184029486523,
  -2.18484412508324e-05,-0.00466576254369488,0.072832074161845,-0.0979932684735275,
  -2.46296573481464e-05,-0.00400145467623347,0.088631423213577,-0.129168133998403,
  -2.74108734453771e-05,-0.00333714680877217,0.104430772265309,-0.160342999523278,
  -3.01920895427188e-05,-0.00267283894131087,0.120230121317041,-0.191517865048153,
  -3.29733056401715e-05,-0.00200853107384968,0.136029470368773,-0.222692730573028,
  -3.57545217374855e-05,-0.00134422320638861,0.151828819420504,-0.253867596097903,
  -3.85357378346329e-05,-0.000679915338926751,0.167628168472236,-0.285042461622779,
  -4.13169539318359e-05,-1.56074714656729e-05,0.183427517523968,-0.316217327147654,
  -4.40981700290943e-05,0.000648700395995849,0.1992268665757,-0.347392192672529,
  -4.68793861265193e-05,0.00131300826345693,0.215026215627432,-0.378567058197404,
  -4.96606022235557e-05,0.00197731613091889,0.230825564679164,-0.409741923722279,
  -5.24418183209807e-05,0.00264162399837975,0.246624913730896,-0.440916789247155,
  -5.52230344184057e-05,0.00330593186584105,0.262424262782628,-0.47209165477203,
  -5.80042505153866e-05,0.00397023973330324,0.27822361183436,-0.503266520296905,
  -6.07854666132557e-05,0.00463454760076343,0.294022960886091,-0.53444138582178,
  -6.35666827105696e-05,0.00529885546822473,0.309822309937823,-0.565616251346655,
  -6.63478988076616e-05,0.00596316333568603,0.325621658989555,-0.596791116871531,
  -6.91291149048645e-05,0.00662747120314799,0.341421008041287,-0.627965982396406,
  -7.19103310020675e-05,0.00729177907060885,0.357220357093019,-0.659140847921281,
  -7.46915470986043e-05,0.00795608693807148,0.373019706144751,-0.690315713446156,
  -7.74727631960292e-05,0.00862039480553278,0.388819055196483,-0.721490578971031,
  -8.02539792941204e-05,0.00928470267299319,0.404618404248215,-0.752665444495907,
  -1.32222791387193e-05,-0.00664484683601915,0.0254309825651138,-0.00449074092689025,
  -1.58848799419603e-05,-0.00598913227789127,0.0411252163116373,-0.0357361354110802,
  -1.85474807451458e-05,-0.00533341771976331,0.0568194500581608,-0.0669815298952701,
  -2.12100815484562e-05,-0.00467770316163546,0.0725136838046843,-0.09822692437946,
  -2.38726823516833e-05,-0.00402198860350761,0.0882079175512078,-0.12947231886365,
  -2.65352831548549e-05,-0.0033662740453797,0.103902151297731,-0.16071771334784,
  -2.91978839583318e-05,-0.00271055948725207,0.119596385044255,-0.19196310783203,
  -3.18604847614479e-05,-0.002054844929124,0.135290618790778,-0.22320850231622,
  -3.45230855645084e-05,-0.00139913037099604,0.150984852537302,-0.25445389680041,
  -3.71856863680686e-05,-0.000743415812868298,0.166679086283825,-0.2856992912846,
  -3.98482871712402e-05,-8.77012547404465e-05,0.182373320030349,-0.316944685768789,
  -4.25108879745228e-05,0.000568013303387405,0.198067553776872,-0.348190080252979,
  -4.51734887774724e-05,0.0012237278615157,0.213761787523396,-0.379435474737169,
  -4.78360895808105e-05,0.00187944241964377,0.229456021269919,-0.410680869221359,
  -5.04986903840932e-05,0.00253515697777118,0.245150255016443,-0.441926263705549,
  -5.31612911873758e-05,0.00319087153589903,0.260844488762966,-0.473171658189739,
  -5.58238919908804e-05,0.00384658609402688,0.27653872250949,-0.504417052673929,
  -5.848649279383e-05,0.00450230065215518,0.292232956256013,-0.535662447158119,
  -6.11490935971126e-05,0.00515801521028281,0.307927190002537,-0.566907841642309,
  -6.38116944001732e-05,0.00581372976841088,0.32362142374906,-0.598153236126499,
  -6.64742952038999e-05,0.00646944432653784,0.339315657495583,-0.629398630610689,
  -6.91368960070715e-05,0.00712515888466614,0.355009891242107,-0.660644025094879,
  -7.179949680991e-05,0.00778087344279488,0.370704124988631,-0.691889419579068,
  -7.44620976130816e-05,0.00843658800092273,0.386398358735154,-0.723134814063259,
  -7.71246984168084e-05,0.00909230255904969,0.402092592481677,-0.754380208547449,
  -1.28462280215083e-05,-0.00662666231581905,0.0254268280857261,-0.00451985244472586,
  -1.53555079866613e-05,-0.00598256610710396,0.040981960292534,-0.035858282519704,
  -1.78647879517796e-05,-0.00533846989838876,0.056537092499342,-0.0671967125946821,
  -2.03740679169673e-05,-0.00469437368967363,0.07209222470615,-0.0985351426696602,
  -2.28833478820578e-05,-0.00405027748095849,0.0876473569129579,-0.129873572744638,
  -2.53926278471761e-05,-0.00340618127224324,0.103202489119766,-0.161212002819616,
  -2.79019078123222e-05,-0.00276208506352815,0.118757621326574,-0.192550432894595,
  -3.04111877774682e-05,-0.00211798885481307,0.134312753533382,-0.223888862969573,
  -3.29204677426698e-05,-0.0014738926460981,0.14986788574019,-0.255227293044551,
  -3.54297477078158e-05,-0.00082979643738279,0.165423017946998,-0.286565723119529,
  -3.79390276729064e-05,-0.000185700228667818,0.180978150153805,-0.317904153194507,
  -4.04483076382189e-05,0.000458395980047488,0.196533282360614,-0.349242583269485,
  -4.29575876030874e-05,0.00110249218876279,0.212088414567422,-0.380581013344463,
  -4.54668675681225e-05,0.00174658839747832,0.22764354677423,-0.411919443419441,
  -4.79761475332685e-05,0.00239068460619341,0.243198678981038,-0.443257873494419,
  -5.04854274983035e-05,0.00303478081490871,0.258753811187846,-0.474596303569398,
  -5.29947074638937e-05,0.00367887702362291,0.274308943394653,-0.505934733644376,
  -5.55039874291507e-05,0.00432297323233799,0.289864075601461,-0.537273163719354,
  -5.80132673939637e-05,0.00496706944105396,0.30541920780827,-0.568611593794332,
  -6.05225473595539e-05,0.00561116564976794,0.320974340015077,-0.59995002386931,
  -6.30318273241448e-05,0.00625526185848413,0.336529472221885,-0.631288453944288,
  -6.55411072892909e-05,0.00689935806719921,0.352084604428693,-0.662626884019266,
  -6.805038725477e-05,0.00754345427591385,0.367639736635501,-0.693965314094244,
  -7.05596672194719e-05,0.00818755048462938,0.383194868842309,-0.725303744169222,
  -7.30689471843959e-05,0.00883164669334491,0.398750001049117,-0.756642174244201,
  -1.23545201799261e-05,-0.00660328428945223,0.0254212263169582,-0.00455747018312831,
  -1.46710909880721e-05,-0.00597467811814334,0.0407958664774927,-0.0360161203213869,
  -1.69876617961834e-05,-0.00534607194683445,0.0561705066380271,-0.0674747704596454,
  -1.9304232604378e-05,-0.00471746577552562,0.0715451467985616,-0.0989334205979039,
  -2.16208034123921e-05,-0.00408885960421657,0.0869197869590962,-0.130392070736163,
  -2.39373742207949e-05,-0.00346025343290801,0.10229442711963,-0.161850720874421,
  -2.62539450287536e-05,-0.00283164726159879,0.117669067280165,-0.19330937101268,
  -2.85705158369343e-05,-0.0022030410902899,0.1330437074407,-0.224768021150938,
  -3.0887086645115e-05,-0.00157443491898113,0.148418347601234,-0.256226671289197,
  -3.32036574531291e-05,-0.000945828747672128,0.163792987761769,-0.287685321427455,
  -3.55202282615874e-05,-0.000317222576363463,0.179167627922303,-0.319143971565714,
  -3.78367990695461e-05,0.000311383594945314,0.194542268082837,-0.350602621703972,
  -4.01533698776158e-05,0.000939989766254312,0.209916908243372,-0.382061271842231,
  -4.24699406857409e-05,0.00156859593756331,0.225291548403906,-0.413519921980489,
  -4.47865114940882e-05,0.00219720210887209,0.240666188564441,-0.444978572118748,
  -4.71030823021579e-05,0.00282580828018109,0.256040828724975,-0.476437222257007,
  -4.94196531105606e-05,0.0034544144514892,0.271415468885509,-0.507895872395265,
  -5.17362239182972e-05,0.00408302062279886,0.286790109046044,-0.539354522533524,
  -5.40527947264779e-05,0.00471162679410742,0.302164749206578,-0.570813172671782,
  -5.63693655348807e-05,0.00534023296541619,0.317539389367113,-0.602271822810041,
  -5.86859363428394e-05,0.00596883913672563,0.332914029527648,-0.633730472948299,
  -6.10025071510201e-05,0.00659744530803419,0.348288669688182,-0.665189123086558,
  -6.33190779590898e-05,0.00722605147934319,0.363663309848717,-0.696647773224816,
  -6.56356487673815e-05,0.0078546576506513,0.37903795000925,-0.728106423363075,
  -6.79522195753401e-05,0.00848326382196074,0.394412590169785,-0.759565073501333,
  -1.17263788682875e-05,-0.0065740595809894,0.0254138036221959,-0.00460480546026015,
  -1.38093612328249e-05,-0.00596570964058377,0.0405601316434969,-0.0362147313065718,
  -1.58923435974595e-05,-0.00535735970017825,0.0557064596647978,-0.0678246571528835,
  -1.79753259620108e-05,-0.0047490097597726,0.0708527876860989,-0.0994345829991951,
  -2.00583083265204e-05,-0.00414065981936701,0.0859991157073998,-0.131044508845507,
  -2.21412906912244e-05,-0.00353230987896158,0.101145443728701,-0.162654434691818,
  -2.4224273055623e-05,-0.00292395993855565,0.116291771750002,-0.19426436053813,
  -2.63072554202992e-05,-0.00231560999815028,0.131438099771303,-0.225874286384442,
  -2.83902377847811e-05,-0.00170726005774446,0.146584427792604,-0.257484212230754,
  -3.04732201495406e-05,-0.00109891011733931,0.161730755813905,-0.289094138077065,
  -3.25562025137449e-05,-0.000490560176933164,0.176877083835206,-0.320704063923377,
  -3.46391848783933e-05,0.000117789763472542,0.192023411856507,-0.352313989769688,
  -3.67221672432083e-05,0.000726139703877804,0.207169739877808,-0.383923915616,
  -3.88051496077457e-05,0.00133448964428373,0.222316067899109,-0.415533841462312,
  -4.08881319722276e-05,0.00194283958468899,0.23746239592041,-0.447143767308623,
  -4.29711143367095e-05,0.00255118952509426,0.252608723941711,-0.478753693154935,
  -4.50540967011914e-05,0.00315953946550018,0.267755051963012,-0.510363619001247,
  -4.71370790660064e-05,0.00376788940590567,0.282901379984313,-0.541973544847558,
  -4.92200614303773e-05,0.00437623934631159,0.298047708005614,-0.57358347069387,
  -5.13030437946371e-05,0.00498458928671774,0.313194036026915,-0.605193396540182,
  -5.33860261595631e-05,0.00559293922712278,0.328340364048216,-0.636803322386493,
  -5.54690085237119e-05,0.00620128916752893,0.343486692069517,-0.668413248232805,
  -5.755199088886e-05,0.00680963910793331,0.358633020090817,-0.700023174079117,
  -5.96349732528978e-05,0.0074179890483399,0.373779348112119,-0.731633099925428,
  -6.17179556178238e-05,0.00802633898874472,0.388925676133419,-0.76324302577174,
  -1.09474054983544e-05,-0.00653878010131805,0.0254042073544089,-0.00466241717516525,
  -1.27599238548132e-05,-0.00595623538196288,0.0402708604933348,-0.0364564605231058,
  -1.45724422112303e-05,-0.00537369066260773,0.0551375136322606,-0.0682505038710463,
  -1.63849605677169e-05,-0.00479114594325258,0.0700041667711865,-0.100044547218987,
  -1.81974789241202e-05,-0.00420860122389743,0.0848708199101124,-0.131838590566927,
  -2.00099972804679e-05,-0.00362605650454217,0.0997374730490382,-0.163632633914868,
  -2.18225156371488e-05,-0.00304351178518736,0.114604126187964,-0.195426677262808,
  -2.36350339934965e-05,-0.00246096706583199,0.12947077932689,-0.227220720610749,
  -2.54475523502884e-05,-0.00187842234647728,0.144337432465816,-0.259014763958689,
  -2.72600707062476e-05,-0.00129587762712147,0.159204085604742,-0.29080880730663,
  -2.90725890629839e-05,-0.000713332907766873,0.174070738743667,-0.32260285065457,
  -3.08851074194982e-05,-0.000130788188411612,0.188937391882594,-0.354396894002511,
  -3.2697625775735e-05,0.000451756530943648,0.203804045021519,-0.386190937350451,
  -3.45101441320828e-05,0.00103430125029913,0.218670698160445,-0.417984980698392,
  -3.63226624888746e-05,0.0016168459696535,0.233537351299371,-0.449779024046332,
  -3.81351808449448e-05,0.00219939068900921,0.248404004438297,-0.481573067394273,
  -3.99476992012371e-05,0.00278193540836491,0.263270657577223,-0.513367110742213,
  -4.17602175583065e-05,0.00336448012771906,0.278137310716149,-0.545161154090154,
  -4.35727359147098e-05,0.00394702484707432,0.293003963855075,-0.576955197438094,
  -4.5385254270891e-05,0.00452956956643025,0.307870616994001,-0.608749240786035,
  -4.71977726274053e-05,0.00511211428578484,0.322737270132926,-0.640543284133975,
  -4.90102909841417e-05,0.00569465900513944,0.337603923271852,-0.672337327481916,
  -5.08228093404339e-05,0.00627720372449492,0.352470576410778,-0.704131370829856,
  -5.26353276962821e-05,0.00685974844385084,0.367337229549704,-0.735925414177797,
  -5.44478460527964e-05,0.00744229316320588,0.38220388268863,-0.767719457525737,
  -1.00161865496037e-05,-0.00649794593372762,0.0253922078414258,-0.00472976015830734,
  -1.15326006883271e-05,-0.00594717025762809,0.0399294456681986,-0.0367390205298823,
  -1.30490148270573e-05,-0.00539639458152857,0.0544666834949714,-0.0687482809014573,
  -1.4565428965746e-05,-0.00484561890542889,0.0690039213217444,-0.100757541273032,
  -1.60818431044207e-05,-0.00429484322932938,0.0835411591485172,-0.132766801644607,
  -1.7598257243151e-05,-0.00374406755322987,0.09807839697529,-0.164776062016182,
  -1.9114671381798e-05,-0.00319329187713024,0.112615634802063,-0.196785322387757,
  -2.06310855205283e-05,-0.00264251620103073,0.127152872628836,-0.228794582759332,
  -2.21474996593418e-05,-0.00209174052493133,0.141690110455608,-0.260803843130907,
  -2.36639137978778e-05,-0.00154096484883137,0.156227348282381,-0.292813103502482,
  -2.51803279370244e-05,-0.000990189172732636,0.170764586109154,-0.324822363874057,
  -2.66967420757824e-05,-0.00043941349663279,0.185301823935927,-0.356831624245632,
  -2.82131562143184e-05,0.000111362179466834,0.1998390617627,-0.388840884617207,
  -2.97295703528544e-05,0.000662137855566236,0.214376299589472,-0.420850144988782,
  -3.12459844914459e-05,0.0012129135316663,0.228913537416246,-0.452859405360357,
  -3.27623986304815e-05,0.00176368920776548,0.243450775243018,-0.484868665731932,
  -3.4278812769184e-05,0.00231446488386511,0.257988013069791,-0.516877926103507,
  -3.57952269074424e-05,0.00286524055996518,0.272525250896564,-0.548887186475082,
  -3.7311641046589e-05,0.00341601623606391,0.287062488723337,-0.580896446846657,
  -3.88280551850695e-05,0.00396679191216376,0.30159972655011,-0.612905707218232,
  -4.0344469323772e-05,0.00451756758826338,0.316136964376883,-0.644914967589807,
  -4.18608834625855e-05,0.00506834326436278,0.330674202203655,-0.676924227961382,
  -4.33772976018432e-05,0.00561911894046174,0.345211440030428,-0.708933488332957,
  -4.48937117402126e-05,0.00616989461656203,0.359748677857201,-0.740942748704532,
  -4.641012587836e-05,0.00672067029266188,0.374285915683974,-0.772952009076107,
  -8.95061131261227e-06,-0.00645292424524583,0.0253778317728423,-0.00480485928043545,
  -1.01635120729332e-05,-0.00593962074851551,0.0395445359692769,-0.0370541240116016,
  -1.1376412833275e-05,-0.00542631725178516,0.0537112401657115,-0.0693033887427677,
  -1.25893135936028e-05,-0.00491301375505498,0.0678779443621459,-0.101552653473934,
  -1.38022143539307e-05,-0.00439971025832459,0.0820446485585806,-0.1338019182051,
  -1.50151151142308e-05,-0.00388640676159435,0.0962113527550151,-0.166051182936266,
  -1.62280158744754e-05,-0.00337310326486384,0.11037805695145,-0.198300447667432,
  -1.74409166347478e-05,-0.00285979976813344,0.124544761147884,-0.230549712398598,
  -1.86538173950757e-05,-0.00234649627140304,0.138711465344319,-0.262798977129764,
  -1.98667181555701e-05,-0.00183319277467298,0.152878169540754,-0.295048241860931,
  -2.10796189158424e-05,-0.00131988927794269,0.167044873737188,-0.327297506592097,
  -2.22925196765034e-05,-0.000806585781212732,0.181211577933623,-0.359546771323263,
  -2.35054204364982e-05,-0.000293282284481888,0.195378282130057,-0.391796036054429,
  -2.47183211967705e-05,0.000220021212248733,0.209544986326492,-0.424045300785595,
  -2.59312219570429e-05,0.000733324708978689,0.223711690522926,-0.456294565516761,
  -2.71441227174263e-05,0.00124662820570909,0.237878394719361,-0.488543830247927,
  -2.83570234775876e-05,0.00175993170243949,0.252045098915796,-0.520793094979093,
  -2.95699242383041e-05,0.00227323519916922,0.26621180311223,-0.55304235971026,
  -3.07828249982434e-05,0.00278653869590006,0.280378507308665,-0.585291624441425,
  -3.19957257587378e-05,0.00329984219263024,0.294545211505099,-0.617540889172592,
  -3.3208626518455e-05,0.00381314568936153,0.308711915701534,-0.649790153903758,
  -3.44215272796156e-05,0.00432644918609038,0.322878619897968,-0.682039418634924,
  -3.5634428040221e-05,0.004839752682821,0.337045324094403,-0.71428868336609,
  -3.68473288002713e-05,0.00535305617955117,0.351212028290838,-0.746537948097256,
  -3.80602295600996e-05,0.00586635967628224,0.365378732487272,-0.778787212828422,
  -7.79067106557868e-06,-0.0064058714063689,0.025361475361132,-0.00488433690778027,
  -8.71464295375268e-06,-0.00593457731235156,0.0391323924974063,-0.0373875989762279,
  -9.63861484193362e-06,-0.00546328321833428,0.0529033096336805,-0.0698908610446755,
  -1.05625867301007e-05,-0.00499198912431692,0.0666742267699548,-0.102394123113123,
  -1.14865586183788e-05,-0.00452069503029973,0.080445143906229,-0.134897385181571,
  -1.24105305066013e-05,-0.00404940093628248,0.0942160610425033,-0.167400647250018,
  -1.33345023948239e-05,-0.00357810684226534,0.107986978178777,-0.199903909318466,
  -1.425847428288e-05,-0.00310681274824776,0.121757895315052,-0.232407171386914,
  -1.5182446171158e-05,-0.00263551865423051,0.135528812451326,-0.264910433455361,
  -1.61064180592141e-05,-0.00216422456021326,0.1492997295876,-0.297413695523809,
  -1.70303899476587e-05,-0.00169293046619612,0.163070646723875,-0.329916957592256,
  -1.79543618354927e-05,-0.00122163637217843,0.176841563860149,-0.362420219660704,
  -1.88783337238818e-05,-0.000750342278161398,0.190612480996423,-0.394923481729152,
  -1.98023056120489e-05,-0.000279048184144148,0.204383398132697,-0.427426743797599,
  -2.07262775000494e-05,0.000192245909873323,0.218154315268972,-0.459930005866047,
  -2.1650249388494e-05,0.000663540003890573,0.231925232405246,-0.492433267934494,
  -2.25742212766056e-05,0.00113483409790782,0.24569614954152,-0.524936530002942,
  -2.34981931649392e-05,0.00160612819192507,0.259467066677795,-0.55743979207139,
  -2.44221650530507e-05,0.00207742228594276,0.273237983814069,-0.589943054139837,
  -2.53461369410513e-05,0.00254871637996024,0.287008900950343,-0.622446316208285,
  -2.62701088294959e-05,0.00302001047397704,0.300779818086617,-0.654949578276732,
  -2.71940807173854e-05,0.00349130456799474,0.314550735222892,-0.68745284034518,
  -2.8118052605941e-05,0.0039625986620111,0.328321652359165,-0.719956102413627,
  -2.90420244946077e-05,0.0044338927560279,0.34209256949544,-0.752459364482075,
  -2.9965996381498e-05,0.00490518685004737,0.355863486631715,-0.784962626550523,
  -6.5946658991331e-06,-0.00635936840938081,0.0253439198651874,-0.0049639222493114,
  -7.26444071441623e-06,-0.00593256992546679,0.0387147523091504,-0.0377215258917449,
  -7.93421552977569e-06,-0.00550577144155279,0.0520855847531134,-0.0704791295341784,
  -8.60399034513515e-06,-0.00507897295763887,0.0654564171970763,-0.103236733176612,
  -9.27376516038358e-06,-0.00465217447372474,0.0788272496410394,-0.135994336819045,
  -9.94353997574304e-06,-0.00422537598981076,0.0921980820850024,-0.168751940461479,
  -1.06133147909082e-05,-0.00379857750589652,0.105568914528965,-0.201509544103912,
  -1.12830896062954e-05,-0.00337177902198249,0.118939746972929,-0.234267147746346,
  -1.19528644214606e-05,-0.00294498053806846,0.132310579416891,-0.267024751388779,
  -1.26226392370699e-05,-0.00251818205415477,0.145681411860854,-0.299782355031213,
  -1.32924140519575e-05,-0.00209138357024008,0.159052244304818,-0.332539958673646,
  -1.39621888672892e-05,-0.00166458508632639,0.17242307674878,-0.36529756231608,
  -1.46319636827874e-05,-0.00123778660241269,0.185793909192743,-0.398055165958513,
  -1.53017384983412e-05,-0.000810988118499001,0.199164741636706,-0.430812769600947,
  -1.59715133133398e-05,-0.000384189634584198,0.21253557408067,-0.46357037324338,
  -1.6641288128505e-05,4.26088493301613e-05,0.225906406524633,-0.496327976885814,
  -1.73110629441142e-05,0.000469407333243632,0.239277238968595,-0.529085580528247,
  -1.79808377592794e-05,0.000896205817158213,0.252648071412559,-0.561843184170681,
  -1.86506125744446e-05,0.00132300430107213,0.266018903856521,-0.594600787813114,
  -1.93203873900538e-05,0.0017498027849856,0.279389736300484,-0.627358391455548,
  -1.9990162205108e-05,0.00217660126889951,0.292760568744447,-0.660115995097981,
  -2.06599370204952e-05,0.00260339975281365,0.30613140118841,-0.692873598740415,
  -2.13297118358824e-05,0.00303019823672823,0.319502233632374,-0.725631202382848,
  -2.19994866508255e-05,0.00345699672064237,0.332873066076336,-0.758388806025282,
  -2.26692614664348e-05,0.00388379520455562,0.346243898520299,-0.791146409667715,
  -5.42848221371517e-06,-0.00631587937051781,0.0253262013124811,-0.00503932162701836,
  -5.89167125854273e-06,-0.00593348347584252,0.0383145203489413,-0.0380378891961575,
  -6.35486030345356e-06,-0.00555108758116729,0.0513028393854015,-0.0710364567652966,
  -6.81804934832275e-06,-0.00516869168649192,0.0642911584218618,-0.104035024334436,
  -7.28123839308092e-06,-0.0047862957918165,0.077279477458322,-0.137033591903575,
  -7.74442743795012e-06,-0.00440389989714118,0.0902677964947822,-0.170032159472714,
  -8.20761648270829e-06,-0.00402150400246581,0.103256115531242,-0.203030727041853,
  -8.67080552768851e-06,-0.00363910810779067,0.116244434567703,-0.236029294610992,
  -9.13399457264097e-06,-0.00325671221311541,0.129232753604163,-0.269027862180131,
  -9.59718361726036e-06,-0.00287431631844004,0.142221072640623,-0.30202642974927,
  -1.00603726622683e-05,-0.00249192042376456,0.155209391677083,-0.335024997318409,
  -1.05235617069432e-05,-0.00210952452908897,0.168197710713544,-0.368023564887548,
  -1.09867507520067e-05,-0.00172712863441449,0.181186029750003,-0.401022132456688,
  -1.14499397967927e-05,-0.0013447327397389,0.194174348786464,-0.434020700025827,
  -1.19131288415231e-05,-0.000962336845063305,0.207162667822924,-0.467019267594965,
  -1.23763178869751e-05,-0.000579940950389046,0.220150986859384,-0.500017835164105,
  -1.28395069310949e-05,-0.000197545055712345,0.233139305895845,-0.533016402733244,
  -1.3302695976547e-05,0.000184850838962136,0.246127624932305,-0.566014970302383,
  -1.37658850213329e-05,0.000567246733637727,0.259115943968765,-0.599013537871522,
  -1.42290740656748e-05,0.000949642628313319,0.272104263005225,-0.632012105440661,
  -1.46922631107937e-05,0.00133203852298847,0.285092582041685,-0.6650106730098,
  -1.51554521554687e-05,0.00171443441766428,0.298080901078146,-0.698009240578939,
  -1.56186412004766e-05,0.00209683031233876,0.311069220114605,-0.731007808148078,
  -1.60818302453736e-05,0.00247922620701457,0.324057539151066,-0.764006375717217,
  -1.65450192899375e-05,0.00286162210168994,0.337045858187526,-0.797004943286357,
  -4.35168288635823e-06,-0.00627725978127903,0.0253093718361411,-0.00510709848344121,
  -4.65912107407151e-06,-0.00593664760446716,0.0379509645294384,-0.0383222696633804,
  -4.9665592617848e-06,-0.0055960354276553,0.0505925572227357,-0.0715374408433196,
  -5.27399744956747e-06,-0.00525542325084344,0.063234149916033,-0.104752612023259,
  -5.58143563716973e-06,-0.00491481107403152,0.0758757426093302,-0.137967783203198,
  -5.8888738248275e-06,-0.00457419889721944,0.0885173353026277,-0.171182954383137,
  -6.19631201270732e-06,-0.00423358672040774,0.101158927995925,-0.204398125563076,
  -6.50375020028182e-06,-0.00389297454359561,0.113800520689222,-0.237613296743015,
  -6.81118838780082e-06,-0.00355236236678358,0.12644211338252,-0.270828467922955,
  -7.11862657587492e-06,-0.00321175018997222,0.139083706075817,-0.304043639102894,
  -7.4260647633384e-06,-0.00287113801316008,0.151725298769114,-0.337258810282833,
  -7.73350295113495e-06,-0.00253052583634816,0.164366891462411,-0.370473981462772,
  -8.0409411389315e-06,-0.00218991365953647,0.177008484155709,-0.403689152642711,
  -8.34837932661703e-06,-0.00184930148272455,0.189650076849006,-0.43690432382265,
  -8.6558175145246e-06,-0.00150868930591286,0.202291669542303,-0.47011949500259,
  -8.96325570232115e-06,-0.00116807712910094,0.214933262235601,-0.503334666182529,
  -9.27069388945156e-06,-0.000827464952288359,0.227574854928898,-0.536549837362468,
  -9.57813207735914e-06,-0.000486852775476443,0.240216447622196,-0.569765008542407,
  -9.88557026537773e-06,-0.000146240598665193,0.252858040315493,-0.602980179722347,
  -1.01930084526192e-05,0.00019437157814739,0.26549963300879,-0.636195350902285,
  -1.05004466407488e-05,0.000534983754958418,0.278141225702087,-0.669410522082225,
  -1.08078848281012e-05,0.000875595931770778,0.290782818395384,-0.702625693262164,
  -1.11153230156757e-05,0.00121620810858269,0.303424411088682,-0.735840864442103,
  -1.14227612030282e-05,0.0015568202853955,0.316066003781979,-0.769056035622042,
  -1.17301993911578e-05,0.00189743246220653,0.328707596475276,-0.802271206801981,
  -3.40627984006525e-06,-0.0062445074647781,0.0252942634384722,-0.00516520534647556,
  -3.60385146050413e-06,-0.00594112973499392,0.0376364252876892,-0.0385660764394793,
  -3.80142308087361e-06,-0.00563775200520966,0.0499785871369062,-0.071966947532483,
  -3.99899470115983e-06,-0.00533437427542527,0.0623207489861233,-0.105367818625487,
  -4.19656632158483e-06,-0.00503099654564115,0.0746629108353402,-0.13876868971849,
  -4.39413794198207e-06,-0.00472761881585693,0.0870050726845572,-0.172169560811494,
  -4.59170956237931e-06,-0.00442424108607264,0.0993472345337743,-0.205570431904498,
  -4.78928118274879e-06,-0.00412086335628836,0.111689396382991,-0.238971302997502,
  -4.98685280320155e-06,-0.00381748562650441,0.124031558232208,-0.272372174090505,
  -5.18442442343225e-06,-0.00351410789671969,0.136373720081425,-0.305773045183509,
  -5.38199604410705e-06,-0.00321073016693596,0.148715881930642,-0.339173916276513,
  -5.57956766444878e-06,-0.00290735243715168,0.161058043779859,-0.372574787369516,
  -5.77713928479051e-06,-0.00260397470736717,0.173400205629076,-0.40597565846252,
  -5.97471090513224e-06,-0.00230059697758289,0.185742367478293,-0.439376529555524,
  -6.1722825256405e-06,-0.00199721924779883,0.19808452932751,-0.472777400648527,
  -6.36985414592672e-06,-0.00169384151801499,0.210426691176727,-0.506178271741531,
  -6.56742576654601e-06,-0.00139046378823049,0.222768853025944,-0.539579142834535,
  -6.76499738661018e-06,-0.00108708605844576,0.235111014875162,-0.572980013927539,
  -6.96256900734049e-06,-0.000783708328662369,0.247453176724378,-0.606380885020543,
  -7.16014062729364e-06,-0.000480330598877199,0.259795338573596,-0.639781756113546,
  -7.35771224813497e-06,-0.000176952869093583,0.272137500422812,-0.67318262720655,
  -7.55528386786608e-06,0.000126424860691365,0.28447966227203,-0.706583498299553,
  -7.75285548837434e-06,0.00042980259047587,0.296821824121247,-0.739984369392557,
  -7.95042710954874e-06,0.000733180320258597,0.309163985970463,-0.773385240485561,
  -8.14799872972394e-06,0.0010365580500431,0.32150614781968,-0.806786111578565,
  -2.61224921833947e-06,-0.00621779686777803,0.0252813566324146,-0.00521303325079621,
  -2.73646024999408e-06,-0.00594604662143827,0.0373755508193538,-0.0387667544067805,
  -2.86067128163481e-06,-0.00567429637509842,0.0494697450062931,-0.0723204755627647,
  -2.98488231320615e-06,-0.00540254612875862,0.0615639391932323,-0.105874196718749,
  -3.10909334491627e-06,-0.00513079588241888,0.0736581333801715,-0.139427917874733,
  -3.23330437662639e-06,-0.0048590456360792,0.0857523275671107,-0.172981639030717,
  -3.35751540811446e-06,-0.00458729538973934,0.0978465217540498,-0.206535360186702,
  -3.48172643993561e-06,-0.0043155451433996,0.109940715940989,-0.240089081342686,
  -3.60593747134041e-06,-0.00404379489705942,0.122034910127929,-0.27364280249867,
  -3.73014850296727e-06,-0.0037720446507199,0.134129104314868,-0.307196523654654,
  -3.85435953470514e-06,-0.00350029440438004,0.146223298501807,-0.340750244810639,
  -3.97857056655404e-06,-0.00322854415804064,0.158317492688746,-0.374303965966623,
  -4.10278159795885e-06,-0.00295679391170056,0.170411686875685,-0.407857687122607,
  -4.22699262947468e-06,-0.00268504366536071,0.182505881062625,-0.441411408278591,
  -4.35120366115704e-06,-0.00241329341902108,0.194600075249564,-0.474965129434575,
  -4.47541469283941e-06,-0.002141543172681,0.206694269436503,-0.50851885059056,
  -4.59962572441075e-06,-0.00186979292634115,0.218788463623443,-0.542072571746544,
  -4.72383675642618e-06,-0.00159804268000197,0.230882657810381,-0.575626292902528,
  -4.8480477878865e-06,-0.00132629243366189,0.242976851997321,-0.609180014058512,
  -4.97225881934682e-06,-0.00105454218732204,0.25507104618426,-0.642733735214497,
  -5.09646985102918e-06,-0.000782791940982186,0.267165240371199,-0.676287456370481,
  -5.22068088304461e-06,-0.000511041694642778,0.279259434558139,-0.709841177526465,
  -5.34489191461596e-06,-0.000239291448302481,0.291353628745078,-0.743394898682449,
  -5.46910294585423e-06,3.24587980369273e-05,0.303447822932017,-0.776948619838434,
  -5.59331397842477e-06,0.000304209044375447,0.315542017118955,-0.810502340994418,
  -1.96980984534106e-06,-0.00619669904589003,0.025270780592608,-0.00525109781491041,
  -2.04703023620745e-06,-0.00595075304648801,0.0371666545363841,-0.0389264670151655,
  -2.12425062715016e-06,-0.00570480704708615,0.0490625284801601,-0.0726018362154206,
  -2.20147101809287e-06,-0.00545886104768428,0.0609584024239361,-0.106277205415676,
  -2.27869140900783e-06,-0.00521291504828231,0.0728542763677122,-0.139952574615931,
  -2.35591179981176e-06,-0.00496696904888028,0.0847501503114882,-0.173627943816186,
  -2.43313219064345e-06,-0.0047210230494783,0.0966460242552643,-0.207303313016441,
  -2.51035258169718e-06,-0.00447507705007644,0.10854189819904,-0.240978682216696,
  -2.58757297250112e-06,-0.00422913105067457,0.120437772142816,-0.274654051416951,
  -2.66479336330505e-06,-0.00398318505127215,0.132333646086593,-0.308329420617206,
  -2.74201375422001e-06,-0.0037372390518704,0.144229520030369,-0.342004789817462,
  -2.81923414541252e-06,-0.00349129305246887,0.156125393974144,-0.375680159017717,
  -2.89645453616094e-06,-0.00324534705306645,0.168021267917921,-0.409355528217972,
  -2.97367492702039e-06,-0.0029994010536647,0.179917141861697,-0.443030897418227,
  -3.05089531793534e-06,-0.00275345505426272,0.191813015805473,-0.476706266618482,
  -3.12811570890581e-06,-0.00250750905486097,0.203708889749249,-0.510381635818737,
  -3.20533609965423e-06,-0.00226156305545877,0.215604763693025,-0.544057005018992,
  -3.28255649084674e-06,-0.00201561705605724,0.227500637636801,-0.577732374219247,
  -3.35977688170619e-06,-0.00176967105665504,0.239396511580577,-0.611407743419502,
  -3.43699727312075e-06,-0.00152372505725396,0.251292385524353,-0.645083112619757,
  -3.51421766364712e-06,-0.00127777905785154,0.263188259468129,-0.678758481820013,
  -3.59143805461759e-06,-0.00103183305844956,0.275084133411905,-0.712433851020268,
  -3.66865844536601e-06,-0.000785887059047585,0.286980007355681,-0.746109220220523,
  -3.74587883600341e-06,-0.000539941059645166,0.298875881299457,-0.779784589420778,
  -3.82309922664081e-06,-0.000293995060242747,0.310771755243234,-0.813459958621033,
  -1.46554387259884e-06,-0.00618045097756702,0.0252624014483386,-0.00528058882068535,
  -1.51349218004138e-06,-0.0059548832993663,0.0370040323170038,-0.0390502063923481,
  -1.56144048751861e-06,-0.00572931562116558,0.048745663185669,-0.0728198239640108,
  -1.60938879489869e-06,-0.00550374794296482,0.0604872940543341,-0.106589441535674,
  -1.65733710233429e-06,-0.00527818026476412,0.0722289249229993,-0.140359059107336,
  -1.70528540979764e-06,-0.00505261258656331,0.0839705557916645,-0.174128676678999,
  -1.75323371737202e-06,-0.00482704490836272,0.0957121866603297,-0.207898294250662,
  -1.80118202458557e-06,-0.00460147723016169,0.107453817528995,-0.241667911822324,
  -1.8491303321877e-06,-0.00437590955196132,0.11919544839766,-0.275437529393987,
  -1.89707863951227e-06,-0.0041503418737604,0.130937079266325,-0.30920714696565,
  -1.94502694689236e-06,-0.00392477419555948,0.14267871013499,-0.342976764537313,
  -1.99297525438347e-06,-0.00369920651735889,0.154420341003656,-0.376746382108975,
  -2.04092356187457e-06,-0.00347363883915808,0.166161971872321,-0.410515999680638,
  -2.08887186942119e-06,-0.00324807116095749,0.177903602740986,-0.444285617252301,
  -2.13682017669026e-06,-0.00302250348275668,0.189645233609651,-0.478055234823964,
  -2.18476848423688e-06,-0.00279693580455631,0.201386864478316,-0.511824852395626,
  -2.23271679145043e-06,-0.00257136812635483,0.213128495346982,-0.545594469967289,
  -2.28066509888603e-06,-0.00234580044815402,0.224870126215647,-0.579364087538952,
  -2.32861340643264e-06,-0.00212023276995388,0.236611757084312,-0.613133705110615,
  -2.37656171397926e-06,-0.00189466509175329,0.248353387952977,-0.646903322682277,
  -2.42451002163691e-06,-0.00166909741355248,0.260095018821642,-0.68067294025394,
  -2.47245832851739e-06,-0.00144352973535122,0.271836649690307,-0.714442557825603,
  -2.52040663661912e-06,-0.0012179620571513,0.283578280558972,-0.748212175397266,
  -2.56835494349961e-06,-0.000992394378949157,0.295319911427638,-0.781981792968928,
  -2.61630325071316e-06,-0.000766826700748346,0.307061542296303,-0.815751410540591,
  -1.07906766994709e-06,-0.00616817972183895,0.0252559358611204,-0.00530296515732785,
  -1.10905105556169e-06,-0.00595829925679961,0.0368801897736026,-0.0391440937958805,
  -1.13903444118324e-06,-0.00574841879176025,0.0485044436860849,-0.0729852224344332,
  -1.16901782679091e-06,-0.00553853832672085,0.0601286975985671,-0.106826351072986,
  -1.19900121237082e-06,-0.00532865786168146,0.0717529515110493,-0.140667479711539,
  -1.22898459806176e-06,-0.00511877739664213,0.0833772054235316,-0.174508608350091,
  -1.25896798369718e-06,-0.0049088969316029,0.0950014593360137,-0.208349736988644,
  -1.2889513690828e-06,-0.00469901646656312,0.106625713248496,-0.242190865627196,
  -1.31893475469047e-06,-0.00448913600152401,0.118249967160978,-0.276031994265749,
  -1.34891814052018e-06,-0.00427925553648456,0.129874221073461,-0.309873122904302,
  -1.37890152596132e-06,-0.00406937507144534,0.141498474985942,-0.343714251542855,
  -1.40888491145796e-06,-0.00385949460640567,0.153122728898425,-0.377555380181407,
  -1.43886829717665e-06,-0.00364961414136622,0.164746982810907,-0.41139650881996,
  -1.46885168289534e-06,-0.00343973367632699,0.176371236723389,-0.445237637458512,
  -1.49883506850301e-06,-0.00322985321128777,0.187995490635872,-0.479078766097065,
  -1.52881845383313e-06,-0.0030199727462481,0.199619744548354,-0.512919894735618,
  -1.55880183982937e-06,-0.0028100922812091,0.211243998460836,-0.546761023374171,
  -1.58878522515948e-06,-0.00260021181616921,0.222868252373319,-0.580602152012723,
  -1.61876861060062e-06,-0.00239033135112976,0.234492506285801,-0.614443280651276,
  -1.64875199659686e-06,-0.00218045088609076,0.246116760198283,-0.648284409289828,
  -1.67873538248209e-06,-0.00197057042105175,0.257741014110765,-0.682125537928381,
  -1.70871876747913e-06,-0.00176068995601186,0.269365268023247,-0.715966666566934,
  -1.73870215314231e-06,-0.0015508094909733,0.280989521935729,-0.749807795205486,
  -1.76868553858345e-06,-0.00134092902593297,0.292613775848212,-0.783648923844039,
  -1.79866892446867e-06,-0.00113104856089352,0.304238029760694,-0.817490052482591,
  -7.88248433407357e-07,-0.00615904771366496,0.0252510466753871,-0.00531967566949122,
  -8.07243923386936e-07,-0.00596100914560357,0.036787450125136,-0.039214208338032,
  -8.26239413387331e-07,-0.00576297057754227,0.0483238535748849,-0.0731087410065727,
  -8.45234903401604e-07,-0.00556493200948088,0.0598602570246339,-0.107003273675114,
  -8.64230393471388e-07,-0.00536689344141961,0.0713966604743828,-0.140897806343654,
  -8.83225883541172e-07,-0.00516885487335828,0.0829330639241318,-0.174792339012195,
  -9.02221373333401e-07,-0.00497081630529672,0.0944694673738807,-0.208686871680736,
  -9.21216863458696e-07,-0.0047727777372355,0.10600587082363,-0.242581404349277,
  -9.40212353084391e-07,-0.00457473916917361,0.117542274273379,-0.276475937017817,
  -9.5920784337622e-07,-0.00437670060111273,0.129078677723128,-0.310370469686358,
  -9.78203333334982e-07,-0.00417866203305128,0.140615081172876,-0.344265002354899,
  -9.97198822960677e-07,-0.00398062346498929,0.152151484622626,-0.37815953502344,
  -1.01619431336353e-06,-0.00378258489692884,0.163687888072374,-0.41205406769198,
  -1.03518980326678e-06,-0.00358454632886684,0.175224291522124,-0.445948600360521,
  -1.05418529317003e-06,-0.00338650776080596,0.186760694971872,-0.479843133029062,
  -1.07318078323981e-06,-0.00318846919274463,0.198297098421621,-0.513737665697602,
  -1.09217627308755e-06,-0.00299043062468285,0.20983350187137,-0.547632198366143,
  -1.11117176337938e-06,-0.00279239205662174,0.221369905321119,-0.581526731034684,
  -1.13016725333814e-06,-0.00259435348856041,0.232906308770868,-0.615421263703225,
  -1.14916274340793e-06,-0.00239631492049908,0.244442712220617,-0.649315796371766,
  -1.16815823325567e-06,-0.0021982763524373,0.255979115670366,-0.683210329040306,
  -1.18715372310341e-06,-0.00200023778437552,0.267515519120115,-0.717104861708847,
  -1.2061492137283e-06,-0.00180219921631553,0.279051922569864,-0.750999394377388,
  -1.22514470346502e-06,-0.00160416064825331,0.290588326019613,-0.784893927045929,
  -1.24414019331276e-06,-0.00140612208019197,0.302124729469362,-0.818788459714469,
  -5.72414513677622e-07,-0.00615232617215074,0.0252474053070923,-0.00533200752270217,
  -5.84649016172056e-07,-0.00596309611677742,0.03671887135759,-0.0392659507522268,
  -5.96883518652613e-07,-0.00577386606140412,0.0481903374080877,-0.0731998939817515,
  -6.09118021105415e-07,-0.00558463600603071,0.0596618034585855,-0.107133837211276,
  -6.21352523516583e-07,-0.00539540595065729,0.0711332695090832,-0.141067780440801,
  -6.33587025927751e-07,-0.00520617589528383,0.082604735559581,-0.175001723670325,
  -6.45821528366675e-07,-0.00501694583991041,0.0940762016100787,-0.20893566689985,
  -6.58056031055398e-07,-0.00482771578453745,0.105547667660576,-0.242869610129375,
  -6.70290533466567e-07,-0.00463848572916414,0.117019133711074,-0.276803553358899,
  -6.82525035988757e-07,-0.00444925567379073,0.128490599761572,-0.310737496588424,
  -6.94759538344414e-07,-0.00426002561841732,0.139962065812069,-0.344671439817949,
  -7.06994040811093e-07,-0.00407079556304368,0.151433531862567,-0.378605383047473,
  -7.19228543555328e-07,-0.00388156550767071,0.162904997913065,-0.412539326276998,
  -7.31463045577918e-07,-0.00369233545229686,0.174376463963563,-0.446473269506523,
  -7.43697548211131e-07,-0.00350310539692367,0.18584793001406,-0.480407212736047,
  -7.55932050955366e-07,-0.0033138753415507,0.197319396064558,-0.514341155965572,
  -7.68166553588578e-07,-0.00312464528617751,0.208790862115056,-0.548275099195097,
  -7.80401055888724e-07,-0.00293541523080409,0.220262328165553,-0.582209042424621,
  -7.92635558299892e-07,-0.00274618517543068,0.231733794216051,-0.616142985654146,
  -8.04870060489016e-07,-0.0025569551200566,0.243205260266549,-0.65007692888367,
  -8.17104562900184e-07,-0.00236772506468386,0.254676726317046,-0.684010872113195,
  -8.29339065866463e-07,-0.00217849500931067,0.266148192367544,-0.71794481534272,
  -8.41573567944565e-07,-0.00198926495393748,0.277619658418041,-0.751878758572245,
  -8.53808070133688e-07,-0.00180003489856295,0.28909112446854,-0.78581270180177,
  -8.66042573099968e-07,-0.00161080484319065,0.300562590519037,-0.819746645031294,
  -4.13869175520942e-07,-0.0061474187365574,0.0252447236841371,-0.00534102845601091,
  -4.21889341600812e-07,-0.00596466965806236,0.0366686298337597,-0.0393038010947261,
  -4.29909507757009e-07,-0.00578192057956745,0.0480925359833822,-0.0732665737334412,
  -4.3792967382994e-07,-0.00559917150107236,0.0595164421330048,-0.107229346372156,
  -4.45949840027771e-07,-0.00541642242257745,0.0709403482826274,-0.141192119010872,
  -4.53970006031312e-07,-0.00523367334408242,0.0823642544322499,-0.175154891649587,
  -4.61990172090365e-07,-0.00505092426558718,0.0937881605818727,-0.209117664288302,
  -4.70010338315952e-07,-0.00486817518709237,0.105212066731495,-0.243080436927017,
  -4.78030504458271e-07,-0.00468542610859746,0.116635972881118,-0.277043209565732,
  -4.8605067054508e-07,-0.00450267703010254,0.12805987903074,-0.311005982204447,
  -4.94070836298821e-07,-0.00431992795160707,0.139483785180363,-0.344968754843162,
  -5.0209100238563e-07,-0.00413717887311194,0.150907691329985,-0.378931527481877,
  -5.10111168861016e-07,-0.00395442979461746,0.162331597479608,-0.412894300120593,
  -5.18131334836802e-07,-0.00377168071612233,0.17375550362923,-0.446857072759308,
  -5.26151501145655e-07,-0.00358893163762763,0.185179409778853,-0.480819845398023,
  -5.34171667232464e-07,-0.0034061825591325,0.196603315928475,-0.514782618036738,
  -5.4219183320825e-07,-0.00322343348063736,0.208027222078098,-0.548745390675453,
  -5.50211999628125e-07,-0.00304068440214289,0.219451128227721,-0.582708163314168,
  -5.58232165936978e-07,-0.0028579353236482,0.230875034377343,-0.616670935952883,
  -5.66252330913564e-07,-0.00267518624515128,0.242298940526966,-0.650633708591598,
  -5.74272497333439e-07,-0.00249243716665681,0.253722846676589,-0.684596481230314,
  -5.82292663975359e-07,-0.00230968808816279,0.265146752826211,-0.718559253869029,
  -5.90312829396034e-07,-0.00212693900966698,0.276570658975833,-0.752522026507744,
  -5.98332995704887e-07,-0.00194418993117251,0.287994565125456,-0.786484799146459,
  -6.06353162346807e-07,-0.0017614408526776,0.299418471275079,-0.820447571785174,
  -1.88214363341863e-05,-0.00685505252793257,0.0372352849382559,-0.0183293921652007,
  -2.19693087145506e-05,-0.00617600832893198,0.053071722954117,-0.0485726429861822,
  -2.51171810948525e-05,-0.00549696412993123,0.0689081609699782,-0.0788158938071636,
  -2.82650534750573e-05,-0.00481791993093039,0.0847445989858394,-0.109059144628145,
  -3.14129258554563e-05,-0.00413887573192984,0.100581037001701,-0.139302395449127,
  -3.45607982356055e-05,-0.00345983153292906,0.116417475017562,-0.169545646270108,
  -3.77086706160323e-05,-0.00278078733392839,0.132253913033423,-0.199788897091089,
  -4.08565429965146e-05,-0.00210174313492795,0.148090351049284,-0.230032147912071,
  -4.40044153765529e-05,-0.00142269893592695,0.163926789065145,-0.260275398733052,
  -4.71522877570352e-05,-0.000743654736926391,0.179763227081006,-0.290518649554034,
  -5.03001601370734e-05,-6.46105379251694e-05,0.195599665096868,-0.320761900375015,
  -5.34480325177777e-05,0.000614433661074942,0.211436103112729,-0.351005151195997,
  -5.65959048976494e-05,0.00129347786007616,0.22727254112859,-0.381248402016978,
  -5.97437772780762e-05,0.00197252205907672,0.243108979144451,-0.41149165283796,
  -6.28916496586696e-05,0.00265156625807705,0.258945417160312,-0.441734903658941,
  -6.60395220386523e-05,0.00333061045707805,0.274781855176173,-0.471978154479923,
  -6.91873944190791e-05,0.00400965465607883,0.290618293192035,-0.502221405300904,
  -7.23352667991728e-05,0.00468869885507983,0.306454731207896,-0.532464656121886,
  -7.54831391794886e-05,0.00536774305408039,0.322291169223757,-0.562707906942867,
  -7.86310115603595e-05,0.00604678725308005,0.338127607239618,-0.592951157763849,
  -8.17788839406752e-05,0.00672583145208128,0.353964045255479,-0.62319440858483,
  -8.49267563204359e-05,0.0074048756510825,0.369800483271341,-0.653437659405811,
  -8.80746287010847e-05,0.00808391985008283,0.385636921287202,-0.683680910226793,
  -9.12225010808454e-05,0.00876296404908405,0.401473359303063,-0.713924161047774,
  -9.43703734609391e-05,0.00944200824808528,0.417309797318924,-0.744167411868756,
  -1.87366418219342e-05,-0.00684975478369067,0.0372263427390231,-0.0183417609263533,
  -2.18564035990298e-05,-0.00617246373150038,0.0530393725162785,-0.0486008942974748,
  -2.49761653760283e-05,-0.00549517267930999,0.0688524022935339,-0.0788600276685963,
  -2.80959271531378e-05,-0.00481788162711977,0.0846654320707892,-0.109119161039718,
  -3.12156889302473e-05,-0.00414059057492955,0.100478461848044,-0.139378294410839,
  -3.4335450707107e-05,-0.00346329952273894,0.1162914916253,-0.169637427781961,
  -3.7455212484383e-05,-0.00278600847054877,0.132104521402555,-0.199896561153082,
  -4.05749742612982e-05,-0.00210871741835839,0.147917551179811,-0.230155694524204,
  -4.36947360384354e-05,-0.00143142636616844,0.163730580957066,-0.260414827895325,
  -4.68144978154617e-05,-0.000754135313977833,0.179543610734321,-0.290673961266447,
  -4.99342595923769e-05,-7.68442617873344e-05,0.195356640511577,-0.320933094637568,
  -5.30540213692365e-05,0.000600446790403275,0.211169670288832,-0.35119222800869,
  -5.61737831464293e-05,0.00127773784259322,0.226982700066087,-0.381451361379811,
  -5.9293544923622e-05,0.00195502889478383,0.242795729843343,-0.411710494750933,
  -6.24133067010924e-05,0.00263231994697355,0.258608759620598,-0.441969628122054,
  -6.55330684780076e-05,0.00330961099916349,0.274421789397853,-0.472228761493176,
  -6.86528302548117e-05,0.00398690205135432,0.290234819175109,-0.502487894864297,
  -7.1772592031949e-05,0.00466419310354449,0.306047848952364,-0.532747028235419,
  -7.48923538085311e-05,0.00534148415573532,0.32186087872962,-0.56300616160654,
  -7.80121155858904e-05,0.00601877520792549,0.337673908506875,-0.593265294977662,
  -8.11318773628056e-05,0.00669606626011587,0.35348693828413,-0.623524428348783,
  -8.42516391402759e-05,0.00737335731230582,0.369299968061386,-0.653783561719905,
  -8.73714009170801e-05,0.0080506483644962,0.385112997838641,-0.684042695091026,
  -9.04911626937732e-05,0.00872793941668748,0.400926027615897,-0.714301828462148,
  -9.36109244710215e-05,0.00940523046887742,0.416739057393152,-0.744560961833269,
  -1.86192833677642e-05,-0.00684244467215672,0.0372139665350253,-0.0183588529880309,
  -2.17003591440612e-05,-0.00616759190513824,0.0529946244144051,-0.0486399340322654,
  -2.47814349203651e-05,-0.00549273913811976,0.0687752822937849,-0.0789210150764998,
  -2.78625106967523e-05,-0.00481788637110131,0.0845559401731646,-0.109202096120734,
  -3.09435864731256e-05,-0.00414303360408297,0.100336598052544,-0.139483177164969,
  -3.40246622494156e-05,-0.00346818083706446,0.116117255931924,-0.169764258209203,
  -3.71057380255668e-05,-0.00279332807004573,0.131897913811304,-0.200045339253438,
  -4.01868138019124e-05,-0.00211847530302745,0.147678571690684,-0.230326420297672,
  -4.32678895783689e-05,-0.00144362253600905,0.163459229570063,-0.260607501341907,
  -4.63489653548255e-05,-0.000768769768990873,0.179239887449443,-0.290888582386141,
  -4.943004113106e-05,-9.39170019722546e-05,0.195020545328823,-0.321169663430376,
  -5.2511116907128e-05,0.000580935765046586,0.210801203208203,-0.35145074447461,
  -5.55921926835845e-05,0.00125578853206476,0.226581861087582,-0.381731825518845,
  -5.86732684600966e-05,0.00193064129908316,0.242362518966962,-0.412012906563079,
  -6.17543442361645e-05,0.00260549406610155,0.258143176846342,-0.442293987607314,
  -6.48354200128987e-05,0.00328034683311951,0.273923834725721,-0.472575068651548,
  -6.79164957891887e-05,0.00395519960013813,0.289704492605101,-0.502856149695783,
  -7.09975715654787e-05,0.00463005236715697,0.305485150484481,-0.533137230740017,
  -7.40786473417687e-05,0.00530490513417536,0.321265808363861,-0.563418311784251,
  -7.71597231180587e-05,0.00597975790119376,0.337046466243241,-0.593699392828486,
  -8.02407988945708e-05,0.00665461066821216,0.352827124122621,-0.62398047387272,
  -8.33218746706388e-05,0.007329463435231,0.368607782002,-0.654261554916955,
  -8.64029504470398e-05,0.00800431620224895,0.38438843988138,-0.684542635961189,
  -8.94840262234409e-05,0.00867916896926735,0.40016909776076,-0.714823717005424,
  -9.2565102000064e-05,0.0093540217362853,0.415949755640139,-0.745104798049659,
  -1.84575372020879e-05,-0.00683241166888501,0.0371969096452189,-0.0183823589785741,
  -2.1485713185318e-05,-0.00616094185344759,0.0529330010553548,-0.0486936237306827,
  -2.45138891684926e-05,-0.00548947203801003,0.0686690924654907,-0.0790048884827912,
  -2.75420651517089e-05,-0.00481800222257261,0.0844051838756265,-0.1093161532349,
  -3.05702411349806e-05,-0.00414653240713514,0.100141275285762,-0.139627417987008,
  -3.35984171181691e-05,-0.00347506259169783,0.115877366695898,-0.169938682739117,
  -3.66265931014409e-05,-0.0028035927762603,0.131613458106034,-0.200249947491225,
  -3.96547690846294e-05,-0.00213212296082288,0.14734954951617,-0.230561212243334,
  -4.26829450678734e-05,-0.00146065314538546,0.163085640926306,-0.260872476995442,
  -4.57111210511729e-05,-0.000789183329947929,0.178821732336442,-0.291183741747551,
  -4.87392970341394e-05,-0.000117713514510065,0.194557823746578,-0.321495006499659,
  -5.17674730172724e-05,0.000553756300927244,0.210293915156713,-0.351806271251768,
  -5.47956490006829e-05,0.00122522611636455,0.226030006566849,-0.382117536003877,
  -5.78238249840379e-05,0.00189669593180186,0.241766097976985,-0.412428800755985,
  -6.08520009670599e-05,0.00256816574723939,0.257502189387121,-0.442740065508094,
  -6.38801769502484e-05,0.00323963556267715,0.273238280797257,-0.473051330260202,
  -6.69083529335479e-05,0.00391110537811445,0.288974372207393,-0.503362595012311,
  -6.99365289167364e-05,0.00458257519355176,0.304710463617528,-0.533673859764419,
  -7.29647048999249e-05,0.00525404500898952,0.320446555027665,-0.563985124516528,
  -7.59928808832244e-05,0.00592551482442705,0.3361826464378,-0.594296389268636,
  -7.90210568660799e-05,0.0065969846398648,0.351918737847936,-0.624607654020745,
  -8.20492328499345e-05,0.00726845445530122,0.367654829258072,-0.654918918772853,
  -8.5077408833345e-05,0.00793992427073809,0.383390920668207,-0.685230183524962,
  -8.81055848157564e-05,0.00861139408617717,0.399127012078344,-0.71554144827707,
  -9.11337607991669e-05,0.00928286390161448,0.41486310348848,-0.745852713029179,
  -1.82359026973528e-05,-0.0068187423677884,0.0371735380238382,-0.0184144733187535,
  -2.11923778945938e-05,-0.00615194997760457,0.0528486543261413,-0.0487669756379732,
  -2.4148853091821e-05,-0.00548515758742074,0.0685237706284444,-0.0791194779571929,
  -2.71053282892286e-05,-0.00481836519723722,0.0841988869307474,-0.109471980276413,
  -3.00618034866085e-05,-0.00415157280705358,0.0998740032330505,-0.139824482595632,
  -3.30182786838773e-05,-0.00348478041686973,0.115549119535354,-0.170176984914852,
  -3.59747538810629e-05,-0.00281798802668609,0.131224235837657,-0.200529487234072,
  -3.89312290784427e-05,-0.00215119563650235,0.14689935213996,-0.230881989553292,
  -4.18877042758226e-05,-0.00148440324631871,0.162574468442263,-0.261234491872511,
  -4.48441794729804e-05,-0.000817610856134965,0.178249584744566,-0.291586994191731,
  -4.78006546705267e-05,-0.000150818465951552,0.193924701046869,-0.321939496510951,
  -5.0757129867629e-05,0.000515973924232638,0.209599817349172,-0.35229199883017,
  -5.37136050651754e-05,0.00118276631441594,0.225274933651475,-0.38264450114939,
  -5.66700802620557e-05,0.00184955870460035,0.240950049953778,-0.41299700346861,
  -5.96265554598796e-05,0.00251635109478343,0.256625166256081,-0.443349505787829,
  -6.25830306567599e-05,0.0031831434849674,0.272300282558384,-0.473702008107049,
  -6.55395058540842e-05,0.00384993587515092,0.287975398860687,-0.504054510426269,
  -6.84959810511865e-05,0.00451672826533511,0.30365051516299,-0.534407012745489,
  -7.14524562486218e-05,0.00518352065551841,0.319325631465293,-0.564759515064708,
  -7.44089314462792e-05,0.00585031304570194,0.335000747767596,-0.595112017383928,
  -7.73654066436036e-05,0.00651710543588546,0.350675864069899,-0.625464519703148,
  -8.03218818407059e-05,0.00718389782606943,0.366350980372202,-0.655817022022367,
  -8.32783570380302e-05,0.00785069021625295,0.382026096674505,-0.686169524341587,
  -8.62348322353546e-05,0.00851748260643692,0.397701212976808,-0.716522026660807,
  -8.91913074322348e-05,0.00918427499662089,0.413376329279111,-0.746874528980027,
  -1.79346047260026e-05,-0.00680030432163194,0.0371417678314268,-0.0184579555447157,
  -2.07950609872887e-05,-0.00613994738454396,0.0527341638745772,-0.0488662927713706,
  -2.36555172485886e-05,-0.005479590447456,0.0683265599177277,-0.0792746299980255,
  -2.65159735098608e-05,-0.00481923351036806,0.0839189559608781,-0.10968296722468,
  -2.93764297711607e-05,-0.00415887657328007,0.0995113520040287,-0.140091304451335,
  -3.22368860323219e-05,-0.00349851963619197,0.115103748047179,-0.17049964167799,
  -3.50973422939549e-05,-0.00283816269910442,0.130696144090329,-0.200907978904645,
  -3.79577985551438e-05,-0.00217780576201632,0.14628854013348,-0.2313163161313,
  -4.08182548163882e-05,-0.00151744882492832,0.16188093617663,-0.261724653357955,
  -4.36787110777992e-05,-0.000857091887840555,0.177473332219781,-0.29213299058461,
  -4.65391673391546e-05,-0.000196734950752564,0.193065728262931,-0.322541327811265,
  -4.9399623600177e-05,0.000463621986335871,0.208658124306082,-0.35294966503792,
  -5.2260079861588e-05,0.00112397892342342,0.224250520349232,-0.383358002264575,
  -5.512053612311e-05,0.00178433586051119,0.239842916392383,-0.413766339491229,
  -5.79809923841879e-05,0.0024446927975994,0.255435312435533,-0.444174676717884,
  -6.08414486454878e-05,0.00310504973468717,0.271027708478684,-0.474583013944539,
  -6.37019049071208e-05,0.00376540667177472,0.286620104521834,-0.504991351171194,
  -6.65623611679766e-05,0.0044257636088636,0.302212500564985,-0.535399688397849,
  -6.94228174293876e-05,0.00508612054595137,0.317804896608135,-0.565808025624504,
  -7.22832736904655e-05,0.00574647748303958,0.333397292651286,-0.596216362851159,
  -7.51437299522095e-05,0.00640683442012691,0.348989688694436,-0.626624700077814,
  -7.80041862128433e-05,0.00706719135721556,0.364582084737586,-0.657033037304469,
  -8.08646424746984e-05,0.00772754829430289,0.380174480780737,-0.687441374531124,
  -8.37250987359983e-05,0.00838790523139066,0.395766876823887,-0.717849711757778,
  -8.65855549972983e-05,0.00904826216847932,0.411359272867038,-0.748258048984433,
  -1.75293962865336e-05,-0.00677576723881289,0.0370990460173373,-0.0185161179004411,
  -2.02633523189166e-05,-0.00612420253475468,0.0525805047211186,-0.0489991405802043,
  -2.29973083512441e-05,-0.0054726378306964,0.0680619634249,-0.0794821632599674,
  -2.57312643835717e-05,-0.00482107312663815,0.0835434221286812,-0.109965185939731,
  -2.84652204158575e-05,-0.00416950842257968,0.0990248808324627,-0.140448208619494,
  -3.11991764481434e-05,-0.00351794371852143,0.114506339536244,-0.170931231299257,
  -3.39331324807346e-05,-0.0028663790144634,0.129987798240025,-0.20141425397902,
  -3.66670885128539e-05,-0.00221481431040504,0.145469256943807,-0.231897276658783,
  -3.94010445453619e-05,-0.00156324960634668,0.160950715647588,-0.262380299338546,
  -4.21350005775367e-05,-0.000911684902288434,0.176432174351369,-0.29286332201831,
  -4.48689566101002e-05,-0.000260120198230407,0.19191363305515,-0.323346344698073,
  -4.76029126424415e-05,0.000391444505827732,0.207395091758932,-0.353829367377836,
  -5.03368686746164e-05,0.00104300920988654,0.222876550462713,-0.384312390057599,
  -5.30708247066247e-05,0.00169457391394512,0.238358009166495,-0.414795412737362,
  -5.58047807394102e-05,0.00234613861800304,0.253839467870276,-0.445278435417126,
  -5.85387367717516e-05,0.00299770332206117,0.269320926574057,-0.475761458096889,
  -6.1272692804204e-05,0.00364926802611931,0.284802385277839,-0.506244480776652,
  -6.40066488362123e-05,0.00430083273017789,0.30028384398162,-0.536727503456415,
  -6.67406048686647e-05,0.00495239743423603,0.315765302685401,-0.567210526136178,
  -6.94745609011171e-05,0.00560396213829417,0.331246761389183,-0.597693548815941,
  -7.22085169332365e-05,0.00625552684235275,0.346728220092964,-0.628176571495704,
  -7.4942472966022e-05,0.00690709154641045,0.362209678796745,-0.658659594175468,
  -7.76764289983634e-05,0.00755865625046859,0.377691137500526,-0.689142616855231,
  -8.04103850307047e-05,0.00821022095452673,0.393172596204307,-0.719625639534994,
  -8.31443410631572e-05,0.00886178565858531,0.408654054908089,-0.750108662214757,
  -1.69922629897207e-05,-0.00674369450186987,0.0370424276515967,-0.0185926635691099,
  -1.9563170846032e-05,-0.0061040222919802,0.0523773798652408,-0.0491739774524651,
  -2.21340787024266e-05,-0.00546435008209067,0.0677123320788847,-0.0797552913358204,
  -2.47049865587934e-05,-0.00482467787220103,0.0830472842925288,-0.110336605219176,
  -2.72758944151186e-05,-0.00418500566231128,0.0983822365061729,-0.140917919102531,
  -2.9846802271416e-05,-0.0035453334524217,0.113717188719817,-0.171499232985886,
  -3.24177101278522e-05,-0.002905661242532,0.129052140933461,-0.202080546869242,
  -3.49886179841774e-05,-0.00226598903264241,0.144387093147105,-0.232661860752597,
  -3.75595258406691e-05,-0.00162631682275294,0.159722045360749,-0.263243174635952,
  -4.01304336968833e-05,-0.000986644612863241,0.175056997574393,-0.293824488519308,
  -4.27013415530975e-05,-0.000346972402973433,0.190391949788037,-0.324405802402663,
  -4.52722494096447e-05,0.000292699806916152,0.205726902001681,-0.354987116286018,
  -4.78431572659699e-05,0.000932372016805516,0.221061854215325,-0.385568430169373,
  -5.04140651225171e-05,0.00157204422669488,0.236396806428969,-0.416149744052729,
  -5.29849729786758e-05,0.00221171643658491,0.251731758642613,-0.446731057936084,
  -5.55558808349454e-05,0.00285138864647472,0.267066710856257,-0.477312371819439,
  -5.81267886915482e-05,0.00349106085636408,0.282401663069901,-0.507893685702795,
  -6.06976965478179e-05,0.00413073306625367,0.297736615283545,-0.53847499958615,
  -6.32686044041986e-05,0.00477040527614325,0.313071567497189,-0.569056313469505,
  -6.58395122608013e-05,0.00541007748603284,0.328406519710833,-0.599637627352861,
  -6.8410420117071e-05,0.0060497496959222,0.343741471924477,-0.630218941236216,
  -7.09813279733407e-05,0.00668942190581268,0.359076424138122,-0.660800255119571,
  -7.35522358296103e-05,0.00732909411570182,0.374411376351766,-0.691381569002926,
  -7.612314368588e-05,0.00796876632559185,0.38974632856541,-0.721962882886282,
  -7.86940515423717e-05,0.00860843853548099,0.405081280779054,-0.752544196769637,
  -1.62937396231272e-05,-0.0067027433278069,0.0369688261835577,-0.018691278456884,
  -1.86604746705704e-05,-0.00607893113012178,0.0521141854907746,-0.0493992223139529,
  -2.10272097180136e-05,-0.00545511893243666,0.0672595447979915,-0.0801071661710218,
  -2.33939447654985e-05,-0.00483130673475157,0.0824049041052085,-0.110815110028091,
  -2.57606798129972e-05,-0.00420749453706659,0.0975502634124253,-0.14152305388516,
  -2.81274148602184e-05,-0.00358368233938122,0.112695622719642,-0.172230997742229,
  -3.04941499078559e-05,-0.0029598701416963,0.127840982026859,-0.202938941599298,
  -3.28608849553547e-05,-0.00233605794401126,0.142986341334076,-0.233646885456367,
  -3.52276200029089e-05,-0.00171224574632622,0.158131700641293,-0.264354829313435,
  -3.75943550502411e-05,-0.00108843354864108,0.17327705994851,-0.295062773170504,
  -3.99610900979064e-05,-0.000464621350956262,0.188422419255727,-0.325770717027573,
  -4.23278251451276e-05,0.000159190846729551,0.203567778562944,-0.356478660884642,
  -4.46945601925153e-05,0.000783003044414032,0.21871313787016,-0.387186604741711,
  -4.70612952400695e-05,0.0014068152420994,0.233858497177378,-0.41789454859878,
  -4.94280302876238e-05,0.00203062743978433,0.249003856484594,-0.448602492455849,
  -5.17947653349005e-05,0.0026544396374697,0.264149215791811,-0.479310436312918,
  -5.41615003825102e-05,0.00327825183515484,0.279294575099029,-0.510018380169987,
  -5.6528235430342e-05,0.00390206403283933,0.294439934406245,-0.540726324027056,
  -5.88949704776187e-05,0.00452587623052447,0.309585293713462,-0.571434267884125,
  -6.12617055247844e-05,0.00514968842821051,0.324730653020679,-0.602142211741194,
  -6.36284405725052e-05,0.00577350062589455,0.339876012327896,-0.632850155598263,
  -6.5995175620337e-05,0.00639731282357925,0.355021371635113,-0.663558099455332,
  -6.83619106673916e-05,0.00702112502126484,0.37016673094233,-0.6942660433124,
  -7.07286457145573e-05,0.00764493721895088,0.385312090249547,-0.724973987169469,
  -7.3095380762167e-05,0.00826874941663558,0.400457449556764,-0.755681931026538,
  -1.54075864325573e-05,-0.00665199721018116,0.0368755166188757,-0.0188148945336712,
  -1.75280170387065e-05,-0.00604892369816176,0.0517818705359336,-0.0496815720354004,
  -1.96484476449321e-05,-0.00544585018614246,0.0666882244529914,-0.0805482495371296,
  -2.17688782510328e-05,-0.00484277667412297,0.0815945783700494,-0.111414927038859,
  -2.3889308857189e-05,-0.00423970316210354,0.0965009322871072,-0.142281604540588,
  -2.60097394632897e-05,-0.00363662965008404,0.111407286204165,-0.173148282042317,
  -2.81301700693071e-05,-0.00303355613806455,0.126313640121223,-0.204014959544047,
  -3.02506006756298e-05,-0.00243048262604539,0.141219994038281,-0.234881637045776,
  -3.23710312818415e-05,-0.00182740911402601,0.156126347955339,-0.265748314547505,
  -3.44914618879977e-05,-0.00122433560200674,0.171032701872396,-0.296614992049234,
  -3.66118924940428e-05,-0.000621262089987029,0.185939055789454,-0.327481669550963,
  -3.87323231005321e-05,-1.81885779682034e-05,0.200845409706512,-0.358348347052693,
  -4.08527537067993e-05,0.000584884934051288,0.21575176362357,-0.389215024554422,
  -4.29731843128445e-05,0.00118795844607056,0.230658117540628,-0.420081702056151,
  -4.50936149192227e-05,0.00179103195808961,0.245564471457685,-0.450948379557881,
  -4.72140455248793e-05,0.00239410547010954,0.260470825374743,-0.48181505705961,
  -4.9334476131091e-05,0.00299717898212926,0.275377179291802,-0.512681734561339,
  -5.14549067375247e-05,0.00360025249414808,0.290283533208859,-0.543548412063068,
  -5.35753373431813e-05,0.00420332600616824,0.305189887125918,-0.574415089564797,
  -5.56957679497261e-05,0.00480639951818684,0.320096241042975,-0.605281767066527,
  -5.78161985562708e-05,0.00540947303020634,0.335002594960033,-0.636148444568256,
  -5.99366291622605e-05,0.00601254654222538,0.349908948877091,-0.667015122069985,
  -6.20570597681391e-05,0.00661562005424532,0.364815302794149,-0.697881799571714,
  -6.41774903740178e-05,0.00721869356626526,0.379721656711207,-0.728748477073443,
  -6.62979209800074e-05,0.0078217670782843,0.394628010628264,-0.759615154575173,
  -1.43181155143612e-05,-0.00659140106304036,0.0367609212111324,-0.018964640389785,
  -1.61550505929503e-05,-0.00601472995701616,0.0513757431305874,-0.0500236044138784,
  -1.79919856715394e-05,-0.00543805885099197,0.0659905650500425,-0.0810825684379719,
  -1.98289207502811e-05,-0.00486138774496792,0.0806053869694975,-0.112141532462065,
  -2.1665855828884e-05,-0.00428471663894381,0.0952202088889524,-0.143200496486159,
  -2.35027909075425e-05,-0.0037080455329197,0.109835030808407,-0.174259460510252,
  -2.53397259862287e-05,-0.00313137442689571,0.124449852727862,-0.205318424534346,
  -2.71766610647206e-05,-0.00255470332087127,0.139064674647318,-0.236377388558439,
  -2.90135961433236e-05,-0.00197803221484727,0.153679496566772,-0.267436352582533,
  -3.0850531222204e-05,-0.00140136110882327,0.168294318486227,-0.298495316606626,
  -3.2687466300918e-05,-0.000824690002799278,0.182909140405682,-0.329554280630719,
  -3.45244013796875e-05,-0.000248018896775504,0.197523962325137,-0.360613244654813,
  -3.63613364581794e-05,0.000328652209249158,0.212138784244593,-0.391672208678906,
  -3.81982715365048e-05,0.000905323315273376,0.226753606164047,-0.422731172703,
  -4.00352066155518e-05,0.00148199442129715,0.241368428083502,-0.453790136727093,
  -4.18721416935997e-05,0.00205866552732226,0.255983250002958,-0.484849100751187,
  -4.37090767724246e-05,0.00263533663334559,0.270598071922412,-0.51590806477528,
  -4.55460118512496e-05,0.00321200773937003,0.285212893841868,-0.546967028799374,
  -4.73829469300746e-05,0.00378867884539424,0.299827715761323,-0.578025992823467,
  -4.92198820079004e-05,0.00436534995141891,0.314442537680778,-0.60908495684756,
  -5.10568170869474e-05,0.00494202105744268,0.329057359600233,-0.640143920871654,
  -5.28937521658834e-05,0.00551869216346601,0.343672181519687,-0.671202884895747,
  -5.47306872443754e-05,0.00609536326949067,0.358287003439143,-0.702261848919841,
  -5.65676223228673e-05,0.00667203437551445,0.372901825358597,-0.733320812943934,
  -5.84045574021363e-05,0.00724870548153778,0.387516647278052,-0.764379776968028,
  -1.30291705836005e-05,-0.00652217453444938,0.0366255656968742,-0.0191387034144726,
  -1.45579484050751e-05,-0.00597795876668852,0.0508987517815769,-0.050421179290967,
  -1.60867262264802e-05,-0.00543374299892763,0.0651719378662797,-0.0817036551674614,
  -1.76155040479409e-05,-0.00488952723116676,0.0794451239509824,-0.112986131043956,
  -1.91442818693044e-05,-0.00434531146340589,0.0937183100356851,-0.14426860692045,
  -2.06730596907512e-05,-0.00380109569564491,0.107991496120388,-0.175551082796945,
  -2.22018375121702e-05,-0.00325687992788404,0.122264682205091,-0.206833558673439,
  -2.37306153336725e-05,-0.0027126641601235,0.136537868289793,-0.238116034549934,
  -2.52593931549527e-05,-0.00216844839236219,0.150811054374496,-0.269398510426428,
  -2.67881709765105e-05,-0.00162423262460143,0.165084240459199,-0.300680986302922,
  -2.83169487977908e-05,-0.00108001685684034,0.179357426543902,-0.331963462179417,
  -2.98457266190155e-05,-0.000535801089079246,0.193630612628604,-0.363245938055911,
  -3.13745044409064e-05,8.41467868095691e-06,0.207903798713307,-0.394528413932406,
  -3.29032822621311e-05,0.00055263044644227,0.22217698479801,-0.4258108898089,
  -3.44320600835779e-05,0.00109684621420314,0.236450170882713,-0.457093365685395,
  -3.59608379052467e-05,0.00164106198196357,0.250723356967415,-0.488375841561889,
  -3.74896157261384e-05,0.0021852777497251,0.264996543052118,-0.519658317438383,
  -3.90183935481403e-05,0.00272949351748553,0.279269729136821,-0.550940793314878,
  -4.05471713694761e-05,0.00327370928524617,0.293542915221523,-0.582223269191372,
  -4.20759491905898e-05,0.00381792505300815,0.307816101306227,-0.613505745067867,
  -4.36047270119255e-05,0.0043621408207688,0.322089287390929,-0.644788220944361,
  -4.51335048340384e-05,0.00490635658852812,0.336362473475631,-0.676070696820856,
  -4.66622826553742e-05,0.00545057235628965,0.350635659560334,-0.70735317269735,
  -4.81910604762659e-05,0.00599478812405119,0.364908845645038,-0.738635648573844,
  -4.97198382976016e-05,0.00653900389181183,0.37918203172974,-0.769918124450339,
  -1.1571773419268e-05,-0.00644698744831899,0.0364728765592646,-0.0193315834815309,
  -1.27872832081238e-05,-0.00594095685927656,0.0503640259712118,-0.0508617339066942,
  -1.40027929969727e-05,-0.00543492627023401,0.064255175383159,-0.0823918843318574,
  -1.52183027858632e-05,-0.00492889568119159,0.0781463247951061,-0.113922034757021,
  -1.64338125747676e-05,-0.00442286509214906,0.0920374742070534,-0.145452185182184,
  -1.76493223636442e-05,-0.00391683450310665,0.105928623619001,-0.176982335607347,
  -1.88648321524654e-05,-0.00341080391406423,0.119819773030948,-0.208512486032511,
  -2.0080341941342e-05,-0.00290477332502181,0.133710922442895,-0.240042636457674,
  -2.12958517299411e-05,-0.00239874273597895,0.147602071854842,-0.271572786882837,
  -2.25113615188732e-05,-0.00189271214693632,0.161493221266789,-0.303102937308,
  -2.37268713078054e-05,-0.00138668155789423,0.175384370678736,-0.334633087733164,
  -2.4942381096793e-05,-0.000880650968851926,0.189275520090683,-0.366163238158327,
  -2.61578908855586e-05,-0.000374620379809176,0.203166669502631,-0.39769338858349,
  -2.73734006746573e-05,0.000131410209233129,0.217057818914578,-0.429223539008653,
  -2.85889104632009e-05,0.000637440798275879,0.230948968326525,-0.460753689433817,
  -2.9804420252133e-05,0.00114347138731841,0.244840117738472,-0.49228383985898,
  -3.10199300408431e-05,0.00164950197636071,0.258731267150419,-0.523813990284143,
  -3.22354398297753e-05,0.00215553256540324,0.272622416562367,-0.555344140709307,
  -3.34509496190405e-05,0.00266156315444532,0.286513565974314,-0.58687429113447,
  -3.46664594077506e-05,0.00316759374348763,0.300404715386261,-0.618404441559633,
  -3.58819691965717e-05,0.00367362433253016,0.314295864798208,-0.649934591984797,
  -3.70974789849488e-05,0.00417965492157357,0.328187014210156,-0.68146474240996,
  -3.83129887741029e-05,0.00468568551061566,0.342078163622102,-0.712994892835123,
  -3.95284985629241e-05,0.00519171609965774,0.355969313034049,-0.744525043260286,
  -4.07440083520783e-05,0.00569774668869982,0.369860462445996,-0.77605519368545,
  -1.00059536845415e-05,-0.00636969301938656,0.0363093321376009,-0.019534309837596,
  -1.09259525469946e-05,-0.00590631936602409,0.0497950121854411,-0.0513247782909903,
  -1.18459514094615e-05,-0.00544294571266168,0.0632806922332813,-0.0831152467443846,
  -1.27659502718869e-05,-0.00497957205929911,0.0767663722811217,-0.114905715197779,
  -1.36859491342844e-05,-0.00451619840593664,0.0902520523289619,-0.146696183651173,
  -1.46059479967098e-05,-0.00405282475257407,0.103737732376802,-0.178486652104568,
  -1.55259468589963e-05,-0.00358945109921138,0.117223412424643,-0.210277120557962,
  -1.64459457215882e-05,-0.00312607744584914,0.130709092472483,-0.242067589011356,
  -1.7365944583958e-05,-0.00266270379248645,0.144194772520323,-0.273858057464751,
  -1.82859434463278e-05,-0.0021993301391241,0.157680452568163,-0.305648525918145,
  -1.92059423088642e-05,-0.00173595648576153,0.171166132616004,-0.337438994371539,
  -2.01259411712895e-05,-0.00127258283239917,0.184651812663844,-0.369229462824934,
  -2.10459400337148e-05,-0.000809209179036596,0.198137492711684,-0.401019931278328,
  -2.19659388960847e-05,-0.000345835525674243,0.211623172759524,-0.432810399731722,
  -2.28859377583435e-05,0.000117538127688555,0.225108852807365,-0.464600868185117,
  -2.38059366209908e-05,0.00058091178105113,0.238594532855205,-0.496391336638511,
  -2.47259354831941e-05,0.00104428543441371,0.252080212903045,-0.528181805091905,
  -2.56459343456195e-05,0.00150765908777606,0.265565892950885,-0.5599722735453,
  -2.65659332080448e-05,0.00197103274113841,0.279051572998726,-0.591762741998694,
  -2.74859320706922e-05,0.00243440639450099,0.292537253046566,-0.623553210452088,
  -2.84059309331175e-05,0.00289778004786356,0.306022933094406,-0.655343678905482,
  -2.93259297952098e-05,0.00336115370122636,0.319508613142247,-0.687134147358877,
  -3.02459286580792e-05,0.00382452735458827,0.332994293190087,-0.718924615812271,
  -3.11659275201714e-05,0.00428790100795151,0.346479973237928,-0.750715084265666,
  -3.20859263820417e-05,0.00475127466131431,0.359965653285768,-0.78250555271906,
  -8.41328971042804e-06,-0.00629460181127853,0.0361436069563478,-0.0197358841021053,
  -9.07577024131245e-06,-0.00587621167600946,0.0492221281791086,-0.0517851911993628,
  -9.73825077225932e-06,-0.00545782154074048,0.0623006494018693,-0.0838344982966202,
  -1.04007313031229e-05,-0.00503943140547136,0.0753791706246301,-0.115883805393878,
  -1.10632118339726e-05,-0.00462104127020224,0.0884576918473909,-0.147933112491135,
  -1.17256923649889e-05,-0.00420265113493334,0.101536213070152,-0.179982419588393,
  -1.23881728957831e-05,-0.003784260999664,0.114614734292913,-0.21203172668565,
  -1.30506534267161e-05,-0.00336587086439522,0.127693255515673,-0.244081033782908,
  -1.37131339577046e-05,-0.00294748072912598,0.140771776738434,-0.276130340880165,
  -1.4375614488582e-05,-0.00252909059385709,0.153850297961195,-0.308179647977422,
  -1.5038095019293e-05,-0.00211070045858786,0.166928819183955,-0.34022895507468,
  -1.57005755503925e-05,-0.00169231032331907,0.180007340406716,-0.372278262171937,
  -1.63630560812145e-05,-0.00127392018804984,0.193085861629477,-0.404327569269195,
  -1.70255366120364e-05,-0.000855530052780828,0.206164382852238,-0.436376876366452,
  -1.76880171428584e-05,-0.000437139917511375,0.219242904074999,-0.46842618346371,
  -1.83504976737359e-05,-1.87497822421445e-05,0.23232142529776,-0.500475490560967,
  -1.90129782047244e-05,0.000399640353026864,0.245399946520521,-0.532524797658224,
  -1.96754587356018e-05,0.000818030488295651,0.258478467743281,-0.564574104755482,
  -2.03379392664793e-05,0.00123642062356466,0.271556988966042,-0.596623411852739,
  -2.10004197976899e-05,0.00165481075883323,0.284635510188802,-0.628672718949997,
  -2.16629003289004e-05,0.00207320089410246,0.297714031411563,-0.660722026047254,
  -2.23253808592228e-05,0.00249159102937169,0.310792552634324,-0.692771333144512,
  -2.29878613902113e-05,0.00290998116464047,0.323871073857084,-0.724820640241769,
  -2.36503419210887e-05,0.0033283712999097,0.336949595079845,-0.756869947339027,
  -2.43128224518552e-05,0.00374676143517894,0.350028116302606,-0.788919254436284,
  -6.88102790130651e-06,-0.00622555647263549,0.0359848381938962,-0.0199255525963224,
  -7.33620228605958e-06,-0.00585183735802305,0.0486766125121778,-0.0522184103072765,
  -7.79137667081264e-06,-0.00547811824341055,0.0613683868304594,-0.0845112680182306,
  -8.24655105557959e-06,-0.00510439912879818,0.0740601611487409,-0.116804125729185,
  -8.70172544048531e-06,-0.00473068001418586,0.0867519354670224,-0.149096983440139,
  -9.15689982494694e-06,-0.00435696089957305,0.0994437097853041,-0.181389841151093,
  -9.61207420974164e-06,-0.00398324178496057,0.112135484103586,-0.213682698862047,
  -1.00672485945363e-05,-0.00360952267034831,0.124827258421867,-0.245975556573001,
  -1.05224229794421e-05,-0.00323580355573583,0.137519032740149,-0.278268414283955,
  -1.09775973639037e-05,-0.00286208444112312,0.15021080705843,-0.310561271994909,
  -1.14327717486429e-05,-0.00248836532651064,0.162902581376712,-0.342854129705864,
  -1.18879461337706e-05,-0.00211464621189883,0.175594355694993,-0.375146987416818,
  -1.23431205184543e-05,-0.00174092709728568,0.188286130013275,-0.407439845127772,
  -1.27982949030825e-05,-0.00136720798267342,0.200977904331557,-0.439732702838726,
  -1.32534692879327e-05,-0.000993488868061165,0.213669678649838,-0.47202556054968,
  -1.37086436725609e-05,-0.000619769753448685,0.22636145296812,-0.504318418260634,
  -1.41638180575221e-05,-0.000246050638836204,0.239053227286401,-0.536611275971588,
  -1.46189924420392e-05,0.000127668475776277,0.251745001604683,-0.568904133682543,
  -1.50741668264454e-05,0.000501387590389424,0.264436775922965,-0.601196991393496,
  -1.55293412116286e-05,0.00087510670500146,0.277128550241246,-0.633489849104451,
  -1.59845155963678e-05,0.0012488258196135,0.289820324559527,-0.665782706815405,
  -1.64396899813291e-05,0.00162254493422598,0.302512098877809,-0.698075564526359,
  -1.68948643654021e-05,0.00199626404883935,0.315203873196091,-0.730368422237313,
  -1.73500387500303e-05,0.00236998316345183,0.327895647514373,-0.762661279948267,
  -1.78052131355466e-05,0.00274370227806386,0.340587421832654,-0.794954137659221,
  -5.48380948876825e-06,-0.00616520542924962,0.035840695691782,-0.0200949746134528,
  -5.78409060808527e-06,-0.00583331493506042,0.0481840256868369,-0.0526053847250636,
  -6.08437172744392e-06,-0.00550142444087132,0.0605273556818919,-0.0851157948366744,
  -6.38465284680256e-06,-0.00516953394668218,0.0728706856769468,-0.117626204948285,
  -6.68493396607794e-06,-0.00483764345249293,0.0852140156720018,-0.150136615059896,
  -6.98521508551986e-06,-0.00450575295830391,0.0975573456670566,-0.182647025171507,
  -7.28549620487851e-06,-0.00417386246411477,0.109900675662112,-0.215157435283117,
  -7.58577732407062e-06,-0.00384197196992553,0.122244005657167,-0.247667845394728,
  -7.8860584435958e-06,-0.00351008147573639,0.134587335652221,-0.280178255506339,
  -8.18633956262138e-06,-0.00317819098154692,0.146930665647277,-0.31268866561795,
  -8.48662068242412e-06,-0.00284630048735846,0.159273995642331,-0.34519907572956,
  -8.78690180161623e-06,-0.0025144099931691,0.171617325637386,-0.377709485841171,
  -9.08718292080835e-06,-0.00218251949897974,0.183960655632441,-0.410219895952782,
  -9.38746404033353e-06,-0.0018506290047906,0.196303985627496,-0.442730306064393,
  -9.68774515963666e-06,-0.00151873851060169,0.208647315622551,-0.475240716176004,
  -9.98802627905082e-06,-0.00118684801641233,0.220990645617606,-0.507751126287614,
  -1.0288307398687e-05,-0.000854957522223643,0.233333975612661,-0.540261536399225,
  -1.0588588517213e-05,-0.000523067028033619,0.245677305607716,-0.572771946510836,
  -1.08888696364051e-05,-0.000191176533844262,0.258020635602771,-0.605282356622447,
  -1.11891507565964e-05,0.000140713960343763,0.270363965597825,-0.637792766734057,
  -1.14894318752334e-05,0.000472604454534231,0.282707295592881,-0.670303176845668,
  -1.17897129946476e-05,0.000804494948722922,0.295050625587936,-0.702813586957279,
  -1.20899941137287e-05,0.0011363854429125,0.307393955582991,-0.73532399706889,
  -1.23902752335869e-05,0.00146827593710119,0.319737285578046,-0.7678344071805,
  -1.2690556352668e-05,0.00180016643129033,0.3320806155731,-0.800344817292111,
  -4.27063925444865e-06,-0.0061147390656839,0.035716069660084,-0.0202394236739863,
  -4.46254755315234e-06,-0.0058199496928541,0.0477600945300585,-0.0529353187681507,
  -4.65445585189073e-06,-0.00552516032002431,0.059804119400033,-0.0856312138623151,
  -4.84636415046258e-06,-0.00523037094719436,0.0718481442700076,-0.11832710895648,
  -5.03827244932586e-06,-0.00493558157436491,0.0838921691399819,-0.151023004050644,
  -5.23018074807813e-06,-0.00464079220153513,0.0959361940099564,-0.183718899144808,
  -5.42208904669161e-06,-0.00434600282870512,0.107980218879931,-0.216414794238973,
  -5.61399734533286e-06,-0.00405121345587545,0.120024243749905,-0.249110689333137,
  -5.80590564419614e-06,-0.00375642408304577,0.13206826861988,-0.281806584427302,
  -5.99781394272636e-06,-0.00346163471021566,0.144112293489855,-0.314502479521466,
  -6.18972224153413e-06,-0.00316684533738609,0.156156318359829,-0.347198374615631,
  -6.38163054023089e-06,-0.00287205596455631,0.168200343229803,-0.379894269709795,
  -6.57353883909417e-06,-0.00257726659172652,0.180244368099778,-0.412590164803959,
  -6.7654471376799e-06,-0.00228247721889674,0.192288392969752,-0.445286059898124,
  -6.95735543632114e-06,-0.00198768784606673,0.204332417839727,-0.477981954992288,
  -7.14926373490687e-06,-0.00169289847323717,0.216376442709701,-0.510677850086453,
  -7.34117203382567e-06,-0.00139810910040739,0.228420467579676,-0.543373745180617,
  -7.53308033230038e-06,-0.00110331972757738,0.24046449244965,-0.576069640274782,
  -7.72498863088611e-06,-0.00080853035474715,0.252508517319625,-0.608765535368946,
  -7.91689692991593e-06,-0.00051374098191781,0.2645525421896,-0.64146143046311,
  -8.1088052287237e-06,-0.000218951609087803,0.276596567059574,-0.674157325557275,
  -8.30071352786454e-06,7.58377637408714e-05,0.288640591929548,-0.706853220651439,
  -8.49262182622823e-06,0.000370627136571322,0.300684616799523,-0.739549115745604,
  -8.68453012492498e-06,0.000665416509400885,0.312728641669497,-0.772245010839768,
  -8.87643842351071e-06,0.000960205882230447,0.324772666539471,-0.804940905933933,
  -3.26127385064101e-06,-0.00607407204136683,0.0356127777136462,-0.0203577695523877,
  -3.38133523655748e-06,-0.00581066736359478,0.047410060368674,-0.0532056309044808,
  -3.50139662258497e-06,-0.0055472626858229,0.0592073430237018,-0.0860534922565739,
  -3.62145800847369e-06,-0.00528385800805081,0.0710046256787297,-0.118901353608667,
  -3.74151939450118e-06,-0.00502045333027901,0.0828019083337574,-0.15174921496076,
  -3.86158078047316e-06,-0.00475704865250703,0.0945991909887852,-0.184597076312853,
  -3.98164216658392e-06,-0.00449364397473506,0.106396473643813,-0.217444937664946,
  -4.10170355236161e-06,-0.00423023929696287,0.118193756298841,-0.250292799017039,
  -4.22176493836135e-06,-0.00396683461919112,0.129991038953869,-0.283140660369132,
  -4.34182632458313e-06,-0.00370342994141937,0.141788321608896,-0.315988521721226,
  -4.46188771030531e-06,-0.00344002526364706,0.153585604263924,-0.348836383073319,
  -4.58194909613852e-06,-0.00317662058587498,0.165382886918952,-0.381684244425412,
  -4.70201048224927e-06,-0.00291321590810334,0.17718016957398,-0.414532105777505,
  -4.82207186824901e-06,-0.00264981123033148,0.188977452229008,-0.447379967129598,
  -4.94213325419324e-06,-0.00238640655255962,0.200774734884035,-0.480227828481691,
  -5.06219464035951e-06,-0.00212300187478731,0.212572017539064,-0.513075689833784,
  -5.18225602608169e-06,-0.00185959719701523,0.224369300194091,-0.545923551185877,
  -5.30231741202591e-06,-0.00159619251924314,0.236166582849119,-0.57877141253797,
  -5.42237879808116e-06,-0.00133278784147173,0.247963865504147,-0.611619273890063,
  -5.54244018413641e-06,-0.00106938316369964,0.259761148159174,-0.644467135242156,
  -5.66250157019166e-06,-0.000805978485928005,0.271558430814202,-0.677314996594249,
  -5.78256295591384e-06,-0.000542573808155922,0.28335571346923,-0.710162857946343,
  -5.90262434185806e-06,-0.000279169130383394,0.295152996124258,-0.743010719298436,
  -6.02268572802434e-06,-1.57644526121992e-05,0.306950278779285,-0.775858580650529,
  -6.14274711463469e-06,0.00024764022515944,0.318747561434313,-0.808706442002622,
  -2.45087047683751e-06,-0.00604226362942155,0.0355301195261492,-0.0204516039132621,
  -2.52519229645976e-06,-0.00580437669403822,0.0471307889492505,-0.0534199566325227,
  -2.59951411607506e-06,-0.00556648975865487,0.0587314583723518,-0.0863883093517833,
  -2.67383593569037e-06,-0.00532860282327163,0.070332127795453,-0.119356662071044,
  -2.74815775527792e-06,-0.00509071588788823,0.0819327972185543,-0.152325014790304,
  -2.82247957494874e-06,-0.00485282895250494,0.0935334666416556,-0.185293367509565,
  -2.8968013945363e-06,-0.00461494201712143,0.105134136064757,-0.218261720228826,
  -2.97112321406834e-06,-0.00437705508173825,0.116734805487858,-0.251230072948086,
  -3.04544503382242e-06,-0.00413916814635484,0.12833547491096,-0.284198425667347,
  -3.11976685340998e-06,-0.00390128121097155,0.139936144334061,-0.317166778386607,
  -3.1940886733306e-06,-0.00366339427558882,0.151536813757162,-0.350135131105868,
  -3.26841049264059e-06,-0.00342550734020497,0.163137483180263,-0.383103483825128,
  -3.34273231211712e-06,-0.00318762040482135,0.174738152603365,-0.416071836544389,
  -3.41705413203774e-06,-0.00294973346943861,0.186338822026466,-0.44904018926365,
  -3.49137595168081e-06,-0.00271184653405565,0.197939491449567,-0.48200854198291,
  -3.56569777093529e-06,-0.00247395959867136,0.209540160872669,-0.514976894702171,
  -3.64001959074489e-06,-0.00223607266328862,0.22114083029577,-0.547945247421431,
  -3.71434141055449e-06,-0.00199818572790567,0.232741499718871,-0.580913600140692,
  -3.78866322969795e-06,-0.0017602987925216,0.244342169141972,-0.613881952859953,
  -3.86298504917448e-06,-0.0015224118571382,0.255942838565074,-0.646850305579213,
  -3.93730686887306e-06,-0.00128452492175457,0.267543507988175,-0.679818658298474,
  -4.01162868846061e-06,-0.00104663798637139,0.279144177411276,-0.712787011017734,
  -4.0859505087143e-06,-0.000808751050989098,0.290744846834377,-0.745755363736995,
  -4.16027232774674e-06,-0.000570864115604586,0.302345516257479,-0.778723716456255,
  -4.23459414766736e-06,-0.00033297718022185,0.31394618568058,-0.811692069175516,
  -1.81862549927109e-06,-0.00601795638562291,0.0354658074895192,-0.0205240892539303,
  -1.86460256136611e-06,-0.00580016536697839,0.0469140059682884,-0.0535855193673919,
  -1.91057962349583e-06,-0.00558237434833397,0.0583622044470575,-0.0866469494808535,
  -1.95655668558392e-06,-0.00536458332968942,0.0698104029258267,-0.119708379594315,
  -2.00253374754711e-06,-0.00514679231104487,0.0812586014045958,-0.152769809707777,
  -2.04851080978785e-06,-0.0049290012924007,0.0927067998833647,-0.185831239821238,
  -2.09448787186206e-06,-0.00471121027375598,0.104154998362134,-0.2188926699347,
  -2.14046493379749e-06,-0.00449341925511126,0.115603196840903,-0.251954100048162,
  -2.18644199584395e-06,-0.00427562823646688,0.127051395319672,-0.285015530161623,
  -2.23241905800142e-06,-0.00405783721782238,0.138499593798441,-0.318076960275085,
  -2.27839612010339e-06,-0.00384004619917766,0.149947792277211,-0.351138390388546,
  -2.32437318237189e-06,-0.00362225518053361,0.16139599075598,-0.384199820502008,
  -2.3703502441963e-06,-0.00340446416188867,0.172844189234749,-0.41726125061547,
  -2.41632730607622e-06,-0.00318667314324395,0.184292387713518,-0.450322680728931,
  -2.4623043682892e-06,-0.00296888212459967,0.195740586192287,-0.483384110842393,
  -2.50828143033566e-06,-0.00275109110595495,0.207188784671057,-0.516445540955854,
  -2.55425849249313e-06,-0.00253330008731067,0.218636983149825,-0.549506971069316,
  -2.60023555465061e-06,-0.00231550906866618,0.230085181628595,-0.582568401182778,
  -2.64621261680809e-06,-0.00209771805002168,0.241533380107364,-0.615629831296239,
  -2.69218967896556e-06,-0.00187992703137763,0.252981578586132,-0.648691261409701,
  -2.73816674101202e-06,-0.00166213601273357,0.264429777064901,-0.681752691523162,
  -2.78414380283643e-06,-0.00144434499408774,0.275877975543671,-0.714814121636624,
  -2.83012086488288e-06,-0.00122655397544325,0.28732617402244,-0.747875551750085,
  -2.87609792704036e-06,-0.00100876295679919,0.298774372501209,-0.780936981863547,
  -2.92207498908681e-06,-0.00079097193815425,0.310222570979979,-0.813998411977009,
  -1.33633359245683e-06,-0.00599970816774084,0.0354168541279304,-0.0205789634026486,
  -1.36499175208693e-06,-0.00579735326426706,0.0467492838428647,-0.0537108566294048,
  -1.39364991171009e-06,-0.00559499836079336,0.0580817135577988,-0.086842749856161,
  -1.42230807126387e-06,-0.00539264345731943,0.0694141432727331,-0.119974643082917,
  -1.45096623083152e-06,-0.00519028855384562,0.0807465729876673,-0.153106536309673,
  -1.47962439062121e-06,-0.00498793365037198,0.0920790027026015,-0.186238429536429,
  -1.50828255024438e-06,-0.00478557874689822,0.103411432417536,-0.219370322763186,
  -1.53694070975652e-06,-0.00458322384342436,0.11474386213247,-0.252502215989942,
  -1.56559886943519e-06,-0.00438086893995082,0.126076291847404,-0.285634109216698,
  -1.59425702916938e-06,-0.00417851403647718,0.137408721562338,-0.318766002443454,
  -1.62291518851498e-06,-0.00397615913300275,0.148741151277273,-0.35189789567021,
  -1.65157334813815e-06,-0.003773804229529,0.160073580992207,-0.385029788896967,
  -1.68023150809438e-06,-0.00357144932605591,0.171406010707141,-0.418161682123723,
  -1.70888966771754e-06,-0.00336909442258215,0.182738440422075,-0.451293575350479,
  -1.73754782695212e-06,-0.00316673951910751,0.19407087013701,-0.484425468577235,
  -1.76620598690835e-06,-0.00296438461563442,0.205403299851943,-0.517557361803991,
  -1.79486414642049e-06,-0.00276202971216022,0.216735729566878,-0.550689255030747,
  -1.82352230582161e-06,-0.00255967480868646,0.228068159281812,-0.583821148257504,
  -1.85218046566682e-06,-0.00235731990521293,0.239400588996746,-0.61695304148426,
  -1.88083862528998e-06,-0.0021549650017394,0.25073301871168,-0.650084934711016,
  -1.90949678435803e-06,-0.00195261009826453,0.262065448426615,-0.683216827937772,
  -1.93815494420324e-06,-0.001750255194791,0.273397878141549,-0.716348721164528,
  -1.96681310438152e-06,-0.00154790029131835,0.284730307856482,-0.749480614391284,
  -1.99547126378263e-06,-0.00134554538784393,0.296062737571417,-0.78261250761804,
  -2.02412942296171e-06,-0.00114319048436951,0.307395167286352,-0.815744400844796,
  -9.74699892214437e-07,-0.00598618968932808,0.0353802086763759,-0.0206198733992233,
  -9.92805531535579e-07,-0.00579546775011153,0.0466261379683687,-0.053804298570271,
  -1.01091117085672e-06,-0.00560474581089498,0.0578720672603616,-0.0869887237413188,
  -1.02901681015011e-06,-0.00541402387167855,0.0691179965523542,-0.120173148912367,
  -1.04712244972105e-06,-0.00522330193246223,0.0803639258443471,-0.153357574083414,
  -1.06522808898668e-06,-0.00503257999324558,0.09160985513634,-0.186541999254462,
  -1.08333372811353e-06,-0.00484185805402892,0.102855784428333,-0.21972642442551,
  -1.1014393675457e-06,-0.00465113611481238,0.114101713720326,-0.252910849596558,
  -1.11954500703337e-06,-0.00446041417559606,0.125347643012318,-0.286095274767605,
  -1.13765064613247e-06,-0.00426969223637919,0.136593572304311,-0.319279699938653,
  -1.15575628562015e-06,-0.00407897029716286,0.147839501596304,-0.352464125109701,
  -1.17386192505231e-06,-0.00388824835794654,0.159085430888297,-0.385648550280748,
  -1.19196756442896e-06,-0.00369752641873,0.17033136018029,-0.418832975451796,
  -1.21007320358357e-06,-0.00350680447951301,0.181577289472283,-0.452017400622844,
  -1.22817884296023e-06,-0.00331608254029714,0.192823218764275,-0.485201825793892,
  -1.24628448239239e-06,-0.0031253606010806,0.204069148056268,-0.518386250964939,
  -1.26439012182455e-06,-0.00293463866186405,0.215315077348261,-0.551570676135987,
  -1.28249576081263e-06,-0.00274391672264684,0.226561006640254,-0.584755101307035,
  -1.30060140013377e-06,-0.00255319478343052,0.237806935932247,-0.617939526478083,
  -1.31870703978798e-06,-0.0023624728442142,0.249052865224239,-0.65112395164913,
  -1.3368126789981e-06,-0.00217175090499744,0.260298794516233,-0.684308376820178,
  -1.35491831887435e-06,-0.00198102896578201,0.271544723808225,-0.717492801991226,
  -1.37302395775141e-06,-0.0017903070265648,0.282790653100218,-0.750677227162274,
  -1.39112959696153e-06,-0.00159958508734803,0.294036582392211,-0.783861652333322,
  -1.40923523650471e-06,-0.00140886314813216,0.305282511684203,-0.817046077504369,
  -7.07019120936569e-07,-0.00597627311205831,0.0353531178182547,-0.020650025616694,
  -7.18653093340071e-07,-0.00579419347460122,0.046535188019078,-0.0538731688210115,
  -7.30287065708879e-07,-0.00561211383714416,0.0577172582199012,-0.087096312025329,
  -7.41921038188709e-07,-0.00543003419968724,0.0688993284207244,-0.120319455229646,
  -7.53555010474249e-07,-0.00524795456223004,0.0800813986215478,-0.153542598433964,
  -7.65188982898568e-07,-0.00506587492477284,0.0912634688223712,-0.186765741638281,
  -7.76822955184109e-07,-0.00488379528731564,0.102445539023195,-0.219988884842599,
  -7.88456927747205e-07,-0.004701715649859,0.113627609224017,-0.253212028046916,
  -8.00090900254791e-07,-0.00451963601240191,0.124809679424841,-0.286435171251234,
  -8.11724872318287e-07,-0.00433755637494437,0.135991749625664,-0.319658314455551,
  -8.23358844936894e-07,-0.00415547673748762,0.147173819826487,-0.352881457659869,
  -8.34992817166924e-07,-0.0039733971000302,0.158355890027311,-0.386104600864186,
  -8.46626789563487e-07,-0.00379131746257366,0.169537960228134,-0.419327744068504,
  -8.5826076196005e-07,-0.00360923782511624,0.180720030428957,-0.452550887272821,
  -8.69894734578658e-07,-0.00342715818765971,0.19190210062978,-0.485774030477138,
  -8.81528706586643e-07,-0.00324507855020184,0.203084170830604,-0.518997173681456,
  -8.93162679482806e-07,-0.00306299891274575,0.214266241031427,-0.552220316885773,
  -9.04796651823858e-07,-0.00288091927528811,0.225448311232251,-0.585443460090091,
  -9.1643062416491e-07,-0.00269883963783113,0.236630381433074,-0.618666603294408,
  -9.28064596728007e-07,-0.0025167600003746,0.247812451633897,-0.651889746498726,
  -9.39698568624969e-07,-0.00233468036291651,0.25899452183472,-0.685112889703043,
  -9.51332541521133e-07,-0.00215260072546064,0.270176592035543,-0.718336032907361,
  -9.62966513307073e-07,-0.00197052108800255,0.281358662236367,-0.751559176111678,
  -9.7460048587017e-07,-0.00178844145054535,0.29254073243719,-0.784782319315996,
  -9.86234458433266e-07,-0.0016063618130886,0.303722802638013,-0.818005462520313,
  -5.10771194582593e-07,-0.00596905098598514,0.0353332749568421,-0.0206720619399733,
  -5.18382780284599e-07,-0.00579332416002917,0.0464686182828356,-0.0539235016733503,
  -5.25994366035176e-07,-0.00561759733407313,0.0576039616088292,-0.0871749414067273,
  -5.33605951730243e-07,-0.00544187050811712,0.0687393049348227,-0.120426381140104,
  -5.41217537508576e-07,-0.00526614368216127,0.0798746482608161,-0.153677820873481,
  -5.48829123175887e-07,-0.00509041685620526,0.0910099915868096,-0.186929260606858,
  -5.56440708843198e-07,-0.00491469003024925,0.102145334912803,-0.220180700340235,
  -5.64052294704798e-07,-0.00473896320429334,0.113280678238797,-0.253432140073612,
  -5.71663880344353e-07,-0.00456323637833722,0.12441602156479,-0.286683579806989,
  -5.79275466372486e-07,-0.00438750955238154,0.135551364890784,-0.319935019540366,
  -5.86887051956531e-07,-0.00421178272642542,0.146686708216777,-0.353186459273743,
  -5.94498637762619e-07,-0.00403605590046952,0.157822051542771,-0.38643789900712,
  -6.02110223402175e-07,-0.00386032907451361,0.168957394868764,-0.419689338740497,
  -6.09721808986219e-07,-0.00368460224855727,0.180092738194758,-0.452940778473874,
  -6.17333395069863e-07,-0.00350887542260159,0.191228081520751,-0.486192218207251,
  -6.24944980653908e-07,-0.00333314859664569,0.202363424846745,-0.519443657940628,
  -6.32556566015907e-07,-0.00315742177068934,0.213498768172738,-0.552695097674005,
  -6.40168151933018e-07,-0.00298169494473344,0.224634111498732,-0.585946537407382,
  -6.47779737850129e-07,-0.00280596811877798,0.235769454824725,-0.619197977140759,
  -6.55391323656218e-07,-0.00263024129282163,0.246904798150719,-0.652449416874136,
  -6.6300290912924e-07,-0.00245451446686529,0.258040141476712,-0.685700856607513,
  -6.70614495046351e-07,-0.00227878764090983,0.269175484802705,-0.71895229634089,
  -6.78226080741418e-07,-0.00210306081495348,0.280310828128699,-0.752203736074267,
  -6.85837666991596e-07,-0.00192733398899891,0.291446171454692,-0.785455175807644,
  -6.93449252020528e-07,-0.00175160716304168,0.302581514780686,-0.818706615541021,
  -2.3594827396542e-05,-0.00705454434582081,0.0486493044125134,-0.0315387942280043,
  -2.68564869033844e-05,-0.00637817687214226,0.064317667428829,-0.0610266075605757,
  -3.01181464102129e-05,-0.0057018093984636,0.0799860304451446,-0.0905144208931471,
  -3.33798059170554e-05,-0.00502544192478505,0.0956543934614602,-0.120002234225719,
  -3.66414654238423e-05,-0.00434907445110644,0.111322756477776,-0.14949004755829,
  -3.99031249307125e-05,-0.00367270697742805,0.126991119494091,-0.178977860890861,
  -4.31647844377214e-05,-0.00299633950374956,0.142659482510407,-0.208465674223433,
  -4.64264439441475e-05,-0.00231997203007028,0.158327845526723,-0.237953487556004,
  -4.96881034511287e-05,-0.00164360455639201,0.173996208543038,-0.267441300888576,
  -5.29497629578324e-05,-0.000967237082713179,0.189664571559354,-0.296929114221147,
  -5.62114224648136e-05,-0.000290869609034905,0.205332934575669,-0.326416927553718,
  -5.94730819714617e-05,0.000385497864644035,0.221001297591985,-0.35590474088629,
  -6.27347414784429e-05,0.00106186533832275,0.236669660608301,-0.385392554218861,
  -6.59964009854797e-05,0.00173823281200103,0.252338023624616,-0.414880367551433,
  -6.92580604920723e-05,0.0024146002856793,0.268006386640931,-0.444368180884004,
  -7.2519719998887e-05,0.00309096775935847,0.283674749657248,-0.473855994216575,
  -7.57813795057016e-05,0.00376733523303674,0.299343112673563,-0.503343807549147,
  -7.90430390124053e-05,0.00444370270671568,0.315011475689879,-0.532831620881718,
  -8.2304698519664e-05,0.00512007018039395,0.330679838706194,-0.562319434214289,
  -8.55663580264787e-05,0.00579643765407201,0.346348201722509,-0.591807247546861,
  -8.88280175330713e-05,0.00647280512775117,0.362016564738825,-0.621295060879432,
  -9.20896770408852e-05,0.00714917260142833,0.37768492775514,-0.650782874212004,
  -9.53513365472558e-05,0.00782554007510772,0.393353290771456,-0.680270687544575,
  -9.86129960536264e-05,0.0085019075487871,0.409021653787772,-0.709758500877147,
  -0.000101874655560996,0.00917827502246471,0.424690016804087,-0.739246314209718,
  -2.34812631053904e-05,-0.00704650783120872,0.0486309746561106,-0.0315599217145,
  -2.67125954673958e-05,-0.00637192841193729,0.0642744317962176,-0.0610647100786468,
  -2.99439278295122e-05,-0.005697348992666,0.0799178889363246,-0.0905694984427936,
  -3.31752601916702e-05,-0.00502276957339476,0.0955613460764316,-0.12007428680694,
  -3.64065925536339e-05,-0.00434819015412335,0.111204803216539,-0.149579075171087,
  -3.96379249158196e-05,-0.00367361073485217,0.126848260356646,-0.179083863535234,
  -4.28692572778666e-05,-0.00299903131558077,0.142491717496753,-0.208588651899381,
  -4.61005896399969e-05,-0.00232445189630948,0.15813517463686,-0.238093440263528,
  -4.93319220020161e-05,-0.00164987247703818,0.173778631776967,-0.267598228627674,
  -5.25632543642574e-05,-0.000975293057767113,0.189422088917073,-0.297103016991821,
  -5.57945867262211e-05,-0.000300713638495598,0.20506554605718,-0.326607805355968,
  -5.90259190882958e-05,0.000373865780775695,0.220709003197287,-0.356112593720115,
  -6.2257251450315e-05,0.00104844520004699,0.236352460337394,-0.385617382084262,
  -6.54885838127783e-05,0.00172302461931828,0.251995917477501,-0.415122170448408,
  -6.8719916174742e-05,0.00239760403858935,0.267639374617608,-0.444626958812555,
  -7.19512485368723e-05,0.00307218345786087,0.283282831757715,-0.474131747176702,
  -7.51825808991136e-05,0.00374676287713172,0.298926288897822,-0.503636535540849,
  -7.84139132605777e-05,0.0044213422964039,0.314569746037929,-0.533141323904996,
  -8.1645245623152e-05,0.0050959217156743,0.330213203178036,-0.562646112269143,
  -8.48765779852823e-05,0.00577050113494537,0.345856660318143,-0.592150900633289,
  -8.81079103470794e-05,0.00644508055421777,0.36150011745825,-0.621655688997436,
  -9.13392427094317e-05,0.00711965997348862,0.377143574598357,-0.651160477361583,
  -9.45705750711179e-05,0.00779423939276036,0.392787031738464,-0.68066526572573,
  -9.78019074331371e-05,0.00846881881203165,0.408430488878571,-0.710170054089877,
  -0.000101033239795378,0.00914339823130295,0.424073946018678,-0.739674842454023,
  -2.33242024943875e-05,-0.00703542873146884,0.0486056233416017,-0.0315891012240339,
  -2.65138259760017e-05,-0.00636333698488284,0.0642146538181516,-0.0611173340758056,
  -2.9703449457491e-05,-0.00569124523829678,0.0798236842947014,-0.0906455669275773,
  -3.28930729389665e-05,-0.00501915349171067,0.0954327147712512,-0.120173799779349,
  -3.6082696420553e-05,-0.00434706174512456,0.111041745247801,-0.149702032631121,
  -3.92723199020839e-05,-0.00367496999853845,0.126650775724351,-0.179230265482893,
  -4.24619433836981e-05,-0.00300287825195245,0.142259806200901,-0.208758498334664,
  -4.56515668652568e-05,-0.00233078650536656,0.157868836677451,-0.238286731186436,
  -4.88411903468156e-05,-0.00165869475878044,0.173477867154,-0.267814964038208,
  -5.20308138280967e-05,-0.000986603012194109,0.18908689763055,-0.29734319688998,
  -5.52204373099885e-05,-0.000314511265608441,0.2046959281071,-0.326871429741751,
  -5.84100607911031e-05,0.000357580480977893,0.22030495858365,-0.356399662593523,
  -6.15996842726618e-05,0.001029672227564,0.2359139890602,-0.385927895445295,
  -6.47893077543316e-05,0.00170176397414989,0.251523019536749,-0.415456128297067,
  -6.79789312355572e-05,0.00237385572073623,0.267132050013299,-0.444984361148838,
  -7.11685547172269e-05,0.00304594746732256,0.282741080489849,-0.47451259400061,
  -7.43581781992297e-05,0.00371803921390756,0.298350110966399,-0.504040826852382,
  -7.75478016801223e-05,0.00439013096049479,0.313959141442949,-0.533569059704153,
  -8.07374251622361e-05,0.00506222270707957,0.329568171919498,-0.563097292555925,
  -8.39270486433508e-05,0.00573431445366679,0.345177202396049,-0.592625525407697,
  -8.71166721247985e-05,0.00640640620025268,0.360786232872598,-0.622153758259469,
  -9.03062956064682e-05,0.00707849794683879,0.376395263349148,-0.65168199111124,
  -9.34959190880269e-05,0.00775058969342446,0.392004293825698,-0.681210223963012,
  -9.66855425695856e-05,0.00842268144001057,0.407613324302248,-0.710738456814784,
  -9.98751660515884e-05,0.00909477318659624,0.423222354778797,-0.740266689666556,
  -2.31079586765909e-05,-0.0070202419677704,0.0485707173301202,-0.0316292002757349,
  -2.62406007479898e-05,-0.00635160320840189,0.0641323835871722,-0.0611896510001301,
  -2.93732428194304e-05,-0.00568296444903343,0.0796940498442241,-0.0907501017245252,
  -3.25058848908155e-05,-0.00501432568966498,0.095255716101276,-0.12031055244892,
  -3.56385269622006e-05,-0.00434568693029658,0.110817382358328,-0.149871003173316,
  -3.87711690336134e-05,-0.00367704817092807,0.12637904861538,-0.179431453897711,
  -4.19038111050818e-05,-0.00300840941155966,0.141940714872432,-0.208991904622106,
  -4.50364531765501e-05,-0.00233977065219126,0.157502381129484,-0.238552355346501,
  -4.81690952476854e-05,-0.00167113189282242,0.173064047386536,-0.268112806070896,
  -5.13017373190428e-05,-0.0010024931334538,0.188625713643588,-0.297673256795292,
  -5.44343793907331e-05,-0.000333854374085396,0.20418737990064,-0.327233707519687,
  -5.7567021462035e-05,0.000334784385282783,0.219749046157691,-0.356794158244082,
  -6.06996635333368e-05,0.00100342314465141,0.235310712414743,-0.386354608968477,
  -6.38323056050272e-05,0.00167206190401981,0.250872378671795,-0.415915059692872,
  -6.6964947676218e-05,0.00234070066338865,0.266434044928848,-0.445475510417267,
  -7.00975897474088e-05,0.00300933942275705,0.281995711185899,-0.475035961141662,
  -7.32302318189326e-05,0.00367797818212545,0.297557377442951,-0.504596411866058,
  -7.63628738903455e-05,0.00434661694149385,0.313119043700003,-0.534156862590453,
  -7.94955159619803e-05,0.00501525570086181,0.328680709957055,-0.563717313314848,
  -8.26281580331711e-05,0.00568389446023065,0.344242376214107,-0.593277764039243,
  -8.57608001043619e-05,0.00635253321959972,0.359804042471159,-0.622838214763638,
  -8.88934421763299e-05,0.00702117197896701,0.37536570872821,-0.652398665488033,
  -9.20260842477427e-05,0.00768981073833608,0.390927374985263,-0.681959116212428,
  -9.51587263186005e-05,0.0083584494977047,0.406489041242314,-0.711519566936824,
  -9.82913683905684e-05,0.00902708825707288,0.422050707499366,-0.741080017661219,
  -2.28120629598982e-05,-0.00699958663889538,0.0485229508093914,-0.0316839277490385,
  -2.58675684358667e-05,-0.00633572478445732,0.0640198723657723,-0.0612883496570178,
  -2.89230739119184e-05,-0.00567186293001926,0.0795167939221532,-0.090892771564997,
  -3.19785793877758e-05,-0.00500800107558119,0.095013715478534,-0.120497193472976,
  -3.50340848636888e-05,-0.00434413922114296,0.110510637034915,-0.150101615380956,
  -3.80895903398237e-05,-0.00368027736670518,0.126007558591296,-0.179706037288935,
  -4.11450958155424e-05,-0.00301641551226661,0.141504480147677,-0.209310459196914,
  -4.42006012915663e-05,-0.00235255365782872,0.157001401704058,-0.238914881104894,
  -4.72561067673682e-05,-0.00168869180339037,0.172498323260439,-0.268519303012873,
  -5.03116122435587e-05,-0.00102482994895259,0.18799524481682,-0.298123724920852,
  -5.33671177194717e-05,-0.000360968094514469,0.2034921663732,-0.327728146828831,
  -5.64226231957732e-05,0.000302893759923206,0.218989087929581,-0.357332568736811,
  -5.94781286712975e-05,0.000966755614361547,0.234486009485962,-0.38693699064479,
  -6.25336341470439e-05,0.00163061746880033,0.249982931042344,-0.416541412552769,
  -6.55891396231789e-05,0.00229447932323823,0.265479852598724,-0.446145834460749,
  -6.86446450990363e-05,0.00295834117767635,0.280976774155105,-0.475750256368728,
  -7.17001505750048e-05,0.00362220303211402,0.296473695711486,-0.505354678276707,
  -7.47556560505291e-05,0.00428606488655325,0.311970617267867,-0.534959100184686,
  -7.78111615270527e-05,0.0049499267409896,0.327467538824247,-0.564563522092666,
  -8.08666670026881e-05,0.00561378859542883,0.342964460380629,-0.594167944000645,
  -8.39221724785455e-05,0.00627765044986672,0.358461381937009,-0.623772365908625,
  -8.6977677954736e-05,0.00694151230430462,0.37395830349339,-0.653376787816603,
  -9.00331834308155e-05,0.00760537415874252,0.389455225049771,-0.682981209724583,
  -9.30886889062288e-05,0.00826923601318086,0.404952146606152,-0.712585631632562,
  -9.61441943824193e-05,0.0089330978676192,0.420449068162533,-0.742190053540541,
  -2.24105788531326e-05,-0.006971790591252,0.0484581343463593,-0.031757923720823,
  -2.5362961627709e-05,-0.00631450546007623,0.0638673292162421,-0.0614217982266187,
  -2.83153444023687e-05,-0.00565722032890054,0.079276524086125,-0.0910856727324144,
  -3.12677271770423e-05,-0.00499993519772485,0.0946857189560079,-0.12074954723821,
  -3.42201099516048e-05,-0.0043426500665491,0.110094913825891,-0.150413421744006,
  -3.71724927262507e-05,-0.00368536493537353,0.125504108695773,-0.180077296249801,
  -4.01248755009243e-05,-0.00302807980419784,0.140913303565656,-0.209741170755597,
  -4.30772582755701e-05,-0.00237079467302193,0.156322498435539,-0.239405045261393,
  -4.60296410502159e-05,-0.00171350954184635,0.171731693305422,-0.269068919767189,
  -4.89820238249727e-05,-0.00105622441067066,0.187140888175305,-0.298732794272984,
  -5.1934406599341e-05,-0.000398939279494748,0.202550083045188,-0.32839666877878,
  -5.48867893742644e-05,0.000258345851680497,0.217959277915071,-0.358060543284576,
  -5.78391721481886e-05,0.000915630982857296,0.233368472784954,-0.387724417790371,
  -6.07915549233895e-05,0.0015729161140321,0.248777667654836,-0.417388292296167,
  -6.37439376979243e-05,0.00223020124520801,0.264186862524719,-0.447052166801963,
  -6.66963204726256e-05,0.0028874863763837,0.279596057394602,-0.476716041307758,
  -6.96487032471049e-05,0.00354477150755916,0.295005252264485,-0.506379915813554,
  -7.26010860216952e-05,0.00420205663873552,0.310414447134368,-0.53604379031935,
  -7.55534687965076e-05,0.00485934176991054,0.32582364200425,-0.565707664825145,
  -7.85058515710979e-05,0.00551662690108645,0.341232836874134,-0.595371539330941,
  -8.14582343454662e-05,0.00617391203226303,0.356642031744017,-0.625035413836737,
  -8.44106171206116e-05,0.00683119716343805,0.3720512266139,-0.654699288342532,
  -8.73629998947578e-05,0.00748848229461441,0.387460421483782,-0.684363162848328,
  -9.03153826692371e-05,0.00814576742578987,0.402869616353665,-0.714027037354124,
  -9.32677654439384e-05,0.00880305255696578,0.418278811223548,-0.74369091185992,
  -2.18720218072843e-05,-0.00693491643490615,0.048371182282186,-0.0318567150175,
  -2.46888569472026e-05,-0.00628662334124291,0.0636629196819949,-0.061599964103931,
  -2.75056920869543e-05,-0.00563833024757943,0.0789546570818039,-0.0913432131903619,
  -3.03225272269003e-05,-0.00499003715391622,0.0942463944816127,-0.121086462276793,
  -3.31393623668741e-05,-0.00434174406025301,0.109538131881422,-0.150829711363224,
  -3.59561975066258e-05,-0.00369345096658957,0.124829869281231,-0.180572960449655,
  -3.87730326464886e-05,-0.00304515787292625,0.140121606681039,-0.210316209536086,
  -4.15898677863513e-05,-0.00239686477926304,0.155413344080848,-0.240059458622517,
  -4.44067029262141e-05,-0.00174857168559961,0.170705081480657,-0.269802707708948,
  -4.72235380659103e-05,-0.00110027859193629,0.185996818880466,-0.299545956795379,
  -5.0040373205773e-05,-0.000451985498272744,0.201288556280275,-0.32928920588181,
  -5.28572083459689e-05,0.000196307595390133,0.216580293680084,-0.35903245496824,
  -5.56740434858316e-05,0.000844600689053454,0.231872031079893,-0.388775704054671,
  -5.84908786257499e-05,0.00149289378271678,0.247163768479702,-0.418518953141103,
  -6.1307713765113e-05,0.00214118687638054,0.262455505879511,-0.448262202227533,
  -6.41245489049203e-05,0.00278947997004364,0.277747243279319,-0.478005451313964,
  -6.69413840450606e-05,0.00343777306370718,0.293038980679128,-0.507748700400395,
  -6.97582191853119e-05,0.00408606615736962,0.308330718078937,-0.537491949486826,
  -7.25750543248971e-05,0.00473435925103383,0.323622455478746,-0.567235198573257,
  -7.53918894643713e-05,0.00538265234469737,0.338914192878555,-0.596978447659688,
  -7.82087246042895e-05,0.00603094543836047,0.354205930278364,-0.626721696746119,
  -8.10255597444298e-05,0.00667923853202401,0.369497667678173,-0.65646494583255,
  -8.38423948844591e-05,0.00732753162568622,0.384789405077981,-0.686208194918981,
  -8.66592300241553e-05,0.00797582471934977,0.40008114247779,-0.715951444005412,
  -8.94760651637405e-05,0.00862411781301375,0.415372879877599,-0.745694693091843,
  -2.11605704003165e-05,-0.00688691882449444,0.0482563103433187,-0.0319864067548445,
  -2.38032287121076e-05,-0.00625079780245241,0.0633932707791616,-0.0618338576040809,
  -2.64458870239959e-05,-0.00561467678041044,0.0785302312150046,-0.0916813084533172,
  -2.90885453357592e-05,-0.00497855575836831,0.0936671916508476,-0.121528759302554,
  -3.17312036477446e-05,-0.00434243473632645,0.108804152086691,-0.15137621015179,
  -3.43738619594247e-05,-0.0037063137142842,0.123941112522534,-0.181223661001026,
  -3.70165202714379e-05,-0.00307019269224251,0.139078072958376,-0.211071111850263,
  -3.96591785830069e-05,-0.00243407167019993,0.15421503339422,-0.240918562699499,
  -4.2301836894687e-05,-0.00179795064815769,0.169351993830063,-0.270766013548735,
  -4.49444952065892e-05,-0.001161829626116,0.184488954265906,-0.300613464397972,
  -4.75871535181582e-05,-0.000525708604073527,0.199625914701749,-0.330460915247208,
  -5.02298118300604e-05,0.000110412417968719,0.214762875137592,-0.360308366096445,
  -5.28724701421845e-05,0.000746533440010078,0.229899835573435,-0.390155816945681,
  -5.55151284538091e-05,0.00138265446205232,0.245036796009278,-0.420003267794917,
  -5.81577867655447e-05,0.00201877548409479,0.260173756445121,-0.449850718644154,
  -6.08004450773914e-05,0.00265489650613682,0.275310716880964,-0.47969816949339,
  -6.3443103389238e-05,0.00329101752817884,0.290447677316807,-0.509545620342626,
  -6.60857617013066e-05,0.00392713855022042,0.30558463775265,-0.539393071191863,
  -6.87284200131533e-05,0.00456325957226245,0.320721598188493,-0.569240522041099,
  -7.13710783248889e-05,0.00519938059430447,0.335858558624336,-0.599087972890335,
  -7.40137366366245e-05,0.00583550161634649,0.350995519060179,-0.628935423739572,
  -7.66563949483601e-05,0.00647162263838874,0.366132479496021,-0.658782874588808,
  -7.92990532606508e-05,0.00710774366043054,0.381269439931865,-0.688630325438044,
  -8.19417115720533e-05,0.00774386468247323,0.396406400367708,-0.718477776287281,
  -8.45843698838999e-05,0.00837998570451504,0.411543360803551,-0.748325227136517,
  -2.02394967061814e-05,-0.00682596698169216,0.0481075954312107,-0.0321529493709036,
  -2.26649154918684e-05,-0.00620608901611291,0.0630448336788449,-0.0621342100875296,
  -2.50903342774722e-05,-0.00558621105053364,0.0779820719264791,-0.0921154708041555,
  -2.75157530631731e-05,-0.00496633308495431,0.0929193101741135,-0.122096731520781,
  -2.99411718487907e-05,-0.00434645511937515,0.107856548421748,-0.152077992237407,
  -3.23665906344639e-05,-0.00372657715379576,0.122793786669382,-0.182059252954033,
  -3.47920094202481e-05,-0.00310669918821671,0.137731024917016,-0.212040513670659,
  -3.72174282060045e-05,-0.00248682122263744,0.15266826316465,-0.242021774387285,
  -3.96428469915389e-05,-0.00186694325705816,0.167605501412285,-0.272003035103911,
  -4.20682657774063e-05,-0.00124706529147911,0.182542739659919,-0.301984295820537,
  -4.44936845627186e-05,-0.000627187325899392,0.197479977907553,-0.331965556537163,
  -4.69191033486416e-05,-7.30936032056206e-06,0.212417216155187,-0.361946817253789,
  -4.9344522134287e-05,0.000612568605259156,0.227354454402822,-0.391928077970415,
  -5.17699409202099e-05,0.00123244657083754,0.242291692650455,-0.421909338687041,
  -5.41953597058553e-05,0.00185232453641726,0.25722893089809,-0.451890599403667,
  -5.66207784917783e-05,0.00247220250199587,0.272166169145724,-0.481871860120293,
  -5.90461972770351e-05,0.00309208046757603,0.287103407393359,-0.511853120836919,
  -6.1471616062625e-05,0.0037119584331553,0.302040645640993,-0.541834381553544,
  -6.38970348481038e-05,0.00433183639873458,0.316977883888627,-0.57181564227017,
  -6.63224536343598e-05,0.00495171436431319,0.331915122136261,-0.601796902986796,
  -6.87478724200608e-05,0.00557159232989202,0.346852360383895,-0.631778163703422,
  -7.11732912055396e-05,0.00619147029547173,0.361789598631529,-0.661759424420048,
  -7.35987099907964e-05,0.0068113482610519,0.376726836879164,-0.691740685136674,
  -7.60241287766084e-05,0.00743122622663073,0.391664075126798,-0.7217219458533,
  -7.84495475628644e-05,0.00805110419220867,0.406601313374432,-0.751703206569926,
  -1.90777036821049e-05,-0.0067509566582728,0.0479200436444593,-0.0323608586104601,
  -2.12423877882506e-05,-0.00615232382186409,0.0626064265192182,-0.0625091655068113,
  -2.34070718945212e-05,-0.00555369098545533,0.0772928093939773,-0.0926574724031625,
  -2.55717560007362e-05,-0.00495505814904668,0.0919791922687362,-0.122805779299514,
  -2.77364401069513e-05,-0.00435642531263802,0.106665575143495,-0.152954086195865,
  -2.99011242132496e-05,-0.00375779247622932,0.121351958018254,-0.183102393092216,
  -3.2065808319437e-05,-0.00315915963982061,0.136038340893013,-0.213250699988567,
  -3.42304924255132e-05,-0.00256052680341168,0.150724723767772,-0.243399006884918,
  -3.63951765317561e-05,-0.00196189396700297,0.165411106642531,-0.27354731378127,
  -3.85598606380544e-05,-0.00136326113059471,0.18009748951729,-0.303695620677621,
  -4.07245447440752e-05,-0.000764628294185554,0.194783872392049,-0.333843927573972,
  -4.2889228850318e-05,-0.000165995457776846,0.209470255266808,-0.363992234470323,
  -4.50539129565053e-05,0.000432637378632084,0.224156638141567,-0.394140541366674,
  -4.72185970629146e-05,0.00103127021504035,0.238843021016326,-0.424288848263025,
  -4.9383281169324e-05,0.00162990305144883,0.253529403891085,-0.454437155159377,
  -5.15479652752893e-05,0.00222853588785799,0.268215786765844,-0.484585462055728,
  -5.37126493814766e-05,0.00282716872426625,0.282902169640602,-0.514733768952079,
  -5.58773334877749e-05,0.0034258015606754,0.297588552515362,-0.54488207584843,
  -5.80420175938512e-05,0.00402443439708411,0.312274935390121,-0.575030382744781,
  -6.02067017001495e-05,0.00462306723349304,0.32696131826488,-0.605178689641132,
  -6.23713858056707e-05,0.00522170006990219,0.341647701139639,-0.635326996537484,
  -6.45360699130793e-05,0.00582033290630912,0.356334084014397,-0.665475303433835,
  -6.67007540189335e-05,0.00641896574271872,0.371020466889157,-0.695623610330186,
  -6.88654381252318e-05,0.00701759857912743,0.385706849763916,-0.725771917226537,
  -7.10301222313081e-05,0.00761623141553613,0.400393232638675,-0.755920224122888,
  -1.76595017411796e-05,-0.00666214638203028,0.0476911883195031,-0.0326114488374637,
  -1.95259739344811e-05,-0.00609055012260873,0.0620729675499896,-0.0629610942610814,
  -2.13924461277548e-05,-0.00551895386318724,0.076454746780476,-0.0933107396846991,
  -2.32589183211673e-05,-0.00494735760376575,0.0908365260109626,-0.123660385108317,
  -2.51253905145243e-05,-0.00437576134434436,0.105218305241449,-0.154010030531935,
  -2.69918627076871e-05,-0.00380416508492265,0.119600084471935,-0.184359675955552,
  -2.88583349011273e-05,-0.00323256882550116,0.133981863702422,-0.21470932137917,
  -3.07248070943178e-05,-0.00266097256607967,0.148363642932908,-0.245058966802788,
  -3.25912792878413e-05,-0.0020893763066584,0.162745422163395,-0.275408612226406,
  -3.44577514810318e-05,-0.00151778004723657,0.177127201393881,-0.305758257650023,
  -3.63242236744443e-05,-0.000946183787815302,0.191508980624368,-0.336107903073641,
  -3.81906958676903e-05,-0.000374587528393588,0.205890759854854,-0.366457548497259,
  -4.00571680611583e-05,0.000197008731027681,0.220272539085341,-0.396807193920877,
  -4.19236402542378e-05,0.000768604990449395,0.234654318315827,-0.427156839344494,
  -4.37901124479279e-05,0.00134020124987067,0.249036097546314,-0.457506484768112,
  -4.56565846410628e-05,0.00191179750929238,0.2634178767768,-0.48785613019173,
  -4.75230568347529e-05,0.00248339376871365,0.277799656007287,-0.518205775615347,
  -4.93895290277768e-05,0.00305499002813536,0.292181435237773,-0.548555421038965,
  -5.12560012206897e-05,0.0036265862875573,0.30656321446826,-0.578905066462583,
  -5.31224734140467e-05,0.00419818254697879,0.320944993698746,-0.609254711886201,
  -5.49889456074037e-05,0.00476977880640028,0.335326772929233,-0.639604357309818,
  -5.68554178010938e-05,0.00534137506582155,0.349708552159719,-0.669954002733436,
  -5.87218899936737e-05,0.00591297132524371,0.364090331390206,-0.700303648157054,
  -6.05883621879189e-05,0.00648456758466409,0.378472110620692,-0.730653293580672,
  -6.24548343816089e-05,0.00705616384408536,0.392853889851178,-0.761002939004289,
  -1.59959192743281e-05,-0.00656170866354217,0.0474229351147055,-0.0329010027005708,
  -1.75406844489939e-05,-0.00602330309650645,0.0614496844725409,-0.0634832922662185,
  -1.90854496235904e-05,-0.00548489752947057,0.0754764338303764,-0.0940655818318661,
  -2.06302147984505e-05,-0.00494649196243513,0.0895031831882117,-0.124647871397514,
  -2.21749799729221e-05,-0.00440808639539914,0.103529932546047,-0.155230160963162,
  -2.37197451475601e-05,-0.00386968082836325,0.117556681903883,-0.185812450528809,
  -2.52645103224758e-05,-0.0033312752613277,0.131583431261718,-0.216394740094457,
  -2.68092754970861e-05,-0.00279286969429227,0.145610180619553,-0.246977029660105,
  -2.83540406713634e-05,-0.00225446412725583,0.159636929977389,-0.277559319225752,
  -2.98988058461402e-05,-0.00171605856022028,0.173663679335224,-0.3081416087914,
  -3.14435710209171e-05,-0.00117765299318462,0.18769042869306,-0.338723898357048,
  -3.29883361955274e-05,-0.000639247426148959,0.201717178050895,-0.369306187922695,
  -3.45331013705819e-05,-0.000100841859113743,0.21574392740873,-0.399888477488343,
  -3.60778665446371e-05,0.000437563707922806,0.229770676766566,-0.430470767053991,
  -3.76226317195805e-05,0.000975969274958244,0.243797426124401,-0.461053056619638,
  -3.91673968945794e-05,0.00151437484199346,0.257824175482237,-0.491635346185286,
  -4.07121620688011e-05,0.00205278040902979,0.271850924840072,-0.522217635750934,
  -4.2256927243689e-05,0.00259118597606567,0.285877674197908,-0.552799925316581,
  -4.38016924181328e-05,0.00312959154310133,0.299904423555743,-0.583382214882229,
  -4.53464575930207e-05,0.00366799711013677,0.313931172913578,-0.613964504447877,
  -4.68912227675755e-05,0.00420640267717287,0.327957922271414,-0.644546794013524,
  -4.84359879420193e-05,0.00474480824420898,0.34198467162925,-0.675129083579172,
  -4.99807531166852e-05,0.00528321381124464,0.356011420987085,-0.70571137314482,
  -5.1525518291351e-05,0.0058216193782803,0.37003817034492,-0.736293662710468,
  -5.30702834662389e-05,0.00636002494531551,0.384064919702755,-0.766875952276115,
  -1.4133300540814e-05,-0.0064538706340953,0.0471229485411515,-0.0332197073276481,
  -1.5353856657227e-05,-0.00595441955359038,0.0607551275041145,-0.06405806242712,
  -1.65744127736123e-05,-0.00545496847308546,0.0743873064670775,-0.094896417526592,
  -1.77949688899559e-05,-0.00495551739258043,0.0880194854300406,-0.125734772626064,
  -1.90155250064106e-05,-0.00445606631207573,0.101651664393003,-0.156573127725536,
  -2.0236081122782e-05,-0.00395661523157076,0.115283843355966,-0.187411482825008,
  -2.14566372390146e-05,-0.00345716415106567,0.12891602231893,-0.21824983792448,
  -2.26771933552472e-05,-0.00295771307056047,0.142548201281893,-0.249088193023952,
  -2.38977494717574e-05,-0.00245826199005572,0.156180380244856,-0.279926548123423,
  -2.51183055879345e-05,-0.00195881090955052,0.169812559207819,-0.310764903222895,
  -2.63388617046667e-05,-0.00145935982904599,0.183444738170782,-0.341603258322367,
  -2.75594178210659e-05,-0.000959908748541016,0.197076917133745,-0.372441613421839,
  -2.87799739377981e-05,-0.000460457668036485,0.210709096096708,-0.403279968521311,
  -3.00005300540862e-05,3.8993412468491e-05,0.22434127505967,-0.434118323620783,
  -3.12210861695972e-05,0.000538444492974355,0.237973454022634,-0.464956678720255,
  -3.24416422864404e-05,0.00103789557347911,0.251605632985597,-0.495795033819727,
  -3.36621984028396e-05,0.00153734665398342,0.265237811948559,-0.526633388919199,
  -3.48827545193497e-05,0.00203679773448839,0.278869990911522,-0.557471744018671,
  -3.61033106354158e-05,0.00253624881499359,0.292502169874486,-0.588310099118142,
  -3.73238667522591e-05,0.00303569989549812,0.306134348837449,-0.619148454217614,
  -3.85444228689913e-05,0.00353515097600221,0.319766527800411,-0.649986809317087,
  -3.97649789841692e-05,0.00403460205650896,0.333398706763375,-0.680825164416558,
  -4.09855351010124e-05,0.00453405313701394,0.347030885726338,-0.71166351951603,
  -4.22060912178557e-05,0.00503350421751803,0.360663064689301,-0.742501874615502,
  -4.34266473331446e-05,0.00553295529802433,0.374295243652264,-0.773340229714974,
  -1.21534947497837e-05,-0.00634438197652659,0.0468046375595618,-0.0335522688691095,
  -1.30711203291528e-05,-0.00588829157735871,0.0600208473306649,-0.064657822940321,
  -1.39887459086052e-05,-0.00543220117819077,0.0732370571017682,-0.0957633770115324,
  -1.49063714880437e-05,-0.00497611077902305,0.0864532668728713,-0.126868931082744,
  -1.58239970676211e-05,-0.00452002037985533,0.0996694766439744,-0.157974485153955,
  -1.67416226470596e-05,-0.0040639299806875,0.112885686415078,-0.189080039225167,
  -1.76592482264426e-05,-0.00360783958151967,0.126101896186181,-0.220185593296378,
  -1.85768738057424e-05,-0.00315174918235162,0.139318105957284,-0.25129114736759,
  -1.94944993854307e-05,-0.00269565878318412,0.152534315728387,-0.282396701438801,
  -2.04121249646749e-05,-0.00223956838401596,0.16575052549949,-0.313502255510013,
  -2.13297505440302e-05,-0.00178347798484801,0.178966735270593,-0.344607809581224,
  -2.2247376123552e-05,-0.00132738758568007,0.192182945041697,-0.375713363652436,
  -2.31650017031293e-05,-0.000871297186512798,0.2053991548128,-0.406818917723647,
  -2.40826272824846e-05,-0.000415206787344635,0.218615364583903,-0.437924471794858,
  -2.50002528621174e-05,4.08836118228617e-05,0.231831574355006,-0.46903002586607,
  -2.5917878440973e-05,0.000496974010991691,0.24504778412611,-0.500135579937281,
  -2.68355040207169e-05,0.000953064410158744,0.258263993897212,-0.531241134008493,
  -2.77531296001277e-05,0.00140915480932691,0.271480203668316,-0.562346688079704,
  -2.86707551794274e-05,0.00186524520849507,0.284696413439419,-0.593452242150916,
  -2.95883807592823e-05,0.00232133560766234,0.297912623210522,-0.624557796222127,
  -3.0506006338249e-05,0.00277742600683073,0.311128832981626,-0.655663350293339,
  -3.14236319178818e-05,0.00323351640599867,0.324345042752729,-0.68676890436455,
  -3.23412574978477e-05,0.00368960680516528,0.337561252523831,-0.717874458435762,
  -3.32588830770364e-05,0.00414569720433322,0.350777462294934,-0.748980012506973,
  -3.41765086567802e-05,0.00460178760350072,0.363993672066038,-0.780085566578185,
  -1.01620730509622e-05,-0.00623936560030039,0.0464851674537681,-0.0338805154515821,
  -1.081832139678e-05,-0.00582879618279192,0.0592865555669479,-0.0652498016095776,
  -1.14745697426533e-05,-0.0054182267652837,0.0720879436801276,-0.0966190877675731,
  -1.21308180884849e-05,-0.00500765734777514,0.0848893317933074,-0.127988373925569,
  -1.27870664344831e-05,-0.00459708793026703,0.0976907199064871,-0.159357660083564,
  -1.3443314780287e-05,-0.00418651851275864,0.110492108019667,-0.19072694624156,
  -1.40995631261465e-05,-0.00377594909525014,0.123293496132847,-0.222096232399555,
  -1.47558114719781e-05,-0.00336537967774198,0.136094884246026,-0.253465518557551,
  -1.54120598174767e-05,-0.00295481026023292,0.148896272359206,-0.284834804715546,
  -1.60683081635304e-05,-0.00254424084272498,0.161697660472386,-0.316204090873541,
  -1.67245565095842e-05,-0.00213367142521692,0.174499048585566,-0.347573377031537,
  -1.73808048555268e-05,-0.00172310200770864,0.187300436698745,-0.378942663189533,
  -1.8037053201192e-05,-0.00131253259019992,0.200101824811925,-0.410311949347528,
  -1.86933015471902e-05,-0.000901963172691866,0.212903212925105,-0.441681235505523,
  -1.93495498930218e-05,-0.000491393755183589,0.225704601038284,-0.473050521663519,
  -2.00057982384649e-05,-8.08243376744233e-05,0.238505989151465,-0.504419807821514,
  -2.06620465843521e-05,0.000329745079833632,0.251307377264644,-0.53578909397951,
  -2.13182949301283e-05,0.00074031449734191,0.264108765377824,-0.567158380137506,
  -2.19745432760154e-05,0.00115088391485063,0.276910153491004,-0.598527666295501,
  -2.26307916216806e-05,0.00156145333235935,0.289711541604184,-0.629896952453496,
  -2.32870399675678e-05,0.00197202274986763,0.302512929717363,-0.661266238611492,
  -2.3943288313677e-05,0.00238259216737502,0.315314317830542,-0.692635524769487,
  -2.45995366598972e-05,0.0027931615848833,0.328115705943723,-0.724004810927483,
  -2.52557850056734e-05,0.00320373100239113,0.340917094056902,-0.755374097085478,
  -2.59120333515606e-05,0.00361430041989985,0.353718482170082,-0.786743383243474,
  -8.26705109892301e-06,-0.00614399811919378,0.0461819444859536,-0.0341871901170836,
  -8.71494151642727e-06,-0.00577840804286384,0.058591957638233,-0.0658028762494132,
  -9.16283193405643e-06,-0.00541281796653398,0.0710019707905123,-0.0974185623817426,
  -9.61072235172722e-06,-0.00504722789020423,0.0834119839427916,-0.129034248514072,
  -1.0058612769176e-05,-0.00468163781387432,0.0958219970950708,-0.160649934646402,
  -1.05065031867912e-05,-0.00431604773754446,0.10823201024735,-0.192265620778731,
  -1.09543936041567e-05,-0.00395045766121427,0.12064202339963,-0.223881306911061,
  -1.14022840220218e-05,-0.00358486758488485,0.133052036551909,-0.25549699304339,
  -1.18501744393318e-05,-0.00321927750855455,0.145462049704188,-0.28711267917572,
  -1.22980648569748e-05,-0.00285368743222492,0.157872062856467,-0.318728365308049,
  -1.27459552746734e-05,-0.00248809735589517,0.170282076008747,-0.350344051440379,
  -1.31938456918168e-05,-0.00212250727956453,0.182692089161026,-0.381959737572708,
  -1.36417361095154e-05,-0.00175691720323479,0.195102102313306,-0.413575423705038,
  -1.40896265271029e-05,-0.00139132712690526,0.207512115465585,-0.445191109837367,
  -1.45375169446904e-05,-0.00102573705057507,0.219922128617864,-0.476806795969697,
  -1.49854073622224e-05,-0.000660146974245324,0.232332141770144,-0.508422482102026,
  -1.54332977795324e-05,-0.000294556897915133,0.244742154922423,-0.540038168234356,
  -1.58811881972865e-05,7.10331784146145e-05,0.257152168074702,-0.571653854366686,
  -1.63290786149295e-05,0.00043662325474414,0.269562181226981,-0.603269540499015,
  -1.67769690324615e-05,0.000802213331074331,0.281972194379261,-0.634885226631344,
  -1.72248594498825e-05,0.0011678034074043,0.29438220753154,-0.666500912763674,
  -1.76727498673035e-05,0.00153339348373427,0.306792220683819,-0.698116598896004,
  -1.81206402853906e-05,0.00189898356006335,0.319202233836098,-0.729732285028333,
  -1.85685307022565e-05,0.00226457363639376,0.331612246988378,-0.761347971160663,
  -1.90164211203436e-05,0.00263016371272329,0.344022260140657,-0.792963657292992,
  -6.55658407081039e-06,-0.00606159083217481,0.0459090008301479,-0.0344593555276549,
  -6.85022699883908e-06,-0.00573790517319722,0.0579685928599279,-0.0662937149242715,
  -7.14386992681226e-06,-0.00541421951421955,0.070028184889708,-0.0981280743208882,
  -7.43751285489647e-06,-0.00509053385524205,0.082087776919488,-0.129962433717505,
  -7.7311557828974e-06,-0.00476684819626438,0.0941473689492681,-0.161796793114121,
  -8.02479871087058e-06,-0.00444316253728694,0.106206960979048,-0.193631152510738,
  -8.31844163906581e-06,-0.00411947687830927,0.118266553008828,-0.225465511907355,
  -8.61208456715001e-06,-0.00379579121933193,0.130326145038608,-0.257299871303971,
  -8.90572749501217e-06,-0.00347210556035404,0.142385737068388,-0.289134230700588,
  -9.19937042309638e-06,-0.00314841990137649,0.154445329098168,-0.320968590097205,
  -9.49301335084751e-06,-0.0028247342423986,0.166504921127948,-0.352802949493821,
  -9.78665627926478e-06,-0.00250104858342159,0.178564513157728,-0.384637308890438,
  -1.00802992069604e-05,-0.00217736292444348,0.190624105187508,-0.416471668287055,
  -1.03739421350446e-05,-0.00185367726546581,0.202683697217289,-0.448306027683671,
  -1.06675850630733e-05,-0.00152999160648859,0.214743289247068,-0.480140387080288,
  -1.09612279913796e-05,-0.00120630594751092,0.226802881276849,-0.511974746476904,
  -1.12548709191307e-05,-0.000882620288533476,0.238862473306628,-0.543809105873521,
  -1.15485138472149e-05,-0.000558934629555585,0.250922065336409,-0.575643465270138,
  -1.18421567755211e-05,-0.000235248970578805,0.262981657366188,-0.607477824666755,
  -1.21357997029392e-05,8.84366883999732e-05,0.275041249395969,-0.639312184063371,
  -1.24294426315785e-05,0.000412122347376531,0.287100841425748,-0.671146543459988,
  -1.27230855595517e-05,0.000735808006354421,0.299160433455528,-0.702980902856604,
  -1.30167284865257e-05,0.0010594936653332,0.311220025485309,-0.734815262253221,
  -1.33103714157201e-05,0.00138317932430976,0.323279617515089,-0.766649621649837,
  -1.36040143425831e-05,0.00170686498328809,0.335339209544868,-0.798483981046454,
  -5.08478729989437e-06,-0.00599337229756208,0.0456747726584931,-0.0346900943510097,
  -5.27140450777563e-06,-0.00570667872925507,0.057435008107411,-0.0667098425212948,
  -5.45802171550425e-06,-0.00541998516094772,0.0691952435563291,-0.09872959069158,
  -5.64463892352429e-06,-0.00513329159264081,0.080955479005247,-0.130749338861865,
  -5.83125613121127e-06,-0.00484659802433351,0.092715714454165,-0.16276908703215,
  -6.01787333912029e-06,-0.00455990445602639,0.104475949903083,-0.194788835202435,
  -6.20449054683503e-06,-0.00427321088771926,0.116236185352001,-0.22680858337272,
  -6.39110775468854e-06,-0.00398651731941224,0.127996420800919,-0.258828331543005,
  -6.57772496270859e-06,-0.00369982375110534,0.139756656249837,-0.290848079713291,
  -6.76434217045108e-06,-0.00341313018279799,0.151516891698755,-0.322867827883576,
  -6.95095937847112e-06,-0.00312643661449075,0.163277127147673,-0.354887576053861,
  -7.13757658643566e-06,-0.0028397430461844,0.17503736259659,-0.386907324224146,
  -7.32419379384508e-06,-0.00255304947787649,0.186797598045509,-0.418927072394431,
  -7.5108110022537e-06,-0.00226635590957036,0.198557833494426,-0.450946820564716,
  -7.69742820949659e-06,-0.00197966234126223,0.210318068943345,-0.482966568735001,
  -7.88404541740562e-06,-0.00169296877295522,0.222078304392263,-0.514986316905286,
  -8.07066262542566e-06,-0.0014062752046482,0.23383853984118,-0.547006065075571,
  -8.25727983344571e-06,-0.00111958163634096,0.245598775290099,-0.579025813245856,
  -8.44389704091064e-06,-0.000832888068033499,0.257359010739017,-0.611045561416142,
  -8.63051424870864e-06,-0.000546194499726482,0.269119246187934,-0.643065309586427,
  -8.81713145639562e-06,-0.000259500931419243,0.280879481636852,-0.675085057756712,
  -9.00374866452669e-06,2.71926368875519e-05,0.29263971708577,-0.707104805926997,
  -9.19036587232469e-06,0.000313886205194347,0.304399952534688,-0.739124554097282,
  -9.37698307978962e-06,0.00060057977350203,0.316160187983606,-0.771144302267567,
  -9.56360028792069e-06,0.000887273341809269,0.327920423432524,-0.803164050437852,
  -3.86957818909739e-06,-0.00593886466524146,0.0454818542272867,-0.0348782456110755,
  -3.98575481037888e-06,-0.00568333287867956,0.0569964413405259,-0.067049165269802,
  -4.10193143168813e-06,-0.00542780109211766,0.0685110284537651,-0.0992200849285285,
  -4.21810805301126e-06,-0.00517226930555587,0.0800256155670042,-0.131391004587255,
  -4.33428467425112e-06,-0.0049167375189938,0.0915402026802435,-0.163561924245982,
  -4.45046129576854e-06,-0.00466120573243234,0.103054789793482,-0.195732843904708,
  -4.56663791703615e-06,-0.00440567394587021,0.114569376906722,-0.227903763563435,
  -4.68281453830377e-06,-0.00415014215930853,0.126083964019961,-0.260074683222161,
  -4.79899115973792e-06,-0.00389461037274674,0.1375985511332,-0.292245602880888,
  -4.91516778067247e-06,-0.0036390785861844,0.149113138246439,-0.324416522539614,
  -5.03134440210662e-06,-0.00338354679962261,0.160627725359679,-0.356587442198341,
  -5.14752102331872e-06,-0.00312801501306059,0.172142312472918,-0.388758361857067,
  -5.2636976448639e-06,-0.0028724832264988,0.183656899586157,-0.420929281515794,
  -5.37987426635356e-06,-0.00261695143993745,0.195171486699396,-0.45310020117452,
  -5.49605088751015e-06,-0.00236141965337522,0.206686073812635,-0.485271120833247,
  -5.61222750872226e-06,-0.00210588786681343,0.218200660925874,-0.517442040491973,
  -5.72840413026743e-06,-0.00185035608025164,0.229715248039114,-0.5496129601507,
  -5.84458075114647e-06,-0.0015948242936894,0.241229835152353,-0.581783879809426,
  -5.96075737246959e-06,-0.00133929250712739,0.252744422265592,-0.613954799468153,
  -6.07693399412579e-06,-0.0010837607205656,0.264259009378832,-0.646125719126879,
  -6.19311061533789e-06,-0.000828228934004027,0.27577359649207,-0.678296638785606,
  -6.30928723632795e-06,-0.000572697147442014,0.287288183605309,-0.710467558444333,
  -6.42546385820619e-06,-0.000317165360880445,0.298802770718549,-0.742638478103059,
  -6.54164047908523e-06,-6.16335743179874e-05,0.310317357831788,-0.774809397761785,
  -6.65781710051938e-06,0.000193898212243138,0.321831944945027,-0.806980317420512,
  -2.89997342294013e-06,-0.0058965229248214,0.04532825336189,-0.0350268606255955,
  -2.97158240979145e-06,-0.00566623906565222,0.0566478297080244,-0.0673171860908092,
  -3.04319139671216e-06,-0.00543595520648321,0.0679674060541586,-0.0996075115560229,
  -3.11480038370227e-06,-0.00520567134731414,0.0792869824002929,-0.131897837021237,
  -3.18640937066461e-06,-0.00497538748814519,0.0906065587464271,-0.16418816248645,
  -3.25801835751593e-06,-0.00474510362897607,0.101926135092561,-0.196478487951664,
  -3.32962734445053e-06,-0.00451481976980717,0.113245711438695,-0.228768813416878,
  -3.40123633119083e-06,-0.00428453591063782,0.12456528778483,-0.261059138882091,
  -3.47284531831971e-06,-0.00405425205146892,0.135884864130964,-0.293349464347305,
  -3.54445430494899e-06,-0.00382396819229935,0.147204440477099,-0.325639789812519,
  -3.61606329180031e-06,-0.00359368433313034,0.158524016823233,-0.357930115277732,
  -3.6876722789847e-06,-0.00336340047396155,0.169843593169367,-0.390220440742946,
  -3.75928126594705e-06,-0.00313311661479254,0.181163169515501,-0.42251076620816,
  -3.83089025263184e-06,-0.00290283275562331,0.192482745861635,-0.454801091673373,
  -3.90249923953867e-06,-0.0026725488964543,0.20380232220777,-0.487091417138587,
  -3.97410822638999e-06,-0.00244226503728528,0.215121898553904,-0.519381742603801,
  -4.04571721324132e-06,-0.00221198117811627,0.226441474900038,-0.551672068069014,
  -4.11732620053673e-06,-0.00198169731894726,0.237761051246172,-0.583962393534228,
  -4.18893518738805e-06,-0.00175141345977869,0.249080627592306,-0.616252718999442,
  -4.26054417446142e-06,-0.00152112960060924,0.260400203938441,-0.648543044464655,
  -4.33215316086866e-06,-0.00129084574143956,0.271719780284575,-0.680833369929869,
  -4.40376214749794e-06,-0.00106056188226988,0.28303935663071,-0.713123695395083,
  -4.47537113479335e-06,-0.000830278023101982,0.294358932976843,-0.745414020860297,
  -4.54698012153365e-06,-0.000599994163932305,0.305678509322978,-0.77770434632551,
  -4.61858910860702e-06,-0.000369710304763959,0.316998085669112,-0.809994671790724,
  -2.14724391352228e-06,-0.00586434101126784,0.0452092181363553,-0.0351413215647159,
  -2.19137834478467e-06,-0.00565388466844047,0.0563780103181248,-0.0675236114979282,
  -2.23551277592215e-06,-0.0054434283256129,0.0675468024998945,-0.0999059014311406,
  -2.27964720717067e-06,-0.00523297198278561,0.0787155946816639,-0.132288191364353,
  -2.32378163830815e-06,-0.00502251563995793,0.0898843868634336,-0.164670481297565,
  -2.3679160694734e-06,-0.00481205929713047,0.101053179045203,-0.197052771230778,
  -2.41205050061088e-06,-0.00460160295430301,0.112221971226973,-0.22943506116399,
  -2.45618493199817e-06,-0.00439114661147566,0.123390763408742,-0.261817351097202,
  -2.50031936310791e-06,-0.0041806902686482,0.134559555590512,-0.294199641030415,
  -2.54445379432866e-06,-0.00397023392582097,0.145728347772281,-0.326581930963627,
  -2.5885882254939e-06,-0.0037597775829934,0.156897139954051,-0.358964220896839,
  -2.63272265654813e-06,-0.00354932124016538,0.168065932135821,-0.391346510830052,
  -2.67685708760235e-06,-0.00333886489733759,0.179234724317591,-0.423728800763264,
  -2.72099151898963e-06,-0.00312840855451091,0.19040351649936,-0.456111090696476,
  -2.76512595021039e-06,-0.00291795221168356,0.201572308681129,-0.488493380629689,
  -2.80926038154217e-06,-0.00270749586885599,0.212741100862899,-0.520875670562901,
  -2.8533948126519e-06,-0.00249703952602864,0.223909893044668,-0.553257960496114,
  -2.89752924420572e-06,-0.00228658318320152,0.235078685226438,-0.585640250429326,
  -2.94166367509341e-06,-0.00207612684037328,0.246247477408208,-0.618022540362538,
  -2.98579810620314e-06,-0.00186567049754593,0.257416269589977,-0.65040483029575,
  -3.02993253686878e-06,-0.00165521415471748,0.268585061771747,-0.682787120228963,
  -3.07406696864465e-06,-0.00144475781189124,0.279753853953516,-0.715169410162175,
  -3.11820139997643e-06,-0.00123430146906367,0.290922646135286,-0.747551700095387,
  -3.16233583042003e-06,-0.00102384512623521,0.302091438317056,-0.7799339900286,
  -3.20647026230692e-06,-0.000813388783408531,0.313260230498825,-0.812316279961812,
  -1.57521898412616e-06,-0.0058402812355243,0.0451188854488749,-0.0352277756672731,
  -1.60264036312696e-06,-0.00564502143455947,0.0561734477297235,-0.0676795277734248,
  -1.63006174194735e-06,-0.00544976163359451,0.067228010010572,-0.100131279879576,
  -1.65748312089264e-06,-0.00525450183262971,0.0782825722914205,-0.132583031985728,
  -1.68490449986569e-06,-0.00505924203166486,0.0893371345722691,-0.16503478409188,
  -1.71232587875547e-06,-0.00486398223069984,0.100391696853118,-0.197486536198031,
  -1.73974725758974e-06,-0.00466872242973504,0.111446259133966,-0.229938288304183,
  -1.76716863670157e-06,-0.00447346262877013,0.122500821414815,-0.262390040410335,
  -1.79459001553584e-06,-0.00427820282780533,0.133555383695663,-0.294841792516486,
  -1.82201139448113e-06,-0.00408294302684031,0.144609945976512,-0.327293544622638,
  -1.84943277348193e-06,-0.00388768322587563,0.155664508257361,-0.35974529672879,
  -1.87685415253824e-06,-0.00369242342491072,0.166719070538209,-0.392197048834941,
  -1.90427553109496e-06,-0.00349716362394537,0.177773632819058,-0.424648800941093,
  -1.9316969103178e-06,-0.0033019038229809,0.188828195099906,-0.457100553047244,
  -1.9591182892631e-06,-0.00310664402201621,0.199882757380755,-0.489552305153396,
  -1.9865396677643e-06,-0.00291138422105086,0.210937319661604,-0.522004057259548,
  -2.01396104693163e-06,-0.00271612442008617,0.221991881942452,-0.5544558093657,
  -2.04138242643204e-06,-0.00252086461912215,0.2330464442233,-0.586907561471851,
  -2.06880380460017e-06,-0.00232560481815636,0.244101006504149,-0.619359313578003,
  -2.09622518376751e-06,-0.00213034501719145,0.255155568784998,-0.651811065684154,
  -2.12364656326791e-06,-0.00193508521622743,0.266210131065846,-0.684262817790306,
  -2.15106794188014e-06,-0.00173982541526208,0.277264693346695,-0.716714569896458,
  -2.17848932004827e-06,-0.00154456561429672,0.288319255627543,-0.749166322002609,
  -2.20591069888254e-06,-0.00134930581333093,0.299373817908393,-0.781618074108761,
  -2.23333207827192e-06,-0.00115404601236735,0.31042838018924,-0.814069826214913,
  -1.14752978243315e-06,-0.00582251324052027,0.0450514188223559,-0.0352921190621095,
  -1.16480631602578e-06,-0.00563868670992446,0.0560207754968416,-0.0677955683334324,
  -1.18208284960453e-06,-0.00545486017932861,0.0669901321713274,-0.100299017604755,
  -1.19935938328042e-06,-0.00527103364873294,0.0779594888458131,-0.132802466876078,
  -1.21663591656773e-06,-0.00508720711813671,0.0889288455202991,-0.165305916147401,
  -1.23391245032689e-06,-0.00490338058754114,0.0998982021947847,-0.197809365418724,
  -1.251188983864e-06,-0.00471955405694524,0.110867558869271,-0.230312814690047,
  -1.26846551762316e-06,-0.00453572752634968,0.121836915543756,-0.262816263961369,
  -1.28574205116028e-06,-0.00435190099575378,0.132806272218242,-0.295319713232692,
  -1.30301858458637e-06,-0.00416807446515799,0.143775628892728,-0.327823162504015,
  -1.32029511845655e-06,-0.00398424793456242,0.154744985567213,-0.360326611775338,
  -1.33757165204917e-06,-0.00380042140396664,0.165714342241699,-0.392830061046661,
  -1.35484818508669e-06,-0.00361659487337018,0.176683698916185,-0.425333510317984,
  -1.37212471901238e-06,-0.00343276834277462,0.187653055590671,-0.457836959589306,
  -1.38940125271603e-06,-0.00324894181217883,0.198622412265157,-0.490340408860629,
  -1.40667778558701e-06,-0.00306511528158193,0.209591768939643,-0.522843858131952,
  -1.42395432023434e-06,-0.0028812887509877,0.220561125614128,-0.555347307403275,
  -1.44123085354941e-06,-0.00269746222039169,0.231530482288614,-0.587850756674598,
  -1.45850738753062e-06,-0.00251363568979657,0.242499838963099,-0.620354205945921,
  -1.47578392073466e-06,-0.00232980915920011,0.253469195637585,-0.652857655217243,
  -1.49306045427178e-06,-0.00214598262860433,0.264438552312071,-0.685361104488566,
  -1.51033698803094e-06,-0.00196215609800854,0.275407908986557,-0.717864553759889,
  -1.52761352090192e-06,-0.00177832956741186,0.286377265661043,-0.750368003031212,
  -1.54489005521619e-06,-0.00159450303681741,0.297346622335528,-0.782871452302535,
  -1.56216658819819e-06,-0.00141067650622029,0.308315979010014,-0.815374901573858,
  -8.31630060330046e-07,-0.00580950970757976,0.045001627399384,-0.0353394824502399,
  -8.42705339509919e-07,-0.0056341664871114,0.0559081602851909,-0.0678809861777422,
  -8.53780618564892e-07,-0.00545882326664299,0.0668146931709978,-0.100422489905245,
  -8.64855897703132e-07,-0.00528348004617463,0.0777212260568046,-0.132963993632747,
  -8.75931176924638e-07,-0.00510813682570643,0.0886277589426114,-0.165505497360249,
  -8.87006455979611e-07,-0.00493279360523791,0.0995342918284183,-0.198047001087752,
  -8.98081734979073e-07,-0.00475745038476927,0.110440824714225,-0.230588504815254,
  -9.09157014394868e-07,-0.0045821071643013,0.121347357600032,-0.263130008542756,
  -9.20232293366574e-07,-0.00440676394383277,0.132253890485839,-0.295671512270259,
  -9.31307572282769e-07,-0.00423142072336402,0.143160423371646,-0.328213015997761,
  -9.42382851587542e-07,-0.00405607750289616,0.154066956257452,-0.360754519725263,
  -9.53458130947826e-07,-0.00388073428242786,0.164973489143259,-0.393296023452766,
  -9.64533409919532e-07,-0.00370539106195933,0.175880022029066,-0.425837527180268,
  -9.75608688891239e-07,-0.0035300478414908,0.186786554914873,-0.45837903090777,
  -9.86683968418056e-07,-0.00335470462102294,0.19769308780068,-0.490920534635273,
  -9.97759247445273e-07,-0.00317936140055419,0.208599620686487,-0.523462038362775,
  -1.00883452636147e-06,-0.00300401818008611,0.219506153572294,-0.556003542090278,
  -1.01990980572175e-06,-0.00282867495961758,0.230412686458101,-0.58854504581778,
  -1.03098508485999e-06,-0.0026533317391495,0.241319219343907,-0.621086549545282,
  -1.04206036377619e-06,-0.00247798851868009,0.252225752229715,-0.653628053272784,
  -1.05313564291443e-06,-0.00230264529821245,0.263132285115521,-0.686169557000287,
  -1.06421092227471e-06,-0.00212730207774436,0.274038818001328,-0.718711060727789,
  -1.07528620130193e-06,-0.00195195885727539,0.284945350887135,-0.751252564455292,
  -1.08636148032915e-06,-0.00177661563680775,0.295851883772941,-0.783794068182794,
  -1.09743675957841e-06,-0.00160127241633923,0.306758416658749,-0.816335571910297,
  -6.00394642863433e-07,-0.00580005558619484,0.0449652028088316,-0.0353740650941542,
  -6.07626607168621e-07,-0.00563094253125529,0.0558258090308201,-0.0679433544966126,
  -6.14858571307275e-07,-0.00546182947631557,0.0666864152528086,-0.100512643899071,
  -6.22090535612463e-07,-0.00529271642137613,0.077547021474797,-0.133081933301529,
  -6.29322499862139e-07,-0.00512360336643647,0.0884076276967856,-0.165651222703988,
  -6.36554464250594e-07,-0.00495449031149708,0.0992682339187739,-0.198220512106446,
  -6.43786428555781e-07,-0.0047853772565577,0.110128840140762,-0.230789801508905,
  -6.51018392694436e-07,-0.00461626420161787,0.120989446362751,-0.263359090911363,
  -6.58250356999623e-07,-0.00444715114667871,0.131850052584739,-0.295928380313821,
  -6.65482321082767e-07,-0.00427803809173866,0.142710658806728,-0.32849766971628,
  -6.72714285276932e-07,-0.00410892503679894,0.153571265028716,-0.361066959118738,
  -6.79946249637631e-07,-0.00393981198185989,0.164431871250704,-0.393636248521197,
  -6.87178214053841e-07,-0.00377069892692039,0.175292477472693,-0.426205537923655,
  -6.94410178525562e-07,-0.00360158587198089,0.186153083694681,-0.458774827326114,
  -7.0164214283075e-07,-0.00343247281704162,0.19701368991667,-0.491344116728572,
  -7.08874106969404e-07,-0.0032633597621019,0.207874296138658,-0.523913406131031,
  -7.16106070886013e-07,-0.00309424670716196,0.218734902360647,-0.556482695533489,
  -7.23338035579779e-07,-0.00292513365222269,0.229595508582635,-0.589051984935947,
  -7.30569999607411e-07,-0.00275602059728319,0.240456114804624,-0.621621274338406,
  -7.37801963746065e-07,-0.00258690754234348,0.251316721026612,-0.654190563740864,
  -7.45033928661876e-07,-0.00241779448740465,0.2621773272486,-0.686759853143323,
  -7.52265892245418e-07,-0.00224868143246404,0.273037933470589,-0.719329142545781,
  -7.59497857050206e-07,-0.00207956837752521,0.283898539692578,-0.751898431948239,
  -7.66729821521928e-07,-0.00191045532258594,0.294759145914566,-0.784467721350698,
  -7.73961785327515e-07,-0.00174134226764533,0.305619752136555,-0.817037010753156,
  -2.84782493201324e-05,-0.00729197454872307,0.0597259588284352,-0.0440726974825753,
  -3.18714019584831e-05,-0.00661748196895767,0.0752520089806604,-0.0728230742581764,
  -3.52645545967922e-05,-0.00594298938919213,0.0907780591328857,-0.101573451033777,
  -3.86577072351846e-05,-0.00526849680942676,0.106304109285111,-0.130323827809379,
  -4.20508598735769e-05,-0.0045940042296615,0.121830159437336,-0.15907420458498,
  -4.5444012511664e-05,-0.00391951164989557,0.137356209589561,-0.187824581360581,
  -4.88371651501396e-05,-0.0032450190701302,0.152882259741787,-0.216574958136182,
  -5.22303177883932e-05,-0.00257052649036471,0.168408309894012,-0.245325334911783,
  -5.56234704267577e-05,-0.00189603391059934,0.183934360046237,-0.274075711687384,
  -5.90166230652334e-05,-0.00122154133083408,0.199460410198462,-0.302826088462985,
  -6.2409775703709e-05,-0.000547048751068813,0.214986460350687,-0.331576465238586,
  -6.58029283415185e-05,0.000127443828697338,0.230512510502913,-0.360326842014187,
  -6.9196080979772e-05,0.000801936408463044,0.246038560655138,-0.389077218789788,
  -7.25892336184142e-05,0.00147642898822764,0.261564610807363,-0.417827595565389,
  -7.59823862567233e-05,0.00215092156799357,0.277090660959589,-0.446577972340991,
  -7.93755388952544e-05,0.00282541414775905,0.292616711111814,-0.475328349116592,
  -8.27686915334525e-05,0.00349990672752409,0.308142761264039,-0.504078725892193,
  -8.61618441717615e-05,0.0041743993072898,0.323668811416264,-0.532829102667794,
  -8.95549968101816e-05,0.00484889188705528,0.33919486156849,-0.561579479443395,
  -9.29481494481577e-05,0.00552338446682121,0.354720911720715,-0.590329856218996,
  -9.63413020870219e-05,0.00619787704658581,0.37024696187294,-0.619080232994597,
  -9.97344547251089e-05,0.00687236962635218,0.385773012025166,-0.647830609770198,
  -0.000103127607363307,0.00754686220611767,0.401299062177391,-0.676580986545799,
  -0.000106520760002393,0.00822135478588226,0.416825112329616,-0.7053313633214,
  -0.000109913912640369,0.00889584736564775,0.432351162481841,-0.734081740097001,
  -2.83328205074457e-05,-0.00728071021353133,0.0596970031002054,-0.0441038666928489,
  -3.16930733335052e-05,-0.00660803700476242,0.0751964528709227,-0.0728724659747643,
  -3.50533261596619e-05,-0.00593536379599358,0.09069590264164,-0.10164106525668,
  -3.84135789857354e-05,-0.00526269058722467,0.106195352412357,-0.130409664538595,
  -4.17738318117811e-05,-0.00459001737845577,0.121694802183075,-0.159178263820511,
  -4.5134084637799e-05,-0.00391734416968681,0.137194251953792,-0.187946863102426,
  -4.84943374638447e-05,-0.00324467096091785,0.152693701724509,-0.216715462384341,
  -5.18545902896683e-05,-0.00257199775214845,0.168193151495227,-0.245484061666257,
  -5.52148431159361e-05,-0.00189932454337971,0.183692601265944,-0.274252660948172,
  -5.85750959419817e-05,-0.00122665133461064,0.199192051036661,-0.303021260230087,
  -6.19353487680829e-05,-0.000553978125841903,0.214691500807378,-0.331789859512003,
  -6.52956015942396e-05,0.000118695082927056,0.230190950578096,-0.360558458793918,
  -6.86558544201188e-05,0.000791368291696015,0.245690400348813,-0.389327058075834,
  -7.20161072461645e-05,0.00146404150046497,0.26118985011953,-0.418095657357749,
  -7.53763600719326e-05,0.00213671470923438,0.276689299890248,-0.446864256639665,
  -7.87366128985889e-05,0.00280938791800223,0.292188749660965,-0.47563285592158,
  -8.2096865724246e-05,0.00348206112677185,0.307688199431682,-0.504401455203495,
  -8.54571185503472e-05,0.00415473433554037,0.323187649202399,-0.533170054485411,
  -8.88173713763374e-05,0.00482740754430977,0.338687098973117,-0.561938653767326,
  -9.21776242027716e-05,0.00550008075307828,0.354186548743834,-0.590707253049242,
  -9.55378770288728e-05,0.00617275396184747,0.369685998514552,-0.619475852331157,
  -9.8898129854641e-05,0.00684542717061642,0.385185448285269,-0.648244451613072,
  -0.000102258382681186,0.0075181003793845,0.400684898055985,-0.677013050894987,
  -0.000105618635506954,0.0081907735881539,0.416184347826703,-0.705781650176903,
  -0.000108978888332723,0.0088634467969233,0.43168379759742,-0.734550249458818,
  -2.81318302663564e-05,-0.00726519504593853,0.0596569780256893,-0.0441468892027146,
  -3.14468683355607e-05,-0.0065950543363637,0.0751196777924643,-0.0729406408048461,
  -3.47619064047233e-05,-0.00592491362678882,0.0905823775592394,-0.101734392406978,
  -3.80769444739415e-05,-0.00525477291721388,0.106045077326015,-0.130528144009109,
  -4.13919825430487e-05,-0.00458463220763905,0.12150777709279,-0.159321895611241,
  -4.47070206123779e-05,-0.00391449149806444,0.136970476859564,-0.188115647213372,
  -4.80220586816515e-05,-0.00324435078848961,0.15243317662634,-0.216909398815504,
  -5.13370967507587e-05,-0.00257421007891478,0.167895876393115,-0.245703150417635,
  -5.46521348198659e-05,-0.00190406936933962,0.18335857615989,-0.274496902019767,
  -5.79671728889175e-05,-0.00123392865976468,0.198821275926665,-0.303290653621898,
  -6.12822109583577e-05,-0.000563787950190076,0.21428397569344,-0.33208440522403,
  -6.45972490274649e-05,0.000106352759384976,0.229746675460215,-0.360878156826161,
  -6.79122870966831e-05,0.000776493468959361,0.24520937522699,-0.389671908428293,
  -7.12273251656237e-05,0.00144663417853463,0.260672074993765,-0.418465660030425,
  -7.45423632351194e-05,0.00211677488810902,0.27613477476054,-0.447259411632556,
  -7.785740130406e-05,0.00278691559768451,0.291597474527315,-0.476053163234688,
  -8.11724393735558e-05,0.0034570563072589,0.30706017429409,-0.504846914836819,
  -8.44874774427185e-05,0.00412719701683351,0.322522874060865,-0.533640666438951,
  -8.78025155117701e-05,0.00479733772640834,0.33798557382764,-0.562434418041082,
  -9.11175535808217e-05,0.00546747843598405,0.353448273594416,-0.591228169643214,
  -9.44325916502065e-05,0.00613761914555866,0.368910973361191,-0.620021921245345,
  -9.7747629718925e-05,0.00680775985513327,0.384373673127965,-0.648815672847477,
  -0.000101062667788532,0.00747790056470787,0.39983637289474,-0.677609424449608,
  -0.000104377705857583,0.00814804127428337,0.415299072661516,-0.70640317605174,
  -0.000107692743927079,0.00881818198385753,0.43076177242829,-0.735196927653871,
  -2.78553677655058e-05,-0.00724395350292695,0.0596019109039985,-0.0442059628311834,
  -3.11086956129997e-05,-0.00657733028075719,0.0750140858755764,-0.073034250745218,
  -3.43620234603825e-05,-0.00591070705858715,0.0904262608471544,-0.101862538659253,
  -3.76153513079458e-05,-0.00524408383641739,0.105838435818732,-0.130690826573287,
  -4.08686791554258e-05,-0.00457746061424769,0.12125061079031,-0.159519114487322,
  -4.4122007002767e-05,-0.00391083739207754,0.136662785761888,-0.188347402401357,
  -4.73753348502193e-05,-0.00324421416990772,0.152074960733466,-0.217175690315391,
  -5.0628662697616e-05,-0.00257759094773768,0.167487135705044,-0.246003978229426,
  -5.38819905452903e-05,-0.00191096772556809,0.182899310676622,-0.274832266143461,
  -5.71353183927981e-05,-0.00124434450339828,0.1983114856482,-0.303660554057495,
  -6.03886462401948e-05,-0.000577721281228571,0.213723660619778,-0.33248884197153,
  -6.36419740874805e-05,8.8901940941799e-05,0.229135835591356,-0.361317129885565,
  -6.68953019351548e-05,0.000755525163111059,0.244548010562934,-0.390145417799599,
  -7.0148629782496e-05,0.00142214838528143,0.259960185534512,-0.418973705713634,
  -7.34019576296152e-05,0.00208877160745158,0.27537236050609,-0.447801993627669,
  -7.66552854771785e-05,0.0027553948296215,0.290784535477669,-0.476630281541703,
  -7.99086133247418e-05,0.00342201805179143,0.306196710449247,-0.505458569455738,
  -8.3161941171972e-05,0.00408864127396114,0.321608885420824,-0.534286857369773,
  -8.64152690194242e-05,0.00475526449613128,0.337021060392403,-0.563115145283807,
  -8.96685968673205e-05,0.00542188771830077,0.352433235363981,-0.591943433197842,
  -9.29219247146618e-05,0.00608851094047047,0.367845410335558,-0.620771721111877,
  -9.6175252562225e-05,0.00675513416264018,0.383257585307136,-0.649600009025911,
  -9.94285804094552e-05,0.00742175738481032,0.398669760278714,-0.678428296939946,
  -0.000102681908256685,0.00808838060698047,0.414081935250292,-0.707256584853981,
  -0.000105935236104471,0.00875500382914973,0.42949411022187,-0.736084872768015,
  -2.74775680015188e-05,-0.00721511144957537,0.0595266360380612,-0.044286496017058,
  -3.06474705275839e-05,-0.00655335836996551,0.074869813130267,-0.0731618661790941,
  -3.38173730536351e-05,-0.00589160529035571,0.0902129902224726,-0.10203723634113,
  -3.69872755798528e-05,-0.00522985221074601,0.105556167314678,-0.130912606503166,
  -4.0157178105904e-05,-0.00456809913113621,0.120899344406884,-0.159787976665203,
  -4.3327080631872e-05,-0.0039063460515264,0.13624252149909,-0.188663346827239,
  -4.64969831581175e-05,-0.00324459297191682,0.151585698591295,-0.217538716989275,
  -4.96668856841409e-05,-0.00258283989230679,0.166928875683501,-0.246414087151311,
  -5.28367882101088e-05,-0.00192108681269676,0.182272052775707,-0.275289457313347,
  -5.60066907361878e-05,-0.00125933373308706,0.197615229867913,-0.304164827475383,
  -5.91765932622113e-05,-0.000597580653477259,0.212958406960118,-0.33304019763742,
  -6.23464957884012e-05,6.41724261325471e-05,0.228301584052324,-0.361915567799456,
  -6.55163983140361e-05,0.000725925505743019,0.24364476114453,-0.390790937961492,
  -6.86863008405592e-05,0.00138767858535238,0.258987938236736,-0.419666308123528,
  -7.18562033665826e-05,0.00204943166496241,0.274331115328942,-0.448541678285564,
  -7.50261058927171e-05,0.00271118474457155,0.289674292421147,-0.4774170484476,
  -7.81960084190736e-05,0.00337293782418113,0.305017469513353,-0.506292418609637,
  -8.1365910945097e-05,0.00403469090379072,0.320360646605558,-0.535167788771673,
  -8.45358134712315e-05,0.00469644398340097,0.335703823697764,-0.564043158933709,
  -8.77057159969219e-05,0.00535819706301122,0.35104700078997,-0.592918529095745,
  -9.08756185235005e-05,0.00601995014262036,0.366390177882175,-0.621793899257781,
  -9.40455210495239e-05,0.00668170322222972,0.381733354974381,-0.650669269419817,
  -9.72154235756584e-05,0.00734345630183952,0.397076532066586,-0.679544639581854,
  -0.000100385326101127,0.00800520938145066,0.412419709158793,-0.70842000974389,
  -0.000103555228627927,0.00866696246106002,0.427762886250999,-0.737295379905926,
  -2.69658674338924e-05,-0.00717638647988697,0.0594246413539615,-0.0443952168496572,
  -3.00244447036385e-05,-0.00652134522800274,0.0746744525616861,-0.0733341486496414,
  -3.30830219733569e-05,-0.00586630397611854,0.0899242637694107,-0.102273080449626,
  -3.61415992432002e-05,-0.00521126272423444,0.105174074977135,-0.13121201224961,
  -3.92001765129601e-05,-0.00455622147235035,0.12042388618486,-0.160150944049594,
  -4.22587537827201e-05,-0.00390118022046615,0.135673697392585,-0.189089875849578,
  -4.53173310523414e-05,-0.00324613896858172,0.150923508600309,-0.218028807649563,
  -4.83759083223512e-05,-0.00259109771669797,0.166173319808034,-0.246967739449547,
  -5.14344855919724e-05,-0.00193605646481354,0.181423131015758,-0.275906671249531,
  -5.44930628618157e-05,-0.00128101521292945,0.196672942223483,-0.304845603049515,
  -5.75516401315479e-05,-0.000625973961045023,0.211922753431208,-0.3337845348495,
  -6.06102174010581e-05,2.90672908389578e-05,0.227172564638932,-0.362723466649484,
  -6.36687946708459e-05,0.000684108542723383,0.242422375846657,-0.391662398449468,
  -6.67273719408001e-05,0.00133914979460736,0.257672187054382,-0.420601330249453,
  -6.97859492102548e-05,0.00199419104649201,0.272921998262107,-0.449540262049437,
  -7.28445264801536e-05,0.00264923229837621,0.288171809469831,-0.478479193849421,
  -7.59031037498303e-05,0.00330427355026042,0.303421620677556,-0.507418125649405,
  -7.8961681019396e-05,0.00395931480214462,0.31867143188528,-0.536357057449389,
  -8.20202582898499e-05,0.00461435605402771,0.333921243093004,-0.565295989249374,
  -8.50788355594156e-05,0.00526939730591214,0.349171054300729,-0.594234921049358,
  -8.81374128287593e-05,0.00592443855779701,0.364420865508454,-0.623173852849342,
  -9.1195990098436e-05,0.00657947980968121,0.379670676716179,-0.652112784649326,
  -9.42545673681128e-05,0.00723452106156586,0.394920487923903,-0.681051716449311,
  -9.73131446380116e-05,0.00788956231344917,0.410170299131627,-0.709990648249295,
  -0.000100371721908021,0.00854460356533293,0.425420110339352,-0.738929580049279,
  -2.62811141993613e-05,-0.00712517025886258,0.0592880832589611,-0.0445400712968631,
  -2.91937237537065e-05,-0.00647931637516425,0.0744131092949161,-0.0735636895889239,
  -3.21063333081073e-05,-0.00583346249146593,0.0895381353308712,-0.102587307880985,
  -3.50189428625636e-05,-0.00518760860776779,0.104663161366826,-0.131610926173046,
  -3.79315524170754e-05,-0.00454175472406959,0.119788187402781,-0.160634544465106,
  -4.08441619714206e-05,-0.00389590084037161,0.134913213438736,-0.189658162757167,
  -4.37567715258491e-05,-0.00325004695667308,0.150038239474691,-0.218681781049228,
  -4.66693810802221e-05,-0.00260419307297477,0.165163265510646,-0.247705399341289,
  -4.95819906347617e-05,-0.0019583391892769,0.180288291546601,-0.27672901763335,
  -5.24946001890791e-05,-0.00131248530557837,0.195413317582556,-0.30575263592541,
  -5.54072097435632e-05,-0.000666631421880615,0.210538343618511,-0.334776254217471,
  -5.83198192981027e-05,-2.07775381819708e-05,0.225663369654466,-0.363799872509532,
  -6.12324288523647e-05,0.000625076345516229,0.240788395690421,-0.392823490801593,
  -6.41450384065712e-05,0.00127093022921465,0.255913421726376,-0.421847109093654,
  -6.70576479612217e-05,0.00191678411291285,0.271038447762331,-0.450870727385714,
  -6.99702575155392e-05,0.00256263799661105,0.286163473798286,-0.479894345677775,
  -7.28828670699677e-05,0.00320849188030947,0.301288499834241,-0.508917963969836,
  -7.57954766245073e-05,0.00385434576400745,0.316413525870196,-0.537941582261897,
  -7.87080861786027e-05,0.00450019964770609,0.331538551906151,-0.566965200553958,
  -8.16206957334753e-05,0.00514605353140385,0.346663577942106,-0.595988818846019,
  -8.45333052880148e-05,0.00579190741510205,0.361788603978061,-0.625012437138079,
  -8.74459148416662e-05,0.00643776129880091,0.376913630014016,-0.65403605543014,
  -9.03585243967608e-05,0.00708361518249845,0.392038656049971,-0.683059673722201,
  -9.32711339513004e-05,0.00772946906619687,0.407163682085927,-0.712083292014262,
  -9.61837435055068e-05,0.00837532294989485,0.422288708121881,-0.741106910306323,
  -2.53794224035347e-05,-0.00705877183441364,0.0591081483077737,-0.0447297191618403,
  -2.81050807483113e-05,-0.00642536954754025,0.074069130089697,-0.0738642115949753,
  -3.0830739092963e-05,-0.00579196726066661,0.0890301118716205,-0.10299870402811,
  -3.35563974377118e-05,-0.00515856497379319,0.103991093653544,-0.132133196461245,
  -3.62820557824606e-05,-0.00452516268691971,0.118952075435467,-0.16126768889438,
  -3.90077141270151e-05,-0.00389176040004591,0.133913057217391,-0.190402181327515,
  -4.17333724717084e-05,-0.00325835811317254,0.148874038999314,-0.21953667376065,
  -4.44590308165682e-05,-0.00262495582629918,0.163835020781237,-0.248671166193785,
  -4.71846891612615e-05,-0.00199155353942582,0.178796002563161,-0.27780565862692,
  -4.99103475058993e-05,-0.00135815125255223,0.193756984345084,-0.306940151060055,
  -5.26360058507591e-05,-0.000724748965678756,0.208717966127007,-0.33607464349319,
  -5.53616641952859e-05,-9.13466788048378e-05,0.223678947908931,-0.365209135926325,
  -5.80873225402567e-05,0.000542055608067749,0.238639929690854,-0.39434362835946,
  -6.08129808845614e-05,0.00117545789494211,0.253600911472778,-0.423478120792595,
  -6.35386392294768e-05,0.00180886018181514,0.268561893254701,-0.452612613225731,
  -6.62642975741701e-05,0.00244226246868862,0.283522875036624,-0.481747105658865,
  -6.89899559187523e-05,0.00307566475556298,0.298483856818548,-0.510881598092001,
  -7.17156142635567e-05,0.00370906704243579,0.313444838600471,-0.540016090525135,
  -7.444127260825e-05,0.00434246932930971,0.328405820382395,-0.56915058295827,
  -7.71669309531653e-05,0.00497587161618274,0.343366802164317,-0.598285075391405,
  -7.98925892977476e-05,0.00560927390305643,0.358327783946241,-0.62741956782454,
  -8.26182476426629e-05,0.00624267618992969,0.373288765728164,-0.656554060257675,
  -8.53439059870231e-05,0.00687607847680338,0.388249747510087,-0.68568855269081,
  -8.80695643321605e-05,0.00750948076367619,0.403210729292011,-0.714823045123946,
  -9.07952226765207e-05,0.00814288305055078,0.418171711073935,-0.74395753755708,
  -2.42169219448612e-05,-0.0069748910802756,0.0588759956276035,-0.0449724007196165,
  -2.67104048698452e-05,-0.00635812307561145,0.0736259484247471,-0.0742487724682725,
  -2.92038877948153e-05,-0.00574135507094725,0.0883759012218906,-0.103525144216928,
  -3.16973707195078e-05,-0.00512458706628288,0.103125854019034,-0.132801515965584,
  -3.41908536445612e-05,-0.00450781906161868,0.117875806816178,-0.16207788771424,
  -3.66843365696146e-05,-0.00389105105695464,0.132625759613321,-0.191354259462896,
  -3.91778194944736e-05,-0.00327428305229027,0.147375712410465,-0.220630631211552,
  -4.16713024194437e-05,-0.00265751504762612,0.162125665207608,-0.249907002960208,
  -4.41647853443583e-05,-0.00204074704296209,0.176875618004752,-0.279183374708864,
  -4.66582682692174e-05,-0.00142397903829772,0.191625570801895,-0.30845974645752,
  -4.91517511940764e-05,-0.000807211033633237,0.206375523599039,-0.337736118206176,
  -5.16452341192131e-05,-0.000190443028969423,0.221125476396183,-0.367012489954832,
  -5.41387170442942e-05,0.000426324975694392,0.235875429193326,-0.396288861703488,
  -5.66321999692088e-05,0.00104309298035887,0.25062538199047,-0.425565233452144,
  -5.91256828940123e-05,0.00165986098502291,0.265375334787613,-0.4548416052008,
  -6.16191658188159e-05,0.00227662898968739,0.280125287584757,-0.484117976949456,
  -6.41126487441745e-05,0.00289339699435098,0.2948752403819,-0.513394348698112,
  -6.6606131668534e-05,0.00351016499901591,0.309625193179044,-0.542670720446768,
  -6.90996145936706e-05,0.00412693300368039,0.324375145976188,-0.571947092195424,
  -7.15930975185852e-05,0.0047437010083442,0.339125098773331,-0.60122346394408,
  -7.40865804437219e-05,0.00536046901300846,0.353875051570474,-0.630499835692736,
  -7.65800633678593e-05,0.00597723701767316,0.368625004367618,-0.659776207441392,
  -7.90735462937731e-05,0.00659400502233654,0.383374957164761,-0.689052579190047,
  -8.15670292182435e-05,0.00721077302700124,0.398124909961905,-0.718328950938704,
  -8.40605121431581e-05,0.0078275410316655,0.412874862759049,-0.74760532268736,
  -2.27583961417144e-05,-0.0068723398930263,0.0585844867841895,-0.045274022225637,
  -2.49747339643308e-05,-0.00627734400617658,0.0730704197735651,-0.074726731448029,
  -2.7191071786753e-05,-0.00568234811932666,0.0875563527629407,-0.104179440670421,
  -2.94074096093e-05,-0.00508735223247692,0.102042285752316,-0.133632149892813,
  -3.16237474319025e-05,-0.00449235634562717,0.116528218741692,-0.163084859115205,
  -3.38400852544218e-05,-0.00389736045877742,0.131014151731067,-0.192537568337597,
  -3.60564230769689e-05,-0.00330236457192745,0.145500084720443,-0.221990277559989,
  -3.82727608995159e-05,-0.00270736868507782,0.159986017709819,-0.251442986782381,
  -4.04890987221185e-05,-0.00211237279822818,0.174471950699194,-0.280895696004773,
  -4.270543654461e-05,-0.0015173769113781,0.18895788368857,-0.310348405227165,
  -4.49217743672681e-05,-0.000922381024528462,0.203443816677946,-0.339801114449557,
  -4.71381121896486e-05,-0.000327385137678382,0.217929749667321,-0.369253823671949,
  -4.93544500122511e-05,0.000267610749171254,0.232415682656697,-0.398706532894342,
  -5.15707878347982e-05,0.000862606636021113,0.246901615646072,-0.428159242116734,
  -5.37871256572897e-05,0.00145760252287097,0.261387548635448,-0.457611951339126,
  -5.60034634798923e-05,0.00205259840972039,0.275873481624823,-0.487064660561518,
  -5.82198013021618e-05,0.00264759429657069,0.290359414614199,-0.51651736978391,
  -6.04361391250974e-05,0.0032425901834201,0.304845347603575,-0.545970079006302,
  -6.26524769475889e-05,0.00383758607026974,0.31933128059295,-0.575422788228694,
  -6.48688147699694e-05,0.00443258195711982,0.333817213582326,-0.604875497451086,
  -6.70851525922389e-05,0.00502757784396968,0.348303146571701,-0.634328206673478,
  -6.93014904147304e-05,0.00562257373081954,0.362789079561077,-0.66378091589587,
  -7.15178282366669e-05,0.00621756961767028,0.377275012550453,-0.693233625118262,
  -7.37341660600466e-05,0.00681256550451881,0.391760945539828,-0.722686334340654,
  -7.59505038830932e-05,0.00740756139136778,0.406246878529203,-0.752139043563046,
  -2.09896723926684e-05,-0.00675189391053091,0.0582306870362514,-0.0456356018562426,
  -2.28911588340958e-05,-0.00618460437605056,0.0723975777075627,-0.075299701968683,
  -2.47926452754677e-05,-0.00561731484157013,0.0865644683788739,-0.104963802081123,
  -2.66941317169644e-05,-0.00505002530708998,0.100731359050185,-0.134627902193564,
  -2.85956181584335e-05,-0.00448273577260982,0.114898249721496,-0.164292002306004,
  -3.04971045997915e-05,-0.00391544623812956,0.129065140392807,-0.193956102418445,
  -3.23985910411495e-05,-0.00334815670364919,0.143232031064119,-0.223620202530885,
  -3.4300077482452e-05,-0.0027808671691687,0.15739892173543,-0.253284302643326,
  -3.62015639240321e-05,-0.00221357763468855,0.171565812406741,-0.282948402755766,
  -3.81030503653346e-05,-0.00164628810020817,0.185732703078052,-0.312612502868207,
  -4.00045368067481e-05,-0.0010789985657278,0.199899593749363,-0.342276602980647,
  -4.19060232480506e-05,-0.000511709031247198,0.214066484420675,-0.371940703093087,
  -4.38075096894641e-05,5.55805032329548e-05,0.228233375091986,-0.401604803205528,
  -4.57089961309887e-05,0.00062287003771333,0.242400265763297,-0.431268903317968,
  -4.76104825724022e-05,0.00119015957219326,0.256567156434608,-0.460933003430409,
  -4.95119690139267e-05,0.00175744910667364,0.270734047105919,-0.490597103542849,
  -5.14134554552292e-05,0.00232473864115401,0.28490093777723,-0.52026120365529,
  -5.33149418967538e-05,0.00289202817563394,0.299067828448541,-0.54992530376773,
  -5.52164283381673e-05,0.00345931771011387,0.313234719119852,-0.57958940388017,
  -5.71179147794698e-05,0.00402660724459469,0.327401609791164,-0.609253503992611,
  -5.90194012208833e-05,0.00459389677907529,0.341568500462475,-0.638917604105051,
  -6.09208876626299e-05,0.005161186313555,0.355735391133786,-0.668581704217492,
  -6.28223741040435e-05,0.00572847584803515,0.369902281805097,-0.698245804329932,
  -6.472386054579e-05,0.00629576538251531,0.384069172476408,-0.727909904442373,
  -6.66253469867595e-05,0.00686305491699635,0.39823606314772,-0.757574004554813,
  -1.89311786960439e-05,-0.00661695961314956,0.0578186243856483,-0.0460507569456302,
  -2.04957256269706e-05,-0.00608364584900739,0.0716157856959496,-0.0759575698560974,
  -2.20602725578278e-05,-0.00555033208486505,0.085412947006251,-0.105864382766565,
  -2.36248194886157e-05,-0.00501701832072277,0.0992101083165523,-0.135771195677032,
  -2.51893664195424e-05,-0.00448370455658043,0.113007269626854,-0.165678008587499,
  -2.67539133505523e-05,-0.00395039079243842,0.126804430937155,-0.195584821497966,
  -2.83184602813402e-05,-0.00341707702829597,0.140601592247456,-0.225491634408434,
  -2.98830072125167e-05,-0.00288376326415407,0.154398753557758,-0.255398447318901,
  -3.14475541430825e-05,-0.0023504495000114,0.168195914868059,-0.285305260229368,
  -3.3012101074148e-05,-0.00181713573586939,0.18199307617836,-0.315212073139835,
  -3.45766480051024e-05,-0.00128382197172727,0.195790237488662,-0.345118886050302,
  -3.61411949358348e-05,-0.00075050820758471,0.209587398798963,-0.37502569896077,
  -3.77057418669002e-05,-0.000217194443442814,0.223384560109264,-0.404932511871237,
  -3.92702887974661e-05,0.000316119320699748,0.237181721419566,-0.434839324781704,
  -4.0834835728476e-05,0.000849433084842088,0.250978882729867,-0.464746137692171,
  -4.23993826591529e-05,0.00138274684898443,0.264776044040169,-0.494652950602639,
  -4.39639295901628e-05,0.00191606061312677,0.27857320535047,-0.524559763513106,
  -4.55284765215058e-05,0.00244937437726822,0.292370366660771,-0.554466576423573,
  -4.70930234520717e-05,0.00298268814141078,0.306167527971072,-0.58437338933404,
  -4.86575703828596e-05,0.00351600190555335,0.319964689281374,-0.614280202244507,
  -5.02221173135364e-05,0.00404931566969591,0.333761850591676,-0.644187015154975,
  -5.17866642448794e-05,0.00458262943383758,0.347559011901977,-0.674093828065442,
  -5.33512111760004e-05,0.00511594319797926,0.361356173212278,-0.704000640975909,
  -5.49157581065662e-05,0.00564925696212271,0.37515333452258,-0.733907453886376,
  -5.648030503691e-05,0.00618257072626482,0.388950495832881,-0.763814266796844,
  -1.66470254656104e-05,-0.00647361313829381,0.0573611600706776,-0.04650446136626,
  -1.78751135015004e-05,-0.00598008142069067,0.0707500867390631,-0.076676524233245,
  -1.91032015374459e-05,-0.00548654970308754,0.0841390134074487,-0.10684858710023,
  -2.03312895733776e-05,-0.00499301798548435,0.0975279400758344,-0.137020649967215,
  -2.15593776093093e-05,-0.00449948626788133,0.11091686674422,-0.1671927128342,
  -2.27874656453242e-05,-0.0040059545502783,0.124305793412605,-0.197364775701185,
  -2.40155536812003e-05,-0.00351242283267506,0.137694720080991,-0.22753683856817,
  -2.524364171691e-05,-0.0030188911150717,0.151083646749377,-0.257708901435155,
  -2.64717297531192e-05,-0.0025253593974689,0.164472573417762,-0.28788096430214,
  -2.76998177888288e-05,-0.00203182767986543,0.177861500086148,-0.318053027169125,
  -2.8927905825149e-05,-0.00153829596226274,0.191250426754533,-0.34822509003611,
  -3.01559938605811e-05,-0.00104476424465938,0.204639353422919,-0.378397152903095,
  -3.13840818968458e-05,-0.000551232527056245,0.218028280091305,-0.40856921577008,
  -3.26121699325554e-05,-5.77008094531095e-05,0.23141720675969,-0.438741278637065,
  -3.38402579687092e-05,0.000435830908150026,0.244806133428076,-0.46891334150405,
  -3.50683460041967e-05,0.000929362625753605,0.258195060096461,-0.499085404371035,
  -3.62964340406835e-05,0.00142289434335607,0.271583986764847,-0.52925746723802,
  -3.75245220763931e-05,0.00191642606095943,0.284972913433232,-0.559429530105005,
  -3.87526101122138e-05,0.00240995777856257,0.298361840101618,-0.58960159297199,
  -3.99806981481454e-05,0.0029034894961657,0.311750766770003,-0.619773655838975,
  -4.12087861839661e-05,0.00339702121376906,0.325139693438389,-0.64994571870596,
  -4.24368742201198e-05,0.00389055293137197,0.338528620106775,-0.680117781572945,
  -4.36649622556073e-05,0.00438408464897577,0.351917546775161,-0.710289844439929,
  -4.48930502920941e-05,0.0048776163665778,0.365306473443546,-0.740461907306915,
  -4.61211383281368e-05,0.00537114808418071,0.378695400111931,-0.7706339701739,
  -1.42427884829849e-05,-0.00632971345519029,0.0568795639046676,-0.0469743050743908,
  -1.51596241397545e-05,-0.00588030446785154,0.0698411395937946,-0.0774210534359073,
  -1.60764597967322e-05,-0.00543089548051295,0.0828027152829215,-0.107867801797424,
  -1.69932954535712e-05,-0.00498148649317443,0.0957642909720484,-0.13831455015894,
  -1.79101311104657e-05,-0.00453207750583573,0.108725866661175,-0.168761298520457,
  -1.88269667673047e-05,-0.00408266851849703,0.121687442350302,-0.199208046881973,
  -1.97438024240881e-05,-0.00363325953115845,0.134649018039429,-0.22965479524349,
  -2.06606380810381e-05,-0.00318385054381976,0.147610593728556,-0.260101543605006,
  -2.15774737381547e-05,-0.00273444155648161,0.160572169417683,-0.290548291966523,
  -2.24943093948271e-05,-0.00228503256914259,0.17353374510681,-0.320995040328039,
  -2.34111450516661e-05,-0.00183562358180422,0.186495320795937,-0.351441788689556,
  -2.43279807084495e-05,-0.00138621459446542,0.199456896485064,-0.381888537051072,
  -2.52448163652885e-05,-0.000936805607126612,0.212418472174191,-0.412335285412589,
  -2.6161652022072e-05,-0.00048739661978825,0.225380047863317,-0.442782033774105,
  -2.7078487678911e-05,-3.79876324492212e-05,0.238341623552444,-0.473228782135622,
  -2.7995323335972e-05,0.000411421354889141,0.251303199241571,-0.503675530497138,
  -2.89121589926999e-05,0.000860830342227725,0.264264774930698,-0.534122278858655,
  -2.9828994649872e-05,0.00131023932956631,0.277226350619825,-0.564569027220171,
  -3.0745830306822e-05,0.00175964831690489,0.290187926308952,-0.595015775581688,
  -3.1662665963772e-05,0.00220905730424326,0.303149501998079,-0.625462523943204,
  -3.25795016201669e-05,0.00265846629158251,0.316111077687206,-0.655909272304721,
  -3.34963372773389e-05,0.00310787527892042,0.329072653376333,-0.686356020666237,
  -3.44131729342889e-05,0.00355728426625879,0.342034229065459,-0.716802769027754,
  -3.53300085910169e-05,0.00400669325359759,0.354995804754586,-0.74724951738927,
  -3.62468442477448e-05,0.0044561022409364,0.367957380443713,-0.777696265750787,
  -1.18487128997202e-05,-0.00619326655079422,0.0564001055218364,-0.04743450078835,
  -1.2499750499384e-05,-0.00578996693775052,0.0689385738635717,-0.0781502941218063,
  -1.31507880989923e-05,-0.00538666732470688,0.0814770422053068,-0.108866087455263,
  -1.38018256987948e-05,-0.00498336771166341,0.094015510547042,-0.139581880788719,
  -1.44528632982921e-05,-0.00458006809861966,0.106553978888777,-0.170297674122175,
  -1.51039008980391e-05,-0.00417676848557602,0.119092447230512,-0.201013467455632,
  -1.5754938497814e-05,-0.0037734688725326,0.131630915572247,-0.231729260789088,
  -1.64059760973112e-05,-0.00337016925948874,0.144169383913983,-0.262445054122544,
  -1.70570136970305e-05,-0.00296686964644532,0.156707852255718,-0.293160847456001,
  -1.77080512969163e-05,-0.00256357003340191,0.169246320597453,-0.323876640789457,
  -1.83590888963026e-05,-0.00216027042035782,0.181784788939188,-0.354592434122913,
  -1.90101264960774e-05,-0.00175697080731441,0.194323257280923,-0.38530822745637,
  -1.96611640961297e-05,-0.00135367119427099,0.206861725622659,-0.416024020789826,
  -2.0312201695627e-05,-0.000950371581227349,0.219400193964394,-0.446739814123282,
  -2.09632392947912e-05,-0.000547071968183044,0.231938662306129,-0.477455607456739,
  -2.16142768949545e-05,-0.00014377235514007,0.244477130647864,-0.508171400790195,
  -2.22653144947849e-05,0.000259527257903347,0.257015598989599,-0.538887194123651,
  -2.2916352093949e-05,0.000662826870947431,0.269554067331335,-0.569602987457108,
  -2.35673896938904e-05,0.00106612648399063,0.282092535673069,-0.600318780790564,
  -2.42184272931656e-05,0.00146942609703471,0.294631004014805,-0.63103457412402,
  -2.4869464893329e-05,0.0018727257100779,0.30716947235654,-0.661750367457477,
  -2.55205024934924e-05,0.0022760253231211,0.319707940698275,-0.692466160790933,
  -2.61715400923235e-05,0.00267932493616518,0.33224640904001,-0.72318195412439,
  -2.68225776921538e-05,0.00308262454920882,0.344784877381745,-0.753897747457846,
  -2.74736152920951e-05,0.00348592416225246,0.357323345723481,-0.784613540791302,
  -9.59285573970403e-06,-0.00607071185607524,0.0559485849309637,-0.0478613003010824,
  -1.00341497088624e-05,-0.00571274019390927,0.0680906422344277,-0.0788266141308056,
  -1.04754436778542e-05,-0.00535476853174316,0.0802326995378917,-0.109791927960529,
  -1.09167376469987e-05,-0.0049967968695771,0.0923747568413559,-0.140757241790252,
  -1.13580316161432e-05,-0.0046388252074111,0.10451681414482,-0.171722555619976,
  -1.1799325585371e-05,-0.00428085354524532,0.116658871448284,-0.202687869449699,
  -1.2240619554349e-05,-0.00392288188307921,0.128800928751748,-0.233653183279422,
  -1.26819135233824e-05,-0.0035649102209131,0.140942986055212,-0.264618497109145,
  -1.31232074925824e-05,-0.0032069385587471,0.153085043358676,-0.295583810938869,
  -1.35645014618935e-05,-0.00284896689658143,0.16522710066214,-0.326549124768592,
  -1.40057954307604e-05,-0.00249099523441521,0.177369157965604,-0.357514438598315,
  -1.44470893999604e-05,-0.0021330235722492,0.189511215269068,-0.388479752428039,
  -1.48883833688829e-05,-0.00177505191008298,0.201653272572532,-0.419445066257762,
  -1.53296773383049e-05,-0.00141708024791742,0.213795329875996,-0.450410380087485,
  -1.57709713073384e-05,-0.0010591085857512,0.22593738717946,-0.481375693917208,
  -1.62122652762609e-05,-0.000701136923585199,0.238079444482924,-0.512341007746932,
  -1.66535592456274e-05,-0.00034316526141942,0.250221501786388,-0.543306321576655,
  -1.70948532147719e-05,1.48064007463589e-05,0.262363559089852,-0.574271635406378,
  -1.75361471838054e-05,0.000372778062912582,0.274505616393316,-0.605236949236102,
  -1.79774411530609e-05,0.000730749725078361,0.28664767369678,-0.636202263065825,
  -1.84187351220944e-05,0.00108872138724481,0.298789731000244,-0.667167576895548,
  -1.88600290911278e-05,0.00144669304941081,0.310931788303708,-0.698132890725272,
  -1.93013230600503e-05,0.00180466471157681,0.323073845607172,-0.729098204554995,
  -1.97426170291948e-05,0.00216263637374237,0.335215902910635,-0.760063518384718,
  -2.01839109986723e-05,0.00252060803590837,0.3473579602141,-0.791028832214441,
  -7.57517455252099e-06,-0.00596586621096029,0.0555450709451129,-0.0482375490255339,
  -7.86266118284196e-06,-0.0056499052921945,0.0673344695282808,-0.0794228297616014,
  -8.15014781332946e-06,-0.00533394437342888,0.0791238681114488,-0.110608110497669,
  -8.43763444380308e-06,-0.00501798345466331,0.0909132666946166,-0.141793391233736,
  -8.72512107416568e-06,-0.00470202253589747,0.102702665277785,-0.172978671969804,
  -9.01260770475032e-06,-0.00438606161713206,0.114492063860952,-0.204163952705871,
  -9.30009433519619e-06,-0.00407010069836633,0.12628146244412,-0.235349233441939,
  -9.58758096547552e-06,-0.00375413977960026,0.138070861027289,-0.266534514178006,
  -9.87506759586587e-06,-0.00343817886083453,0.149860259610457,-0.297719794914074,
  -1.01625542266448e-05,-0.00312221794206935,0.161649658193624,-0.328905075650142,
  -1.04500408568131e-05,-0.00280625702330339,0.173439056776792,-0.360090356386209,
  -1.07375274873145e-05,-0.0024902961045381,0.18522845535996,-0.391275637122276,
  -1.10250141178159e-05,-0.00217433518577237,0.197017853943128,-0.422460917858344,
  -1.13125007482617e-05,-0.00185837426700641,0.208807252526296,-0.453646198594411,
  -1.15999873788741e-05,-0.00154241334824112,0.220596651109464,-0.484831479330479,
  -1.18874740092645e-05,-0.00122645242947539,0.232386049692632,-0.516016760066546,
  -1.21749606394328e-05,-0.000910491510709432,0.2441754482758,-0.547202040802614,
  -1.24624472701562e-05,-0.00059453059194392,0.255964846858968,-0.578387321538681,
  -1.27499339002135e-05,-0.000278569673178186,0.267754245442135,-0.609572602274749,
  -1.30374205303818e-05,3.73912455882142e-05,0.279543644025304,-0.640757883010816,
  -1.33249071612163e-05,0.000353352164352838,0.291333042608471,-0.671943163746884,
  -1.36123937919397e-05,0.00066931308311835,0.303122441191639,-0.703128444482952,
  -1.3899880421997e-05,0.000985274001884751,0.314911839774807,-0.734313725219019,
  -1.41873670521653e-05,0.00130123492065071,0.326701238357975,-0.765499005955087,
  -1.44748536839989e-05,0.00161719583941489,0.338490636941143,-0.796684286691154,
  -5.85291751924177e-06,-0.00587982223885913,0.055200969110531,-0.0485546865512454,
  -6.03458705161763e-06,-0.00560076788768915,0.0666907856685643,-0.079925375916985,
  -6.21625658403513e-06,-0.00532171353651917,0.0781806022265976,-0.111296065282725,
  -6.39792611628609e-06,-0.00504265918534896,0.0896704187846309,-0.142666754648464,
  -6.57959564870358e-06,-0.00476360483417904,0.101160235342664,-0.174037444014204,
  -6.76126518128761e-06,-0.00448455048300944,0.112650051900697,-0.205408133379943,
  -6.94293471348306e-06,-0.00420549613183918,0.124139868458731,-0.236778822745683,
  -7.12460424601158e-06,-0.00392644178066914,0.135629685016764,-0.268149512111422,
  -7.30627377809601e-06,-0.00364738742949899,0.147119501574797,-0.299520201477162,
  -7.48794331079106e-06,-0.0033683330783294,0.15860931813283,-0.330890890842902,
  -7.66961284337508e-06,-0.00308927872715947,0.170099134690864,-0.362261580208641,
  -7.851282375404e-06,-0.00281022437598932,0.181588951248897,-0.393632269574381,
  -8.03295190798803e-06,-0.0025311700248194,0.19307876780693,-0.42500295894012,
  -8.2146214402945e-06,-0.00225211567364947,0.204568584364963,-0.45637364830586,
  -8.39629097293404e-06,-0.00197306132247976,0.216058400922997,-0.487744337671599,
  -8.57796050512949e-06,-0.00169400697130939,0.22754821748103,-0.519115027037339,
  -8.75963003721392e-06,-0.00141495262013946,0.239038034039063,-0.550485716403079,
  -8.94129957018652e-06,-0.00113589826896954,0.250527850597097,-0.581856405768818,
  -9.12296910238197e-06,-0.00085684391779961,0.26201766715513,-0.613227095134558,
  -9.30463863491049e-06,-0.000577789566630127,0.273507483713163,-0.644597784500297,
  -9.48630816699492e-06,-0.000298735215459089,0.284997300271197,-0.675968473866037,
  -9.66797769930139e-06,-1.96808642889401e-05,0.29648711682923,-0.707339163231776,
  -9.84964723171888e-06,0.000259373486879877,0.307976933387262,-0.738709852597516,
  -1.00313167636923e-05,0.000538427838051359,0.319466749945297,-0.770080541963256,
  -1.02129862968869e-05,0.000817482189219731,0.330956566503329,-0.801451231328995,
  -4.44050545927999e-06,-0.00581156574737568,0.0549190472023984,-0.0488120486915552,
  -4.55304085171526e-06,-0.00556346920329315,0.066164182659506,-0.0803332001057616,
  -4.66557624420605e-06,-0.00531537265921084,0.0774093181166134,-0.111854351519968,
  -4.7781116366552e-06,-0.00506727611512836,0.0886544535737209,-0.143375502934175,
  -4.89064702915987e-06,-0.00481917957104605,0.0998995890308284,-0.174896654348381,
  -5.00318242158126e-06,-0.00457108302696352,0.111144724487936,-0.206417805762588,
  -5.11571781386388e-06,-0.00432298648288099,0.122389859945043,-0.237938957176794,
  -5.22825320653508e-06,-0.00407488993879868,0.133634995402151,-0.269460108591001,
  -5.34078859898424e-06,-0.00382679339471614,0.144880130859259,-0.300981260005207,
  -5.45332399143339e-06,-0.00357869685063372,0.156125266316366,-0.332502411419414,
  -5.56585938371601e-06,-0.00333060030655119,0.167370401773474,-0.36402356283362,
  -5.67839477599863e-06,-0.00308250376246821,0.178615537230581,-0.395544714247827,
  -5.79093016844778e-06,-0.00283440721838635,0.189860672687688,-0.427065865662033,
  -5.90346556095245e-06,-0.00258631067430382,0.201105808144796,-0.45858701707624,
  -6.01600095384569e-06,-0.00233821413022173,0.212350943601904,-0.490108168490446,
  -6.12853634596178e-06,-0.00209011758613853,0.223596079059011,-0.521629319904652,
  -6.24107173863298e-06,-0.00184202104205666,0.234841214516119,-0.553150471318859,
  -6.35360713086008e-06,-0.00159392449797413,0.246086349973226,-0.584671622733065,
  -6.46614252330924e-06,-0.00134582795389182,0.257331485430333,-0.616192774147272,
  -6.57867791564737e-06,-0.00109773140980884,0.268576620887441,-0.647713925561478,
  -6.69121330909572e-06,-0.000849634865727644,0.279821756344548,-0.679235076975685,
  -6.80374870098976e-06,-0.000601538321644668,0.291066891801656,-0.710756228389892,
  -6.91628409321687e-06,-0.000353441777561692,0.302312027258764,-0.742277379804098,
  -7.02881948633216e-06,-0.000105345233480492,0.313557162715871,-0.773798531218305,
  -7.14135487844825e-06,0.000142751310602485,0.324802298172979,-0.805319682632511,
  -3.31973059683466e-06,-0.00575884980193198,0.0546955368165693,-0.0490145482464725,
  -3.38879714462115e-06,-0.0055357471369798,0.0657471645046427,-0.0806540873062349,
  -3.45786369237988e-06,-0.00531264447202762,0.0767987921927161,-0.112293626365997,
  -3.52693024002759e-06,-0.00508954180707522,0.0878504198807896,-0.14393316542576,
  -3.59599678795286e-06,-0.00486643914212315,0.0989020475688629,-0.175572704485522,
  -3.66506333560057e-06,-0.00464333647717075,0.109953675256936,-0.207212243545285,
  -3.73412988341482e-06,-0.00442023381221845,0.12100530294501,-0.238851782605047,
  -3.80319643111804e-06,-0.00419713114726605,0.132056930633084,-0.270491321664809,
  -3.87226297915433e-06,-0.00397402848231443,0.143108558321157,-0.302130860724572,
  -3.94132952680204e-06,-0.00375092581736203,0.15416018600923,-0.333770399784334,
  -4.01039607411668e-06,-0.00352782315240896,0.165211813697304,-0.365409938844097,
  -4.07946262231951e-06,-0.00330472048745745,0.176263441385377,-0.397049477903859,
  -4.14852917002273e-06,-0.00308161782250505,0.187315069073451,-0.428689016963622,
  -4.2175957174484e-06,-0.00285851515755242,0.198366696761524,-0.460328556023384,
  -4.28666226548469e-06,-0.00263541249260091,0.209418324449597,-0.491968095083147,
  -4.35572881329893e-06,-0.00241230982764851,0.220469952137671,-0.523607634142909,
  -4.42479536066909e-06,-0.00218920716269611,0.231521579825744,-0.555247173202671,
  -4.4938619088164e-06,-0.00196610449774393,0.242573207513818,-0.586886712262434,
  -4.56292845663064e-06,-0.00174300183279197,0.253624835201891,-0.618526251322196,
  -4.63199500422284e-06,-0.00151989916783934,0.264676462889964,-0.650165790381959,
  -4.70106155192607e-06,-0.00129679650288761,0.275728090578037,-0.681805329441721,
  -4.77012809951827e-06,-0.00107369383793454,0.286779718266111,-0.713444868501484,
  -4.83919464788762e-06,-0.00085059117298325,0.297831345954185,-0.745084407561246,
  -4.90826119481369e-06,-0.000627488508029739,0.308882973642258,-0.776723946621009,
  -4.97732774284998e-06,-0.000404385843077559,0.319934601330332,-0.808363485680771,
  -2.45340071673705e-06,-0.00571896343692924,0.0545229018106951,-0.0491700415113413,
  -2.49581029534984e-06,-0.00551543306426827,0.0654253513504637,-0.0809004868525282,
  -2.53821987394875e-06,-0.0053119026916072,0.0763278008902324,-0.112630932193715,
  -2.58062945240889e-06,-0.0051083723189459,0.0872302504300012,-0.144361377534902,
  -2.62303903095229e-06,-0.00490484194628504,0.0981326999697696,-0.176091822876089,
  -2.66544860949569e-06,-0.00470131157362386,0.109035149509538,-0.207822268217276,
  -2.7078581883444e-06,-0.00449778120096311,0.119937599049307,-0.239552713558462,
  -2.75026776674903e-06,-0.00429425082830182,0.130840048589076,-0.271283158899649,
  -2.79267734526467e-06,-0.00409072045564074,0.141742498128844,-0.303013604240836,
  -2.83508692394685e-06,-0.00388719008298,0.152644947668613,-0.334744049582023,
  -2.87749650229596e-06,-0.00368365971031848,0.163547397208382,-0.36647449492321,
  -2.91990608081161e-06,-0.00348012933765762,0.17444984674815,-0.398204940264397,
  -2.96231565988236e-06,-0.00327659896499699,0.185352296287919,-0.429935385605584,
  -3.00472523795392e-06,-0.00307306859233525,0.196254745827688,-0.46166583094677,
  -3.04713481646957e-06,-0.00286953821967395,0.207157195367456,-0.493396276287957,
  -3.08954439487419e-06,-0.00266600784701287,0.218059644907225,-0.525126721629144,
  -3.13195397350086e-06,-0.00246247747435202,0.228962094446993,-0.556857166970331,
  -3.17436355234957e-06,-0.00225894710169117,0.239864543986762,-0.588587612311518,
  -3.21677313119828e-06,-0.00205541672903053,0.25076699352653,-0.620318057652705,
  -3.25918270949188e-06,-0.00185188635636901,0.261669443066299,-0.652048502993891,
  -3.30159228800753e-06,-0.00164835598370772,0.272571892606068,-0.683778948335078,
  -3.34400186652317e-06,-0.00144482561104686,0.283474342145836,-0.715509393676265,
  -3.38641144503882e-06,-0.00124129523838645,0.294376791685604,-0.747239839017452,
  -3.42882102366548e-06,-0.00103776486572427,0.305279241225374,-0.778970284358639,
  -3.47123060229215e-06,-0.000834234493063413,0.316181690765143,-0.810700729699826,
  -1.79723251893249e-06,-0.00568924620187969,0.0543922282550564,-0.0492872186713995,
  -1.82349798166781e-06,-0.00550068362258754,0.065181921298203,-0.0810861694870695,
  -1.84976344422272e-06,-0.00531212104329515,0.0759716143413497,-0.112885120302739,
  -1.87602890705518e-06,-0.00512355846400303,0.0867613073844965,-0.144684071118409,
  -1.90229436969336e-06,-0.0049349958847108,0.0975510004276431,-0.176483021934079,
  -1.92855983244256e-06,-0.00474643330541868,0.10834069347079,-0.208281972749749,
  -1.95482529502522e-06,-0.00455787072612646,0.119130386513936,-0.240080923565419,
  -1.98109075788544e-06,-0.00436930814683434,0.129920079557083,-0.271879874381089,
  -2.00735622030157e-06,-0.00418074556754178,0.14070977260023,-0.303678825196759,
  -2.03362168277321e-06,-0.00399218298824922,0.151499465643377,-0.335477776012429,
  -2.05988714607752e-06,-0.00380362040895799,0.162289158686523,-0.367276726828099,
  -2.08615260838263e-06,-0.00361505782966542,0.17307885172967,-0.399075677643769,
  -2.11241807129836e-06,-0.00342649525037308,0.183868544772817,-0.430874628459438,
  -2.13868353382551e-06,-0.00323793267108075,0.194658237815963,-0.462673579275108,
  -2.16494899696329e-06,-0.00304937009178952,0.205447930859109,-0.494472530090778,
  -2.19121445943493e-06,-0.00286080751249673,0.216237623902256,-0.526271480906448,
  -2.21747992190657e-06,-0.00267224493320417,0.227027316945403,-0.558070431722118,
  -2.2437453848223e-06,-0.0024836823539125,0.237817009988549,-0.589869382537788,
  -2.27001084740497e-06,-0.00229511977461994,0.248606703031696,-0.621668333353458,
  -2.29627631009865e-06,-0.0021065571953276,0.259396396074843,-0.653467284169128,
  -2.32254177268132e-06,-0.00191799461603548,0.27018608911799,-0.685266234984798,
  -2.34880723537501e-06,-0.00172943203674336,0.280975782161136,-0.717065185800468,
  -2.37507269829074e-06,-0.00154086945745124,0.291765475204283,-0.748864136616137,
  -2.40133816065136e-06,-0.00135230687815868,0.30255516824743,-0.780663087431807,
  -2.42760362356709e-06,-0.00116374429886656,0.313344861290576,-0.812462038247477,
  -1.30786010667239e-06,-0.00566735681711797,0.0542948197846209,-0.0493742777079591,
  -1.32436299335459e-06,-0.00549003648582658,0.0650005499420833,-0.0812241259903759,
  -1.34086588032822e-06,-0.00531271615453555,0.0757062800995456,-0.113073974272793,
  -1.35736876705206e-06,-0.00513539582324418,0.086412010257008,-0.144923822555209,
  -1.37387165394243e-06,-0.00495807549195304,0.0971177404144702,-0.176773670837626,
  -1.39037454066626e-06,-0.00478075516066157,0.107823470571933,-0.208623519120043,
  -1.40687742744561e-06,-0.00460343482937042,0.118529200729395,-0.24047336740246,
  -1.42338031439149e-06,-0.00442611449807928,0.129234930886857,-0.272323215684876,
  -1.43988320094879e-06,-0.00424879416678792,0.13994066104432,-0.304173063967293,
  -1.45638608800569e-06,-0.00407147383549677,0.150646391201782,-0.33602291224971,
  -1.47288897484055e-06,-0.00389415350420563,0.161352121359244,-0.367872760532127,
  -1.48939186145336e-06,-0.00371683317291427,0.172057851516707,-0.399722608814543,
  -1.50589474806617e-06,-0.00353951284162246,0.182763581674169,-0.43157245709696,
  -1.52239763517859e-06,-0.00336219251033198,0.193469311831631,-0.463422305379377,
  -1.53890052201344e-06,-0.00318487217904084,0.204175041989093,-0.495272153661794,
  -1.5554034088483e-06,-0.00300755184774948,0.214880772146556,-0.52712200194421,
  -1.57190629568316e-06,-0.00283023151645811,0.225586502304018,-0.558971850226627,
  -1.58840918262904e-06,-0.00265291118516719,0.23629223246148,-0.590821698509044,
  -1.60491206857571e-06,-0.00247559085387472,0.246997962618943,-0.622671546791461,
  -1.62141495629875e-06,-0.00229827052258491,0.257703692776405,-0.654521395073878,
  -1.63791784313361e-06,-0.00212095019129332,0.268409422933868,-0.686371243356294,
  -1.65442072952438e-06,-0.00194362986000129,0.279115153091331,-0.718221091638711,
  -1.67092361624821e-06,-0.00176630952871015,0.289820883248793,-0.750070939921128,
  -1.68742650341613e-06,-0.00158898919741945,0.300526613406255,-0.781920788203545,
  -1.70392938947383e-06,-0.00141166886612698,0.311232343563717,-0.813770636485961,
  -9.47073127297027e-07,-0.00565136763978538,0.0542230332692654,-0.0494382805648794,
  -9.57627861980503e-07,-0.00548237840085608,0.0648669343832368,-0.0813255469420803,
  -9.68182596622347e-07,-0.00531338916192675,0.0755108354972083,-0.113212813319281,
  -9.78737331208679e-07,-0.0051443999229972,0.0861547366111798,-0.145100079696482,
  -9.89292066044811e-07,-0.00497541068406815,0.0967986377251512,-0.176987346073683,
  -9.9984680046461e-07,-0.00480642144513843,0.107442538839123,-0.208874612450884,
  -1.01040153527299e-06,-0.00463743220620916,0.118086439953094,-0.240761878828085,
  -1.02095626985932e-06,-0.00446844296728,0.128730341067066,-0.272649145205286,
  -1.03151100444565e-06,-0.0042994537283505,0.139374242181037,-0.304536411582487,
  -1.04206573919852e-06,-0.00413046448942134,0.150018143295009,-0.336423677959688,
  -1.05262047372934e-06,-0.00396147525049195,0.16066204440898,-0.368310944336889,
  -1.06317520870425e-06,-0.00379248601156279,0.171305945522952,-0.40019821071409,
  -1.07372994306854e-06,-0.00362349677263296,0.181949846636923,-0.432085477091291,
  -1.08428467815447e-06,-0.00345450753370447,0.192593747750894,-0.463972743468491,
  -1.09483941246324e-06,-0.00328551829477419,0.203237648864866,-0.495860009845692,
  -1.10539414710509e-06,-0.00311652905584503,0.213881549978837,-0.527747276222893,
  -1.11594888219102e-06,-0.00294753981691631,0.224525451092809,-0.559634542600094,
  -1.12650361661082e-06,-0.0027785505779867,0.23516935220678,-0.591521808977295,
  -1.13705835136368e-06,-0.00260956133905776,0.245813253320751,-0.623409075354496,
  -1.14761308589451e-06,-0.00244057210012771,0.256457154434723,-0.655296341731697,
  -1.15816781998124e-06,-0.00227158286119788,0.267101055548695,-0.687183608108898,
  -1.16872255540024e-06,-0.00210259362226939,0.277744956662666,-0.719070874486099,
  -1.17927728982004e-06,-0.00193360438333956,0.288388857776638,-0.7509581408633,
  -1.18983202446188e-06,-0.00176461514441062,0.299032758890609,-0.782845407240501,
  -1.20038675943679e-06,-0.00159562590548079,0.309676660004581,-0.814732673617702,
  -6.83342537374787e-07,-0.00563975911363324,0.0541705732794429,-0.0494849689807362,
  -6.90221258703438e-07,-0.00547688257234463,0.0647693169974282,-0.0813995308827608,
  -6.97099980240257e-07,-0.0053140060310562,0.0753680607154135,-0.113314092784785,
  -7.03978701527275e-07,-0.00515112948976748,0.0859668044333988,-0.14522865468681,
  -7.10857422925315e-07,-0.00498825294847893,0.0965655481513841,-0.177143216588835,
  -7.17736144240089e-07,-0.00482537640719016,0.107164291869369,-0.209057778490859,
  -7.24614865721396e-07,-0.00466249986590173,0.117763035587355,-0.240972340392884,
  -7.31493587258214e-07,-0.00449962332461329,0.12836177930534,-0.272886902294908,
  -7.38372308461965e-07,-0.00433674678332441,0.138960523023326,-0.304801464196933,
  -7.45251029887761e-07,-0.00417387024203575,0.149559266741311,-0.336716026098957,
  -7.52129751424579e-07,-0.00401099370074776,0.160158010459296,-0.368630588000982,
  -7.59008472850375e-07,-0.00384811715945865,0.170756754177282,-0.400545149903006,
  -7.65887194442705e-07,-0.00368524061817066,0.181355497895267,-0.432459711805031,
  -7.72765915590945e-07,-0.00352236407688133,0.191954241613252,-0.464374273707056,
  -7.79644637072252e-07,-0.00335948753559312,0.202552985331237,-0.49628883560908,
  -7.86523358553559e-07,-0.00319661099430468,0.213151729049223,-0.528203397511105,
  -7.93402079701799e-07,-0.0030337344530158,0.223750472767208,-0.560117959413129,
  -8.00280800850039e-07,-0.00287085791172692,0.234349216485193,-0.592032521315154,
  -8.07159522664413e-07,-0.00270798137043915,0.244947960203178,-0.623947083217179,
  -8.14038243812654e-07,-0.00254510482915027,0.255546703921164,-0.655861645119203,
  -8.20916965182938e-07,-0.00238222828786183,0.266145447639149,-0.687776207021227,
  -8.27795686775268e-07,-0.00221935174657339,0.276744191357134,-0.719690768923252,
  -8.3467440803453e-07,-0.00205647520528451,0.28734293507512,-0.751605330825277,
  -8.41553129293793e-07,-0.00189359866399519,0.297941678793106,-0.783519892727301,
  -8.48431850664078e-07,-0.00173072212270675,0.308540422511091,-0.815434454629326,
  -3.3514362659734e-05,-0.0075725860829095,0.0705082317074798,-0.0559502033100555,
  -3.70593347697179e-05,-0.00689924795748276,0.0859184038549559,-0.0839782955458044,
  -4.06043068797157e-05,-0.00622590983205606,0.101328576002432,-0.112006387781553,
  -4.41492789896025e-05,-0.00555257170662915,0.116738748149908,-0.140034480017302,
  -4.76942510996559e-05,-0.00487923358120257,0.132148920297384,-0.168062572253051,
  -5.12392232097092e-05,-0.00420589545577577,0.147559092444861,-0.1960906644888,
  -5.47841953195682e-05,-0.00353255733034896,0.162969264592337,-0.224118756724549,
  -5.83291674295383e-05,-0.00285921920492205,0.178379436739813,-0.252146848960298,
  -6.18741395396749e-05,-0.00218588107949558,0.193789608887289,-0.280174941196047,
  -6.5419111649756e-05,-0.00151254295406877,0.209199781034765,-0.308203033431796,
  -6.89640837596706e-05,-0.000839204828642082,0.224609953182241,-0.336231125667544,
  -7.25090558696961e-05,-0.000165866703215611,0.240020125329717,-0.364259217903294,
  -7.60540279799993e-05,0.000507471422210637,0.255430297477193,-0.392287310139042,
  -7.95990000896918e-05,0.00118080954763777,0.270840469624669,-0.420315402374791,
  -8.31439721994398e-05,0.00185414767306469,0.286250641772146,-0.44834349461054,
  -8.66889443094099e-05,0.00252748579849182,0.301660813919622,-0.476371586846289,
  -9.0233916419713e-05,0.00320082392391807,0.317070986067098,-0.504399679082038,
  -9.37788885297941e-05,0.00387416204934476,0.332481158214574,-0.532427771317787,
  -9.73238606397642e-05,0.00454750017477124,0.34789133036205,-0.560455863553536,
  -0.000100868832749956,0.00522083830019771,0.363301502509526,-0.588483955789285,
  -0.000104413804859926,0.00589417642562484,0.378711674657003,-0.616512048025034,
  -0.000107958776969341,0.00656751455105198,0.394121846804478,-0.644540140260783,
  -0.000111503749079644,0.00724085267647823,0.409532018951954,-0.672568232496531,
  -0.000115048721189059,0.00791419080190581,0.424942191099431,-0.70059632473228,
  -0.000118593693299585,0.00858752892733206,0.440352363246907,-0.728624416968029,
  -3.333330835599e-05,-0.0075574823956483,0.0704671679721499,-0.0559929789484191,
  -3.68423786739347e-05,-0.00688598867887147,0.0858488136336203,-0.0840407260669521,
  -4.03514489917822e-05,-0.00621449496209442,0.101230459295091,-0.112088473185485,
  -4.3860519309713e-05,-0.00554300124531759,0.116612104956561,-0.140136220304018,
  -4.73695896275605e-05,-0.0048715075285406,0.131993750618032,-0.168183967422551,
  -5.08786599457411e-05,-0.00420001381176405,0.147375396279502,-0.196231714541084,
  -5.43877302634499e-05,-0.00352852009498683,0.162757041940973,-0.224279461659616,
  -5.78968005812697e-05,-0.00285702637820995,0.178138687602443,-0.252327208778149,
  -6.14058708990894e-05,-0.00218553266143273,0.193520333263914,-0.280374955896682,
  -6.49149412169647e-05,-0.00151403894465574,0.208901978925384,-0.308422703015215,
  -6.84240115350621e-05,-0.000842545227879077,0.224283624586855,-0.336470450133748,
  -7.19330818528818e-05,-0.000171051511102194,0.239665270248325,-0.364518197252281,
  -7.54421521707571e-05,0.000500442205674689,0.255046915909795,-0.392565944370814,
  -7.89512224884659e-05,0.00117193592245157,0.270428561571266,-0.420613691489347,
  -8.24602928068963e-05,0.00184342963922846,0.285810207232737,-0.44866143860788,
  -8.59693631239944e-05,0.002514923356006,0.301191852894207,-0.476709185726412,
  -8.94784334426468e-05,0.003186417072782,0.316573498555677,-0.504756932844945,
  -9.2987503759856e-05,0.00385791078955977,0.331955144217148,-0.532804679963478,
  -9.64965740780643e-05,0.00452940450633643,0.347336789878618,-0.560852427082011,
  -0.000100005644396273,0.00520089822311309,0.362718435540089,-0.588900174200544,
  -0.000103514714713704,0.00587239193989086,0.37810008120156,-0.616947921319077,
  -0.000107023785032134,0.00654388565666641,0.39348172686303,-0.64499566843761,
  -0.000110532855349676,0.0072153793734433,0.408863372524499,-0.673043415556143,
  -0.000114041925667885,0.00788687309022063,0.42424501818597,-0.701091162674675,
  -0.000117550995985538,0.00855836680699795,0.439626663847441,-0.729138909793208,
  -3.30832550226173e-05,-0.00753669825446041,0.0704104381983693,-0.0560519828707818,
  -3.65430231690222e-05,-0.00686777374934983,0.0857526948780803,-0.0841268415701629,
  -4.000279131533e-05,-0.00619884924423908,0.101094951557791,-0.112201700269544,
  -4.34625594617211e-05,-0.00552992473912817,0.116437208237503,-0.140276558968925,
  -4.69223276080011e-05,-0.00486100023401725,0.131779464917214,-0.168351417668306,
  -5.03820957543089e-05,-0.00419207572890667,0.147121721596925,-0.196426276367687,
  -5.38418639008387e-05,-0.00352315122379609,0.162463978276636,-0.224501135067069,
  -5.73016320471464e-05,-0.00285422671868507,0.177806234956347,-0.25257599376645,
  -6.07614001935652e-05,-0.00218530221357449,0.193148491636058,-0.280650852465831,
  -6.4221168339762e-05,-0.00151637770846347,0.20849074831577,-0.308725711165212,
  -6.76809364861253e-05,-0.000847453203352666,0.223833004995481,-0.336800569864593,
  -7.11407046325441e-05,-0.000178528698242086,0.239175261675192,-0.364875428563974,
  -7.46004727790184e-05,0.000490395806868493,0.254517518354903,-0.392950287263355,
  -7.80602409253817e-05,0.00115932031197952,0.269859775034614,-0.421025145962736,
  -8.15200090716894e-05,0.00182824481708965,0.285202031714325,-0.449100004662118,
  -8.49797772181082e-05,0.0024971693222009,0.300544288394037,-0.477174863361499,
  -8.84395453648601e-05,0.00316609382731103,0.315886545073747,-0.50524972206088,
  -9.18993135107238e-05,0.0038350183324225,0.331228801753459,-0.533324580760261,
  -9.53590816573646e-05,0.00450394283753242,0.346571058433169,-0.561399439459642,
  -9.88188498034503e-05,0.00517286734264366,0.361913315112881,-0.589474298159023,
  -0.000102278617949647,0.00584179184775513,0.377255571792592,-0.617549156858404,
  -0.000105738386096843,0.0065107163528646,0.392597828472303,-0.645624015557786,
  -0.000109198154242707,0.00717964085797629,0.407940085152015,-0.673698874257166,
  -0.000112657922388903,0.00784856536308709,0.423282341831726,-0.701773732956547,
  -0.000116117690535544,0.008517489868197,0.438624598511436,-0.729848591655929,
  -3.27396342828523e-05,-0.00750827923529929,0.0703324492112678,-0.0561329271165876,
  -3.61321854839003e-05,-0.00684292659055397,0.0856205947112607,-0.0842449787071612,
  -3.95247366848095e-05,-0.00617757394580842,0.100908740211254,-0.112357030297735,
  -4.29172878858297e-05,-0.00551222130106288,0.116196885711247,-0.140469081888308,
  -4.63098390867112e-05,-0.00484686865631734,0.13148503121124,-0.168581133478882,
  -4.97023902876204e-05,-0.0041815160115718,0.146773176711233,-0.196693185069456,
  -5.30949414886961e-05,-0.00351616336682647,0.162061322211226,-0.224805236660029,
  -5.64874926897718e-05,-0.00285081072208104,0.177349467711219,-0.252917288250603,
  -5.988004389057e-05,-0.00218545807733528,0.192637613211212,-0.281029339841177,
  -6.32725950913682e-05,-0.00152010543258974,0.207925758711205,-0.30914139143175,
  -6.66651462923329e-05,-0.000854752787844193,0.223213904211198,-0.337253443022324,
  -7.00576974934086e-05,-0.00018940014309865,0.238502049711191,-0.365365494612897,
  -7.34502486943733e-05,0.00047595250164667,0.253790195211184,-0.393477546203471,
  -7.68427998953936e-05,0.00114130514639199,0.269078340711177,-0.421589597794045,
  -8.02353510961362e-05,0.00180665779113798,0.28436648621117,-0.449701649384618,
  -8.3627902297323e-05,0.00247201043588285,0.299654631711162,-0.477813700975192,
  -8.70204534980656e-05,0.00313736308062862,0.314942777211155,-0.505925752565766,
  -9.04130046994744e-05,0.00380271572537372,0.330230922711148,-0.534037804156339,
  -9.3805555899884e-05,0.00446806837012015,0.345519068211142,-0.562149855746913,
  -9.71981071011818e-05,0.00513342101486525,0.360807213711135,-0.590261907337486,
  -0.000100590658302147,0.00579877365961101,0.376095359211128,-0.61837395892806,
  -0.000103983209503222,0.00646412630435611,0.391383504711121,-0.646486010518634,
  -0.000107375760704298,0.00712947894910121,0.406671650211113,-0.674598062109207,
  -0.000110768311905263,0.0077948315938472,0.421959795711107,-0.702710113699781,
  -0.000114160863106005,0.00846018423859274,0.437247941211099,-0.730822165290354,
  -3.22706733916212e-05,-0.00746975853033011,0.0702259546872205,-0.0562431394968078,
  -3.55724877529606e-05,-0.00680935727376503,0.0854402826847812,-0.0844058323284578,
  -3.88743021142446e-05,-0.00614895601719984,0.100654610682342,-0.112568525160108,
  -4.21761164756396e-05,-0.00548855476063481,0.115868938679903,-0.140731217991758,
  -4.54779308367292e-05,-0.00482815350406929,0.131083266677464,-0.168893910823408,
  -4.87797451983463e-05,-0.00416775224750454,0.146297594675024,-0.197056603655058,
  -5.2081559559658e-05,-0.00350735099093957,0.161511922672585,-0.225219296486708,
  -5.53833739207477e-05,-0.00284694973437394,0.176726250670146,-0.253381989318358,
  -5.86851882821704e-05,-0.00218654847780897,0.191940578667706,-0.281544682150008,
  -6.19870026434821e-05,-0.001526147221244,0.207154906665267,-0.309707374981658,
  -6.52888170046828e-05,-0.000865745964678588,0.222369234662828,-0.337870067813308,
  -6.859063136605e-05,-0.000205344708113619,0.237583562660389,-0.366032760644958,
  -7.18924457273618e-05,0.000455056548451571,0.252797890657949,-0.394195453476608,
  -7.51942600885069e-05,0.00111545780501676,0.26801221865551,-0.422358146308258,
  -7.84960744497631e-05,0.00177585906158217,0.283226546653071,-0.450520839139908,
  -8.17978888113524e-05,0.00243626031814737,0.298440874650632,-0.478683531971558,
  -8.50997031728307e-05,0.00309666157471211,0.313655202648192,-0.506846224803208,
  -8.84015175338648e-05,0.00375706283127752,0.328869530645753,-0.535008917634858,
  -9.17033318954541e-05,0.00441746408784205,0.344083858643313,-0.563171610466508,
  -9.50051462561552e-05,0.00507786534440791,0.359298186640874,-0.591334303298158,
  -9.83069606179665e-05,0.00573826660097243,0.374512514638435,-0.619496996129808,
  -0.000101608774979334,0.00639866785753762,0.389726842635996,-0.647659688961458,
  -0.000104910589340035,0.0070590691141037,0.404941170633557,-0.675822381793108,
  -0.000108212403701069,0.00771947037066933,0.420155498631118,-0.703985074624758,
  -0.000111514218062658,0.00837987162723364,0.435369826628678,-0.732147767456408,
  -3.1636631266832e-05,-0.00741816005590101,0.0700818680436263,-0.0563916786934148,
  -3.48176043722948e-05,-0.00676459267663321,0.0851964517058617,-0.0846226234696252,
  -3.79985774777991e-05,-0.00611102529736535,0.100311035368097,-0.112853568245836,
  -4.11795505834145e-05,-0.0054574579180976,0.115425619030333,-0.141084513022046,
  -4.43605236890021e-05,-0.0048038905388299,0.130540202692568,-0.169315457798256,
  -4.75414967944232e-05,-0.00415032315956199,0.145654786354803,-0.197546402574467,
  -5.07224699000108e-05,-0.00349675578029429,0.160769370017039,-0.225777347350677,
  -5.39034430053764e-05,-0.00284318840102626,0.175883953679274,-0.254008292126888,
  -5.70844161110196e-05,-0.00218962102175879,0.19099853734151,-0.282239236903098,
  -6.02653892162741e-05,-0.00153605364249043,0.206113121003745,-0.310470181679309,
  -6.34463623219728e-05,-0.000882486263222848,0.221227704665981,-0.338701126455519,
  -6.66273354276159e-05,-0.000228918883955043,0.236342288328216,-0.366932071231729,
  -6.98083085332035e-05,0.000424648495312541,0.251456871990452,-0.39516301600794,
  -7.29892816384581e-05,0.00107821587458079,0.266571455652687,-0.42339396078415,
  -7.61702547442678e-05,0.00173178325384793,0.281686039314922,-0.451624905560361,
  -7.93512278496333e-05,0.00238535063311596,0.296800622977158,-0.479855850336571,
  -8.25322009547769e-05,0.00303891801238443,0.311915206639394,-0.508086795112782,
  -8.57131740604755e-05,0.00369248539165201,0.327029790301629,-0.536317739888992,
  -8.88941471662852e-05,0.00434605277091893,0.342144373963864,-0.564548684665202,
  -9.20751202717618e-05,0.0049996201501874,0.3572589576261,-0.592779629441413,
  -9.52560933771274e-05,0.00565318752945476,0.372373541288335,-0.621010574217623,
  -9.8437066482604e-05,0.00630675490872301,0.38748812495057,-0.649241518993834,
  -0.000101618039588303,0.00696032228798993,0.402602708612805,-0.677472463770044,
  -0.00010479901269389,0.00761388966725818,0.417717292275041,-0.705703408546255,
  -0.000107979985799145,0.00826745704652598,0.432831875937276,-0.733934353322465,
  -3.07901906400759e-05,-0.00735013236564763,0.069889331386681,-0.0565891421576789,
  -3.38131421663279e-05,-0.00670593545475512,0.0848708620399048,-0.084910818981211,
  -3.68360936923717e-05,-0.00606173854386244,0.0998523926931286,-0.113232495804743,
  -3.98590452185543e-05,-0.00541754163296981,0.114833923346352,-0.141554172628275,
  -4.28819967447092e-05,-0.00477334472207724,0.129815453999576,-0.169875849451807,
  -4.59049482707807e-05,-0.00412914781118445,0.1447969846528,-0.198197526275339,
  -4.89278997967135e-05,-0.00348495090029144,0.159778515306024,-0.226519203098871,
  -5.19508513228129e-05,-0.00284075398939898,0.174760045959248,-0.254840879922404,
  -5.49738028493008e-05,-0.00219655707850663,0.189741576612472,-0.283162556745936,
  -5.79967543752336e-05,-0.00155236016761373,0.204723107265696,-0.311484233569468,
  -6.10197059012219e-05,-0.000908163256721162,0.219704637918919,-0.339805910393,
  -6.40426574273767e-05,-0.000263966345828148,0.234686168572143,-0.368127587216532,
  -6.70656089534205e-05,0.000380230565064421,0.249667699225367,-0.396449264040064,
  -7.00885604794088e-05,0.00102442747595721,0.264649229878591,-0.424770940863596,
  -7.31115120059522e-05,0.00166862438684956,0.279630760531815,-0.453092617687128,
  -7.61344635320516e-05,0.00231282129774213,0.294612291185038,-0.48141429451066,
  -7.91574150580399e-05,0.00295701820863514,0.309593821838263,-0.509735971334192,
  -8.21803665839171e-05,0.00360121511952816,0.324575352491487,-0.538057648157724,
  -8.52033181101275e-05,0.00424541203042028,0.33955688314471,-0.566379324981257,
  -8.82262696358938e-05,0.00488960894131352,0.354538413797934,-0.594701001804789,
  -9.12492211627702e-05,0.0055338058522052,0.369519944451157,-0.623022678628321,
  -9.42721726887585e-05,0.00617800276309843,0.384501475104382,-0.651344355451853,
  -9.72951242149689e-05,0.00682219967399034,0.399483005757605,-0.679666032275385,
  -0.000100318075741401,0.00746639658488268,0.414464536410829,-0.707987709098917,
  -0.000103341027266945,0.00811059349577636,0.429446067064053,-0.736309385922449,
  -2.96791214308423e-05,-0.00726230382292048,0.069636295537153,-0.0568469051328679,
  -3.25003998211115e-05,-0.00663082998881531,0.084443359670137,-0.0852870208916724,
  -3.53216782112142e-05,-0.00599935615470987,0.0992504238031211,-0.113727136650477,
  -3.81429566014557e-05,-0.00536788232060459,0.114057487936105,-0.142167252409281,
  -4.09642349917527e-05,-0.00473640848649948,0.128864552069089,-0.170607368168086,
  -4.37855133817444e-05,-0.00410493465239392,0.143671616202073,-0.19904748392689,
  -4.66067917720969e-05,-0.0034734608182887,0.158478680335057,-0.227487599685694,
  -4.94280701623384e-05,-0.00284198698418359,0.173285744468041,-0.255927715444499,
  -5.22493485525799e-05,-0.00221051315007847,0.188092808601025,-0.284367831203303,
  -5.50706269425993e-05,-0.00157903931597292,0.202899872734009,-0.312807946962108,
  -5.78919053328963e-05,-0.000947565481867807,0.217706936866993,-0.341248062720912,
  -6.07131837232489e-05,-0.000316091647762695,0.232514000999977,-0.369688178479717,
  -6.35344621134348e-05,0.000315382186342417,0.247321065132961,-0.398128294238521,
  -6.63557405037318e-05,0.000946856020447751,0.262128129265945,-0.426568409997325,
  -6.91770188938623e-05,0.00157832985455308,0.276935193398929,-0.45500852575613,
  -7.19982972839928e-05,0.00220980368865842,0.291742257531913,-0.483448641514934,
  -7.48195756743453e-05,0.00284127752276397,0.306549321664898,-0.511888757273739,
  -7.76408540641427e-05,0.00347275135686909,0.321356385797881,-0.540328873032543,
  -8.04621324547172e-05,0.00410422519097398,0.336163449930865,-0.568768988791347,
  -8.32834108451808e-05,0.00473569902507931,0.350970514063849,-0.597209104550152,
  -8.61046892349782e-05,0.00536717285918487,0.365777578196833,-0.625649220308956,
  -8.89259676255527e-05,0.00599864669328953,0.380584642329817,-0.654089336067761,
  -9.17472460152391e-05,0.00663012052739598,0.395391706462802,-0.682529451826565,
  -9.45685244054806e-05,0.00726159436150109,0.410198770595786,-0.710969567585369,
  -9.7389802795389e-05,0.0078930681956062,0.42500583472877,-0.739409683344174,
  -2.82525934522937e-05,-0.00715194177284662,0.0693109329894528,-0.0571754954885706,
  -3.08245652365924e-05,-0.00653749439738832,0.0838943054360859,-0.0857665944979433,
  -3.33965370209466e-05,-0.00592304702193008,0.0984776778827189,-0.114357693507316,
  -3.59685088051898e-05,-0.00530859964647179,0.113061050329352,-0.142948792516689,
  -3.85404805894607e-05,-0.00469415227101333,0.127644422775985,-0.171539891526061,
  -4.11124523739259e-05,-0.00407970489555531,0.142227795222618,-0.200130990535434,
  -4.36844241581413e-05,-0.00346525752009674,0.156811167669251,-0.228722089544807,
  -4.62563959423568e-05,-0.00285081014463839,0.171394540115884,-0.257313188554179,
  -4.88283677266832e-05,-0.00223636276918016,0.185977912562517,-0.285904287563552,
  -5.14003395112317e-05,-0.00162191539372225,0.20056128500915,-0.314495386572925,
  -5.3972311295003e-05,-0.00100746801826301,0.215144657455784,-0.343086485582297,
  -5.6544283079607e-05,-0.000393020642805331,0.229728029902416,-0.37167758459167,
  -5.91162548638779e-05,0.000221426732653018,0.24431140234905,-0.400268683601043,
  -6.16882266483154e-05,0.000835874108110923,0.258894774795682,-0.428859782610415,
  -6.42601984326419e-05,0.00145032148356949,0.273478147242316,-0.457450881619788,
  -6.68321702171903e-05,0.0020647688590274,0.288061519688949,-0.48604198062916,
  -6.94041420009617e-05,0.00267921623448619,0.302644892135582,-0.514633079638533,
  -7.19761137853991e-05,0.00329366360994454,0.317228264582215,-0.543224178647906,
  -7.45480855695035e-05,0.00390811098540333,0.331811637028848,-0.571815277657278,
  -7.7120057354052e-05,0.0045225583608608,0.346395009475481,-0.600406376666651,
  -7.96920291383785e-05,0.00513700573631937,0.360978381922114,-0.628997475676024,
  -8.22640009228159e-05,0.00575145311177749,0.375561754368747,-0.657588574685396,
  -8.48359727069203e-05,0.00636590048723606,0.39014512681538,-0.686179673694769,
  -8.74079444912468e-05,0.00698034786269464,0.404728499262014,-0.714770772704142,
  -8.99799162754622e-05,0.00759479523815232,0.419311871708646,-0.743361871713514,
  -2.64721851737232e-05,-0.0070179164517512,0.0689041417036613,-0.0575819404777743,
  -2.87482984059895e-05,-0.00642578341161415,0.0832088283563476,-0.0863597959898322,
  -3.10244116382419e-05,-0.00583365037147698,0.097513515009034,-0.11513765150189,
  -3.3300524870522e-05,-0.00524151733133993,0.11181820166172,-0.143915507013948,
  -3.55766381028022e-05,-0.00464938429120298,0.126122888314407,-0.172693362526006,
  -3.78527513352211e-05,-0.00405725125106604,0.140427574967093,-0.201471218038064,
  -4.01288645674458e-05,-0.00346511821092899,0.154732261619779,-0.230249073550122,
  -4.24049777996149e-05,-0.00287298517079182,0.169036948272466,-0.25902692906218,
  -4.46810910320616e-05,-0.00228085213065476,0.183341634925152,-0.287804784574238,
  -4.69572042641198e-05,-0.00168871909051749,0.197646321577838,-0.316582640086295,
  -4.92333174964554e-05,-0.00109658605038065,0.211951008230525,-0.345360495598353,
  -5.15094307287911e-05,-0.000504453010243378,0.226255694883211,-0.374138351110411,
  -5.37855439609602e-05,8.76800298934555e-05,0.240560381535897,-0.402916206622469,
  -5.60616571932959e-05,0.000679813070030511,0.254865068188584,-0.431694062134527,
  -5.83377704252985e-05,0.00127194611016801,0.26916975484127,-0.460471917646585,
  -6.06138836576342e-05,0.00186407915030484,0.283474441493956,-0.489249773158643,
  -6.28899968900809e-05,0.0024562121904419,0.297779128146643,-0.518027628670701,
  -6.51661101224166e-05,0.00304834523057895,0.312083814799329,-0.546805484182759,
  -6.74422233547523e-05,0.00364047827071601,0.326388501452016,-0.575583339694817,
  -6.97183365870879e-05,0.00423261131085262,0.340693188104702,-0.604361195206875,
  -7.19944498192016e-05,0.0048247443509899,0.354997874757388,-0.633139050718933,
  -7.42705630510931e-05,0.00541687739112762,0.369302561410074,-0.661916906230991,
  -7.65466762836509e-05,0.00600901043126445,0.383607248062761,-0.690694761743048,
  -7.88227895160976e-05,0.00660114347140084,0.397911934715447,-0.719472617255106,
  -8.10989027478781e-05,0.007193276511539,0.412216621368134,-0.748250472767164,
  -2.43270513372168e-05,-0.00686177910283986,0.068413046531941,-0.0580663554092568,
  -2.62694646791517e-05,-0.00629805522500304,0.0823827061525363,-0.0870667936590905,
  -2.82118780211282e-05,-0.00573433134716617,0.0963523657731316,-0.116067231908924,
  -3.0154291363188e-05,-0.00517060746932951,0.110322025393727,-0.145067670158758,
  -3.20967047051368e-05,-0.00460688359149253,0.124291685014322,-0.174068108408592,
  -3.40391180468913e-05,-0.00404315971365532,0.138261344634918,-0.203068546658425,
  -3.59815313890066e-05,-0.00347943583581889,0.152231004255513,-0.232068984908259,
  -3.79239447310109e-05,-0.00291571195798201,0.166200663876108,-0.261069423158093,
  -3.98663580730152e-05,-0.00235198808014525,0.180170323496703,-0.290069861407926,
  -4.1808771414853e-05,-0.00178826420230815,0.194139983117299,-0.31907029965776,
  -4.37511847566907e-05,-0.00122454032447106,0.208109642737894,-0.348070737907594,
  -4.56935980990836e-05,-0.000660816446634849,0.222079302358489,-0.377071176157428,
  -4.76360114404217e-05,-9.70925687970858e-05,0.236048961979085,-0.406071614407261,
  -4.95784247825926e-05,0.000466631309038901,0.25001862159968,-0.435072052657095,
  -5.15208381246524e-05,0.001030355186876,0.263988281220275,-0.464072490906929,
  -5.34632514666011e-05,0.00159407906471287,0.277957940840871,-0.493072929156762,
  -5.54056648083279e-05,0.00215780294254997,0.291927600461466,-0.522073367406596,
  -5.73480781503877e-05,0.00272152682038662,0.305897260082061,-0.55107380565643,
  -5.92904914925585e-05,0.00328525069822305,0.319866919702656,-0.580074243906263,
  -6.12329048340632e-05,0.00384897457606082,0.333836579323252,-0.609074682156097,
  -6.3175318176012e-05,0.00441269845389725,0.347806238943847,-0.638075120405931,
  -6.51177315182938e-05,0.00497642233173368,0.361775898564442,-0.667075558655764,
  -6.70601448604646e-05,0.00554014620957055,0.375745558185038,-0.696075996905598,
  -6.90025582023024e-05,0.00610387008740787,0.389715217805634,-0.725076435155432,
  -7.09449715440291e-05,0.00666759396524519,0.403684877426229,-0.754076873405265,
  -2.1849580899666e-05,-0.00668850940268417,0.0678446826992698,-0.0586187823892984,
  -2.34379189397171e-05,-0.00615959626440699,0.0814284550167798,-0.0878730540815954,
  -2.50262569798099e-05,-0.00563068312612991,0.0950122273342897,-0.117127325773892,
  -2.66145950201524e-05,-0.00510176998785317,0.1085959996518,-0.14638159746619,
  -2.82029330602174e-05,-0.00457285684957609,0.122179771969309,-0.175635869158487,
  -2.97912711004766e-05,-0.00404394371129924,0.135763544286819,-0.204890140850784,
  -3.13796091405694e-05,-0.00351503057302227,0.149347316604329,-0.234144412543081,
  -3.296794718044e-05,-0.00298611743474475,0.162931088921839,-0.263398684235378,
  -3.45562852205883e-05,-0.00245720429646812,0.176514861239349,-0.292652955927675,
  -3.61446232608476e-05,-0.00192829115819082,0.190098633556859,-0.321907227619972,
  -3.77329613007737e-05,-0.00139937801991397,0.203682405874369,-0.351161499312269,
  -3.9321299341144e-05,-0.000870464881637334,0.217266178191878,-0.380415771004566,
  -4.09096373811813e-05,-0.000341551743359592,0.230849950509389,-0.409670042696863,
  -4.24979754214405e-05,0.000187361394917041,0.244433722826898,-0.43892431438916,
  -4.40863134615332e-05,0.000716274533194117,0.258017495144408,-0.468178586081457,
  -4.56746515014039e-05,0.00124518767147119,0.271601267461918,-0.497432857773754,
  -4.72629895422738e-05,0.00177410080974738,0.285185039779428,-0.526687129466051,
  -4.88513275819225e-05,0.0023030139480249,0.298768812096938,-0.555941401158348,
  -5.04396656219042e-05,0.00283192708630242,0.312352584414448,-0.585195672850645,
  -5.20280036628851e-05,0.00336084022457817,0.325936356731957,-0.614449944542942,
  -5.36163417024227e-05,0.00388975336285613,0.339520129049468,-0.643704216235239,
  -5.52046797419603e-05,0.00441866650113365,0.353103901366978,-0.672958487927536,
  -5.67930177822751e-05,0.00494757963941028,0.366687673684487,-0.702212759619833,
  -5.83813558223678e-05,0.00547649277768736,0.380271446001997,-0.73146703131213,
  -5.99696938625716e-05,0.00600540591596443,0.393855218319507,-0.760721303004427,
  -1.91243824914644e-05,-0.00650636573407587,0.0672182056732137,-0.0592179528773268,
  -2.03625594114853e-05,-0.0060181223875741,0.0803788342890195,-0.0887475360824455,
  -2.16007363314508e-05,-0.00552987904107211,0.0935394629048256,-0.118277119287564,
  -2.28389132516105e-05,-0.0050416356945705,0.106700091520631,-0.147806702492683,
  -2.40770901714094e-05,-0.00455339234806851,0.119860720136437,-0.177336285697801,
  -2.53152670914858e-05,-0.00406514900156663,0.133021348752243,-0.20686586890292,
  -2.65534440115345e-05,-0.00357690565506497,0.146181977368049,-0.236395452108039,
  -2.77916209314721e-05,-0.00308866230856297,0.159342605983855,-0.265925035313157,
  -2.90297978514098e-05,-0.0026004189620612,0.172503234599661,-0.295454618518276,
  -3.02679747713475e-05,-0.00211217561555932,0.185663863215467,-0.324984201723395,
  -3.15061516915072e-05,-0.00162393226905766,0.198824491831273,-0.354513784928513,
  -3.27443286112783e-05,-0.00113568892255556,0.211985120447079,-0.384043368133632,
  -3.39825055314935e-05,-0.000647445576053673,0.225145749062885,-0.41357295133875,
  -3.52206824517642e-05,-0.000159202229552458,0.23830637767869,-0.443102534543869,
  -3.64588593716464e-05,0.000329041116949202,0.251467006294496,-0.472632117748988,
  -3.76970362911955e-05,0.000817284463451973,0.264627634910302,-0.502161700954106,
  -3.89352132111886e-05,0.00130552780995385,0.277788263526108,-0.531691284159225,
  -4.01733901316259e-05,0.00179377115645463,0.290948892141913,-0.561220867364343,
  -4.14115670515081e-05,0.00228201450295673,0.30410952075772,-0.590750450569462,
  -4.26497439706131e-05,0.00277025784946039,0.317270149373526,-0.620280033774581,
  -4.38879208914944e-05,0.00325850119596049,0.330430777989332,-0.649809616979699,
  -4.51260978113766e-05,0.00374674454246238,0.343591406605137,-0.679339200184818,
  -4.63642747311477e-05,0.00423498788896515,0.356752035220944,-0.708868783389936,
  -4.76024516513629e-05,0.00472323123546659,0.36991266383675,-0.738398366595055,
  -4.8840628571134e-05,0.00521147458196847,0.383073292452556,-0.767927949800174,
  -1.62827888009337e-05,-0.00632553980067685,0.0665637631324394,-0.0598334842902082,
  -1.7200413722579e-05,-0.00588224182507047,0.0792847041431977,-0.0896458966530631,
  -1.81180386441271e-05,-0.00543894384946414,0.0920056451539559,-0.119458309015918,
  -1.90356635656475e-05,-0.00499564587385748,0.104726586164714,-0.149270721378773,
  -1.99532884871956e-05,-0.00455234789825099,0.117447527175473,-0.179083133741628,
  -2.08709134089102e-05,-0.00410904992264494,0.130168468186231,-0.208895546104483,
  -2.17885383304584e-05,-0.00366575194703833,0.142889409196989,-0.238707958467338,
  -2.2706163252062e-05,-0.00322245397143184,0.155610350207748,-0.268520370830193,
  -2.36237881734436e-05,-0.00277915599582523,0.168331291218506,-0.298332783193048,
  -2.45414130948807e-05,-0.00233585802021841,0.181052232229264,-0.328145195555903,
  -2.54590380165398e-05,-0.00189256004461225,0.193773173240023,-0.357957607918758,
  -2.6376662938199e-05,-0.00144926206900586,0.206494114250781,-0.387770020281613,
  -2.72942878601357e-05,-0.00100596409339992,0.219215055261539,-0.417582432644468,
  -2.82119127816838e-05,-0.000562666117793542,0.231935996272297,-0.447394845007323,
  -2.91295377027323e-05,-0.000119368142186493,0.244656937283056,-0.477207257370178,
  -3.0047162624558e-05,0.000323929833420111,0.257377878293814,-0.507019669733033,
  -3.09647875461616e-05,0.000767227809026272,0.270098819304572,-0.536832082095888,
  -3.18824124679873e-05,0.00121052578463199,0.28281976031533,-0.566644494458743,
  -3.28000373893689e-05,0.00165382376023926,0.295540701326089,-0.596456906821598,
  -3.37176623109725e-05,0.00209712173584542,0.308261642336847,-0.626269319184453,
  -3.46352872323541e-05,0.00254041971145202,0.320982583347605,-0.656081731547308,
  -3.55529121540687e-05,0.00298371768705818,0.333703524358364,-0.685894143910163,
  -3.64705370755614e-05,0.00342701566266523,0.346424465369122,-0.715706556273017,
  -3.7388161997165e-05,0.00387031363827139,0.35914540637988,-0.745518968635873,
  -3.83057869188796e-05,0.004313611613878,0.371866347390639,-0.775331380998727,
  -1.34803339186668e-05,-0.00615597225470871,0.0659173502755847,-0.0604315489745142,
  -1.41271488639794e-05,-0.00575942456010398,0.0782062369907426,-0.0905187647469017,
  -1.47739638092781e-05,-0.00536287686549913,0.0904951237059005,-0.120605980519289,
  -1.54207787546601e-05,-0.00496632917089457,0.102784010421058,-0.150693196291677,
  -1.60675936999588e-05,-0.00456978147628972,0.115072897136216,-0.180780412064064,
  -1.67144086452575e-05,-0.00417323378168499,0.127361783851374,-0.210867627836452,
  -1.73612235904175e-05,-0.00377668608708004,0.139650670566532,-0.240954843608839,
  -1.80080385359105e-05,-0.00338013839247553,0.15193955728169,-0.271042059381227,
  -1.86548534811815e-05,-0.00298359069787058,0.164228443996848,-0.301129275153614,
  -1.93016684266745e-05,-0.00258704300326595,0.176517330712006,-0.331216490926002,
  -1.99484833717234e-05,-0.00219049530866111,0.188806217427164,-0.361303706698389,
  -2.05952983170499e-05,-0.00179394761405627,0.201095104142321,-0.391390922470777,
  -2.12421132625429e-05,-0.00139739991945187,0.213383990857479,-0.421478138243164,
  -2.18889282079804e-05,-0.00100085222484747,0.225672877572637,-0.451565354015551,
  -2.25357431529183e-05,-0.000604304530242183,0.237961764287795,-0.481652569787939,
  -2.31825580980782e-05,-0.000207756835636896,0.250250651002953,-0.511739785560326,
  -2.38293730436823e-05,0.000188790858967502,0.262539537718111,-0.541827001332714,
  -2.44761879890643e-05,0.000585338553572123,0.274828424433269,-0.571914217105101,
  -2.51230029338911e-05,0.00098188624817741,0.287117311148427,-0.602001432877489,
  -2.57698178798282e-05,0.00137843394278114,0.299406197863584,-0.632088648649876,
  -2.64166328252102e-05,0.00177498163738621,0.311695084578743,-0.662175864422264,
  -2.70634477703702e-05,0.00217152933199083,0.3239839712939,-0.692263080194651,
  -2.77102627156411e-05,0.00256807702659545,0.336272858009058,-0.722350295967039,
  -2.8357077660579e-05,0.00296462472120052,0.348561744724216,-0.752437511739426,
  -2.9003892605739e-05,0.00336117241580602,0.360850631439374,-0.782524727511814,
  -1.08642086106003e-05,-0.00600526002682084,0.0653132268553835,-0.0609819924412029,
  -1.1299555561145e-05,-0.00565442974138458,0.0772002430266358,-0.0913221302559217,
  -1.17349025117452e-05,-0.00530359945594833,0.0890872591978881,-0.121662268070641,
  -1.2170249462401e-05,-0.00495276917051202,0.100974275369141,-0.152002405885359,
  -1.26055964130012e-05,-0.00460193888507576,0.112861291540393,-0.182342543700078,
  -1.30409433636292e-05,-0.00425110859963962,0.124748307711645,-0.212682681514797,
  -1.34762903140628e-05,-0.00390027831420325,0.136635323882897,-0.243022819329516,
  -1.39116372649406e-05,-0.00354944802876733,0.14852234005415,-0.273362957144235,
  -1.43469842153188e-05,-0.00319861774333075,0.160409356225402,-0.303703094958953,
  -1.47823311660855e-05,-0.00284778745789493,0.172296372396654,-0.334043232773672,
  -1.52176781165747e-05,-0.00249695717245846,0.184183388567907,-0.364383370588391,
  -1.56530250674525e-05,-0.00214612688702243,0.196070404739159,-0.39472350840311,
  -1.60883720179972e-05,-0.00179529660158639,0.207957420910411,-0.425063646217829,
  -1.65237189684309e-05,-0.0014444663161497,0.219844437081664,-0.455403784032547,
  -1.6959065918809e-05,-0.001093636030713,0.231731453252916,-0.485743921847266,
  -1.73944128696313e-05,-0.000742805745276964,0.243618469424169,-0.516084059661985,
  -1.78297598203425e-05,-0.000391975459841154,0.255505485595421,-0.546424197476704,
  -1.82651067707207e-05,-4.11451744044555e-05,0.267392501766673,-0.576764335291423,
  -1.8700453721654e-05,0.000309685111031133,0.279279517937925,-0.607104473106141,
  -1.9135800671366e-05,0.000660515396468053,0.291166534109177,-0.63744461092086,
  -1.95711476226323e-05,0.00101134568190409,0.30305355028043,-0.667784748735579,
  -2.00064945726774e-05,0.00136217596734101,0.314940566451682,-0.698124886550298,
  -2.04418415239438e-05,0.00171300625277615,0.326827582622934,-0.728465024365017,
  -2.08771884740999e-05,0.00206383653821307,0.338714598794187,-0.758805162179735,
  -2.13125354253663e-05,0.00241466682364866,0.350601614965439,-0.789145299994454,
  -8.54427901572641e-06,-0.00587753542442282,0.0647770877488557,-0.0614639088840356,
  -8.82605807289716e-06,-0.00556885248833594,0.0763089438781005,-0.0920254814115461,
  -9.1078371300124e-06,-0.00526016955224901,0.0878408000073453,-0.122587053939057,
  -9.38961618718315e-06,-0.00495148661616218,0.09937265613659,-0.153148626466567,
  -9.67139524427063e-06,-0.00464280368007497,0.110904512265835,-0.183710198994078,
  -9.95317430141363e-06,-0.0043341207439882,0.12243636839508,-0.214271771521588,
  -1.02349533586676e-05,-0.00402543780790132,0.133968224524325,-0.244833344049099,
  -1.05167324157551e-05,-0.00371675487181433,0.145500080653569,-0.275394916576609,
  -1.07985114729536e-05,-0.00340807193572767,0.157031936782814,-0.30595648910412,
  -1.10802905301521e-05,-0.00309938899964091,0.168563792912059,-0.336518061631631,
  -1.13620695871841e-05,-0.00279070606355369,0.180095649041304,-0.367079634159141,
  -1.16438486443826e-05,-0.00248202312746693,0.191627505170548,-0.397641206686651,
  -1.19256277018032e-05,-0.00217334019138038,0.203159361299793,-0.428202779214162,
  -1.22074067585576e-05,-0.00186465725529272,0.214691217429038,-0.458764351741672,
  -1.24891858162002e-05,-0.00155597431920662,0.226223073558283,-0.489325924269183,
  -1.27709648733987e-05,-0.00124729138311963,0.237754929687527,-0.519887496796694,
  -1.305274392982e-05,-0.000938608447031974,0.249286785816772,-0.550449069324204,
  -1.33345229874626e-05,-0.00062992551094565,0.260818641946017,-0.581010641851715,
  -1.36163020447722e-05,-0.000321242574858882,0.272350498075262,-0.611572214379225,
  -1.38980811017486e-05,-1.25596387716698e-05,0.283882354204507,-0.642133786906736,
  -1.41798601591692e-05,0.000296123297315098,0.295414210333752,-0.672695359434246,
  -1.44616392159236e-05,0.000604806233401867,0.306946066462996,-0.703256931961757,
  -1.47434182732331e-05,0.000913489169489079,0.318477922592241,-0.733818504489267,
  -1.50251973304316e-05,0.0012221721055754,0.330009778721486,-0.764380077016778,
  -1.5306976387186e-05,0.00153085504166306,0.341541634850731,-0.794941649544288,
  -6.57883096513712e-06,-0.0057735583080733,0.0643226571187663,-0.061867711433839,
  -6.75587030443681e-06,-0.00550171923130122,0.0755545343874936,-0.0926148262954412,
  -6.93290964365323e-06,-0.00522988015452924,0.0867864116562209,-0.123361941157043,
  -7.10994898306394e-06,-0.00495804107775732,0.0980182889249481,-0.154109056018645,
  -7.28698832222485e-06,-0.00468620200098524,0.109250166193675,-0.184856170880248,
  -7.4640276615523e-06,-0.00441436292421316,0.120482043462403,-0.21560328574185,
  -7.6410670009075e-06,-0.0041425238474414,0.13171392073113,-0.246350400603452,
  -7.81810634020719e-06,-0.00387068477066943,0.142945797999857,-0.277097515465054,
  -7.99514567950688e-06,-0.00359884569389735,0.154177675268585,-0.307844630326656,
  -8.17218501869554e-06,-0.00332700661712515,0.165409552537312,-0.338591745188258,
  -8.34922435793972e-06,-0.0030551675403534,0.176641429806039,-0.36933886004986,
  -8.52626369729492e-06,-0.00278332846358142,0.187873307074766,-0.400085974911463,
  -8.70330303670563e-06,-0.00251148938680945,0.199105184343494,-0.430833089773065,
  -8.8803423758943e-06,-0.00223965031003726,0.210337061612221,-0.461580204634667,
  -9.05738171497195e-06,-0.00196781123326528,0.221568938880948,-0.492327319496269,
  -9.23442105438266e-06,-0.00169597215649331,0.232800816149676,-0.523074434357871,
  -9.41146039379337e-06,-0.00142413307972133,0.244032693418403,-0.553821549219473,
  -9.58849973320408e-06,-0.00115229400294936,0.25526457068713,-0.584568664081075,
  -9.76553907283684e-06,-0.000880454926178054,0.266496447955857,-0.615315778942678,
  -9.94257841113733e-06,-0.000608615849404526,0.277728325224585,-0.64606289380428,
  -1.0119617750326e-05,-0.000336776772632774,0.288960202493312,-0.676810008665882,
  -1.02966570902918e-05,-6.49376958614667e-05,0.300192079762039,-0.707557123527484,
  -1.04736964294805e-05,0.000206901380910729,0.311423957030767,-0.738304238389086,
  -1.06507357684471e-05,0.000478740457682925,0.322655834299494,-0.769051353250689,
  -1.08277751080799e-05,0.000750579534454232,0.333887711568221,-0.799798468112291,
  -4.97708186809886e-06,-0.00569162186446176,0.0639522252365395,-0.0621938019127339,
  -5.08620036032692e-06,-0.00545055470662098,0.0749402664515676,-0.0930907513620787,
  -5.19531885256885e-06,-0.00520948754878031,0.0859283076665957,-0.123987700811423,
  -5.30443734478303e-06,-0.00496842039093937,0.096916348881624,-0.154884650260768,
  -5.41355583683067e-06,-0.00472735323309859,0.107904390096652,-0.185781599710113,
  -5.52267432923914e-06,-0.00448628607525814,0.11889243131168,-0.216678549159458,
  -5.63179282131454e-06,-0.00424521891741725,0.129880472526708,-0.247575498608802,
  -5.74091131361198e-06,-0.0040041517595768,0.140868513741736,-0.278472448058147,
  -5.85002980579841e-06,-0.0037630846017358,0.151856554956764,-0.309369397507492,
  -5.95914829798483e-06,-0.00352201744389502,0.162844596171792,-0.340266346956836,
  -6.06826679033778e-06,-0.00328095028605446,0.17383263738682,-0.371163296406181,
  -6.17738528235767e-06,-0.00303988312821324,0.184820678601849,-0.402060245855526,
  -6.28650377448858e-06,-0.00279881597037246,0.195808719816877,-0.432957195304871,
  -6.39562226689705e-06,-0.00255774881253212,0.206796761031905,-0.463854144754215,
  -6.50474075947205e-06,-0.00231668165469179,0.217784802246933,-0.49475109420356,
  -6.61385925160296e-06,-0.00207561449685101,0.228772843461961,-0.525648043652905,
  -6.72297774373387e-06,-0.00183454733901023,0.239760884676989,-0.556544993102249,
  -6.83209623564274e-06,-0.001593480181169,0.250748925892017,-0.587441942551594,
  -6.94121472788467e-06,-0.00135241302332845,0.261736967107045,-0.618338892000939,
  -7.05033322068171e-06,-0.00111134586548811,0.272725008322073,-0.649235841450284,
  -7.15945171236854e-06,-0.00087027870764711,0.283713049537101,-0.680132790899628,
  -7.26857020472149e-06,-0.000629211549806108,0.294701090752129,-0.711029740348973,
  -7.37768869707445e-06,-0.000388144391965994,0.305689131967157,-0.741926689798318,
  -7.48680718920536e-06,-0.000147077234124993,0.316677173182185,-0.772823639247663,
  -7.59592568155831e-06,9.3989923715565e-05,0.327665214397213,-0.803720588697007,
  -3.71250461386752e-06,-0.00562867394503819,0.0636597386881602,-0.0624493766702425,
  -3.77918532362687e-06,-0.00541236153796443,0.0744556803412751,-0.0934637595955922,
  -3.84586603335846e-06,-0.00519604913089067,0.08525162199439,-0.124478142520942,
  -3.91254674311781e-06,-0.0049797367238168,0.0960475636475049,-0.155492525446291,
  -3.97922745293267e-06,-0.00476342431674326,0.10684350530062,-0.186506908371641,
  -4.04590816266426e-06,-0.00454711190966939,0.117639446953735,-0.217521291296991,
  -4.11258887239585e-06,-0.00433079950259563,0.128435388606849,-0.24853567422234,
  -4.17926958218295e-06,-0.00411448709552176,0.139231330259964,-0.27955005714769,
  -4.24595029185904e-06,-0.00389817468844811,0.150027271913079,-0.310564440073039,
  -4.31263100175716e-06,-0.00368186228137435,0.160823213566194,-0.341578822998389,
  -4.37931171159978e-06,-0.00346554987430059,0.171619155219309,-0.372593205923738,
  -4.44599242122035e-06,-0.00324923746722683,0.182415096872424,-0.403607588849088,
  -4.51267313106296e-06,-0.00303292506015351,0.193211038525538,-0.434621971774438,
  -4.5793538410166e-06,-0.00281661265307953,0.204006980178653,-0.465636354699787,
  -4.64603455052615e-06,-0.00260030024600555,0.214802921831768,-0.496650737625137,
  -4.71271526047978e-06,-0.00238398783893201,0.225598863484883,-0.527665120550486,
  -4.77939597043342e-06,-0.0021676754318587,0.236394805137998,-0.558679503475836,
  -4.84607667994297e-06,-0.00195136302478427,0.247190746791113,-0.589693886401186,
  -4.91275738967456e-06,-0.00173505061771007,0.257986688444228,-0.620708269326535,
  -4.97943809918411e-06,-0.00151873821063653,0.268782630097343,-0.651722652251885,
  -5.04611880913775e-06,-0.00130242580356299,0.279578571750457,-0.682737035177234,
  -5.11279951875832e-06,-0.00108611339648856,0.290374513403573,-0.713751418102584,
  -5.17948022848991e-06,-0.000869800989415026,0.301170455056687,-0.744765801027934,
  -5.24616093855457e-06,-0.000653488582341932,0.311966396709802,-0.775780183953283,
  -5.31284164861923e-06,-0.000437176175268839,0.322762338362916,-0.806794566878633,
  -2.73890571138302e-06,-0.00558124015239941,0.0634345469472606,-0.0626450288560269,
  -2.77969848899717e-06,-0.00538425722868063,0.0740828399435056,-0.0937493115683843,
  -2.82049126643091e-06,-0.00518727430496169,0.0847311329397504,-0.124853594280742,
  -2.86128404400343e-06,-0.00499029138124296,0.0953794259359953,-0.155957876993099,
  -2.90207682138166e-06,-0.00479330845752379,0.10602771893224,-0.187062159705457,
  -2.94286959889867e-06,-0.00459632553380496,0.116676011928485,-0.218166442417814,
  -2.9836623762769e-06,-0.00439934261008579,0.12732430492473,-0.249270725130171,
  -3.0244551540437e-06,-0.0042023596863674,0.137972597920975,-0.280375007842529,
  -3.06524793153296e-06,-0.00400537676264845,0.14862089091722,-0.311479290554886,
  -3.10604070891118e-06,-0.00380839383892928,0.159269183913465,-0.342583573267244,
  -3.14683348628941e-06,-0.00361141091521033,0.16991747690971,-0.373687855979601,
  -3.18762626383418e-06,-0.00341442799149161,0.180565769905955,-0.404792138691959,
  -3.22841904148996e-06,-0.00321744506777266,0.1912140629022,-0.435896421404316,
  -3.26921181936779e-06,-0.0030204621440546,0.201862355898444,-0.467000704116673,
  -3.310004596635e-06,-0.00282347922033499,0.21251064889469,-0.498104986829031,
  -3.35079737445731e-06,-0.00262649629661671,0.223158941890934,-0.529209269541388,
  -3.39159015150248e-06,-0.00242951337289732,0.233807234887179,-0.560313552253746,
  -3.43238292899173e-06,-0.00223253044917837,0.244455527883424,-0.591417834966103,
  -3.47317570670302e-06,-0.00203554752545987,0.255103820879669,-0.622522117678461,
  -3.51396848374819e-06,-0.00183856460174026,0.265752113875914,-0.653626400390818,
  -3.55476126212562e-06,-0.00164158167802286,0.276400406872158,-0.684730683103175,
  -3.59555403917078e-06,-0.00144459875430281,0.287048699868404,-0.715834965815533,
  -3.63634681643799e-06,-0.00124761583058364,0.297696992864649,-0.74693924852789,
  -3.67713959403826e-06,-0.00105063290686536,0.308345285860893,-0.778043531240247,
  -3.71793237174955e-06,-0.000853649983146187,0.318993578857139,-0.809147813952605,
  -2.00373790508468e-06,-0.00554600914918618,0.0632645060146246,-0.0627921284506976,
  -2.02892152043055e-06,-0.00536377545118588,0.0738014540411196,-0.0939640016281287,
  -2.0541051357903e-06,-0.00518154175318591,0.0843384020676143,-0.12513587480556,
  -2.07928875109453e-06,-0.00499930805518567,0.0948753500941091,-0.156307747982991,
  -2.10447236628775e-06,-0.00481707435718537,0.105412298120604,-0.187479621160422,
  -2.12965598156423e-06,-0.00463484065918507,0.115949246147099,-0.218651494337853,
  -2.15483959725704e-06,-0.00445260696118543,0.126486194173594,-0.249823367515284,
  -2.18002321256128e-06,-0.00427037326318513,0.137023142200088,-0.280995240692715,
  -2.20520682753245e-06,-0.00408813956518461,0.147560090226583,-0.312167113870146,
  -2.23039044294771e-06,-0.00390590586718464,0.158097038253078,-0.343338987047577,
  -2.25557405858501e-06,-0.00372367216918468,0.168633986279573,-0.374510860225008,
  -2.28075767372271e-06,-0.00354143847118427,0.179170934306068,-0.405682733402439,
  -2.30594128919348e-06,-0.0033592047731843,0.189707882332563,-0.43685460657987,
  -2.33112490444221e-06,-0.00317697107518389,0.200244830359058,-0.468026479757301,
  -2.35630851985746e-06,-0.00299473737718414,0.210781778385552,-0.499198352934732,
  -2.38149213493966e-06,-0.00281250367918395,0.221318726412047,-0.530370226112163,
  -2.40667575035491e-06,-0.00263026998118354,0.231855674438542,-0.561542099289595,
  -2.43185936565915e-06,-0.00244803628318357,0.242392622465037,-0.592713972467026,
  -2.45704298085236e-06,-0.00226580258518272,0.252929570491532,-0.623885845644457,
  -2.4822265961566e-06,-0.00208356888718297,0.263466518518026,-0.655057718821888,
  -2.50741021146084e-06,-0.00190133518918278,0.274003466544521,-0.686229591999319,
  -2.53259382654303e-06,-0.00171910149118171,0.284540414571017,-0.71740146517675,
  -2.55777744273544e-06,-0.00153686779318329,0.29507736259751,-0.748573338354181,
  -2.58296105759559e-06,-0.00135463409518177,0.305614310624006,-0.779745211531612,
  -2.6081446727888e-06,-0.00117240039718203,0.316151258650501,-0.810917084709043,
  -1.4567048298858e-06,-0.00552011838490268,0.0631379833391577,-0.0629012299352861,
  -1.47248479620554e-06,-0.0053489440620324,0.0735921619988165,-0.0941232339108343,
  -1.48826476256692e-06,-0.00517776973916217,0.0840463406584754,-0.125345237886383,
  -1.50404472887278e-06,-0.00500659541629189,0.0945005193181342,-0.156567241861931,
  -1.5198246952064e-06,-0.0048354210934215,0.104954697977793,-0.187789245837479,
  -1.53560466154001e-06,-0.00466424677055122,0.115408876637452,-0.219011249813027,
  -1.55138462781812e-06,-0.00449307244768082,0.125863055297111,-0.250233253788575,
  -1.56716459409623e-06,-0.00432189812481065,0.13631723395677,-0.281455257764124,
  -1.58294456037433e-06,-0.00415072380194026,0.146771412616429,-0.312677261739672,
  -1.59872452665244e-06,-0.0039795494790702,0.157225591276087,-0.34389926571522,
  -1.61450449293055e-06,-0.00380837515619969,0.167679769935746,-0.375121269690768,
  -1.6302844594307e-06,-0.00363720083332941,0.178133948595405,-0.406343273666317,
  -1.64606442565329e-06,-0.00346602651045935,0.188588127255064,-0.437565277641865,
  -1.66184439198691e-06,-0.00329485218758907,0.199042305914723,-0.468787281617413,
  -1.67762435832053e-06,-0.00312367786471879,0.209496484574381,-0.500009285592961,
  -1.69340432487619e-06,-0.00295250354184895,0.21995066323404,-0.53123128956851,
  -1.70918429132083e-06,-0.00278132921897867,0.230404841893699,-0.562453293544058,
  -1.72496425698832e-06,-0.0026101548961075,0.240859020553358,-0.593675297519606,
  -1.74074422376602e-06,-0.00243898057323833,0.251313199213016,-0.624897301495154,
  -1.75652418965555e-06,-0.00226780625036715,0.261767377872676,-0.656119305470703,
  -1.77230415632224e-06,-0.00209663192749732,0.272221556532334,-0.687341309446251,
  -1.78808412265585e-06,-0.00192545760462703,0.282675735191993,-0.718563313421799,
  -1.80386408887845e-06,-0.00175428328175631,0.293129913851653,-0.749785317397347,
  -1.81964405499002e-06,-0.00158310895888603,0.303584092511311,-0.781007321372896,
  -1.83542402110159e-06,-0.00141193463601486,0.314038271170971,-0.812229325348444,
  -1.05409447145877e-06,-0.0055012386522445,0.0630448669403176,-0.0629813351146762,
  -1.06416351181027e-06,-0.00533824956799184,0.0734381730101917,-0.0942401464406587,
  -1.07423255221728e-06,-0.00517526048373934,0.0838314790800657,-0.125498957766641,
  -1.08430159240225e-06,-0.00501227139948646,0.0942247851499398,-0.156757769092624,
  -1.09437063283702e-06,-0.00484928231523385,0.104618091219814,-0.188016580418606,
  -1.10443967316076e-06,-0.00468629323098124,0.115011397289688,-0.219275391744589,
  -1.11450871376206e-06,-0.00452330414672886,0.125404703359562,-0.250534203070571,
  -1.1245777540303e-06,-0.00436031506247636,0.135798009429436,-0.281793014396554,
  -1.134646794132e-06,-0.00419732597822309,0.14619131549931,-0.313051825722536,
  -1.14471583456677e-06,-0.00403433689397037,0.156584621569185,-0.344310637048519,
  -1.1547848753346e-06,-0.00387134780971876,0.166977927639058,-0.375569448374502,
  -1.16485391526977e-06,-0.00370835872546516,0.177371233708933,-0.406828259700484,
  -1.17492295559352e-06,-0.00354536964121266,0.187764539778807,-0.438087071026467,
  -1.1849919960838e-06,-0.00338238055696016,0.198157845848681,-0.469345882352449,
  -1.19506103646305e-06,-0.00321939147270722,0.208551151918555,-0.500604693678432,
  -1.20513007662026e-06,-0.00305640238845473,0.218944457988429,-0.531863505004414,
  -1.21519911711054e-06,-0.00289341330420201,0.229337764058303,-0.563122316330397,
  -1.22526815760082e-06,-0.00273042421994929,0.239731070128177,-0.594381127656379,
  -1.23533719764701e-06,-0.00256743513569657,0.250124376198051,-0.625639938982362,
  -1.24540623791525e-06,-0.00240444605144363,0.260517682267925,-0.656898750308344,
  -1.25547527873859e-06,-0.00224145696719225,0.270910988337799,-0.688157561634327,
  -1.26554431889581e-06,-0.00207846788293908,0.281304294407673,-0.719416372960309,
  -1.27561335938609e-06,-0.00191547879868637,0.291697600477547,-0.750675184286292,
  -1.28568240009841e-06,-0.00175248971443365,0.302090906547422,-0.781933995612274,
  -1.2957514401446e-06,-0.00158950063018182,0.312484212617295,-0.813192806938257,
  -7.60159664076054e-07,-0.00548754861970574,0.0629768871422562,-0.0630397150369398,
  -7.6670921528299e-07,-0.00533055962925999,0.0733257758731576,-0.0943253512233551,
  -7.73258766573193e-07,-0.00517357063881413,0.0836746646040593,-0.12561098740977,
  -7.79808318002173e-07,-0.00501658164836838,0.0940235533349608,-0.156896623596186,
  -7.86357868931553e-07,-0.00485959265792213,0.104372442065862,-0.188182259782601,
  -7.92907420332778e-07,-0.00470260366747643,0.114721330796764,-0.219467895969016,
  -7.9945697162298e-07,-0.00454561467703063,0.125070219527666,-0.250753532155431,
  -8.06006522802161e-07,-0.0043886256865846,0.135419108258567,-0.282039168341847,
  -8.1255607392583e-07,-0.0042316366961388,0.145767996989469,-0.313324804528262,
  -8.19105625327055e-07,-0.00407464770569299,0.15611688572037,-0.344610440714677,
  -8.25655176561746e-07,-0.00391765871524696,0.166465774451272,-0.375896076901093,
  -8.32204728073993e-07,-0.0037606697248016,0.176814663182173,-0.407181713087508,
  -8.38754279197662e-07,-0.00360368073435535,0.187163551913075,-0.438467349273923,
  -8.45303830487865e-07,-0.00344669174390955,0.197512440643977,-0.469752985460338,
  -8.51853381833578e-07,-0.00328970275346396,0.207861329374878,-0.501038621646754,
  -8.58402932846225e-07,-0.00313271376301794,0.218210218105779,-0.532324257833169,
  -8.64952484302961e-07,-0.00297572477257235,0.228559106836681,-0.563609894019584,
  -8.71502035537652e-07,-0.00281873578212632,0.238907995567583,-0.594895530206,
  -8.78051586661321e-07,-0.00266174679168008,0.249256884298484,-0.626181166392415,
  -8.84601137673968e-07,-0.00250475780123383,0.259605773029386,-0.65746680257883,
  -8.91150689130704e-07,-0.00234776881078869,0.269954661760287,-0.688752438765245,
  -8.97700239810284e-07,-0.00219077982034177,0.280303550491189,-0.720038074951661,
  -9.04249791489065e-07,-0.00203379082989663,0.29065243922209,-0.751323711138076,
  -9.10799343278867e-07,-0.00187680183945194,0.301001327952991,-0.782609347324491,
  -9.17348894513559e-07,-0.00171981284900591,0.311350216683893,-0.813894983510907,
  -3.87513374328075e-05,-0.00790301093123119,0.0810393634870072,-0.0671847208865598,
  -4.2471694755325e-05,-0.00723021059810613,0.0963611459252105,-0.0945026907767414,
  -4.61920520778425e-05,-0.00655741026498113,0.111682928363414,-0.121820660666923,
  -4.99124094003045e-05,-0.00588460993185602,0.127004710801617,-0.149138630557104,
  -5.3632766722822e-05,-0.00521180959873102,0.14232649323982,-0.176456600447286,
  -5.73531240453673e-05,-0.00453900926560591,0.157648275678024,-0.203774570337468,
  -6.10734813678571e-05,-0.00386620893248102,0.172970058116227,-0.231092540227649,
  -6.47938386903468e-05,-0.0031934085993558,0.18829184055443,-0.258410510117831,
  -6.85141960126701e-05,-0.00252060826623057,0.203613622992633,-0.285728480008012,
  -7.22345533355484e-05,-0.0018478079331059,0.218935405430837,-0.313046449898194,
  -7.59549106576496e-05,-0.00117500759998013,0.23425718786904,-0.340364419788375,
  -7.96752679803614e-05,-0.000502207266855681,0.249578970307243,-0.367682389678557,
  -8.33956253027401e-05,0.000170593066269653,0.264900752745447,-0.395000359568739,
  -8.71159826254519e-05,0.000843393399394543,0.28022253518365,-0.42231832945892,
  -9.08363399479972e-05,0.00151619373251966,0.295544317621853,-0.449636299349102,
  -9.45566972703205e-05,0.00218899406564477,0.310866100060056,-0.476954269239283,
  -9.82770545928657e-05,0.0028617943987701,0.32618788249826,-0.504272239129465,
  -0.000101997411915411,0.00353459473189499,0.341509664936463,-0.531590209019646,
  -0.000105717769237734,0.0042073950650201,0.356831447374666,-0.558908178909828,
  -0.000109438126560391,0.00488019539814522,0.37215322981287,-0.586226148800009,
  -0.000113158483883047,0.00555299573126966,0.387475012251072,-0.613544118690191,
  -0.000116878841205481,0.00622579606439499,0.402796794689276,-0.640862088580373,
  -0.000120599198527804,0.00689859639752077,0.41811857712748,-0.668180058470554,
  -0.000124319555850461,0.00757139673064477,0.433440359565682,-0.695498028360736,
  -0.000128039913172673,0.008244197063771,0.448762142003886,-0.722815998250917,
  -3.85300721344739e-05,-0.00788329595479953,0.0809844087123069,-0.0672410256727426,
  -4.22110033521939e-05,-0.00721235489558286,0.0962754640655238,-0.0945803054201955,
  -4.58919345698305e-05,-0.00654141383636603,0.111566519418741,-0.121919585167648,
  -4.9572865787717e-05,-0.00587047277714958,0.126857574771957,-0.149258864915101,
  -5.32537970052704e-05,-0.00519953171793275,0.142148630125174,-0.176598144662554,
  -5.69347282229904e-05,-0.00452859065871603,0.157439685478391,-0.203937424410007,
  -6.06156594410434e-05,-0.00385764959949975,0.172730740831608,-0.23127670415746,
  -6.42965906586523e-05,-0.00318670854028302,0.188021796184825,-0.258615983904913,
  -6.79775218763723e-05,-0.0025157674810663,0.203312851538042,-0.285955263652366,
  -7.16584530939257e-05,-0.00184482642184958,0.218603906891258,-0.313294543399819,
  -7.53393843120898e-05,-0.0011738853626333,0.233894962244475,-0.340633823147271,
  -7.90203155295877e-05,-0.000502944303416575,0.249186017597692,-0.367973102894724,
  -8.27012467474741e-05,0.000167996755799704,0.264477072950908,-0.395312382642177,
  -8.6382177964861e-05,0.000838937815017315,0.279768128304126,-0.42265166238963,
  -9.0063109182803e-05,0.00150987887423359,0.295059183657343,-0.449990942137083,
  -9.37440404003009e-05,0.0021808199334501,0.310350239010559,-0.477330221884536,
  -9.7424971618354e-05,0.00285176099266704,0.325641294363777,-0.504669501631989,
  -0.000101105902836074,0.00352270205188354,0.340932349716993,-0.532008781379442,
  -0.000104786834053572,0.00419364311110049,0.35622340507021,-0.559348061126895,
  -0.000108467765271736,0.00486458417031654,0.371514460423427,-0.586687340874348,
  -0.000112148696488679,0.00553552522953416,0.386805515776644,-0.6140266206218,
  -0.000115829627707287,0.00620646628874955,0.40209657112986,-0.641365900369254,
  -0.000119510558924674,0.00687740734796627,0.417387626483077,-0.668705180116706,
  -0.000123191490142394,0.00754834840718388,0.432678681836294,-0.696044459864159,
  -0.000126872421360114,0.00821928946640016,0.447969737189511,-0.723383739611612,
  -3.82247026755878e-05,-0.00785619318357883,0.0809085332388486,-0.0673186351740324,
  -4.18515377016149e-05,-0.00718784479051343,0.0961571869407825,-0.0946872880442251,
  -4.54783727276142e-05,-0.00651949639744787,0.111405840642717,-0.122055940914418,
  -4.91052077537246e-05,-0.00585114800438247,0.126654494344651,-0.149424593784611,
  -5.27320427798905e-05,-0.00518279961131718,0.141903148046585,-0.176793246654803,
  -5.63588778056956e-05,-0.00451445121825145,0.157151801748519,-0.204161899524996,
  -5.99857128317782e-05,-0.00384610282518616,0.172400455450453,-0.231530552395189,
  -6.36125478577498e-05,-0.00317775443212054,0.187649109152387,-0.258899205265382,
  -6.72393828840545e-05,-0.00250940603905536,0.202897762854321,-0.286267858135574,
  -7.08662179099151e-05,-0.00184105764598974,0.218146416556255,-0.313636511005767,
  -7.44930529361088e-05,-0.00117270925292456,0.233395070258189,-0.34100516387596,
  -7.81198879620248e-05,-0.000504360859858943,0.248643723960123,-0.368373816746152,
  -8.17467229879965e-05,0.000163987533206678,0.263892377662057,-0.395742469616345,
  -8.53735580140791e-05,0.000832335926271854,0.279141031363991,-0.423111122486538,
  -8.90003930400507e-05,0.00150068431933792,0.294389685065926,-0.450479775356731,
  -9.26272280661333e-05,0.00216903271240287,0.309638338767859,-0.477848428226923,
  -9.62540630918829e-05,0.00283738110546872,0.324886992469793,-0.505217081097116,
  -9.98808981181876e-05,0.00350572949853367,0.340135646171727,-0.532585733967309,
  -0.000103507733144048,0.00417407789159951,0.355384299873661,-0.559954386837501,
  -0.000107134568170131,0.00484242628466491,0.370632953575595,-0.587323039707694,
  -0.000110761403196546,0.00551077467772965,0.385881607277529,-0.614691692577887,
  -0.000114388238221963,0.00617912307079571,0.401130260979463,-0.64206034544808,
  -0.00011801507324849,0.00684747146386089,0.416378914681397,-0.669428998318272,
  -0.000121641908274683,0.00751581985692606,0.431627568383331,-0.696797651188465,
  -0.000125268743299767,0.00818416824999302,0.446876222085266,-0.724166304058658,
  -3.7805481504255e-05,-0.00781918500902962,0.080804308743738,-0.0674249973764269,
  -4.13586493746843e-05,-0.00715444607824173,0.095994761509842,-0.0948339054985397,
  -4.49118172448915e-05,-0.00648970714745345,0.111185214275946,-0.122242813620652,
  -4.84649851153485e-05,-0.00582496821666545,0.12637566704205,-0.149651721742765,
  -5.20181529854447e-05,-0.00516022928587712,0.141566119808155,-0.177060629864878,
  -5.55713208558739e-05,-0.004495490355089,0.156756572574259,-0.204469537986991,
  -5.91244887262476e-05,-0.00383075142430112,0.171947025340363,-0.231878446109104,
  -6.26776565967879e-05,-0.00316601249351334,0.187137478106467,-0.259287354231217,
  -6.62308244668286e-05,-0.00250127356272478,0.202327930872571,-0.286696262353329,
  -6.97839923374244e-05,-0.00183653463193689,0.217518383638675,-0.314105170475442,
  -7.33371602074095e-05,-0.00117179570114856,0.232708836404779,-0.341514078597555,
  -7.68903280778943e-05,-0.00050705677036067,0.247899289170883,-0.368922986719668,
  -8.04434959479905e-05,0.000157682160427886,0.263089741936988,-0.39633189484178,
  -8.39966638188638e-05,0.000822421091215109,0.278280194703092,-0.423740802963893,
  -8.75498316887935e-05,0.00148716002200411,0.293470647469196,-0.451149711086006,
  -9.11029995592783e-05,0.00215189895279155,0.3086611002353,-0.478558619208119,
  -9.46561674292079e-05,0.00281663788358033,0.323851553001405,-0.505967527330232,
  -9.82093353001368e-05,0.00348137681436778,0.339042005767509,-0.533376435452344,
  -0.000101762503170177,0.00414611574515589,0.354232458533613,-0.560785343574457,
  -0.000105315671040773,0.00481085467594422,0.369422911299717,-0.58819425169657,
  -0.00010886883891148,0.00547559360673144,0.384613364065821,-0.615603159818683,
  -0.00011242200678141,0.00614033253752044,0.399803816831926,-0.643012067940796,
  -0.000115975174651783,0.00680507146830811,0.414994269598029,-0.670420976062908,
  -0.000119528342522268,0.00746981039909622,0.430184722364133,-0.697829884185021,
  -0.000123081510392309,0.00813454932988522,0.445375175130238,-0.725238792307134,
  -3.72341175191859e-05,-0.00776911545554998,0.0806621483403185,-0.0675696216167753,
  -4.06879996476817e-05,-0.00710938885211015,0.0957732957329877,-0.0950332661499243,
  -4.41418817761219e-05,-0.0064496622486705,0.110884443125657,-0.122496910683073,
  -4.75957639044233e-05,-0.00578993564523034,0.125995590518326,-0.149960555216222,
  -5.10496460329191e-05,-0.00513020904179062,0.141106737910995,-0.177424199749371,
  -5.4503528161276e-05,-0.00447048243835069,0.156217885303664,-0.20488784428252,
  -5.7957410289744e-05,-0.00381075583491108,0.171329032696333,-0.232351488815669,
  -6.14112924179899e-05,-0.00315102923147093,0.186440180089003,-0.259815133348818,
  -6.48651745466244e-05,-0.00249130262803132,0.201551327481672,-0.287278777881967,
  -6.83190566749814e-05,-0.00183157602459127,0.216662474874341,-0.314742422415116,
  -7.17729388035049e-05,-0.00117184942115189,0.23177362226701,-0.342206066948265,
  -7.52268209318063e-05,-0.000512122817711624,0.246884769659679,-0.369669711481414,
  -7.86807030599412e-05,0.000147603785728201,0.261995917052348,-0.397133356014562,
  -8.21345851884647e-05,0.000807330389168248,0.277107064445018,-0.424597000547711,
  -8.55884673173213e-05,0.00146705699260696,0.292218211837686,-0.45206064508086,
  -8.90423494456227e-05,0.00212678359604745,0.307329359230356,-0.479524289614009,
  -9.24962315739242e-05,0.00278651019948728,0.322440506623025,-0.506987934147158,
  -9.59501137020036e-05,0.00344623680292755,0.337551654015694,-0.534451578680307,
  -9.94039958305271e-05,0.0041059634063676,0.352662801408363,-0.561915223213456,
  -0.000102857877959162,0.00476569000980698,0.367773948801032,-0.589378867746605,
  -0.00010631176008713,0.00542541661324725,0.382885096193701,-0.616842512279754,
  -0.000109765642215653,0.00608514321668707,0.39799624358637,-0.644306156812903,
  -0.000113219524344066,0.0067448698201269,0.413107390979039,-0.671769801346051,
  -0.000116673406472811,0.00740459642356628,0.428218538371709,-0.699233445879201,
  -0.000120127288600669,0.00806432302700655,0.443329685764378,-0.72669709041235,
  -3.64630431560764e-05,-0.00770221594930115,0.0804700980057073,-0.0677641813430692,
  -3.97849844228915e-05,-0.00704942226023914,0.0954742529407388,-0.0953014615345548,
  -4.31069256898453e-05,-0.00639662857117718,0.11047840787577,-0.12283874172604,
  -4.64288669568269e-05,-0.00574383488211527,0.125482562810802,-0.150376021917526,
  -4.97508082238363e-05,-0.00509104119305337,0.140486717745833,-0.177913302109012,
  -5.30727494907346e-05,-0.00443824750399169,0.155490872680865,-0.205450582300497,
  -5.6394690757855e-05,-0.0037854538149299,0.170495027615896,-0.232987862491983,
  -5.97166320246423e-05,-0.00313266012586766,0.185499182550928,-0.260525142683468,
  -6.30385732917627e-05,-0.00247986643680598,0.200503337485959,-0.288062422874954,
  -6.636051455855e-05,-0.00182707274774385,0.215507492420991,-0.31559970306644,
  -6.96824558258369e-05,-0.00117427905868239,0.230511647356022,-0.343136983257925,
  -7.30043970924577e-05,-0.000521485369620045,0.245515802291054,-0.370674263449411,
  -7.6326338359578e-05,0.000131308319441636,0.260519957226085,-0.398211543640897,
  -7.96482796265874e-05,0.000784102008503096,0.275524112161116,-0.425748823832382,
  -8.29702208930971e-05,0.00143689569756567,0.290528267096148,-0.453286104023868,
  -8.6292162160384e-05,0.00208968938662712,0.305532422031179,-0.480823384215353,
  -8.9614103427671e-05,0.00274248307568925,0.320536576966211,-0.508360664406839,
  -9.29360446944028e-05,0.00339527676475115,0.335540731901242,-0.535897944598325,
  -9.62579859613566e-05,0.00404807045381306,0.350544886836274,-0.56343522478981,
  -9.95799272280884e-05,0.00470086414287518,0.365549041771305,-0.590972504981296,
  -0.000102901868495042,0.00535365783193686,0.380553196706337,-0.618509785172781,
  -0.000106223809761885,0.00600645152099899,0.395557351641368,-0.646047065364267,
  -0.000109545751028617,0.00665924521006112,0.4105615065764,-0.673584345555752,
  -0.000112867692295682,0.0073120388991228,0.425565661511431,-0.701121625747238,
  -0.000116189633563191,0.00796483258818403,0.440569816446462,-0.728658905938724,
  -3.54362035020206e-05,-0.00761431110991845,0.0802139940284266,-0.0680221884059904,
  -3.85861085285266e-05,-0.00697104754351358,0.0950757263030734,-0.0956571173775994,
  -4.17360135551159e-05,-0.0063277839771087,0.10993745857772,-0.123292046349208,
  -4.48859185816775e-05,-0.00568452041070378,0.124799190852367,-0.150926975320817,
  -4.80358236081835e-05,-0.00504125684429868,0.139660923127014,-0.178561904292426,
  -5.11857286348283e-05,-0.00439799327789403,0.154522655401661,-0.206196833264035,
  -5.4335633661251e-05,-0.00375472971148894,0.169384387676308,-0.233831762235644,
  -5.74855386878959e-05,-0.00311146614508406,0.184246119950955,-0.261466691207253,
  -6.06354437142076e-05,-0.00246820257867886,0.199107852225602,-0.289101620178862,
  -6.37853487409079e-05,-0.00182493901227421,0.213969584500249,-0.316736549150471,
  -6.69352537672752e-05,-0.00118167544586889,0.228831316774896,-0.34437147812208,
  -7.008515879392e-05,-0.00053841187946424,0.243693049049542,-0.372006407093689,
  -7.32350638205093e-05,0.000104851686940632,0.258554781324189,-0.399641336065297,
  -7.63849688468765e-05,0.000748115253345949,0.273416513598836,-0.427276265036906,
  -7.95348738737989e-05,0.00139137881975016,0.288278245873483,-0.454911194008515,
  -8.26847789001661e-05,0.00203464238615525,0.30313997814813,-0.482546122980124,
  -8.58346839267554e-05,0.00267790595256034,0.318001710422777,-0.510181051951733,
  -8.89845889533447e-05,0.00332116951896522,0.332863442697424,-0.537815980923342,
  -9.21344939796009e-05,0.00396443308537009,0.34772517497207,-0.565450909894951,
  -9.52843990065233e-05,0.00460769665177452,0.362586907246717,-0.59308583886656,
  -9.84343040325575e-05,0.00525096021818028,0.377448639521365,-0.620720767838169,
  -0.000101584209059147,0.00589422378458515,0.392310371796011,-0.648355696809777,
  -0.00010473411408618,0.00653748735098958,0.407172104070658,-0.675990625781386,
  -0.000107884019112658,0.00718075091739445,0.422033836345305,-0.703625554752995,
  -0.000111033924139248,0.00782401448379977,0.436895568619952,-0.731260483724604,
  -3.40927319410211e-05,-0.00750131884290484,0.0798783290034158,-0.0683578978307025,
  -3.70239188101085e-05,-0.00687103020131541,0.0945538257009949,-0.0961198838503931,
  -3.9955105679057e-05,-0.0062407415597257,0.109229322398574,-0.123881869870084,
  -4.28862925481721e-05,-0.00561045291813633,0.123904819096153,-0.151643855889775,
  -4.58174794171762e-05,-0.00498016427654668,0.138580315793732,-0.179405841909465,
  -4.87486662862358e-05,-0.00434987563495703,0.153255812491311,-0.207167827929156,
  -5.16798531552398e-05,-0.0037195869933675,0.16793130918889,-0.234929813948847,
  -5.46110400244659e-05,-0.00308929835177818,0.182606805886469,-0.262691799968537,
  -5.75422268935255e-05,-0.00245900971018886,0.197282302584048,-0.290453785988228,
  -6.04734137626406e-05,-0.00182872106859922,0.211957799281627,-0.318215772007919,
  -6.34046006317002e-05,-0.00119843242700979,0.226633295979206,-0.345977758027609,
  -6.63357875003712e-05,-0.000568143785419695,0.241308792676785,-0.3737397440473,
  -6.92669743697083e-05,6.21448561692883e-05,0.255984289374364,-0.401501730066991,
  -7.21981612387124e-05,0.000692433497758937,0.270659786071943,-0.429263716086681,
  -7.51293481078275e-05,0.00132272213934859,0.285335282769523,-0.457025702106372,
  -7.80605349766095e-05,0.00195301078093824,0.300010779467101,-0.484787688126063,
  -8.09917218458356e-05,0.00258329942252766,0.31468627616468,-0.512549674145753,
  -8.39229087151727e-05,0.00321358806411665,0.329361772862259,-0.540311660165444,
  -8.68540955839547e-05,0.00384387670570674,0.344037269559839,-0.568073646185135,
  -8.97852824530698e-05,0.00447416534729594,0.358712766257418,-0.595835632204825,
  -9.27164693222959e-05,0.00510445398888537,0.373388262954996,-0.623597618224516,
  -9.56476561917441e-05,0.00573474263047435,0.388063759652575,-0.651359604244207,
  -9.8578843060082e-05,0.00636503127206511,0.402739256350155,-0.679121590263897,
  -0.000101510029929308,0.00699531991365365,0.417414753047733,-0.706883576283588,
  -0.000104441216798534,0.00762560855524308,0.432090249745312,-0.734645562303279,
  -3.23751147089935e-05,-0.0073601376514536,0.0794482412780845,-0.0687840802472298,
  -3.50372660770093e-05,-0.00674725802378606,0.0938858129100584,-0.0967073649252313,
  -3.76994174449974e-05,-0.00613437839611847,0.108323384542032,-0.124630649603233,
  -4.03615688129577e-05,-0.00552149876845098,0.122760956174006,-0.152553934281234,
  -4.30237201811123e-05,-0.00490861914078367,0.13719852780598,-0.180477218959236,
  -4.56858715489616e-05,-0.00429573951311601,0.151636099437954,-0.208400503637237,
  -4.83480229169775e-05,-0.00368285988544848,0.166073671069928,-0.236323788315239,
  -5.10101742849378e-05,-0.00306998025778105,0.180511242701902,-0.26424707299324,
  -5.36723256527871e-05,-0.00245710063011328,0.194948814333875,-0.292170357671241,
  -5.63344770208585e-05,-0.00184422100244586,0.209386385965849,-0.320093642349243,
  -5.89966283890409e-05,-0.00123134137477865,0.223823957597823,-0.348016927027244,
  -6.16587797568902e-05,-0.000618461747110777,0.238261529229797,-0.375940211705246,
  -6.4320931124906e-05,-5.58211944312603e-06,0.252699100861771,-0.403863496383247,
  -6.69830824929774e-05,0.000607297508224303,0.267136672493745,-0.431786781061249,
  -6.96452338608822e-05,0.00122017713589173,0.281574244125719,-0.45971006573925,
  -7.23073852292311e-05,0.00183305676355872,0.296011815757692,-0.487633350417252,
  -7.49695365971359e-05,0.00244593639122637,0.310449387389666,-0.515556635095253,
  -7.76316879649297e-05,0.00305881601889402,0.32488695902164,-0.543479919773254,
  -8.02938393329455e-05,0.00367169564656189,0.339324530653614,-0.571403204451256,
  -8.29559907012944e-05,0.00428457527422887,0.353762102285588,-0.599326489129257,
  -8.56181420687552e-05,0.00489745490189719,0.368199673917562,-0.627249773807259,
  -8.8280293436549e-05,0.00551033452956462,0.382637245549536,-0.65517305848526,
  -9.09424448052309e-05,0.0061232141572316,0.397074817181509,-0.683096343163262,
  -9.36045961724696e-05,0.00673609378489948,0.411512388813483,-0.711019627841263,
  -9.62667475407075e-05,0.00734897341256691,0.425949960445457,-0.738942912519264,
  -3.02428762286033e-05,-0.00718989029943223,0.0789129219964207,-0.0693085114166922,
  -3.25877583167711e-05,-0.00659987447214505,0.0930554171182493,-0.0974302792810717,
  -3.49326404048278e-05,-0.00600985864485759,0.107197912240078,-0.125552047145451,
  -3.72775224930511e-05,-0.00541984281757057,0.121340407361906,-0.153673815009831,
  -3.96224045812188e-05,-0.00482982699028334,0.135482902483735,-0.18179558287421,
  -4.19672866693865e-05,-0.00423981116299621,0.149625397605564,-0.209917350738589,
  -4.43121687574988e-05,-0.00364979533570886,0.163767892727392,-0.238039118602969,
  -4.6657050845722e-05,-0.00305977950842173,0.177910387849221,-0.266160886467348,
  -4.90019329335012e-05,-0.00246976368113416,0.19205288297105,-0.294282654331728,
  -5.1346815022113e-05,-0.00187974785384726,0.206195378092878,-0.322404422196107,
  -5.36916971101142e-05,-0.00128973202655991,0.220337873214707,-0.350526190060487,
  -5.60365791982265e-05,-0.000699716199272782,0.234480368336535,-0.378647957924866,
  -5.83814612863942e-05,-0.000109700371985211,0.248622863458364,-0.406769725789246,
  -6.07263433740624e-05,0.00048031545530236,0.262765358580193,-0.434891493653625,
  -6.30712254625632e-05,0.00107033128258904,0.276907853702021,-0.463013261518005,
  -6.54161075507309e-05,0.00166034710987639,0.29105034882385,-0.491135029382384,
  -6.77609896391207e-05,0.0022503629371633,0.305192843945679,-0.519256797246763,
  -7.01058717271774e-05,0.00284037876445042,0.319335339067507,-0.547378565111143,
  -7.24507538153452e-05,0.00343039459173822,0.333477834189336,-0.575500332975522,
  -7.47956359030688e-05,0.00402041041902557,0.347620329311165,-0.603622100839901,
  -7.71405179913476e-05,0.00461042624631247,0.361762824432993,-0.631743868704281,
  -7.94854000790712e-05,0.00520044207360026,0.375905319554822,-0.65986563656866,
  -8.18302821677941e-05,0.00579045790088673,0.39004781467665,-0.68798740443304,
  -8.41751642562949e-05,0.00638047372817363,0.404190309798479,-0.716109172297419,
  -8.65200463442406e-05,0.00697048955546142,0.418332804920308,-0.744230940161799,
  -2.76906766451257e-05,-0.00699323286277509,0.0782702182224257,-0.0699296381602874,
  -2.96804563928443e-05,-0.00643235776638196,0.0920599444313986,-0.0982864859024318,
  -3.16702361404242e-05,-0.00587148266998838,0.105849670640372,-0.126643333644576,
  -3.36600158881706e-05,-0.00531060757359525,0.119639396849345,-0.155000181386721,
  -3.56497956355284e-05,-0.00474973247720156,0.133429123058318,-0.183357029128865,
  -3.76395753833858e-05,-0.00418885738080843,0.147218849267291,-0.211713876871009,
  -3.96293551312987e-05,-0.00362798228441552,0.161008575476263,-0.240070724613154,
  -4.16191348788786e-05,-0.00306710718802206,0.174798301685236,-0.268427572355298,
  -4.36089146262364e-05,-0.00250623209162826,0.188588027894209,-0.296784420097443,
  -4.55986943740938e-05,-0.00194535699523524,0.202377754103182,-0.325141267839587,
  -4.75884741218402e-05,-0.00138448189884222,0.216167480312155,-0.353498115581731,
  -4.9578253869309e-05,-0.000823606802448751,0.229957206521128,-0.381854963323876,
  -5.15680336170554e-05,-0.000262731706055064,0.243746932730101,-0.41021181106602,
  -5.35578133643577e-05,0.000298143390338623,0.257536658939074,-0.438568658808165,
  -5.55475931122151e-05,0.000859018486731644,0.271326385148047,-0.466925506550309,
  -5.75373728599615e-05,0.00141989358312467,0.28511611135702,-0.495282354292453,
  -5.95271526078189e-05,0.00198076867951791,0.298905837565993,-0.523639202034598,
  -6.15169323548992e-05,0.00254164377591204,0.312695563774966,-0.551996049776742,
  -6.35067121030897e-05,0.00310251887230462,0.326485289983939,-0.580352897518886,
  -6.54964918502809e-05,0.00366339396869808,0.340275016192912,-0.608709745261031,
  -6.74862715981384e-05,0.00422426906509132,0.354064742401885,-0.637066593003175,
  -6.94760513461068e-05,0.00478514416148412,0.367854468610857,-0.66542344074532,
  -7.1465831092965e-05,0.00534601925787914,0.381644194819831,-0.693780288487464,
  -7.34556108410445e-05,0.0059068943542715,0.395433921028804,-0.722137136229608,
  -7.54453905891239e-05,0.0064677694506643,0.409223647237776,-0.750493983971753,
  -2.4765843945479e-05,-0.00677712800949692,0.0775312295647967,-0.0706328365407603,
  -2.63822469181996e-05,-0.00625194792299394,0.0909172739889085,-0.0992558260825144,
  -2.79986498909757e-05,-0.00572676783649095,0.10430331841302,-0.127878815624268,
  -2.96150528635852e-05,-0.0052015877499878,0.117689362837132,-0.156501805166023,
  -3.12314558363336e-05,-0.00467640766348476,0.131075407261244,-0.185124794707777,
  -3.28478588090264e-05,-0.00415122757698183,0.144461451685356,-0.213747784249531,
  -3.44642617820523e-05,-0.00362604749047912,0.157847496109467,-0.242370773791285,
  -3.60806647545786e-05,-0.00310086740397575,0.171233540533579,-0.270993763333039,
  -3.76970677272714e-05,-0.00257568731747249,0.184619584957691,-0.299616752874793,
  -3.93134706999643e-05,-0.00205050723096978,0.198005629381803,-0.328239742416547,
  -4.09298736725461e-05,-0.0015253271444664,0.211391673805915,-0.356862731958301,
  -4.25462766455165e-05,-0.0010001470579637,0.224777718230027,-0.385485721500055,
  -4.41626796184313e-05,-0.000474966971460766,0.238163762654138,-0.414108711041809,
  -4.57790825910687e-05,5.02131150419416e-05,0.25154980707825,-0.442731700583563,
  -4.73954855636505e-05,0.00057539320154576,0.264935851502362,-0.471354690125317,
  -4.90118885365654e-05,0.00110057328804825,0.278321895926474,-0.499977679667071,
  -5.06282915089251e-05,0.00162575337455162,0.291707940350586,-0.528600669208825,
  -5.22446944821731e-05,0.00215093346105433,0.305093984774698,-0.557223658750579,
  -5.38610974546438e-05,0.00267611354755748,0.318480029198809,-0.585846648292333,
  -5.54775004271146e-05,0.00320129363406085,0.331866073622921,-0.614469637834087,
  -5.70939034004736e-05,0.00372647372056267,0.345252118047032,-0.643092627375841,
  -5.87103063727223e-05,0.00425165380706627,0.358638162471144,-0.671715616917596,
  -6.03267093456372e-05,0.00477683389356942,0.372024206895256,-0.700338606459349,
  -6.19431123183301e-05,0.00530201398007257,0.385410251319368,-0.728961596001104,
  -6.35595152911339e-05,0.00582719406657572,0.39879629574348,-0.757584585542858,
  -2.15765426092307e-05,-0.00655239545050879,0.0767226627807991,-0.0713894207000596,
  -2.28274613289781e-05,-0.00606883491992061,0.0896692784930238,-0.100298757132398,
  -2.40783800486977e-05,-0.00558527438933248,0.102615894205248,-0.129208093564736,
  -2.5329298768334e-05,-0.00510171385874414,0.115562509917473,-0.158117429997074,
  -2.65802174880814e-05,-0.00461815332815607,0.128509125629697,-0.187026766429412,
  -2.78311362078565e-05,-0.004134592797568,0.141455741341922,-0.21593610286175,
  -2.90820549274096e-05,-0.00365103226697949,0.154402357054147,-0.244845439294088,
  -3.03329736473512e-05,-0.00316747173639176,0.167348972766371,-0.273754775726425,
  -3.15838923667378e-05,-0.00268391120580325,0.180295588478596,-0.302664112158763,
  -3.28348110867349e-05,-0.00220035067521507,0.19324220419082,-0.331573448591101,
  -3.40857298061215e-05,-0.00171679014462689,0.206188819903045,-0.360482785023439,
  -3.53366485258966e-05,-0.00123322961403871,0.219135435615269,-0.389392121455777,
  -3.65875672462268e-05,-0.000749669083451199,0.232082051327494,-0.418301457888115,
  -3.78384859658354e-05,-0.00026610855286302,0.245028667039718,-0.447210794320453,
  -3.9089404685333e-05,0.000217451977725602,0.257975282751943,-0.476120130752791,
  -4.03403234051636e-05,0.000701012508313781,0.270921898464167,-0.505029467185129,
  -4.15912421247722e-05,0.00118457303890174,0.283868514176392,-0.533938803617467,
  -4.28421608440477e-05,0.00166813356949014,0.296815129888616,-0.562848140049805,
  -4.40930795638783e-05,0.00215169410007854,0.309761745600841,-0.591757476482143,
  -4.53439982843751e-05,0.00263525463066605,0.322708361313066,-0.620666812914481,
  -4.65949170036506e-05,0.00311881516125379,0.335654977025289,-0.649576149346819,
  -4.78458357230371e-05,0.00360237569184285,0.348601592737515,-0.678485485779157,
  -4.90967544434229e-05,0.00408593622243014,0.361548208449739,-0.707394822211495,
  -5.03476731626984e-05,0.00456949675301965,0.374494824161964,-0.736304158643833,
  -5.15985918828621e-05,0.00505305728360694,0.387441439874189,-0.765213495076171,
  -1.82820068112266e-05,-0.00633178907998166,0.0758846509921035,-0.0721601188421155,
  -1.92020081763167e-05,-0.00589405962601686,0.0883782051392907,-0.101361143930426,
  -2.01220095410737e-05,-0.00545633017205149,0.100871759286478,-0.130562169018737,
  -2.10420109060805e-05,-0.00501860071808657,0.113365313433665,-0.159763194107048,
  -2.1962012271004e-05,-0.00458087126412166,0.125858867580853,-0.188964219195359,
  -2.2882013635761e-05,-0.00414314181015618,0.13835242172804,-0.21816524428367,
  -2.38020150007401e-05,-0.00370541235619148,0.150845975875227,-0.247366269371981,
  -2.47220163657191e-05,-0.00326768290222657,0.163339530022415,-0.276567294460292,
  -2.56420177306982e-05,-0.00282995344826165,0.175833084169602,-0.305768319548603,
  -2.65620190952887e-05,-0.00239222399429595,0.18832663831679,-0.334969344636914,
  -2.74820204602677e-05,-0.00195449454033114,0.200820192463977,-0.364170369725225,
  -2.84020218253578e-05,-0.00151676508636611,0.213313746611164,-0.393371394813536,
  -2.93220231902258e-05,-0.00107903563240108,0.225807300758351,-0.422572419901847,
  -3.02420245549273e-05,-0.000641306178436052,0.238300854905539,-0.451773444990158,
  -3.11620259195733e-05,-0.000203576724470356,0.250794409052726,-0.480974470078469,
  -3.20820272849964e-05,0.000234152729494008,0.263287963199913,-0.51017549516678,
  -3.30020286495314e-05,0.00067188218345926,0.275781517347101,-0.539376520255091,
  -3.39220300145104e-05,0.00110961163742429,0.288275071494288,-0.568577545343402,
  -3.48420313798226e-05,0.0015473410913891,0.300768625641475,-0.597778570431713,
  -3.57620327445796e-05,0.00198507054535391,0.313262179788662,-0.626979595520024,
  -3.66820341088925e-05,0.00242279999931982,0.32575573393585,-0.656180620608335,
  -3.76020354743156e-05,0.00286052945328441,0.338249288083037,-0.685381645696646,
  -3.85220368391836e-05,0.003298258907249,0.350742842230224,-0.714582670784957,
  -3.94420382042737e-05,0.00373598836121447,0.363236396377412,-0.743783695873268,
  -4.03620395693638e-05,0.00417371781517817,0.375729950524598,-0.772984720961579,
  -1.5063564925144e-05,-0.00612720700004926,0.0750635316699236,-0.0729026729103611,
  -1.57071187954771e-05,-0.00573692304783152,0.087115380217898,-0.102384734874635,
  -1.63506726658103e-05,-0.00534663909561384,0.0991672287658724,-0.131866796838909,
  -1.69942265362821e-05,-0.00495635514339632,0.111219077313847,-0.161348858803183,
  -1.76377804065875e-05,-0.00456607119117847,0.123270925861821,-0.190830920767457,
  -1.82813342767263e-05,-0.00417578723896062,0.135322774409796,-0.220312982731731,
  -1.89248881469761e-05,-0.00378550328674265,0.14737462295777,-0.249795044696005,
  -1.95684420172815e-05,-0.0033952193345248,0.159426471505745,-0.279277106660279,
  -2.02119958878644e-05,-0.00300493538230762,0.171478320053719,-0.308759168624553,
  -2.08555497580587e-05,-0.00261465143008976,0.183530168601693,-0.338241230588827,
  -2.14991036285861e-05,-0.00222436747787191,0.195582017149668,-0.367723292553101,
  -2.21426574988914e-05,-0.00183408352565428,0.207633865697642,-0.397205354517375,
  -2.27862113692523e-05,-0.00144379957343665,0.219685714245616,-0.426687416481649,
  -2.34297652392801e-05,-0.00105351562121836,0.231737562793591,-0.456169478445923,
  -2.40733191100295e-05,-0.000663231669001396,0.243789411341565,-0.485651540410197,
  -2.47168729804459e-05,-0.000272947716783767,0.255841259889539,-0.515133602374471,
  -2.53604268505292e-05,0.000117336235434751,0.267893108437514,-0.544615664338745,
  -2.60039807205015e-05,0.000507620187652824,0.279944956985489,-0.574097726303019,
  -2.66475345908068e-05,0.000897904139870453,0.291996805533463,-0.603579788267293,
  -2.72910884614452e-05,0.00128818809208786,0.304048654081438,-0.633061850231567,
  -2.79346423320836e-05,0.00167847204430505,0.316100502629412,-0.662543912195841,
  -2.85781962020559e-05,0.00206875599652312,0.328152351177386,-0.692025974160114,
  -2.92217500724723e-05,0.0024590399487403,0.34020419972536,-0.721508036124388,
  -2.98653039435548e-05,0.00284932390095749,0.352256048273335,-0.750990098088662,
  -3.05088578134161e-05,0.00323960785317601,0.364307896821309,-0.780472160052936,
  -1.20864025979217e-05,-0.00594725462785445,0.0743020124196335,-0.0735807020880631,
  -1.25164184503479e-05,-0.00560311911021305,0.0859460900176758,-0.103319379981145,
  -1.29464343028574e-05,-0.00525898359257171,0.0975901676157181,-0.133058057874227,
  -1.33764501551448e-05,-0.00491484807493003,0.109234245213761,-0.16279673576731,
  -1.3806466007571e-05,-0.00457071255728869,0.120878322811803,-0.192535413660392,
  -1.42364818601082e-05,-0.00422657703964724,0.132522400409845,-0.222274091553474,
  -1.46664977125899e-05,-0.00388244152200601,0.144166478007888,-0.252012769446556,
  -1.50965135650161e-05,-0.00353830600436444,0.15581055560593,-0.281751447339638,
  -1.55265294173867e-05,-0.0031941704867231,0.167454633203972,-0.31149012523272,
  -1.59565452695354e-05,-0.00285003496908121,0.179098710802015,-0.341228803125802,
  -1.63865611221836e-05,-0.0025058994514402,0.190742788400057,-0.370967481018885,
  -1.68165769746098e-05,-0.0021617639337983,0.2023868659981,-0.400706158911967,
  -1.7246592826925e-05,-0.00181762841615729,0.214030943596142,-0.430444836805049,
  -1.76766086796842e-05,-0.00147349289851606,0.225675021194184,-0.460183514698131,
  -1.81066245319439e-05,-0.00112935738087461,0.237319098792226,-0.489922192591213,
  -1.85366403843146e-05,-0.000785221863233154,0.248963176390269,-0.519660870484295,
  -1.89666562371293e-05,-0.000441086345591701,0.260607253988312,-0.549399548377378,
  -1.93966720890559e-05,-9.69508279502485e-05,0.272251331586354,-0.57913822627046,
  -1.98266879414266e-05,0.000247184689690982,0.283895409184396,-0.608876904163542,
  -2.02567037944634e-05,0.000591320207332213,0.295539486782438,-0.638615582056624,
  -2.0686719646057e-05,0.000935455724974776,0.307183564380481,-0.668354259949706,
  -2.11167354994268e-05,0.00127959124261467,0.318827641978523,-0.698092937842788,
  -2.15467513519085e-05,0.00162372676025635,0.330471719576565,-0.727831615735871,
  -2.19767672036131e-05,0.00196786227789847,0.342115797174608,-0.757570293628953,
  -2.24067830565389e-05,0.00231199779553926,0.35375987477265,-0.787308971522035,
  -9.46817859062699e-06,-0.00579615041194154,0.0736309015583511,-0.0741701195065835,
  -9.74466901729198e-06,-0.00549432899130387,0.0849170501959846,-0.10413187614507,
  -1.00211594437905e-05,-0.00519250757066592,0.0962031988336182,-0.134093632783557,
  -1.02976498701224e-05,-0.00489068615002786,0.107489347471252,-0.164055389422043,
  -1.05741402965931e-05,-0.00458886472938991,0.118775496108885,-0.19401714606053,
  -1.08506307232026e-05,-0.00428704330875218,0.130061644746519,-0.223978902699016,
  -1.11271211498121e-05,-0.00398522188811445,0.141347793384152,-0.253940659337503,
  -1.1403611576144e-05,-0.00368340046747617,0.152633942021786,-0.283902415975989,
  -1.16801020029755e-05,-0.00338157904683878,0.163920090659419,-0.313864172614476,
  -1.19565924294185e-05,-0.00307975762620094,0.175206239297053,-0.343825929252962,
  -1.2233082855917e-05,-0.00277793620556266,0.186492387934687,-0.373787685891449,
  -1.25095732820824e-05,-0.00247611478492482,0.19777853657232,-0.403749442529935,
  -1.27860637087474e-05,-0.00217429336428698,0.209064685209953,-0.433711199168422,
  -1.30625541352458e-05,-0.00187247194364892,0.220350833847587,-0.463672955806908,
  -1.33390445619108e-05,-0.00157065052301131,0.23163698248522,-0.493634712445395,
  -1.36155349885758e-05,-0.00126882910237369,0.242923131122854,-0.523596469083881,
  -1.38920254150188e-05,-0.000967007681735188,0.254209279760488,-0.553558225722368,
  -1.41685158416838e-05,-0.000665186261098238,0.265495428398121,-0.583519982360854,
  -1.44450062683488e-05,-0.000363364840459957,0.276781577035755,-0.613481738999341,
  -1.47214966944587e-05,-6.15434198212306e-05,0.288067725673389,-0.643443495637827,
  -1.49979871211237e-05,0.000240278000815497,0.299353874311021,-0.673405252276314,
  -1.52744775475666e-05,0.000542099421454001,0.310640022948655,-0.703367008914801,
  -1.55509679742316e-05,0.000843920842091617,0.321926171586289,-0.733328765553287,
  -1.58274584005635e-05,0.00114574226273012,0.333212320223923,-0.763290522191774,
  -1.61039488268955e-05,0.00144756368336862,0.344498468861556,-0.79325227883026,
  -7.26597980485466e-06,-0.00567409848383488,0.0730655058317331,-0.0746610077444901,
  -7.43868304958761e-06,-0.00540908042356814,0.0840511094225305,-0.10480855246593,
  -7.61138629457037e-06,-0.00514406236330178,0.0950367130133277,-0.134956097187369,
  -7.78408953930332e-06,-0.00487904430303487,0.106022316604125,-0.165103641908808,
  -7.95679278386974e-06,-0.00461402624276808,0.117007920194923,-0.195251186630248,
  -8.12949602868596e-06,-0.00434900818250128,0.12799352378572,-0.225398731351687,
  -8.30219927366871e-06,-0.00408399012223493,0.138979127376517,-0.255546276073127,
  -8.47490251837391e-06,-0.00381897206196802,0.149964730967315,-0.285693820794566,
  -8.64760576319012e-06,-0.00355395400170155,0.160950334558112,-0.315841365516006,
  -8.82030900756225e-06,-0.00328893594143409,0.17193593814891,-0.345988910237445,
  -8.99301225282256e-06,-0.0030239178811684,0.182921541739706,-0.376136454958885,
  -9.16571549736123e-06,-0.00275889982090094,0.193907145330504,-0.406283999680324,
  -9.33841874239949e-06,-0.00249388176063503,0.204892748921301,-0.436431544401764,
  -9.51112198721571e-06,-0.00222886370036846,0.215878352512099,-0.466579089123203,
  -9.68382523192091e-06,-0.00196384564010166,0.226863956102896,-0.496726633844643,
  -9.85652847673713e-06,-0.00169882757983464,0.237849559693694,-0.526874178566082,
  -1.00292317213313e-05,-0.00143380951956784,0.248835163284491,-0.557021723287522,
  -1.02019349662585e-05,-0.00116879145930149,0.259820766875288,-0.587169268008961,
  -1.03746382108527e-05,-0.000903773399034247,0.270806370466086,-0.617316812730401,
  -1.05473414556689e-05,-0.000638755338767893,0.281791974056883,-0.64746435745184,
  -1.07200447010403e-05,-0.00037373727850154,0.29277757764768,-0.677611902173279,
  -1.08927479450793e-05,-0.000108719218234299,0.303763181238478,-0.707759446894719,
  -1.10654511904507e-05,0.00015629884203161,0.314748784829275,-0.737906991616159,
  -1.12381544351559e-05,0.000421316902298408,0.325734388420072,-0.768054536337598,
  -1.1410857679639e-05,0.000686334962565649,0.33671999201087,-0.798202081059038,
  -5.482051736172e-06,-0.00557852921852242,0.0726069333781728,-0.0750554505952252,
  -5.58796033722775e-06,-0.00534411450003119,0.0833494278031076,-0.105352281397311,
  -5.6938689382835e-06,-0.00510969978153997,0.0940919222280422,-0.135649112199397,
  -5.79977753953353e-06,-0.00487528506304891,0.104834416652977,-0.165945943001483,
  -5.90568614045051e-06,-0.00464087034455729,0.115576911077912,-0.196242773803569,
  -6.01159474145074e-06,-0.00440645562606612,0.126319405502847,-0.226539604605656,
  -6.11750334272854e-06,-0.00417204090757506,0.137061899927781,-0.256836435407742,
  -6.22341194367326e-06,-0.00393762618908367,0.147804394352716,-0.287133266209828,
  -6.32932054495106e-06,-0.00370321147059305,0.15854688877765,-0.317430097011914,
  -6.43522914595129e-06,-0.00346879675210143,0.169289383202585,-0.347726927814,
  -6.54113774684051e-06,-0.00323438203361004,0.18003187762752,-0.378023758616086,
  -6.64704634817381e-06,-0.00299996731511909,0.190774372052455,-0.408320589418172,
  -6.75295494911854e-06,-0.0027655525966277,0.20151686647739,-0.438617420220258,
  -6.85886355000775e-06,-0.00253113787813608,0.212259360902325,-0.468914251022344,
  -6.96477215134106e-06,-0.00229672315964491,0.223001855327259,-0.49921108182443,
  -7.0706807523413e-06,-0.00206230844115396,0.233744349752194,-0.529507912626516,
  -7.17658935323051e-06,-0.00182789372266257,0.244486844177129,-0.559804743428602,
  -7.28249795467484e-06,-0.00159347900417162,0.255229338602063,-0.590101574230688,
  -7.38840655545303e-06,-0.00135906428568022,0.265971833026998,-0.620398405032774,
  -7.4943151571194e-06,-0.00112464956718972,0.276714327451933,-0.65069523583486,
  -7.60022375800862e-06,-0.000890234848697879,0.287456821876868,-0.680992066636946,
  -7.70613235945294e-06,-0.000655820130207374,0.298199316301802,-0.711288897439032,
  -7.81204095978705e-06,-0.000421405411715092,0.308941810726737,-0.741585728241118,
  -7.9179495613424e-06,-0.000186990693224143,0.319684305151672,-0.771882559043204,
  -8.02385816189854e-06,4.7424025267695e-05,0.330426799576607,-0.80217938984529,
  -4.08043643584932e-06,-0.0055054757741303,0.0722463101057433,-0.0753633723797584,
  -4.14487548536235e-06,-0.00529559081989184,0.0827980226927252,-0.105776743350523,
  -4.20931453479212e-06,-0.00508570586565316,0.0933497352797074,-0.136190114321287,
  -4.27375358424964e-06,-0.0048758209114147,0.103901447866689,-0.166603485292052,
  -4.33819263379043e-06,-0.00466593595717624,0.114453160453671,-0.197016856262816,
  -4.40263168310917e-06,-0.00445605100293733,0.125004873040654,-0.22743022723358,
  -4.46707073264996e-06,-0.0042461660486991,0.135556585627635,-0.257843598204345,
  -4.53150978219075e-06,-0.00403628109446053,0.146108298214617,-0.288256969175109,
  -4.59594883178704e-06,-0.00382639614022229,0.156660010801599,-0.318670340145874,
  -4.66038788093925e-06,-0.00361651118598316,0.167211723388582,-0.349083711116638,
  -4.72482693042453e-06,-0.0034066262317447,0.177763435975564,-0.379497082087402,
  -4.78926598024287e-06,-0.00319674127750669,0.188315148562545,-0.409910453058167,
  -4.85370502956162e-06,-0.00298685632326778,0.198866861149528,-0.440323824028931,
  -4.91814407888036e-06,-0.00277697136902888,0.20941857373651,-0.470737194999695,
  -4.98258312853217e-06,-0.00256708641479064,0.219970286323492,-0.50115056597046,
  -5.04702217807296e-06,-0.00235720146055218,0.230521998910474,-0.531563936941224,
  -5.1114612273917e-06,-0.00214731650631328,0.241073711497456,-0.561977307911989,
  -5.17590027682147e-06,-0.00193743155207504,0.251625424084438,-0.592390678882753,
  -5.24033932691736e-06,-0.00172754659783747,0.262177136671419,-0.622804049853518,
  -5.30477837601406e-06,-0.00151766164359834,0.272728849258401,-0.653217420824282,
  -5.36921742555485e-06,-0.00130777668936011,0.283280561845383,-0.683630791795046,
  -5.43365647542871e-06,-0.00109789173512187,0.293832274432365,-0.714044162765811,
  -5.4980955245254e-06,-0.000888006780883188,0.304383987019347,-0.744457533736575,
  -5.56253457417721e-06,-0.000678121826644063,0.31493569960633,-0.77487090470734,
  -5.626973623718e-06,-0.000468236872406269,0.325487412193311,-0.805284275678104,
  -3.00539819664269e-06,-0.00545063936356049,0.0719695296992574,-0.0755983749014439,
  -3.0446734750611e-06,-0.00525985279772129,0.0823750505193432,-0.106100688048088,
  -3.08394875339624e-06,-0.00506906623188197,0.092780571339429,-0.136603001194732,
  -3.12322403189791e-06,-0.00487827966604304,0.103186092159515,-0.167105314341376,
  -3.16249931014978e-06,-0.00468749310020378,0.1135916129796,-0.19760762748802,
  -3.20177458851267e-06,-0.0044967065343644,0.123997133799686,-0.228109940634663,
  -3.24104986715312e-06,-0.00430591996852558,0.134402654619772,-0.258612253781307,
  -3.28032514551602e-06,-0.00411513340268654,0.144808175439857,-0.289114566927951,
  -3.31960042365687e-06,-0.00392434683684706,0.155213696259943,-0.319616880074595,
  -3.35887570235283e-06,-0.00373356027100846,0.165619217080029,-0.350119193221239,
  -3.39815098071572e-06,-0.00354277370516876,0.176024737900115,-0.380621506367883,
  -3.43742625891208e-06,-0.00335198713932949,0.186430258720201,-0.411123819514527,
  -3.47670153744151e-06,-0.00316120057349045,0.196835779540286,-0.441626132661171,
  -3.51597681558236e-06,-0.00297041400765119,0.207241300360372,-0.472128445807814,
  -3.55525209405627e-06,-0.00277962744181215,0.217646821180458,-0.502630758954458,
  -3.59452737264121e-06,-0.00258884087597289,0.228052342000544,-0.533133072101102,
  -3.63380265122615e-06,-0.00239805431013385,0.23845786282063,-0.563635385247746,
  -3.67307792947802e-06,-0.00220726774429503,0.248863383640715,-0.59413769839439,
  -3.712353208285e-06,-0.00201648117845621,0.259268904460801,-0.624640011541034,
  -3.75162848553767e-06,-0.00182569461261561,0.269674425280887,-0.655142324687678,
  -3.79090376434466e-06,-0.00163490804677657,0.280079946100973,-0.685644637834322,
  -3.83017904337368e-06,-0.00144412148093842,0.290485466921058,-0.716146950980966,
  -3.86945432140351e-06,-0.00125333491509938,0.300890987741143,-0.74664926412761,
  -3.90872959954436e-06,-0.00106254834925945,0.31129650856123,-0.777151577274253,
  -3.94800487857339e-06,-0.000871761783421299,0.321702029381315,-0.807653890420898,
  -2.19596999972982e-06,-0.00541002868313351,0.0717610344841811,-0.0757746483461988,
  -2.22013973152912e-06,-0.00523378236273958,0.0820565633018825,-0.106343676282173,
  -2.24430946332843e-06,-0.00505753604234593,0.0923520921195836,-0.136912704218147,
  -2.26847919515549e-06,-0.0048812897219519,0.102647620937285,-0.16748173215412,
  -2.29264892703807e-06,-0.00470504340155842,0.112943149754986,-0.198050760090094,
  -2.31681865875411e-06,-0.00452879708116427,0.123238678572688,-0.228619788026068,
  -2.34098839035912e-06,-0.00435255076077012,0.133534207390389,-0.259188815962042,
  -2.36515812246374e-06,-0.00417630444037675,0.14382973620809,-0.289757843898016,
  -2.38932785395773e-06,-0.00400005811998239,0.154125265025792,-0.32032687183399,
  -2.41349758584031e-06,-0.00382381179958857,0.164420793843493,-0.350895899769964,
  -2.43766731800044e-06,-0.00364756547919542,0.174716322661194,-0.381464927705938,
  -2.46183704960545e-06,-0.00347131915880117,0.185011851478896,-0.412033955641912,
  -2.486006781377e-06,-0.00329507283840691,0.195307380296597,-0.442602983577886,
  -2.510176512871e-06,-0.0031188265180131,0.205602909114298,-0.473172011513859,
  -2.53434624464255e-06,-0.00294258019761906,0.215898437932,-0.503741039449833,
  -2.55851597674717e-06,-0.00276633387722569,0.226193966749701,-0.534310067385807,
  -2.58268570851872e-06,-0.0025900875568321,0.236489495567402,-0.564879095321781,
  -2.60685544040129e-06,-0.00241384123643806,0.246785024385104,-0.595448123257755,
  -2.63102517239489e-06,-0.00223759491604425,0.257080553202805,-0.626017151193729,
  -2.65519490338928e-06,-0.00206134859564999,0.267376082020506,-0.656586179129703,
  -2.67936463604901e-06,-0.0018851022752564,0.277671610838208,-0.687155207065677,
  -2.70353436748749e-06,-0.00170885595486236,0.287967139655909,-0.717724235001651,
  -2.72770409881495e-06,-0.00153260963446833,0.29826266847361,-0.748293262937625,
  -2.75187383091957e-06,-0.00135636331407429,0.308558197291312,-0.778862290873598,
  -2.77604356324623e-06,-0.00118011699368115,0.318853726109013,-0.809431318809572,
  -1.59498190127616e-06,-0.00538024907151868,0.0716061772516516,-0.075905160244249,
  -1.61008542687302e-06,-0.00521488692176708,0.0818200837016172,-0.10652358344674,
  -1.62518895227559e-06,-0.00504952477201526,0.0920339901515828,-0.13714200664923,
  -1.64029247781694e-06,-0.00488416262226354,0.102247896601548,-0.167760429851721,
  -1.65539600327502e-06,-0.00471880047251194,0.112461803051514,-0.198378853054212,
  -1.67049952876086e-06,-0.0045534383227599,0.12267570950148,-0.228997276256702,
  -1.68560305413568e-06,-0.00438807617300807,0.132889615951445,-0.259615699459193,
  -1.70070657945498e-06,-0.00422271402325602,0.143103522401411,-0.290234122661683,
  -1.71581010527389e-06,-0.00405735187350476,0.153317428851377,-0.320852545864174,
  -1.73091363042666e-06,-0.0038919897237526,0.163531335301342,-0.351470969066664,
  -1.74601715607903e-06,-0.00372662757400111,0.173745241751308,-0.382089392269155,
  -1.76112068167589e-06,-0.00356126542424939,0.183959148201273,-0.412707815471646,
  -1.77622420693968e-06,-0.00339590327449746,0.194173054651239,-0.443326238674136,
  -1.79132773248103e-06,-0.00323054112474552,0.204386961101205,-0.473944661876627,
  -1.80643125802238e-06,-0.00306517897499448,0.21460086755117,-0.504563085079118,
  -1.82153478323066e-06,-0.00289981682524165,0.224814774001136,-0.535181508281608,
  -1.83663830866099e-06,-0.00273445467548994,0.235028680451102,-0.565799931484099,
  -1.85174183442438e-06,-0.00256909252573867,0.245242586901067,-0.596418354686589,
  -1.86684535963266e-06,-0.00240373037598651,0.255456493351033,-0.62703677788908,
  -1.88194888584015e-06,-0.00223836822623591,0.265670399800998,-0.65765520109157,
  -1.89705241149252e-06,-0.00207300607648442,0.275884306250963,-0.688273624294061,
  -1.91215593681182e-06,-0.00190764392673248,0.286098212700929,-0.718892047496552,
  -1.9272594620201e-06,-0.00174228177698055,0.296312119150895,-0.749510470699042,
  -1.94236298689532e-06,-0.00157691962722728,0.306526025600861,-0.780128893901533,
  -1.95746651276973e-06,-0.00141155747747668,0.316739932050826,-0.810747317104024,
  -1.15336946768241e-06,-0.0053585681419499,0.0714923588165568,-0.07600086250191,
  -1.16298470706488e-06,-0.00520125136338623,0.081646312938949,-0.106655506452041,
  -1.17259994661389e-06,-0.00504393458482266,0.0918002670613413,-0.137310150402173,
  -1.18221518596862e-06,-0.00488661780625899,0.101954221183733,-0.167964794352304,
  -1.19183042551763e-06,-0.00472930102769553,0.112108175306126,-0.198619438302436,
  -1.20144566501112e-06,-0.00457198424913197,0.122262129428518,-0.229274082252567,
  -1.21106090422707e-06,-0.00441466747056796,0.13241608355091,-0.259928726202699,
  -1.22067614383159e-06,-0.00425735069200461,0.142570037673302,-0.29058337015283,
  -1.23029138371367e-06,-0.0041000339134416,0.152723991795694,-0.321238014102962,
  -1.23990662248552e-06,-0.00394271713487715,0.162877945918087,-0.351892658053093,
  -1.24952186242311e-06,-0.00378540035631425,0.173031900040479,-0.382547302003225,
  -1.25913710180559e-06,-0.00362808357775046,0.183185854162871,-0.413201945953356,
  -1.26875234129908e-06,-0.00347076679918668,0.193339808285263,-0.443856589903487,
  -1.27836758057054e-06,-0.00331345002062311,0.203493762407655,-0.474511233853619,
  -1.28798281995302e-06,-0.00315613324205932,0.213647716530048,-0.50516587780375,
  -1.29759805955754e-06,-0.00299881646349598,0.223801670652439,-0.535820521753882,
  -1.30721329905104e-06,-0.00284149968493219,0.233955624774832,-0.566475165704013,
  -1.31682853854453e-06,-0.00268418290636885,0.244109578897224,-0.597129809654145,
  -1.32644377803803e-06,-0.00252686612780528,0.254263533019616,-0.627784453604276,
  -1.33605901742051e-06,-0.00236954934924194,0.264417487142008,-0.658439097554408,
  -1.34567425658094e-06,-0.00221223257067749,0.274571441264401,-0.689093741504539,
  -1.35528949651853e-06,-0.00205491579211525,0.284725395386792,-0.719748385454671,
  -1.36490473578998e-06,-0.00189759901355124,0.294879349509185,-0.750403029404802,
  -1.37451997528348e-06,-0.00174028223498723,0.305033303631577,-0.781057673354934,
  -1.38413521466596e-06,-0.00158296545642367,0.315187257753969,-0.811712317305065,
  -8.31339066226233e-07,-0.00534286518022409,0.0714093462833771,-0.0760705439261344,
  -8.37581454998793e-07,-0.00519144046630249,0.0815195955185766,-0.106751560433651,
  -8.43823843854619e-07,-0.005040015752381,0.0916298447537761,-0.137432576941169,
  -8.50066232516156e-07,-0.00488859103845918,0.101740093988976,-0.168113593448686,
  -8.56308621288715e-07,-0.00473716632453769,0.111850343224175,-0.198794609956203,
  -8.62551009950252e-07,-0.00458574161061576,0.121960592459375,-0.22947562646372,
  -8.68793398778323e-07,-0.00443431689669427,0.132070841694574,-0.260156642971237,
  -8.75035787550882e-07,-0.00428289218277278,0.142181090929774,-0.290837659478754,
  -8.81278176323441e-07,-0.00413146746885107,0.152291340164973,-0.321518675986271,
  -8.87520564929467e-07,-0.00398004275492903,0.162401589400173,-0.352199692493788,
  -8.93762954090604e-07,-0.00382861804100831,0.172511838635372,-0.382880709001305,
  -9.00005342585608e-07,-0.00367719332708605,0.182622087870572,-0.413561725508822,
  -9.06247731247145e-07,-0.00352576861316445,0.192732337105771,-0.444242742016339,
  -9.12490119686638e-07,-0.00337434389924218,0.202842586340971,-0.474923758523856,
  -9.1873250862573e-07,-0.00322291918532081,0.212952835576171,-0.505604775031373,
  -9.24974897342778e-07,-0.00307149447139921,0.22306308481137,-0.53628579153889,
  -9.31217286503916e-07,-0.00292006975747805,0.23317333404657,-0.566966808046407,
  -9.37459675220964e-07,-0.00276864504355623,0.243283583281769,-0.597647824553924,
  -9.4370206382699e-07,-0.00261722032963463,0.253393832516969,-0.628328841061441,
  -9.49944452988127e-07,-0.00246579561571325,0.263504081752168,-0.659009857568958,
  -9.56186841483131e-07,-0.00231437090179165,0.273614330987368,-0.689690874076475,
  -9.62429230311201e-07,-0.00216294618787005,0.283724580222567,-0.720371890583992,
  -9.68671618362116e-07,-0.00201152147394756,0.293834829457767,-0.751052907091509,
  -9.74914006746097e-07,-0.00186009676002552,0.303945078692966,-0.781733923599026,
  -9.81156396129279e-07,-0.00170867204610481,0.314055327928166,-0.812414940106543,
  -4.42445513552936e-05,-0.00829168561266924,0.0913637107697273,-0.0777833820791131,
  -4.81678903504479e-05,-0.0076189447664301,0.106626091225949,-0.104400178095791,
  -5.20912293454634e-05,-0.00694620392019074,0.121888471682171,-0.131016974112468,
  -5.60145683403401e-05,-0.00627346307395116,0.137150852138394,-0.157633770129146,
  -5.99379073354389e-05,-0.00560072222771202,0.152413232594616,-0.184250566145823,
  -6.38612463303989e-05,-0.00492798138147266,0.167675613050838,-0.210867362162501,
  -6.77845853253034e-05,-0.0042552405352333,0.18293799350706,-0.237484158179178,
  -7.17079243202079e-05,-0.00358249968899371,0.198200373963282,-0.264100954195856,
  -7.56312633155565e-05,-0.00290975884275468,0.213462754419504,-0.290717750212533,
  -7.95546023104055e-05,-0.00223701799651543,0.228725134875726,-0.317334546229211,
  -8.3477941305421e-05,-0.00156427715027618,0.243987515331948,-0.343951342245889,
  -8.74012803005475e-05,-0.000891536304036933,0.25924989578817,-0.370568138262566,
  -9.13246192953965e-05,-0.000218795457797238,0.274512276244393,-0.397184934279244,
  -9.52479582900789e-05,0.000453945388442678,0.289774656700615,-0.423801730295921,
  -9.91712972855385e-05,0.00112668623468104,0.305037037156836,-0.450418526312599,
  -0.000103094636279999,0.0017994270809214,0.320299417613059,-0.477035322329276,
  -0.000107017975275681,0.00247216792715999,0.335561798069281,-0.503652118345954,
  -0.000110941314270363,0.00314490877339968,0.350824178525503,-0.530268914362631,
  -0.000114864653265156,0.00381764961963915,0.366086558981725,-0.556885710379309,
  -0.000118787992260061,0.0044903904658784,0.381348939437947,-0.583502506395986,
  -0.000122711331255299,0.0051631313121181,0.39661131989417,-0.610119302412664,
  -0.000126634670250536,0.00583587215835646,0.411873700350391,-0.636736098429341,
  -0.000130558009245441,0.00650861300459571,0.427136080806613,-0.663352894446019,
  -0.000134481348240789,0.00718135385083452,0.442398461262835,-0.689969690462697,
  -0.000138404687234917,0.0078540946970751,0.457660841719058,-0.716586486479374,
  -4.39774573719187e-05,-0.00826637447153794,0.0912927069884302,-0.0778555991839324,
  -4.78572041406056e-05,-0.00759549191827702,0.106521831821564,-0.104495630683952,
  -5.17369509092924e-05,-0.00692460936501615,0.121750956654699,-0.131135662183971,
  -5.56166976781458e-05,-0.00625372681175529,0.136980081487833,-0.15777569368399,
  -5.94964444469714e-05,-0.00558284425849453,0.152209206320967,-0.18441572518401,
  -6.33761912157693e-05,-0.00491196170523378,0.167438331154101,-0.211055756684029,
  -6.72559379843451e-05,-0.00424107915197269,0.182667455987236,-0.237695788184048,
  -7.11356847533651e-05,-0.00357019659871216,0.19789658082037,-0.264335819684067,
  -7.50154315221074e-05,-0.00289931404545118,0.213125705653504,-0.290975851184087,
  -7.88951782908498e-05,-0.00222843149219032,0.228354830486639,-0.317615882684106,
  -8.27749250594811e-05,-0.00155754893892945,0.243583955319773,-0.344255914184125,
  -8.66546718284456e-05,-0.000886666385668589,0.258813080152907,-0.370895945684145,
  -9.0534418597521e-05,-0.000215783832408389,0.274042204986041,-0.397535977184164,
  -9.44141653657082e-05,0.000455098720853586,0.289271329819176,-0.424176008684183,
  -9.82939121345616e-05,0.00112598127411401,0.30450045465231,-0.450816040184203,
  -0.000102173658903748,0.00179686382737465,0.319729579485444,-0.477456071684222,
  -0.000106053405672046,0.00246774638063596,0.334958704318579,-0.504096103184241,
  -0.0001099331524409,0.00313862893389683,0.350187829151713,-0.53073613468426,
  -0.000113812899210086,0.00380951148715702,0.365416953984847,-0.55737616618428,
  -0.000117692645978607,0.00448039404041811,0.380646078817981,-0.584016197684299,
  -0.000121572392747349,0.00515127659367876,0.395875203651115,-0.610656229184318,
  -0.000125452139515314,0.00582215914694073,0.41110432848425,-0.637296260684337,
  -0.000129331886285278,0.00649304170020049,0.426333453317384,-0.663936292184357,
  -0.000133211633053909,0.00716392425346113,0.441562578150518,-0.690576323684376,
  -0.000137091379821763,0.0078348068067231,0.456791702983653,-0.717216355184395,
  -4.36091194501165e-05,-0.00823161628614266,0.091194734657373,-0.0779550620272648,
  -4.74291090190593e-05,-0.00756332910621127,0.106377999241316,-0.10462709518735,
  -5.12490985878911e-05,-0.00689504192627988,0.121561263825259,-0.131299128347435,
  -5.50690881565841e-05,-0.00622675474634815,0.136744528409202,-0.15797116150752,
  -5.88890777253881e-05,-0.00555846756641643,0.151927792993146,-0.184643194667606,
  -6.27090672943309e-05,-0.00489018038648525,0.167111057577089,-0.211315227827691,
  -6.65290568632737e-05,-0.00422189320655386,0.182294322161032,-0.237987260987776,
  -7.03490464321055e-05,-0.00355360602662225,0.197477586744975,-0.264659294147861,
  -7.41690360009928e-05,-0.00288531884669085,0.212660851328918,-0.291331327307946,
  -7.7989025569547e-05,-0.00221703166675891,0.227844115912861,-0.318003360468031,
  -8.18090151385453e-05,-0.00154874448682762,0.243027380496804,-0.344675393628117,
  -8.56290047071551e-05,-0.000880457306895899,0.258210645080748,-0.371347426788202,
  -8.94489942764309e-05,-0.000212170126965283,0.27339390966469,-0.398019459948287,
  -9.32689838448741e-05,0.000456117052966887,0.288577174248634,-0.424691493108372,
  -9.70889734138725e-05,0.00112440423289839,0.303760438832577,-0.451363526268457,
  -0.000100908962982316,0.00179269141283012,0.31894370341652,-0.478035559428543,
  -0.000104728952551425,0.0024609785927614,0.334126968000463,-0.504707592588628,
  -0.000108548942120423,0.00312926577269268,0.349310232584406,-0.531379625748713,
  -0.000112368931688978,0.00379755295262463,0.364493497168349,-0.558051658908798,
  -0.000116188921258087,0.00446584013255524,0.379676761752292,-0.584723692068883,
  -0.00012000891082653,0.00513412731248808,0.394860026336236,-0.611395725228968,
  -0.00012382890039575,0.00580241449241869,0.410043290920179,-0.638067758389054,
  -0.000127648889964527,0.00647070167234975,0.425226555504121,-0.664739791549139,
  -0.000131468879533081,0.0071389888522817,0.440409820088065,-0.691411824709224,
  -0.000135288869101968,0.00780727603221365,0.455593084672008,-0.718083857869309,
  -4.3103981690551e-05,-0.00818422557750659,0.0910602743446279,-0.078091223542111,
  -4.68426985407444e-05,-0.00751955902889478,0.106180648528959,-0.10480706597173,
  -5.05814153909656e-05,-0.00685489248028326,0.12130102271329,-0.131522908401349,
  -5.43201322412978e-05,-0.00619022593167173,0.136421396897621,-0.158238750830968,
  -5.80588490916023e-05,-0.00552555938305999,0.151541771081952,-0.184954593260587,
  -6.17975659417125e-05,-0.00486089283444835,0.166662145266282,-0.211670435690206,
  -6.55362827922112e-05,-0.00419622628583705,0.181782519450613,-0.238386278119826,
  -6.92749996424324e-05,-0.00353155973722541,0.196902893634944,-0.265102120549445,
  -7.30137164928202e-05,-0.00286689318861377,0.212023267819275,-0.291817962979064,
  -7.67524333427083e-05,-0.00220222664000191,0.227143642003606,-0.318533805408683,
  -8.04911501930961e-05,-0.0015375600913905,0.242264016187936,-0.345249647838302,
  -8.42298670430397e-05,-0.000872893542778419,0.257384390372268,-0.371965490267921,
  -8.7968583893816e-05,-0.000208226994167227,0.272504764556599,-0.39868133269754,
  -9.17073007439262e-05,0.000456439554444632,0.287625138740929,-0.425397175127159,
  -9.54460175939253e-05,0.00112110610305649,0.30274551292526,-0.452113017556778,
  -9.91847344442576e-05,0.00178577265166791,0.317865887109591,-0.478828859986398,
  -0.000102923451294479,0.00245043920027954,0.332986261293922,-0.505544702416017,
  -0.000106662168144922,0.00311510574889118,0.348106635478253,-0.532260544845636,
  -0.000110400884995254,0.00377977229750237,0.363227009662583,-0.558976387275255,
  -0.000114139601845475,0.00444443884611445,0.378347383846915,-0.585692229704874,
  -0.000117878318695475,0.00510910539472587,0.393467758031245,-0.612408072134493,
  -0.000121617035545918,0.00577377194333772,0.408588132215576,-0.639123914564112,
  -0.000125355752395917,0.00643843849194914,0.423708506399907,-0.665839756993731,
  -0.00012909446924636,0.00710310504056055,0.438828880584238,-0.69255559942335,
  -0.000132833186096248,0.00776777158917241,0.453949254768569,-0.71927144185297,
  -4.24165047226421e-05,-0.00812023932709,0.0908770912732962,-0.0782760887561202,
  -4.60458757737259e-05,-0.00746061366440209,0.105911877835496,-0.105051410620858,
  -4.96752468248096e-05,-0.00680098800171414,0.120946664397695,-0.131826732485596,
  -5.33046178758378e-05,-0.00614136233902618,0.135981450959895,-0.158602054350334,
  -5.69339889267551e-05,-0.005481736676338,0.151016237522094,-0.185377376215072,
  -6.05633599780053e-05,-0.00482211101365038,0.166051024084293,-0.21215269807981,
  -6.4192731028867e-05,-0.00416248535096231,0.181085810646493,-0.238928019944548,
  -6.78221020800063e-05,-0.00350285968827435,0.196120597208692,-0.265703341809286,
  -7.14514731309235e-05,-0.00284323402558639,0.211155383770892,-0.292478663674024,
  -7.50808441821738e-05,-0.00218360836289855,0.226190170333091,-0.319253985538762,
  -7.87102152332575e-05,-0.00152398270021092,0.24122495689529,-0.3460293074035,
  -8.23395862839527e-05,-0.000864357037522412,0.25625974345749,-0.372804629268238,
  -8.59689573354805e-05,-0.00020473137483501,0.271294530019689,-0.399579951132976,
  -8.95983283857316e-05,0.000454894287853946,0.286329316581889,-0.426355272997714,
  -9.32276994374259e-05,0.00111451995054113,0.301364103144088,-0.453130594862452,
  -9.68570704880101e-05,0.00177414561322942,0.316398889706287,-0.47990591672719,
  -0.00010048644153926,0.00243377127591748,0.331433676268487,-0.506681238591928,
  -0.000104115812590289,0.00309339693860511,0.346468462830686,-0.533456560456666,
  -0.000107745183640984,0.0037530226012934,0.361503249392886,-0.560231882321404,
  -0.000111374554692456,0.00441264826398102,0.376538035955085,-0.587007204186142,
  -0.000115003925743262,0.00507227392666953,0.391572822517285,-0.61378252605088,
  -0.000118633296794401,0.00573189958935716,0.406607609079484,-0.640557847915618,
  -0.000122262667845541,0.00639152525204523,0.421642395641684,-0.667333169780356,
  -0.000125892038896347,0.0070511509147333,0.436677182203883,-0.694108491645094,
  -0.00012952140994793,0.00771077657742003,0.451711968766082,-0.720883813509833,
  -4.14905306511115e-05,-0.00803497930851171,0.0906300224053497,-0.078524279428037,
  -4.49749343499617e-05,-0.00738234814739813,0.105549537680614,-0.105379455369414,
  -4.84593380489229e-05,-0.00672971698628466,0.120469052955878,-0.132234631310791,
  -5.19437417477175e-05,-0.00607708582517108,0.135388568231143,-0.159089807252168,
  -5.54281454466232e-05,-0.0054244546640575,0.150308083506407,-0.185944983193545,
  -5.89125491455289e-05,-0.00477182350294414,0.165227598781671,-0.212800159134922,
  -6.23969528445456e-05,-0.00411919234183078,0.180147114056936,-0.239655335076299,
  -6.58813565431182e-05,-0.00346656118071664,0.1950666293322,-0.266510511017676,
  -6.93657602419684e-05,-0.00281393001960306,0.209986144607464,-0.293365686959053,
  -7.2850163940763e-05,-0.00216129885848959,0.224905659882729,-0.320220862900431,
  -7.63345676396132e-05,-0.0015086676973759,0.239825175157993,-0.347076038841807,
  -7.98189713385189e-05,-0.000856036536262428,0.254744690433257,-0.373931214783185,
  -8.33033750378132e-05,-0.000203405375149623,0.269664205708521,-0.400786390724562,
  -8.67877787363858e-05,0.000449225785964513,0.284583720983786,-0.427641566665939,
  -9.02721824354025e-05,0.00110185694707776,0.29950323625905,-0.454496742607316,
  -9.37565861341971e-05,0.00175448810819145,0.314422751534315,-0.481351918548693,
  -9.72409898332138e-05,0.00240711926930492,0.329342266809579,-0.50820709449007,
  -0.000100725393532008,0.00305975043041884,0.344261782084843,-0.535062270431447,
  -0.000104209797230914,0.00371238159153187,0.359181297360107,-0.561917446372824,
  -0.000107694200929487,0.004365012752646,0.374100812635372,-0.588772622314201,
  -0.000111178604628392,0.00501764391375925,0.389020327910636,-0.615627798255578,
  -0.000114663008327742,0.00567027507487206,0.4039398431859,-0.642482974196955,
  -0.000118147412026204,0.00632290623598708,0.418859358461166,-0.669338150138332,
  -0.000121631815725332,0.00697553739709988,0.433778873736429,-0.69619332607971,
  -0.000125116219423349,0.00762816855821447,0.448698389011694,-0.723048502021087,
  -4.02606149702278e-05,-0.00792335697679852,0.0903012669809651,-0.0788525176998919,
  -4.35565936896254e-05,-0.00728037590829322,0.105067689406134,-0.105813302622921,
  -4.68525724090507e-05,-0.00663739483978809,0.119834111831304,-0.132774087545949,
  -5.01485511282818e-05,-0.00599441377128263,0.134600534256473,-0.159734872468978,
  -5.34445298475128e-05,-0.00535143270277716,0.149366956681643,-0.186695657392007,
  -5.67405085671879e-05,-0.00470845163427203,0.164133379106812,-0.213656442315036,
  -6.00364872863079e-05,-0.00406547056576656,0.178899801531981,-0.240617227238064,
  -6.333246600565e-05,-0.00342248949726132,0.19366622395715,-0.267578012161093,
  -6.66284447251586e-05,-0.00277950842875585,0.20843264638232,-0.294538797084122,
  -6.99244234446117e-05,-0.00213652736025094,0.223199068807489,-0.321499582007151,
  -7.32204021637872e-05,-0.00149354629174536,0.237965491232659,-0.348460366930179,
  -7.65163808830738e-05,-0.000850565223240007,0.252731913657828,-0.375421151853208,
  -7.98123596028599e-05,-0.000207584154735319,0.267498336082997,-0.402381936776237,
  -8.31083383215914e-05,0.000435396913771147,0.282264758508167,-0.429342721699265,
  -8.64043170409889e-05,0.0010783779822765,0.297031180933336,-0.456303506622294,
  -8.97002957606086e-05,0.00172135905078119,0.311797603358505,-0.483264291545323,
  -9.29962744797841e-05,0.00236434011928655,0.326564025783675,-0.510225076468352,
  -9.62922531992927e-05,0.0030073211877919,0.341330448208844,-0.53718586139138,
  -9.95882319184682e-05,0.00365030225629703,0.356096870634013,-0.564146646314409,
  -0.000102884210638421,0.00429328332480194,0.370863293059183,-0.591107431237438,
  -0.000106180189357707,0.00493626439330752,0.385629715484352,-0.618068216160466,
  -0.000109476168076772,0.0055792454618131,0.400396137909521,-0.645029001083495,
  -0.000112772146795614,0.00622222653031912,0.415162560334691,-0.671989786006524,
  -0.000116068125515345,0.00686520759882381,0.42992898275986,-0.698950570929553,
  -0.000119364104235298,0.0075081886673285,0.444695405185029,-0.725911355852581,
  -3.86569647305435e-05,-0.00778056098095492,0.0898716229858205,-0.0792780987456773,
  -4.17143859098856e-05,-0.00715077028090649,0.104438459646998,-0.106375812188959,
  -4.47718070892278e-05,-0.00652097958085796,0.119005296308177,-0.133473525632242,
  -4.78292282686532e-05,-0.00589118888080975,0.133572132969354,-0.160571239075524,
  -5.08866494480786e-05,-0.00526139818076155,0.148138969630532,-0.187668952518806,
  -5.39440706273653e-05,-0.00463160748071312,0.16270580629171,-0.214766665962088,
  -5.70014918070405e-05,-0.0040018167806648,0.177272642952888,-0.24186437940537,
  -6.00589129863827e-05,-0.00337202608061649,0.191839479614066,-0.268962092848653,
  -6.31163341656693e-05,-0.00274223538056817,0.206406316275244,-0.296059806291935,
  -6.61737553447894e-05,-0.00211244468051919,0.220973152936422,-0.323157519735217,
  -6.92311765241871e-05,-0.00148265398047109,0.2355399895976,-0.350255233178499,
  -7.22885977036958e-05,-0.000852863280422778,0.250106826258778,-0.377352946621781,
  -7.53460188829269e-05,-0.000223072580374017,0.264673662919956,-0.404450660065063,
  -7.84034400623801e-05,0.000406718119674077,0.279240499581134,-0.431548373508346,
  -8.14608612416112e-05,0.00103650881972239,0.293807336242312,-0.458646086951628,
  -8.45182824206203e-05,0.00166629951977137,0.30837417290349,-0.48574380039491,
  -8.75757036007396e-05,0.0022960902198188,0.322941009564668,-0.512841513838192,
  -9.06331247799708e-05,0.00292588091986756,0.337507846225846,-0.539939227281474,
  -9.36905459594239e-05,0.00355567161991521,0.352074682887023,-0.567036940724757,
  -9.67479671386551e-05,0.00418546231996419,0.366641519548202,-0.594134654168039,
  -9.98053883176642e-05,0.00481525302001318,0.38120835620938,-0.621232367611321,
  -0.000102862809497561,0.00544504372006127,0.395775192870558,-0.648330081054603,
  -0.000105920230676571,0.00607483442010981,0.410342029531736,-0.675427794497885,
  -0.000108977651856024,0.00670462512015879,0.424908866192914,-0.702525507941168,
  -0.000112035073035144,0.00733441582020689,0.439475702854092,-0.72962322138445,
  -3.66157987935489e-05,-0.0076032241914849,0.08932318112222,-0.0798159268761991,
  -3.93813574805502e-05,-0.00699120007977883,0.103636028336712,-0.107086683763949,
  -4.21469161677457e-05,-0.00637917596807303,0.117948875551203,-0.1343574406517,
  -4.49124748545804e-05,-0.00576715185636689,0.132261722765694,-0.16162819753945,
  -4.76780335414984e-05,-0.00515512774466043,0.146574569980186,-0.1888989544272,
  -5.04435922285551e-05,-0.00454310363295463,0.160887417194678,-0.216169711314951,
  -5.32091509157229e-05,-0.00393107952124849,0.175200264409169,-0.243440468202701,
  -5.59747096028351e-05,-0.00331905540954269,0.189513111623661,-0.270711225090451,
  -5.87402682897809e-05,-0.00270703129783656,0.203825958838152,-0.297981981978201,
  -6.15058269768931e-05,-0.00209500718613054,0.218138806052644,-0.325252738865952,
  -6.42713856636723e-05,-0.00148298307442429,0.232451653267135,-0.352523495753702,
  -6.7036944350618e-05,-0.000870958962717827,0.246764500481627,-0.379794252641452,
  -6.98025030380078e-05,-0.000258934851012471,0.261077347696118,-0.407065009529203,
  -7.25680617252866e-05,0.000353089260693107,0.27539019491061,-0.434335766416953,
  -7.53336204118993e-05,0.000965113372399795,0.289703042125101,-0.461606523304703,
  -7.8099179098956e-05,0.00157713748410537,0.304015889339593,-0.488877280192453,
  -8.08647377865679e-05,0.0021891615958114,0.318328736554085,-0.516148037080204,
  -8.36302964734026e-05,0.0028011857075172,0.332641583768576,-0.543418793967954,
  -8.63958551602373e-05,0.00341320981922344,0.346954430983067,-0.570689550855704,
  -8.91614138475161e-05,0.00402523393092924,0.361267278197559,-0.597960307743455,
  -9.19269725347949e-05,0.00463725804263548,0.375580125412051,-0.625231064631205,
  -9.46925312212965e-05,0.00524928215434128,0.389892972626541,-0.652501821518955,
  -9.74580899089084e-05,0.00586130626604708,0.404205819841033,-0.679772578406705,
  -0.000100223648595188,0.00647333037775422,0.418518667055525,-0.707043335294456,
  -0.000102989207282578,0.00708535448945957,0.432831514270016,-0.734314092182206,
  -3.40960517092037e-05,-0.00739098692626106,0.0886437839778648,-0.0804740146847633,
  -3.65197484325508e-05,-0.00680237154852958,0.102643171415431,-0.107956507952026,
  -3.89434451558979e-05,-0.00621375617079811,0.116642558852997,-0.135439001219288,
  -4.13671418791617e-05,-0.00562514079306653,0.130641946290562,-0.16292149448655,
  -4.37908386024533e-05,-0.00503652541533495,0.144641333728128,-0.190403987753812,
  -4.62145353260501e-05,-0.00444791003760392,0.158640721165694,-0.217886481021075,
  -4.86382320492584e-05,-0.00385929465987234,0.17264010860326,-0.245368974288337,
  -5.10619287727443e-05,-0.00327067928214098,0.186639496040826,-0.272851467555599,
  -5.34856254961191e-05,-0.00268206390440939,0.200638883478392,-0.300333960822862,
  -5.59093222192719e-05,-0.0020934485266777,0.214638270915958,-0.327816454090124,
  -5.83330189428688e-05,-0.00150483314894667,0.228637658353523,-0.355298947357386,
  -6.07567156661326e-05,-0.0009162177712152,0.242637045791089,-0.382781440624649,
  -6.31804123895074e-05,-0.000327602393483728,0.256636433228655,-0.410263933891911,
  -6.56041091128268e-05,0.000261012984247744,0.270635820666221,-0.437746427159173,
  -6.8027805835702e-05,0.00084962836197966,0.284635208103787,-0.465228920426436,
  -7.04515025593544e-05,0.00143824373971069,0.298634595541352,-0.492711413693698,
  -7.28751992826737e-05,0.00202685911744238,0.312633982978918,-0.52019390696096,
  -7.52988960062151e-05,0.00261547449517363,0.326633370416484,-0.547676400228222,
  -7.77225927294234e-05,0.00320408987290555,0.34063275785405,-0.575158893495485,
  -8.01462894525207e-05,0.0037927052506368,0.354632145291616,-0.602641386762747,
  -8.2569986176062e-05,0.00438132062836827,0.368631532729182,-0.630123880030009,
  -8.49936828991593e-05,0.00496993600609974,0.382630920166747,-0.657606373297272,
  -8.74173796228117e-05,0.00555855138383121,0.396630307604314,-0.685088866564534,
  -8.98410763465751e-05,0.00614716676156224,0.410629695041879,-0.712571359831796,
  -9.22647730693393e-05,0.00673578213929416,0.424629082479445,-0.740053853099059,
  -3.11005306776468e-05,-0.00714803056391161,0.0878328342118803,-0.0812481718479604,
  -3.31447504075266e-05,-0.00658930953292436,0.101459703410679,-0.108979746214698,
  -3.51889701373231e-05,-0.00603058850193694,0.115086572609478,-0.136711320581436,
  -3.72331898670919e-05,-0.00547186747094963,0.128713441808277,-0.164442894948174,
  -3.92774095969717e-05,-0.00491314643996243,0.142340311007076,-0.192174469314912,
  -4.1321629326796e-05,-0.00435442540897513,0.155967180205875,-0.21990604368165,
  -4.33658490568423e-05,-0.00379570437798804,0.169594049404674,-0.247637618048388,
  -4.5410068786389e-05,-0.00323698334700051,0.183220918603473,-0.275369192415125,
  -4.74542885163798e-05,-0.00267826231601331,0.196847787802272,-0.303100766781863,
  -4.9498508246093e-05,-0.00211954128502612,0.210474657001071,-0.330832341148601,
  -5.15427279760283e-05,-0.0015608202540387,0.22410152619987,-0.358563915515339,
  -5.35869477056861e-05,-0.00100209922305128,0.237728395398669,-0.386295489882077,
  -5.56311674355658e-05,-0.000443378192063859,0.251355264597468,-0.414027064248815,
  -5.76753871652791e-05,0.000115342838923338,0.264982133796267,-0.441758638615552,
  -5.97196068954364e-05,0.000674063869910313,0.278609002995066,-0.46949021298229,
  -6.17638266248166e-05,0.00123278490089818,0.292235872193865,-0.497221787349028,
  -6.38080463548629e-05,0.00179150593188493,0.305862741392663,-0.524953361715766,
  -6.58522660846872e-05,0.00235022696287257,0.319489610591463,-0.552684936082504,
  -6.78964858144004e-05,0.00290894799385999,0.333116479790262,-0.580416510449242,
  -6.99407055446688e-05,0.00346766902484674,0.346743348989061,-0.60814808481598,
  -7.1984925274271e-05,0.00402639005583438,0.360370218187859,-0.635879659182717,
  -7.40291450042063e-05,0.00458511108682114,0.373997087386658,-0.663611233549455,
  -7.60733647344747e-05,0.00514383211780833,0.387623956585457,-0.691342807916193,
  -7.81175844636328e-05,0.00570255314879642,0.401250825784256,-0.719074382282931,
  -8.01618041933461e-05,0.00626127417978362,0.414877694983055,-0.746805956649669,
  -2.76949814652927e-05,-0.0068837960383844,0.0869067615619287,-0.0821177985406446,
  -2.93440439205483e-05,-0.00636170187866747,0.100110309829948,-0.110129170838661,
  -3.09931063758595e-05,-0.00583960771895042,0.113313858097968,-0.138140543136678,
  -3.26421688311707e-05,-0.00531751355923349,0.126517406365987,-0.166151915434694,
  -3.42912312864541e-05,-0.00479541939951644,0.139720954634006,-0.194163287732711,
  -3.59402937417097e-05,-0.00427332523979951,0.152924502902026,-0.222174660030727,
  -3.75893561969098e-05,-0.00375123108008224,0.166128051170045,-0.250186032328744,
  -3.9238418652221e-05,-0.00322913692036531,0.179331599438065,-0.27819740462676,
  -4.08874811077542e-05,-0.00270704276064881,0.192535147706084,-0.306208776924777,
  -4.25365435630654e-05,-0.00218494860093177,0.205738695974104,-0.334220149222793,
  -4.4185606018321e-05,-0.0016628544412145,0.218942244242123,-0.36223152152081,
  -4.58346684737987e-05,-0.00114076028149812,0.232145792510142,-0.390242893818826,
  -4.74837309288878e-05,-0.000618666121780853,0.245349340778162,-0.418254266116843,
  -4.91327933841434e-05,-9.65719620635852e-05,0.258552889046181,-0.446265638414859,
  -5.07818558396211e-05,0.000425522197653017,0.271756437314201,-0.474277010712876,
  -5.24309182947658e-05,0.000947616357370284,0.28495998558222,-0.502288383010892,
  -5.40799807499104e-05,0.00146971051708711,0.29816353385024,-0.530299755308909,
  -5.57290432052771e-05,0.00199180467680393,0.311367082118259,-0.558311127606925,
  -5.73781056603107e-05,0.00251389883652142,0.324570630386279,-0.586322499904942,
  -5.90271681160104e-05,0.0030359929962378,0.337774178654298,-0.614333872202958,
  -6.0676230571266e-05,0.00355808715595529,0.350977726922318,-0.642345244500975,
  -6.23252930266327e-05,0.00408018131567189,0.364181275190337,-0.670356616798991,
  -6.39743554813332e-05,0.00460227547538938,0.377384823458356,-0.698367989097008,
  -6.56234179374771e-05,0.00512436963510554,0.390588371726375,-0.726379361395024,
  -6.72724803927327e-05,0.00564646379482259,0.403791919994395,-0.754390733693041,
  -2.40145463735741e-05,-0.00661209284973829,0.0859012639790929,-0.0830454532095383,
  -2.52809823776956e-05,-0.00613263163969541,0.0986475716772185,-0.111355293642768,
  -2.65474183817893e-05,-0.0056531704296523,0.111393879375344,-0.139665134075998,
  -2.78138543860496e-05,-0.00517370921960947,0.12414018707347,-0.167974974509229,
  -2.908029039006e-05,-0.00469424800956642,0.136886494771596,-0.196284814942459,
  -3.03467263941815e-05,-0.00421478679952358,0.149632802469721,-0.224594655375689,
  -3.16131623983029e-05,-0.00373532558948075,0.162379110167847,-0.252904495808919,
  -3.28795984025354e-05,-0.00325586437943781,0.175125417865972,-0.281214336242149,
  -3.41460344065458e-05,-0.00277640316939487,0.187871725564098,-0.309524176675379,
  -3.54124704106673e-05,-0.00229694195935215,0.200618033262223,-0.337834017108609,
  -3.66789064148443e-05,-0.00181748074930899,0.213364340960349,-0.366143857541839,
  -3.79453424189102e-05,-0.00133801953926604,0.226110648658475,-0.39445369797507,
  -3.92117784225876e-05,-0.000858558329222436,0.238856956356601,-0.4227635384083,
  -4.04782144269866e-05,-0.000379097119180161,0.251603264054726,-0.45107337884153,
  -4.17446504310526e-05,0.000100364090863003,0.264349571752852,-0.47938321927476,
  -4.30110864354516e-05,0.000579825300905501,0.277095879450977,-0.50769305970799,
  -4.42775224396286e-05,0.00105928651094844,0.289842187149103,-0.53600290014122,
  -4.55439584438055e-05,0.00153874772099138,0.302588494847228,-0.56431274057445,
  -4.68103944477605e-05,0.00201820893103477,0.315334802545354,-0.59262258100768,
  -4.80768304516044e-05,0.00249767014107771,0.32808111024348,-0.62093242144091,
  -4.93432664563365e-05,0.00297713135111977,0.340827417941605,-0.64924226187414,
  -5.06097024595142e-05,0.00345659256116404,0.353573725639731,-0.677552102307371,
  -5.18761384643573e-05,0.00393605377120609,0.366320033337856,-0.705861942740601,
  -5.31425744684233e-05,0.00441551498124904,0.379066341035982,-0.734171783173831,
  -5.44090104721562e-05,0.00489497619129242,0.391812648734108,-0.762481623607061,
  -2.024860122668e-05,-0.00634846484767609,0.0848676598048198,-0.0839820054716886,
  -2.1172586532503e-05,-0.00591578612376553,0.0971464011409162,-0.11259317679516,
  -2.20965718385202e-05,-0.00548310739985514,0.109425142477013,-0.141204348118631,
  -2.30205571442599e-05,-0.00505042867594441,0.121703883813109,-0.169815519442102,
  -2.39445424501938e-05,-0.0046177499520339,0.133982625149205,-0.198426690765574,
  -2.48685277561833e-05,-0.0041850712281235,0.146261366485302,-0.227037862089045,
  -2.57925130618952e-05,-0.00375239250421255,0.158540107821398,-0.255649033412516,
  -2.67164983678292e-05,-0.00331971378030227,0.170818849157494,-0.284260204735988,
  -2.76404836739297e-05,-0.0028870350563921,0.183097590493591,-0.312871376059459,
  -2.85644689798081e-05,-0.00245435633248103,0.195376331829687,-0.34148254738293,
  -2.948845428552e-05,-0.00202167760857042,0.207655073165784,-0.370093718706401,
  -3.04124395913985e-05,-0.00158899888466024,0.21993381450188,-0.398704890029873,
  -3.13364248972769e-05,-0.00115632016074962,0.232212555837976,-0.427316061353344,
  -3.22604102030999e-05,-0.000723641436839007,0.244491297174073,-0.455927232676815,
  -3.31843955089228e-05,-0.000290962712928167,0.256770038510169,-0.484538404000286,
  -3.41083808149678e-05,0.000141716010982007,0.269048779846266,-0.513149575323758,
  -3.50323661209018e-05,0.000574394734892403,0.281327521182362,-0.541760746647229,
  -3.59563514263916e-05,0.00100707345880346,0.293606262518458,-0.5703719179707,
  -3.68803367324366e-05,0.00143975218271386,0.305885003854555,-0.598983089294172,
  -3.78043220388147e-05,0.00187243090662337,0.31816374519065,-0.627594260617643,
  -3.87283073436384e-05,0.00230510963053554,0.330442486526747,-0.656205431941114,
  -3.96522926497944e-05,0.00273778835444594,0.342721227862844,-0.684816603264585,
  -4.05762779555063e-05,0.00317046707835678,0.354999969198941,-0.713427774588056,
  -4.15002632626615e-05,0.0036031458022654,0.367278710535036,-0.742038945911528,
  -4.24242485678183e-05,0.00403582452617757,0.379557451871134,-0.770650117234999,
  -1.66046072638815e-05,-0.00610674845149206,0.0838632239709511,-0.0848764364913305,
  -1.72458415884369e-05,-0.0057222667830471,0.0956898557338712,-0.11377538641115,
  -1.78870759132144e-05,-0.00533778511460259,0.107516487496791,-0.142674336330969,
  -1.85283102375478e-05,-0.00495330344615741,0.119343119259711,-0.171573286250788,
  -1.91695445621587e-05,-0.00456882177771267,0.131169751022631,-0.200472236170607,
  -1.98107788866309e-05,-0.0041843401092676,0.142996382785551,-0.229371186090426,
  -2.04520132112695e-05,-0.00379985844082287,0.154823014548471,-0.258270136010245,
  -2.10932475357417e-05,-0.0034153767723778,0.166649646311391,-0.287169085930064,
  -2.1734481860658e-05,-0.00303089510393328,0.178476278074311,-0.316068035849883,
  -2.23757161850746e-05,-0.00264641343548822,0.190302909837231,-0.344966985769702,
  -2.30169505094913e-05,-0.00226193176704315,0.202129541600151,-0.373865935689521,
  -2.3658184834241e-05,-0.00187745009859852,0.213956173363071,-0.40276488560934,
  -2.42994191586021e-05,-0.00149296843015323,0.225782805125991,-0.431663835529159,
  -2.49406534835739e-05,-0.00110848676170927,0.23760943688891,-0.460562785448978,
  -2.55818878076575e-05,-0.000724005093263758,0.24943606865183,-0.489461735368798,
  -2.62231221324072e-05,-0.000339523424818688,0.261262700414751,-0.518360685288616,
  -2.68643564570459e-05,4.49582436257145e-05,0.27308933217767,-0.547259635208436,
  -2.75055907817956e-05,0.00042943991207034,0.28491596394059,-0.576158585128255,
  -2.81468251061012e-05,0.000813921580515409,0.29674259570351,-0.605057535048074,
  -2.87880594307399e-05,0.00119840324896048,0.30856922746643,-0.633956484967893,
  -2.94292937557117e-05,0.0015828849174051,0.32039585922935,-0.662855434887712,
  -3.00705280801283e-05,0.00196736658584973,0.33222249099227,-0.691754384807531,
  -3.0711762404656e-05,0.0023518482542948,0.34404912275519,-0.72065333472735,
  -3.13529967286286e-05,0.00273632992274031,0.35587575451811,-0.749552284647169,
  -3.19942310532673e-05,0.00312081159118538,0.36770238628103,-0.778451234566988,
  -1.32643123506859e-05,-0.00589635286828044,0.0829389981464266,-0.0856864416886958,
  -1.36895836624906e-05,-0.00555849310559758,0.0943514979743686,-0.114846006629252,
  -1.41148549741288e-05,-0.00522063334291434,0.105763997802311,-0.144005571569809,
  -1.45401262860168e-05,-0.00488277358023126,0.117176497630253,-0.173165136510365,
  -1.49653975977104e-05,-0.00454491381754829,0.128588997458195,-0.202324701450922,
  -1.53906689097094e-05,-0.00420705405486566,0.140001497286137,-0.231484266391479,
  -1.58159402214308e-05,-0.00386919429218235,0.151413997114079,-0.260643831332035,
  -1.62412115330968e-05,-0.00353133452949927,0.162826496942022,-0.289803396272592,
  -1.66664828447627e-05,-0.00319347476681631,0.174238996769964,-0.318962961213148,
  -1.70917541563731e-05,-0.00285561500413323,0.185651496597906,-0.348122526153705,
  -1.75170254682055e-05,-0.00251775524144993,0.197063996425848,-0.377282091094261,
  -1.79422967802045e-05,-0.00217989547876729,0.20847649625379,-0.406441656034818,
  -1.8367568092037e-05,-0.00184203571608421,0.219888996081732,-0.435601220975374,
  -1.87928394033143e-05,-0.00150417595340047,0.231301495909675,-0.464760785915931,
  -1.92181107154799e-05,-0.00116631619071805,0.242713995737617,-0.493920350856488,
  -1.96433820269792e-05,-0.000828456428034752,0.254126495565559,-0.523079915797044,
  -2.00686533391448e-05,-0.000490596665352339,0.265538995393501,-0.552239480737601,
  -2.04939246503111e-05,-0.000152736902668593,0.276951495221443,-0.581399045678157,
  -2.09191959623656e-05,0.000185122860014042,0.288363995049385,-0.610558610618714,
  -2.1344467273976e-05,0.000522982622697121,0.299776494877327,-0.63971817555927,
  -2.17697385852533e-05,0.000860842385380867,0.311188994705269,-0.668877740499827,
  -2.21950098975299e-05,0.00119870214806284,0.322601494533211,-0.698037305440383,
  -2.26202812092513e-05,0.00153656191074658,0.334013994361154,-0.72719687038094,
  -2.30455525206397e-05,0.00187442167343033,0.345426494189096,-0.756356435321496,
  -2.34708238334713e-05,0.00221228143611096,0.356838994017037,-0.785516000262053,
  -1.03507837654337e-05,-0.00572130633451018,0.0821302691350132,-0.0863854481388437,
  -1.06223777410486e-05,-0.0054259575270364,0.0931817986578394,-0.115769914822122,
  -1.08939717166356e-05,-0.0051306087195625,0.104233328180666,-0.1451543815054,
  -1.11655656923615e-05,-0.00483525991208866,0.115284857703492,-0.174538848188678,
  -1.1437159667893e-05,-0.00453991110461482,0.126336387226318,-0.203923314871956,
  -1.17087536436467e-05,-0.00424456229714121,0.137387916749144,-0.233307781555234,
  -1.19803476191782e-05,-0.00394921348966715,0.14843944627197,-0.262692248238512,
  -1.22519415948763e-05,-0.00365386468219342,0.159490975794797,-0.29207671492179,
  -1.25235355705189e-05,-0.0033585158747198,0.170542505317623,-0.321461181605068,
  -1.2795129546217e-05,-0.00306316706724585,0.181594034840449,-0.350845648288346,
  -1.30667235220261e-05,-0.00276781825977235,0.192645564363275,-0.380230114971624,
  -1.33383174975577e-05,-0.00247246945229818,0.203697093886102,-0.409614581654902,
  -1.36099114729227e-05,-0.00217712064482378,0.214748623408928,-0.43899904833818,
  -1.38815054488983e-05,-0.00188177183735094,0.225800152931754,-0.468383515021458,
  -1.41530994243189e-05,-0.00158642302987677,0.23685168245458,-0.497767981704736,
  -1.44246933997394e-05,-0.0012910742224026,0.247903211977407,-0.527152448388014,
  -1.46962873759371e-05,-0.00099572541492976,0.258954741500232,-0.556536915071292,
  -1.49678813512466e-05,-0.000700376607455366,0.270006271023059,-0.58592138175457,
  -1.52394753272223e-05,-0.000405027799981639,0.281057800545885,-0.615305848437848,
  -1.55110693027538e-05,-0.000109678992508133,0.292109330068711,-0.644690315121126,
  -1.57826632779523e-05,0.000185669814966261,0.303160859591537,-0.674074781804404,
  -1.6054257254039e-05,0.00048101862244021,0.314212389114364,-0.703459248487682,
  -1.63258512295705e-05,0.00077636742991416,0.32526391863719,-0.73284371517096,
  -1.65974452052131e-05,0.00107171623738722,0.336315448160016,-0.762228181854238,
  -1.68690391808557e-05,0.00136706504486162,0.347366977682842,-0.791612648537516,
  -7.91750545015013e-06,-0.00558100423806918,0.0814530923693547,-0.08696399491889,
  -8.08614557601395e-06,-0.00532243997700249,0.092203342817765,-0.116534606063426,
  -8.25478570212757e-06,-0.00506387571593603,0.102953593266175,-0.146105217207961,
  -8.42342582799138e-06,-0.00480531145486918,0.113703843714586,-0.175675828352497,
  -8.59206595399398e-06,-0.00454674719380255,0.124454094162996,-0.205246439497032,
  -8.76070607985779e-06,-0.00428818293273603,0.135204344611406,-0.234817050641568,
  -8.92934620588814e-06,-0.00402961867166962,0.145954595059816,-0.264387661786104,
  -9.09798633169645e-06,-0.00377105441060277,0.156704845508226,-0.293958272930639,
  -9.26662645783782e-06,-0.00351249014953625,0.167455095956637,-0.323528884075175,
  -9.43526658375715e-06,-0.00325392588846962,0.178205346405047,-0.35309949521971,
  -9.60390670950995e-06,-0.00299536162740277,0.188955596853457,-0.382670106364246,
  -9.77254683542927e-06,-0.00273679736633614,0.199705847301868,-0.412240717508781,
  -9.94118696140411e-06,-0.00247823310526929,0.210456097750278,-0.441811328653317,
  -1.0109827087379e-05,-0.0022196688442031,0.221206348198688,-0.471381939797853,
  -1.02784672133538e-05,-0.00196110458313625,0.231956598647098,-0.500952550942388,
  -1.04471073394397e-05,-0.00170254032207007,0.242706849095508,-0.530523162086924,
  -1.06157474655255e-05,-0.00144397606100322,0.253457099543919,-0.560093773231459,
  -1.07843875909452e-05,-0.00118541179993636,0.264207349992329,-0.589664384375995,
  -1.09530277171421e-05,-0.000926847538869513,0.27495760044074,-0.619234995520531,
  -1.1121667843339e-05,-0.00066828327780355,0.28570785088915,-0.648805606665066,
  -1.12903079687587e-05,-0.000409719016736254,0.29645810133756,-0.678376217809602,
  -1.14589480951777e-05,-0.000151154755669847,0.30720835178597,-0.707946828954137,
  -1.16275882211525e-05,0.000107409505396561,0.317958602234381,-0.737517440098673,
  -1.17962283469053e-05,0.000365973766463412,0.328708852682791,-0.767088051243209,
  -1.19648684726581e-05,0.000624538027530264,0.339459103131201,-0.796658662387744,
  -5.95790820895337e-06,-0.0054718284239843,0.0809066293812432,-0.0874265160356373,
  -6.0607982790839e-06,-0.00524371553294883,0.0914143830249319,-0.11714594097893,
  -6.16368834926995e-06,-0.00501560264191359,0.10192213666862,-0.146865365922222,
  -6.26657841937273e-06,-0.00478748975087784,0.112429890312309,-0.176584790865514,
  -6.36946848930897e-06,-0.00455937685984231,0.122937643955998,-0.206304215808806,
  -6.47235855966155e-06,-0.0043312639688069,0.133445397599686,-0.236023640752099,
  -6.57524862973657e-06,-0.00410315107777159,0.143953151243375,-0.265743065695391,
  -6.67813869986711e-06,-0.00387503818673596,0.154460904887064,-0.295462490638683,
  -6.78102877010867e-06,-0.00364692529570076,0.164968658530752,-0.325181915581976,
  -6.88391884018369e-06,-0.00341881240466524,0.175476412174441,-0.354901340525268,
  -6.98680891053627e-06,-0.00319069951363016,0.185984165818129,-0.38462076546856,
  -7.08969898027823e-06,-0.00296258662259441,0.196491919461818,-0.414340190411853,
  -7.19258905035325e-06,-0.00273447373155866,0.206999673105507,-0.444059615355145,
  -7.29547912092787e-06,-0.00250636084052402,0.217507426749195,-0.473779040298437,
  -7.39836919072534e-06,-0.00227824794948805,0.228015180392884,-0.503498465241729,
  -7.50125926129996e-06,-0.00205013505845342,0.238522934036572,-0.533217890185022,
  -7.60414933109743e-06,-0.00182202216741723,0.249030687680261,-0.562937315128314,
  -7.70703940156103e-06,-0.00159390927638214,0.259538441323949,-0.592656740071606,
  -7.80992947124748e-06,-0.00136579638534617,0.270046194967638,-0.622376165014899,
  -7.91281954204415e-06,-0.00113768349431131,0.280553948611327,-0.652095589958191,
  -8.01570961173059e-06,-0.000909570603275345,0.291061702255015,-0.681815014901483,
  -8.11859968186113e-06,-0.000681457712240263,0.301569455898704,-0.711534439844776,
  -8.22148975176962e-06,-0.000453344821204293,0.312077209542392,-0.741253864788068,
  -8.32437982167811e-06,-0.000225231930168768,0.322584963186081,-0.77097328973136,
  -8.42726989214171e-06,2.88096086675793e-06,0.33309271682977,-0.800692714674652,
  -4.42546953025036e-06,-0.00538878111252727,0.0804786202161186,-0.0877861327909007,
  -4.48779988349024e-06,-0.00518498642541804,0.0907968232344126,-0.117621262582057,
  -4.55013023675788e-06,-0.00498119173830891,0.101115026252706,-0.147456392373214,
  -4.61246059024756e-06,-0.00477739705120006,0.111433229271,-0.177291522164371,
  -4.67479094318213e-06,-0.00457360236409032,0.121751432289295,-0.207126651955527,
  -4.7371212966163e-06,-0.00436980767698159,0.132069635307588,-0.236961781746684,
  -4.79945164988393e-06,-0.0041660129898724,0.142387838325882,-0.266796911537841,
  -4.86178200304055e-06,-0.00396221830276289,0.152706041344176,-0.296632041328998,
  -4.92411235641921e-06,-0.00375842361565404,0.16302424436247,-0.326467171120154,
  -4.9864427094648e-06,-0.00355462892854463,0.173342447380764,-0.356302300911311,
  -5.04877306284346e-06,-0.00335083424143545,0.183660650399058,-0.386137430702468,
  -5.11110341644416e-06,-0.00314703955432694,0.193978853417352,-0.415972560493624,
  -5.17343376926771e-06,-0.00294324486721709,0.204297056435646,-0.445807690284781,
  -5.2357641228129e-06,-0.00273945018010835,0.21461525945394,-0.475642820075938,
  -5.29809447613605e-06,-0.00253565549299939,0.224933462472233,-0.505477949867095,
  -5.36042482957022e-06,-0.00233186080589065,0.235251665490527,-0.535313079658251,
  -5.42275518278235e-06,-0.00212806611878147,0.245569868508821,-0.565148209449408,
  -5.4850855356614e-06,-0.00192427143167118,0.255888071527116,-0.594983339240564,
  -5.54741588909557e-06,-0.00172047674456244,0.266206274545409,-0.624818469031721,
  -5.60974624219668e-06,-0.00151668205745326,0.276524477563703,-0.654653598822878,
  -5.67207659529778e-06,-0.00131288737034385,0.286842680581997,-0.684488728614035,
  -5.734406948954e-06,-0.00110909268323489,0.297160883600291,-0.714323858405191,
  -5.79673730238817e-06,-0.000905297996126819,0.307479086618584,-0.744158988196348,
  -5.85906765526722e-06,-0.000701503309016527,0.317797289636879,-0.773994117987505,
  -5.92139800892344e-06,-0.000497708621907567,0.328115492655173,-0.803829247778661,
  -3.25436557427339e-06,-0.00532667556094296,0.0801511491377326,-0.0880597373212555,
  -3.29221476833008e-06,-0.00514175923455507,0.0903245483128141,-0.11798289796775,
  -3.330063962248e-06,-0.00495684290816711,0.100497947487895,-0.147906058614245,
  -3.36791315613816e-06,-0.00477192658177927,0.110671346662977,-0.17782921926074,
  -3.40576235008383e-06,-0.00458701025539121,0.120844745838058,-0.207752379907234,
  -3.44361154408501e-06,-0.00440209392900348,0.131018145013139,-0.237675540553729,
  -3.48146073786415e-06,-0.00421717760261509,0.141191544188221,-0.267598701200224,
  -3.51930993164329e-06,-0.00403226127622691,0.151364943363303,-0.297521861846718,
  -3.55715912608856e-06,-0.00384734494983974,0.161538342538384,-0.327445022493213,
  -3.59500831970117e-06,-0.00366242862345145,0.171711741713465,-0.357368183139708,
  -3.63285751364684e-06,-0.00347751229706339,0.181885140888546,-0.387291343786202,
  -3.67070670792558e-06,-0.00329259597067599,0.192058540063628,-0.417214504432697,
  -3.70855590137165e-06,-0.00310767964428749,0.202231939238709,-0.447137665079192,
  -3.74640509592794e-06,-0.00292276331790009,0.212405338413791,-0.477060825725686,
  -3.78425428926299e-06,-0.00273784699151181,0.222578737588872,-0.506983986372181,
  -3.82210348337519e-06,-0.00255293066512396,0.232752136763953,-0.536907147018676,
  -3.85995267759842e-06,-0.00236801433873612,0.242925535939035,-0.566830307665171,
  -3.89780187082245e-06,-0.00218309801234695,0.253098935114117,-0.596753468311665,
  -3.93565106526772e-06,-0.00199818168596,0.263272334289198,-0.62667662895816,
  -3.97350025937993e-06,-0.00181326535957194,0.273445733464279,-0.656599789604654,
  -4.01134945315906e-06,-0.00162834903318387,0.28361913263936,-0.686522950251149,
  -4.04919864704922e-06,-0.00144343270679581,0.293792531814442,-0.716446110897644,
  -4.08704784093938e-06,-0.00125851638040819,0.303965930989523,-0.746369271544139,
  -4.12489703482954e-06,-0.00107360005402013,0.314139330164604,-0.776292432190633,
  -4.16274622849766e-06,-0.000888683727631623,0.324312729339686,-0.806215592837128,
  -2.37504888861428e-06,-0.005280810421116,0.079905056501776,-0.0882644842368586,
  -2.39826720455083e-06,-0.00511023439952679,0.0899697611605282,-0.11825352115406,
  -2.42148552068167e-06,-0.00493965837793764,0.10003446581928,-0.148242558071262,
  -2.4447038368125e-06,-0.00476908235634865,0.110099170478033,-0.178231594988464,
  -2.46792215274905e-06,-0.00459850633475933,0.120163875136785,-0.208220631905666,
  -2.49114046879662e-06,-0.00442793031317035,0.130228579795537,-0.238209668822868,
  -2.5143587848997e-06,-0.00425735429158125,0.140293284454289,-0.26819870574007,
  -2.53757710094726e-06,-0.00408677826999182,0.150357989113042,-0.298187742657271,
  -2.5607954168283e-06,-0.00391620224840272,0.160422693771794,-0.328176779574473,
  -2.58401373265382e-06,-0.00374562622681296,0.170487398430546,-0.358165816491675,
  -2.60723204908997e-06,-0.00357505020522431,0.180552103089298,-0.388154853408877,
  -2.63045036485998e-06,-0.00340447418363476,0.190616807748051,-0.418143890326079,
  -2.65366868101857e-06,-0.00323389816204567,0.200681512406803,-0.448132927243281,
  -2.67688699728819e-06,-0.00306332214045724,0.210746217065555,-0.478121964160482,
  -2.70010531333575e-06,-0.00289274611886792,0.220810921724307,-0.508111001077684,
  -2.72332362893923e-06,-0.00272217009727838,0.230875626383059,-0.538100037994886,
  -2.74654194531987e-06,-0.00255159407568883,0.240940331041812,-0.568089074912088,
  -2.76976026114539e-06,-0.00238101805409974,0.251005035700564,-0.59807811182929,
  -2.79297857763705e-06,-0.00221044203251108,0.261069740359316,-0.628067148746492,
  -2.81619689346257e-06,-0.00203986601092243,0.271134445018068,-0.658056185663694,
  -2.83941520973219e-06,-0.00186928998933267,0.281199149676821,-0.688045222580896,
  -2.86263352566873e-06,-0.00169871396774379,0.291263854335573,-0.718034259498098,
  -2.88585184138324e-06,-0.00152813794615403,0.301328558994325,-0.748023296415299,
  -2.90907015798592e-06,-0.0013575619245656,0.311393263653077,-0.778012333332501,
  -2.93228847381144e-06,-0.00118698590297628,0.321457968311829,-0.808001370249703,
  -1.7235237572133e-06,-0.00524724759180278,0.0797225997427357,-0.0884158125911222,
  -1.73799350300374e-06,-0.0050873877606607,0.0897067850021773,-0.118453538630706,
  -1.75246324873868e-06,-0.00492752792951845,0.099690970261619,-0.14849126467029,
  -1.76693299461239e-06,-0.00476766809837637,0.109675155521061,-0.178528990709874,
  -1.78140274020855e-06,-0.00460780826723406,0.119659340780502,-0.208566716749458,
  -1.79587248605451e-06,-0.00444794843609186,0.129643526039944,-0.238604442789041,
  -1.81034223178944e-06,-0.00428808860494978,0.139627711299386,-0.268642168828625,
  -1.82481197752438e-06,-0.00412822877380759,0.149611896558827,-0.298679894868209,
  -1.83928172348136e-06,-0.00396836894266572,0.159596081818269,-0.328717620907793,
  -1.85375146899425e-06,-0.00380850911152297,0.169580267077711,-0.358755346947377,
  -1.86822121511776e-06,-0.00364864928038133,0.179564452337152,-0.388793072986961,
  -1.88269096079718e-06,-0.00348878944923925,0.189548637596594,-0.418830799026545,
  -1.89716070664314e-06,-0.00332892961809717,0.199532822856036,-0.448868525066129,
  -1.91163045226705e-06,-0.00316906978695464,0.209517008115478,-0.478906251105712,
  -1.92610019800199e-06,-0.00300920995581233,0.219501193374919,-0.508943977145296,
  -1.94056994406999e-06,-0.00284935012467114,0.22948537863436,-0.53898170318488,
  -1.95503968924982e-06,-0.00268949029352794,0.239469563893803,-0.569019429224464,
  -1.96950943509577e-06,-0.00252963046238563,0.249453749153244,-0.599057155264048,
  -1.98397918105275e-06,-0.00236977063124399,0.259437934412686,-0.629094881303632,
  -1.99844892678769e-06,-0.00220991080010169,0.269422119672128,-0.659132607343215,
  -2.0129186724116e-06,-0.00205005096895983,0.279406304931569,-0.689170333382799,
  -2.02738841803551e-06,-0.00189019113781708,0.289390490191011,-0.719208059422383,
  -2.04185816365943e-06,-0.00173033130667477,0.299374675450453,-0.749245785461967,
  -2.05632790994947e-06,-0.00157047147553335,0.309358860709894,-0.779283511501551,
  -2.07079765657259e-06,-0.00141061164439282,0.319343045969335,-0.809321237541135,
  -1.24551046420951e-06,-0.00522284953621327,0.0795886724021008,-0.0885266361822533,
  -1.25470114031856e-06,-0.00507090084651973,0.0895137913536916,-0.11860001914428,
  -1.2638918163721e-06,-0.00491895215682614,0.0994389103052823,-0.148673402106307,
  -1.27308249239788e-06,-0.00476700346713244,0.109364029256873,-0.178746785068334,
  -1.28227316836815e-06,-0.00461505477743873,0.119289148208464,-0.20882016803036,
  -1.29146384436618e-06,-0.00446310608774481,0.129214267160055,-0.238893550992387,
  -1.30065452041972e-06,-0.00431115739805121,0.139139386111646,-0.268966933954414,
  -1.30984519647326e-06,-0.00415920870835773,0.149064505063237,-0.299040316916441,
  -1.31903587241577e-06,-0.00400726001866381,0.158989624014828,-0.329113699878468,
  -1.32822654869136e-06,-0.00385531132897055,0.168914742966418,-0.359187082840494,
  -1.33741722446734e-06,-0.0037033626392764,0.178839861918009,-0.389260465802521,
  -1.34660790079844e-06,-0.00355141394958336,0.1887649808696,-0.419333848764548,
  -1.35579857651891e-06,-0.00339946525988921,0.198690099821191,-0.449407231726575,
  -1.36498925273898e-06,-0.00324751657019573,0.208615218772781,-0.479480614688602,
  -1.37417992884803e-06,-0.00309556788050225,0.218540337724372,-0.509553997650628,
  -1.38337060473503e-06,-0.0029436191908081,0.228465456675963,-0.539627380612655,
  -1.39256128084408e-06,-0.00279167050111506,0.238390575627554,-0.569700763574682,
  -1.40175195695313e-06,-0.00263972181142091,0.248315694579145,-0.599774146536709,
  -1.41094263272912e-06,-0.00248777312172699,0.258240813530736,-0.629847529498736,
  -1.42013330928226e-06,-0.00233582443203462,0.268165932482326,-0.659920912460763,
  -1.42932398450313e-06,-0.00218387574233914,0.278091051433918,-0.689994295422789,
  -1.43851466094524e-06,-0.00203192705264632,0.288016170385508,-0.720067678384816,
  -1.44770533738736e-06,-0.0018799783629535,0.297941289337099,-0.750141061346843,
  -1.45689601238619e-06,-0.00172802967325802,0.30786640828869,-0.78021444430887,
  -1.46608668905035e-06,-0.00157608098356521,0.317791527240281,-0.810287827270897,
  -8.97327714383112e-07,-0.00520519823579557,0.0794910877134545,-0.0886072515340195,
  -9.03283094738638e-07,-0.00505903788916073,0.0893731881145652,-0.1187065720723,
  -9.09238475260699e-07,-0.00491287754252623,0.0992552885156758,-0.14880589261058,
  -9.15193855616225e-07,-0.00476671719589161,0.109137388916786,-0.17890521314886,
  -9.2114923611053e-07,-0.004620556849257,0.119019489317897,-0.20900453368714,
  -9.27104616577079e-07,-0.00447439650262238,0.128901589719008,-0.23910385422542,
  -9.33059996988117e-07,-0.00432823615598754,0.138783690120118,-0.269203174763701,
  -9.39015377343644e-07,-0.00418207580935293,0.148665790521229,-0.299302495301981,
  -9.44970757810193e-07,-0.00403591546271831,0.158547890922339,-0.329401815840261,
  -9.50926138276742e-07,-0.00388975511608391,0.16842999132345,-0.359501136378541,
  -9.56881518854313e-07,-0.0037435947694493,0.178312091724561,-0.389600456916821,
  -9.62836899154329e-07,-0.00359743442281468,0.188194192125671,-0.419699777455102,
  -9.68792279287811e-07,-0.0034512740761794,0.198076292526782,-0.449799097993382,
  -9.74747660031916e-07,-0.00330511372954501,0.207958392927893,-0.479898418531662,
  -9.80703040553976e-07,-0.00315895338291083,0.217840493329003,-0.509997739069942,
  -9.86658420853992e-07,-0.00301279303627555,0.227722593730114,-0.540097059608222,
  -9.92613801042985e-07,-0.00286663268964049,0.237604694131225,-0.570196380146503,
  -9.9856918178709e-07,-0.00272047234300632,0.247486794532335,-0.600295700684783,
  -1.00452456253119e-06,-0.00257431199637237,0.257368894933445,-0.630395021223063,
  -1.01047994260917e-06,-0.00242815164973686,0.267250995334557,-0.660494341761343,
  -1.01643532313123e-06,-0.00228199130310269,0.277133095735667,-0.690593662299623,
  -1.02239070354226e-06,-0.00213583095646808,0.287015196136777,-0.720692982837904,
  -1.02834608450841e-06,-0.00198967060983435,0.296897296537888,-0.750792303376184,
  -1.0343014641423e-06,-0.0018435102631984,0.306779396938999,-0.780891623914464,
  -1.04025684477538e-06,-0.00169734991656423,0.316661497340109,-0.810990944452744,
  -5.0058779060641e-05,-0.00874943061523603,0.10152775478316,-0.087746140739364,
  -5.42177514088749e-05,-0.00807646185555561,0.116761755025814,-0.113667167375043,
  -5.83767237571919e-05,-0.00740349309587529,0.131995755268469,-0.139588194010721,
  -6.2535696105398e-05,-0.00673052433619481,0.147229755511123,-0.1655092206464,
  -6.6694668453382e-05,-0.00605755557651411,0.162463755753778,-0.191430247282079,
  -7.08536408016713e-05,-0.00538458681683374,0.177697755996432,-0.217351273917757,
  -7.50126131497386e-05,-0.00471161805715326,0.192931756239087,-0.243272300553436,
  -7.91715854980835e-05,-0.004038649297473,0.208165756481741,-0.269193327189115,
  -8.33305578462062e-05,-0.0033656805377924,0.223399756724396,-0.295114353824793,
  -8.74895301944956e-05,-0.0026927117781117,0.238633756967051,-0.321035380460472,
  -9.16485025426739e-05,-0.00201974301843144,0.253867757209705,-0.346956407096151,
  -9.58074748910742e-05,-0.00134677425875118,0.269101757452359,-0.372877433731829,
  -9.9966447239086e-05,-0.000673805499070479,0.284335757695014,-0.398798460367508,
  -0.000104125419587375,-8.36739390219776e-07,0.299569757937668,-0.424719487003187,
  -0.000108284391935221,0.000672132020290483,0.314803758180323,-0.450640513638865,
  -0.000112443364283843,0.00134510077997052,0.330037758422977,-0.476561540274544,
  -0.000116602336632132,0.00201806953965122,0.345271758665632,-0.502482566910223,
  -0.000120761308980089,0.00269103829933193,0.360505758908287,-0.528403593545901,
  -0.000124920281328378,0.00336400705901219,0.375739759150941,-0.55432462018158,
  -0.000129079253676556,0.00403697581869222,0.390973759393595,-0.580245646817259,
  -0.000133238226024845,0.00470994457837337,0.40620775963625,-0.606166673452937,
  -0.000137397198373135,0.00538291333805319,0.421441759878904,-0.632087700088616,
  -0.000141556170721313,0.00605588209773389,0.436675760121559,-0.658008726724294,
  -0.000145715143068936,0.00672885085741504,0.451909760364213,-0.683929753359973,
  -0.000149874115417781,0.00740181961709441,0.467143760606868,-0.709850779995652,
  -4.97389312965335e-05,-0.00871725152278963,0.101438073036634,-0.0878372532864131,
  -5.38493482503399e-05,-0.00804611588991389,0.116635893956205,-0.113783773714845,
  -5.79597652041741e-05,-0.00737498025703809,0.131833714875777,-0.139730294143276,
  -6.20701821580361e-05,-0.00670384462416251,0.147031535795348,-0.165676814571708,
  -6.61805991118425e-05,-0.00603270899128661,0.16222935671492,-0.19162333500014,
  -7.02910160657599e-05,-0.00536157335841103,0.177427177634491,-0.217569855428571,
  -7.44014330195109e-05,-0.00469043772553546,0.192624998554062,-0.243516375857003,
  -7.85118499734283e-05,-0.00401930209265977,0.207822819473634,-0.269462896285435,
  -8.26222669273458e-05,-0.00334816645978409,0.223020640393205,-0.295409416713866,
  -8.67326838813742e-05,-0.00267703082690862,0.238218461312777,-0.321355937142298,
  -9.08431008350696e-05,-0.00200589519403271,0.253416282232348,-0.347302457570729,
  -9.49535177888206e-05,-0.00133475956115681,0.268614103151919,-0.373248977999161,
  -9.90639347425715e-05,-0.000663623928281121,0.283811924071491,-0.399195498427593,
  -0.0001031743516966,7.51170459456496e-06,0.299009744991062,-0.425142018856025,
  -0.000107284768650406,0.000678647337470251,0.314207565910634,-0.451088539284456,
  -0.000111395185603991,0.00134978297034594,0.329405386830205,-0.477035059712888,
  -0.000115505602558241,0.0020209186032214,0.344603207749776,-0.50298158014132,
  -0.000119616019511937,0.00269205423609775,0.359801028669348,-0.528928100569751,
  -0.000123726436465854,0.00336318986897277,0.374998849588919,-0.554874620998183,
  -0.000127836853419994,0.00403432550184801,0.39019667050849,-0.580821141426614,
  -0.000131947270374022,0.0047054611347237,0.405394491428062,-0.606767661855046,
  -0.000136057687327273,0.00537659676760027,0.420592312347634,-0.632714182283478,
  -0.00014016810428108,0.00604773240047596,0.435790133267205,-0.658660702711909,
  -0.000144278521235108,0.00671886803335164,0.450987954186777,-0.684607223140341,
  -0.000148388938189248,0.00739000366622689,0.466185775106348,-0.710553743568773,
  -4.92982031372602e-05,-0.00867311516561137,0.101314412654826,-0.0879626281311997,
  -5.33421268683332e-05,-0.00800454587266874,0.116462378068205,-0.113944229132099,
  -5.7386050599656e-05,-0.00733597657972618,0.131610343481584,-0.139925830132997,
  -6.14299743308677e-05,-0.00666740728678361,0.146758308894964,-0.165907431133896,
  -6.54738980620517e-05,-0.00599883799384104,0.161906274308343,-0.191889032134795,
  -6.95178217931525e-05,-0.00533026870089848,0.177054239721722,-0.217870633135694,
  -7.35617455243087e-05,-0.00466169940795569,0.192202205135101,-0.243852234136593,
  -7.76056692556315e-05,-0.00399313011501334,0.20735017054848,-0.269833835137492,
  -8.16495929867878e-05,-0.00332456082207044,0.22249813596186,-0.29581543613839,
  -8.56935167174999e-05,-0.00265599152912732,0.237646101375239,-0.321797037139289,
  -8.97374404488782e-05,-0.00198742223618509,0.252794066788618,-0.347778638140188,
  -9.37813641801455e-05,-0.00131885294324285,0.267942032201997,-0.373760239141087,
  -9.78252879109132e-05,-0.00065028365029951,0.283089997615376,-0.399741840141986,
  -0.000101869211642236,1.82856426431677e-05,0.298237963028756,-0.425723441142885,
  -0.00010591313537367,0.000686854935585179,0.313385928442135,-0.451705042143783,
  -0.00010995705910477,0.00135542422852786,0.328533893855514,-0.477686643144682,
  -0.000114000982836093,0.00202399352147054,0.343681859268893,-0.503668244145581,
  -0.000118044906567416,0.00269256281441299,0.358829824682273,-0.52964984514648,
  -0.000122088830298406,0.00336113210735567,0.373977790095652,-0.555631446147378,
  -0.000126132754029729,0.00402970140029835,0.389125755509031,-0.581613047148278,
  -0.000130176677760607,0.00469827069324102,0.40427372092241,-0.607594648149176,
  -0.000134220601491708,0.0053668399861837,0.419421686335789,-0.633576249150075,
  -0.000138264525223142,0.00603540927912594,0.434569651749168,-0.659557850150974,
  -0.000142308448954243,0.00670397857206861,0.449717617162547,-0.685539451151873,
  -0.00014635237268501,0.00737254786501174,0.464865582575927,-0.711521052152772,
  -4.86944684676138e-05,-0.00861303707949579,0.101144856267737,-0.0881340518436699,
  -5.26480844179056e-05,-0.00794805899594692,0.116224521346548,-0.114163618143973,
  -5.66017003680308e-05,-0.00728308091239793,0.13130418642536,-0.140193184444275,
  -6.05553163181283e-05,-0.00661810282884889,0.146383851504171,-0.166222750744578,
  -6.45089322683368e-05,-0.00595312474529996,0.161463516582983,-0.192252317044881,
  -6.84625482184065e-05,-0.0052881466617507,0.176543181661794,-0.218281883345184,
  -7.24161641684762e-05,-0.00462316857820155,0.191622846740606,-0.244311449645486,
  -7.63697801186014e-05,-0.00395819049465262,0.206702511819417,-0.270341015945789,
  -8.03233960689487e-05,-0.00329321241110403,0.221782176898228,-0.296370582246092,
  -8.42770120189629e-05,-0.00262823432755477,0.23686184197704,-0.322400148546395,
  -8.82306279688105e-05,-0.00196325624400551,0.251941507055851,-0.348429714846697,
  -9.21842439194354e-05,-0.00129827816045691,0.267021172134663,-0.374459281147,
  -9.6137859869394e-05,-0.00063330007690765,0.282100837213475,-0.400488847447303,
  -0.000100091475819797,3.1678006640723e-05,0.297180502292286,-0.426518413747606,
  -0.000104045091769978,0.000696656090189762,0.312260167371097,-0.452547980047908,
  -0.000107998707720047,0.0013616341737388,0.327339832449909,-0.478577546348211,
  -0.000111952323670228,0.00202661225728784,0.34241949752872,-0.504607112648514,
  -0.000115905939620076,0.00269159034083732,0.357499162607532,-0.530636678948817,
  -0.000119859555570367,0.00335656842438614,0.372578827686343,-0.556666245249119,
  -0.000123813171520326,0.00402154650793562,0.387658492765155,-0.582695811549422,
  -0.000127766787470285,0.00468652459148489,0.402738157843967,-0.608725377849725,
  -0.000131720403420799,0.00535150267503326,0.417817822922778,-0.634754944150028,
  -0.00013567401937109,0.00601648075858252,0.43289748800159,-0.66078451045033,
  -0.00013962763532116,0.00668145884213089,0.447977153080401,-0.686814076750633,
  -0.000143581251271452,0.00734643692568016,0.463056818159213,-0.712843643050936,
  -4.78740650391163e-05,-0.00853210234720342,0.100914156200479,-0.0883664036473179,
  -5.17064108839782e-05,-0.0078721436731175,0.115900999343048,-0.114460983262689,
  -5.55387567290067e-05,-0.00721218499903176,0.130887842485617,-0.14055556287806,
  -5.93711025739241e-05,-0.00655222632494612,0.145874685628185,-0.166650142493431,
  -6.32034484186472e-05,-0.00589226765085993,0.160861528770754,-0.192744722108802,
  -6.703579426387e-05,-0.0052323089767744,0.175848371913323,-0.218839301724173,
  -7.08681401085376e-05,-0.00457235030268832,0.190835215055892,-0.244933881339544,
  -7.47004859534828e-05,-0.00391239162860257,0.205822058198461,-0.271028460954915,
  -7.85328317984835e-05,-0.00325243295451694,0.220808901341029,-0.297123040570286,
  -8.23651776432621e-05,-0.00259247428043086,0.235795744483598,-0.323217620185658,
  -8.61975234884294e-05,-0.00193251560634544,0.250782587626167,-0.349312199801029,
  -9.00298693327639e-05,-0.00127255693225892,0.265769430768736,-0.3754067794164,
  -9.38622151779311e-05,-0.00061259825817328,0.280756273911305,-0.401501359031771,
  -9.76945610230429e-05,4.73604159121344e-05,0.295743117053873,-0.427595938647142,
  -0.000101526906867488,0.000707319089998659,0.310729960196442,-0.453690518262513,
  -0.000105359252712933,0.00136727776408385,0.325716803339011,-0.479785097877884,
  -0.00010919159855749,0.00202723643816993,0.34070364648158,-0.505879677493255,
  -0.000113023944402602,0.00268719511225557,0.355690489624149,-0.531974257108626,
  -0.000116856290247713,0.00334715378634121,0.370677332766717,-0.558068836723997,
  -0.000120688636091937,0.00400711246042773,0.385664175909286,-0.584163416339368,
  -0.000124520981937382,0.00466707113451292,0.400651019051855,-0.610257995954739,
  -0.000128353327782604,0.00532702980859856,0.415637862194424,-0.63635257557011,
  -0.000132185673626606,0.00598698848268553,0.430624705336993,-0.662447155185481,
  -0.000136018019472162,0.00664694715677072,0.445611548479562,-0.688541734800853,
  -0.000139850365317384,0.00730690583085591,0.46059839162213,-0.714636314416224,
  -4.67713460918506e-05,-0.0084245841700562,0.10060354094776,-0.0886776457729838,
  -5.0443330422395e-05,-0.0077716230812121,0.115465602675248,-0.11485931265026,
  -5.41153147529116e-05,-0.00711866199236821,0.130327664402736,-0.141040979527536,
  -5.77872990834838e-05,-0.00646570090352439,0.145189726130224,-0.167222646404813,
  -6.14592834138339e-05,-0.00581273981468011,0.160051787857712,-0.193404313282089,
  -6.51312677444338e-05,-0.00515977872583639,0.1749138495852,-0.219585980159366,
  -6.88032520751447e-05,-0.00450681763699257,0.189775911312688,-0.245767647036642,
  -7.24752364054115e-05,-0.00385385654814829,0.204637973040176,-0.271949313913918,
  -7.61472207359004e-05,-0.00320089545930435,0.219500034767663,-0.298130980791195,
  -7.98192050663893e-05,-0.00254793437046019,0.234362096495151,-0.324312647668471,
  -8.34911893968782e-05,-0.00189497328161625,0.249224158222639,-0.350494314545747,
  -8.71631737274225e-05,-0.00124201219277209,0.264086219950127,-0.376675981423024,
  -9.08351580578559e-05,-0.000589051103927929,0.278948281677615,-0.4028576483003,
  -9.45071423888999e-05,6.39099849153446e-05,0.293810343405103,-0.429039315177576,
  -9.81791267187226e-05,0.000716871073760394,0.308672405132591,-0.455220982054853,
  -0.000101851111049656,0.00136983216260345,0.323534466860079,-0.481402648932129,
  -0.000105523095380033,0.00202279325144783,0.338396528587567,-0.507584315809405,
  -0.000109195079710855,0.00267575434029133,0.353258590315054,-0.533765982686682,
  -0.000112867064041122,0.00332871542913571,0.368120652042542,-0.559947649563958,
  -0.000116539048371611,0.00398167651797987,0.382982713770031,-0.586129316441234,
  -0.000120211032702211,0.00463463760682314,0.397844775497518,-0.612310983318511,
  -0.000123883017032922,0.00528759869566731,0.412706837225006,-0.638492650195787,
  -0.000127555001363078,0.00594055978451191,0.427568898952494,-0.664674317073063,
  -0.000131226985694011,0.00659352087335519,0.442430960679982,-0.69085598395034,
  -0.000134898970024611,0.00724648196219935,0.45729302240747,-0.717037650827616,
  -4.53107414451481e-05,-0.00828438459144798,0.100191196783747,-0.0890880408760064,
  -4.87750104347096e-05,-0.00764113027100488,0.114887948612064,-0.115384538564649,
  -5.22392794244375e-05,-0.00699787595056189,0.129584700440381,-0.141681036253292,
  -5.57035484139712e-05,-0.0063546216301188,0.144281452268698,-0.167977533941934,
  -5.91678174035049e-05,-0.00571136730967536,0.158978204097015,-0.194274031630577,
  -6.26320863932328e-05,-0.0050681129892326,0.173674955925332,-0.220570529319219,
  -6.60963553827387e-05,-0.00442485866878917,0.188371707753649,-0.246867027007862,
  -6.95606243724112e-05,-0.00378160434834629,0.203068459581966,-0.273163524696505,
  -7.30248933621391e-05,-0.00313835002790341,0.217765211410283,-0.299460022385147,
  -7.6489162351423e-05,-0.00249509570745987,0.2324619632386,-0.32575652007379,
  -7.99534313412065e-05,-0.00185184138701699,0.247158715066917,-0.352053017762433,
  -8.34177003307124e-05,-0.00120858706657367,0.261855466895234,-0.378349515451075,
  -8.68819693206069e-05,-0.00056533274613102,0.276552218723551,-0.404646013139718,
  -9.03462383102793e-05,7.79215743120787e-05,0.291248970551867,-0.430942510828361,
  -9.38105072993967e-05,0.000721175894756065,0.305945722380185,-0.457239008517003,
  -9.72747762897352e-05,0.00136443021519783,0.320642474208501,-0.483535506205646,
  -0.00010073904527852,0.00200768453564182,0.335339226036818,-0.509832003894289,
  -0.000104203314268525,0.00265093885608425,0.350035977865135,-0.536128501582931,
  -0.000107667583258086,0.00329419317652779,0.364732729693452,-0.562424999271574,
  -0.000111131852247759,0.00393744749697111,0.37942948152177,-0.588721496960216,
  -0.000114596121237875,0.00458070181741332,0.394126233350086,-0.615017994648859,
  -0.000118060390227548,0.00522395613785687,0.408822985178404,-0.641314492337501,
  -0.000121524659216776,0.00586721045829952,0.42351973700672,-0.667610990026144,
  -0.000124988928206005,0.00651046477874351,0.438216488835037,-0.693907487714787,
  -0.000128453197195788,0.00715371909918661,0.452913240663354,-0.720203985403429,
  -4.34132682335386e-05,-0.00810596430317584,0.0996539807637659,-0.0896180681046644,
  -4.66157490368324e-05,-0.00747605506734977,0.114135926939613,-0.116062870332676,
  -4.98182298401817e-05,-0.00684614583152376,0.12861787311546,-0.142507672560687,
  -5.30207106436142e-05,-0.00621623659569792,0.143099819291307,-0.168952474788699,
  -5.62231914469913e-05,-0.00558632735987197,0.157581765467154,-0.19539727701671,
  -5.94256722504793e-05,-0.00495641812404612,0.172063711643001,-0.221842079244722,
  -6.26281530536899e-05,-0.00432650888821984,0.186545657818849,-0.248286881472733,
  -6.58306338569559e-05,-0.00369659965239377,0.201027603994696,-0.274731683700745,
  -6.90331146602774e-05,-0.00306669041656749,0.215509550170543,-0.301176485928756,
  -7.2235595464043e-05,-0.00243678118074242,0.22999149634639,-0.327621288156768,
  -7.54380762672535e-05,-0.00180687194491602,0.244473442522237,-0.354066090384779,
  -7.86405570706306e-05,-0.00117696270909007,0.258955388698084,-0.380510892612791,
  -8.18430378738411e-05,-0.000547053473264114,0.273437334873931,-0.406955694840802,
  -8.50455186776067e-05,8.28557625613957e-05,0.287919281049778,-0.433400497068814,
  -8.82479994805951e-05,0.000712764998388238,0.302401227225626,-0.459845299296825,
  -9.14504802842497e-05,0.00134267423421375,0.316883173401473,-0.486290101524837,
  -9.46529610874602e-05,0.0019725834700397,0.33136511957732,-0.512734903752848,
  -9.78554418905597e-05,0.00260249270586632,0.345847065753167,-0.53917970598086,
  -0.000101057922694325,0.00323240194169117,0.360329011929014,-0.565624508208871,
  -0.000104260403497647,0.00386231117751779,0.374810958104862,-0.592069310436883,
  -0.000107462884300746,0.00449222041334396,0.389292904280709,-0.618514112664894,
  -0.000110665365104734,0.00512212964916925,0.403774850456555,-0.644958914892906,
  -0.000113867845907278,0.00575203888499631,0.418256796632403,-0.671403717120917,
  -0.000117070326711044,0.0063819481208216,0.43273874280825,-0.697848519348929,
  -0.000120272807514366,0.00701185735664733,0.447220688984097,-0.72429332157694,
  -4.10094967634722e-05,-0.00788585184550522,0.0989709743399407,-0.0902845607802442,
  -4.3893562496955e-05,-0.00727401952321172,0.113180717835569,-0.116915851331686,
  -4.67776282303267e-05,-0.00666218720091816,0.127390461331197,-0.143547141883127,
  -4.96616939639205e-05,-0.00605035487862482,0.141600204826825,-0.170178432434568,
  -5.25457596971535e-05,-0.00543852255633093,0.155809948322453,-0.19680972298601,
  -5.5429825430664e-05,-0.00482669023403759,0.170019691818081,-0.223441013537451,
  -5.831389116423e-05,-0.00421485791174392,0.184229435313709,-0.250072304088892,
  -6.11979568976295e-05,-0.00360302558945047,0.198439178809337,-0.276703594640334,
  -6.4082022630918e-05,-0.00299119326715669,0.212648922304965,-0.303334885191775,
  -6.69660883643175e-05,-0.0023793609448628,0.226858665800594,-0.329966175743216,
  -6.9850154097828e-05,-0.00176752862256957,0.241068409296222,-0.356597466294657,
  -7.2734219831061e-05,-0.00115569630027568,0.25527815279185,-0.383228756846099,
  -7.56182855647936e-05,-0.000543863977982451,0.269487896287478,-0.40986004739754,
  -7.85023512981375e-05,6.79683443107759e-05,0.283697639783105,-0.436491337948982,
  -8.13864170315926e-05,0.000679800666604446,0.297907383278734,-0.463122628500423,
  -8.42704827652696e-05,0.00129163298889812,0.312117126774362,-0.489753919051864,
  -8.71545484990577e-05,0.00190346531119112,0.32632687026999,-0.516385209603306,
  -9.00386142319576e-05,0.00251529763348501,0.340536613765618,-0.543016500154747,
  -9.29226799651905e-05,0.00312712995577891,0.354746357261246,-0.569647790706188,
  -9.58067456986456e-05,0.00373896227807258,0.368956100756874,-0.59627908125763,
  -9.86908114323226e-05,0.00435079460036603,0.383165844252503,-0.622910371809071,
  -0.000101574877165889,0.00496262692265903,0.39737558774813,-0.649541662360512,
  -0.000104458942898678,0.00557445924495381,0.411585331243759,-0.676172952911953,
  -0.000107343008632244,0.00618629156724682,0.425795074739386,-0.702804243463395,
  -0.000110227074366587,0.00679812388953938,0.440004818235014,-0.729435534014836,
  -3.80596517962906e-05,-0.0076245671120399,0.0981291654083597,-0.0910950680558131,
  -4.05734806585289e-05,-0.00703666671454195,0.112004749814571,-0.117953143009374,
  -4.30873095206841e-05,-0.00644876631704372,0.125880334220783,-0.144811217962935,
  -4.5601138383089e-05,-0.00586086591954604,0.139755918626994,-0.171669292916496,
  -4.81149672451053e-05,-0.00527296552204759,0.153631503033206,-0.198527367870057,
  -5.06287961075103e-05,-0.0046850651245498,0.167507087439417,-0.225385442823618,
  -5.31426249695266e-05,-0.00409716472705157,0.181382671845629,-0.252243517777179,
  -5.56564538321536e-05,-0.00350926432955401,0.19525825625184,-0.27910159273074,
  -5.81702826940589e-05,-0.00292136393205555,0.209133840658052,-0.305959667684301,
  -6.06841115561307e-05,-0.0023334635345571,0.223009425064263,-0.332817742637863,
  -6.31979404187577e-05,-0.00174556313705998,0.236885009470474,-0.359675817591423,
  -6.57117692809961e-05,-0.00115766273956175,0.250760593876686,-0.386533892544985,
  -6.82255981431235e-05,-0.000569762342063518,0.264636178282898,-0.413391967498546,
  -7.07394270053063e-05,1.81380554347133e-05,0.278511762689109,-0.440250042452107,
  -7.32532558677113e-05,0.000606038452932056,0.29238734709532,-0.467108117405668,
  -7.57670847297831e-05,0.00119393885043051,0.306262931501532,-0.493966192359229,
  -7.82809135917439e-05,0.00178183924792896,0.320138515907744,-0.52082426731279,
  -8.07947424543709e-05,0.00236973964542653,0.334014100313955,-0.547682342266351,
  -8.33085713164428e-05,0.00295764004292476,0.347889684720166,-0.574540417219912,
  -8.58224001789587e-05,0.00354554044042255,0.361765269126378,-0.601398492173473,
  -8.83362290406975e-05,0.00413344083792078,0.375640853532589,-0.628256567127034,
  -9.08500579029914e-05,0.00472134123541901,0.389516437938801,-0.655114642080595,
  -9.33638867655073e-05,0.00530924163291679,0.403392022345012,-0.681972717034156,
  -9.58777156273571e-05,0.00589714203041458,0.417267606751223,-0.708830791987717,
  -9.83915444897621e-05,0.00648504242791326,0.431143191157436,-0.735688866941278,
  -3.45779145164704e-05,-0.00732835531256426,0.0971305622271952,-0.0920415337166216,
  -3.66844091888585e-05,-0.00677111474302738,0.110611573274943,-0.11916443497771,
  -3.87909038613854e-05,-0.00621387417349073,0.12409258432269,-0.146287336238799,
  -4.08973985337735e-05,-0.00565663360395396,0.137573595370438,-0.173410237499888,
  -4.30038932061061e-05,-0.00509939303441687,0.151054606418186,-0.200533138760977,
  -4.5110387878633e-05,-0.00454215246488043,0.164535617465933,-0.227656040022065,
  -4.72168825510488e-05,-0.00398491189534356,0.178016628513681,-0.254778941283154,
  -4.93233772231871e-05,-0.00342767132580635,0.191497639561429,-0.281901842544243,
  -5.14298718957695e-05,-0.00287043075626969,0.204978650609177,-0.309024743805332,
  -5.35363665684074e-05,-0.00231319018673326,0.218459661656924,-0.336147645066421,
  -5.56428612406012e-05,-0.00175594961719616,0.231940672704672,-0.363270546327509,
  -5.77493559131281e-05,-0.00119870904765929,0.24542168375242,-0.390393447588598,
  -5.9855850585655e-05,-0.000641468478122853,0.258902694800167,-0.417516348849687,
  -6.19623452577933e-05,-8.42279085857545e-05,0.272383705847915,-0.444639250110776,
  -6.40688399304867e-05,0.0004730126609509,0.285864716895663,-0.471762151371865,
  -6.61753346027361e-05,0.00103025323048822,0.299345727943411,-0.498885052632953,
  -6.82818292755405e-05,0.00158749380002421,0.312826738991158,-0.526007953894042,
  -7.03883239473457e-05,0.00214473436956153,0.326307750038906,-0.553130855155131,
  -7.24948186198171e-05,0.00270197493909818,0.339788761086653,-0.580253756416219,
  -7.46013132923995e-05,0.00325921550863484,0.353269772134401,-0.607376657677308,
  -7.67078079648709e-05,0.00381645607817171,0.366750783182149,-0.634499558938397,
  -7.88143026374533e-05,0.00437369664770859,0.380231794229897,-0.661622460199486,
  -8.09207973094805e-05,0.00493093721724591,0.393712805277644,-0.688745361460574,
  -8.30272919819519e-05,0.00548817778678234,0.407193816325392,-0.715868262721663,
  -8.51337866539792e-05,0.00604541835631967,0.42067482737314,-0.742991163982752,
  -3.06525281011105e-05,-0.00700973400874272,0.0959984432618401,-0.0930958073532768,
  -3.23392300514425e-05,-0.00649009642664439,0.10903440525097,-0.120513700187626,
  -3.40259320015801e-05,-0.00597045884454606,0.122070367240099,-0.147931593021976,
  -3.57126339517455e-05,-0.00545082126244745,0.135106329229229,-0.175349485856326,
  -3.73993359019109e-05,-0.00493118368034906,0.148142291218359,-0.202767378690675,
  -3.90860378523539e-05,-0.00441154609825101,0.161178253207488,-0.230185271525025,
  -4.07727398021307e-05,-0.00389190851615162,0.174214215196619,-0.257603164359374,
  -4.24594417525737e-05,-0.00337227093405379,0.187250177185748,-0.285021057193724,
  -4.41461437028501e-05,-0.00285263335195518,0.200286139174878,-0.312438950028074,
  -4.58328456530155e-05,-0.00233299576985702,0.213322101164008,-0.339856842862423,
  -4.75195476034584e-05,-0.00181335818775841,0.226358063153138,-0.367274735696773,
  -4.92062495536238e-05,-0.00129372060566046,0.239394025142267,-0.394692628531123,
  -5.08929515037337e-05,-0.000774083023561634,0.252429987131397,-0.422110521365472,
  -5.25796534536216e-05,-0.000254445441462803,0.265465949120527,-0.449528414199822,
  -5.42663554041756e-05,0.00026519214063514,0.278501911109656,-0.476946307034171,
  -5.59530573540634e-05,0.000784829722733971,0.291537873098786,-0.504364199868521,
  -5.76397593043954e-05,0.00130446730483214,0.304573835087916,-0.531782092702871,
  -5.93264612549493e-05,0.0018241048869303,0.317609797077046,-0.55919998553722,
  -6.10131632049482e-05,0.00234374246902935,0.330645759066176,-0.58661787837157,
  -6.2699865154392e-05,0.00286338005112841,0.343681721055305,-0.614035771205919,
  -6.43865671061672e-05,0.00338301763322457,0.356717683044434,-0.641453664040269,
  -6.60732690552779e-05,0.00390265521532474,0.369753645033565,-0.668871556874619,
  -6.77599710058319e-05,0.00442229279742268,0.382789607022694,-0.696289449708968,
  -6.94466729558307e-05,0.00494193037952151,0.395825569011824,-0.723707342543318,
  -7.11333749062737e-05,0.00546156796161945,0.408861531000954,-0.751125235377668,
  -2.64494376026603e-05,-0.00668598208688942,0.0947791461911116,-0.094210172661096,
  -2.77343182182865e-05,-0.00621005569337407,0.107338354713484,-0.121939871049442,
  -2.90191988338018e-05,-0.00573412929985873,0.119897563235857,-0.149669569437788,
  -3.0304079449428e-05,-0.00525820290634327,0.13245677175823,-0.177399267826133,
  -3.15889600651653e-05,-0.00478227651282837,0.145015980280602,-0.205128966214479,
  -3.28738406804585e-05,-0.00430635011931257,0.157575188802975,-0.232858664602825,
  -3.41587212962513e-05,-0.00383042372579745,0.170134397325348,-0.260588362991171,
  -3.54436019119331e-05,-0.0033544973322821,0.182693605847721,-0.288318061379517,
  -3.67284825276704e-05,-0.00287857093876709,0.195252814370094,-0.316047759767862,
  -3.8013363142908e-05,-0.00240264454525096,0.207812022892467,-0.343777458156208,
  -3.92982437585898e-05,-0.00192671815173595,0.220371231414839,-0.371507156544554,
  -4.0583124373994e-05,-0.00145079175822027,0.232930439937212,-0.3992368549329,
  -4.18680049897313e-05,-0.000974865364705257,0.245489648459585,-0.426966553321246,
  -4.31528856047469e-05,-0.000498938971188911,0.258048856981958,-0.454696251709591,
  -4.44377662207618e-05,-2.30125776745638e-05,0.27060806550433,-0.482425950097937,
  -4.57226468366656e-05,0.000452913815840672,0.283167274026703,-0.510155648486283,
  -4.70075274520143e-05,0.000928840209356574,0.295726482549076,-0.537885346874629,
  -4.8292408067363e-05,0.00140476660287181,0.308285691071449,-0.565615045262975,
  -4.95772886830448e-05,0.00188069299638705,0.320844899593822,-0.59334474365132,
  -5.08621692989486e-05,0.00235661938990184,0.333404108116194,-0.621074442039666,
  -5.21470499141863e-05,0.00283254578341818,0.345963316638568,-0.648804140428012,
  -5.34319305303121e-05,0.00330847217693275,0.35852252516094,-0.676533838816358,
  -5.47168111455498e-05,0.00378439857044865,0.371081733683313,-0.704263537204703,
  -5.60016917613426e-05,0.00426032496396367,0.383640942205686,-0.731993235593049,
  -5.72865723769134e-05,0.00473625135747913,0.396200150728059,-0.759722933981395,
  -2.21904635240855e-05,-0.00637564714269551,0.0935364647369939,-0.0953246333844103,
  -2.31200732917491e-05,-0.00594752312316504,0.105612365103849,-0.123366164024534,
  -2.40496830592185e-05,-0.0055193991036343,0.117688265470703,-0.151407694664657,
  -2.49792928268544e-05,-0.00509127508410401,0.129764165837558,-0.17944922530478,
  -2.59089025945736e-05,-0.00466315106457338,0.141840066204413,-0.207490755944904,
  -2.68385123621262e-05,-0.00423502704504308,0.153915966571267,-0.235532286585027,
  -2.77681221296788e-05,-0.00380690302551245,0.165991866938122,-0.26357381722515,
  -2.8697731897287e-05,-0.00337877900598182,0.178067767304977,-0.291615347865274,
  -2.96273416646731e-05,-0.00295065498645108,0.190143667671832,-0.319656878505397,
  -3.05569514327808e-05,-0.00252253096692101,0.202219568038687,-0.34769840914552,
  -3.14865612001669e-05,-0.00209440694739049,0.214295468405541,-0.375739939785644,
  -3.24161709682191e-05,-0.00166628292786086,0.226371368772395,-0.403781470425767,
  -3.33457807355497e-05,-0.00123815890832968,0.238447269139251,-0.43182300106589,
  -3.42753905027138e-05,-0.000810034888798272,0.250523169506106,-0.459864531706014,
  -3.5205000270655e-05,-0.000381910869267976,0.26259906987296,-0.487906062346137,
  -3.61346100381521e-05,4.62131502620977e-05,0.274674970239815,-0.51594759298626,
  -3.70642198060933e-05,0.000474337169792172,0.286750870606669,-0.543989123626384,
  -3.79938295733684e-05,0.000902461189323134,0.298826770973524,-0.572030654266507,
  -3.89234393414206e-05,0.00133058520885299,0.310902671340379,-0.600072184906631,
  -3.98530491085847e-05,0.00175870922838461,0.322978571707234,-0.628113715546754,
  -4.07826588758597e-05,0.00218683324791513,0.335054472074088,-0.656155246186877,
  -4.1712268643912e-05,0.00261495726744476,0.347130372440943,-0.684196776827001,
  -4.26418784115201e-05,0.00304308128697528,0.359206272807797,-0.712238307467124,
  -4.35714881793503e-05,0.0034712053065058,0.371282173174652,-0.740279838107247,
  -4.45010979468474e-05,0.00389932932603676,0.383358073541507,-0.76832136874737,
  -1.81092964162965e-05,-0.00609442506540392,0.092339161418845,-0.0963791729933219,
  -1.87491388606575e-05,-0.00571530823008992,0.103951741424497,-0.124715769627209,
  -1.93889813051573e-05,-0.00533619139477615,0.11556432143015,-0.153052366261096,
  -2.00288237498514e-05,-0.0049570745594627,0.127176901435802,-0.181388962894984,
  -2.06686661942124e-05,-0.00457795772414893,0.138789481441454,-0.209725559528871,
  -2.13085086385179e-05,-0.00419884088883482,0.150402061447107,-0.238062156162758,
  -2.19483510832119e-05,-0.00381972405352127,0.162014641452759,-0.266398752796645,
  -2.25881935274619e-05,-0.00344060721820716,0.173627221458412,-0.294735349430532,
  -2.32280359721004e-05,-0.00306149038289383,0.185239801464064,-0.32307194606442,
  -2.3867878416739e-05,-0.0026823735475805,0.196852381469716,-0.351408542698307,
  -2.45077208610445e-05,-0.00230325671226628,0.208464961475369,-0.379745139332194,
  -2.51475633050724e-05,-0.00192413987695206,0.220077541481021,-0.408081735966081,
  -2.57874057499885e-05,-0.00154502304163917,0.231690121486673,-0.436418332599969,
  -2.64272481942385e-05,-0.00116590620632495,0.243302701492326,-0.464754929233856,
  -2.70670906388215e-05,-0.000786789371011176,0.254915281497978,-0.493091525867743,
  -2.77069330829605e-05,-0.000407672535697179,0.26652786150363,-0.52142812250163,
  -2.83467755275435e-05,-2.85557003834036e-05,0.278140441509283,-0.549764719135517,
  -2.89866179723486e-05,0.000350561134929706,0.289753021514935,-0.578101315769404,
  -2.96264604167096e-05,0.000729677970243703,0.301365601520587,-0.606437912403291,
  -3.02663028611816e-05,0.0011087948055577,0.31297818152624,-0.634774509037179,
  -3.09061453060977e-05,0.00148791164087081,0.324590761531892,-0.663111105671066,
  -3.15459877504587e-05,0.00186702847618481,0.336203341537545,-0.691447702304953,
  -3.21858301944866e-05,0.0022461453114988,0.347815921543197,-0.71978429893884,
  -3.28256726390697e-05,0.0026252621468128,0.35942850154885,-0.748120895572728,
  -3.34655150839858e-05,0.00300437898212547,0.371041081554501,-0.776457492206615,
  -1.44024434682866e-05,-0.00585225334547468,0.0912463662770427,-0.0973260229863607,
  -1.48235312124601e-05,-0.00552027537389832,0.102437970731987,-0.125927553466052,
  -1.52446189566335e-05,-0.00518829740232207,0.113629575186932,-0.154529083945742,
  -1.56657067008348e-05,-0.00485631943074571,0.124821179641876,-0.183130614425433,
  -1.60867944450915e-05,-0.00452434145916925,0.136012784096821,-0.211732144905124,
  -1.6507882189154e-05,-0.004192363487593,0.147204388551766,-0.240333675384815,
  -1.69289699337161e-05,-0.0038603855160172,0.15839599300671,-0.268935205864506,
  -1.73500576775565e-05,-0.00352840754444017,0.169587597461655,-0.297536736344197,
  -1.7771145421952e-05,-0.00319642957286415,0.180779201916599,-0.326138266823888,
  -1.81922331660145e-05,-0.00286445160128768,0.191970806371544,-0.354739797303579,
  -1.86133209100214e-05,-0.00253247362971076,0.203162410826489,-0.38334132778327,
  -1.9034408654417e-05,-0.00220049565813518,0.214354015281433,-0.41194285826296,
  -1.94554963985905e-05,-0.00186851768655849,0.225545619736378,-0.440544388742651,
  -1.98765841425974e-05,-0.0015365397149818,0.236737224191323,-0.469145919222342,
  -2.02976718876036e-05,-0.00120456174340688,0.247928828646267,-0.497747449702033,
  -2.07187596309444e-05,-0.000872583771829083,0.259120433101212,-0.526348980181724,
  -2.11398473756175e-05,-0.000540605800253502,0.270312037556156,-0.554950510661415,
  -2.15609351198465e-05,-0.000208627828677033,0.281503642011101,-0.583552041141106,
  -2.19820228638534e-05,0.000123350142899881,0.292695246466046,-0.612153571620797,
  -2.24031106076383e-05,0.000455328114476128,0.30388685092099,-0.640755102100487,
  -2.28241983523114e-05,0.000787306086052375,0.315078455375935,-0.669356632580178,
  -2.32452860965404e-05,0.00111928405762818,0.326270059830879,-0.697958163059869,
  -2.36663738407694e-05,0.00145126202920487,0.337461664285824,-0.72655969353956,
  -2.40874615848874e-05,0.00178324000078112,0.348653268740768,-0.755161224019251,
  -2.45085493290054e-05,0.00211521797235692,0.359844873195712,-0.783762754498942,
  -1.11956750544762e-05,-0.00565263731943455,0.0902970633076586,-0.0981369688707207,
  -1.14627406947176e-05,-0.0053633973446745,0.101124377882493,-0.126965406477688,
  -1.17298063349314e-05,-0.00507415736991468,0.111951692457328,-0.155793844084655,
  -1.19968719753671e-05,-0.00478491739515507,0.122779007032162,-0.184622281691623,
  -1.22639376156641e-05,-0.00449567742039525,0.133606321606997,-0.21345071929859,
  -1.25310032560999e-05,-0.00420643744563565,0.144433636181831,-0.242279156905557,
  -1.27980688963691e-05,-0.00391719747087582,0.155260950756666,-0.271107594512525,
  -1.30651345369714e-05,-0.00362795749611622,0.1660882653315,-0.299936032119492,
  -1.33322001771297e-05,-0.00333871752135617,0.176915579906335,-0.32876446972646,
  -1.35992658176209e-05,-0.00304947754659657,0.187742894481169,-0.357592907333427,
  -1.38663314576681e-05,-0.00276023757183652,0.198570209056004,-0.386421344940394,
  -1.41333970979374e-05,-0.00247099759707647,0.209397523630839,-0.415249782547362,
  -1.44004627384842e-05,-0.00218175762231732,0.220224838205673,-0.444078220154329,
  -1.46675283788644e-05,-0.00189251764755749,0.231052152780507,-0.472906657761296,
  -1.49345940188006e-05,-0.00160327767279722,0.241879467355342,-0.501735095368264,
  -1.52016596595139e-05,-0.00131403769803762,0.252706781930176,-0.530563532975231,
  -1.54687252994501e-05,-0.00102479772327735,0.263534096505011,-0.559391970582198,
  -1.57357909403855e-05,-0.000735557748518634,0.274361411079845,-0.588220408189166,
  -1.60028565808767e-05,-0.000446317773758809,0.28518872565468,-0.617048845796133,
  -1.62699222199247e-05,-0.000157077798997651,0.296016040229514,-0.645877283403101,
  -1.65369878610822e-05,0.000132162175761508,0.306843354804349,-0.674705721010068,
  -1.68040535013514e-05,0.000421402150521111,0.317670669379184,-0.703534158617035,
  -1.70711191419537e-05,0.00071064212528027,0.328497983954018,-0.732362596224003,
  -1.7338184782334e-05,0.000999882100040317,0.339325298528852,-0.76119103383097,
  -1.76052504223811e-05,0.00128912207480036,0.350152613103687,-0.790019471437937,
  -8.53627198391105e-06,-0.00549387608430107,0.0895071105732167,-0.0988038979201813,
  -8.70110285366987e-06,-0.00524142307825587,0.10003224520615,-0.127818945950395,
  -8.86593372320665e-06,-0.00498897007221011,0.110557379839084,-0.156833993980609,
  -9.03076459266017e-06,-0.00473651706616451,0.121082514472018,-0.185849042010823,
  -9.19559546241899e-06,-0.00448406406011925,0.131607649104952,-0.214864090041036,
  -9.36042633220557e-06,-0.00423161105407388,0.142132783737886,-0.24387913807125,
  -9.5252572017146e-06,-0.00397915804802829,0.152657918370819,-0.272894186101464,
  -9.6900880716122e-06,-0.00372670504198336,0.163183053003753,-0.301909234131678,
  -9.8549189410102e-06,-0.00347425203593765,0.173708187636687,-0.330924282161892,
  -1.00197498106858e-05,-0.00322179902989195,0.184233322269621,-0.359939330192105,
  -1.01845806801393e-05,-0.00296934602384646,0.194758456902554,-0.388954378222319,
  -1.03494115502034e-05,-0.00271689301780165,0.205283591535488,-0.417969426252533,
  -1.05142424191573e-05,-0.00246444001175528,0.215808726168422,-0.446984474282747,
  -1.06790732894435e-05,-0.00221198700571046,0.226333860801355,-0.47599952231296,
  -1.08439041586195e-05,-0.00195953399966431,0.236858995434289,-0.505014570343174,
  -1.10087350281285e-05,-0.00170708099361883,0.247384130067223,-0.534029618373388,
  -1.11735658978596e-05,-0.00145462798757379,0.257909264700157,-0.563044666403602,
  -1.13383967679237e-05,-0.00120217498152897,0.26843439933309,-0.592059714433815,
  -1.15032276370997e-05,-0.00094972197548282,0.278959533966024,-0.621074762464029,
  -1.16680585069417e-05,-0.000697268969437559,0.289484668598958,-0.650089810494243,
  -1.18328893772279e-05,-0.000444815963393186,0.300009803231891,-0.679104858524457,
  -1.19977202459598e-05,-0.000192362957346592,0.310534937864825,-0.70811990655467,
  -1.21625511158019e-05,6.00900486991129e-05,0.321060072497759,-0.737134954584884,
  -1.2327381985866e-05,0.000312543054743486,0.331585207130693,-0.766150002615098,
  -1.24922128547089e-05,0.000564996060790079,0.342110341763627,-0.795165050645312,
  -6.40692016448674e-06,-0.0053710999246836,0.0888728918428511,-0.0993343209497565,
  -6.50696889714641e-06,-0.0051489622806824,0.0991560307723809,-0.128497784266617,
  -6.60701762988936e-06,-0.00492682463668104,0.109439169701911,-0.157661247583477,
  -6.70706636268781e-06,-0.0047046869926799,0.119722308631441,-0.186824710900338,
  -6.80711509537524e-06,-0.00448254934867875,0.130005447560971,-0.215988174217198,
  -6.90716382828471e-06,-0.00426041170467784,0.140288586490501,-0.245151637534059,
  -7.0072125607501e-06,-0.00403827406067636,0.150571725420031,-0.274315100850919,
  -7.10726129382611e-06,-0.00381613641667555,0.160854864349561,-0.303478564167779,
  -7.20731002623598e-06,-0.00359399877267408,0.17113800327909,-0.33264202748464,
  -7.30735875920097e-06,-0.00337186112867305,0.18142114220862,-0.3618054908015,
  -7.40740749172186e-06,-0.0031497234846718,0.19170428113815,-0.39096895411836,
  -7.5074562244648e-06,-0.00292758584067077,0.20198742006768,-0.420132417435221,
  -7.60750495754081e-06,-0.00270544819666951,0.21227055899721,-0.449295880752081,
  -7.7075536905058e-06,-0.00248331055266848,0.22255369792674,-0.478459344068942,
  -7.80760242291567e-06,-0.00226117290866701,0.23283683685627,-0.507622807385802,
  -7.90765115599168e-06,-0.00203903526466642,0.2431199757858,-0.536786270702662,
  -8.0076998886236e-06,-0.00181689762066495,0.25340311471533,-0.565949734019523,
  -8.10774862125552e-06,-0.00159475997666414,0.263686253644859,-0.595113197336383,
  -8.20779735388744e-06,-0.00137262233266267,0.27396939257439,-0.624276660653243,
  -8.30784608663038e-06,-0.00115048468866163,0.284252531503919,-0.653440123970104,
  -8.40789482015047e-06,-0.000928347044661493,0.294535670433449,-0.682603587286964,
  -8.50794355211626e-06,-0.000706209400658686,0.30481880936298,-0.711767050603825,
  -8.60799228508125e-06,-0.0004840717566581,0.315101948292509,-0.740930513920685,
  -8.70804101815725e-06,-0.000261934112657958,0.325385087222038,-0.770093977237545,
  -8.80808975034508e-06,-3.97964686555952e-05,0.335668226151569,-0.799257440554406,
  -4.7493710347013e-06,-0.00527815649809937,0.0883781638102335,-0.0997450522043126,
  -4.80971551430898e-06,-0.00508013826492776,0.0984729004798276,-0.129023440389591,
  -4.8700599936391e-06,-0.00488212003175592,0.108567637149422,-0.158301828574869,
  -4.93040447338555e-06,-0.00468410179858436,0.118662373819016,-0.187580216760147,
  -4.99074895271567e-06,-0.00448608356541258,0.12875711048861,-0.216858604945425,
  -5.05109343229559e-06,-0.00428806533224102,0.138851847158204,-0.246136993130703,
  -5.11143791193103e-06,-0.00409004709906957,0.148946583827798,-0.275415381315981,
  -5.17178239123339e-06,-0.00389202886589768,0.159041320497392,-0.30469376950126,
  -5.23212687070229e-06,-0.0036940106327259,0.169136057166986,-0.333972157686538,
  -5.2924713502267e-06,-0.00349599239955434,0.17923079383658,-0.363250545871816,
  -5.35281583002867e-06,-0.00329797416638278,0.189325530506175,-0.392528934057094,
  -5.41316030960859e-06,-0.003099955933211,0.199420267175769,-0.421807322242372,
  -5.47350478896647e-06,-0.00290193770003966,0.209515003845362,-0.45108571042765,
  -5.53384926815781e-06,-0.00270391946686721,0.219609740514957,-0.480364098612928,
  -5.59419374790426e-06,-0.00250590123369587,0.229704477184551,-0.509642486798207,
  -5.65453822720663e-06,-0.00230788300052409,0.239799213854145,-0.538920874983485,
  -5.71488270706411e-06,-0.00210986476735253,0.249893950523739,-0.568199263168763,
  -5.77522718625545e-06,-0.00191184653418097,0.259988687193333,-0.597477651354041,
  -5.83557166555781e-06,-0.0017138283010083,0.270083423862928,-0.626756039539319,
  -5.89591614541529e-06,-0.00151581006783719,0.280178160532522,-0.656034427724597,
  -5.95626062516175e-06,-0.00131779183466607,0.290272897202115,-0.685312815909875,
  -6.01660510446411e-06,-0.00111977360149407,0.30036763387171,-0.714591204095153,
  -6.07694958443261e-06,-0.000921755368323396,0.310462370541303,-0.743869592280432,
  -6.13729406373498e-06,-0.000723737135150948,0.320557107210898,-0.77314798046571,
  -6.19763854325939e-06,-0.000525718901979388,0.330651843880492,-0.802426368650988,
  -3.48715964956781e-06,-0.00520890474348573,0.0880008344408879,-0.100056566544096,
  -3.523667049532e-06,-0.00502955531331717,0.0979520895970044,-0.12942211815829,
  -3.56017444960721e-06,-0.00485020588314866,0.107903344753121,-0.158787669772483,
  -3.59668184971018e-06,-0.00467085645298015,0.117854599909237,-0.188153221386677,
  -3.63318924967437e-06,-0.00449150702281154,0.127805855065354,-0.21751877300087,
  -3.6696966495553e-06,-0.0043121575926427,0.13775711022147,-0.246884324615064,
  -3.70620404976929e-06,-0.00413280816247441,0.147708365377587,-0.276249876229257,
  -3.74271144976124e-06,-0.00395345873230579,0.157659620533703,-0.305615427843451,
  -3.77921884947563e-06,-0.00377410930213684,0.16761087568982,-0.334980979457644,
  -3.81572624991167e-06,-0.00359475987196856,0.177562130845936,-0.364346531071838,
  -3.8522336498481e-06,-0.00341541044180005,0.187513386002053,-0.393712082686032,
  -3.88874105000658e-06,-0.00323606101163154,0.197464641158169,-0.423077634300225,
  -3.92524844994302e-06,-0.00305671158146303,0.207415896314286,-0.452443185914419,
  -3.96175585004599e-06,-0.0028773621512943,0.217367151470402,-0.481808737528612,
  -3.99826324992691e-06,-0.00269801272112535,0.227318406626519,-0.511174289142806,
  -4.03477065002988e-06,-0.00251866329095707,0.237269661782635,-0.540539840756999,
  -4.07127805013285e-06,-0.00233931386078856,0.247220916938752,-0.569905392371193,
  -4.1077854501248e-06,-0.00215996443062028,0.257172172094868,-0.599270943985386,
  -4.14429285000573e-06,-0.00198061500045155,0.267123427250985,-0.62863649559958,
  -4.18080025044176e-06,-0.00180126557028304,0.277074682407101,-0.658002047213773,
  -4.21730765043371e-06,-0.00162191614011453,0.287025937563218,-0.687367598827967,
  -4.25381505009259e-06,-0.00144256670994558,0.296977192719334,-0.71673315044216,
  -4.29032245052863e-06,-0.00126321727977796,0.30692844787545,-0.746098702056354,
  -4.32682984996546e-06,-0.00108386784960768,0.316879703031568,-0.775464253670547,
  -4.36333724973537e-06,-0.000904518419439171,0.326830958187684,-0.804829805284741,
  -2.54199221810802e-06,-0.00515790214524514,0.0877179488119476,-0.100289131280884,
  -2.5643166282896e-06,-0.00499270161256504,0.0975617543160146,-0.129719755790012,
  -2.58664103830464e-06,-0.00482750107988472,0.107405559820082,-0.15915038029914,
  -2.60896544848621e-06,-0.00466230054720473,0.117249365324149,-0.188581004808268,
  -2.63128985850125e-06,-0.00449710001452464,0.127093170828216,-0.218011629317396,
  -2.65361426871058e-06,-0.00433189948184465,0.136936976332283,-0.247442253826524,
  -2.67593867891991e-06,-0.00416669894916466,0.14678078183635,-0.276872878335652,
  -2.69826308918475e-06,-0.00400149841648467,0.156624587340417,-0.30630350284478,
  -2.72058749889448e-06,-0.0038362978838038,0.166468392844484,-0.335734127353908,
  -2.7429119090483e-06,-0.00367109735112403,0.176312198348551,-0.365164751863036,
  -2.76523631953518e-06,-0.00350589681844427,0.186156003852618,-0.394595376372163,
  -2.78756072946695e-06,-0.00334069628576406,0.195999809356685,-0.424026000881291,
  -2.80988513956526e-06,-0.00317549575308407,0.205843614860751,-0.453456625390419,
  -2.83220954977459e-06,-0.00301029522040386,0.215687420364818,-0.482887249899547,
  -2.85453395976187e-06,-0.00284509468772387,0.225531225868885,-0.512317874408675,
  -2.87685836974916e-06,-0.00267989415504299,0.235375031372953,-0.541748498917803,
  -2.89918278006951e-06,-0.00251469362236367,0.245218836877019,-0.571179123426931,
  -2.92150719050088e-06,-0.00234949308968391,0.255062642381086,-0.600609747936059,
  -2.94383160026612e-06,-0.00218429255700325,0.264906447885153,-0.630040372445187,
  -2.9661560106975e-06,-0.00201909202432349,0.274750253389221,-0.659470996954315,
  -2.98848042024069e-06,-0.00185389149164283,0.284594058893288,-0.688901621463443,
  -3.01080483111615e-06,-0.00168869095896396,0.294437864397354,-0.718332245972571,
  -3.03312924121446e-06,-0.0015234904262833,0.304281669901422,-0.747762870481698,
  -3.05545365031357e-06,-0.00135828989360176,0.314125475405489,-0.777193494990826,
  -3.07777806130005e-06,-0.00119308936092244,0.323969280909556,-0.806624119499954,
  -1.8430865197927e-06,-0.00512065534514089,0.0875085860192835,-0.100460717415729,
  -1.8569617065145e-06,-0.00496600983648232,0.0972729333748349,-0.129939352670936,
  -1.87083689301426e-06,-0.00481136432782359,0.107037280730386,-0.159417987926143,
  -1.88471207970831e-06,-0.00465671881916507,0.116801628085938,-0.18889662318135,
  -1.89858726634684e-06,-0.00450207331050667,0.126565975441489,-0.218375258436557,
  -1.91246245301313e-06,-0.00434742780184805,0.13633032279704,-0.247853893691764,
  -1.92633763973493e-06,-0.00419278229318942,0.146094670152592,-0.277332528946971,
  -1.9402128262902e-06,-0.0040381367845308,0.155859017508143,-0.306811164202179,
  -1.95408801273445e-06,-0.00388349127587184,0.165623364863695,-0.336289799457386,
  -1.96796319962278e-06,-0.00372884576721355,0.175387712219246,-0.365768434712593,
  -1.98183838573396e-06,-0.00357420025855437,0.185152059574797,-0.3952470699678,
  -1.99571357228923e-06,-0.00341955474989608,0.194916406930348,-0.424725705223007,
  -2.00958875951063e-06,-0.00326490924123801,0.2046807542859,-0.454204340478215,
  -2.0234639460659e-06,-0.0031102637325795,0.214445101641451,-0.483682975733422,
  -2.03733913262116e-06,-0.00295561822392054,0.224209448997003,-0.513161610988629,
  -2.05121431928745e-06,-0.00280097271526225,0.233973796352554,-0.542640246243836,
  -2.06508950584272e-06,-0.00264632720660352,0.243738143708105,-0.572118881499043,
  -2.07896469239799e-06,-0.00249168169794434,0.253502491063657,-0.60159751675425,
  -2.09283987928632e-06,-0.00233703618928649,0.263266838419208,-0.631076152009458,
  -2.10671506528648e-06,-0.00218239068062687,0.27303118577476,-0.660554787264665,
  -2.12059025206379e-06,-0.00202774517196813,0.282795533130311,-0.690033422519872,
  -2.1344654388411e-06,-0.00187309966331028,0.292559880485862,-0.719512057775079,
  -2.14834062617353e-06,-0.00171845415465288,0.302324227841413,-0.748990693030286,
  -2.1622158127288e-06,-0.0015638086459937,0.312088575196965,-0.778469328285493,
  -2.17609099806282e-06,-0.00140916313733364,0.321852922552516,-0.8079479635407,
  -1.33107356933837e-06,-0.00509361934727198,0.087355110602369,-0.100586213915024,
  -1.33986652878226e-06,-0.00494675606574968,0.0970612452386173,-0.130099963782301,
  -1.3486594881984e-06,-0.00479989278422721,0.106767379874866,-0.159613713649577,
  -1.35745244772556e-06,-0.00465302950270519,0.116473514511114,-0.189127463516854,
  -1.36624540691965e-06,-0.00450616622118238,0.126179649147362,-0.21864121338413,
  -1.37503836644681e-06,-0.00435930293966025,0.135885783783611,-0.248154963251406,
  -1.38383132580744e-06,-0.00421243965813756,0.145591918419859,-0.277668713118683,
  -1.39262428516806e-06,-0.00406557637661531,0.155298053056108,-0.307182462985959,
  -1.40141724502829e-06,-0.00391871309509373,0.165004187692355,-0.336696212853236,
  -1.41021020416687e-06,-0.00377184981357082,0.174710322328604,-0.366209962720512,
  -1.41900316336097e-06,-0.00362498653204812,0.184416456964853,-0.395723712587788,
  -1.42779612311017e-06,-0.00347812325052632,0.194122591601101,-0.425237462455065,
  -1.43658908258182e-06,-0.00333125996900407,0.203828726237349,-0.454751212322341,
  -1.44538204216449e-06,-0.00318439668748161,0.213534860873598,-0.484264962189618,
  -1.45417500119205e-06,-0.00303753340595914,0.223240995509846,-0.513778712056894,
  -1.46296796088574e-06,-0.00289067012443711,0.232947130146094,-0.543292461924171,
  -1.47176092013535e-06,-0.00274380684291464,0.242653264782342,-0.572806211791447,
  -1.48055387994006e-06,-0.0025969435613924,0.252359399418591,-0.602319961658723,
  -1.48934683941171e-06,-0.00245008027987037,0.262065534054839,-0.631833711526,
  -1.49813979866131e-06,-0.00230321699834768,0.271771668691087,-0.661347461393276,
  -1.50693275735581e-06,-0.00215635371682454,0.281477803327336,-0.690861211260553,
  -1.51572571716052e-06,-0.00200949043530274,0.291183937963584,-0.720374961127829,
  -1.52451867696524e-06,-0.00186262715378094,0.300890072599832,-0.749888710995105,
  -1.533311636992e-06,-0.00171576387225958,0.31059620723608,-0.779402460862382,
  -1.54210459568649e-06,-0.00156890059073556,0.320302341872329,-0.808916210729658,
  -9.58531469835711e-07,-0.00507408061420334,0.087243389692799,-0.100677416388633,
  -9.64218329235766e-07,-0.00493290601486351,0.0969071673851203,-0.13021668521061,
  -9.69905188913378e-07,-0.00479173141552414,0.106570945077441,-0.159755954032586,
  -9.75592048313434e-07,-0.00465055681618431,0.116234722769763,-0.189295222854562,
  -9.81278907741245e-07,-0.00450938221684438,0.125898500462084,-0.218834491676539,
  -9.86965767113546e-07,-0.00436820761750445,0.135562278154405,-0.248373760498515,
  -9.92652626763402e-07,-0.00422703301816485,0.145226055846727,-0.277913029320492,
  -9.98339485969169e-07,-0.00408585841882503,0.154889833539048,-0.307452298142468,
  -1.00402634573005e-06,-0.00394468381948543,0.164553611231369,-0.336991566964444,
  -1.00971320521337e-06,-0.00380350922014583,0.17421738892369,-0.366530835786421,
  -1.01540006491874e-06,-0.00366233462080645,0.183881166616011,-0.396070104608397,
  -1.02108692418001e-06,-0.00352116002146663,0.193544944308333,-0.425609373430374,
  -1.02677378344129e-06,-0.00337998542212614,0.203208722000654,-0.45514864225235,
  -1.03246064275808e-06,-0.00323881082278676,0.212872499692975,-0.484687911074327,
  -1.03814750251896e-06,-0.00309763622344739,0.222536277385296,-0.514227179896303,
  -1.04383436183575e-06,-0.00295646162410712,0.232200055077618,-0.543766448718279,
  -1.04952122137458e-06,-0.00281528702476774,0.241863832769939,-0.573305717540256,
  -1.05520808113546e-06,-0.00267411242542837,0.25152761046226,-0.602844986362232,
  -1.0608949406743e-06,-0.00253293782608832,0.261191388154582,-0.632384255184209,
  -1.06658179988006e-06,-0.00239176322674828,0.270855165846903,-0.661923524006185,
  -1.07226865964094e-06,-0.00225058862740868,0.280518943539224,-0.691462792828161,
  -1.07795551851364e-06,-0.00210941402806819,0.290182721231546,-0.721002061650138,
  -1.0836423781635e-06,-0.00196823942872948,0.299846498923866,-0.750541330472114,
  -1.08932923759131e-06,-0.00182706482938944,0.309510276616188,-0.780080599294091,
  -1.09501609724116e-06,-0.00168589023004984,0.319174054308509,-0.809619868116067,
  -5.62710645622966e-05,-0.00929027179783393,0.111581322726033,-0.0970644369926607,
  -6.07047215306356e-05,-0.00861705818975056,0.126820653135254,-0.122291084080049,
  -6.51383784987802e-05,-0.00794384458166708,0.142059983544474,-0.147517731167437,
  -6.9572035467147e-05,-0.00727063097358371,0.157299313953695,-0.172744378254826,
  -7.40056924353194e-05,-0.00659741736550012,0.172538644362916,-0.197971025342214,
  -7.84393494034918e-05,-0.00592420375741654,0.187777974772136,-0.223197672429603,
  -8.28730063719418e-05,-0.0052509901493335,0.203017305181357,-0.248424319516991,
  -8.73066633402808e-05,-0.00457777654125024,0.218256635590577,-0.273650966604379,
  -9.17403203085643e-05,-0.00390456293316666,0.233495965999798,-0.298877613691768,
  -9.61739772764036e-05,-0.00323134932508262,0.248735296409019,-0.324104260779156,
  -0.000100607634244854,-0.00255813571699948,0.26397462681824,-0.349330907866544,
  -0.000105041291213193,-0.00188492210891611,0.27921395722746,-0.374557554953933,
  -0.000109474948181809,-0.00121170850083296,0.294453287636681,-0.399784202041321,
  -0.000113908605149815,-0.000538494892749375,0.309692618045902,-0.42501084912871,
  -0.000118342262118154,0.000134718715334214,0.324931948455123,-0.450237496216098,
  -0.000122775919086493,0.00080793232341736,0.340171278864343,-0.475464143303486,
  -0.000127209576054721,0.00148114593150073,0.355410609273564,-0.500690790390875,
  -0.00013164323302306,0.00215435953958409,0.370649939682784,-0.525917437478263,
  -0.000136076889990622,0.00282757314766835,0.385889270092005,-0.551144084565651,
  -0.000140510546959405,0.00350078675575149,0.401128600501226,-0.57637073165304,
  -0.000144944203927633,0.00417400036383464,0.416367930910446,-0.601597378740428,
  -0.000149377860895306,0.00484721397191867,0.431607261319667,-0.626824025827817,
  -0.000153811517863756,0.00552042758000182,0.446846591728888,-0.652050672915205,
  -0.000158245174832095,0.00619364118808541,0.462085922138109,-0.677277320002594,
  -0.000162678831800656,0.00686685479616855,0.477325252547329,-0.702503967089982,
  -5.58898615238002e-05,-0.00924955997740112,0.111469737258622,-0.0971782211083355,
  -6.02689985940985e-05,-0.00857811775207085,0.12666948406076,-0.122433034186761,
  -6.46481356645356e-05,-0.00790667552674051,0.141869230862897,-0.147687847265187,
  -6.9027272734612e-05,-0.00723523330140985,0.157068977665035,-0.172942660343612,
  -7.34064098051879e-05,-0.00656379107607996,0.172268724467172,-0.198197473422038,
  -7.77855468755417e-05,-0.00589234885074974,0.187468471269309,-0.223452286500464,
  -8.21646839457291e-05,-0.00522090662541919,0.202668218071447,-0.248707099578889,
  -8.65438210163605e-05,-0.00454946440008919,0.217867964873584,-0.273961912657315,
  -9.09229580866588e-05,-0.00387802217475897,0.233067711675721,-0.299216725735741,
  -9.53020951567907e-05,-0.00320657994942852,0.248267458477859,-0.324471538814167,
  -9.96812322275331e-05,-0.00253513772409852,0.263467205279996,-0.349726351892592,
  -0.000104060369297776,-0.0018636954987683,0.278666952082133,-0.374981164971018,
  -0.000108439506367519,-0.00119225327343742,0.293866698884271,-0.400235978049443,
  -0.000112818643438484,-0.000520811048107639,0.309066445686408,-0.425490791127869,
  -0.000117197780508782,0.00015063117722236,0.324266192488545,-0.450745604206295,
  -0.000121576917578969,0.000822073402552803,0.339465939290682,-0.476000417284721,
  -0.000125956054649046,0.00149351562788413,0.354665686092821,-0.501255230363146,
  -0.000130335191719788,0.00216495785321369,0.369865432894958,-0.526510043441572,
  -0.000134714328789864,0.00283640007854435,0.385065179697095,-0.551764856519997,
  -0.000139093465860385,0.00350784230387413,0.400264926499232,-0.577019669598423,
  -0.000143472602930794,0.0041792845292048,0.41546467330137,-0.602274482676849,
  -0.000147851740001426,0.00485072675453413,0.430664420103507,-0.627529295755275,
  -0.000152230877071502,0.00552216897986435,0.445864166905644,-0.6527841088337,
  -0.000156610014141356,0.0061936112051959,0.461063913707782,-0.678038921912126,
  -0.000160989151211655,0.00686505343052612,0.476263660509919,-0.703293734990551,
  -5.53650565652264e-05,-0.00919379537165227,0.111315987704391,-0.0973346360612716,
  -5.96696161429267e-05,-0.00852484240257845,0.126461231965598,-0.122628167919875,
  -6.39741757204604e-05,-0.00785588943350446,0.141606476226805,-0.147921699778478,
  -6.82787352981884e-05,-0.00718693646443092,0.156751720488012,-0.173215231637081,
  -7.25832948758054e-05,-0.00651798349535715,0.171896964749218,-0.198508763495684,
  -7.68878544534224e-05,-0.00584903052628316,0.187042209010425,-0.223802295354287,
  -8.11924140310949e-05,-0.00518007755720939,0.202187453271632,-0.24909582721289,
  -8.54969736086564e-05,-0.00451112458813552,0.217332697532839,-0.274389359071493,
  -8.98015331861068e-05,-0.00384217161906153,0.232477941794046,-0.299682890930096,
  -9.41060927638349e-05,-0.00317321864998799,0.247623186055253,-0.3249764227887,
  -9.84106523415074e-05,-0.00250426568091422,0.26276843031646,-0.350269954647302,
  -0.000102715211918958,-0.00183531271184001,0.277913674577667,-0.375563486505906,
  -0.000107019771497074,-0.00116635974276669,0.293058918838874,-0.400857018364509,
  -0.000111324331074081,-0.000497406773692033,0.308204163100081,-0.426150550223112,
  -0.000115628890651753,0.000171546195381511,0.323349407361288,-0.451444082081715,
  -0.000119933450229315,0.000840499164455499,0.338494651622495,-0.476737613940318,
  -0.000124238009806876,0.00150945213352949,0.353639895883702,-0.502031145798921,
  -0.00012854256938466,0.00217840510260281,0.368785140144908,-0.527324677657524,
  -0.000132847128962554,0.00284735807167635,0.383930384406115,-0.552618209516127,
  -0.000137151688540449,0.0035163110407499,0.399075628667322,-0.577911741374731,
  -0.000141456248116789,0.00418526400982522,0.414220872928529,-0.603205273233334,
  -0.000145760807695128,0.00485421697889832,0.429366117189736,-0.628498805091937,
  -0.000150065367272689,0.00552316994797231,0.444511361450943,-0.65379233695054,
  -0.000154369926850584,0.00619212291704541,0.45965660571215,-0.679085868809143,
  -0.000158674486428256,0.00686107588611895,0.474801849973357,-0.704379400667746,
  -5.46470261018894e-05,-0.00911802876212842,0.111105388761253,-0.0975482068911161,
  -5.88504542051171e-05,-0.0084525760314943,0.126176049380055,-0.122894605830889,
  -6.30538823081228e-05,-0.00778712330085995,0.141246709998856,-0.148241004770662,
  -6.72573104111285e-05,-0.0071216705702255,0.156317370617657,-0.173587403710435,
  -7.14607385142174e-05,-0.00645621783959116,0.171388031236459,-0.198933802650208,
  -7.56641666170843e-05,-0.00579076510895682,0.18645869185526,-0.224280201589981,
  -7.98675947204508e-05,-0.0051253123783227,0.201529352474061,-0.249626600529754,
  -8.40710228234287e-05,-0.00445985964768836,0.216600013092862,-0.274972999469527,
  -8.82744509264621e-05,-0.00379440691705413,0.231670673711663,-0.3003193984093,
  -9.24778790298286e-05,-0.00312895418642012,0.246741334330465,-0.325665797349073,
  -9.66813071330286e-05,-0.00246350145578611,0.261811994949266,-0.351012196288846,
  -0.000100884735236006,-0.00179804872515166,0.276882655568067,-0.376358595228619,
  -0.00010508816333854,-0.00113259599451632,0.291953316186869,-0.401704994168392,
  -0.00010929159144224,-0.000467143263882974,0.30702397680567,-0.427051393108165,
  -0.000113495019545162,0.000198309466751478,0.322094637424471,-0.452397792047938,
  -0.000117698447647752,0.000863762197386597,0.337165298043273,-0.477744190987711,
  -0.000121901875751007,0.00152921492802016,0.352235958662074,-0.503090589927484,
  -0.000126105303854152,0.00219466765865461,0.367306619280875,-0.528436988867257,
  -0.000130308731957296,0.00286012038928884,0.382377279899676,-0.55378338780703,
  -0.000134512160060329,0.0035255731199233,0.397447940518477,-0.579129786746803,
  -0.000138715588163807,0.00419102585055731,0.412518601137279,-0.604476185686576,
  -0.00014291901626684,0.00485647858119176,0.42758926175608,-0.629822584626349,
  -0.00014712244436943,0.00552193131182621,0.442659922374881,-0.655168983566122,
  -0.000151325872472796,0.00618738404246022,0.457730582993683,-0.680515382505895,
  -0.000155529300575608,0.00685283677309467,0.472801243612484,-0.705861781445668,
  -5.36729334582597e-05,-0.00901621422295495,0.110819244155366,-0.097837145662461,
  -5.77408420101566e-05,-0.00835568333326708,0.125788697382655,-0.123255068178225,
  -6.18087505618037e-05,-0.00769515244357899,0.140758150609944,-0.148672990693989,
  -6.58766591136173e-05,-0.00703462155389123,0.155727603837232,-0.174090913209753,
  -6.99445676652366e-05,-0.00637409066420302,0.170697057064521,-0.199508835725517,
  -7.40124762173e-05,-0.00571355977451549,0.185666510291809,-0.22492675824128,
  -7.80803847689193e-05,-0.0050530288848275,0.200635963519098,-0.250344680757045,
  -8.21482933206497e-05,-0.00439249799513952,0.215605416746386,-0.275762603272808,
  -8.6216201872491e-05,-0.00373196710545165,0.230574869973675,-0.301180525788572,
  -9.02841104244989e-05,-0.003071436215764,0.245544323200964,-0.326598448304336,
  -9.43520189762292e-05,-0.00241090532607613,0.260513776428252,-0.3520163708201,
  -9.84199275280151e-05,-0.00175037443638826,0.275483229655541,-0.377434293335864,
  -0.000102487836079579,-0.00108984354669972,0.29045268288283,-0.402852215851628,
  -0.000106555744631143,-0.000429312657011849,0.305422136110118,-0.428270138367392,
  -0.000110623653183262,0.000231218232675579,0.320391589337406,-0.453688060883156,
  -0.000114691561734936,0.00089174912236345,0.335361042564695,-0.47910598339892,
  -0.000118759470286611,0.00155228001205199,0.350330495791984,-0.504523905914684,
  -0.000122827378838397,0.00221281090173986,0.365299949019272,-0.529941828430447,
  -0.000126895287390294,0.00287334179142751,0.380269402246561,-0.555359750946211,
  -0.000130963195941747,0.00353387268111582,0.395238855473849,-0.580777673461975,
  -0.000135031104494421,0.00419440357080259,0.410208308701138,-0.606195595977739,
  -0.000139099013045429,0.00485493446049112,0.425177761928426,-0.631613518493503,
  -0.000143166921596993,0.00551546535017922,0.440147215155715,-0.657031441009267,
  -0.00014723483014889,0.00617599623986775,0.455116668383004,-0.682449363525031,
  -0.000151302738700565,0.00683652712955496,0.470086121610292,-0.707867286040795,
  -5.23665861979217e-05,-0.00888141198140296,0.110434705288464,-0.0982232166583781,
  -5.62557988355028e-05,-0.00822779229853743,0.125268383429118,-0.123736706750919,
  -6.01450114732227e-05,-0.00757417261567206,0.140102061569772,-0.14925019684346,
  -6.40342241108316e-05,-0.00692055293280636,0.154935739710426,-0.174763686936001,
  -6.7923436748496e-05,-0.00626693324994099,0.16976941785108,-0.200277177028542,
  -7.18126493859939e-05,-0.00561331356707528,0.184603095991734,-0.225790667121083,
  -7.57018620237693e-05,-0.00495969388421003,0.199436774132388,-0.251304157213624,
  -7.95910746613782e-05,-0.00430607420134432,0.214270452273042,-0.276817647306165,
  -8.34802872992091e-05,-0.00365245451847929,0.229104130413696,-0.302331137398706,
  -8.73694999366514e-05,-0.00299883483561314,0.24393780855435,-0.327844627491247,
  -9.12587125742048e-05,-0.00234521515274766,0.258771486695004,-0.353358117583788,
  -9.51479252120913e-05,-0.0016915954698824,0.273605164835658,-0.378871607676329,
  -9.90371378495336e-05,-0.0010379757870167,0.288438842976312,-0.404385097768869,
  -0.000102926350487142,-0.000384356104151218,0.303272521116966,-0.42989858786141,
  -0.000106815563124862,0.000269263578714041,0.31810619925762,-0.455412077953951,
  -0.000110704775762693,0.000922883261579521,0.332939877398274,-0.480925568046492,
  -0.000114593988400191,0.001576502944445,0.347773555538928,-0.506439058139033,
  -0.000118483201037578,0.0022301226273107,0.362607233679582,-0.531952548231574,
  -0.000122372413675853,0.00288374231017552,0.377440911820236,-0.557466038324115,
  -0.000126261626313795,0.003537361993041,0.39227458996089,-0.582979528416656,
  -0.000130150838950849,0.00419098167590715,0.407108268101545,-0.608493018509197,
  -0.000134040051588125,0.00484460135877285,0.421941946242198,-0.634006508601738,
  -0.000137929264225845,0.005498221041639,0.436775624382853,-0.659519998694279,
  -0.000141818476864009,0.00615184072450292,0.451609302523506,-0.68503348878682,
  -0.000145707689501173,0.00680546040736907,0.46644298066416,-0.710546978879361,
  -5.06414664759591e-05,-0.00870641494209479,0.109925519599893,-0.0987305867049729,
  -5.4300090960635e-05,-0.00806246084650675,0.124579815825865,-0.124369670603822,
  -5.7958715445644e-05,-0.00741850675091893,0.139234112051837,-0.150008754502671,
  -6.16173399302089e-05,-0.00677455265533078,0.153888408277809,-0.175647838401519,
  -6.52759644150236e-05,-0.00613059855974274,0.168542704503781,-0.201286922300368,
  -6.89345888998938e-05,-0.00548664446415503,0.183197000729753,-0.226926006199217,
  -7.25932133845419e-05,-0.00484269036856666,0.197851296955725,-0.252565090098066,
  -7.62518378695787e-05,-0.00419873627297918,0.212505593181697,-0.278204173996915,
  -7.99104623543934e-05,-0.00355478217739136,0.227159889407669,-0.303843257895764,
  -8.35690868390415e-05,-0.0029108280818031,0.241814185633641,-0.329482341794613,
  -8.72277113236342e-05,-0.00226687398621461,0.256468481859614,-0.355121425693461,
  -9.08863358084488e-05,-0.00162291989062679,0.271122778085585,-0.38076050959231,
  -9.45449602932635e-05,-0.000978965795038311,0.285777074311558,-0.406399593491159,
  -9.82035847781892e-05,-0.000335011699450938,0.30043137053753,-0.432038677390008,
  -0.000101862209262782,0.000308942396137546,0.315085666763502,-0.457677761288857,
  -0.00010552083374793,0.000952896491724697,0.329739962989474,-0.483316845187706,
  -0.000109179458232411,0.0015968505873134,0.344394259215446,-0.508955929086555,
  -0.000112838082717559,0.00224080468290078,0.359048555441418,-0.534595012985404,
  -0.000116496707201819,0.00288475877848993,0.37370285166739,-0.560234096884252,
  -0.000120155331686522,0.00352871287407774,0.388357147893362,-0.585873180783101,
  -0.000123813956171559,0.00417266696966534,0.403011444119334,-0.61151226468195,
  -0.000127472580656374,0.00481662106525338,0.417665740345306,-0.637151348580799,
  -0.000131131205141188,0.00546057516084097,0.432320036571278,-0.662790432479648,
  -0.000134789829626225,0.00610452925642901,0.44697433279725,-0.688429516378497,
  -0.000138448454110485,0.0067484833520175,0.461628629023222,-0.714068600277346,
  -4.84092007519699e-05,-0.00848499191781982,0.109264353836443,-0.0993830256763889,
  -5.17786513329621e-05,-0.007854441457956,0.123686396404011,-0.125183613578783,
  -5.51481019137601e-05,-0.00722389099809195,0.13810843897158,-0.150984201481176,
  -5.85175524945858e-05,-0.00659334053822791,0.152530481539148,-0.17678478938357,
  -6.18870030755225e-05,-0.00596279007836398,0.166952524106717,-0.202585377285963,
  -6.52564536562927e-05,-0.0053322396184996,0.181374566674286,-0.228385965188357,
  -6.86259042370074e-05,-0.00470168915863556,0.195796609241854,-0.25418655309075,
  -7.19953548179442e-05,-0.00407113869877151,0.210218651809423,-0.279987140993144,
  -7.53648053989919e-05,-0.00344058823890747,0.224640694376991,-0.305787728895538,
  -7.87342559796511e-05,-0.00281003777904343,0.23906273694456,-0.331588316797931,
  -8.21037065606434e-05,-0.00217948731917939,0.253484779512128,-0.357388904700325,
  -8.54731571413025e-05,-0.00154893685931512,0.267906822079697,-0.383189492602718,
  -8.88426077221283e-05,-0.000918386399451299,0.282328864647265,-0.408990080505112,
  -9.22120583030095e-05,-0.000287835939587255,0.296750907214834,-0.434790668407506,
  -9.55815088841128e-05,0.000342714520276566,0.311172949782402,-0.460591256309899,
  -9.8950959464883e-05,0.000973264980140609,0.325594992349971,-0.486391844212293,
  -0.000102320410045764,0.00160381544000487,0.34001703491754,-0.512192432114686,
  -0.000105689860626312,0.00223436589986914,0.354439077485108,-0.53799302001708,
  -0.000109059311206972,0.0028649163597334,0.368861120052677,-0.563793607919474,
  -0.000112428761788186,0.00349546681959723,0.383283162620245,-0.589594195821867,
  -0.000115798212368845,0.00412601727946127,0.397705205187814,-0.615394783724261,
  -0.000119167662950281,0.00475656773932487,0.412127247755382,-0.641195371626654,
  -0.000122537113530941,0.00538711819918891,0.42654929032295,-0.666995959529048,
  -0.000125906564111822,0.00601766865905295,0.440971332890519,-0.692796547431442,
  -0.000129276014692481,0.00664821911891789,0.455393375458088,-0.718597135333835,
  -4.5595620421085e-05,-0.00821381402702714,0.108427395723077,-0.100198949943295,
  -4.8615583543743e-05,-0.00760157123076188,0.122556482353515,-0.126201510813993,
  -5.16355466664287e-05,-0.00698932843449651,0.136685568983954,-0.152204071684692,
  -5.46555097888923e-05,-0.00637708563823103,0.150814655614392,-0.17820663255539,
  -5.76754729117446e-05,-0.00576484284196588,0.16494374224483,-0.204209193426089,
  -6.06954360342082e-05,-0.00515260004570006,0.179072828875269,-0.230211754296787,
  -6.37153991569495e-05,-0.00454035724943513,0.193201915505707,-0.256214315167486,
  -6.67353622795797e-05,-0.00392811445316954,0.207331002136145,-0.282216876038184,
  -6.97553254023209e-05,-0.00331587165690439,0.221460088766583,-0.308219436908882,
  -7.27752885247845e-05,-0.00270362886063857,0.235589175397022,-0.334221997779581,
  -7.57952516476923e-05,-0.00209138606437387,0.24971826202746,-0.360224558650279,
  -7.88152147704335e-05,-0.00147914326810827,0.263847348657898,-0.386227119520978,
  -8.18351778930637e-05,-0.000866900471843124,0.277976435288336,-0.412229680391676,
  -8.48551410155274e-05,-0.00025465767557753,0.292105521918775,-0.438232241262375,
  -8.78751041384351e-05,0.00035758512068762,0.306234608549213,-0.464234802133073,
  -9.08950672607878e-05,0.000969827916953658,0.320363695179652,-0.490237363003771,
  -9.39150303838066e-05,0.00158207071321814,0.334492781810089,-0.51623992387447,
  -9.69349935058261e-05,0.0021943135094844,0.348621868440528,-0.542242484745168,
  -9.99549566289559e-05,0.00280655630574911,0.362750955070966,-0.568245045615867,
  -0.000102974919751309,0.0034187991020147,0.376880041701404,-0.594247606486565,
  -0.000105994882873661,0.00403104189828074,0.391009128331843,-0.620250167357264,
  -0.000109014845996902,0.004643284694545,0.405138214962281,-0.646252728227962,
  -0.000112034809119255,0.00525552749081104,0.419267301592719,-0.672255289098661,
  -0.000115054772241496,0.00586777028707708,0.433396388223158,-0.698257849969359,
  -0.000118074735364515,0.00648001308334178,0.447525474853596,-0.724260410840057,
  -4.2164673495132e-05,-0.00789477635516589,0.107401453686758,-0.101184488415708,
  -4.47814931092694e-05,-0.00730694190386327,0.121172972355841,-0.127431008362911,
  -4.73983127236843e-05,-0.0067191074525611,0.134944491024923,-0.153677528310114,
  -5.00151323377107e-05,-0.00613127300125815,0.148716009694006,-0.179924048257317,
  -5.26319519519869e-05,-0.00554343854995598,0.162487528363088,-0.206170568204519,
  -5.52487715662631e-05,-0.00495560409865359,0.176259047032171,-0.232417088151722,
  -5.78655911804837e-05,-0.00436776964735119,0.190030565701253,-0.258663608098925,
  -6.04824107948154e-05,-0.0037799351960488,0.203802084370336,-0.284910128046128,
  -6.30992304090361e-05,-0.00319210074474663,0.217573603039418,-0.31115664799333,
  -6.57160500232568e-05,-0.00260426629344401,0.231345121708501,-0.337403167940533,
  -6.83328696375884e-05,-0.00201643184214162,0.245116640377584,-0.363649687887736,
  -7.09496892515871e-05,-0.00142859739083878,0.258888159046666,-0.389896207834939,
  -7.35665088654747e-05,-0.000840762939536388,0.272659677715749,-0.416142727782142,
  -7.61833284801394e-05,-0.000252928488234216,0.286431196384831,-0.442389247729344,
  -7.88001480944711e-05,0.000334905963068177,0.300202715053914,-0.468635767676547,
  -8.14169677081367e-05,0.000922740414371459,0.313974233722997,-0.49488228762375,
  -8.40337873225794e-05,0.00151057486567385,0.327745752392079,-0.521128807570953,
  -8.66506069369111e-05,0.00209840931697602,0.341517271061162,-0.547375327518156,
  -8.92674265513538e-05,0.00268624376827731,0.355288789730243,-0.573621847465358,
  -9.18842461650193e-05,0.00327407821958081,0.369060308399326,-0.599868367412561,
  -9.4501065779018e-05,0.00386191267088387,0.382831827068409,-0.626114887359764,
  -9.71178853942378e-05,0.00444974712218471,0.396603345737491,-0.652361407306967,
  -9.97347050075703e-05,0.0050375815734891,0.410374864406575,-0.67860792725417,
  -0.000102351524621902,0.00562541602479083,0.424146383075657,-0.704854447201373,
  -0.000104968344236789,0.00621325047609211,0.437917901744739,-0.731100967148575,
  -3.81458826478609e-05,-0.00753687964632804,0.106192467225051,-0.102326156082606,
  -4.03234014009213e-05,-0.00698046723672974,0.119544693813782,-0.128855283150168,
  -4.25009201538151e-05,-0.00642405482713104,0.132896920402514,-0.155384410217729,
  -4.4678438906931e-05,-0.00586764241753279,0.146249146991246,-0.181913537285291,
  -4.68559576597416e-05,-0.00531123000793399,0.159601373579978,-0.208442664352852,
  -4.90334764128297e-05,-0.00475481759833585,0.17295360016871,-0.234971791420414,
  -5.12109951657513e-05,-0.00419840518873738,0.186305826757441,-0.261500918487976,
  -5.3388513918895e-05,-0.0036419927791389,0.199658053346173,-0.288030045555537,
  -5.55660326718166e-05,-0.00308558036954043,0.213010279934905,-0.314559172623098,
  -5.77435514247937e-05,-0.00252916795994218,0.226362506523636,-0.34108829969066,
  -5.99210701777153e-05,-0.00197275555034326,0.239714733112369,-0.367617426758221,
  -6.20985889311365e-05,-0.00141634314074546,0.2530669597011,-0.394146553825783,
  -6.42761076836695e-05,-0.000859930731146763,0.266419186289832,-0.420675680893344,
  -6.64536264366467e-05,-0.000303518321548291,0.279771412878564,-0.447204807960906,
  -6.86311451896238e-05,0.000252894088050626,0.293123639467296,-0.473733935028468,
  -7.08086639424899e-05,0.000809306497648876,0.306475866056027,-0.500263062096029,
  -7.29861826960221e-05,0.00136571890724668,0.319828092644759,-0.526792189163591,
  -7.51637014483331e-05,0.00192213131684582,0.333180319233491,-0.553321316231152,
  -7.73412202011992e-05,0.00247854372644496,0.346532545822223,-0.579850443298713,
  -7.95187389548424e-05,0.00303495613604232,0.359884772410954,-0.606379570366275,
  -8.16962577082636e-05,0.00359136854564035,0.373236998999686,-0.632908697433836,
  -8.38737764603525e-05,0.00414778095523971,0.386589225588418,-0.659437824501398,
  -8.60512952136627e-05,0.00470419336483818,0.39994145217715,-0.685966951568959,
  -8.82288139665288e-05,0.00526060577443621,0.413293678765881,-0.712496078636521,
  -9.04063327205051e-05,0.0058170181840338,0.426645905354613,-0.739025205704083,
  -3.36547882024141e-05,-0.00715643983893677,0.104832389040387,-0.103586357827746,
  -3.53845704886835e-05,-0.00663864511414669,0.117715461255131,-0.130427433807054,
  -3.71143527748141e-05,-0.00612085038935617,0.130598533469875,-0.157268509786362,
  -3.88441350612223e-05,-0.00560305566456609,0.143481605684618,-0.18410958576567,
  -4.05739173472974e-05,-0.00508526093977568,0.156364677899362,-0.210950661744977,
  -4.23036996333725e-05,-0.00456746621498516,0.169247750114106,-0.237791737724285,
  -4.40334819199473e-05,-0.00404967149019542,0.18213082232885,-0.264632813703593,
  -4.57632642059669e-05,-0.00353187676540467,0.195013894543594,-0.291473889682901,
  -4.74930464920975e-05,-0.00301408204061415,0.207896966758337,-0.318314965662209,
  -4.92228287781726e-05,-0.00249628731582363,0.220780038973081,-0.345156041641517,
  -5.09526110645253e-05,-0.00197849259103378,0.233663111187825,-0.371997117620825,
  -5.2682393350767e-05,-0.0014606978662437,0.246546183402568,-0.398838193600132,
  -5.44121756368421e-05,-0.000942903141452955,0.259429255617313,-0.42567926957944,
  -5.61419579230282e-05,-0.000425108416662878,0.272312327832056,-0.452520345558748,
  -5.78717402093254e-05,9.2686308127643e-05,0.2851954000468,-0.479361421538056,
  -5.96015224957336e-05,0.000610481032917498,0.298078472261543,-0.506202497517364,
  -6.13313047819197e-05,0.00112827575770802,0.310961544476287,-0.533043573496672,
  -6.30610870679948e-05,0.00164607048249854,0.323844616691031,-0.559884649475979,
  -6.4790869354181e-05,0.0021638652072884,0.336727688905775,-0.586725725455287,
  -6.65206516408112e-05,0.00268165993207869,0.349610761120519,-0.613566801434595,
  -6.82504339269974e-05,0.00319945465686899,0.362493833335263,-0.640407877413903,
  -6.99802162127394e-05,0.00371724938165974,0.375376905550006,-0.667248953393211,
  -7.17099984990366e-05,0.00423504410644959,0.38825997776475,-0.694090029372519,
  -7.34397807856668e-05,0.00475283883123989,0.401143049979494,-0.720931105351827,
  -7.5169563071853e-05,0.00527063355603019,0.414026122194237,-0.747772181331134,
  -2.88924011872804e-05,-0.00677473419631736,0.103380081712184,-0.104905388275511,
  -3.01988382318263e-05,-0.00630179432450795,0.115764984726713,-0.13207297555694,
  -3.15052752763723e-05,-0.00582885445269854,0.128149887741241,-0.159240562838369,
  -3.28117123206684e-05,-0.00535591458088891,0.14053479075577,-0.186408150119798,
  -3.41181493653253e-05,-0.00488297470907961,0.152919693770299,-0.213575737401227,
  -3.54245864099267e-05,-0.00441003483727009,0.165304596784827,-0.240743324682656,
  -3.67310234544171e-05,-0.00393709496546057,0.177689499799356,-0.267910911964085,
  -3.80374604989631e-05,-0.00346415509365161,0.190074402813884,-0.295078499245513,
  -3.93438975432314e-05,-0.00299121522184165,0.202459305828413,-0.322246086526942,
  -4.0650334588388e-05,-0.00251827535003324,0.214844208842941,-0.349413673808371,
  -4.19567716326008e-05,-0.00204533547822305,0.22722911185747,-0.3765812610898,
  -4.32632086773688e-05,-0.0015723956064142,0.239614014871999,-0.403748848371229,
  -4.45696457216371e-05,-0.00109945573460446,0.251998917886528,-0.430916435652658,
  -4.58760827662941e-05,-0.000626515862795385,0.264383820901056,-0.458084022934087,
  -4.718251981084e-05,-0.000153575990985644,0.276768723915585,-0.485251610215516,
  -4.84889568551639e-05,0.000319363880824097,0.289153626930114,-0.512419197496944,
  -4.97953938994877e-05,0.00079230375263406,0.301538529944643,-0.539586784778373,
  -5.11018309442557e-05,0.00126524362444269,0.313923432959171,-0.566754372059802,
  -5.24082679886906e-05,0.00173818349625243,0.3263083359737,-0.593921959341231,
  -5.37147050329034e-05,0.00221112336806195,0.338693238988228,-0.62108954662266,
  -5.50211420778934e-05,0.00268406323987103,0.351078142002757,-0.648257133904089,
  -5.63275791223283e-05,0.00315700311168055,0.363463045017285,-0.675424721185518,
  -5.76340161670963e-05,0.00362994298348962,0.375847948031814,-0.702592308466946,
  -5.89404532111981e-05,0.00410288285529958,0.388232851046343,-0.729759895748375,
  -6.02468902568543e-05,0.00457582272710733,0.400617754060871,-0.756927483029804,
  -2.41152995490712e-05,-0.00641349477086245,0.101913187729533,-0.106211365668085,
  -2.505222062818e-05,-0.0059894485064711,0.11379768301813,-0.133702233113146,
  -2.59891417071501e-05,-0.00556540224207958,0.125682178306728,-0.161193100558208,
  -2.69260627863144e-05,-0.00514135597768839,0.137566673595326,-0.188683968003269,
  -2.78629838653122e-05,-0.00471730971329676,0.149451168883923,-0.21617483544833,
  -2.87999049443655e-05,-0.00429326344890557,0.161335664172521,-0.243665702893392,
  -2.97368260233632e-05,-0.00386921718451394,0.173220159461118,-0.271156570338453,
  -3.06737471025276e-05,-0.00344517092012242,0.185104654749716,-0.298647437783514,
  -3.16106681816364e-05,-0.00302112465573146,0.196989150038313,-0.326138305228576,
  -3.25475892608562e-05,-0.00259707839134005,0.208873645326911,-0.353629172673637,
  -3.3484510339854e-05,-0.00217303212694886,0.220758140615508,-0.381120040118699,
  -3.44214314187963e-05,-0.00174898586255723,0.232642635904106,-0.40861090756376,
  -3.5358352497572e-05,-0.00132493959816515,0.244527131192704,-0.436101775008821,
  -3.62952735766253e-05,-0.000900893333774189,0.256411626481301,-0.463592642453883,
  -3.72321946559007e-05,-0.000476847069383002,0.268296121769899,-0.491083509898944,
  -3.8169115735065e-05,-5.28008049915929e-05,0.280180617058496,-0.518574377344005,
  -3.91060368140073e-05,0.00037124545940026,0.292065112347094,-0.546065244789067,
  -4.00429578930606e-05,0.000795291723791447,0.303949607635692,-0.573556112234128,
  -4.09798789721139e-05,0.00121933798818263,0.315834102924289,-0.601046979679189,
  -4.19168000509451e-05,0.00164338425257471,0.327718598212887,-0.628537847124251,
  -4.28537211297764e-05,0.0020674305169659,0.339603093501484,-0.656028714569312,
  -4.37906422097178e-05,0.00249147678135619,0.351487588790081,-0.683519582014373,
  -4.47275632883271e-05,0.00291552304574871,0.36337208407868,-0.711010449459434,
  -4.56644843674914e-05,0.0033395693101399,0.375256579367277,-0.738501316904496,
  -4.66014054466557e-05,0.00376361557453109,0.387141074655875,-0.765992184349557,
  -1.95831580042938e-05,-0.00609011418887767,0.100512430000829,-0.107435178400323,
  -2.02225283721935e-05,-0.00571594628149952,0.111921526641904,-0.135228987062119,
  -2.08618987400933e-05,-0.00534177837412131,0.123330623282978,-0.163022795723914,
  -2.1501269108215e-05,-0.00496761046674332,0.134739719924052,-0.19081660438571,
  -2.2140639475865e-05,-0.00459344255936489,0.146148816565127,-0.218610413047505,
  -2.27800098440145e-05,-0.00421927465198702,0.157557913206201,-0.246404221709301,
  -2.3419380211942e-05,-0.0038451067446087,0.168967009847276,-0.274198030371096,
  -2.4058750580036e-05,-0.00347093883723071,0.18037610648835,-0.301991839032892,
  -2.4698120947908e-05,-0.00309677092985261,0.191785203129424,-0.329785647694687,
  -2.533749131578e-05,-0.00272260302247407,0.203194299770499,-0.357579456356483,
  -2.59768616835965e-05,-0.00234843511509619,0.214603396411573,-0.385373265018278,
  -2.66162320516905e-05,-0.00197426720771854,0.226012493052647,-0.413167073680073,
  -2.72556024196735e-05,-0.00160009930033977,0.237421589693722,-0.440960882341869,
  -2.78949727875455e-05,-0.00122593139296145,0.248830686334796,-0.468754691003664,
  -2.85343431551954e-05,-0.000851763485583357,0.26023978297587,-0.49654849966546,
  -2.91737135230674e-05,-0.000477595578204815,0.271648879616945,-0.524342308327255,
  -2.98130838913835e-05,-0.000103427670827383,0.283057976258019,-0.552136116989051,
  -3.04524542588114e-05,0.000270740236551603,0.294467072899094,-0.579929925650846,
  -3.10918246271275e-05,0.000644908143929257,0.305876169540168,-0.607723734312642,
  -3.17311949951105e-05,0.00101907605130735,0.317285266181242,-0.635517542974437,
  -3.23705653630935e-05,0.00139324395868501,0.328694362822316,-0.663311351636233,
  -3.30099357310765e-05,0.00176741186606355,0.340103459463391,-0.691105160298028,
  -3.36493060989485e-05,0.0021415797734412,0.351512556104465,-0.718898968959823,
  -3.42886764667094e-05,0.00251574768081975,0.362921652745539,-0.746692777621619,
  -3.49280468350255e-05,0.0028899155881974,0.374330749386614,-0.774486586283414,
  -1.55049761480508e-05,-0.0058146927621745,0.0992446118064855,-0.108524254763767,
  -1.59224191787766e-05,-0.00548822537001237,0.110225382031673,-0.136587652154269,
  -1.63398622096689e-05,-0.00516175797785046,0.12120615225686,-0.16465104954477,
  -1.67573052405334e-05,-0.00483529058568855,0.132186922482047,-0.192714446935271,
  -1.717474827162e-05,-0.00450882319352675,0.143167692707234,-0.220777844325773,
  -1.7592191302318e-05,-0.0041823558013645,0.154148462932421,-0.248841241716274,
  -1.80096343331271e-05,-0.00385588840920259,0.165129233157608,-0.276904639106775,
  -1.84270773641582e-05,-0.00352942101704068,0.176110003382795,-0.304968036497277,
  -1.88445203948562e-05,-0.00320295362487877,0.187090773607982,-0.333031433887778,
  -1.92619634257762e-05,-0.00287648623271641,0.198071543833169,-0.361094831278279,
  -1.96794064567518e-05,-0.0025500188405545,0.209052314058356,-0.389158228668781,
  -2.00968494876164e-05,-0.00222355144839259,0.220033084283543,-0.417221626059282,
  -2.0514292518814e-05,-0.00189708405623112,0.23101385450873,-0.445285023449783,
  -2.0931735549512e-05,-0.00157061666406899,0.241994624733917,-0.473348420840284,
  -2.1349178579988e-05,-0.00124414927190641,0.252975394959105,-0.501411818230786,
  -2.17666216112411e-05,-0.000917681879745391,0.263956165184291,-0.529475215621287,
  -2.21840646423832e-05,-0.000591214487583702,0.274936935409478,-0.557538613011788,
  -2.26015076730812e-05,-0.000264747095420903,0.285917705634666,-0.58560201040229,
  -2.30189507038903e-05,6.1720296741008e-05,0.296898475859853,-0.613665407792791,
  -2.34363937343662e-05,0.000388187688903585,0.30787924608504,-0.641728805183292,
  -2.38538367656194e-05,0.000714655081065274,0.318860016310227,-0.669792202573794,
  -2.42712797965394e-05,0.00104112247322696,0.329840786535414,-0.697855599964295,
  -2.46887228279036e-05,0.00136758986538821,0.340821556760601,-0.725918997354796,
  -2.51061658587126e-05,0.00169405725755034,0.351802326985788,-0.753982394745298,
  -2.55236088895217e-05,0.00202052464971203,0.362783097210975,-0.782045792135799,
  -1.20061388099169e-05,-0.00558981272839293,0.0981514582102102,-0.109449762027059,
  -1.22690225870248e-05,-0.00530634073274416,0.108764333946017,-0.137742258436595,
  -1.25319063639107e-05,-0.00502286873709501,0.119377209681824,-0.166034754846131,
  -1.27947901409908e-05,-0.00473939674144608,0.129990085417631,-0.194327251255667,
  -1.30576739180155e-05,-0.00445592474579715,0.140602961153438,-0.222619747665203,
  -1.33205576947071e-05,-0.00417245275014788,0.151215836889245,-0.250912244074739,
  -1.35834414717872e-05,-0.00388898075449895,0.161828712625052,-0.279204740484274,
  -1.38463252486454e-05,-0.00360550875884957,0.17244158836086,-0.30749723689381,
  -1.41092090258366e-05,-0.00332203676320098,0.183054464096666,-0.335789733303346,
  -1.43720928026392e-05,-0.00303856476755171,0.193667339832474,-0.364082229712882,
  -1.46349765797193e-05,-0.00275509277190289,0.204280215568281,-0.392374726122418,
  -1.48978603571326e-05,-0.00247162077625451,0.214893091304087,-0.420667222531954,
  -1.51607441337687e-05,-0.0021881487806048,0.225505967039895,-0.44895971894149,
  -1.54236279108488e-05,-0.00190467678495598,0.236118842775702,-0.477252215351026,
  -1.5686511687929e-05,-0.00162120478930694,0.246731718511509,-0.505544711760562,
  -1.59493954646761e-05,-0.00133773279365745,0.257344594247316,-0.533837208170097,
  -1.62122792415342e-05,-0.00105426079800797,0.267957469983124,-0.562129704579633,
  -1.64751630186144e-05,-0.000770788802359146,0.278570345718931,-0.590422200989169,
  -1.67380467960276e-05,-0.000487316806710769,0.289183221454737,-0.618714697398705,
  -1.70009305727747e-05,-0.000203844811061504,0.299796097190545,-0.647007193808241,
  -1.72638143497439e-05,7.96271845868723e-05,0.310408972926351,-0.675299690217777,
  -1.75266981270461e-05,0.000363099180236137,0.321021848662159,-0.703592186627313,
  -1.77895819037932e-05,0.000646571175885402,0.331634724397966,-0.731884683036849,
  -1.80524656806513e-05,0.000930043171534667,0.342247600133773,-0.760177179446385,
  -1.83153494573984e-05,0.00121351516718393,0.35286047586958,-0.788469675855921,
  -9.12489553736573e-06,-0.0054123496580194,0.0972475554035802,-0.110205947423729,
  -9.28615369125141e-06,-0.00516568791187411,0.107557184001185,-0.138685629109336,
  -9.44741184549791e-06,-0.00491902616572915,0.117866812598789,-0.167165310794943,
  -9.60866999932808e-06,-0.00467236441958374,0.128176441196394,-0.195644992480551,
  -9.7699281534358e-06,-0.00442570267343856,0.138486069793999,-0.224124674166158,
  -9.93118630748802e-06,-0.00417904092729326,0.148795698391604,-0.252604355851765,
  -1.00924444614847e-05,-0.0039323791811483,0.159105326989208,-0.281084037537372,
  -1.02537026154259e-05,-0.0036857174350029,0.169414955586813,-0.30956371922298,
  -1.04149607694781e-05,-0.00343905568885772,0.179724584184417,-0.338043400908587,
  -1.05762189235303e-05,-0.00319239394271231,0.190034212782022,-0.366523082594194,
  -1.0737477077416e-05,-0.00294573219656713,0.200343841379627,-0.395002764279802,
  -1.08987352316903e-05,-0.00269907045042239,0.210653469977231,-0.423482445965409,
  -1.10599933854649e-05,-0.00245240870427654,0.220963098574836,-0.451962127651016,
  -1.12212515392951e-05,-0.00220574695813136,0.231272727172441,-0.480441809336623,
  -1.13825096936804e-05,-0.00195908521198662,0.241582355770045,-0.508921491022231,
  -1.15437678472885e-05,-0.00171242346584055,0.25189198436765,-0.537401172707838,
  -1.17050260016738e-05,-0.00146576171969559,0.262201612965255,-0.565880854393445,
  -1.1866284155726e-05,-0.00121909997355085,0.272511241562859,-0.594360536079053,
  -1.20275423095562e-05,-0.000972438227405448,0.282820870160464,-0.62284021776466,
  -1.21888004632753e-05,-0.000725776481259377,0.293130498758069,-0.651319899450267,
  -1.23500586176606e-05,-0.000479114735114639,0.303440127355674,-0.679799581135874,
  -1.25113167716018e-05,-0.000232452988969456,0.313749755953278,-0.708279262821482,
  -1.2672574925876e-05,1.42087571752825e-05,0.324059384550883,-0.736758944507089,
  -1.28338330798172e-05,0.000260870503320465,0.334369013148487,-0.765238626192696,
  -1.29950912333143e-05,0.000507532249466092,0.344678641746092,-0.793718307878304,
  -6.83115584967919e-06,-0.00527595995553259,0.0965256040382916,-0.110804190206857,
  -6.92852758998885e-06,-0.00505949294417618,0.106593629701304,-0.139431960232983,
  -7.02589933029851e-06,-0.0048430259328196,0.116661655364317,-0.168059730259109,
  -7.12327107088573e-06,-0.00462655892146346,0.126729681027329,-0.196687500285235,
  -7.22064281111212e-06,-0.00441009191010688,0.136797706690342,-0.225315270311362,
  -7.31801455144954e-06,-0.00419362489875008,0.146865732353354,-0.253943040337488,
  -7.41538629184246e-06,-0.00397715788739395,0.156933758016367,-0.282570810363614,
  -7.51275803234641e-06,-0.0037606908760377,0.167001783679379,-0.311198580389741,
  -7.61012977251729e-06,-0.00354422386468078,0.177069809342392,-0.339826350415867,
  -7.70750151302124e-06,-0.00332775685332454,0.187137835005404,-0.368454120441993,
  -7.80487325330315e-06,-0.00311128984196807,0.197205860668417,-0.397081890468119,
  -7.90224499347403e-06,-0.00289482283061138,0.207273886331429,-0.425709660494246,
  -7.99961673392247e-06,-0.00267835581925491,0.217341911994442,-0.454337430520372,
  -8.09698847425988e-06,-0.00246188880789866,0.227409937657454,-0.482965200546498,
  -8.19436021448627e-06,-0.00224542179654175,0.237477963320467,-0.511592970572624,
  -8.29173195504573e-06,-0.00202895478518572,0.247545988983479,-0.54022074059875,
  -8.38910369549417e-06,-0.00181248777382947,0.257614014646492,-0.568848510624877,
  -8.48647543549852e-06,-0.00159602076247278,0.267682040309504,-0.597476280651003,
  -8.58384717605798e-06,-0.00137955375111654,0.277750065972517,-0.62610405067713,
  -8.68121891695051e-06,-0.00116308673976029,0.28781809163553,-0.654731820703256,
  -8.77859065673281e-06,-0.000946619728403153,0.297886117298542,-0.683359590729382,
  -8.87596239718125e-06,-0.00073015271704735,0.307954142961554,-0.711987360755509,
  -8.9733341371856e-06,-0.00051368570568977,0.318022168624567,-0.740615130781635,
  -9.07070587707892e-06,-0.000297218694333079,0.32809019428758,-0.769242900807761,
  -9.16807761852656e-06,-8.0751682978164e-05,0.338158219950592,-0.797870670833887,
  -5.05375034340338e-06,-0.0051732050509341,0.0959647446968884,-0.11126552299452,
  -5.11222258181565e-06,-0.00498067081721709,0.105845437000755,-0.140007490816054,
  -5.17069482022792e-06,-0.00478813658350008,0.115726129304622,-0.168749458637588,
  -5.22916705875121e-06,-0.00459560234978307,0.125606821608488,-0.197491426459123,
  -5.28763929735776e-06,-0.00440306811606639,0.135487513912355,-0.226233394280657,
  -5.34611153563125e-06,-0.00421053388234915,0.145368206216221,-0.254975362102192,
  -5.40458377390474e-06,-0.0040179996486317,0.155248898520088,-0.283717329923726,
  -5.46305601234476e-06,-0.0038254654149148,0.165129590823955,-0.31245929774526,
  -5.5215282513954e-06,-0.00363293118119867,0.175010283127821,-0.341201265566795,
  -5.58000048955787e-06,-0.00344039694748122,0.184890975431688,-0.369943233388329,
  -5.63847272777585e-06,-0.00324786271376376,0.194771667735555,-0.398685201209863,
  -5.69694496660444e-06,-0.00305532848004719,0.204652360039421,-0.427427169031398,
  -5.75541720493344e-06,-0.00286279424633018,0.214533052343288,-0.456169136852932,
  -5.81388944331795e-06,-0.00267026001261317,0.224413744647155,-0.484911104674467,
  -5.87236168192451e-06,-0.00247772577889616,0.234294436951021,-0.513653072496001,
  -5.93083392042004e-06,-0.00228519154517914,0.244175129254888,-0.542395040317535,
  -5.98930615891557e-06,-0.00209265731146235,0.254055821558755,-0.57113700813907,
  -6.04777839718906e-06,-0.00190012307774512,0.263936513862621,-0.599878975960604,
  -6.10625063512948e-06,-0.00170758884402744,0.273817206166488,-0.628620943782139,
  -6.16472287373604e-06,-0.00151505461031043,0.283697898470355,-0.657362911603673,
  -6.22319511245362e-06,-0.0013225203765943,0.293578590774221,-0.686104879425207,
  -6.28166735094915e-06,-0.00112998614287729,0.303459283078088,-0.714846847246742,
  -6.34013958988877e-06,-0.000937451909160725,0.313339975381954,-0.743588815068276,
  -6.3986118283843e-06,-0.000744917675443713,0.323220667685821,-0.77233078288981,
  -6.45708406588064e-06,-0.000552383441724924,0.333101359989688,-0.801072750711345,
  -3.70501094104636e-06,-0.00509692020875624,0.0955383278748698,-0.11161430732803,
  -3.7402543903442e-06,-0.00492285513785695,0.105276798533111,-0.140442612828188,
  -3.77549783975306e-06,-0.00474879006695772,0.115015269191353,-0.169270918328346,
  -3.81074128913417e-06,-0.0045747249960586,0.124753739849594,-0.198099223828504,
  -3.8459847386263e-06,-0.00440065992515948,0.134492210507836,-0.226927529328662,
  -3.88122818795189e-06,-0.00422659485426036,0.144230681166077,-0.25575583482882,
  -3.91647163738851e-06,-0.00405252978336113,0.153969151824318,-0.284584140328978,
  -3.95171508704717e-06,-0.00387846471246234,0.16370762248256,-0.313412445829136,
  -3.98695853615072e-06,-0.00370439964156266,0.173446093140801,-0.342240751329294,
  -4.02220198564285e-06,-0.00353033457066365,0.183184563799043,-0.371069056829453,
  -4.05744543519049e-06,-0.00335626949976464,0.192923034457284,-0.399897362329611,
  -4.09268888440506e-06,-0.00318220442886541,0.202661505115525,-0.428725667829769,
  -4.12793233373066e-06,-0.00300813935796618,0.212399975773767,-0.457553973329927,
  -4.16317578322278e-06,-0.00283407428706717,0.222138446432008,-0.486382278830085,
  -4.19841923238184e-06,-0.00266000921616749,0.23187691709025,-0.515210584330243,
  -4.23366268209602e-06,-0.00248594414526915,0.241615387748491,-0.544038889830401,
  -4.26890613147712e-06,-0.00231187907436925,0.251353858406733,-0.572867195330559,
  -4.30414958030312e-06,-0.00213781400346957,0.261092329064974,-0.601695500830717,
  -4.33939303035036e-06,-0.00196374893257145,0.270830799723215,-0.630523806330875,
  -4.37463647950942e-06,-0.00178968386167178,0.280569270381457,-0.659352111831033,
  -4.40987992955666e-06,-0.00161561879077343,0.290307741039698,-0.688180417331191,
  -4.44512337882674e-06,-0.0014415537198742,0.300046211697939,-0.717008722831349,
  -4.48036682809683e-06,-0.00126748864897497,0.309784682356181,-0.745837028331507,
  -4.51561027725589e-06,-0.00109342357807574,0.319523153014422,-0.774665333831665,
  -4.55085372697006e-06,-0.000919358507176504,0.329261623672664,-0.803493639331823,
  -2.69772602098928e-06,-0.00504088952996201,0.0952194047193457,-0.11187407580856,
  -2.71920955394189e-06,-0.00488079001395125,0.104851620627799,-0.140766684103981,
  -2.74069308667246e-06,-0.00472069049794011,0.114483836536253,-0.169659292399401,
  -2.76217661970835e-06,-0.00456059098192918,0.124116052444707,-0.198551900694822,
  -2.78366015249443e-06,-0.00440049146591825,0.133748268353161,-0.227444508990243,
  -2.80514368550255e-06,-0.00424039194990744,0.143380484261615,-0.256337117285663,
  -2.82662721828864e-06,-0.00408029243389629,0.153012700170069,-0.285229725581084,
  -2.84811075090818e-06,-0.00392019291788492,0.162644916078522,-0.314122333876505,
  -2.86959428402733e-06,-0.00376009340187444,0.172277131986976,-0.343014942171925,
  -2.8910778172575e-06,-0.00359999388586396,0.18190934789543,-0.371907550467346,
  -2.91256134976603e-06,-0.00343989436985281,0.191541563803883,-0.400800158762767,
  -2.93404488260762e-06,-0.00327979485384167,0.201173779712337,-0.429692767058187,
  -2.95552841544922e-06,-0.00311969533783074,0.210805995620791,-0.458585375353608,
  -2.97701194795774e-06,-0.00295959582181915,0.220438211529245,-0.487477983649028,
  -2.99849548135445e-06,-0.00279949630580867,0.230070427437699,-0.516370591944449,
  -3.01997901475115e-06,-0.00263939678979885,0.239702643346152,-0.54526320023987,
  -3.04146254703763e-06,-0.00247929727378682,0.249334859254606,-0.57415580853529,
  -3.06294608021229e-06,-0.00231919775777634,0.25896707516306,-0.603048416830711,
  -3.08442961283184e-06,-0.00215909824176519,0.268599291071514,-0.631941025126132,
  -3.10591314622854e-06,-0.00199899872575493,0.278231506979967,-0.660833633421552,
  -3.12739667862605e-06,-0.00183889920974245,0.287863722888422,-0.689726241716973,
  -3.14888021157866e-06,-0.00167879969373175,0.297495938796876,-0.718618850012394,
  -3.17036374397617e-06,-0.0015187001777206,0.307128154705329,-0.747511458307814,
  -3.19184727737287e-06,-0.00135860066171034,0.316760370613783,-0.776404066603235,
  -3.21333080999242e-06,-0.00119850114569919,0.326392586522236,-0.805296674898655,
  -1.95435807170963e-06,-0.00500005209382431,0.0949837906642617,-0.112065393789132,
  -1.96767481369653e-06,-0.00485035286914359,0.104537570109605,-0.141005360720634,
  -1.98099155565568e-06,-0.00470065364446282,0.114091349554949,-0.169945327652136,
  -1.99430829761482e-06,-0.00455095441978193,0.123645129000292,-0.198885294583638,
  -2.00762503965723e-06,-0.00440125519510115,0.133198908445636,-0.227825261515139,
  -2.02094178164414e-06,-0.00425155597042037,0.14275268789098,-0.256765228446641,
  -2.03425852379757e-06,-0.00410185674573993,0.152306467336323,-0.285705195378143,
  -2.04757526545141e-06,-0.00395215752105882,0.161860246781667,-0.314645162309645,
  -2.06089200749382e-06,-0.00380245829637804,0.171414026227011,-0.343585129241147,
  -2.07420874948072e-06,-0.00365275907169726,0.180967805672354,-0.372525096172648,
  -2.08752549157865e-06,-0.00350305984701693,0.190521585117697,-0.40146506310415,
  -2.10084223362106e-06,-0.00335336062233571,0.200075364563041,-0.430405030035652,
  -2.11415897566347e-06,-0.00320366139765516,0.209629144008385,-0.459344996967154,
  -2.1274757172618e-06,-0.00305396217297416,0.219182923453728,-0.488284963898656,
  -2.14079245919319e-06,-0.00290426294829316,0.228736702899072,-0.517224930830157,
  -2.15410920179071e-06,-0.00275456372361349,0.238290482344415,-0.546164897761659,
  -2.16742594305597e-06,-0.00260486449893138,0.247844261789759,-0.575104864693161,
  -2.1807426852094e-06,-0.00245516527425083,0.257398041235103,-0.604044831624663,
  -2.19405942758488e-06,-0.00230546604957071,0.266951820680446,-0.632984798556165,
  -2.20737616873912e-06,-0.00215576682488861,0.27650560012579,-0.661924765487666,
  -2.22069291133664e-06,-0.00200606760020872,0.286059379571133,-0.690864732419168,
  -2.23400965326803e-06,-0.00185636837552838,0.295613159016477,-0.71980469935067,
  -2.24732639497738e-06,-0.00170666915084627,0.305166938461821,-0.748744666282172,
  -2.26064313746388e-06,-0.00155696992616683,0.314720717907164,-0.777684633213674,
  -2.27395987917323e-06,-0.00140727070148605,0.324274497352508,-0.806624600145176,
  -1.41056460697953e-06,-0.00497045281280539,0.0948112979073366,-0.112205140109363,
  -1.41898454053546e-06,-0.00482841191805494,0.104307687476285,-0.141179699686594,
  -1.42740447453549e-06,-0.00468637102330483,0.113804077045234,-0.170154259263824,
  -1.43582440809142e-06,-0.00454433012855426,0.123300466614182,-0.199128818841055,
  -1.44424434178614e-06,-0.00440228923380392,0.132796856183131,-0.228103378418286,
  -1.45266427548085e-06,-0.00426024833905336,0.14229324575208,-0.257077937995516,
  -1.46108420917557e-06,-0.00411820744430313,0.151789635321028,-0.286052497572747,
  -1.46950414287028e-06,-0.00397616654955235,0.161286024889977,-0.315027057149978,
  -1.47792407700909e-06,-0.00383412565480268,0.170782414458926,-0.344001616727208,
  -1.48634401081482e-06,-0.00369208476005234,0.180278804027874,-0.372976176304439,
  -1.49476394395442e-06,-0.00355004386530133,0.189775193596823,-0.40195073588167,
  -1.50318387792669e-06,-0.00340800297055122,0.199271583165772,-0.4309252954589,
  -1.51160381134385e-06,-0.00326596207580043,0.20876797273472,-0.459899855036131,
  -1.52002374542715e-06,-0.00312392118105076,0.218264362303669,-0.488874414613362,
  -1.52844367906635e-06,-0.0029818802863002,0.227760751872617,-0.517848974190592,
  -1.53686361281657e-06,-0.00283983939154964,0.237257141441566,-0.546823533767823,
  -1.54528354645578e-06,-0.00269779849679908,0.246753531010515,-0.575798093345054,
  -1.55370347998396e-06,-0.00255575760204829,0.256249920579464,-0.604772652922284,
  -1.56212341373418e-06,-0.00241371670729817,0.265746310148412,-0.633747212499515,
  -1.57054334770645e-06,-0.00227167581254806,0.275242699717361,-0.662721772076746,
  -1.57896328145668e-06,-0.0021296349177975,0.28473908928631,-0.691696331653976,
  -1.58738321520691e-06,-0.00198759402304738,0.294235478855258,-0.720670891231207,
  -1.59580314862406e-06,-0.00184555312829637,0.303731868424207,-0.749645450808438,
  -1.60422308270736e-06,-0.0017035122335467,0.313228257993155,-0.778620010385669,
  -1.61264301612452e-06,-0.00156147133879569,0.322724647562104,-0.807594569962899,
  -1.01531944154964e-06,-0.00494908414239981,0.0946858537565381,-0.112306602157747,
  -1.02075476535179e-06,-0.00481263610113947,0.104140524546712,-0.141306277535443,
  -1.02619008929272e-06,-0.00467618805987946,0.113595195336887,-0.170305952913139,
  -1.03162541342794e-06,-0.00453974001861945,0.123049866127061,-0.199305628290835,
  -1.03706073723009e-06,-0.00440329197735922,0.132504536917236,-0.228305303668531,
  -1.04249606130979e-06,-0.00426684393609933,0.14195920770741,-0.257304979046227,
  -1.04793138483439e-06,-0.00413039589483866,0.151413878497584,-0.286304654423923,
  -1.05336670891409e-06,-0.00399394785357865,0.160868549287759,-0.315304329801619,
  -1.05880203271624e-06,-0.0038574998123182,0.170323220077933,-0.344304005179315,
  -1.06423735674044e-06,-0.00372105177105819,0.179777890868107,-0.373303680557011,
  -1.06967268070912e-06,-0.00358460372979841,0.189232561658282,-0.402303355934707,
  -1.07510800434474e-06,-0.00344815568853796,0.198687232448456,-0.431303031312403,
  -1.08054332814689e-06,-0.00331170764727751,0.20814190323863,-0.460302706690099,
  -1.08597865233762e-06,-0.00317525960601772,0.217596574028805,-0.489302382067795,
  -1.09141397608425e-06,-0.00303881156475749,0.227051244818979,-0.518302057445491,
  -1.09684930049703e-06,-0.00290236352349793,0.236505915609153,-0.547301732823187,
  -1.10228462413264e-06,-0.00276591548223704,0.245960586399328,-0.576301408200883,
  -1.1077199479903e-06,-0.00262946744097725,0.255415257189502,-0.605301083578579,
  -1.11315527184797e-06,-0.00249301939971724,0.264869927979676,-0.634300758956275,
  -1.1185905955946e-06,-0.00235657135845635,0.274324598769851,-0.663300434333971,
  -1.12402591978533e-06,-0.00222012331719679,0.283779269560025,-0.692300109711667,
  -1.12946124342095e-06,-0.00208367527593634,0.2932339403502,-0.721299785089364,
  -1.13489656750065e-06,-0.00194722723467633,0.302688611140374,-0.750299460467059,
  -1.14033189158036e-06,-0.00181077919341588,0.312143281930549,-0.779299135844755,
  -1.14576721554904e-06,-0.00167433115215676,0.321597952720722,-0.808298811222452,
  -6.29745544075688e-05,-0.00993262689014757,0.121579107247871,-0.105719242678498,
  -6.77301365100968e-05,-0.00925954296093956,0.136860984208181,-0.130248224071424,
  -7.24857186124306e-05,-0.00858645903173139,0.15214286116849,-0.154777205464349,
  -7.72413007151806e-05,-0.00791337510252366,0.1674247381288,-0.179306186857274,
  -8.19968828174034e-05,-0.00724029117331548,0.18270661508911,-0.2038351682502,
  -8.67524649198481e-05,-0.00656720724410742,0.197988492049419,-0.228364149643125,
  -9.15080470225149e-05,-0.00589412331489947,0.213270369009729,-0.25289313103605,
  -9.62636291250152e-05,-0.00522103938569174,0.228552245970039,-0.277422112428976,
  -0.000101019211227404,-0.00454795545648334,0.243834122930349,-0.301951093821901,
  -0.000105774793329905,-0.00387487152727539,0.259115999890658,-0.326480075214826,
  -0.000110530375432516,-0.00320178759806744,0.274397876850968,-0.351009056607751,
  -0.00011528595753485,-0.00252870366885904,0.289679753811278,-0.375538038000677,
  -0.000120041539637072,-0.00185561973965109,0.304961630771587,-0.400067019393602,
  -0.000124797121740072,-0.00118253581044359,0.320243507731897,-0.424596000786527,
  -0.000129552703841962,-0.000509451881234746,0.335525384692207,-0.449124982179453,
  -0.000134308285944407,0.000163632047972984,0.350807261652516,-0.473653963572378,
  -0.000139063868047185,0.000836715977180935,0.366089138612826,-0.498182944965303,
  -0.000143819450149629,0.00150979990638889,0.381371015573136,-0.522711926358228,
  -0.000148575032251963,0.0021828838355975,0.396652892533446,-0.547240907751154,
  -0.00015333061435463,0.00285596776480501,0.411934769493755,-0.571769889144079,
  -0.000158086196456964,0.00352905169401296,0.427216646454065,-0.596298870537004,
  -0.000162841778559852,0.00420213562322047,0.442498523414374,-0.62082785192993,
  -0.000167597360662075,0.00487521955242931,0.457780400374685,-0.645356833322855,
  -0.000172352942764409,0.00554830348163726,0.473062277334994,-0.66988581471578,
  -0.000177108524866965,0.00622138741084477,0.488344154295304,-0.694414796108706,
  -6.25212171991851e-05,-0.00988116932849398,0.121441629470806,-0.105860539473836,
  -6.72150409196381e-05,-0.00920973978907358,0.136679928207829,-0.130420880930384,
  -7.1908864640341e-05,-0.00853831024965357,0.151918226944851,-0.154981222386931,
  -7.6602688361016e-05,-0.00786688071023356,0.167156525681874,-0.179541563843478,
  -8.12965120814968e-05,-0.00719545117081322,0.182394824418896,-0.204101905300026,
  -8.59903358020331e-05,-0.00652402163139298,0.197633123155919,-0.228662246756573,
  -9.06841595224583e-05,-0.00585259209197264,0.212871421892942,-0.25322258821312,
  -9.53779832431056e-05,-0.00518116255255241,0.228109720629964,-0.277782929669668,
  -0.000100071806963364,-0.00450973301313162,0.243348019366987,-0.302343271126215,
  -0.000104765630684178,-0.00383830347371217,0.258586318104009,-0.326903612582762,
  -0.000109459454404603,-0.00316687393429138,0.273824616841032,-0.351463954039309,
  -0.000114153278125251,-0.00249544439487148,0.289062915578055,-0.376024295495857,
  -0.000118847101845843,-0.00182401485545158,0.304301214315077,-0.400584636952404,
  -0.000123540925566545,-0.00115258531603146,0.319539513052099,-0.425144978408951,
  -0.000128234749287026,-0.000481155776610898,0.334777811789122,-0.449705319865499,
  -0.000132928573007951,0.000190273762809001,0.350016110526145,-0.474265661322046,
  -0.000137622396728099,0.000861703302229566,0.365254409263168,-0.498826002778593,
  -0.000142316220448691,0.00153313284164946,0.38049270800019,-0.523386344235141,
  -0.00014701004416906,0.00220456238107047,0.395731006737213,-0.547946685691688,
  -0.00015170386788943,0.00287599192049059,0.410969305474235,-0.572507027148235,
  -0.000156397691610133,0.00354742145991072,0.426207604211258,-0.597067368604782,
  -0.000161091515330503,0.00421885099933128,0.441445902948281,-0.62162771006133,
  -0.000165785339051427,0.00489028053875096,0.456684201685303,-0.646188051517877,
  -0.000170479162772241,0.00556171007817108,0.471922500422326,-0.670748392974424,
  -0.000175172986492944,0.00623313961759075,0.487160799159348,-0.695308734430971,
  -6.18977128422071e-05,-0.00981079287236147,0.121252355724612,-0.106054555342661,
  -6.65071626657632e-05,-0.009141702933808,0.136430705448179,-0.13065795757759,
  -7.11166124893192e-05,-0.00847261299525459,0.151609055171746,-0.155261359812518,
  -7.57260623130973e-05,-0.00780352305670173,0.166787404895312,-0.179864762047447,
  -8.03355121364868e-05,-0.0071344331181481,0.181965754618879,-0.204468164282375,
  -8.49449619601539e-05,-0.00646534317959502,0.197144104342446,-0.229071566517304,
  -8.95544117838765e-05,-0.00579625324104172,0.212322454066012,-0.253674968752232,
  -9.41638616073215e-05,-0.00512716330248808,0.227500803789579,-0.278278370987161,
  -9.87733114308775e-05,-0.00445807336393478,0.242679153513146,-0.302881773222089,
  -0.000103382761254323,-0.00378898342538125,0.257857503236713,-0.327485175457018,
  -0.000107992211077879,-0.00311989348682795,0.27303585296028,-0.352088577691946,
  -0.000112601660901435,-0.00245080354827487,0.288214202683846,-0.376691979926875,
  -0.000117211110725379,-0.00178171360972179,0.303392552407413,-0.401295382161804,
  -0.000121820560548769,-0.00111262367116849,0.31857090213098,-0.425898784396732,
  -0.000126430010372269,-0.000443533732614743,0.333749251854547,-0.450502186631661,
  -0.000131039460196103,0.000225556205937671,0.348927601578113,-0.475105588866589,
  -0.000135648910019603,0.000894646144491418,0.36410595130168,-0.499708991101518,
  -0.000140258359843437,0.00156373608304428,0.379284301025247,-0.524312393336446,
  -0.000144867809666827,0.00223282602159802,0.394462650748814,-0.548915795571375,
  -0.000149477259490216,0.00290191596015132,0.40964100047238,-0.573519197806303,
  -0.00015408670931405,0.00357100589870463,0.424819350195947,-0.598122600041232,
  -0.000158696159137661,0.00424009583725793,0.439997699919514,-0.62272600227616,
  -0.000163305608961384,0.00490918577581079,0.45517604964308,-0.647329404511088,
  -0.000167915058784551,0.00557827571436498,0.470354399366647,-0.671932806746017,
  -0.00017252450860894,0.00624736565291695,0.485532749090214,-0.696536208980946,
  -6.10457847530221e-05,-0.00971537180219301,0.120993383697517,-0.106319056823321,
  -6.55410138808432e-05,-0.00904959816023088,0.136089797416879,-0.130981163739001,
  -7.00362430086365e-05,-0.00838382451826869,0.151186211136242,-0.155643270654681,
  -7.45314721367629e-05,-0.00771805087630673,0.166282624855604,-0.180305377570362,
  -7.9026701264362e-05,-0.00705227723434443,0.181379038574967,-0.204967484486042,
  -8.3521930392183e-05,-0.00638650359238202,0.196475452294329,-0.229629591401722,
  -8.80171595203927e-05,-0.00572072995042039,0.211571866013692,-0.254291698317403,
  -9.25123886481583e-05,-0.00505495630845831,0.226668279733054,-0.278953805233083,
  -9.70076177758683e-05,-0.00438918266649591,0.241764693452417,-0.303615912148763,
  -0.000101502846903911,-0.00372340902453394,0.256861107171779,-0.328278019064444,
  -0.000105998076032121,-0.0030576353825722,0.271957520891141,-0.352940125980124,
  -0.000110493305159665,-0.00239186174060957,0.287053934610504,-0.377602232895804,
  -0.000114988534287708,-0.00172608809864805,0.302150348329866,-0.402264339811485,
  -0.000119483763415751,-0.00106031445668608,0.317246762049229,-0.426926446727165,
  -0.000123978992543461,-0.000394540814723676,0.332343175768591,-0.451588553642845,
  -0.000128474221671282,0.000271232827238288,0.347439589487953,-0.476250660558526,
  -0.000132969450799325,0.000937006469200252,0.362536003207316,-0.500912767474206,
  -0.000137464679927479,0.00160278011116244,0.377632416926678,-0.525574874389886,
  -0.000141959909054634,0.00226855375312529,0.392728830646041,-0.550236981305567,
  -0.000146455138183121,0.00293432739508637,0.407825244365403,-0.574899088221247,
  -0.00015095036731072,0.003600101037049,0.422921658084766,-0.599561195136928,
  -0.000155445596438319,0.00426587467901118,0.438018071804128,-0.624223302052608,
  -0.000159940825566474,0.00493164832097337,0.453114485523491,-0.648885408968288,
  -0.000164436054694406,0.00559742196293511,0.468210899242853,-0.673547515883969,
  -0.000168931283822338,0.00626319560489685,0.483307312962215,-0.698209622799649,
  -5.98921521896556e-05,-0.00958750637341704,0.12064204552938,-0.10667614793544,
  -6.42346775772129e-05,-0.00892644199013992,0.135627461276786,-0.13141750930249,
  -6.85772029647147e-05,-0.00826537760686286,0.150612877024192,-0.156158870669541,
  -7.291972835205e-05,-0.00760431322358557,0.165598292771598,-0.180900232036592,
  -7.72622537394962e-05,-0.00694324884030839,0.180583708519004,-0.205641593403642,
  -8.16047791267205e-05,-0.00628218445703088,0.195569124266409,-0.230382954770693,
  -8.59473045145553e-05,-0.00562112007375415,0.210554540013815,-0.255124316137744,
  -9.02898299017241e-05,-0.00496005569047653,0.225539955761221,-0.279865677504794,
  -9.46323552894479e-05,-0.0042989913071998,0.240525371508627,-0.304607038871845,
  -9.89748806765056e-05,-0.00363792692392195,0.255510787256033,-0.329348400238896,
  -0.000103317406064285,-0.002976862540645,0.270496203003439,-0.354089761605946,
  -0.000107659931451454,-0.0023157981573676,0.285481618750845,-0.378831122972997,
  -0.000112002456839178,-0.00165473377409064,0.300467034498251,-0.403572484340048,
  -0.000116344982226346,-0.000993669390813468,0.315452450245656,-0.428313845707098,
  -0.000120687507614403,-0.000332605007536735,0.330437865993062,-0.453055207074149,
  -0.000125030033001017,0.000328459375741552,0.345423281740468,-0.4777965684412,
  -0.000129372558388852,0.000989523759018063,0.360408697487874,-0.502537929808251,
  -0.000133715083776242,0.00165058814229546,0.37539411323528,-0.527279291175301,
  -0.000138057609163633,0.00231165252557264,0.390379528982685,-0.552020652542352,
  -0.000142400134551246,0.00297271690884982,0.405364944730091,-0.576762013909403,
  -0.000146742659938637,0.00363378129212766,0.420350360477498,-0.601503375276453,
  -0.000151085185326139,0.00429484567540417,0.435335776224903,-0.626244736643504,
  -0.000155427710713751,0.00495591005868112,0.450321191972309,-0.650986098010554,
  -0.000159770236100587,0.00561697444195897,0.465306607719715,-0.675727459377605,
  -0.000164112761488311,0.00627803882523637,0.480292023467121,-0.700468820744656,
  -5.8348834089228e-05,-0.00941885030773526,0.120170863833363,-0.107151938233032,
  -6.24906356596067e-05,-0.00876447526894952,0.135007706822138,-0.131998898697129,
  -6.66324372299021e-05,-0.0081101002301639,0.149844549810914,-0.156845859161226,
  -7.0774238800253e-05,-0.00745572519137827,0.164681392799689,-0.181692819625323,
  -7.49160403704097e-05,-0.00680135015259253,0.179518235788465,-0.20653978008942,
  -7.90578419407328e-05,-0.00614697511380669,0.194355078777241,-0.231386740553517,
  -8.31996435113336e-05,-0.00549260007502139,0.209191921766016,-0.256233701017614,
  -8.73414450815457e-05,-0.00483822503623554,0.224028764754792,-0.281080661481711,
  -9.14832466518689e-05,-0.00418384999745003,0.238865607743567,-0.305927621945808,
  -9.5625048221859e-05,-0.00352947495866363,0.253702450732343,-0.330774582409905,
  -9.97668497922377e-05,-0.00287509991987811,0.268539293721119,-0.355621542874002,
  -0.000103908651362561,-0.0022207248810926,0.283376136709894,-0.380468503338099,
  -0.000108050452932607,-0.00156634984230664,0.29821297969867,-0.405315463802196,
  -0.000112192254502985,-0.000911974803520899,0.313049822687446,-0.430162424266293,
  -0.000116334056073586,-0.000257599764735605,0.327886665676221,-0.45500938473039,
  -0.000120475857643632,0.000396775274050354,0.342723508664997,-0.479856345194487,
  -0.000124617659214232,0.00105115031283565,0.357560351653772,-0.504703305658584,
  -0.0001287594607845,0.00170552535162138,0.372397194642548,-0.529550266122681,
  -0.000132901262354546,0.00235990039040757,0.387234037631324,-0.554397226586777,
  -0.000137043063925257,0.00301427542919264,0.402070880620099,-0.579244187050875,
  -0.000141184865494748,0.00366865046797926,0.416907723608875,-0.604091147514971,
  -0.000145326667065682,0.00432302550676456,0.43174456659765,-0.628938107979068,
  -0.000149468468635949,0.00497740054555029,0.446581409586426,-0.653785068443165,
  -0.000153610270206439,0.00563177558433559,0.461418252575202,-0.678632028907262,
  -0.000157752071776374,0.00628615062312221,0.476255095563977,-0.703478989371359,
  -5.63174605223149e-05,-0.00920099165407712,0.119548666053613,-0.10777489048742,
  -6.02013293527492e-05,-0.00855609208950081,0.134189810952349,-0.132760111853219,
  -6.40851981831558e-05,-0.00791119252492445,0.148830955851085,-0.157745333219018,
  -6.79690670135624e-05,-0.00726629296034842,0.163472100749821,-0.182730554584817,
  -7.18529358439413e-05,-0.00662139339577195,0.178113245648558,-0.207715775950616,
  -7.57368046744866e-05,-0.00597649383119592,0.192754390547294,-0.232700997316415,
  -7.96206735047544e-05,-0.00533159426661944,0.20739553544603,-0.257686218682214,
  -8.35045423352998e-05,-0.00468669470204341,0.222036680344766,-0.282671440048013,
  -8.73884111656231e-05,-0.00404179513746716,0.236677825243503,-0.307656661413812,
  -9.12722799961685e-05,-0.00339689557289113,0.251318970142239,-0.332641882779611,
  -9.51561488269359e-05,-0.00275199600831511,0.265960115040975,-0.35762710414541,
  -9.90400176567041e-05,-0.00210709644373797,0.280601259939712,-0.382612325511209,
  -0.000102923886487694,-0.00146219687916305,0.295242404838447,-0.407597546877008,
  -0.000106807755317906,-0.00081729731458613,0.309883549737184,-0.432582768242807,
  -0.000110691624148562,-0.0001723977500101,0.32452469463592,-0.457567989608606,
  -0.000114575492978775,0.000472501814566373,0.339165839534656,-0.482553210974405,
  -0.00011845936180932,0.0011174013791424,0.353806984433392,-0.507538432340204,
  -0.000122343230639532,0.00176230094371865,0.368448129332128,-0.532523653706003,
  -0.000126227099469967,0.0024072005082949,0.383089274230864,-0.557508875071802,
  -0.000130110968300734,0.00305210007287071,0.397730419129601,-0.582494096437601,
  -0.000133994837131057,0.00369699963744763,0.412371564028337,-0.6074793178034,
  -0.000137878705961714,0.00434189920202321,0.427012708927073,-0.6324645391692,
  -0.000141762574792148,0.00498679876659924,0.441653853825809,-0.657449760534998,
  -0.000145646443622138,0.0056316983311766,0.456294998724546,-0.682434981900797,
  -0.000149530312452351,0.00627659789575219,0.470936143623282,-0.707420203266596,
  -5.37001857960906e-05,-0.00892710193971546,0.118743687487011,-0.108572101661111,
  -5.72623515026072e-05,-0.00829551638681869,0.133132453292541,-0.133734259758329,
  -6.08245172088462e-05,-0.00766393083392147,0.14752121909807,-0.158896417855547,
  -6.43866829152517e-05,-0.00703234528102437,0.1619099849036,-0.184058575952765,
  -6.79488486214352e-05,-0.00640075972812737,0.176298750709129,-0.209220734049983,
  -7.15110143278408e-05,-0.00576917417523037,0.190687516514659,-0.234382892147201,
  -7.50731800343574e-05,-0.0051375886223336,0.205076282320188,-0.259545050244419,
  -7.86353457406519e-05,-0.0045060030694366,0.219465048125718,-0.284707208341637,
  -8.21975114469464e-05,-0.0038744175165395,0.233853813931247,-0.309869366438855,
  -8.5759677153241e-05,-0.00324283196364239,0.248242579736777,-0.335031524536073,
  -8.9321842859702e-05,-0.0026112464107455,0.262631345542306,-0.360193682633291,
  -9.28840085657745e-05,-0.00197966085784795,0.277020111347836,-0.38535584073051,
  -9.64461742721801e-05,-0.00134807530495129,0.291408877153366,-0.410517998827728,
  -0.000100008339978697,-0.000716489752054184,0.305797642958895,-0.435680156924946,
  -0.000103570505685102,-8.49041991572985e-05,0.320186408764425,-0.460842315022164,
  -0.000107132671391619,0.000546681353739142,0.334575174569954,-0.486004473119382,
  -0.000110694837098024,0.00117826690663647,0.348963940375484,-0.5111666312166,
  -0.000114257002804541,0.00180985245953291,0.363352706181013,-0.536328789313818,
  -0.000117819168510502,0.00244143801243069,0.377741471986543,-0.561490947411036,
  -0.000121381334216908,0.00307302356532757,0.392130237792072,-0.586653105508254,
  -0.000124943499923313,0.00370460911822468,0.406519003597602,-0.611815263605472,
  -0.000128505665629497,0.00433619467112178,0.420907769403132,-0.63697742170269,
  -0.00013206783133568,0.00496778022401889,0.435296535208661,-0.662139579799908,
  -0.000135629997041975,0.005599365776916,0.44968530101419,-0.687301737897126,
  -0.000139192162749269,0.00623095132981177,0.46407406681972,-0.712463895994345,
  -5.04194275811609e-05,-0.00859436858308127,0.117729450459499,-0.109563016714011,
  -5.35954980609432e-05,-0.00798119474293357,0.131801481508245,-0.134945103076613,
  -5.6771568540559e-05,-0.00736802090278554,0.14587351255699,-0.160327189439214,
  -5.99476390202303e-05,-0.00675484706263751,0.159945543605736,-0.185709275801816,
  -6.31237094999015e-05,-0.0061416732224896,0.174017574654482,-0.211091362164417,
  -6.62997799796838e-05,-0.0055284993823419,0.188089605703227,-0.236473448527019,
  -6.94758504594106e-05,-0.00491532554219376,0.202161636751973,-0.26185553488962,
  -7.26519209392484e-05,-0.00430215170204606,0.216233667800718,-0.287237621252222,
  -7.58279914190307e-05,-0.00368897786189848,0.230305698849464,-0.312619707614823,
  -7.90040618981469e-05,-0.00307580402174956,0.24437772989821,-0.338001793977425,
  -8.21801323784843e-05,-0.00246263018160287,0.258449760946955,-0.363383880340026,
  -8.5356202857878e-05,-0.00184945634145417,0.272521791995701,-0.388765966702628,
  -8.85322733373828e-05,-0.00123628250130636,0.286593823044446,-0.41414805306523,
  -9.17083438173316e-05,-0.000623108661158556,0.300665854093192,-0.439530139427831,
  -9.48844142971694e-05,-9.93482101030452e-06,0.314737885141938,-0.464912225790433,
  -9.80604847767852e-05,0.000603239019137281,0.328809916190683,-0.490294312153034,
  -0.000101236555256401,0.00121641285928531,0.342881947239428,-0.515676398515636,
  -0.000104412625736128,0.00182958669943356,0.356953978288174,-0.541058484878237,
  -0.000107588696215632,0.00244276053958115,0.371026009336919,-0.566440571240839,
  -0.000110764766695914,0.00305593437972851,0.385098040385665,-0.591822657603441,
  -0.000113940837175419,0.00366910821987654,0.39917007143441,-0.617204743966042,
  -0.000117116907655146,0.00428228206002457,0.413242102483156,-0.642586830328644,
  -0.000120292978134873,0.00489545590017215,0.427314133531901,-0.667968916691245,
  -0.000123469048614377,0.00550862974032063,0.441386164580647,-0.693351003053847,
  -0.000126645119093882,0.00612180358046865,0.455458195629393,-0.718733089416449,
  -4.64460278921386e-05,-0.00820674271006061,0.116493502208095,-0.11075103683136,
  -4.91805722405425e-05,-0.00761837050000824,0.130181364503788,-0.136396797868077,
  -5.19151165888632e-05,-0.00702999828995587,0.143869226799482,-0.162042558904794,
  -5.46496609374336e-05,-0.00644162607990362,0.157557089095175,-0.18768831994151,
  -5.73842052857265e-05,-0.00585325386985114,0.171244951390868,-0.213334080978227,
  -6.01187496341304e-05,-0.00526488165979855,0.184932813686562,-0.238979842014944,
  -6.28532939825344e-05,-0.00467650944974629,0.198620675982255,-0.264625603051661,
  -6.55878383311048e-05,-0.00408813723969415,0.212308538277948,-0.290271364088377,
  -6.83223826792312e-05,-0.00349976502964156,0.225996400573641,-0.315917125125094,
  -7.10569270276351e-05,-0.00291139281958896,0.239684262869335,-0.341562886161811,
  -7.37914713760945e-05,-0.00232302060953637,0.253372125165028,-0.367208647198527,
  -7.65260157243874e-05,-0.00173464839948423,0.267059987460721,-0.392854408235244,
  -7.92605600729024e-05,-0.00114627618943186,0.280747849756415,-0.418500169271961,
  -8.19951044211953e-05,-0.000557903979379715,0.294435712052108,-0.444145930308678,
  -8.47296487699323e-05,3.04682306722093e-05,0.308123574347801,-0.469791691345394,
  -8.74641931178921e-05,0.000618840440725466,0.321811436643495,-0.495437452382111,
  -9.0198737466296e-05,0.00120721265077783,0.335499298939188,-0.521083213418828,
  -9.2933281814811e-05,0.0017955848608302,0.349187161234881,-0.546728974455544,
  -9.56678261633259e-05,0.00238395707088235,0.362875023530574,-0.572374735492261,
  -9.84023705118409e-05,0.00297232928093427,0.376562885826267,-0.598020496528978,
  -0.000101136914860578,0.00356070149098686,0.390250748121961,-0.623666257565694,
  -0.00010387145920876,0.00414907370103945,0.403938610417654,-0.649312018602411,
  -0.000106606003557275,0.00473744591109115,0.417626472713347,-0.674957779639128,
  -0.000109340547905235,0.00532581812114419,0.43131433500904,-0.700603540675844,
  -0.000112075092253416,0.00591419033119722,0.445002197304734,-0.726249301712561,
  -4.18297581402938e-05,-0.00777687143813749,0.115047391134535,-0.11211525475144,
  -4.40881495395451e-05,-0.00722065799464855,0.128288147089261,-0.138063796616735,
  -4.63465409387964e-05,-0.00666444455115955,0.141528903043987,-0.16401233848203,
  -4.86049323382143e-05,-0.00610823110767067,0.154769658998713,-0.189960880347325,
  -5.08633237373823e-05,-0.00555201766418167,0.168010414953439,-0.21590942221262,
  -5.31217151366059e-05,-0.00499580422069246,0.181251170908165,-0.241857964077916,
  -5.53801065355519e-05,-0.00443959077720324,0.194491926862891,-0.267806505943211,
  -5.76384979351641e-05,-0.0038833773337148,0.207732682817617,-0.293755047808506,
  -5.98968893344987e-05,-0.00332716389022569,0.220973438772344,-0.319703589673801,
  -6.21552807334447e-05,-0.00277095044673636,0.23421419472707,-0.345652131539097,
  -6.44136721326682e-05,-0.00221473700324726,0.247454950681796,-0.371600673404392,
  -6.66720635322804e-05,-0.0016585235597586,0.260695706636522,-0.397549215269687,
  -6.89304549309488e-05,-0.00110231011626927,0.273936462591248,-0.423497757134982,
  -7.11888463303945e-05,-0.000546096672780827,0.287177218545974,-0.449446299000277,
  -7.34472377298401e-05,1.01167707082794e-05,0.3004179745007,-0.475394840865573,
  -7.57056291289526e-05,0.000566330214197608,0.313658730455426,-0.501343382730868,
  -7.79640205280652e-05,0.00112254365768694,0.326899486410152,-0.527291924596163,
  -8.02224119273998e-05,0.00167875710117538,0.340140242364878,-0.553240466461458,
  -8.24808033266233e-05,0.00223497054466448,0.353380998319604,-0.579189008326753,
  -8.4739194726291e-05,0.00279118398815292,0.36662175427433,-0.605137550192049,
  -8.69975861250705e-05,0.00334739743164292,0.379862510229057,-0.631086092057344,
  -8.92559775244051e-05,0.00390361087513158,0.393103266183783,-0.657034633922639,
  -9.15143689239617e-05,0.0044598243186198,0.406344022138508,-0.682983175787934,
  -9.37727603226302e-05,0.00501603776210979,0.419584778093235,-0.708931717653229,
  -9.60311517219647e-05,0.0055722512055989,0.432825534047961,-0.734880259518525,
  -3.67191166250336e-05,-0.0073257366447137,0.113433942679541,-0.113606353119257,
  -3.84979696033683e-05,-0.00680918514886164,0.126178719976784,-0.139885836245955,
  -4.02768225816474e-05,-0.00629263365300958,0.138923497274027,-0.166165319372653,
  -4.20556755598711e-05,-0.00577608215715764,0.15166827457127,-0.192444802499352,
  -4.38345285381225e-05,-0.00525953066130547,0.164413051868513,-0.21872428562605,
  -4.5613381516374e-05,-0.00474297916545308,0.177157829165756,-0.245003768752748,
  -4.73922344947364e-05,-0.00422642766960135,0.189902606462999,-0.271283251879447,
  -4.91710874727658e-05,-0.00370987617374885,0.202647383760242,-0.297562735006145,
  -5.09499404511837e-05,-0.00319332467789701,0.215392161057485,-0.323842218132843,
  -5.27287934293796e-05,-0.00267677318204451,0.228136938354728,-0.350121701259542,
  -5.45076464076866e-05,-0.00216022168619268,0.24088171565197,-0.37640118438624,
  -5.62864993864931e-05,-0.00164367019034106,0.253626492949213,-0.402680667512938,
  -5.80653523644115e-05,-0.00112711869448856,0.266371270246456,-0.428960150639636,
  -5.98442053427739e-05,-0.000610567198636502,0.279116047543699,-0.455239633766335,
  -6.16230583205812e-05,-9.40157027837785e-05,0.291860824840942,-0.481519116893033,
  -6.34019112990547e-05,0.000422535793068279,0.304605602138186,-0.507798600019731,
  -6.51807642774171e-05,0.000939087288919893,0.317350379435428,-0.53407808314643,
  -6.69596172556686e-05,0.0014556387847724,0.330095156732671,-0.560357566273128,
  -6.8738470234031e-05,0.00197219028062401,0.342839934029914,-0.586637049399826,
  -7.05173232119494e-05,0.00248874177647673,0.355584711327157,-0.612916532526524,
  -7.22961761907559e-05,0.00300529327232768,0.368329488624399,-0.639196015653223,
  -7.40750291690073e-05,0.00352184476817996,0.381074265921642,-0.665475498779921,
  -7.58538821471477e-05,0.00403839626403224,0.393819043218885,-0.691754981906619,
  -7.76327351259543e-05,0.00455494775988408,0.406563820516128,-0.718034465033317,
  -7.94115881033175e-05,0.00507149925573724,0.419308597813372,-0.744313948160016,
  -3.13549085854958e-05,-0.0068791841975252,0.111726695670886,-0.115150719626607,
  -3.26862352426349e-05,-0.0064086962548392,0.123949750500439,-0.141772966591723,
  -3.40175619001626e-05,-0.00593820831215364,0.136172805329992,-0.168395213556839,
  -3.53488885571629e-05,-0.00546772036946741,0.148395860159545,-0.195017460521955,
  -3.66802152145795e-05,-0.00499723242678152,0.160618914989097,-0.22163970748707,
  -3.80115418720517e-05,-0.00452674448409573,0.17284196981865,-0.248261954452186,
  -3.93428685289687e-05,-0.00405625654140951,0.185065024648203,-0.274884201417302,
  -4.06741951866074e-05,-0.00358576859872439,0.197288079477756,-0.301506448382418,
  -4.200552184358e-05,-0.00311528065603772,0.209511134307309,-0.328128695347534,
  -4.33368485008301e-05,-0.00264479271335216,0.221734189136861,-0.35475094231265,
  -4.46681751583022e-05,-0.00217430477066638,0.233957243966414,-0.381373189277765,
  -4.59995018154968e-05,-0.00170381682798015,0.246180298795967,-0.407995436242881,
  -4.733082847308e-05,-0.00123332888529482,0.25840335362552,-0.434617683207997,
  -4.86621551304411e-05,-0.000762840942609033,0.270626408455073,-0.461239930173113,
  -4.99934817871361e-05,-0.000292352999922585,0.282849463284626,-0.487862177138229,
  -5.13248084446083e-05,0.000178134942763419,0.295072518114179,-0.514484424103345,
  -5.26561351020804e-05,0.000648622885449202,0.307295572943732,-0.541106671068461,
  -5.39874617587754e-05,0.00111911082813543,0.319518627773284,-0.567728918033576,
  -5.53187884164696e-05,0.00158959877082121,0.331741682602837,-0.594351164998692,
  -5.66501150739418e-05,0.00206008671350677,0.34396473743239,-0.620973411963808,
  -5.79814417306368e-05,0.002530574656193,0.356187792261943,-0.647595658928924,
  -5.93127683879979e-05,0.00300106259887878,0.368410847091495,-0.67421790589404,
  -6.06440950461362e-05,0.00347155054156367,0.380633901921048,-0.700840152859155,
  -6.19754217027202e-05,0.00394203848425034,0.392856956750601,-0.727462399824271,
  -6.33067483596372e-05,0.00441252642693746,0.405080011580155,-0.754084646789387,
  -2.60307091927425e-05,-0.00646224896747605,0.110018582726155,-0.116663596750258,
  -2.69766889140211e-05,-0.00604182010861598,0.121722634733857,-0.143621618654476,
  -2.7922668635133e-05,-0.00562139124975558,0.13342668674156,-0.170579640558694,
  -2.88686483561618e-05,-0.00520096239089529,0.145130738749262,-0.197537662462911,
  -2.98146280773848e-05,-0.00478053353203534,0.156834790756964,-0.224495684367129,
  -3.07606077985523e-05,-0.00436010467317494,0.168538842764666,-0.251453706271347,
  -3.17065875199973e-05,-0.00393967581431509,0.180242894772368,-0.278411728175565,
  -3.26525672407763e-05,-0.00351924695545458,0.191946946780071,-0.305369750079783,
  -3.35985469621103e-05,-0.00309881809659429,0.203650998787773,-0.332327771984,
  -3.45445266833888e-05,-0.00267838923773422,0.215355050795475,-0.359285793888218,
  -3.54905064045008e-05,-0.00225796037887416,0.227059102803177,-0.386243815792436,
  -3.64364861255018e-05,-0.00183753152001342,0.23876315481088,-0.413201837696654,
  -3.73824658466138e-05,-0.00141710266115314,0.250467206818582,-0.440159859600872,
  -3.83284455679478e-05,-0.000996673802293291,0.262171258826284,-0.46711788150509,
  -3.92744252892818e-05,-0.000576244943433446,0.273875310833986,-0.494075903409308,
  -4.02204050102828e-05,-0.000155816084572935,0.285579362841688,-0.521033925313525,
  -4.11663847311727e-05,0.000264612774287576,0.297283414849391,-0.547991947217743,
  -4.21123644527288e-05,0.000685041633147865,0.308987466857093,-0.574949969121961,
  -4.30583441738408e-05,0.00110547049200793,0.320691518864795,-0.601907991026179,
  -4.40043238946197e-05,0.00152589935086844,0.332395570872497,-0.628866012930397,
  -4.49503036163978e-05,0.00194632820972718,0.344099622880199,-0.655824034834615,
  -4.58962833372878e-05,0.00236675706858813,0.355803674887901,-0.682782056738832,
  -4.68422630587328e-05,0.0027871859274482,0.367507726895604,-0.70974007864305,
  -4.77882427791787e-05,0.00320761478630915,0.379211778903306,-0.736698100547268,
  -4.87342225002907e-05,0.00362804364516967,0.390915830911009,-0.763656122451486,
  -2.10314592080929e-05,-0.00609374080828951,0.108402638682531,-0.118066882661525,
  -2.16712753431936e-05,-0.00572412522208843,0.119618278202666,-0.145336356324801,
  -2.23110914782942e-05,-0.00535450963588713,0.1308339177228,-0.172605829988076,
  -2.29509076133394e-05,-0.00498489404968572,0.142049557242935,-0.199875303651351,
  -2.35907237484678e-05,-0.00461527846348464,0.15326519676307,-0.227144777314626,
  -2.42305398835407e-05,-0.00424566287728301,0.164480836283205,-0.254414250977901,
  -2.48703560185581e-05,-0.00387604729108204,0.175696475803339,-0.281683724641176,
  -2.55101721538531e-05,-0.00350643170488096,0.186912115323474,-0.308953198304451,
  -2.6149988288815e-05,-0.00313681611867933,0.198127754843609,-0.336222671967726,
  -2.67898044238324e-05,-0.00276720053247792,0.209343394363743,-0.363492145631001,
  -2.74296205591273e-05,-0.00239758494627673,0.220559033883878,-0.390761619294276,
  -2.80694366939782e-05,-0.00202796936007554,0.231774673404012,-0.418031092957551,
  -2.87092528290511e-05,-0.00165835377387391,0.242990312924148,-0.445300566620827,
  -2.93490689644571e-05,-0.00128873818767317,0.254205952444282,-0.472570040284102,
  -2.9988885099419e-05,-0.000919122601471978,0.265421591964417,-0.499839513947377,
  -3.06287012343809e-05,-0.000549507015270567,0.276637231484551,-0.527108987610652,
  -3.12685173700089e-05,-0.000179891429070045,0.287852871004686,-0.554378461273927,
  -3.19083335046377e-05,0.000189724157132032,0.299068510524821,-0.581647934937202,
  -3.25481496394886e-05,0.000559339743333886,0.310284150044956,-0.608917408600477,
  -3.31879657751166e-05,0.000928955329534631,0.32149978956509,-0.636186882263752,
  -3.38277819096344e-05,0.00129857091573626,0.332715429085225,-0.663456355927027,
  -3.44675980448184e-05,0.00166818650193745,0.34393106860536,-0.690725829590302,
  -3.51074141802243e-05,0.00203780208813775,0.355146708125494,-0.717995303253577,
  -3.57472303149642e-05,0.00240741767434072,0.36636234764563,-0.745264776916852,
  -3.63870464499261e-05,0.00277703326054146,0.377577987165764,-0.772534250580128,
  -1.65758040944763e-05,-0.00578344312304624,0.106952708469109,-0.119304118994317,
  -1.6990122348931e-05,-0.0054621357738901,0.117732136048038,-0.146848190605967,
  -1.74044406033302e-05,-0.00514082842473396,0.128511563626968,-0.174392262217617,
  -1.78187588577017e-05,-0.00481952107557782,0.139290991205897,-0.201936333829267,
  -1.82330771119621e-05,-0.00449821372642145,0.150070418784826,-0.229480405440917,
  -1.86473953663335e-05,-0.00417690637726531,0.160849846363755,-0.257024477052567,
  -1.90617136206495e-05,-0.00385559902810917,0.171629273942684,-0.284568548664217,
  -1.94760318754095e-05,-0.00353429167895336,0.182408701521614,-0.312112620275867,
  -1.98903501293923e-05,-0.00321298432979655,0.193188129100543,-0.339656691887517,
  -2.03046683838748e-05,-0.00289167698064086,0.203967556679472,-0.367200763499167,
  -2.07189866382462e-05,-0.00257036963148471,0.214746984258401,-0.394744835110817,
  -2.11333048927287e-05,-0.00224906228232857,0.225526411837331,-0.422288906722467,
  -2.15476231468781e-05,-0.00192775493317199,0.23630583941626,-0.449832978334117,
  -2.19619414013605e-05,-0.00160644758401629,0.247085266995189,-0.477377049945767,
  -2.2376259655732e-05,-0.00128514023485971,0.257864694574119,-0.504921121557417,
  -2.27905779105475e-05,-0.000963832885704674,0.268644122153047,-0.532465193169067,
  -2.32048961646969e-05,-0.000642525536548089,0.279423549731976,-0.560009264780717,
  -2.36192144187353e-05,-0.000321218187390837,0.290202977310906,-0.587553336392367,
  -2.40335326733288e-05,8.91617646381349e-08,0.300982404889835,-0.615097408004017,
  -2.44478509274781e-05,0.000321396510921002,0.311761832468765,-0.642641479615667,
  -2.48621691818496e-05,0.000642703860077365,0.322541260047694,-0.670185551227317,
  -2.52764874364431e-05,0.00096401120923284,0.333320687626623,-0.697729622838967,
  -2.56908056909255e-05,0.00128531855838965,0.344100115205553,-0.725273694450617,
  -2.6105123945297e-05,0.00160662590754557,0.354879542784482,-0.752817766062266,
  -2.65194421992243e-05,0.00192793325670149,0.36565897036341,-0.780361837673917,
  -1.27851988466487e-05,-0.0055325338806973,0.105712093385572,-0.120347092032078,
  -1.30442277671561e-05,-0.00525450996101073,0.116119728993648,-0.148122645898807,
  -1.33032566877189e-05,-0.00497648604132428,0.126527364601724,-0.175898199765535,
  -1.35622856080042e-05,-0.00469846212163749,0.1369350002098,-0.203673753632264,
  -1.38213145283728e-05,-0.00442043820195093,0.147342635817875,-0.231449307498992,
  -1.40803434488523e-05,-0.00414241428226414,0.157750271425951,-0.259224861365721,
  -1.43393723691654e-05,-0.00386439036257746,0.168157907034027,-0.287000415232449,
  -1.45984012895339e-05,-0.00358636644289079,0.178565542642103,-0.314775969099177,
  -1.48574302101245e-05,-0.00330834252320455,0.188973178250179,-0.342551522965906,
  -1.51164591307151e-05,-0.0030303186035181,0.199380813858255,-0.370327076832634,
  -1.53754880508616e-05,-0.00275229468383098,0.209788449466331,-0.398102630699363,
  -1.56345169712857e-05,-0.00247427076414453,0.220196085074407,-0.425878184566091,
  -1.58935458915987e-05,-0.00219624684445741,0.230603720682483,-0.45365373843282,
  -1.61525748119118e-05,-0.00191822292477051,0.24101135629056,-0.481429292299548,
  -1.64116037325579e-05,-0.00164019900508472,0.251418991898635,-0.509204846166277,
  -1.66706326526489e-05,-0.00136217508539738,0.261826627506711,-0.536980400033005,
  -1.6929661573073e-05,-0.00108415116571092,0.272234263114787,-0.564755953899733,
  -1.71886904938301e-05,-0.000806127246024246,0.282641898722863,-0.592531507766462,
  -1.74477194138101e-05,-0.000528103326337348,0.293049534330939,-0.62030706163319,
  -1.77067483342341e-05,-0.000250079406650894,0.303457169939015,-0.648082615499919,
  -1.79657772552133e-05,2.79445130351164e-05,0.313864805547091,-0.675858169366647,
  -1.82248061755264e-05,0.000305968432722015,0.324272441155167,-0.703633723233375,
  -1.84838350959504e-05,0.000583992352408469,0.334680076763243,-0.731409277100104,
  -1.87428640165965e-05,0.000862016272094479,0.345087712371318,-0.759184830966833,
  -1.90018929370206e-05,0.00114004019178093,0.355495347979394,-0.786960384833561,
  -9.68577017024241e-06,-0.0053360922584294,0.104692886225837,-0.121193558443921,
  -9.84367642783979e-06,-0.00509492241656495,0.114796041205658,-0.149156980977209,
  -1.00015826854094e-05,-0.00485375257470044,0.12489919618548,-0.177120403510496,
  -1.01594889428958e-05,-0.00461258273283627,0.135002351165301,-0.205083826043784,
  -1.03173952006874e-05,-0.00437141289097198,0.145105506145123,-0.233047248577072,
  -1.04753014579795e-05,-0.00413024304910736,0.155208661124944,-0.261010671110359,
  -1.06332077154936e-05,-0.00388907320724252,0.165311816104766,-0.288974093643647,
  -1.07911139729522e-05,-0.00364790336537824,0.175414971084587,-0.316937516176935,
  -1.09490202308549e-05,-0.00340673352351439,0.185518126064408,-0.344900938710223,
  -1.11069264882024e-05,-0.00316556368164944,0.19562128104423,-0.37286436124351,
  -1.12648327459386e-05,-0.00292439383978538,0.205724436024051,-0.400827783776798,
  -1.14227390032307e-05,-0.00268322399792087,0.215827591003873,-0.428791206310086,
  -1.15806452609668e-05,-0.00244205415605614,0.225930745983695,-0.456754628843373,
  -1.17385515185919e-05,-0.0022008843141923,0.236033900963516,-0.484718051376661,
  -1.18964577762171e-05,-0.00195971447232801,0.246137055943337,-0.512681473909949,
  -1.20543640338422e-05,-0.0017185446304635,0.256240210923159,-0.540644896443237,
  -1.22122702916894e-05,-0.00147737478859966,0.26634336590298,-0.568608318976524,
  -1.23701765487594e-05,-0.00123620494673449,0.276446520882802,-0.596571741509812,
  -1.25280828060514e-05,-0.000995035104869757,0.286549675862623,-0.6245351640431,
  -1.26859890642317e-05,-0.000753865263006137,0.296652830842444,-0.652498586576387,
  -1.28438953214127e-05,-0.000512695421141185,0.306755985822266,-0.680462009109675,
  -1.30018015789268e-05,-0.000271525579276233,0.316859140802088,-0.708425431642963,
  -1.3159707836996e-05,-3.0355737413057e-05,0.326962295781909,-0.736388854176251,
  -1.33176140946212e-05,0.000210814104451451,0.33706545076173,-0.764352276709538,
  -1.34755203520243e-05,0.000451983946315959,0.347168605741552,-0.792315699242826,
  -7.2325036896137e-06,-0.00518605697630781,0.103883116689497,-0.121859629957562,
  -7.32735110889338e-06,-0.00497497609359365,0.113744955782084,-0.149970883480184,
  -7.42219852797876e-06,-0.00476389521087928,0.12360679487467,-0.178082137002806,
  -7.51704594720293e-06,-0.00455281432816523,0.133468633967257,-0.206193390525428,
  -7.61189336639934e-06,-0.00434173344545075,0.143330473059844,-0.23430464404805,
  -7.70674078554023e-06,-0.00413065256273648,0.153192312152431,-0.262415897570672,
  -7.8015882050142e-06,-0.00391957168002266,0.163054151245017,-0.290527151093294,
  -7.89643562409958e-06,-0.00370849079730817,0.172915990337604,-0.318638404615916,
  -7.99128304357355e-06,-0.00349740991459435,0.18277782943019,-0.346749658138538,
  -8.08613046243689e-06,-0.00328632903187964,0.192639668522777,-0.37486091166116,
  -8.18097788191086e-06,-0.00307524814916582,0.202501507615364,-0.402972165183782,
  -8.27582530082971e-06,-0.00286416726645156,0.21236334670795,-0.431083418706404,
  -8.37067272030367e-06,-0.00265308638373751,0.222225185800537,-0.459194672229025,
  -8.46552013933355e-06,-0.00244200550102325,0.232087024893123,-0.487305925751648,
  -8.5603675582524e-06,-0.00223092461830832,0.241948863985711,-0.515417179274269,
  -8.65521497794841e-06,-0.00201984373559494,0.251810703078297,-0.543528432796891,
  -8.75006239686726e-06,-0.00180876285288023,0.261672542170884,-0.571639686319513,
  -8.84490981600816e-06,-0.00159768197016574,0.271534381263471,-0.599750939842135,
  -8.93975723492701e-06,-0.00138660108745103,0.281396220356057,-0.627862193364757,
  -9.03460465440098e-06,-0.00117552020473699,0.291258059448644,-0.655973446887379,
  -9.1294520736529e-06,-0.000964439322022947,0.301119898541231,-0.684084700410001,
  -9.22429949312686e-06,-0.000753358439308904,0.310981737633817,-0.712195953932623,
  -9.31914691215674e-06,-0.000542277556595305,0.320843576726404,-0.740307207455245,
  -9.41399433107559e-06,-0.000331196673879486,0.330705415818991,-0.768418460977867,
  -9.50884175066058e-06,-0.000120115791166331,0.340567254911577,-0.796529714500489,
  -5.34007546679205e-06,-0.00507356282331128,0.103256638053844,-0.122371115145682,
  -5.39678075442418e-06,-0.00488623968474178,0.112932136346901,-0.150595890054283,
  -5.45348604188978e-06,-0.00469891654617194,0.122607634639959,-0.178820664962884,
  -5.51019132954966e-06,-0.00451159340760265,0.132283132933017,-0.207045439871485,
  -5.56689661695975e-06,-0.0043242702690327,0.141958631226075,-0.235270214780086,
  -5.62360190464739e-06,-0.00413694713046309,0.151634129519133,-0.263494989688686,
  -5.68030719250157e-06,-0.00394962399189414,0.16130962781219,-0.291719764597287,
  -5.73701247985614e-06,-0.00376230085332385,0.170985126105248,-0.319944539505888,
  -5.79371776743276e-06,-0.00357497771475446,0.180660624398306,-0.348169314414489,
  -5.85042305523142e-06,-0.00338765457618506,0.190336122691364,-0.37639408932309,
  -5.90712834280804e-06,-0.00320033143761544,0.200011620984422,-0.404618864231691,
  -5.96383363049569e-06,-0.00301300829904583,0.209687119277479,-0.432843639140292,
  -6.02053891785026e-06,-0.00282568516047577,0.219362617570537,-0.461068414048892,
  -6.07724420587097e-06,-0.00263836202190704,0.229038115863595,-0.489293188957493,
  -6.13394949333657e-06,-0.0024510388833372,0.238713614156653,-0.517517963866094,
  -6.19065478102421e-06,-0.00226371574476758,0.248389112449711,-0.545742738774695,
  -6.24736006860083e-06,-0.00207639260619819,0.258064610742768,-0.573967513683296,
  -6.3040653559554e-06,-0.00188906946762835,0.267740109035826,-0.602192288591897,
  -6.36077064286589e-06,-0.0017017463290574,0.277415607328884,-0.630417063500498,
  -6.41747593155273e-06,-0.00151442319048956,0.287091105621942,-0.658641838409098,
  -6.47418121857424e-06,-0.00132710005191905,0.296766603915,-0.686866613317699,
  -6.53088650603983e-06,-0.00113977691334988,0.306442102208057,-0.7150913882263,
  -6.58759179406054e-06,-0.00095245377478026,0.316117600501115,-0.743316163134901,
  -6.64429708141512e-06,-0.000765130636210642,0.325793098794173,-0.771540938043502,
  -6.70100236921378e-06,-0.000577807497641025,0.335468597087231,-0.799765712952103,
  -3.90904127570146e-06,-0.00499034883416188,0.102781846791002,-0.12275657864062,
  -3.94309277224059e-06,-0.00482130462420516,0.112316323756452,-0.151066905098329,
  -3.97714426855766e-06,-0.00465226041424815,0.121850800721901,-0.179377231556038,
  -4.01119576504128e-06,-0.0044832162042916,0.13138527768735,-0.207687558013747,
  -4.04524726149713e-06,-0.00431417199433459,0.140919754652799,-0.235997884471456,
  -4.07929875795299e-06,-0.00414512778437792,0.150454231618248,-0.264308210929165,
  -4.11335025451987e-06,-0.00397608357442136,0.159988708583697,-0.292618537386874,
  -4.14740175075368e-06,-0.00380703936446403,0.169523185549146,-0.320928863844583,
  -4.1814532475426e-06,-0.0036379951545078,0.179057662514595,-0.349239190302292,
  -4.21550474383192e-06,-0.00346895094455069,0.188592139480044,-0.377549516760001,
  -4.24955624012124e-06,-0.00329990673459335,0.198126616445493,-0.40585984321771,
  -4.28360773652159e-06,-0.0031308625246369,0.207661093410942,-0.434170169675419,
  -4.31765923269989e-06,-0.00296181831467934,0.217195570376391,-0.462480496133128,
  -4.35171072910023e-06,-0.00279277410472245,0.226730047341841,-0.490790822590837,
  -4.38576222550058e-06,-0.002623729894766,0.236264524307289,-0.519101149048546,
  -4.41981372201194e-06,-0.00245468568480933,0.245799001272738,-0.547411475506255,
  -4.45386521885638e-06,-0.00228564147485288,0.255333478238187,-0.575721801963964,
  -4.48791671492366e-06,-0.00211659726489577,0.264867955203636,-0.604032128421673,
  -4.521968211324e-06,-0.00194755305493866,0.274402432169085,-0.632342454879382,
  -4.55601970794639e-06,-0.00177850884498199,0.283936909134535,-0.660652781337091,
  -4.59007120434674e-06,-0.00160946463502487,0.293471386099984,-0.6889631077948,
  -4.62412270096912e-06,-0.00144042042506864,0.303005863065433,-0.717273434252509,
  -4.65817419748049e-06,-0.00127137621511197,0.312540340030881,-0.745583760710219,
  -4.69222569388084e-06,-0.00110233200515442,0.322074816996331,-0.773894087167927,
  -4.72627718983709e-06,-0.000933287795197302,0.33160929396178,-0.802204413625637,
  -2.84309424389284e-06,-0.00492939236769374,0.10242759579158,-0.12304297548658,
  -2.86378587022185e-06,-0.00477413800038395,0.111856965424429,-0.151416866183584,
  -2.88447749688392e-06,-0.00461888363307472,0.121286335057277,-0.179790756880588,
  -2.90516912349048e-06,-0.00446362926576527,0.130715704690126,-0.208164647577591,
  -2.92586074984724e-06,-0.00430837489845559,0.140145074322974,-0.236538538274595,
  -2.94655237625951e-06,-0.00415312053114569,0.149574443955823,-0.264912428971599,
  -2.96724400289383e-06,-0.00399786616383646,0.159003813588672,-0.293286319668603,
  -2.9879356293061e-06,-0.00384261179652712,0.16843318322152,-0.321660210365607,
  -3.00862725571838e-06,-0.00368735742921711,0.177862552854369,-0.35003410106261,
  -3.02931888240821e-06,-0.00353210306190799,0.187291922487217,-0.378407991759614,
  -3.0500105089315e-06,-0.00337684869459842,0.196721292120066,-0.406781882456618,
  -3.07070213556582e-06,-0.00322159432728908,0.206150661752915,-0.435155773153622,
  -3.09139376175604e-06,-0.00306633995997907,0.215580031385763,-0.463529663850625,
  -3.11208538839036e-06,-0.0029110855926695,0.225009401018612,-0.491903554547629,
  -3.13277701480263e-06,-0.00275583122536016,0.234438770651461,-0.520277445244633,
  -3.15346864099286e-06,-0.00260057685805037,0.243868140284309,-0.548651335941637,
  -3.17416026784922e-06,-0.00244532249074125,0.253297509917158,-0.577025226638641,
  -3.1948518942615e-06,-0.00229006812343147,0.262726879550006,-0.605399117335645,
  -3.21554352022968e-06,-0.00213481375612101,0.272156249182856,-0.633773008032648,
  -3.23623514719706e-06,-0.00197955938881211,0.281585618815704,-0.662146898729652,
  -3.2569267739424e-06,-0.00182430502150321,0.291014988448552,-0.690520789426656,
  -3.27761840013263e-06,-0.00166905065419254,0.300444358081402,-0.71889468012366,
  -3.29831002621184e-06,-0.00151379628688275,0.30987372771425,-0.747268570820663,
  -3.31900165273513e-06,-0.00135854191957341,0.319303097347098,-0.775642461517667,
  -3.33969327903638e-06,-0.00120328755226318,0.328732466979948,-0.804016352214671,
  -2.05796516150603e-06,-0.00488505214499968,0.102166349102288,-0.123253529805505,
  -2.07075676403323e-06,-0.00474004941776607,0.111518266397154,-0.151674151900921,
  -2.08354836644942e-06,-0.00459504669053246,0.120870183692019,-0.180094773996338,
  -2.09633996905989e-06,-0.00445004396329896,0.130222100986884,-0.208515396091754,
  -2.10913157144832e-06,-0.00430504123606523,0.13957401828175,-0.23693601818717,
  -2.12192317400328e-06,-0.00416003850883184,0.148925935576615,-0.265356640282587,
  -2.13471477655824e-06,-0.00401503578159823,0.15827785287148,-0.293777262378003,
  -2.14750637872463e-06,-0.00387003305436417,0.167629770166346,-0.32219788447342,
  -2.16029798144612e-06,-0.00372503032713078,0.176981687461211,-0.350618506568836,
  -2.1730895840566e-06,-0.0035800275998974,0.186333604756076,-0.379039128664252,
  -2.18588118605645e-06,-0.00343502487266312,0.195685522050941,-0.407459750759669,
  -2.1986727890555e-06,-0.00329002214543039,0.205037439345807,-0.435880372855085,
  -2.21146439149944e-06,-0.00314501941819612,0.214389356640672,-0.464300994950502,
  -2.22425599416542e-06,-0.00300001669096317,0.223741273935537,-0.492721617045918,
  -2.23704759660937e-06,-0.00285501396372934,0.233093191230403,-0.521142239141334,
  -2.24983919916433e-06,-0.00271001123649595,0.242445108525268,-0.549562861236751,
  -2.26263080149725e-06,-0.00256500850926233,0.251797025820133,-0.577983483332167,
  -2.27542240405221e-06,-0.00242000578202872,0.261148943114998,-0.606404105427583,
  -2.28821400682921e-06,-0.00227500305479555,0.270500860409863,-0.634824727523,
  -2.30100560871804e-06,-0.00213000032756128,0.279852777704729,-0.663245349618416,
  -2.31379721193914e-06,-0.00198499760032833,0.289204694999594,-0.691665971713833,
  -2.32658881405001e-06,-0.00183999487309405,0.29855661229446,-0.720086593809249,
  -2.33938041693804e-06,-0.00169499214586155,0.307908529589324,-0.748507215904666,
  -2.35217201871585e-06,-0.00154998941862683,0.31726044688419,-0.776927838000082,
  -2.36496362127081e-06,-0.00140498669139344,0.326612364179055,-0.805348460095498,
  -1.48444435693618e-06,-0.00485296004430896,0.101975341671248,-0.123407126393293,
  -1.49251400780037e-06,-0.00471549649036385,0.111270662757443,-0.151861838425099,
  -1.50058365874783e-06,-0.0045780329364189,0.120565983843638,-0.180316550456906,
  -1.50865330961203e-06,-0.00444056938247384,0.129861304929834,-0.208771262488712,
  -1.51672296055949e-06,-0.00430310582852889,0.139156626016029,-0.237225974520518,
  -1.52479261117389e-06,-0.00416564227458338,0.148451947102225,-0.265680686552325,
  -1.53286226201033e-06,-0.00402817872063843,0.15774726818842,-0.294135398584131,
  -1.54093191312432e-06,-0.00389071516669337,0.167042589274616,-0.322590110615937,
  -1.54900156357218e-06,-0.00375325161274787,0.176337910360811,-0.351044822647743,
  -1.55707121457516e-06,-0.00361578805880303,0.185633231447007,-0.37949953467955,
  -1.56514086557813e-06,-0.00347832450485797,0.194928552533202,-0.407954246711356,
  -1.57321051619252e-06,-0.00334086095091291,0.204223873619397,-0.436408958743162,
  -1.58128016713999e-06,-0.00320339739696784,0.213519194705593,-0.464863670774968,
  -1.58934981797643e-06,-0.00306593384302278,0.222814515791788,-0.493318382806774,
  -1.59741946859082e-06,-0.00292847028907728,0.232109836877984,-0.521773094838581,
  -1.60548911953828e-06,-0.00279100673513222,0.241405157964179,-0.550227806870387,
  -1.61355877048575e-06,-0.00265354318118738,0.250700479050375,-0.578682518902193,
  -1.6216284208781e-06,-0.00251607962724143,0.259995800136571,-0.607137230933999,
  -1.62969807260271e-06,-0.00237861607329748,0.269291121222766,-0.635591942965806,
  -1.63776772243995e-06,-0.00224115251935109,0.278586442308961,-0.664046654997612,
  -1.64583737360946e-06,-0.00210368896540647,0.287881763395157,-0.692501367029418,
  -1.65390702455692e-06,-0.00196622541146185,0.297177084481352,-0.720956079061224,
  -1.66197667539336e-06,-0.00182876185751635,0.306472405567547,-0.749410791093031,
  -1.67004632600776e-06,-0.00169129830357084,0.315767726653743,-0.777865503124837,
  -1.67811597717726e-06,-0.00155383474962623,0.325063047739938,-0.806320215156643,
  -1.06802781960069e-06,-0.0048298157695611,0.101836565852121,-0.123518538352924,
  -1.0732272373859e-06,-0.00469785286076918,0.111090784084086,-0.151997977669832,
  -1.07842665530988e-06,-0.00456588995197749,0.120345002316051,-0.18047741698674,
  -1.0836260731506e-06,-0.00443392704318579,0.129599220548016,-0.208956856303648,
  -1.08882549065825e-06,-0.00430196413439365,0.138853438779981,-0.237436295620556,
  -1.09402490860999e-06,-0.00417000122560218,0.148107657011946,-0.265915734937464,
  -1.09922432633969e-06,-0.00403803831681016,0.157361875243911,-0.294395174254372,
  -1.10442374395836e-06,-0.00390607540801846,0.166616093475876,-0.32287461357128,
  -1.10962316202112e-06,-0.00377411249922677,0.175870311707841,-0.351354052888188,
  -1.11482257997286e-06,-0.00364214959043552,0.185124529939806,-0.379833492205096,
  -1.120021997425e-06,-0.00351018668164294,0.194378748171771,-0.408312931522004,
  -1.12522141537674e-06,-0.00337822377285169,0.203632966403736,-0.436792370838912,
  -1.13042083282888e-06,-0.00324626086405955,0.212887184635701,-0.46527181015582,
  -1.13562025083613e-06,-0.00311429795526763,0.222141402867666,-0.493751249472728,
  -1.14081966873236e-06,-0.00298233504647594,0.231395621099631,-0.522230688789636,
  -1.14601908662859e-06,-0.00285037213768424,0.240649839331596,-0.550710128106544,
  -1.15121850452482e-06,-0.00271840922889321,0.24990405756356,-0.579189567423452,
  -1.15641792186594e-06,-0.00258644632010041,0.259158275795526,-0.60766900674036,
  -1.16161733965114e-06,-0.00245448341130849,0.268412494027491,-0.636148446057268,
  -1.16681675754737e-06,-0.00232252050251702,0.277666712259456,-0.664627885374176,
  -1.17201617599871e-06,-0.00219055759372644,0.28692093049142,-0.693107324691084,
  -1.17721559300676e-06,-0.00205859468493319,0.296175148723386,-0.721586764007992,
  -1.1824150104589e-06,-0.00192663177614127,0.30542936695535,-0.7500662033249,
  -1.18761442902127e-06,-0.00179466886735025,0.314683585187315,-0.778545642641808,
  -1.19281384669545e-06,-0.00166270595855789,0.323937803419281,-0.807025081958716,
  -7.0283698254292e-05,-0.010701056425712,0.131582598851909,-0.113678199740911,
  -7.54190551024159e-05,-0.0100290541223641,0.146948784494001,-0.137500626106234,
  -8.05544119503732e-05,-0.00935705181901603,0.162314970136092,-0.161323052471557,
  -8.56897687984692e-05,-0.00868504951566784,0.177681155778183,-0.18514547883688,
  -9.08251256466208e-05,-0.00801304721231988,0.193047341420274,-0.208967905202204,
  -9.59604824944948e-05,-0.00734104490897158,0.208413527062365,-0.232790331567527,
  -0.000101095839342424,-0.00666904260562329,0.223779712704456,-0.25661275793285,
  -0.000106231196190631,-0.00599704030227532,0.239145898346548,-0.280435184298173,
  -0.000111366553038783,-0.00532503799892758,0.254512083988638,-0.304257610663496,
  -0.000116501909886713,-0.00465303569557918,0.26987826963073,-0.32808003702882,
  -0.000121637266734698,-0.00398103339223121,0.285244455272821,-0.351902463394143,
  -0.000126772623582849,-0.00330903108888325,0.300610640914912,-0.375724889759466,
  -0.000131907980430834,-0.00263702878553507,0.315976826557003,-0.39954731612479,
  -0.000137043337278819,-0.0019650264821871,0.331343012199094,-0.423369742490113,
  -0.000142178694126582,-0.00129302417883848,0.346709197841186,-0.447192168855436,
  -0.000147314050975234,-0.000621021875491401,0.362075383483276,-0.47101459522076,
  -0.000152449407822886,5.09804278574499e-05,0.377441569125368,-0.494837021586083,
  -0.000157584764670871,0.000722982731205635,0.392807754767459,-0.518659447951406,
  -0.000162720121518634,0.00139498503455426,0.40817394040955,-0.542481874316729,
  -0.000167855478367285,0.00206698733790134,0.423540126051641,-0.566304300682053,
  -0.000172990835215159,0.00273898964124974,0.438906311693732,-0.590126727047376,
  -0.000178126192063366,0.00341099194459726,0.454272497335823,-0.613949153412699,
  -0.000183261548911129,0.00408299424794611,0.469638682977915,-0.637771579778022,
  -0.000188396905759003,0.00475499655129452,0.485004868620006,-0.661594006143345,
  -0.00019353226260721,0.00542699885464248,0.500371054262097,-0.685416432508669,
  -6.974458098577e-05,-0.0106358594249302,0.13141425677876,-0.113853306286322,
  -7.48092974050818e-05,-0.00996531066807438,0.146732136582974,-0.137710954815312,
  -7.98740138244769e-05,-0.00929476191121881,0.162050016387189,-0.161568603344303,
  -8.49387302438442e-05,-0.00862421315436301,0.177367896191403,-0.185426251873293,
  -9.00034466631006e-05,-0.00795366439750711,0.192685775995618,-0.209283900402283,
  -9.50681630824124e-05,-0.00728311564065121,0.208003655799832,-0.233141548931274,
  -0.000100132879501724,-0.00661256688379541,0.223321535604046,-0.256999197460264,
  -0.000105197595920981,-0.00594201812693962,0.238639415408261,-0.280856845989255,
  -0.000110262312340181,-0.00527146937008349,0.253957295212475,-0.304714494518245,
  -0.000115327028759826,-0.00460092061322825,0.26927517501669,-0.328572143047235,
  -0.000120391745179027,-0.00393037185637257,0.284593054820904,-0.352429791576226,
  -0.00012545646159845,-0.00325982309951689,0.299910934625118,-0.376287440105216,
  -0.000130521178017928,-0.00258927434266143,0.315228814429332,-0.400145088634206,
  -0.000135585894436963,-0.00191872558580508,0.330546694233547,-0.424002737163197,
  -0.000140650610856219,-0.0012481768289494,0.345864574037761,-0.447860385692187,
  -0.000145715327275697,-0.000577628072093717,0.361182453841976,-0.471718034221177,
  -0.000150780043694954,9.29206847621877e-05,0.37650033364619,-0.495575682750168,
  -0.000155844760114543,0.00076346944161787,0.391818213450405,-0.519433331279158,
  -0.000160909476534021,0.00143401819847311,0.407136093254619,-0.543290979808148,
  -0.000165974192952945,0.00210456695532946,0.422453973058833,-0.567148628337139,
  -0.000171038909372534,0.00277511571218492,0.437771852863048,-0.591006276866129,
  -0.00017610362579179,0.00344566446904082,0.453089732667262,-0.61486392539512,
  -0.000181168342211158,0.00411621322589673,0.468407612471477,-0.63872157392411,
  -0.000186233058630081,0.00478676198275263,0.483725492275691,-0.6625792224531,
  -0.000191297775049892,0.00545731073960765,0.499043372079905,-0.686436870982091,
  -6.90038965986128e-05,-0.0105468463361844,0.131182692667461,-0.114093437132613,
  -7.39722384737462e-05,-0.00987837748463394,0.14643418593165,-0.137999387271059,
  -7.89405803488519e-05,-0.00920990863308335,0.16168567919584,-0.161905337409505,
  -8.39089222240408e-05,-0.00854143978153299,0.17693717246003,-0.185811287547951,
  -8.88772640992297e-05,-0.00787297092998251,0.192188665724219,-0.209717237686397,
  -9.38456059744741e-05,-0.00720450207843215,0.207440158988409,-0.233623187824843,
  -9.88139478494965e-05,-0.00653603322688157,0.222691652252599,-0.257529137963289,
  -0.000103782289724741,-0.0058675643753312,0.237943145516789,-0.281435088101735,
  -0.000108750631599541,-0.00519909552377995,0.253194638780979,-0.30534103824018,
  -0.000113718973475063,-0.00453062667223025,0.268446132045168,-0.329246988378627,
  -0.000118687315350363,-0.00386215782068011,0.283697625309357,-0.353152938517072,
  -0.000123655657225052,-0.00319368896912864,0.298949118573548,-0.377058888655518,
  -0.000128623999100186,-0.00252522011757828,0.314200611837737,-0.400964838793964,
  -0.000133592340975541,-0.00185675126602791,0.329452105101927,-0.42487078893241,
  -0.000138560682850453,-0.00118828241447755,0.344703598366117,-0.448776739070856,
  -0.000143529024725475,-0.000519813562926519,0.359955091630307,-0.472682689209302,
  -0.000148497366600941,0.000148655288623178,0.375206584894496,-0.496588639347748,
  -0.000153465708475631,0.000817124140174652,0.390458078158686,-0.520494589486194,
  -0.00015843405035143,0.00148559299172391,0.405709571422875,-0.54440053962464,
  -0.000163402392226009,0.00215406184327582,0.420961064687066,-0.568306489763086,
  -0.000168370734101697,0.00282253069482508,0.436212557951255,-0.592212439901532,
  -0.000173339075976831,0.00349099954637566,0.451464051215445,-0.616118390039978,
  -0.000178307417851631,0.00415946839792625,0.466715544479634,-0.640024340178424,
  -0.000183275759727097,0.00482793724947639,0.481967037743824,-0.66393029031687,
  -0.00018824410160212,0.00549640610102786,0.497218531008015,-0.687836240455316,
  -6.79933548632383e-05,-0.0104264414366823,0.130866238235245,-0.114420231454212,
  -7.28314784274042e-05,-0.00976096412066174,0.146027120756868,-0.138391915303833,
  -7.76696019917367e-05,-0.00909548680464123,0.161188003278491,-0.162363599153453,
  -8.25077255560136e-05,-0.00843000948862083,0.176348885800115,-0.186335283003074,
  -8.73458491201795e-05,-0.00776453217260031,0.191509768321738,-0.210306966852694,
  -9.2183972684512e-05,-0.00709905485657991,0.206670650843361,-0.234278650702315,
  -9.70220962485113e-05,-0.00643357754055895,0.221831533364985,-0.258250334551935,
  -0.000101860219812455,-0.00576810022453822,0.236992415886608,-0.282222018401556,
  -0.000106698343377232,-0.00510262290851826,0.252153298408232,-0.306193702251176,
  -0.000111536466941176,-0.00443714559249719,0.267314180929855,-0.330165386100797,
  -0.000116374590505619,-0.00377166827647701,0.282475063451478,-0.354137069950417,
  -0.000121212714069729,-0.00310619096045683,0.297635945973101,-0.378108753800038,
  -0.000126050837634173,-0.00244071364443643,0.312796828494725,-0.402080437649658,
  -0.000130888961198394,-0.00177523632841603,0.327957711016348,-0.426052121499279,
  -0.000135727084762283,-0.00110975901239496,0.343118593537972,-0.450023805348899,
  -0.000140565208326726,-0.000444281696374782,0.358279476059595,-0.47399548919852,
  -0.00014540333189117,0.000221195619645842,0.373440358581218,-0.49796717304814,
  -0.000150241455454836,0.00088667293566691,0.388601241102842,-0.521938856897761,
  -0.000155079579019279,0.00155215025168709,0.403762123624465,-0.545910540747381,
  -0.000159917702584167,0.00221762756770705,0.418923006146088,-0.569882224597001,
  -0.000164755826147722,0.00288310488372812,0.434083888667712,-0.593853908446622,
  -0.000169593949711833,0.00354858219974918,0.449244771189335,-0.617825592296242,
  -0.000174432073275721,0.00421405951576981,0.464405653710959,-0.641797276145863,
  -0.000179270196840164,0.00487953683178999,0.479566536232582,-0.665768959995483,
  -0.000184108320405385,0.00554501414780928,0.494727418754205,-0.689740643845104,
  -6.66276904059682e-05,-0.0102656124561046,0.130437622391132,-0.114860371003274,
  -7.12921731370331e-05,-0.00960445780326635,0.145475983522797,-0.138920587621312,
  -7.59566558684033e-05,-0.00894330315042857,0.160514344654462,-0.162980804239351,
  -8.06211385996902e-05,-0.00828214849759057,0.175552705786127,-0.18704102085739,
  -8.52856213309217e-05,-0.00762099384475246,0.190591066917792,-0.211101237475428,
  -8.99501040623196e-05,-0.00695983919191467,0.205629428049457,-0.235161454093467,
  -9.46145867933845e-05,-0.00629868453907645,0.220667789181123,-0.259221670711505,
  -9.92790695242274e-05,-0.00563752988623789,0.235706150312788,-0.283281887329544,
  -0.000103943552255625,-0.0049763752334,0.250744511444453,-0.307342103947582,
  -0.000108608034987245,-0.00431522058056255,0.265782872576118,-0.331402320565621,
  -0.000113272517718366,-0.00365406592772421,0.280821233707783,-0.35546253718366,
  -0.000117937000449819,-0.00299291127488654,0.295859594839448,-0.379522753801698,
  -0.000122601483180551,-0.00233175662204821,0.310897955971113,-0.403582970419737,
  -0.000127265965912282,-0.00167060196921076,0.325936317102778,-0.427643187037775,
  -0.000131930448643458,-0.0010094473163722,0.340974678234444,-0.451703403655814,
  -0.000136594931374523,-0.000348292663534089,0.356013039366109,-0.475763620273853,
  -0.00014125941410581,0.000312861989303359,0.371051400497773,-0.499823836891891,
  -0.00014592389683743,0.000974016642141251,0.386089761629439,-0.52388405350993,
  -0.000150588379568162,0.00163517129498025,0.401128122761104,-0.547944270127968,
  -0.00015525286229956,0.00229632594781792,0.416166483892769,-0.572004486746007,
  -0.000159917345030403,0.00295748060065604,0.431204845024434,-0.596064703364045,
  -0.000164581827761578,0.0036186352534946,0.4462432061561,-0.620124919982084,
  -0.000169246310493087,0.00427978990633227,0.461281567287765,-0.644185136600123,
  -0.00017391079322393,0.00494094455917082,0.47631992841943,-0.668245353218161,
  -0.000178575275956216,0.00560209921200761,0.491358289551095,-0.6923055698362,
  -6.48056721373191e-05,-0.0100543813491858,0.129864086951448,-0.115444948418722,
  -6.92427046365407e-05,-0.00939948934531509,0.144738862039717,-0.139622751054774,
  -7.36797371359565e-05,-0.00874459734144473,0.159613637127985,-0.163800553690826,
  -7.81167696349838e-05,-0.0080897053375738,0.174488412216254,-0.187978356326877,
  -8.25538021343997e-05,-0.00743481333370333,0.189363187304522,-0.212156158962929,
  -8.69908346334269e-05,-0.00677992132983252,0.204237962392791,-0.236333961598981,
  -9.14278671325097e-05,-0.0061250293259616,0.219112737481059,-0.260511764235033,
  -9.58648996318701e-05,-0.00547013732209112,0.233987512569328,-0.284689566871085,
  -0.000100301932131119,-0.00481524531822042,0.248862287657596,-0.308867369507137,
  -0.000104738964630258,-0.00416035331434972,0.263737062745865,-0.333045172143189,
  -0.000109175997129507,-0.00350546131047902,0.278611837834134,-0.35722297477924,
  -0.000113613029628867,-0.00285056930660854,0.293486612922402,-0.381400777415292,
  -0.000118050062128283,-0.00219567730273829,0.30836138801067,-0.405578580051344,
  -0.000122487094627366,-0.00154078529886692,0.32323616309894,-0.429756382687396,
  -0.000126924127126449,-0.000885893294996887,0.338110938187207,-0.453934185323448,
  -0.000131361159625532,-0.000231001291125299,0.352985713275477,-0.4781119879595,
  -0.000135798192124725,0.000423890712745179,0.367860488363745,-0.502289790595551,
  -0.000140235224623919,0.0010787827166161,0.382735263452014,-0.526467593231604,
  -0.000144672257123224,0.0017336747204868,0.397610038540282,-0.550645395867655,
  -0.000149109289622196,0.00238856672435706,0.41248481362855,-0.574823198503707,
  -0.000153546322121834,0.00304345872822775,0.427359588716819,-0.599001001139759,
  -0.000157983354621138,0.00369835073209801,0.442234363805087,-0.623178803775811,
  -0.000162420387120443,0.00435324273596871,0.457109138893356,-0.647356606411863,
  -0.00016685741961997,0.00500813473983897,0.471983913981624,-0.671534409047915,
  -0.000171294452118498,0.005663026743711,0.486858689069894,-0.695712211683967,
  -6.24161043309979e-05,-0.00978305435470772,0.129108997826724,-0.116207128616983,
  -6.65622104957797e-05,-0.00913722239051584,0.143769017645452,-0.140538241545485,
  -7.0708316660506e-05,-0.00849139042632396,0.15842903746418,-0.164869354473987,
  -7.48544228252879e-05,-0.00784555846213197,0.173089057282909,-0.189200467402489,
  -7.90005289902362e-05,-0.00719972649794032,0.187749077101637,-0.213531580330991,
  -8.31466351550736e-05,-0.00655389453374877,0.202409096920365,-0.237862693259493,
  -8.72927413196334e-05,-0.00590806256955678,0.217069116739093,-0.262193806187995,
  -9.14388474844152e-05,-0.00526223060536468,0.231729136557821,-0.286524919116497,
  -9.55849536494191e-05,-0.00461639864117314,0.24638915637655,-0.310856032044999,
  -9.97310598142565e-05,-0.00397056667698092,0.261049176195278,-0.335187144973501,
  -0.000103877165978983,-0.00332473471278938,0.275709196014006,-0.359518257902003,
  -0.000108023272143987,-0.00267890274859783,0.290369215832734,-0.383849370830505,
  -0.000112169378308713,-0.00203307078440607,0.305029235651462,-0.408180483759007,
  -0.000116315484473328,-0.00138723882021408,0.31968925547019,-0.432511596687509,
  -0.000120461590638166,-0.000741406856022087,0.334349275288919,-0.456842709616011,
  -0.000124607696803225,-9.55748918307631e-05,0.349009295107647,-0.481173822544513,
  -0.00012875380296784,0.000550257072361449,0.363669314926375,-0.505504935473015,
  -0.000132899909132567,0.00119608903655366,0.378329334745104,-0.529836048401517,
  -0.000137046015297848,0.00184192100074432,0.392989354563831,-0.554167161330019,
  -0.00014119212146213,0.00248775296493697,0.40764937438256,-0.578498274258522,
  -0.000145338227627079,0.00313358492912874,0.422309394201288,-0.602829387187023,
  -0.000149484333792138,0.00377941689332006,0.436969414020016,-0.627160500115526,
  -0.000153630439957309,0.00442524885751139,0.451629433838744,-0.651491613044027,
  -0.000157776546122146,0.00507108082170316,0.466289453657472,-0.67582272597253,
  -0.000161922652286539,0.00571691278589626,0.480949473476201,-0.700153838901032,
  -5.93517939788124e-05,-0.00944439753518178,0.128135943825456,-0.117177247569262,
  -6.31372292670129e-05,-0.00881156468885913,0.142520212767342,-0.141703497055529,
  -6.692266455538e-05,-0.00817873184253648,0.156904481709227,-0.166229746541796,
  -7.07080998436083e-05,-0.00754589899621405,0.171288750651113,-0.190755996028063,
  -7.44935351320586e-05,-0.00691306614989151,0.185673019592998,-0.215282245514331,
  -7.82789704202869e-05,-0.00628023330356875,0.200057288534884,-0.239808495000598,
  -8.20644057086817e-05,-0.00564740045724643,0.214441557476769,-0.264334744486865,
  -8.584984099691e-05,-0.00501456761092367,0.228825826418655,-0.288860993973132,
  -8.96352762851382e-05,-0.00438173476460091,0.243210095360541,-0.313387243459399,
  -9.34207115736441e-05,-0.00374890191827881,0.257594364302426,-0.337913492945666,
  -9.72061468619834e-05,-0.00311606907195605,0.271978633244312,-0.362439742431933,
  -0.000100991582150489,-0.00248323622563396,0.286362902186197,-0.386965991918201,
  -0.000104777017438384,-0.00185040337931053,0.300747171128083,-0.411492241404468,
  -0.000108562452727168,-0.00121757053298865,0.315131440069968,-0.436018490890735,
  -0.000112347888015285,-0.000584737686665671,0.329515709011854,-0.460544740377002,
  -0.000116133323303735,4.80951596568691e-05,0.34389997795374,-0.485070989863269,
  -0.000119918758591964,0.000680928005979187,0.358284246895625,-0.509597239349536,
  -0.000123704193880414,0.00131376085230173,0.372668515837511,-0.534123488835803,
  -0.00012748962916842,0.00194659369862449,0.387052784779396,-0.55864973832207,
  -0.000131275064456982,0.00257942654494681,0.401437053721282,-0.583175987808338,
  -0.000135060499745321,0.00321225939126935,0.415821322663167,-0.607702237294604,
  -0.000138845935033549,0.00384509223759233,0.430205591605053,-0.632228486780872,
  -0.000142631370321888,0.00447792508391487,0.444589860546938,-0.656754736267139,
  -0.000146416805610117,0.00511075793023696,0.458974129488824,-0.681280985753406,
  -0.000150202240898789,0.00574359077655906,0.473358398430709,-0.705807235239673,
  -5.55336637548809e-05,-0.00903667762364446,0.126916173561392,-0.118374916019083,
  -5.88895474387674e-05,-0.00842216465480727,0.140956295096243,-0.143142072971484,
  -6.22454311227094e-05,-0.00780765168597031,0.154996416631094,-0.167909229923885,
  -6.56013148067625e-05,-0.00719313871713345,0.169036538165945,-0.192676386876286,
  -6.8957198490649e-05,-0.00657862574829626,0.183076659700796,-0.217443543828687,
  -7.23130821745355e-05,-0.00596411277945952,0.197116781235647,-0.242210700781088,
  -7.56689658584775e-05,-0.00534959981062233,0.211156902770499,-0.266977857733489,
  -7.90248495423085e-05,-0.00473508684178525,0.22519702430535,-0.29174501468589,
  -8.2380733226306e-05,-0.00412057387294817,0.239237145840201,-0.31651217163829,
  -8.5736616910137e-05,-0.0035060609041111,0.253277267375052,-0.341279328590691,
  -8.90925005940235e-05,-0.0028915479352738,0.267317388909903,-0.366046485543092,
  -9.24483842782431e-05,-0.00227703496643761,0.281357510444754,-0.390813642495493,
  -9.58042679619631e-05,-0.00166252199760053,0.295397631979605,-0.415580799447894,
  -9.91601516459051e-05,-0.00104800902876301,0.309437753514457,-0.440347956400295,
  -0.000102516035329958,-0.000433496059926153,0.323477875049308,-0.465115113352696,
  -0.000105871919013789,0.000181016908910703,0.337517996584159,-0.489882270305097,
  -0.000109227802697842,0.00079552987774778,0.35155811811901,-0.514649427257498,
  -0.000112583686382117,0.00141004284658441,0.365598239653861,-0.539416584209899,
  -0.000115939570065615,0.00202455581542171,0.379638361188712,-0.5641837411623,
  -0.00011929545374989,0.00263906878425901,0.393678482723564,-0.5889508981147,
  -0.000122651337433832,0.00325358175309542,0.407718604258414,-0.613718055067102,
  -0.000126007221117441,0.00386809472193317,0.421758725793266,-0.638485212019502,
  -0.000129363104801827,0.00448260769076914,0.435798847328116,-0.663252368971903,
  -0.000132718988485436,0.00509712065960732,0.449838968862968,-0.688019525924304,
  -0.000136074872169378,0.00571163362844374,0.463879090397819,-0.712786682876705,
  -5.09436093744098e-05,-0.00856684132877095,0.125439218184938,-0.119799017709532,
  -5.38129069865834e-05,-0.00797738717200214,0.139064782083119,-0.144852628504658,
  -5.66822045991455e-05,-0.00738793301523377,0.152690345981301,-0.169906239299785,
  -5.95515022115412e-05,-0.00679847885846518,0.166315909879482,-0.194959850094912,
  -6.24207998238813e-05,-0.0062090247016966,0.179941473777664,-0.220013460890039,
  -6.52900974362769e-05,-0.0056195705449279,0.193567037675845,-0.245067071685166,
  -6.81593950485615e-05,-0.0050301163881592,0.207192601574027,-0.270120682480292,
  -7.10286926610681e-05,-0.00444066223139084,0.220818165472208,-0.295174293275419,
  -7.38979902731862e-05,-0.0038512080746218,0.23444372937039,-0.320227904070546,
  -7.67672878857484e-05,-0.00326175391785366,0.248069293268571,-0.345281514865673,
  -7.96365854983105e-05,-0.00267229976108507,0.261694857166753,-0.370335125660799,
  -8.25058831107617e-05,-0.00208284560431671,0.275320421064934,-0.395388736455926,
  -8.53751807230463e-05,-0.00149339144754768,0.288945984963116,-0.420442347251053,
  -8.8244478335775e-05,-0.000903937290779755,0.302571548861297,-0.44549595804618,
  -9.11137759475045e-05,-0.000314483134010279,0.316197112759479,-0.470549568841306,
  -9.39830735600111e-05,0.000274971022758086,0.32982267665766,-0.495603179636433,
  -9.68523711722957e-05,0.000864425179527117,0.343448240555842,-0.52065679043156,
  -9.97216687849134e-05,0.00145387933629504,0.357073804454023,-0.545710401226687,
  -0.000102590966397198,0.00204333349306363,0.370699368352205,-0.570764012021814,
  -0.000105460264009705,0.00263278764983221,0.384324932250386,-0.59581762281694,
  -0.000108329561621989,0.00322224180660102,0.397950496148568,-0.620871233612067,
  -0.000111198859234385,0.00381169596336983,0.41157606004675,-0.645924844407194,
  -0.000114068156847225,0.00440115012013775,0.425201623944931,-0.670978455202321,
  -0.000116937454459176,0.00499060427690656,0.438827187843112,-0.696032065997447,
  -0.000119806752071905,0.00558005843367493,0.452452751741294,-0.721085676792574,
  -4.56577545911163e-05,-0.00805233202422462,0.123724364207198,-0.121418673593989,
  -4.80081934708387e-05,-0.00749571544070993,0.13687138683906,-0.146798073379543,
  -5.03586323506999e-05,-0.00693909885719535,0.150018409470922,-0.172177473165096,
  -5.27090712304501e-05,-0.00638248227368088,0.163165432102784,-0.19755687295065,
  -5.50595101101448e-05,-0.00582586569016597,0.176312454734646,-0.222936272736204,
  -5.7409948990117e-05,-0.0052692491066515,0.189459477366507,-0.248315672521757,
  -5.97603878697561e-05,-0.00471263252313681,0.202606499998369,-0.273695072307311,
  -6.21108267498949e-05,-0.00415601593962278,0.215753522630231,-0.299074472092865,
  -6.44612656295895e-05,-0.00359939935610809,0.228900545262093,-0.324453871878418,
  -6.68117045091732e-05,-0.00304278277259296,0.242047567893955,-0.349833271663972,
  -6.91621433889233e-05,-0.00248616618907849,0.255194590525816,-0.375212671449525,
  -7.15125822687845e-05,-0.00192954960556424,0.268341613157678,-0.400592071235079,
  -7.38630211487568e-05,-0.00137293302204955,0.28148863578954,-0.425971471020633,
  -7.62134600283959e-05,-0.000816316438534637,0.294635658421402,-0.451350870806186,
  -7.85638989085902e-05,-0.000259699855020612,0.307782681053263,-0.47673027059174,
  -8.09143377878963e-05,0.000296916728494745,0.320929703685126,-0.502109670377294,
  -8.32647766675354e-05,0.000853533312009436,0.334076726316987,-0.527489070162847,
  -8.56152155473966e-05,0.00141014989552346,0.347223748948849,-0.552868469948401,
  -8.79656544272578e-05,0.00196676647903837,0.360370771580711,-0.578247869733954,
  -9.0316093307341e-05,0.0025233830625524,0.373517794212572,-0.603627269519508,
  -9.26665321868692e-05,0.00307999964606731,0.386664816844434,-0.629006669305062,
  -9.50169710671744e-05,0.00363661622958222,0.399811839476297,-0.654386069090615,
  -9.73674099468136e-05,0.00419323281309669,0.412958862108158,-0.679765468876169,
  -9.97178488257866e-05,0.00474984939661205,0.42610588474002,-0.705144868661722,
  -0.000102068287705981,0.00530646598012652,0.439252907371882,-0.730524268447276,
  -3.98642425261941e-05,-0.00751983369950515,0.121827962154871,-0.123170110142105,
  -4.16988114729511e-05,-0.00700393910405428,0.134449055234155,-0.14890180620879,
  -4.35333804199578e-05,-0.00648804450860363,0.147070148313438,-0.174633502275476,
  -4.53679493667702e-05,-0.00597214991315298,0.159691241392722,-0.200365198342161,
  -4.72025183136937e-05,-0.00545625531770222,0.172312334472005,-0.226096894408846,
  -4.90370872608392e-05,-0.00494036072225201,0.184933427551288,-0.251828590475532,
  -5.08716562076517e-05,-0.00442446612680114,0.197554520630572,-0.277560286542217,
  -5.27062251546306e-05,-0.00390857153135049,0.210175613709855,-0.303291982608902,
  -5.45407941014986e-05,-0.00339267693589984,0.222796706789139,-0.329023678675588,
  -5.63753630486996e-05,-0.00287678234044941,0.235417799868422,-0.354755374742273,
  -5.82099319949014e-05,-0.0023608877449981,0.248038892947705,-0.380487070808958,
  -6.00445009424355e-05,-0.00184499314954811,0.260659986026989,-0.406218766875644,
  -6.18790698894145e-05,-0.00132909855409769,0.273281079106272,-0.431950462942329,
  -6.37136388359494e-05,-0.000813203958646369,0.285902172185556,-0.457682159009014,
  -6.55482077830394e-05,-0.000297309363195719,0.298523265264839,-0.4834138550757,
  -6.73827767299073e-05,0.000218585232255153,0.311144358344123,-0.509145551142385,
  -6.92173456765532e-05,0.000734479827706025,0.323765451423406,-0.53487724720907,
  -7.10519146235322e-05,0.00125037442315645,0.33638654450269,-0.560608943275756,
  -7.28864835708443e-05,0.00176626901860644,0.349007637581973,-0.586340639342441,
  -7.47210525179343e-05,0.00228216361405664,0.361628730661256,-0.612072335409126,
  -7.65556214641361e-05,0.00279805820950862,0.37424982374054,-0.637804031475811,
  -7.83901904113371e-05,0.00331395280495883,0.386870916819823,-0.663535727542497,
  -8.0224759357983e-05,0.00382984740040948,0.399492009899106,-0.689267423609182,
  -8.2059328304851e-05,0.00434574199586057,0.41211310297839,-0.714999119675867,
  -8.38938972518299e-05,0.00486163659131122,0.424734196057674,-0.740730815742553,
  -3.38488750320498e-05,-0.00700035280528066,0.119840674312775,-0.124963691076466,
  -3.5208687984567e-05,-0.00653179367099987,0.13191407999209,-0.151056160642918,
  -3.65685009369177e-05,-0.00606323453671886,0.143987485671406,-0.177148630209371,
  -3.79283138893238e-05,-0.00559467540243797,0.156060891350721,-0.203241099775823,
  -3.92881268418965e-05,-0.00512611626815707,0.168134297030036,-0.229333569342276,
  -4.06479397943027e-05,-0.00465755713387617,0.180207702709352,-0.255426038908728,
  -4.20077527468199e-05,-0.00418899799959549,0.192281108388667,-0.281518508475181,
  -4.33675656990595e-05,-0.00372043886531404,0.204354514067983,-0.307610978041633,
  -4.47273786516877e-05,-0.00325187973103369,0.216427919747298,-0.333703447608086,
  -4.60871916042049e-05,-0.00278332059675268,0.228501325426613,-0.359795917174538,
  -4.74470045566666e-05,-0.00231476146247189,0.240574731105929,-0.385888386740991,
  -4.88068175088507e-05,-0.00184620232819088,0.252648136785244,-0.411980856307443,
  -5.01666304619786e-05,-0.00137764319391054,0.264721542464559,-0.438073325873896,
  -5.15264434139961e-05,-0.00090908405962975,0.276794948143874,-0.464165795440348,
  -5.28862563664578e-05,-0.000440524925348296,0.28886835382319,-0.490258265006801,
  -5.42460693191416e-05,2.80342089320484e-05,0.300941759502505,-0.516350734573253,
  -5.56058822713812e-05,0.000496593343213725,0.313015165181821,-0.542443204139705,
  -5.69656952237318e-05,0.000965152477494291,0.325088570861136,-0.568535673706158,
  -5.83255081765266e-05,0.00143371161177441,0.337161976540451,-0.594628143272611,
  -5.96853211287662e-05,0.00190227074605609,0.349235382219767,-0.620720612839063,
  -6.10451340810059e-05,0.00237082988033732,0.361308787899083,-0.646813082405516,
  -6.24049470336896e-05,0.00283938901461767,0.373382193578398,-0.672905551971968,
  -6.37647599857072e-05,0.00330794814889934,0.385455599257713,-0.69899802153842,
  -6.51245729381689e-05,0.00377650728318013,0.397529004937029,-0.725090491104873,
  -6.64843858908526e-05,0.00424506641746092,0.409602410616344,-0.751182960671325,
  -2.79442657529771e-05,-0.00652223857923007,0.117872205432874,-0.126700888047118,
  -2.89011271974171e-05,-0.00610498108625279,0.129406360135984,-0.153142789645814,
  -2.98579886420236e-05,-0.00568772359327585,0.140940514839095,-0.179584691244511,
  -3.08148500869354e-05,-0.00527046610029913,0.152474669542205,-0.206026592843207,
  -3.17717115314586e-05,-0.00485320860732186,0.164008824245316,-0.232468494441903,
  -3.27285729762039e-05,-0.00443595111434514,0.175542978948426,-0.258910396040599,
  -3.36854344210602e-05,-0.00401869362136842,0.187077133651536,-0.285352297639295,
  -3.46422958656389e-05,-0.00360143612839137,0.198611288354647,-0.311794199237991,
  -3.55991573102177e-05,-0.00318417863541431,0.210145443057757,-0.338236100836688,
  -3.65560187545744e-05,-0.00276692114243682,0.221679597760868,-0.364678002435384,
  -3.75128801993752e-05,-0.00234966364946021,0.233213752463978,-0.39111990403408,
  -3.84697416441204e-05,-0.00193240615648338,0.244747907167089,-0.417561805632776,
  -3.94266030888657e-05,-0.00151514866350633,0.256282061870199,-0.444003707231472,
  -4.03834645334999e-05,-0.00109789117052905,0.26781621657331,-0.470445608830168,
  -4.13403259781342e-05,-0.000680633677552667,0.27935037127642,-0.496887510428865,
  -4.22971874232125e-05,-0.000263376184575614,0.290884525979531,-0.523329412027561,
  -4.32540488672917e-05,0.000153881308401882,0.302418680682641,-0.549771313626257,
  -4.4210910312481e-05,0.000571138801378268,0.313952835385752,-0.576213215224953,
  -4.51677717566712e-05,0.000988396294355542,0.325486990088862,-0.602655116823649,
  -4.61246332010834e-05,0.00140565378733282,0.337021144791973,-0.629097018422346,
  -4.70814946462728e-05,0.0018229112803092,0.348555299495083,-0.655538920021042,
  -4.8038356090907e-05,0.00224016877328603,0.360089454198193,-0.681980821619738,
  -4.89952175354302e-05,0.00265742626626331,0.371623608901304,-0.708422723218434,
  -4.99520789802865e-05,0.00307468375924014,0.383157763604414,-0.73486462481713,
  -5.09089404246987e-05,0.00349194125221786,0.394691918307525,-0.761306526415827,
  -2.24592565011283e-05,-0.00610527692785379,0.116028072975099,-0.128295001417611,
  -2.3100440174062e-05,-0.00573983429560132,0.127059789399198,-0.155057554205601,
  -2.37416238467736e-05,-0.0053743916633483,0.138091505823298,-0.181820106993591,
  -2.43828075195407e-05,-0.00500894903109528,0.149123222247398,-0.208582659781582,
  -2.50239911924188e-05,-0.00464350639884259,0.160154938671497,-0.235345212569572,
  -2.5665174865297e-05,-0.0042780637665899,0.171186655095597,-0.262107765357563,
  -2.63063585380641e-05,-0.00391262113433699,0.182218371519697,-0.288870318145553,
  -2.69475422106091e-05,-0.00354717850208375,0.193250087943797,-0.315632870933544,
  -2.75887258834318e-05,-0.00318173586983117,0.204281804367896,-0.342395423721534,
  -2.82299095563654e-05,-0.00281629323757815,0.215313520791996,-0.369157976509524,
  -2.8871093229188e-05,-0.00245085060532579,0.226345237216095,-0.395920529297515,
  -2.95122769018441e-05,-0.00208540797307255,0.237376953640195,-0.422683082085505,
  -3.01534605749998e-05,-0.0017199653408202,0.248408670064294,-0.449445634873496,
  -3.07946442472673e-05,-0.00135452270856651,0.259440386488395,-0.476208187661486,
  -3.1435827920423e-05,-0.000989080076313931,0.270472102912494,-0.502970740449476,
  -3.20770115933566e-05,-0.000623637444061798,0.281503819336593,-0.529733293237467,
  -3.27181952659572e-05,-0.000258194811808332,0.292535535760693,-0.556495846025457,
  -3.33593789390019e-05,0.000107247820443801,0.303567252184793,-0.583258398813448,
  -3.40005626117135e-05,0.0004726904526966,0.314598968608892,-0.610020951601438,
  -3.4641746284314e-05,0.00083813308495051,0.325630685032993,-0.636783504389428,
  -3.52829299572477e-05,0.00120357571720264,0.336662401457092,-0.663546057177419,
  -3.59241136304034e-05,0.00156901834945522,0.347694117881191,-0.690308609965409,
  -3.65652973028929e-05,0.00193446098170824,0.358725834305291,-0.7170711627534,
  -3.72064809761596e-05,0.00229990361396037,0.36975755072939,-0.74383371554139,
  -3.78476646492043e-05,0.00266534624621295,0.38078926715349,-0.770596268329381,
  -1.76185693750164e-05,-0.00575830935917143,0.114388256464148,-0.129686928029868,
  -1.80302668530696e-05,-0.00544183030858969,0.124975310299501,-0.156729462738776,
  -1.84419643305955e-05,-0.00512535125800728,0.135562364134854,-0.183771997447684,
  -1.88536618085378e-05,-0.00480887220742543,0.146149417970207,-0.210814532156592,
  -1.92653592862579e-05,-0.00449239315684313,0.15673647180556,-0.2378570668655,
  -1.96770567640892e-05,-0.00417591410626117,0.167323525640913,-0.264899601574408,
  -2.00887542417538e-05,-0.00385943505567909,0.177910579476266,-0.291942136283316,
  -2.0500451719474e-05,-0.00354295600509702,0.188497633311619,-0.318984670992224,
  -2.09121491975273e-05,-0.00322647695451517,0.199084687146972,-0.346027205701132,
  -2.13238466753585e-05,-0.00290999790393309,0.209671740982325,-0.37306974041004,
  -2.17355441529121e-05,-0.0025935188533508,0.220258794817679,-0.400112275118947,
  -2.21472416310764e-05,-0.00227703980276939,0.230845848653031,-0.427154809827856,
  -2.25589391089631e-05,-0.00196056075218709,0.241432902488385,-0.454197344536763,
  -2.29706365868498e-05,-0.00164408170160546,0.252019956323738,-0.481239879245671,
  -2.33823340642925e-05,-0.00132760265102294,0.262607010159091,-0.508282413954579,
  -2.37940315421792e-05,-0.00101112360044087,0.273194063994444,-0.535324948663487,
  -2.42057290202879e-05,-0.000694644549859236,0.283781117829797,-0.562367483372395,
  -2.46174264979526e-05,-0.000378165499276939,0.29436817166515,-0.589410018081303,
  -2.50291239757283e-05,-6.16864486948643e-05,0.304955225500503,-0.616452552790211,
  -2.5440821453504e-05,0.00025479260188721,0.315542279335856,-0.643495087499119,
  -2.58525189312797e-05,0.000571271652469285,0.326129333171209,-0.670537622208027,
  -2.62642164092775e-05,0.000887750703050916,0.336716387006562,-0.697580156916935,
  -2.66759138870531e-05,0.00120422975363343,0.347303440841916,-0.724622691625842,
  -2.70876113644958e-05,0.00152070880421595,0.357890494677269,-0.75166522633475,
  -2.74993088424935e-05,0.00183718785479758,0.368477548512622,-0.778707761043658,
  -1.35356444470602e-05,-0.00548053117374969,0.112996219523963,-0.130850566397133,
  -1.379112801983e-05,-0.00520765459392381,0.123207282120401,-0.158127163521725,
  -1.40466115924887e-05,-0.00493477801409814,0.133418344716838,-0.185403760646317,
  -1.43020951651751e-05,-0.00466190143427248,0.143629407313276,-0.212680357770909,
  -1.45575787380281e-05,-0.0043890248544467,0.153840469909714,-0.239956954895501,
  -1.4813062310659e-05,-0.0041161482746207,0.164051532506152,-0.267233552020093,
  -1.50685458835675e-05,-0.00384327169479537,0.17426259510259,-0.294510149144685,
  -1.53240294563095e-05,-0.0035703951149697,0.184473657699027,-0.321786746269277,
  -1.55795130290515e-05,-0.00329751853514404,0.194684720295465,-0.349063343393869,
  -1.58349966017934e-05,-0.00302464195531815,0.204895782891903,-0.376339940518461,
  -1.60904801742578e-05,-0.00275176537549227,0.215106845488341,-0.403616537643053,
  -1.63459637469998e-05,-0.0024788887956666,0.225317908084778,-0.430893134767645,
  -1.66014473197418e-05,-0.00220601221584094,0.235528970681216,-0.458169731892237,
  -1.68569308922617e-05,-0.0019331356360146,0.245740033277654,-0.485446329016829,
  -1.71124144652257e-05,-0.00166025905618916,0.255951095874092,-0.512722926141421,
  -1.73678980380787e-05,-0.00138738247636394,0.266162158470529,-0.539999523266013,
  -1.76233816108207e-05,-0.00111450589653783,0.276373221066967,-0.567276120390605,
  -1.78788651831185e-05,-0.000841629316711723,0.286584283663405,-0.594552717515197,
  -1.81343487561936e-05,-0.000568752736886502,0.296795346259843,-0.621829314639789,
  -1.83898323284915e-05,-0.000295876157060171,0.307006408856281,-0.649105911764381,
  -1.86453159012334e-05,-2.2999577234728e-05,0.317217471452719,-0.676382508888973,
  -1.89007994746415e-05,0.000249877002590271,0.327428534049156,-0.703659106013565,
  -1.91562830463843e-05,0.00052275358241749,0.337639596645594,-0.730935703138157,
  -1.94117666195703e-05,0.000795630162242489,0.347850659242032,-0.758212300262749,
  -1.96672501920903e-05,0.00106850674206882,0.35806172183847,-0.785488897387341,
  -1.02210907211298e-05,-0.00526479979132233,0.111860171746584,-0.131788490061392,
  -1.03758516132035e-05,-0.00502884141754323,0.121765353500718,-0.159253747756793,
  -1.05306125047777e-05,-0.00479288304376324,0.131670535254852,-0.186719005452195,
  -1.06853733966572e-05,-0.00455692466998392,0.141575717008986,-0.214184263147596,
  -1.08401342883702e-05,-0.00432096629620426,0.15148089876312,-0.241649520842997,
  -1.09948951803052e-05,-0.00408500792242505,0.161386080517254,-0.269114778538399,
  -1.11496560720736e-05,-0.0038490495486454,0.171291262271389,-0.2965800362338,
  -1.13044169638421e-05,-0.00361309117486552,0.181196444025523,-0.324045293929201,
  -1.14591778557216e-05,-0.00337713280108631,0.191101625779657,-0.351510551624603,
  -1.16139387474901e-05,-0.0031411744273071,0.201006807533791,-0.378975809320004,
  -1.17686996394806e-05,-0.00290521605352767,0.210911989287925,-0.406441067015405,
  -1.19234605313601e-05,-0.00266925767974802,0.22081717104206,-0.433906324710807,
  -1.20782214225734e-05,-0.00243329930596792,0.230722352796194,-0.461371582406208,
  -1.22329823145639e-05,-0.00219734093218849,0.240627534550328,-0.488836840101609,
  -1.23877432067765e-05,-0.00196138255840927,0.250532716304462,-0.516302097797011,
  -1.25425040981009e-05,-0.00172542418462962,0.260437898058596,-0.543767355492412,
  -1.26972649903134e-05,-0.00148946581085019,0.270343079812731,-0.571232613187813,
  -1.28520258819709e-05,-0.00125350743707053,0.280248261566865,-0.598697870883215,
  -1.30067867732953e-05,-0.00101754906329088,0.290153443320999,-0.626163128578616,
  -1.31615476660629e-05,-0.000781590689512335,0.300058625075133,-0.653628386274017,
  -1.33163085576093e-05,-0.000545632315732902,0.309963806829266,-0.681093643969419,
  -1.34710694490447e-05,-0.000309673941952582,0.319868988583401,-0.70855890166482,
  -1.36258303411463e-05,-7.37155681727053e-05,0.329774170337536,-0.736024159360221,
  -1.37805912330258e-05,0.000162242805606283,0.33967935209167,-0.763489417055623,
  -1.39353521244612e-05,0.000398201179385715,0.349584533845804,-0.790954674751024,
  -7.61269064772363e-06,-0.00510106851568781,0.110962392421196,-0.132522487820334,
  -7.70515579273656e-06,-0.00489510769763823,0.120626441929424,-0.160135386993876,
  -7.79762093761072e-06,-0.00468914687958821,0.130290491437652,-0.187748286167419,
  -7.8900860826514e-06,-0.00448318606153864,0.13995454094588,-0.215361185340961,
  -7.98255122769209e-06,-0.00427722524348906,0.149618590454108,-0.242974084514503,
  -8.07501637256625e-06,-0.00407126442543915,0.159282639962336,-0.270586983688046,
  -8.16748151727387e-06,-0.00386530360738924,0.168946689470564,-0.298199882861588,
  -8.25994666237007e-06,-0.00365934278933966,0.178610738978792,-0.325812782035131,
  -8.35241180741075e-06,-0.00345338197129008,0.188274788487019,-0.353425681208673,
  -8.44487695211837e-06,-0.00324742115324006,0.197938837995247,-0.381038580382215,
  -8.53734209715906e-06,-0.00304146033519048,0.207602887503475,-0.408651479555758,
  -8.62980724247731e-06,-0.00283549951714113,0.217266937011703,-0.4362643787293,
  -8.72227238712941e-06,-0.00262953869909088,0.226930986519931,-0.463877277902843,
  -8.81473753222561e-06,-0.00242357788104131,0.236595036028159,-0.491490177076385,
  -8.90720267698875e-06,-0.00221761706299173,0.246259085536387,-0.519103076249928,
  -8.99966782164086e-06,-0.00201165624494148,0.255923135044615,-0.54671597542347,
  -9.09213296673705e-06,-0.00180569542689168,0.265587184552843,-0.574328874597013,
  -9.18459811194428e-06,-0.00159973460884277,0.275251234061071,-0.601941773770555,
  -9.27706325681843e-06,-0.00139377379079253,0.284915283569299,-0.629554672944097,
  -9.36952840124849e-06,-0.00118781297274184,0.294579333077527,-0.65716757211764,
  -9.46199354678878e-06,-0.000981852154693375,0.304243382585755,-0.684780471291182,
  -9.55445869210703e-06,-0.000775891336643575,0.313907432093983,-0.712393370464725,
  -9.64692383687016e-06,-0.000569930518594219,0.32357148160221,-0.740006269638267,
  -9.73938898196636e-06,-0.00036396970054442,0.333235531110438,-0.76761916881181,
  -9.8318541272846e-06,-0.000158008882495064,0.342899580618667,-0.795232067985352,
  -5.60968746154966e-06,-0.00497889556875963,0.110270734505491,-0.133083736804912,
  -5.66472350171932e-06,-0.004796528543909,0.119749362317796,-0.1608095295516,
  -5.71975954172244e-06,-0.00461416151905814,0.129227990130102,-0.188535322298289,
  -5.77479558172556e-06,-0.00443179449420739,0.138706617942407,-0.216261115044977,
  -5.82983162217277e-06,-0.00424942746935697,0.148185245754712,-0.243986907791666,
  -5.8848676622314e-06,-0.00406706044450655,0.157663873567016,-0.271712700538355,
  -5.93990370212349e-06,-0.00388469341965525,0.167142501379322,-0.299438493285043,
  -5.9949397420711e-06,-0.00370232639480439,0.176621129191627,-0.327164286031732,
  -6.04997578240729e-06,-0.00351995936995397,0.186099757003932,-0.354890078778421,
  -6.1050118223549e-06,-0.00333759234510289,0.195578384816237,-0.382615871525109,
  -6.16004786246904e-06,-0.00315522532025247,0.205057012628542,-0.410341664271798,
  -6.21508390308279e-06,-0.0029728582954025,0.214535640440847,-0.438067457018487,
  -6.27011994280835e-06,-0.00279049127055142,0.224014268253152,-0.465793249765175,
  -6.32515598286698e-06,-0.00260812424570056,0.233492896065457,-0.493519042511864,
  -6.38019202292561e-06,-0.00242575722084948,0.242971523877762,-0.521244835258553,
  -6.43522806320629e-06,-0.00224339019599951,0.252450151690067,-0.548970628005241,
  -6.49026410359799e-06,-0.00206102317114909,0.261928779502372,-0.57669642075193,
  -6.54530014321253e-06,-0.00187865614629779,0.271407407314677,-0.604422213498619,
  -6.60033618393729e-06,-0.00169628912144804,0.280886035126982,-0.632148006245307,
  -6.65537222377388e-06,-0.00151392209659695,0.290364662939287,-0.659873798991996,
  -6.71040826361047e-06,-0.00133155507174543,0.299843290751592,-0.687599591738684,
  -6.76544430378012e-06,-0.00114918804689479,0.309321918563898,-0.715325384485373,
  -6.82048034428284e-06,-0.000966821022044595,0.318800546376202,-0.743051177232062,
  -6.87551638389738e-06,-0.000784453997193513,0.328279174188507,-0.770776969978751,
  -6.93055242428908e-06,-0.000602086972343319,0.337757802000812,-0.798502762725439,
  -4.10027489805564e-06,-0.00488884778478804,0.109748227384138,-0.13350533452058,
  -4.13320112943594e-06,-0.004724578386053,0.119086977347266,-0.161315930400744,
  -4.1661273611493e-06,-0.00456030898731841,0.128425727310393,-0.189126526280908,
  -4.19905359239081e-06,-0.00439603958858314,0.137764477273521,-0.216937122161073,
  -4.23197982385437e-06,-0.00423177018984811,0.147103227236649,-0.244747718041237,
  -4.264906055651e-06,-0.00406750079111351,0.156441977199777,-0.272558313921401,
  -4.29783228705904e-06,-0.00390323139237858,0.165780727162905,-0.300368909801565,
  -4.3307585185226e-06,-0.00373896199364343,0.175119477126033,-0.328179505681729,
  -4.36368475026372e-06,-0.00357469259490872,0.184458227089161,-0.355990101561893,
  -4.39661098144972e-06,-0.00341042319617335,0.193796977052289,-0.383800697442057,
  -4.42953721291328e-06,-0.00324615379743864,0.203135727015416,-0.411611293322221,
  -4.46246344421031e-06,-0.00308188439870349,0.212474476978544,-0.439421889202385,
  -4.4953896758404e-06,-0.00291761499996834,0.221813226941672,-0.46723248508255,
  -4.52831590758151e-06,-0.00275334560123386,0.2311519769048,-0.495043080962714,
  -4.56124213898956e-06,-0.00258907620249915,0.240490726867927,-0.522853676842878,
  -4.59416837017557e-06,-0.00242480680376356,0.249829476831056,-0.550664272723042,
  -4.62709460191668e-06,-0.00226053740502841,0.259168226794184,-0.578474868603206,
  -4.66002083332473e-06,-0.00209626800629392,0.268506976757311,-0.60628546448337,
  -4.69294706528789e-06,-0.00193199860755966,0.277845726720439,-0.634096060363534,
  -4.72587329725105e-06,-0.00176772920882495,0.287184476683567,-0.661906656243698,
  -4.75879952788194e-06,-0.00160345981008936,0.296523226646695,-0.689717252123862,
  -4.79172575928999e-06,-0.00143919041135465,0.305861976609822,-0.717527848004027,
  -4.8246519910311e-06,-0.00127492101261906,0.315200726572951,-0.745338443884191,
  -4.85757822221711e-06,-0.00111065161388435,0.324539476536078,-0.773149039764355,
  -4.89050445406924e-06,-0.000946382215150088,0.333878226499206,-0.800959635644519,
  -2.9788671481179e-06,-0.00482306122726872,0.109359315352207,-0.133817820434063,
  -2.99881215790054e-06,-0.00467241318619205,0.118594060224239,-0.161691271931431,
  -3.01875716784972e-06,-0.0045217651451156,0.127828805096271,-0.189564723428799,
  -3.03870217749358e-06,-0.00437111710403848,0.137063549968304,-0.217438174926168,
  -3.05864718730398e-06,-0.00422046906296181,0.146298294840336,-0.245311626423536,
  -3.07859219716988e-06,-0.00406982102188536,0.155533039712368,-0.273185077920904,
  -3.09853720698028e-06,-0.00391917298080835,0.1647677845844,-0.301058529418273,
  -3.1184822169017e-06,-0.00376852493973168,0.174002529456433,-0.328931980915641,
  -3.13842722687863e-06,-0.003617876898655,0.183237274328465,-0.356805432413009,
  -3.15837223624493e-06,-0.00346722885757789,0.192472019200497,-0.384678883910378,
  -3.17831724633288e-06,-0.00331658081650188,0.201706764072529,-0.412552335407746,
  -3.19826225603226e-06,-0.00316593277542476,0.210941508944561,-0.440425786905114,
  -3.21820726600919e-06,-0.00301528473434809,0.220176253816593,-0.468299238402483,
  -3.23815227576407e-06,-0.00286463669327119,0.229410998688626,-0.496172689899851,
  -3.25809728551896e-06,-0.00271398865219474,0.238645743560658,-0.524046141397219,
  -3.27804229527384e-06,-0.00256334061111763,0.24788048843269,-0.551919592894588,
  -3.29798730525077e-06,-0.00241269257004095,0.257115233304723,-0.579793044391956,
  -3.31793231478361e-06,-0.00226204452896428,0.266349978176754,-0.607666495889325,
  -3.33787732498259e-06,-0.00211139648788761,0.275584723048787,-0.635539947386693,
  -3.3578223344044e-06,-0.00196074844681071,0.284819467920819,-0.663413398884061,
  -3.37776734393724e-06,-0.00181010040573382,0.294054212792851,-0.69128685038143,
  -3.3977123540252e-06,-0.00165945236465737,0.303288957664883,-0.719160301878798,
  -3.41765736378008e-06,-0.00150880432358003,0.312523702536916,-0.747033753376166,
  -3.43760237364599e-06,-0.00135815628250402,0.321758447408948,-0.774907204873535,
  -3.45754738451109e-06,-0.00120750824142801,0.33099319228098,-0.802780656370903,
  -2.15447966761539e-06,-0.00477530097020373,0.109073020878775,-0.134047143901708,
  -2.16677689013345e-06,-0.00463476167236698,0.118231261847959,-0.161966723136284,
  -2.17907411254048e-06,-0.00449422237453001,0.127389502817143,-0.18988630237086,
  -2.19137133533609e-06,-0.00435368307669359,0.136547743786326,-0.217805881605436,
  -2.20366855779863e-06,-0.00421314377885684,0.145705984755509,-0.245725460840013,
  -2.21596578053873e-06,-0.00407260448102031,0.154864225724693,-0.273645040074589,
  -2.22826300316781e-06,-0.00393206518318401,0.164022466693876,-0.301564619309165,
  -2.24056022557484e-06,-0.0037915258853467,0.17318070766306,-0.329484198543741,
  -2.25285744842596e-06,-0.00365098658751051,0.182338948632243,-0.357403777778317,
  -2.2651546708885e-06,-0.00351044728967387,0.191497189601427,-0.385323357012893,
  -2.27745189324002e-06,-0.00336990799183656,0.200655430570611,-0.41324293624747,
  -2.2897491158691e-06,-0.00322936869400037,0.209813671539794,-0.441162515482046,
  -2.30204633844266e-06,-0.00308882939616351,0.218971912508977,-0.469082094716622,
  -2.31434356090521e-06,-0.00294829009832664,0.228130153478161,-0.497001673951198,
  -2.32664078381184e-06,-0.00280775080049023,0.237288394447344,-0.524921253185774,
  -2.33893800649643e-06,-0.00266721150265403,0.246446635416527,-0.55284083242035,
  -2.35123522906999e-06,-0.00252667220481717,0.255604876385711,-0.580760411654927,
  -2.36353245142151e-06,-0.00238613290698053,0.264763117354894,-0.608679990889503,
  -2.37582967355099e-06,-0.002245593609143,0.273921358324078,-0.636599570124079,
  -2.38812689645762e-06,-0.00210505431130636,0.283079599293262,-0.664519149358655,
  -2.40042411892016e-06,-0.00196451501347017,0.292237840262445,-0.692438728593231,
  -2.41272134204884e-06,-0.00182397571563353,0.301396081231629,-0.720358307827807,
  -2.42501856440036e-06,-0.00168343641779733,0.310554322200812,-0.748277887062384,
  -2.43731578664086e-06,-0.00154289711995981,0.319712563169996,-0.77619746629696,
  -2.44961300954749e-06,-0.00140235782212317,0.328870804139179,-0.804117045531536,
  -1.5531331770402e-06,-0.00474078261675359,0.108863975224288,-0.13421421309183,
  -1.56087352429224e-06,-0.00460766781943001,0.117966385942351,-0.16216739779983,
  -1.5686138719051e-06,-0.00447455302210653,0.127068796660415,-0.190120582507831,
  -1.57635421910163e-06,-0.00434143822478306,0.136171207378478,-0.218073767215831,
  -1.58409456674224e-06,-0.0042083234274598,0.145273618096541,-0.246026951923831,
  -1.59183491404979e-06,-0.00407520863013622,0.154376028814604,-0.273980136631832,
  -1.59957526157939e-06,-0.00394209383281274,0.163478439532668,-0.301933321339832,
  -1.60731560899796e-06,-0.0038089790354896,0.172580850250731,-0.329886506047832,
  -1.61505595641653e-06,-0.00367586423816602,0.181683260968794,-0.357839690755832,
  -1.62279630350204e-06,-0.00354274944084199,0.190785671686858,-0.385792875463833,
  -1.63053665125368e-06,-0.00340963464351884,0.199888082404921,-0.413746060171833,
  -1.63827699861674e-06,-0.0032765198461957,0.208990493122984,-0.441699244879833,
  -1.64601734586878e-06,-0.00314340504887145,0.218092903841048,-0.469652429587833,
  -1.65375769334286e-06,-0.00301029025154831,0.227195314559111,-0.497605614295834,
  -1.66149804081694e-06,-0.00287717545422472,0.236297725277174,-0.525558799003834,
  -1.66923838840205e-06,-0.00274406065690158,0.245400135995237,-0.553511983711834,
  -1.67697873554307e-06,-0.002610945859578,0.2545025467133,-0.581465168419835,
  -1.68471908268408e-06,-0.00247783106225441,0.263604957431364,-0.609418353127835,
  -1.69245943026919e-06,-0.00234471626493082,0.272707368149427,-0.637371537835835,
  -1.70019977785429e-06,-0.00221160146760724,0.281809778867491,-0.665324722543835,
  -1.70794012566144e-06,-0.00207848667028498,0.290912189585553,-0.693277907251836,
  -1.71568047235837e-06,-0.00194537187296007,0.300014600303617,-0.721231091959836,
  -1.72342081961041e-06,-0.00181225707563692,0.30911701102168,-0.749184276667836,
  -1.73116116708449e-06,-0.00167914227831378,0.318219421739743,-0.777137461375836,
  -1.73890151422551e-06,-0.00154602748098931,0.327321832457807,-0.805090646083837,
  -1.1169632548047e-06,-0.00471591413422234,0.108712239322846,-0.1343352819284,
  -1.121941169413e-06,-0.00458821119745223,0.117774141990799,-0.16231281927477,
  -1.12691908421558e-06,-0.00446050826068234,0.126836044658752,-0.19029035662114,
  -1.13189699885163e-06,-0.00433280532391223,0.135897947326706,-0.218267893967511,
  -1.13687491370973e-06,-0.00420510238714211,0.144959849994659,-0.246245431313881,
  -1.14185282829027e-06,-0.004077399450372,0.154021752662612,-0.274222968660251,
  -1.14683074303734e-06,-0.00394969651360211,0.163083655330565,-0.302200506006622,
  -1.15180865795095e-06,-0.00382199357683199,0.172145557998518,-0.330178043352992,
  -1.15678657253149e-06,-0.00369429064006188,0.181207460666472,-0.358155580699362,
  -1.16176448744509e-06,-0.00356658770329221,0.190269363334425,-0.386133118045733,
  -1.16674240202563e-06,-0.00343888476652188,0.199331266002378,-0.414110655392103,
  -1.17172031710577e-06,-0.00331118182975199,0.208393168670331,-0.442088192738473,
  -1.17669823140876e-06,-0.00318347889298121,0.217455071338285,-0.470065730084843,
  -1.18167614615583e-06,-0.00305577595621154,0.226516974006237,-0.498043267431214,
  -1.18665406068086e-06,-0.00292807301944142,0.23557887667419,-0.526020804777584,
  -1.19163197520589e-06,-0.00280037008267087,0.244640779342144,-0.553998342123954,
  -1.19660989028603e-06,-0.0026726671459012,0.253702682010097,-0.581975879470325,
  -1.20158780514412e-06,-0.00254496420913153,0.26276458467805,-0.609953416816695,
  -1.20656572011324e-06,-0.00241726127236142,0.271826487346003,-0.637930954163065,
  -1.21154363419418e-06,-0.00228955833559086,0.280888390013956,-0.665908491509436,
  -1.21652154938534e-06,-0.00216185539882119,0.28995029268191,-0.693886028855806,
  -1.22149946402139e-06,-0.00203415246205108,0.299012195349863,-0.721863566202176,
  -1.22647737854642e-06,-0.00190644952528052,0.308074098017816,-0.749841103548547,
  -1.23145529307145e-06,-0.0017787465885104,0.317136000685769,-0.777818640894917,
  -1.23643320815159e-06,-0.00165104365174118,0.326197903353722,-0.805796178241287,
  -7.83414222345902e-05,-0.0116289112638718,0.141662584592908,-0.120891389200109,
  -8.39283406746938e-05,-0.0109598102246087,0.157160732718559,-0.143991459763914,
  -8.95152591147141e-05,-0.0102907091853457,0.17265888084421,-0.167091530327719,
  -9.51021775547067e-05,-0.00962160814608259,0.188157028969861,-0.190191600891524,
  -0.000100689095994588,-0.00895250710681939,0.203655177095512,-0.213291671455329,
  -0.000106276014434692,-0.00828340606755651,0.219153325221162,-0.236391742019134,
  -0.000111862932874962,-0.00761430502829374,0.234651473346813,-0.259491812582939,
  -0.000117449851314677,-0.00694520398903031,0.250149621472464,-0.282591883146744,
  -0.000123036769755003,-0.00627610294976755,0.265647769598115,-0.305691953710549,
  -0.000128623688194773,-0.00560700191050412,0.281145917723766,-0.328792024274354,
  -0.000134210606634488,-0.00493790087124046,0.296644065849417,-0.351892094838159,
  -0.000139797525074647,-0.00426879983197748,0.312142213975068,-0.374992165401964,
  -0.000145384443514751,-0.00359969879271449,0.327640362100719,-0.398092235965769,
  -0.000150971361955077,-0.00293059775345195,0.34313851022637,-0.421192306529575,
  -0.000156558280394958,-0.00226149671418896,0.358636658352021,-0.44429237709338,
  -0.000162145198835062,-0.00159239567492575,0.374134806477672,-0.467392447657185,
  -0.000167732117275166,-0.000923294635662764,0.389632954603323,-0.49049251822099,
  -0.000173319035714825,-0.00025419359639911,0.405131102728974,-0.513592588784795,
  -0.00017890595415504,0.000414907442863433,0.420629250854625,-0.5366926593486,
  -0.000184492872595365,0.0010840084821262,0.436127398980275,-0.559792729912405,
  -0.00019007979103558,0.00175310952138918,0.451625547105926,-0.58289280047621,
  -0.00019566670947524,0.00242221056065306,0.467123695231578,-0.605992871040015,
  -0.000201253627915454,0.0030913115999156,0.482621843357228,-0.62909294160382,
  -0.000206840546355225,0.00376041263917903,0.498119991482879,-0.652193012167625,
  -0.000212427464795661,0.00442951367844158,0.51361813960853,-0.67529308273143,
  -7.76990489378682e-05,-0.0115458433149976,0.141457128654798,-0.121108633483948,
  -8.32042916177889e-05,-0.0108778664364927,0.156901322561119,-0.144248658146241,
  -8.87095342972932e-05,-0.0102098895579871,0.172345516467441,-0.167388682808533,
  -9.42147769772417e-05,-0.00954191267948201,0.187789710373762,-0.190528707470825,
  -9.97200196568016e-05,-0.00887393580097673,0.203233904280083,-0.213668732133118,
  -0.000105225262336306,-0.00820595892247145,0.218678098186404,-0.23680875679541,
  -0.00011073050501631,-0.00753798204396627,0.234122292092726,-0.259948781457702,
  -0.000116235747695925,-0.00687000516546088,0.249566485999047,-0.283088806119995,
  -0.000121740990375485,-0.00620202828695549,0.265010679905369,-0.306228830782287,
  -0.000127246233055045,-0.00553405140845031,0.28045487381169,-0.329368855444579,
  -0.000132751475734882,-0.00486607452994514,0.295899067718011,-0.352508880106872,
  -0.000138256718414831,-0.00419809765144019,0.311343261624332,-0.375648904769164,
  -0.000143761961094335,-0.0035301207729348,0.326787455530654,-0.398788929431456,
  -0.000149267203773618,-0.00286214389442874,0.342231649436975,-0.421928954093749,
  -0.000154772446453899,-0.00219416701592423,0.357675843343296,-0.445068978756041,
  -0.000160277689133403,-0.00152619013741884,0.373120037249618,-0.468209003418333,
  -0.000165782931813463,-0.000858213258914331,0.388564231155939,-0.491349028080626,
  -0.000171288174493189,-0.000190236380408715,0.40400842506226,-0.514489052742918,
  -0.000176793417172361,0.000477740498097567,0.419452618968582,-0.53762907740521,
  -0.00018229865985242,0.0011457173766023,0.434896812874903,-0.560769102067503,
  -0.000187803902531813,0.00181369425510791,0.450341006781225,-0.583909126729795,
  -0.000193309145211762,0.00248167113361264,0.465785200687546,-0.607049151392087,
  -0.000198814387891377,0.00314964801211826,0.481229394593867,-0.630189176054379,
  -0.000204319630571437,0.0038176248906221,0.496673588500188,-0.653329200716672,
  -0.000209824873250497,0.00448560176912904,0.51211778240651,-0.676469225378964,
  -7.68175610340871e-05,-0.0114326568479056,0.141174780546538,-0.121406109441676,
  -8.22115473388119e-05,-0.010766331768774,0.156544907596779,-0.144600843868951,
  -8.76055336435644e-05,-0.0101000066896424,0.17191503464702,-0.167795578296226,
  -9.29995199482891e-05,-0.00943368161051072,0.187285161697261,-0.190990312723501,
  -9.83935062529584e-05,-0.00876735653137894,0.202655288747502,-0.214185047150775,
  -0.000103787492557905,-0.00810103145224761,0.218025415797743,-0.23737978157805,
  -0.000109181478862685,-0.00743470637311616,0.233395542847984,-0.260574516005325,
  -0.000114575465167299,-0.00676838129398427,0.248765669898226,-0.2837692504326,
  -0.000119969451471913,-0.0061020562148526,0.264135796948467,-0.306963984859875,
  -0.000125363437776804,-0.00543573113572116,0.279505923998708,-0.330158719287149,
  -0.000130757424081807,-0.00476940605659015,0.294876051048948,-0.353353453714424,
  -0.000136151410386254,-0.00410308097745804,0.31024617809919,-0.376548188141699,
  -0.000141545396690979,-0.00343675589832637,0.325616305149431,-0.399742922568974,
  -0.000146939382995703,-0.00277043081919448,0.340986432199672,-0.422937656996249,
  -0.000152333369300539,-0.00210410574006326,0.356356559249913,-0.446132391423524,
  -0.000157727355605375,-0.00143778066093181,0.371726686300154,-0.469327125850798,
  -0.000163121341910211,-0.00077145558180014,0.387096813350395,-0.492521860278073,
  -0.000168515328215157,-0.000105130502668471,0.402466940400637,-0.515716594705348,
  -0.00017390931451966,0.000561194576463198,0.417837067450878,-0.538911329132623,
  -0.000179303300824163,0.00122751965559464,0.433207194501118,-0.562106063559898,
  -0.000184697287129332,0.00189384473472609,0.448577321551359,-0.585300797987172,
  -0.000190091273433723,0.00256016981385798,0.463947448601601,-0.608495532414447,
  -0.000195485259738781,0.00322649489298943,0.479317575651842,-0.631690266841722,
  -0.000200879246043284,0.00389281997212132,0.494687702702083,-0.654885001268997,
  -0.000206273232348009,0.00455914505125321,0.510057829752324,-0.678079735696272,
  -7.56168926999978e-05,-0.011279968639008,0.140789429704878,-0.121810129195623,
  -8.08608735217153e-05,-0.0106160952802743,0.15605861693504,-0.145079168201847,
  -8.61048543434606e-05,-0.00995222192154066,0.171327804165203,-0.168348207208072,
  -9.13488351651504e-05,-0.00928834856280691,0.186596991395366,-0.191617246214297,
  -9.65928159866736e-05,-0.00862447520407306,0.201866178625529,-0.214886285220522,
  -0.000101836796808419,-0.00796060184533942,0.217135365855692,-0.238155324226746,
  -0.000107080777629887,-0.00729672848660523,0.232404553085855,-0.261424363232971,
  -0.000112324758451576,-0.00663285512787182,0.247673740316018,-0.284693402239196,
  -0.000117568739273433,-0.0059689817691384,0.262942927546181,-0.307962441245421,
  -0.000122812720095233,-0.00530510841040477,0.278212114776344,-0.331231480251646,
  -0.000128056700916812,-0.00464123505167069,0.293481302006507,-0.35450051925787,
  -0.000133300681738557,-0.00397736169293683,0.30875048923667,-0.377769558264095,
  -0.000138544662560136,-0.0033134883342032,0.324019676466833,-0.40103859727032,
  -0.000143788643382048,-0.00264961497546978,0.339288863696996,-0.424307636276545,
  -0.000149032624203405,-0.00198574161673548,0.354558050927159,-0.44757667528277,
  -0.000154276605025094,-0.00132186825800229,0.369827238157321,-0.470845714288995,
  -0.000159520585847117,-0.000657994899268433,0.385096425387485,-0.494114753295219,
  -0.000164764566668807,5.87845946498078e-06,0.400365612617647,-0.517383792301444,
  -0.000170008547490497,0.000669751818198616,0.41563479984781,-0.540652831307669,
  -0.000175252528312075,0.0013336251769327,0.430903987077973,-0.563921870313894,
  -0.000180496509133099,0.00199749853566722,0.446173174308137,-0.587190909320118,
  -0.000185740489955455,0.00266137189439997,0.461442361538299,-0.610459948326343,
  -0.000190984470776923,0.00332524525313405,0.476711548768462,-0.633728987332568,
  -0.000196228451598501,0.00398911861186768,0.491980735998625,-0.656998026338793,
  -0.000201472432420524,0.00465299197060132,0.507249923228788,-0.680267065345017,
  -7.39979141961555e-05,-0.0110767637999118,0.140268433623546,-0.122352798324143,
  -7.9042448202532e-05,-0.0104165614610069,0.155401415260391,-0.145721641363983,
  -8.4086982208631e-05,-0.00975635912210149,0.170534396897237,-0.169090484403822,
  -8.91315162152573e-05,-0.00909615678319675,0.185667378534082,-0.192459327443662,
  -9.4176050221495e-05,-0.00843595444429157,0.200800360170928,-0.215828170483502,
  -9.92205842277882e-05,-0.00777575210538639,0.215933341807773,-0.239197013523341,
  -0.000104265118234192,-0.00711554976648143,0.231066323444619,-0.262565856563181,
  -0.000109309652240597,-0.00645534742757659,0.246199305081464,-0.28593469960302,
  -0.000114354186246668,-0.00579514508867085,0.26133228671831,-0.30930354264286,
  -0.000119398720253128,-0.005134942749766,0.276465268355156,-0.332672385682699,
  -0.000124443254259476,-0.00447474041086093,0.291598249992001,-0.356041228722539,
  -0.000129487788265714,-0.00381453807195586,0.306731231628846,-0.379410071762378,
  -0.000134532322272118,-0.00315433573305079,0.321864213265692,-0.402778914802218,
  -0.000139576856278745,-0.00249413339414595,0.336997194902537,-0.426147757842057,
  -0.00014462139028526,-0.00183393105524154,0.352130176539383,-0.449516600881897,
  -0.000149665924291109,-0.00117372871633559,0.367263158176228,-0.472885443921737,
  -0.000154710458297846,-0.000513526377431184,0.382396139813074,-0.496254286961576,
  -0.000159754992303918,0.000146675961474108,0.397529121449919,-0.519623130001416,
  -0.0001647995263101,0.000806878300379399,0.412662103086765,-0.542991973041255,
  -0.000169844060316393,0.00146708063928491,0.427795084723611,-0.566360816081095,
  -0.000174888594323241,0.00212728297818909,0.442928066360456,-0.589729659120934,
  -0.000179933128329313,0.00278748531709461,0.458061047997301,-0.613098502160774,
  -0.000184977662335606,0.00344768765599968,0.473194029634147,-0.636467345200613,
  -0.000190022196341788,0.00410788999490519,0.488327011270993,-0.659836188240453,
  -0.000195066730348414,0.00476809233380981,0.503459992907838,-0.683205031280293,
  -7.18444281493369e-05,-0.0108111761873713,0.139572979280439,-0.123070936765675,
  -7.66287251092457e-05,-0.0101564987311539,0.154524611041197,-0.146571854967693,
  -8.14130220691545e-05,-0.00950182127493626,0.169476242801955,-0.170072773169711,
  -8.61973190288134e-05,-0.00884714381871832,0.184427874562713,-0.193573691371729,
  -9.09816159885835e-05,-0.00819246636250082,0.199379506323472,-0.217074609573747,
  -9.57659129484645e-05,-0.0075377889062832,0.21433113808423,-0.240575527775765,
  -0.000100550209908123,-0.00688311145006515,0.229282769844989,-0.264076445977783,
  -0.000105334506867838,-0.00622843399384765,0.244234401605747,-0.287577364179801,
  -0.000110118803827775,-0.00557375653763015,0.259186033366505,-0.311078282381819,
  -0.000114903100787545,-0.00491907908141243,0.274137665127263,-0.334579200583837,
  -0.00011968739774737,-0.00426440162519492,0.289089296888022,-0.358080118785855,
  -0.000124471694707418,-0.00360972416897787,0.304040928648779,-0.381581036987873,
  -0.000129255991667243,-0.00295504671276015,0.318992560409538,-0.405081955189891,
  -0.000134040288626625,-0.00230036925654198,0.333944192170296,-0.428582873391909,
  -0.000138824585586783,-0.0016456918003247,0.348895823931055,-0.452083791593927,
  -0.000143608882546498,-0.000991014344106977,0.363847455691813,-0.475584709795945,
  -0.000148393179506434,-0.000336336887889921,0.378799087452571,-0.499085627997963,
  -0.000153177476465927,0.000318340568328024,0.393750719213329,-0.522586546199981,
  -0.000157961773425641,0.000973018024546191,0.408702350974088,-0.546087464401999,
  -0.000162746070385467,0.00162769548076369,0.423653982734846,-0.569588382604017,
  -0.000167530367345181,0.00228237293698141,0.438605614495604,-0.593089300806035,
  -0.000172314664304896,0.00293705039319914,0.453557246256363,-0.616590219008053,
  -0.000177098961265387,0.00359172784941597,0.468508878017121,-0.640091137210071,
  -0.00018188325822488,0.00424640530563369,0.483460509777879,-0.663592055412089,
  -0.000186667555184261,0.0049010827618523,0.498412141538638,-0.687092973614107,
  -6.90314003069792e-05,-0.0104722002027698,0.138660364701854,-0.12400280290648,
  -7.34845469011758e-05,-0.00982582607415372,0.153374801509756,-0.147675103622728,
  -7.79376934958442e-05,-0.00917945194553793,0.168089238317658,-0.171347404338977,
  -8.23908400900408e-05,-0.00853307781692147,0.18280367512556,-0.195019705055226,
  -8.68439866842374e-05,-0.00788670368830502,0.197518111933462,-0.218692005771475,
  -9.12971332787116e-05,-0.00724032955968901,0.212232548741364,-0.242364306487724,
  -9.57502798729082e-05,-0.00659395543107255,0.226946985549266,-0.266036607203973,
  -0.000100203426467271,-0.00594758130245654,0.241661422357168,-0.289708907920222,
  -0.000104656573061634,-0.00530120717384031,0.25637585916507,-0.31338120863647,
  -0.000109109719655998,-0.00465483304522429,0.271090295972972,-0.337053509352719,
  -0.000113562866250083,-0.00400845891660806,0.285804732780874,-0.360725810068968,
  -0.000118016012845112,-0.00336208478799249,0.300519169588776,-0.384398110785217,
  -0.000122469159439254,-0.00271571065937581,0.315233606396678,-0.408070411501466,
  -0.000126922306033284,-0.0020693365307598,0.329948043204579,-0.431742712217715,
  -0.000131375452627314,-0.00142296240214268,0.344662480012482,-0.455415012933963,
  -0.000135828599222121,-0.000776588273527334,0.359376916820384,-0.479087313650212,
  -0.000140281745816262,-0.000130214144910878,0.374091353628285,-0.502759614366461,
  -0.000144734892410292,0.0005161599837058,0.388805790436188,-0.52643191508271,
  -0.000149188039004544,0.00116253411232203,0.40352022724409,-0.550104215798959,
  -0.000153641185599573,0.00180890824093716,0.418234664051991,-0.573776516515208,
  -0.000158094332193714,0.00245528236955384,0.432949100859893,-0.597448817231456,
  -0.000162547478788189,0.00310165649816962,0.447663537667795,-0.621121117947705,
  -0.000167000625382552,0.00374803062678586,0.462377974475697,-0.644793418663954,
  -0.000171453771976915,0.00439440475540209,0.477092411283599,-0.668465719380203,
  -0.000175906918571167,0.00504077888401788,0.491806848091501,-0.692138020096452,
  -6.54427559836912e-05,-0.0100525494061992,0.137489370775112,-0.125181671037007,
  -6.94881053941165e-05,-0.00941851850435549,0.151900710412697,-0.149070781201855,
  -7.35334548044864e-05,-0.00878448760251183,0.166312050050283,-0.172959891366703,
  -7.75788042147729e-05,-0.00815045670066783,0.180723389687868,-0.196849001531552,
  -8.1624153625004e-05,-0.00751642579882406,0.195134729325454,-0.2207381116964,
  -8.5669503035235e-05,-0.00688239489698028,0.209546068963039,-0.244627221861248,
  -8.97148524458546e-05,-0.00624836399513673,0.223957408600625,-0.268516332026096,
  -9.37602018560302e-05,-0.00561433309329273,0.23836874823821,-0.292405442190945,
  -9.78055512662612e-05,-0.00498030219144896,0.252780087875795,-0.316294552355793,
  -0.000101850900676825,-0.00434627128960541,0.267191427513381,-0.340183662520641,
  -0.00010589625008689,-0.00371224038776119,0.281602767150966,-0.364072772685489,
  -0.000109941599497287,-0.00307820948591742,0.296014106788552,-0.387961882850338,
  -0.000113986948907407,-0.0024441785840732,0.310425446426138,-0.411850993015186,
  -0.000118032298318083,-0.00181014768222987,0.324836786063723,-0.435740103180034,
  -0.000122077647728536,-0.00117611678038654,0.339248125701308,-0.459629213344882,
  -0.000126122997138767,-0.000542085878542098,0.353659465338894,-0.483518323509731,
  -0.000130168346549442,9.19450233007879e-05,0.368070804976479,-0.507407433674579,
  -0.000134213695959118,0.00072597592514545,0.382482144614065,-0.531296543839427,
  -0.000138259045369793,0.001360006826989,0.39689348425165,-0.555185654004275,
  -0.000142304394780024,0.00199403772883233,0.411304823889235,-0.579074764169124,
  -0.000146349744190699,0.00262806863067588,0.425716163526821,-0.602963874333972,
  -0.00015039509360093,0.00326209953251988,0.440127503164406,-0.62685298449882,
  -0.000154440443011494,0.00389613043436299,0.454538842801991,-0.650742094663668,
  -0.000158485792421281,0.00453016133620832,0.468950182439578,-0.674631204828516,
  -0.000162531141831401,0.00516419223805231,0.483361522077163,-0.698520314993365,
  -6.10006916742234e-05,-0.00955241818104746,0.136029599275224,-0.126625996462491,
  -6.45644653196609e-05,-0.00893631688648289,0.150064975374546,-0.15078073718515,
  -6.81282389652926e-05,-0.00832021559191864,0.164100351473868,-0.174935477907808,
  -7.16920126107579e-05,-0.00770411429735429,0.17813572757319,-0.199090218630467,
  -7.52557862562231e-05,-0.00708801300278983,0.192171103672513,-0.223244959353126,
  -7.88195599014663e-05,-0.00647191170822492,0.206206479771835,-0.247399700075785,
  -8.23833335472646e-05,-0.00585581041366079,0.220241855871157,-0.271554440798444,
  -8.59471071922857e-05,-0.00523970911909566,0.23427723197048,-0.295709181521103,
  -8.9510880837973e-05,-0.00462360782453164,0.248312608069802,-0.319863922243762,
  -9.30746544831051e-05,-0.00400750652996651,0.262347984169125,-0.344018662966421,
  -9.66384281291255e-05,-0.00339140523540271,0.276383360268447,-0.36817340368908,
  -0.00010020220177398,-0.00277530394083758,0.290418736367769,-0.392328144411739,
  -0.000103765975419834,-0.00215920264627356,0.304454112467091,-0.416482885134398,
  -0.000107329749065022,-0.00154310135170888,0.318489488566414,-0.440637625857057,
  -0.000110893522710542,-0.000927000057144189,0.332524864665736,-0.464792366579716,
  -0.000114457296356285,-0.000310898762580392,0.346560240765058,-0.488947107302375,
  -0.000118021070001584,0.000305202531984516,0.36059561686438,-0.513101848025034,
  -0.000121584843646771,0.00092130382654898,0.374630992963702,-0.537256588747693,
  -0.000125148617292625,0.00153740512111322,0.388666369063025,-0.561411329470351,
  -0.000128712390937147,0.00215350641567902,0.402701745162347,-0.58556607019301,
  -0.00013227616458289,0.00276960771024282,0.416737121261669,-0.609720810915669,
  -0.000135839938228743,0.0033857090048075,0.430772497360992,-0.633875551638328,
  -0.000139403711874597,0.0040018102993713,0.444807873460314,-0.658030292360987,
  -0.000142967485519341,0.00461791159393732,0.458843249559637,-0.682185033083646,
  -0.000146531259164751,0.00523401288850156,0.472878625658959,-0.706339773806305,
  -5.5703650192529e-05,-0.0089830523772978,0.134274251811519,-0.128327688174916,
  -5.87275555902489e-05,-0.00839205339918936,0.147860149854505,-0.152795392521159,
  -6.17514609882464e-05,-0.00780105442108114,0.161446047897492,-0.177263096867402,
  -6.47753663862716e-05,-0.00721005544297315,0.175031945940478,-0.201730801213645,
  -6.77992717841303e-05,-0.00661905646486483,0.188617843983464,-0.226198505559887,
  -7.08231771822665e-05,-0.00602805748675694,0.202203742026451,-0.25066620990613,
  -7.38470825800697e-05,-0.00543705850864851,0.215789640069437,-0.275133914252372,
  -7.68709879779839e-05,-0.0048460595305404,0.229375538112424,-0.299601618598615,
  -7.98948933761201e-05,-0.0042550605524323,0.24296143615541,-0.324069322944858,
  -8.29187987739788e-05,-0.0036640615743242,0.256547334198396,-0.348537027291101,
  -8.5942704172004e-05,-0.00307306259621587,0.270133232241383,-0.373004731637343,
  -8.89666095700292e-05,-0.00248206361810821,0.283719130284369,-0.397472435983586,
  -9.19905149677769e-05,-0.00189106463999944,0.297305028327356,-0.421940140329828,
  -9.50144203657466e-05,-0.00130006566189156,0.310890926370342,-0.446407844676071,
  -9.80383257632722e-05,-0.000709066683782344,0.324476824413329,-0.470875549022314,
  -0.000101062231161464,-0.000118067705674907,0.338062722456315,-0.495343253368556,
  -0.000104086136559878,0.000472931272432753,0.351648620499301,-0.519810957714799,
  -0.000107110041957181,0.00106393025054174,0.365234518542288,-0.544278662061042,
  -0.000110133947355151,0.00165492922865007,0.378820416585274,-0.568746366407284,
  -0.000113157852753343,0.00224592820675795,0.392406314628261,-0.593214070753527,
  -0.000116181758151424,0.00283692718486561,0.405992212671247,-0.61768177509977,
  -0.00011920566354906,0.0034279261629746,0.419578110714234,-0.642149479446012,
  -0.000122229568947252,0.00401892514108226,0.43316400875722,-0.666617183792255,
  -0.000125253474345,0.00460992411919081,0.446749906800206,-0.691084888138498,
  -0.000128277379742858,0.00520092309729936,0.460335804843193,-0.71555259248474,
  -4.96617395167875e-05,-0.00836817782865384,0.132253064403274,-0.130242626607584,
  -5.21170075100941e-05,-0.00781059006857521,0.14532472226681,-0.155062513471054,
  -5.45722755033728e-05,-0.0072530023084969,0.158396380130346,-0.179882400334524,
  -5.70275434969014e-05,-0.00669541454841849,0.171468037993881,-0.204702287197994,
  -5.94828114901524e-05,-0.00613782678833974,0.184539695857417,-0.229522174061464,
  -6.19380794834035e-05,-0.00558023902826121,0.197611353720953,-0.254342060924934,
  -6.4393347476599e-05,-0.00502265126818258,0.210683011584489,-0.279161947788404,
  -6.68486154701831e-05,-0.00446506350810427,0.223754669448024,-0.303981834651874,
  -6.93038834631565e-05,-0.00390747574802552,0.23682632731156,-0.328801721515344,
  -7.17591514568516e-05,-0.00334988798794744,0.249897985175096,-0.353621608378814,
  -7.42144194501582e-05,-0.00279230022786892,0.262969643038631,-0.378441495242285,
  -7.66696874434647e-05,-0.00223471246779017,0.276041300902167,-0.403261382105755,
  -7.91249554369378e-05,-0.00167712470771209,0.289112958765703,-0.428081268969225,
  -8.15802234301888e-05,-0.00111953694763356,0.302184616629239,-0.452901155832695,
  -8.40354914234398e-05,-0.000561949187554811,0.315256274492774,-0.477721042696165,
  -8.64907594170239e-05,-4.36142747672896e-06,0.32832793235631,-0.502540929559635,
  -8.89460274100529e-05,0.000553226332601797,0.341399590219845,-0.527360816423105,
  -9.14012954035259e-05,0.00111081409268077,0.354471248083382,-0.552180703286575,
  -9.385656339711e-05,0.00166840185275863,0.367542905946917,-0.577000590150046,
  -9.63118313906941e-05,0.00222598961283715,0.380614563810453,-0.601820477013516,
  -9.87670993839451e-05,0.00278357737291524,0.393686221673988,-0.626640363876986,
  -0.00010122236737653,0.00334116513299509,0.406757879537525,-0.651460250740456,
  -0.000103677635370003,0.00389875289307318,0.41982953740106,-0.676280137603926,
  -0.000106132903363476,0.0044563406531517,0.432901195264596,-0.701100024467396,
  -0.000108588171356838,0.00501392841322978,0.445972853128131,-0.725919911330866,
  -4.31106498472444e-05,-0.00774140441284921,0.130039117898095,-0.132289312478137,
  -4.50083614302044e-05,-0.00722559384707899,0.142551279483455,-0.157485611956012,
  -4.69060730135529e-05,-0.00670978328130956,0.155063441068814,-0.182681911433887,
  -4.88037845968181e-05,-0.00619397271553979,0.167575602654174,-0.207878210911763,
  -5.07014961800833e-05,-0.00567816214977002,0.180087764239534,-0.233074510389638,
  -5.25992077629045e-05,-0.00516235158399958,0.192599925824894,-0.258270809867513,
  -5.44969193461142e-05,-0.00464654101823014,0.205112087410254,-0.283467109345389,
  -5.63946309291019e-05,-0.0041307304524596,0.217624248995614,-0.308663408823264,
  -5.82923425126447e-05,-0.0036149198866906,0.230136410580973,-0.333859708301139,
  -6.01900540958544e-05,-0.0030991093209205,0.242648572166333,-0.359056007779015,
  -6.20877656791197e-05,-0.00258329875515106,0.255160733751693,-0.38425230725689,
  -6.39854772621629e-05,-0.00206748818938096,0.267672895337053,-0.409448606734765,
  -6.58831888453726e-05,-0.0015516776236113,0.280185056922412,-0.434644906212641,
  -6.77809004285823e-05,-0.00103586705784142,0.292697218507772,-0.459841205690516,
  -6.967861201157e-05,-0.000520056492071319,0.305209380093132,-0.485037505168391,
  -7.15763235950018e-05,-4.24592630188236e-06,0.317721541678492,-0.510233804646267,
  -7.34740351782115e-05,0.000511564639467998,0.330233703263851,-0.535430104124142,
  -7.53717467607551e-05,0.00102737520523877,0.342745864849211,-0.560626403602018,
  -7.72694583445199e-05,0.00154318577100776,0.355258026434571,-0.585822703079893,
  -7.91671699273966e-05,0.00205899633677742,0.36777018801993,-0.611019002557768,
  -8.10648815107173e-05,0.00257480690254752,0.380282349605291,-0.636215302035643,
  -8.29625930941491e-05,0.00309061746831718,0.39279451119065,-0.661411601513519,
  -8.48603046766927e-05,0.00360642803408773,0.40530667277601,-0.686607900991394,
  -8.67580162601245e-05,0.00412223859985694,0.41781883436137,-0.71180420046927,
  -8.86557278433342e-05,0.00463804916562705,0.43033099594673,-0.737000499947145,
  -3.63868331456629e-05,-0.00713947377690205,0.127742968489222,-0.134359797139464,
  -3.77790412184609e-05,-0.00667232986491384,0.139678744397291,-0.159936886144286,
  -3.91712492913698e-05,-0.00620518595292563,0.15161452030536,-0.185513975149108,
  -4.05634573641955e-05,-0.00573804204093731,0.163550296213429,-0.21109106415393,
  -4.19556654374653e-05,-0.00527089812894943,0.175486072121498,-0.236668153158752,
  -4.33478735101245e-05,-0.00480375421696089,0.187421848029568,-0.262245242163574,
  -4.47400815835053e-05,-0.00433661030497334,0.199357623937637,-0.287822331168396,
  -4.61322896562755e-05,-0.00386946639298502,0.211293399845706,-0.313399420173218,
  -4.75244977292677e-05,-0.00340232248099692,0.223229175753775,-0.33897650917804,
  -4.89167058019824e-05,-0.00293517856900838,0.235164951661845,-0.364553598182862,
  -5.03089138752522e-05,-0.0024680346570205,0.247100727569914,-0.390130687187684,
  -5.17011219481889e-05,-0.00200089074503262,0.259036503477983,-0.415707776192506,
  -5.30933300211256e-05,-0.00153374683304408,0.270972279386053,-0.441284865197328,
  -5.44855380941733e-05,-0.0010666029210562,0.282908055294122,-0.46686195420215,
  -5.58777461671101e-05,-0.000599459009068326,0.294843831202191,-0.492439043206972,
  -5.72699542398247e-05,-0.000132315097079561,0.30677960711026,-0.518016132211794,
  -5.86621623130945e-05,0.000334828814908095,0.318715383018329,-0.543593221216616,
  -6.00543703859202e-05,0.000801972726896416,0.330651158926399,-0.569170310221438,
  -6.1446578459079e-05,0.00126911663888407,0.342586934834467,-0.59474739922626,
  -6.28387865322377e-05,0.00173626055087217,0.354522710742537,-0.620324488231082,
  -6.42309946051745e-05,0.00220340446286027,0.366458486650606,-0.645901577235904,
  -6.56232026785553e-05,0.00267054837484748,0.378394262558675,-0.671478666240726,
  -6.70154107510479e-05,0.00313769228683647,0.390330038466744,-0.697055755245548,
  -6.84076188239846e-05,0.00360483619882501,0.402265814374814,-0.72263284425037,
  -6.97998268970323e-05,0.00407198011081267,0.414201590282883,-0.748209933255191,
  -2.98635966270167e-05,-0.0065938869575296,0.125492570526292,-0.136341083487356,
  -3.08332553230206e-05,-0.00617936697725818,0.136867013534308,-0.162282557268965,
  -3.18029140187748e-05,-0.00576484699698687,0.148241456542323,-0.188224031050575,
  -3.27725727150008e-05,-0.00535032701671589,0.159615899550339,-0.214165504832184,
  -3.37422314108382e-05,-0.00493580703644436,0.170990342558355,-0.240106978613793,
  -3.47118901066756e-05,-0.00452128705617283,0.182364785566371,-0.266048452395403,
  -3.56815488028461e-05,-0.00410676707590207,0.193739228574386,-0.291989926177012,
  -3.66512074982395e-05,-0.00369224709562976,0.205113671582402,-0.317931399958621,
  -3.76208661945765e-05,-0.00327772711535901,0.216488114590418,-0.343872873740231,
  -3.85905248906915e-05,-0.00286320713508803,0.227862557598434,-0.36981434752184,
  -3.95601835864179e-05,-0.00244868715481639,0.239237000606449,-0.395755821303449,
  -4.05298422825329e-05,-0.00203416717454519,0.250611443614465,-0.421697295085058,
  -4.14995009785368e-05,-0.00161964719427399,0.261985886622481,-0.447638768866668,
  -4.24691596747628e-05,-0.00120512721400279,0.273360329630497,-0.473580242648277,
  -4.34388183704337e-05,-0.00079060723373181,0.284734772638512,-0.499521716429886,
  -4.44084770662156e-05,-0.000376087253459501,0.296109215646529,-0.525463190211496,
  -4.53781357624417e-05,3.84327268108109e-05,0.307483658654544,-0.551404663993105,
  -4.63477944582236e-05,0.000452952707082455,0.31885810166256,-0.577346137774714,
  -4.73174531544496e-05,0.000867472687353654,0.330232544670576,-0.603287611556324,
  -4.82871118500094e-05,0.00128199266762508,0.341606987678591,-0.629229085337933,
  -4.92567705456803e-05,0.00169651264789694,0.352981430686607,-0.655170559119542,
  -5.02264292421284e-05,0.00211103262816748,0.364355873694623,-0.681112032901152,
  -5.11960879381324e-05,0.00252555260843934,0.375730316702639,-0.707053506682761,
  -5.21657466340253e-05,0.00294007258871032,0.387104759710655,-0.73299498046437,
  -5.31354053298072e-05,0.00335459256898218,0.398479202718671,-0.75893645424598,
  -2.38714405217944e-05,-0.00612474157325127,0.12340583332653,-0.138138670353154,
  -2.45149233846498e-05,-0.00576310787245682,0.134262714435169,-0.164410744145986,
  -2.51584062475607e-05,-0.00540147417166226,0.145119595543808,-0.190682817938819,
  -2.58018891103884e-05,-0.00503984047086781,0.155976476652448,-0.216954891731652,
  -2.64453719731605e-05,-0.00467820677007325,0.166833357761087,-0.243226965524484,
  -2.70888548359327e-05,-0.00431657306927857,0.177690238869726,-0.269499039317317,
  -2.77323376986494e-05,-0.0039549393684839,0.188547119978366,-0.295771113110149,
  -2.8375820561477e-05,-0.00359330566768934,0.199404001087005,-0.322043186902982,
  -2.90193034245267e-05,-0.00323167196689522,0.210260882195644,-0.348315260695815,
  -2.96627862874654e-05,-0.00287003826610088,0.221117763304283,-0.374587334488647,
  -3.03062691501821e-05,-0.00250840456530632,0.231974644412922,-0.40085940828148,
  -3.09497520128987e-05,-0.00214677086451154,0.242831525521562,-0.427131482074312,
  -3.15932348756709e-05,-0.00178513716371698,0.253688406630201,-0.453403555867145,
  -3.2236717738332e-05,-0.00142350346292197,0.264545287738841,-0.479675629659977,
  -3.28802006013262e-05,-0.00106186976212808,0.275402168847479,-0.50594770345281,
  -3.35236834638764e-05,-0.000700236061333293,0.286259049956119,-0.532219777245643,
  -3.41671663269816e-05,-0.000338602360539397,0.297115931064758,-0.558491851038475,
  -3.48106491898648e-05,2.30313402553861e-05,0.307972812173397,-0.584763924831308,
  -3.54541320526369e-05,0.000384665041049725,0.318829693282036,-0.61103599862414,
  -3.60976149156311e-05,0.000746298741844509,0.329686574390676,-0.637308072416973,
  -3.67410977779592e-05,0.00110793244263974,0.340543455499315,-0.663580146209806,
  -3.73845806413975e-05,0.00146956614343319,0.351400336607954,-0.689852220002638,
  -3.80280635043917e-05,0.00183119984422753,0.362257217716593,-0.716124293795471,
  -3.86715463659426e-05,0.00219283354502364,0.373114098825233,-0.742396367588303,
  -3.93150292291589e-05,0.00255446724581754,0.383970979933872,-0.768668441381136,
  -1.86366938105809e-05,-0.00573912733790094,0.121567614308078,-0.139692465084808,
  -1.90462613730846e-05,-0.00542716192069048,0.131970783245955,-0.166250302289411,
  -1.94558289357549e-05,-0.00511519650348025,0.142373952183832,-0.192808139494014,
  -1.9865396498453e-05,-0.00480323108627001,0.152777121121708,-0.219365976698617,
  -2.0274964060929e-05,-0.00449126566905966,0.163180290059585,-0.24592381390322,
  -2.0684531623516e-05,-0.00417930025184954,0.173583458997461,-0.272481651107823,
  -2.1094099185881e-05,-0.00386733483463853,0.183986627935338,-0.299039488312425,
  -2.1503666748357e-05,-0.00355536941742818,0.194389796873215,-0.325597325517028,
  -2.19132343111106e-05,-0.00324340400021828,0.204792965811091,-0.352155162721631,
  -2.23228018736976e-05,-0.00293143858300771,0.215196134748968,-0.378712999926234,
  -2.27323694361736e-05,-0.00261947316579736,0.225599303686844,-0.405270837130837,
  -2.31419369985941e-05,-0.00230750774858701,0.236002472624721,-0.43182867433544,
  -2.35515045611256e-05,-0.00199554233137622,0.246405641562598,-0.458386511540042,
  -2.39610721237682e-05,-0.00168357691416698,0.256808810500474,-0.484944348744645,
  -2.43706396862997e-05,-0.00137161149695619,0.267211979438351,-0.511502185949248,
  -2.47802072484982e-05,-0.00105964607974518,0.277615148376227,-0.538060023153851,
  -2.51897748111407e-05,-0.000747680662535055,0.288018317314104,-0.564617860358454,
  -2.55993423736722e-05,-0.000435715245324486,0.298421486251981,-0.591175697563057,
  -2.60089099364258e-05,-0.000123749828114139,0.308824655189857,-0.617733534767659,
  -2.64184774992904e-05,0.000188215589095542,0.319227824127734,-0.644291371972262,
  -2.68280450617109e-05,0.000500181006305667,0.32963099306561,-0.670849209176865,
  -2.72376126240204e-05,0.00081214642351668,0.340034162003487,-0.697407046381468,
  -2.76471801867739e-05,0.0011241118407268,0.350437330941364,-0.723964883586071,
  -2.80567477494165e-05,0.00143607725793737,0.36084049987924,-0.750522720790674,
  -2.84663153122811e-05,0.0017480426751475,0.371243668817117,-0.777080557995277,
  -1.4260055230586e-05,-0.00543356155125818,0.120019828200091,-0.140980278113756,
  -1.45122872499681e-05,-0.00516554912953837,0.130042494802027,-0.167774961175394,
  -1.47645192689616e-05,-0.0048975367078179,0.140065161403963,-0.194569644237031,
  -1.50167512882882e-05,-0.00462952428609797,0.150087828005898,-0.221364327298668,
  -1.52689833078923e-05,-0.00436151186437828,0.160110494607834,-0.248159010360306,
  -1.55212153267748e-05,-0.0040934994426578,0.17013316120977,-0.274953693421943,
  -1.57734473457127e-05,-0.00382548702093755,0.180155827811705,-0.30174837648358,
  -1.60256793652613e-05,-0.00355747459921774,0.190178494413641,-0.328543059545217,
  -1.62779113848099e-05,-0.00328946217749815,0.200201161015577,-0.355337742606855,
  -1.653014340397e-05,-0.00302144975577789,0.210223827617513,-0.382132425668492,
  -1.67823754227414e-05,-0.00275343733405742,0.220246494219448,-0.408927108730129,
  -1.703460744229e-05,-0.00248542491233761,0.230269160821384,-0.435721791791767,
  -1.7286839461228e-05,-0.00221741249061735,0.240291827423319,-0.462516474853404,
  -1.75390714806101e-05,-0.00194940006889754,0.250314494025255,-0.489311157915041,
  -1.77913034997701e-05,-0.00168138764717707,0.260337160627191,-0.516105840976678,
  -1.80435355188191e-05,-0.00141337522545681,0.270359827229127,-0.542900524038316,
  -1.82957675384232e-05,-0.00114536280373745,0.280382493831062,-0.569695207099953,
  -1.85479995576943e-05,-0.000877350382017195,0.290405160432998,-0.59648989016159,
  -1.88002315768543e-05,-0.000609337960297385,0.300427827034933,-0.623284573223228,
  -1.90524635962364e-05,-0.000341325538577575,0.310450493636869,-0.650079256284865,
  -1.93046956153964e-05,-7.33131168568768e-05,0.320473160238805,-0.676873939346502,
  -1.95569276342233e-05,0.000194699304863377,0.330495826840741,-0.703668622408139,
  -1.98091596533834e-05,0.000462711726583187,0.340518493442676,-0.730463305469777,
  -2.00613916727654e-05,0.000730724148303885,0.350541160044612,-0.757257988531414,
  -2.03136236925916e-05,0.000998736570022807,0.360563826646548,-0.784052671593051,
  -1.07328730314382e-05,-0.00519819406153044,0.118765218956076,-0.142010988540715,
  -1.08846820860431e-05,-0.00496718408670926,0.128480436889489,-0.168995232888765,
  -1.1036491140648e-05,-0.00473617411188787,0.138195654822903,-0.195979477236816,
  -1.11883001951973e-05,-0.0045051641370667,0.147910872756316,-0.222963721584867,
  -1.13401092496357e-05,-0.00427415416224508,0.15762609068973,-0.249947965932917,
  -1.14919183045181e-05,-0.00404314418742424,0.167341308623143,-0.276932210280968,
  -1.16437273588454e-05,-0.00381213421260274,0.177056526556556,-0.303916454629019,
  -1.17955364132283e-05,-0.00358112423778101,0.18677174448997,-0.330900698977069,
  -1.19473454683883e-05,-0.00335011426296039,0.196486962423383,-0.35788494332512,
  -1.20991545226046e-05,-0.00311910428813889,0.206202180356796,-0.384869187673171,
  -1.22509635775425e-05,-0.00288809431331805,0.215917398290209,-0.411853432021221,
  -1.24027726319254e-05,-0.00265708433849654,0.225632616223623,-0.438837676369272,
  -1.25545816863637e-05,-0.00242607436367481,0.235347834157037,-0.465821920717322,
  -1.27063907413572e-05,-0.0021950643888542,0.24506305209045,-0.492806165065373,
  -1.28581997957955e-05,-0.00196405441403269,0.254778270023863,-0.519790409413424,
  -1.30100088499008e-05,-0.00173304443921074,0.264493487957277,-0.546774653761474,
  -1.31618179046722e-05,-0.0015020344643899,0.27420870589069,-0.573758898109525,
  -1.33136269595546e-05,-0.00127102448956906,0.283923923824103,-0.600743142457575,
  -1.3465436014215e-05,-0.00104001451474733,0.293639141757517,-0.627727386805626,
  -1.36172450683203e-05,-0.000809004539925162,0.30335435969093,-0.654711631153677,
  -1.37690541234248e-05,-0.000577994565105211,0.313069577624343,-0.681695875501727,
  -1.39208631779741e-05,-0.000346984590283483,0.322784795557757,-0.708680119849778,
  -1.40726722323015e-05,-0.0001159746154622,0.33250001349117,-0.735664364197829,
  -1.42244812871839e-05,0.000115035359359084,0.342215231424584,-0.762648608545879,
  -1.43762903414002e-05,0.000346045334179923,0.351930449357996,-0.78963285289393,
  -7.97329846330408e-06,-0.0050206983726272,0.117779134256373,-0.142813096422442,
  -8.06351369583846e-06,-0.00481960848891561,0.127253302217248,-0.169944859023851,
  -8.15372892820632e-06,-0.00461851860520368,0.136727470178124,-0.197076621625259,
  -8.24394416065743e-06,-0.00441742872149198,0.146201638138999,-0.224208384226668,
  -8.33415939338611e-06,-0.00421633883778072,0.155675806099874,-0.251340146828076,
  -8.42437462572621e-06,-0.00401524895406868,0.16514997406075,-0.278471909429485,
  -8.51458985817732e-06,-0.00381415907035687,0.174624142021625,-0.305603672030893,
  -8.60480509079498e-06,-0.00361306918664561,0.1840983099825,-0.332735434632302,
  -8.69502032330161e-06,-0.00341197930293369,0.193572477943376,-0.35986719723371,
  -8.78523555536415e-06,-0.00321088941922154,0.203046645904251,-0.386998959835118,
  -8.87545078837038e-06,-0.00300979953551028,0.212520813865127,-0.414130722436527,
  -8.96566602048843e-06,-0.00280870965179836,0.221994981826002,-0.441262485037935,
  -9.05588125266199e-06,-0.00260761976808599,0.231469149786878,-0.468394247639344,
  -9.14609648561271e-06,-0.00240652988437517,0.240943317747753,-0.495526010240752,
  -9.23631171811934e-06,-0.00220544000066347,0.250417485708628,-0.522657772842161,
  -9.32652695018188e-06,-0.0020043501169511,0.259891653669504,-0.549789535443569,
  -9.41674218302158e-06,-0.00180326023324007,0.269365821630379,-0.576921298044978,
  -9.50695741586127e-06,-0.00160217034952836,0.278839989591254,-0.604053060646386,
  -9.59717264825688e-06,-0.00140108046581622,0.28831415755213,-0.631184823247794,
  -9.68738788065249e-06,-0.00119999058210496,0.297788325513005,-0.658316585849203,
  -9.77760311282605e-06,-0.000998900698392813,0.30726249347388,-0.685448348450612,
  -9.86781834555472e-06,-0.00079781081468111,0.316736661434756,-0.71258011105202,
  -9.95803357817238e-06,-0.000596720930969408,0.326210829395632,-0.739711873653428,
  -1.00482488109011e-05,-0.000395631047258593,0.335684997356506,-0.766843636254837,
  -1.01384640428526e-05,-0.000194541163546003,0.345159165317382,-0.793975398856246,
  -5.86381318926077e-06,-0.00488889587612285,0.117022668274179,-0.143423778154074,
  -5.91727077381421e-06,-0.0047112464395086,0.126312262852083,-0.170667853206788,
  -5.97072835856194e-06,-0.00453359700289468,0.135601857429986,-0.197911928259501,
  -6.02418594308762e-06,-0.00435594756628055,0.144891452007889,-0.225156003312214,
  -6.07764352777984e-06,-0.0041782981296663,0.154181046585792,-0.252400078364928,
  -6.13110111252757e-06,-0.00400064869305228,0.163470641163695,-0.279644153417641,
  -6.18455869710877e-06,-0.00382299925643825,0.172760235741598,-0.306888228470355,
  -6.23801628163445e-06,-0.0036453498198239,0.182049830319502,-0.334132303523068,
  -6.29147386627116e-06,-0.0034677003832102,0.191339424897405,-0.361376378575781,
  -6.34493145068582e-06,-0.0032900509465954,0.200629019475308,-0.388620453628495,
  -6.39838903576662e-06,-0.00311240150998193,0.209918614053211,-0.415864528681208,
  -6.45184662007026e-06,-0.00293475207336735,0.219208208631115,-0.443108603733922,
  -6.50530420442941e-06,-0.00275710263675299,0.228497803209018,-0.470352678786635,
  -6.55876178967674e-06,-0.00257945320013953,0.237787397786921,-0.497596753839348,
  -6.61221937381384e-06,-0.00240180376352517,0.247076992364824,-0.524840828892062,
  -6.66567695839504e-06,-0.00222415432691059,0.256366586942728,-0.552084903944775,
  -6.71913454353135e-06,-0.00204650489029734,0.26565618152063,-0.579328978997489,
  -6.77259212755743e-06,-0.00186885545368232,0.274945776098534,-0.606573054050202,
  -6.82604971236067e-06,-0.0016912060170684,0.284235370676437,-0.633817129102916,
  -6.87950729705289e-06,-0.00151355658045382,0.293524965254341,-0.661061204155629,
  -6.93296488174511e-06,-0.00133590714384058,0.302814559832243,-0.688305279208342,
  -6.98642246665937e-06,-0.00115825770722644,0.312104154410147,-0.715549354261056,
  -7.03988005135159e-06,-0.000980608270612304,0.32139374898805,-0.742793429313769,
  -7.09333763571074e-06,-0.000802958833997724,0.330683343565954,-0.770037504366483,
  -7.14679521995887e-06,-0.000625309397383145,0.339972938143857,-0.797281579419196,
  -4.27964828755845e-06,-0.00479210159281818,0.116453052555298,-0.143881008226318,
  -4.31151111096595e-06,-0.00463237697131769,0.125603858447749,-0.171209173939623,
  -4.34337393440121e-06,-0.00447265234981753,0.134754664340201,-0.198537339652928,
  -4.37523675778095e-06,-0.00431292772831715,0.143905470232653,-0.225865505366233,
  -4.40709958121621e-06,-0.00415320310681677,0.153056276125104,-0.253193671079537,
  -4.43896240476249e-06,-0.00399347848531673,0.162207082017556,-0.280521836792842,
  -4.47082522814224e-06,-0.00383375386381624,0.171357887910008,-0.307850002506147,
  -4.5026880515775e-06,-0.00367402924231608,0.180508693802459,-0.335178168219452,
  -4.53455087517929e-06,-0.00351430462081592,0.189659499694911,-0.362506333932757,
  -4.56641369855904e-06,-0.00335457999931554,0.198810305587362,-0.389834499646062,
  -4.59827652221634e-06,-0.00319485537781539,0.207961111479814,-0.417162665359367,
  -4.63013934548506e-06,-0.00303513075631501,0.217111917372266,-0.444490831072671,
  -4.66200216919788e-06,-0.00287540613481552,0.226262723264717,-0.471818996785977,
  -4.69386499224456e-06,-0.00271568151331381,0.235413529157169,-0.499147162499281,
  -4.72572781595737e-06,-0.00255595689181431,0.24456433504962,-0.526475328212586,
  -4.75759063889303e-06,-0.00239623227031349,0.253715140942072,-0.553803493925891,
  -4.78945346271686e-06,-0.00223650764881378,0.262865946834523,-0.581131659639196,
  -4.82131628631866e-06,-0.00207678302731362,0.272016752726975,-0.608459825352501,
  -4.85317910980942e-06,-0.00191705840581324,0.281167558619427,-0.635787991065806,
  -4.88504193318917e-06,-0.0017573337843122,0.290318364511879,-0.66311615677911,
  -4.91690475667994e-06,-0.00159760916281293,0.29946917040433,-0.690444322492415,
  -4.94876757994867e-06,-0.00143788454131233,0.308619976296781,-0.71777248820572,
  -4.98063040299535e-06,-0.00127815991981128,0.317770782189233,-0.745100653919025,
  -5.01249322704123e-06,-0.00111843529831246,0.326921588081684,-0.77242881963233,
  -5.04435604997688e-06,-0.000958710676811414,0.336072393974136,-0.799756985345635,
  -3.10574873518821e-06,-0.00472157448926613,0.116030106103755,-0.144219077599153,
  -3.12498907284464e-06,-0.00457530959310426,0.125077966126535,-0.171609418743631,
  -3.14422941033454e-06,-0.00442904469694194,0.134125826149315,-0.19899975988811,
  -3.16346974793547e-06,-0.00428277980078007,0.143173686172094,-0.226390101032589,
  -3.18271008570292e-06,-0.00413651490461797,0.152221546194874,-0.253780442177068,
  -3.20195042313731e-06,-0.00399025000845588,0.161269406217654,-0.281170783321546,
  -3.22119076090477e-06,-0.003843985112294,0.170317266240434,-0.308561124466025,
  -3.24043109861671e-06,-0.00369772021613213,0.179365126263213,-0.335951465610504,
  -3.2596714360511e-06,-0.00355145531997003,0.188412986285993,-0.363341806754983,
  -3.27891177376305e-06,-0.00340519042380794,0.197460846308773,-0.390732147899461,
  -3.29815211125295e-06,-0.00325892552764584,0.206508706331552,-0.41812248904394,
  -3.31739244885387e-06,-0.00311266063148352,0.215556566354332,-0.445512830188419,
  -3.33663278639929e-06,-0.00296639573532165,0.224604426377112,-0.472903171332897,
  -3.3558731239447e-06,-0.00282013083915955,0.233652286399891,-0.500293512477376,
  -3.37511346182318e-06,-0.00267386594299812,0.242700146422671,-0.527683853621855,
  -3.39435379925757e-06,-0.0025276010468358,0.25174800644545,-0.555074194766334,
  -3.41359413669196e-06,-0.00238133615067326,0.260795866468231,-0.582464535910813,
  -3.43283447412635e-06,-0.00223507125451139,0.26984372649101,-0.609854877055291,
  -3.45207481278198e-06,-0.0020888063583504,0.27889158651379,-0.63724521819977,
  -3.47131515021637e-06,-0.00194254146218809,0.287939446536569,-0.664635559344249,
  -3.49055548765076e-06,-0.00179627656602577,0.296987306559349,-0.692025900488727,
  -3.50979582541822e-06,-0.00165001166986434,0.306035166582128,-0.719416241633206,
  -3.52903616240852e-06,-0.00150374677370069,0.315083026604909,-0.746806582777685,
  -3.54827650017597e-06,-0.00135748187754015,0.324130886627688,-0.774196923922164,
  -3.56751683794343e-06,-0.00121121698137738,0.333178746650468,-0.801587265066642,
  -2.24442413485071e-06,-0.00467047220604022,0.115719317089902,-0.144466729416384,
  -2.25625542663033e-06,-0.00453417860675587,0.12469158770153,-0.171902617007109,
  -2.26808671810463e-06,-0.00439788500747085,0.133663858313158,-0.199338504597833,
  -2.27991800971772e-06,-0.00426159140818638,0.142636128924786,-0.226774392188558,
  -2.2917493013308e-06,-0.00412529780890181,0.151608399536414,-0.254210279779283,
  -2.30358059283287e-06,-0.00398900420961679,0.160580670148042,-0.281646167370008,
  -2.31541188433493e-06,-0.00385271061033232,0.16955294075967,-0.309082054960733,
  -2.32724317605904e-06,-0.00371641701104752,0.178525211371299,-0.336517942551458,
  -2.33907446739456e-06,-0.00358012341176273,0.187497481982927,-0.363953830142183,
  -2.35090575911867e-06,-0.00344382981247815,0.196469752594555,-0.391389717732908,
  -2.36273705034318e-06,-0.00330753621319291,0.205442023206184,-0.418825605323633,
  -2.37456834206728e-06,-0.00317124261390833,0.214414293817812,-0.446261492914358,
  -2.38639963390241e-06,-0.0030349490146242,0.22338656442944,-0.473697380505083,
  -2.3982309255155e-06,-0.00289865541533918,0.232358835041068,-0.501133268095808,
  -2.41006221624041e-06,-0.00276236181605372,0.241331105652696,-0.528569155686533,
  -2.42189350818656e-06,-0.00262606821676936,0.250303376264325,-0.556005043277258,
  -2.43372479991066e-06,-0.00248977461748501,0.259275646875953,-0.583440930867983,
  -2.44555609141273e-06,-0.00235348101820021,0.268247917487581,-0.610876818458708,
  -2.45738738324786e-06,-0.00221718741891586,0.277220188099209,-0.638312706049433,
  -2.46921867474992e-06,-0.00208089381963106,0.286192458710837,-0.665748593640157,
  -2.48104996558585e-06,-0.00194460022034537,0.295164729322466,-0.693184481230882,
  -2.492881257532e-06,-0.00180830662106102,0.304136999934094,-0.720620368821607,
  -2.50471254914508e-06,-0.00167201302177711,0.313109270545721,-0.748056256412333,
  -2.51654384053612e-06,-0.00153571942249142,0.32208154115735,-0.775492144003057,
  -2.5283751325933e-06,-0.00139942582320751,0.331053811768978,-0.802928031593782,
  -1.61701508455403e-06,-0.00463359054262125,0.115492685151383,-0.144646913928178,
  -1.62444550891316e-06,-0.00450461101635524,0.124409865127504,-0.172115939834917,
  -1.63187593338332e-06,-0.00437563149008913,0.133327045103625,-0.199584965741655,
  -1.63930635782572e-06,-0.00424665196382312,0.142244225079746,-0.227053991648394,
  -1.64673678221261e-06,-0.00411767243755701,0.151161405055867,-0.254523017555133,
  -1.65416720676603e-06,-0.00398869291129123,0.160078585031988,-0.281992043461872,
  -1.66159763098639e-06,-0.00385971338502467,0.16899576500811,-0.309461069368611,
  -1.66902805531777e-06,-0.00373073385875888,0.17791294498423,-0.33693009527535,
  -1.67645847970466e-06,-0.00360175433249266,0.186830124960351,-0.364399121182089,
  -1.68388890409155e-06,-0.00347277480622621,0.195747304936473,-0.391868147088828,
  -1.69131932875599e-06,-0.00334379527996087,0.204664484912593,-0.419337172995567,
  -1.69874975308737e-06,-0.00321481575369464,0.213581664888715,-0.446806198902306,
  -1.70618017758528e-06,-0.00308583622742886,0.222498844864835,-0.474275224809045,
  -1.71361060208319e-06,-0.00295685670116286,0.231416024840956,-0.501744250715784,
  -1.72104102613702e-06,-0.00282787717489619,0.240333204817078,-0.529213276622522,
  -1.72847145074595e-06,-0.00269889764863018,0.249250384793199,-0.556682302529261,
  -1.73590187513284e-06,-0.0025699181223644,0.25816756476932,-0.584151328436,
  -1.74333229963075e-06,-0.0024409385960984,0.267084744745441,-0.611620354342739,
  -1.7507627237956e-06,-0.00231195906983217,0.276001924721561,-0.639089380249478,
  -1.75819314807146e-06,-0.00218297954356572,0.284919104697683,-0.666558406156217,
  -1.76562357279142e-06,-0.00205400001730016,0.293836284673804,-0.694027432062956,
  -1.77305399695626e-06,-0.00192502049103371,0.302753464649925,-0.721496457969695,
  -1.78048442101009e-06,-0.00179604096476726,0.311670644626046,-0.748965483876434,
  -1.78791484584107e-06,-0.0016670614385017,0.320587824602167,-0.776434509783173,
  -1.79534527022795e-06,-0.0015380819122357,0.329505004578288,-0.803903535689912,
  -1.16240584427385e-06,-0.00460704651822252,0.115328342070984,-0.144777362090541,
  -1.16717554787815e-06,-0.00448339330890912,0.124205588726908,-0.172270379140496,
  -1.17194525128816e-06,-0.00435974009959517,0.133082835382833,-0.199763396190452,
  -1.1767149548092e-06,-0.00423608689028143,0.141960082038757,-0.227256413240407,
  -1.18148465860779e-06,-0.00411243368096836,0.150837328694681,-0.254749430290363,
  -1.18625436212882e-06,-0.00398878047165452,0.159714575350606,-0.282242447340318,
  -1.19102406553884e-06,-0.00386512726234067,0.168591822006531,-0.309735464390273,
  -1.19579376944845e-06,-0.00374147405302749,0.177469068662455,-0.337228481440229,
  -1.20056347291397e-06,-0.00361782084371387,0.186346315318379,-0.364721498490184,
  -1.20533317649052e-06,-0.00349416763440002,0.195223561974304,-0.39221451554014,
  -1.21010288028911e-06,-0.00337051442508707,0.204100808630228,-0.419707532590095,
  -1.21487258364361e-06,-0.00324686121577322,0.212978055286152,-0.44720054964005,
  -1.21964228705362e-06,-0.00312320800645915,0.221855301942077,-0.474693566690006,
  -1.22441199090773e-06,-0.00299955479714575,0.230732548598002,-0.502186583739961,
  -1.22918169453978e-06,-0.00287590158783235,0.239609795253926,-0.529679600789916,
  -1.23395139783877e-06,-0.00275224837851806,0.248487041909851,-0.557172617839872,
  -1.23872110158185e-06,-0.00262859516920511,0.257364288565775,-0.584665634889827,
  -1.24349080532493e-06,-0.00250494195989193,0.266241535221699,-0.612158651939783,
  -1.24826050884597e-06,-0.00238128875057786,0.275118781877624,-0.639651668989738,
  -1.25303021247802e-06,-0.00225763554126424,0.283996028533548,-0.667144686039693,
  -1.25779991599906e-06,-0.00213398233195061,0.292873275189473,-0.694637703089649,
  -1.26256961985316e-06,-0.00201032912263743,0.301750521845397,-0.722130720139604,
  -1.26733932326317e-06,-0.00188667591332292,0.310627768501322,-0.749623737189559,
  -1.27210902689523e-06,-0.00176302270401019,0.319505015157246,-0.777116754239515,
  -1.27687873019422e-06,-0.00163936949469612,0.328382261813171,-0.80460977128947,
  -8.73291886486771e-05,-0.0127624485212806,0.151902411475711,-0.127284967931506,
  -9.34580568415777e-05,-0.0120993984572826,0.16758783910667,-0.149638100422294,
  -9.95869250347003e-05,-0.0114363483932849,0.183273266737629,-0.171991232913083,
  -0.000105715793227823,-0.0107732983292872,0.198958694368588,-0.194344365403871,
  -0.000111844661420668,-0.0101102482652893,0.214644121999547,-0.216697497894659,
  -0.000117973529613624,-0.0094471982012917,0.230329549630505,-0.239050630385448,
  -0.000124102397806525,-0.00878414813729345,0.246014977261465,-0.261403762876236,
  -0.000130231265999703,-0.00812109807329597,0.261700404892424,-0.283756895367024,
  -0.000136360134192937,-0.0074580480092985,0.277385832523382,-0.306110027857813,
  -0.000142489002385615,-0.00679499794530014,0.293071260154341,-0.328463160348601,
  -0.000148617870578516,-0.00613194788130222,0.3087566877853,-0.350816292839389,
  -0.000154746738771361,-0.00546889781730409,0.32444211541626,-0.373169425330177,
  -0.000160875606964317,-0.00480584775330617,0.340127543047218,-0.395522557820966,
  -0.000167004475157606,-0.0041427976893087,0.355812970678177,-0.417875690311754,
  -0.00017313334335034,-0.00347974762531078,0.371498398309136,-0.440228822802542,
  -0.000179262211543407,-0.00281669756131331,0.387183825940095,-0.462581955293331,
  -0.000185391079736252,-0.00215364749731495,0.402869253571054,-0.484935087784119,
  -0.000191519947929319,-0.00149059743331703,0.418554681202013,-0.507288220274907,
  -0.000197648816121943,-0.000827547369319115,0.434240108832972,-0.529641352765695,
  -0.000203777684315898,-0.000164497305322531,0.449925536463931,-0.551994485256484,
  -0.000209906552507744,0.00049855275867694,0.46561096409489,-0.574347617747272,
  -0.000216035420701588,0.0011616028226733,0.481296391725848,-0.596700750238061,
  -0.0002221642888941,0.00182465288667188,0.496981819356807,-0.619053882728849,
  -0.000228293157086945,0.00248770295067002,0.512667246987767,-0.641407015219637,
  -0.000234422025280234,0.00315075301466727,0.528352674618725,-0.663760147710425,
  -8.656088771547e-05,-0.0126556753030974,0.151651922568162,-0.127555576576485,
  -9.25941748554093e-05,-0.0119932199685446,0.1672765765241,-0.149954550029706,
  -9.86274619952376e-05,-0.0113307646339917,0.182901230480038,-0.172353523482928,
  -0.000104660749135455,-0.0106683092994392,0.198525884435976,-0.194752496936149,
  -0.000110694036275394,-0.0100058539648865,0.214150538391914,-0.217151470389371,
  -0.000116727323415555,-0.00934339863033407,0.229775192347852,-0.239550443842592,
  -0.000122760610555384,-0.00868094329578128,0.24539984630379,-0.261949417295814,
  -0.000128793897695378,-0.00801848796122862,0.261024500259728,-0.284348390749035,
  -0.00013482718483554,-0.00735603262667617,0.276649154215666,-0.306747364202256,
  -0.000140860471975313,-0.00669357729212283,0.292273808171605,-0.329146337655478,
  -0.000146893759115585,-0.00603112195757061,0.307898462127543,-0.351545311108699,
  -0.000152927046255469,-0.00536866662301794,0.323523116083481,-0.373944284561921,
  -0.000158960333395464,-0.00470621128846505,0.339147770039419,-0.396343258015142,
  -0.000164993620535681,-0.0040437559539126,0.354772423995357,-0.418742231468364,
  -0.000171026907675897,-0.00338130061936015,0.370397077951295,-0.441141204921585,
  -0.000177060194815448,-0.00271884528480704,0.386021731907233,-0.463540178374807,
  -0.000183093481955776,-0.00205638995025481,0.401646385863171,-0.485939151828028,
  -0.000189126769095771,-0.00139393461570192,0.417271039819109,-0.508338125281249,
  -0.000195160056235766,-0.000731479281149472,0.432895693775047,-0.530737098734471,
  -0.000201193343375428,-6.90239465961362e-05,0.448520347730985,-0.553136072187692,
  -0.000207226630516311,0.000593431387955423,0.464145001686923,-0.575535045640914,
  -0.000213259917655639,0.0012558867225092,0.479769655642861,-0.597934019094135,
  -0.000219293204796189,0.00191834205706076,0.495394309598799,-0.620332992547356,
  -0.000225326491934852,0.00258079739161543,0.511018963554738,-0.642731966000578,
  -0.000231359779075513,0.00324325272616699,0.526643617510675,-0.665130939453799,
  -8.55080122962038e-05,-0.0125105253220902,0.151308041069526,-0.127925490462723,
  -9.14113310258036e-05,-0.0118490322212319,0.166849370103956,-0.150387127134128,
  -9.73146497552646e-05,-0.0111875391203735,0.182390699138386,-0.172848763805533,
  -0.000103217968484504,-0.0105260460195149,0.197932028172816,-0.195310400476937,
  -0.000109121287213965,-0.00986455291865618,0.213473357207247,-0.217772037148342,
  -0.000115024605943592,-0.00920305981779801,0.229014686241677,-0.240233673819746,
  -0.000120927924672942,-0.00854156671693929,0.244556015276107,-0.262695310491151,
  -0.000126831243402625,-0.00788007361608134,0.260097344310537,-0.285156947162556,
  -0.000132734562131809,-0.00721858051522228,0.275638673344968,-0.30761858383396,
  -0.000138637880861492,-0.00655708741436434,0.291180002379398,-0.330080220505365,
  -0.000144541199591286,-0.00589559431350595,0.306721331413828,-0.35254185717677,
  -0.000150444518320469,-0.00523410121264756,0.322262660448258,-0.375003493848174,
  -0.000156347837049875,-0.0045726081117885,0.337803989482688,-0.397465130519579,
  -0.000162251155779392,-0.00391111501093011,0.353345318517119,-0.419926767190984,
  -0.000168154474508686,-0.00324962191007194,0.368886647551548,-0.442388403862388,
  -0.000174057793238536,-0.00258812880921355,0.384427976585979,-0.464850040533793,
  -0.000179961111968385,-0.00192663570835561,0.399969305620409,-0.487311677205198,
  -0.000185864430697014,-0.00126514260749633,0.415510634654839,-0.509773313876602,
  -0.000191767749426863,-0.000603649506638604,0.431051963689269,-0.532234950548007,
  -0.000197671068156047,5.78435942206745e-05,0.4465932927237,-0.554696587219412,
  -0.000203574386886118,0.000719336695078177,0.462134621758129,-0.577158223890816,
  -0.000209477705615302,0.00138082979593701,0.47767595079256,-0.599619860562221,
  -0.000215381024344818,0.00204232289679496,0.493217279826989,-0.622081497233625,
  -0.000221284343074779,0.00270381599765335,0.50875860886142,-0.64454313390503,
  -0.000227187661803518,0.00336530909851263,0.52429993789585,-0.667004770576434,
  -8.40765343565752e-05,-0.0123153346921183,0.150839373759823,-0.128426721198822,
  -8.98050404665729e-05,-0.0116554206815792,0.166267338987168,-0.150973266093856,
  -9.55335465764873e-05,-0.0109955066710401,0.181695304214512,-0.173519810988889,
  -0.000101262052686402,-0.0103355926605008,0.197123269441857,-0.196066355883923,
  -0.000106990558796427,-0.00967567864996166,0.212551234669201,-0.218612900778957,
  -0.000112719064906508,-0.00901576463942277,0.227979199896546,-0.24115944567399,
  -0.000118447571016311,-0.00835585062888344,0.24340716512389,-0.263705990569024,
  -0.000124176077126781,-0.00769593661834467,0.258835130351235,-0.286252535464058,
  -0.000129904583236029,-0.007036022607805,0.274263095578579,-0.308799080359092,
  -0.000135633089346276,-0.00637610859726601,0.289691060805924,-0.331345625254125,
  -0.000141361595455747,-0.00571619458672634,0.305119026033268,-0.353892170149159,
  -0.000147090101566105,-0.00505628057618757,0.320546991260613,-0.376438715044193,
  -0.000152818607675909,-0.00439636656564857,0.335974956487957,-0.398985259939227,
  -0.000158547113785823,-0.00373645255510913,0.351402921715302,-0.42153180483426,
  -0.000164275619895626,-0.00307653854456991,0.366830886942646,-0.444078349729294,
  -0.000170004126005985,-0.00241662453403158,0.38225885216999,-0.466624894624328,
  -0.000175732632115233,-0.00175671052349102,0.397686817397336,-0.489171439519362,
  -0.000181461138225147,-0.00109679651295203,0.41311478262468,-0.511717984414395,
  -0.000187189644335728,-0.000436882502413471,0.428542747852024,-0.534264529309429,
  -0.000192918150445087,0.000223031508126414,0.443970713079369,-0.556811074204463,
  -0.000198646656555335,0.000882945518665412,0.459398678306714,-0.579357619099497,
  -0.000204375162665471,0.00154285952920397,0.474826643534058,-0.60190416399453,
  -0.000210103668775163,0.00220277353974385,0.490254608761402,-0.624450708889564,
  -0.000215832174885411,0.00286268755028196,0.505682573988746,-0.646997253784598,
  -0.000221560680994881,0.00352260156082229,0.521110539216092,-0.669543798679631,
  -8.21511521776341e-05,-0.0120566655294801,0.150206964936421,-0.129097847323293,
  -8.76479867296109e-05,-0.0113993623803532,0.165482313665983,-0.151758080631578,
  -9.31448212816988e-05,-0.0107420592312264,0.180757662395545,-0.174418313939864,
  -9.86416558337311e-05,-0.0100847560820992,0.196033011125107,-0.197078547248149,
  -0.000104138490385652,-0.00942745293297198,0.211308359854669,-0.219738780556434,
  -0.000109635324937685,-0.00877014978384527,0.226583708584231,-0.24239901386472,
  -0.000115132159489939,-0.00811284663471845,0.241859057313794,-0.265059247173005,
  -0.000120628994041971,-0.00745554348559141,0.257134406043356,-0.28771948048129,
  -0.000126125828593893,-0.00679824033646415,0.272409754772918,-0.310379713789576,
  -0.00013162266314598,-0.00614093718733755,0.28768510350248,-0.333039947097861,
  -0.00013711949769768,-0.00548363403821006,0.302960452232042,-0.355700180406146,
  -0.00014261633224999,-0.00482633088908324,0.318235800961604,-0.378360413714431,
  -0.000148113166802299,-0.00416902773995664,0.333511149691166,-0.401020647022717,
  -0.000153610001353832,-0.00351172459082871,0.348786498420729,-0.423680880331002,
  -0.00015910683590592,-0.00285442144170234,0.364061847150291,-0.446341113639288,
  -0.000164603670457897,-0.00219711829257552,0.379337195879853,-0.469001346947573,
  -0.000170100505009874,-0.00153981514344803,0.394612544609415,-0.491661580255858,
  -0.000175597339562183,-0.000882511994321211,0.409887893338977,-0.514321813564143,
  -0.000181094174114271,-0.000225208845194613,0.425163242068539,-0.536982046872429,
  -0.000186591008666359,0.000432094303932207,0.440438590798101,-0.559642280180714,
  -0.000192087843218003,0.00108939745305969,0.455713939527663,-0.582302513488999,
  -0.000197584677770202,0.00174670060218673,0.470989288257226,-0.604962746797284,
  -0.00020308151232229,0.00240400375131378,0.486264636986788,-0.62762298010557,
  -0.000208578346874155,0.00306130690044037,0.50153998571635,-0.650283213413855,
  -0.000214075181426243,0.00371861004956786,0.516815334445912,-0.67294344672214,
  -7.9598691956756e-05,-0.0117204850187089,0.149365022520053,-0.129982272811832,
  -8.47945646269554e-05,-0.0110674919238278,0.164437803124756,-0.152792327333694,
  -8.99904372966831e-05,-0.0104144988289463,0.17951058372946,-0.175602381855556,
  -9.51863099667993e-05,-0.00976150573406531,0.194583364334164,-0.198412436377418,
  -0.00010038218263686,-0.00910851263918422,0.209656144938868,-0.22122249089928,
  -0.000105578055306865,-0.00845551954430324,0.224728925543571,-0.244032545421142,
  -0.000110773927976981,-0.00780252644942214,0.239801706148275,-0.266842599943004,
  -0.000115969800647042,-0.00714953335454105,0.254874486752979,-0.289652654464866,
  -0.000121165673316936,-0.00649654025965951,0.269947267357683,-0.312462708986727,
  -0.000126361545986609,-0.00584354716477797,0.285020047962387,-0.335272763508589,
  -0.000131557418656891,-0.00519055406989732,0.30009282856709,-0.358082818030451,
  -0.000136753291327008,-0.00453756097501623,0.315165609171794,-0.380892872552313,
  -0.000141949163996791,-0.00388456788013491,0.330238389776498,-0.403702927074175,
  -0.000147145036666907,-0.00323157478525382,0.345311170381202,-0.426512981596037,
  -0.00015234090933669,-0.00257858169037251,0.360383950985905,-0.449323036117899,
  -0.000157536782006695,-0.00192558859549119,0.375456731590609,-0.472133090639761,
  -0.000162732654677367,-0.00127259550061121,0.390529512195313,-0.494943145161623,
  -0.000167928527346595,-0.000619602405728337,0.405602292800017,-0.517753199683485,
  -0.000173124400017155,3.33906891516467e-05,0.42067507340472,-0.540563254205346,
  -0.000178320272686827,0.000686383784033406,0.435747854009424,-0.563373308727208,
  -0.00018351614535661,0.0013393768789145,0.450820634614128,-0.58618336324907,
  -0.000188712018027282,0.00199236997379471,0.465893415218831,-0.608993417770932,
  -0.00019390789069651,0.00264536306867713,0.480966195823535,-0.631803472292794,
  -0.00019910376336707,0.00329835616355734,0.496038976428239,-0.654613526814656,
  -0.000204299636036853,0.00395134925843887,0.511111757032943,-0.677423581336518,
  -7.62792891767228e-05,-0.0112945458857542,0.148264101903325,-0.131123667596917,
  -8.10943977086476e-05,-0.01064857893753,0.163073027057669,-0.154127073796322,
  -8.59095062408777e-05,-0.0100026119893064,0.177881952212014,-0.177130479995727,
  -9.07246147730523e-05,-0.00935664504108236,0.192690877366359,-0.200133886195133,
  -9.55397233051158e-05,-0.00871067809285875,0.207499802520703,-0.223137292394539,
  -0.00010035483183729,-0.00806471114463458,0.222308727675048,-0.246140698593944,
  -0.000105169940369076,-0.00741874419641042,0.237117652829393,-0.269144104793349,
  -0.000109985048901251,-0.00677277724818648,0.251926577983738,-0.292147510992755,
  -0.000114800157433426,-0.00612681029996276,0.266735503138082,-0.31515091719216,
  -0.000119615265965489,-0.00548084335173882,0.281544428292427,-0.338154323391566,
  -0.00012443037449783,-0.00483487640351488,0.296353353446771,-0.361157729590971,
  -0.000129245483029838,-0.00418890945529138,0.311162278601116,-0.384161135790377,
  -0.000134060591561846,-0.00354294250706721,0.325971203755461,-0.407164541989783,
  -0.000138875700094188,-0.00289697555884327,0.340780128909806,-0.430167948189188,
  -0.000143690808625863,-0.00225100861061889,0.35558905406415,-0.453171354388594,
  -0.000148505917158426,-0.00160504166239539,0.370397979218495,-0.476174760587999,
  -0.000153321025690656,-0.000959074714171892,0.385206904372839,-0.499178166787405,
  -0.000158136134222553,-0.000313107765947507,0.400015829527184,-0.52218157298681,
  -0.000162951242754339,0.000332859182276657,0.414824754681529,-0.545184979186215,
  -0.000167766351286791,0.000978826130500376,0.429633679835874,-0.568188385385621,
  -0.000172581459819021,0.0016247930787241,0.444442604990218,-0.591191791585027,
  -0.000177396568350918,0.00227076002694782,0.459251530144563,-0.614195197784432,
  -0.000182211676882593,0.00291672697517287,0.474060455298908,-0.637198603983837,
  -0.000187026785414601,0.00356269392339659,0.488869380453252,-0.660202010183243,
  -0.000191841893946942,0.00420866087162119,0.503678305607598,-0.683205416382648,
  -7.20690026665693e-05,-0.0107721304816955,0.146858109530938,-0.132557585748381,
  -7.64187099734359e-05,-0.0101373334437707,0.16133167394459,-0.155803896930067,
  -8.07684172806078e-05,-0.00950253640584642,0.175805238358242,-0.179050208111753,
  -8.51181245872246e-05,-0.0088677393679214,0.190278802771894,-0.202296519293439,
  -8.94678318940079e-05,-0.0082329423299965,0.204752367185546,-0.225542830475125,
  -9.38175392010132e-05,-0.00759814529207226,0.219225931599198,-0.248789141656811,
  -9.8167246507963e-05,-0.00696334825414757,0.23369949601285,-0.272035452838497,
  -0.000102516953814635,-0.00632855121622278,0.248173060426502,-0.295281764020183,
  -0.000106866661121807,-0.00569375417829843,0.262646624840154,-0.318528075201869,
  -0.000111216368428646,-0.00505895714037363,0.277120189253806,-0.341774386383555,
  -0.000115566075735485,-0.00442416010244906,0.291593753667458,-0.365020697565241,
  -0.000119915783042379,-0.00378936306452426,0.30606731808111,-0.388267008746927,
  -0.00012426549034894,-0.00315456602659925,0.320540882494762,-0.411513319928613,
  -0.000128615197656057,-0.00251976898867512,0.335014446908414,-0.434759631110299,
  -0.000132964904963062,-0.0018849719507501,0.349488011322066,-0.458005942291985,
  -0.000137314612269512,-0.00125017491282531,0.363961575735718,-0.481252253473671,
  -0.000141664319576518,-0.000615377874900513,0.37843514014937,-0.504498564655357,
  -0.000146014026883745,1.94191630233931e-05,0.392908704563022,-0.527744875837043,
  -0.000150363734190528,0.000654216200948632,0.407382268976674,-0.550991187018729,
  -0.000154713441497201,0.00128901323887343,0.421855833390326,-0.574237498200415,
  -0.000159063148804206,0.00192381027679822,0.436329397803979,-0.597483809382101,
  -0.0001634128561111,0.00255860731472213,0.45080296221763,-0.620730120563787,
  -0.000167762563417884,0.00319340435264737,0.465276526631282,-0.643976431745472,
  -0.000172112270724556,0.00382820139057216,0.479750091044934,-0.667222742927159,
  -0.000176461978032005,0.00446299842849607,0.494223655458586,-0.690469054108844,
  -6.68952954001878e-05,-0.010156644295174,0.14511596475665,-0.13429931895994,
  -7.07005536468297e-05,-0.00953893425820018,0.159176361672187,-0.157840678833533,
  -7.45058118937769e-05,-0.00892122422122676,0.173236758587724,-0.181382038707125,
  -7.83110701403356e-05,-0.00830351418425301,0.187297155503261,-0.204923398580718,
  -8.21163283871162e-05,-0.00768580414727915,0.201357552418798,-0.22846475845431,
  -8.59215866339524e-05,-0.00706809411030562,0.215417949334335,-0.252006118327903,
  -8.97268448806776e-05,-0.00645038407333187,0.229478346249873,-0.275547478201496,
  -9.35321031275693e-05,-0.00583267403635834,0.243538743165409,-0.299088838075088,
  -9.73373613737949e-05,-0.00521496399938415,0.257599140080947,-0.322630197948681,
  -0.000101142619620631,-0.00459725396241062,0.271659536996483,-0.346171557822274,
  -0.000104947877867301,-0.00397954392543665,0.285719933912021,-0.369712917695866,
  -0.000108753136114581,-0.00336183388846356,0.299780330827558,-0.393254277569459,
  -0.000112558394360973,-0.00274412385148959,0.313840727743095,-0.416795637443052,
  -0.000116363652607809,-0.00212641381451606,0.327901124658631,-0.440336997316644,
  -0.000120168910854535,-0.00150870377754231,0.341961521574168,-0.463878357190237,
  -0.000123974169101371,-0.00089099374056878,0.356021918489706,-0.48741971706383,
  -0.000127779427347763,-0.000273283703594585,0.370082315405243,-0.510961076937422,
  -0.000131584685594821,0.000344426333379166,0.38414271232078,-0.534502436811015,
  -0.000135389943841213,0.000962136370352695,0.398203109236317,-0.558043796684608,
  -0.000139195202088049,0.001579846407326,0.412263506151853,-0.5815851565582,
  -0.000143000460335108,0.00219755644429931,0.42632390306739,-0.605126516431793,
  -0.000146805718581722,0.0028152664812735,0.440384299982927,-0.628667876305386,
  -0.000150610976828891,0.00343297651824681,0.454444696898464,-0.652209236178978,
  -0.000154416235075172,0.00405068655522145,0.468505093814002,-0.675750596052571,
  -0.000158221493322341,0.00466839659219387,0.482565490729538,-0.699291955926163,
  -6.0780462052018e-05,-0.00946545187349679,0.143036825947692,-0.136330413343041,
  -6.39823372760584e-05,-0.00887255943138299,0.156607356780888,-0.160215839539132,
  -6.71842125000155e-05,-0.00827966698926896,0.170177887614084,-0.184101265735222,
  -7.03860877238061e-05,-0.00768677454715472,0.183748418447281,-0.207986691931312,
  -7.35879629475966e-05,-0.00709388210504058,0.197318949280477,-0.231872118127402,
  -7.67898381713872e-05,-0.00650098966292656,0.210889480113673,-0.255757544323493,
  -7.99917133952888e-05,-0.00590809722081254,0.224460010946869,-0.279642970519583,
  -8.31935886192459e-05,-0.0053152047786984,0.238030541780065,-0.303528396715674,
  -8.6395463843314e-05,-0.00472231233658471,0.251601072613261,-0.327413822911764,
  -8.95973390669935e-05,-0.00412941989447035,0.265171603446458,-0.351299249107854,
  -9.27992142909506e-05,-0.00353652745235622,0.278742134279654,-0.375184675303945,
  -9.60010895147967e-05,-0.00294363501024231,0.29231266511285,-0.399070101500035,
  -9.92029647391979e-05,-0.00235074256812884,0.305883195946046,-0.422955527696125,
  -0.000102404839962378,-0.00175785012601404,0.319453726779242,-0.446840953892216,
  -0.000105606715186668,-0.00116495768390057,0.333024257612438,-0.470726380088306,
  -0.000108808590410403,-0.000572065241786213,0.346594788445635,-0.494611806284396,
  -0.00011201046563436,2.08272003276999e-05,0.360165319278831,-0.518497232480487,
  -0.000115212340858095,0.000613719642441835,0.373735850112027,-0.542382658676577,
  -0.000118414216081719,0.00120661208455619,0.387306380945223,-0.566268084872667,
  -0.000121616091305676,0.00179950452667033,0.400876911778419,-0.590153511068757,
  -0.000124817966529855,0.00239239696878402,0.414447442611616,-0.614038937264848,
  -0.000128019841753702,0.00298528941089815,0.428017973444812,-0.637924363460938,
  -0.000131221716976992,0.00357818185301317,0.441588504278008,-0.661809789657028,
  -0.000134423592201283,0.00417107429512598,0.455159035111204,-0.685695215853119,
  -0.000137625467425462,0.00476396673723967,0.4687295659444,-0.709580642049209,
  -5.38781856682657e-05,-0.00873048154270528,0.140664345468733,-0.138589310431118,
  -5.64530216378145e-05,-0.00817139984803095,0.153679878558344,-0.162857392608368,
  -5.90278576074188e-05,-0.00761231815335672,0.166695411647955,-0.187125474785619,
  -6.16026935769121e-05,-0.00705323645868217,0.179710944737566,-0.21139355696287,
  -6.41775295465163e-05,-0.00649415476400783,0.192726477827178,-0.235661639140121,
  -6.67523655160651e-05,-0.0059350730693335,0.205742010916789,-0.259929721317371,
  -6.93272014853363e-05,-0.00537599137465872,0.2187575440064,-0.284197803494622,
  -7.19020374552182e-05,-0.00481690967998483,0.231773077096011,-0.308465885671873,
  -7.44768734245449e-05,-0.00425782798531027,0.244788610185622,-0.332733967849124,
  -7.70517093943157e-05,-0.00369874629063616,0.257804143275233,-0.357002050026375,
  -7.96265453638645e-05,-0.00313966459596182,0.270819676364844,-0.381270132203625,
  -8.22013813331912e-05,-0.00258058290128682,0.283835209454456,-0.405538214380876,
  -8.47762173025179e-05,-0.00202150120661226,0.296850742544067,-0.429806296558127,
  -8.73510532720667e-05,-0.00146241951193793,0.309866275633678,-0.454074378735378,
  -8.99258892417265e-05,-0.000903337817263816,0.322881808723289,-0.478342460912629,
  -9.25007252112753e-05,-0.000344256122589481,0.335897341812901,-0.50261054308988,
  -9.50755611812681e-05,0.000214825572083965,0.348912874902511,-0.52687862526713,
  -9.76503971504838e-05,0.000773907266759188,0.361928407992123,-0.551146707444381,
  -0.000100225233120366,0.0013329889614333,0.374943941081734,-0.575414789621632,
  -0.000102800069089248,0.00189207065610786,0.387959474171345,-0.599682871798883,
  -0.000105374905059352,0.00245115235078242,0.400975007260957,-0.623950953976133,
  -0.000107949741028457,0.00301023404545697,0.413990540350567,-0.648219036153384,
  -0.00011052457699845,0.00356931574013064,0.427006073440178,-0.672487118330635,
  -0.000113099412967888,0.0041283974348052,0.44002160652979,-0.696755200507886,
  -0.000115674248937658,0.00468747912947931,0.453037139619401,-0.721023282685136,
  -4.64810320248976e-05,-0.00799368659322441,0.138092214199511,-0.140972902274679,
  -4.84502474501491e-05,-0.00747740205714353,0.150510477396081,-0.165644763659224,
  -5.04194628750954e-05,-0.00696111752106221,0.162928740592652,-0.19031662504377,
  -5.23886783001526e-05,-0.00644483298498111,0.175347003789223,-0.214988486428315,
  -5.43578937252098e-05,-0.0059285484488999,0.187765266985793,-0.239660347812861,
  -5.63271091501005e-05,-0.00541226391281868,0.200183530182364,-0.264332209197406,
  -5.82963245754353e-05,-0.0048959793767378,0.212601793378934,-0.289004070581952,
  -6.02655400004926e-05,-0.00437969484065648,0.225020056575505,-0.313675931966498,
  -6.22347554256053e-05,-0.0038634103045756,0.237438319772075,-0.338347793351043,
  -6.42039708504405e-05,-0.00334712576849405,0.249856582968646,-0.363019654735589,
  -6.61731862753312e-05,-0.00283084123241273,0.262274846165217,-0.387691516120134,
  -6.81424017007215e-05,-0.00231455669633229,0.274693109361787,-0.41236337750468,
  -7.01116171258898e-05,-0.00179827216025097,0.287111372558358,-0.437035238889225,
  -7.2080832551058e-05,-0.00128198762417009,0.299529635754928,-0.461707100273771,
  -7.40500479757822e-05,-0.000765703088088543,0.311947898951499,-0.486378961658317,
  -7.60192634009504e-05,-0.000249418552007663,0.324366162148069,-0.511050823042862,
  -7.79884788262297e-05,0.000266865984072995,0.336784425344639,-0.535722684427408,
  -7.99576942508429e-05,0.000783150520154985,0.349202688541211,-0.560394545811953,
  -8.19269096763442e-05,0.00129943505623586,0.361620951737781,-0.585066407196499,
  -8.38961251011794e-05,0.00181571959231652,0.374039214934351,-0.609738268581045,
  -8.58653405260146e-05,0.00233200412839807,0.386457478130922,-0.63441012996559,
  -8.78345559512939e-05,0.00284828866447917,0.398875741327492,-0.659081991350136,
  -8.9803771375907e-05,0.00336457320056072,0.411294004524063,-0.683753852734681,
  -9.17729868015194e-05,0.00388085773664137,0.423712267720634,-0.708425714119227,
  -9.37422022265766e-05,0.00439714227272248,0.436130530917204,-0.733097575503772,
  -3.89821285236847e-05,-0.00729802825722803,0.135453996894149,-0.143352537693825,
  -4.04110093917831e-05,-0.00683179390766009,0.147264063411592,-0.168427508069446,
  -4.18398902599648e-05,-0.00636555955809226,0.159074129929035,-0.193502478445067,
  -4.32687711283686e-05,-0.00589932520852465,0.170884196446478,-0.218577448820688,
  -4.46976519963282e-05,-0.0054330908589566,0.18269426296392,-0.243652419196309,
  -4.61265328644545e-05,-0.00496685650938855,0.194504329481363,-0.26872738957193,
  -4.75554137328027e-05,-0.00450062215982117,0.206314395998806,-0.293802359947551,
  -4.89842946007624e-05,-0.00403438781025289,0.218124462516249,-0.318877330323172,
  -5.04131754691661e-05,-0.00356815346068551,0.229934529033691,-0.343952300698793,
  -5.18420563370703e-05,-0.00310191911111746,0.241744595551134,-0.369027271074413,
  -5.32709372054185e-05,-0.00263568476154963,0.253554662068577,-0.394102241450035,
  -5.46998180733782e-05,-0.00216945041198136,0.26536472858602,-0.419177211825655,
  -5.6128698941893e-05,-0.00170321606241397,0.277174795103463,-0.444252182201277,
  -5.75575798100747e-05,-0.00123698171284636,0.288984861620905,-0.469327152576897,
  -5.89864606779233e-05,-0.000770747363278312,0.300794928138348,-0.494402122952518,
  -6.04153415465492e-05,-0.000304513013710928,0.312604994655791,-0.519477093328139,
  -6.18442224145088e-05,0.000161721335857568,0.324415061173234,-0.54455206370376,
  -6.32731032823575e-05,0.000627955685425619,0.336225127690677,-0.569627034079381,
  -6.47019841513163e-05,0.00109419003499278,0.348035194208119,-0.594702004455002,
  -6.6130865019165e-05,0.00156042438456039,0.359845260725562,-0.619776974830623,
  -6.75597458875687e-05,0.002026658734128,0.371655327243005,-0.644851945206244,
  -6.89886267553064e-05,0.00249289308369649,0.383465393760448,-0.669926915581865,
  -7.04175076234881e-05,0.00295912743326499,0.395275460277891,-0.695001885957486,
  -7.18463884916698e-05,0.00342536178283215,0.407085526795333,-0.720076856333107,
  -7.32752693595184e-05,0.00389159613240064,0.418895593312776,-0.745151826708728,
  -3.17964670884519e-05,-0.00667772081892115,0.132897299000605,-0.145600406155269,
  -3.27809494870546e-05,-0.00626551471094228,0.144121908926038,-0.171056164268487,
  -3.37654318859348e-05,-0.00585330860296396,0.155346518851471,-0.196511922381706,
  -3.47499142847596e-05,-0.00544110249498531,0.166571128776903,-0.221967680494924,
  -3.57343966835288e-05,-0.00502889638700665,0.177795738702336,-0.247423438608142,
  -3.67188790822426e-05,-0.004616690279028,0.189020348627769,-0.27287919672136,
  -3.77033614809563e-05,-0.00420448417104913,0.200244958553202,-0.298334954834579,
  -3.86878438798366e-05,-0.00379227806307081,0.211469568478635,-0.323790712947797,
  -3.96723262785503e-05,-0.00338007195509182,0.222694178404068,-0.349246471061015,
  -4.06568086773751e-05,-0.0029678658471135,0.233918788329501,-0.374702229174233,
  -4.16412910760888e-05,-0.00255565973913474,0.245143398254934,-0.400157987287452,
  -4.26257734748026e-05,-0.00214345363115598,0.256368008180367,-0.42561374540067,
  -4.36102558739604e-05,-0.00173124752317766,0.2675926181058,-0.451069503513888,
  -4.45947382724521e-05,-0.00131904141519867,0.278817228031233,-0.476525261627106,
  -4.55792206711658e-05,-0.000906835307219911,0.290041837956666,-0.501981019740325,
  -4.65637030702126e-05,-0.000494629199241814,0.301266447882099,-0.527436777853543,
  -4.75481854688153e-05,-8.24230912630508e-05,0.312491057807532,-0.552892535966761,
  -4.8532667867307e-05,0.000329783016716156,0.323715667732965,-0.578348294079979,
  -4.95171502662428e-05,0.000741989124694697,0.334940277658398,-0.603804052193198,
  -5.05016326650676e-05,0.00115419523267324,0.346164887583831,-0.629259810306416,
  -5.14861150640034e-05,0.00156640134065178,0.357389497509264,-0.654715568419634,
  -5.24705974627171e-05,0.00197860744863032,0.368614107434696,-0.680171326532852,
  -5.34550798614308e-05,0.00239081355660931,0.379838717360129,-0.70562708464607,
  -5.44395622602556e-05,0.0028030196645874,0.391063327285562,-0.731082842759289,
  -5.54240446589693e-05,0.00321522577256594,0.402287937210995,-0.756538600872507,
  -2.52727788376539e-05,-0.00615220143011774,0.130551960505155,-0.147615564001963,
  -2.59195085329789e-05,-0.00579402623130587,0.141242690388364,-0.173412688796775,
  -2.65662382286092e-05,-0.00543585103249455,0.151933420271573,-0.199209813591588,
  -2.72129679239619e-05,-0.00507767583368268,0.162624150154781,-0.225006938386401,
  -2.78596976193146e-05,-0.00471950063487103,0.17331488003799,-0.250804063181213,
  -2.85064273149449e-05,-0.0043613254360596,0.184005609921199,-0.276601187976026,
  -2.91531570103531e-05,-0.00400315023724773,0.194696339804408,-0.302398312770838,
  -2.97998867058169e-05,-0.00364497503843642,0.205387069687616,-0.328195437565651,
  -3.04466164013362e-05,-0.00328679983962465,0.216077799570825,-0.353992562360464,
  -3.10933460967444e-05,-0.00292862464081312,0.226768529454033,-0.379789687155276,
  -3.17400757922082e-05,-0.00257044944200135,0.237459259337242,-0.405586811950089,
  -3.23868054877829e-05,-0.00221227424319004,0.248149989220451,-0.431383936744901,
  -3.30335351829136e-05,-0.00185409904437783,0.25884071910366,-0.457181061539714,
  -3.36802648788215e-05,-0.00149592384556718,0.269531448986868,-0.482978186334526,
  -3.43269945740632e-05,-0.00113774864675498,0.280222178870077,-0.508775311129339,
  -3.4973724269638e-05,-0.000779573447943438,0.290912908753286,-0.534572435924152,
  -3.56204539648797e-05,-0.000421398249131455,0.301603638636494,-0.560369560718964,
  -3.62671836601214e-05,-6.3223050319694e-05,0.312294368519703,-0.586166685513777,
  -3.69139133561402e-05,0.000294952148491401,0.322985098402912,-0.611963810308589,
  -3.75606430509379e-05,0.00065312734730405,0.333675828286121,-0.637760935103402,
  -3.82073727468457e-05,0.00101130254611492,0.344366558169329,-0.663558059898215,
  -3.88541024425315e-05,0.00136947774492535,0.355057288052537,-0.689355184693027,
  -3.95008321372181e-05,0.00172765294373844,0.365748017935746,-0.71515230948784,
  -4.0147561833126e-05,0.00208582814254976,0.376438747818955,-0.740949434282653,
  -4.07942915287007e-05,0.00244400334136152,0.387129477702164,-0.766746559077465,
  -1.96334074151483e-05,-0.00572576222337406,0.128506016863772,-0.14933910996327,
  -2.00413254359821e-05,-0.00541801129124064,0.138733348553683,-0.175428202539342,
  -2.04492434565662e-05,-0.00511026035910667,0.148960680243594,-0.201517295115414,
  -2.08571614775388e-05,-0.00480250942697347,0.159188011933505,-0.227606387691486,
  -2.12650794982894e-05,-0.00449475849484016,0.169415343623416,-0.253695480267558,
  -2.1672997519262e-05,-0.00418700756270685,0.179642675313327,-0.27978457284363,
  -2.20809155400126e-05,-0.00387925663057298,0.189870007003238,-0.305873665419702,
  -2.24888335607631e-05,-0.00357150569843956,0.200097338693149,-0.331962757995774,
  -2.28967515816247e-05,-0.00326375476630614,0.21032467038306,-0.358051850571846,
  -2.33046696022643e-05,-0.00295600383417249,0.220552002072971,-0.384140943147918,
  -2.37125876229038e-05,-0.00264825290203885,0.230779333762882,-0.41023003572399,
  -2.41205056435989e-05,-0.00234050196990521,0.241006665452793,-0.436319128300062,
  -2.4528423664627e-05,-0.00203275103777201,0.251233997142704,-0.462408220876134,
  -2.49363416854331e-05,-0.00172500010563859,0.261461328832615,-0.488497313452206,
  -2.53442597062392e-05,-0.00141724917350494,0.271688660522526,-0.514586406028278,
  -2.57521777269343e-05,-0.0011094982413713,0.281915992212437,-0.54067549860435,
  -2.61600957482955e-05,-0.000801747309238765,0.292143323902348,-0.566764591180422,
  -2.65680137689905e-05,-0.000493996377105343,0.302370655592259,-0.592853683756494,
  -2.69759317897966e-05,-0.000186245444971256,0.31259798728217,-0.618942776332566,
  -2.73838498099366e-05,0.000121505487162388,0.322825318972081,-0.645031868908638,
  -2.77917678311868e-05,0.000429256419295587,0.333052650661992,-0.67112096148471,
  -2.81996858518818e-05,0.000737007351429231,0.343279982351903,-0.697210054060782,
  -2.86076038726879e-05,0.00104475828356287,0.353507314041814,-0.723299146636854,
  -2.90155218938271e-05,0.00135250921569563,0.363734645731725,-0.749388239212926,
  -2.94234399143001e-05,0.00166026014782972,0.373961977421636,-0.775477331788998,
  -1.49608233049603e-05,-0.00539140627700752,0.126797767634769,-0.150754933422575,
  -1.52100834727165e-05,-0.00512799092456584,0.13663976283128,-0.177083865749572,
  -1.54593436405559e-05,-0.00486457557212427,0.146481758027791,-0.20341279807657,
  -1.57086038082288e-05,-0.00460116021968238,0.156323753224302,-0.229741730403567,
  -1.59578639760127e-05,-0.00433774486724092,0.166165748420813,-0.256070662730564,
  -1.62071241436856e-05,-0.00407432951479891,0.176007743617324,-0.282399595057562,
  -1.64563843115251e-05,-0.00381091416235746,0.185849738813835,-0.308728527384559,
  -1.67056444788094e-05,-0.0035474988099149,0.195691734010347,-0.335057459711557,
  -1.69549046468709e-05,-0.00328408345747366,0.205533729206857,-0.361386392038554,
  -1.72041648142107e-05,-0.00302066810503154,0.215375724403368,-0.387715324365552,
  -1.74534249820502e-05,-0.00275725275258987,0.22521771959988,-0.414044256692549,
  -1.77026851503337e-05,-0.00249383740014864,0.235059714796391,-0.440373189019546,
  -1.7951945317618e-05,-0.00223042204770652,0.244901709992902,-0.466702121346544,
  -1.82012054855685e-05,-0.00196700669526528,0.254743705189412,-0.493031053673541,
  -1.84504656528528e-05,-0.00170359134282272,0.264585700385924,-0.519359986000539,
  -1.86997258205812e-05,-0.00144017599038104,0.274427695582435,-0.545688918327536,
  -1.89489859885317e-05,-0.00117676063793981,0.284269690778946,-0.572017850654533,
  -1.9198246155927e-05,-0.000913345285497469,0.294111685975457,-0.598346782981531,
  -1.94475063239885e-05,-0.000649929933056015,0.303953681171968,-0.624675715308529,
  -1.9696766491939e-05,-0.000386514580614339,0.313795676368479,-0.651004647635526,
  -1.99460266590012e-05,-0.000123099228172219,0.32363767156499,-0.677333579962523,
  -2.01952868267297e-05,0.000140316124269457,0.333479666761501,-0.703662512289521,
  -2.04445469950132e-05,0.000403731476710689,0.343321661958012,-0.729991444616518,
  -2.06938071626306e-05,0.000667146829152809,0.353163657154523,-0.756320376943516,
  -2.0943067330137e-05,0.000930562181594929,0.363005652351034,-0.782649309270513,
  -1.12229718828294e-05,-0.0051360203707892,0.125422688095384,-0.151879915816704,
  -1.13720107837723e-05,-0.00490971168928833,0.134955497843117,-0.178399419570831,
  -1.15210496851037e-05,-0.00468340300778758,0.144488307590851,-0.204918923324958,
  -1.16700885856025e-05,-0.0044570943262856,0.154021117338585,-0.231438427079086,
  -1.18191274869339e-05,-0.00423078564478518,0.163553927086318,-0.257957930833213,
  -1.19681663877658e-05,-0.00400447696328388,0.173086736834052,-0.28447743458734,
  -1.21172052887086e-05,-0.00377816828178279,0.182619546581785,-0.310996938341467,
  -1.22662441899291e-05,-0.00355185960028193,0.192152356329519,-0.337516442095594,
  -1.24152830907054e-05,-0.0033255509187804,0.201685166077253,-0.364035945849721,
  -1.25643219918703e-05,-0.00309924223727998,0.211217975824986,-0.390555449603849,
  -1.27133608925911e-05,-0.00287293355577822,0.22075078557272,-0.417074953357976,
  -1.28623997939226e-05,-0.0026466248742778,0.230283595320453,-0.443594457112103,
  -1.30114386945879e-05,-0.00242031619277605,0.239816405068187,-0.47011396086623,
  -1.31604775958083e-05,-0.00219400751127519,0.24934921481592,-0.496633464620357,
  -1.33095164970287e-05,-0.00196769882977454,0.258882024563654,-0.523152968374484,
  -1.3458555397361e-05,-0.00174139014827257,0.268414834311387,-0.549672472128611,
  -1.36075942983593e-05,-0.00151508146677148,0.277947644059121,-0.576191975882739,
  -1.37566331999128e-05,-0.00128877278527129,0.287480453806854,-0.602711479636866,
  -1.39056721008002e-05,-0.00106246410377064,0.297013263554587,-0.629230983390993,
  -1.40547110014655e-05,-0.000836155422268892,0.306546073302321,-0.65575048714512,
  -1.4203749903019e-05,-0.000609846740768472,0.316078883050054,-0.682269990899247,
  -1.43527888035733e-05,-0.000383538059266719,0.325611692797788,-0.708789494653374,
  -1.45018277047937e-05,-0.000157229377765855,0.335144502545522,-0.735308998407502,
  -1.4650866605348e-05,6.90793037358972e-05,0.344677312293256,-0.761828502161629,
  -1.47999055070125e-05,0.000295387985235873,0.354210122040989,-0.788348005915756,
  -8.31577803500627e-06,-0.00494467412969601,0.124347900164765,-0.152750402278653,
  -8.40386687445127e-06,-0.00474822162272148,0.133639642622223,-0.179417365982568,
  -8.49195571367423e-06,-0.00455176911574662,0.142931385079682,-0.206084329686484,
  -8.58004455289718e-06,-0.00435531660877198,0.15222312753714,-0.232751293390399,
  -8.66813339217565e-06,-0.00415886410179722,0.161514869994598,-0.259418257094314,
  -8.75622223101002e-06,-0.0039624115948218,0.170806612452057,-0.286085220798229,
  -8.84431107045502e-06,-0.00376595908784738,0.180098354909515,-0.312752184502144,
  -8.93239990995554e-06,-0.00356950658087274,0.189390097366974,-0.339419148206059,
  -9.02048874912298e-06,-0.00337305407389787,0.198681839824432,-0.366086111909974,
  -9.10857758806838e-06,-0.00317660156692279,0.20797358228189,-0.39275307561389,
  -9.19666642751338e-06,-0.00298014905994859,0.217265324739348,-0.419420039317805,
  -9.28475526718042e-06,-0.00278369655297395,0.226557067196807,-0.44608700302172,
  -9.37284410640338e-06,-0.0025872440459993,0.235848809654265,-0.472753966725635,
  -9.46093294507122e-06,-0.00239079153902422,0.245140552111723,-0.49942093042955,
  -9.54902178451622e-06,-0.0021943390320498,0.254432294569181,-0.526087894133466,
  -9.63711062396122e-06,-0.00199788652507493,0.26372403702664,-0.552754857837381,
  -9.72519946285111e-06,-0.00180143401809985,0.273015779484098,-0.579421821541296,
  -9.81328830229611e-06,-0.00160498151112498,0.282307521941557,-0.606088785245211,
  -9.90137714129702e-06,-0.00140852900415034,0.291599264399015,-0.632755748949126,
  -9.98946598051997e-06,-0.00121207649717503,0.300891006856474,-0.659422712653041,
  -1.0077554820187e-05,-0.00101562399020105,0.310182749313932,-0.686089676356957,
  -1.0165643659743e-05,-0.000819171483227077,0.31947449177139,-0.712756640060872,
  -1.02537324984109e-05,-0.000622718976251324,0.328766234228849,-0.739423603764787,
  -1.03418213375228e-05,-0.00042626646927646,0.338057976686307,-0.766090567468702,
  -1.04299101771899e-05,-0.000229813962302483,0.347349719143765,-0.792757531172617,
  -6.10357661676164e-06,-0.00480328062227675,0.123526931414982,-0.153410240587686,
  -6.15554023142284e-06,-0.0046301253796257,0.132634880473999,-0.180188980554842,
  -6.20750384611179e-06,-0.00445697013697488,0.141742829533017,-0.206967720521998,
  -6.25946746068973e-06,-0.00428381489432383,0.150850778592034,-0.233746460489154,
  -6.31143107515664e-06,-0.00411065965167245,0.159958727651052,-0.26052520045631,
  -6.36339469017866e-06,-0.00393750440902196,0.169066676710069,-0.287303940423466,
  -6.41535830492312e-06,-0.00376434916637103,0.178174625769087,-0.314082680390621,
  -6.46732191927901e-06,-0.00359119392371943,0.187282574828105,-0.340861420357777,
  -6.51928553385694e-06,-0.00341803868106871,0.196390523887122,-0.367640160324933,
  -6.57124914887897e-06,-0.003244883438418,0.20549847294614,-0.394418900292089,
  -6.62321276334588e-06,-0.00307172819576684,0.214606422005158,-0.421197640259245,
  -6.67517637775727e-06,-0.00289857295311524,0.223714371064175,-0.447976380226401,
  -6.72713999216867e-06,-0.00272541771046386,0.232822320123193,-0.474755120193557,
  -6.77910360702416e-06,-0.00255226246781337,0.241930269182211,-0.501533860160712,
  -6.83106722165761e-06,-0.00237910722516221,0.251038218241228,-0.528312600127868,
  -6.88303083629105e-06,-0.00220595198251106,0.260146167300246,-0.555091340095024,
  -6.93499445092449e-06,-0.00203279673986034,0.269254116359263,-0.58187008006218,
  -6.98695806566896e-06,-0.00185964149720919,0.278362065418281,-0.608648820029336,
  -7.03892168052445e-06,-0.00168648625455869,0.287470014477298,-0.635427559996492,
  -7.09088529504687e-06,-0.00151333101190732,0.296577963536316,-0.662206299963648,
  -7.14284891001338e-06,-0.00134017576925727,0.305685912595333,-0.688985039930803,
  -7.19481252464682e-06,-0.00116702052660589,0.314793861654351,-0.715763779897959,
  -7.24677613916924e-06,-0.000993865283954065,0.323901810713369,-0.742542519865115,
  -7.29873975402473e-06,-0.000820710041304018,0.333009759772386,-0.769321259832271,
  -7.35070336865817e-06,-0.000647554798652639,0.342117708831404,-0.796099999799427,
  -4.44801885537971e-06,-0.00469981956135423,0.122910765884985,-0.153902641662708,
  -4.47887572457839e-06,-0.00454442440526293,0.131880963461904,-0.180764794113541,
  -4.50973259363829e-06,-0.00438902924917117,0.140851161038824,-0.207626946564374,
  -4.54058946264269e-06,-0.00423363409307931,0.149821358615744,-0.234489099015206,
  -4.57144633198014e-06,-0.004078238936988,0.158791556192663,-0.261351251466039,
  -4.60230320109556e-06,-0.00392284378089647,0.167761753769583,-0.288213403916872,
  -4.63316007021097e-06,-0.00376744862480494,0.176731951346503,-0.315075556367705,
  -4.66401693932639e-06,-0.00361205346871318,0.185702148923423,-0.341937708818537,
  -4.69487380849731e-06,-0.00345665831262187,0.194672346500342,-0.36879986126937,
  -4.72573067777926e-06,-0.00330126315653057,0.203642544077262,-0.395662013720203,
  -4.7565875465061e-06,-0.00314586800043881,0.212612741654181,-0.422524166171036,
  -4.78744441567702e-06,-0.00299047284434684,0.221582939231101,-0.449386318621868,
  -4.81830128473693e-06,-0.00283507768825508,0.230553136808021,-0.476248471072701,
  -4.84915815379683e-06,-0.00267968253216377,0.239523334384941,-0.503110623523534,
  -4.8800150231898e-06,-0.00252428737607224,0.24849353196186,-0.529972775974366,
  -4.91087189258277e-06,-0.00236889221998071,0.25746372953878,-0.556834928425199,
  -4.94172876119858e-06,-0.00221349706388918,0.266433927115699,-0.583697080876032,
  -4.97258563092462e-06,-0.00205810190779876,0.275404124692619,-0.610559233326865,
  -5.00344250009555e-06,-0.00190270675170634,0.284374322269539,-0.637421385777697,
  -5.03429936904443e-06,-0.00174731159561459,0.293344519846459,-0.66428353822853,
  -5.06515623788228e-06,-0.00159191643952283,0.302314717423378,-0.691145690679363,
  -5.09601310771934e-06,-0.00143652128343286,0.311284915000297,-0.718007843130195,
  -5.12686997633516e-06,-0.00128112612733977,0.320255112577218,-0.744869995581028,
  -5.15772684561711e-06,-0.00112573097124891,0.329225310154137,-0.771732148031861,
  -5.18858371423292e-06,-0.000970335815156265,0.338195507731057,-0.798594300482694,
  -3.22438332248098e-06,-0.00462463571043847,0.122454373884297,-0.154265820390697,
  -3.24295788739493e-06,-0.00448254515153534,0.131322643807124,-0.18118949512744,
  -3.26153245189253e-06,-0.00434045459263144,0.140190913729951,-0.208113169864183,
  -3.28010701661219e-06,-0.00419836403372775,0.149059183652778,-0.235036844600927,
  -3.29868158122082e-06,-0.0040562734748244,0.157927453575604,-0.26196051933767,
  -3.31725614638456e-06,-0.00391418291592127,0.166795723498431,-0.288884194074413,
  -3.33583071099319e-06,-0.0037720923570177,0.175663993421258,-0.315807868811157,
  -3.35440527521325e-06,-0.00363000179811346,0.184532263344085,-0.3427315435479,
  -3.37297983982188e-06,-0.00348791123920966,0.193400533266912,-0.369655218284643,
  -3.39155440481909e-06,-0.00334582068030653,0.202268803189739,-0.396578893021386,
  -3.41012896953874e-06,-0.00320373012140318,0.211137073112565,-0.423502567758129,
  -3.42870353464697e-06,-0.00306163956250005,0.220005343035392,-0.450426242494873,
  -3.44727809897805e-06,-0.00291954900359603,0.228873612958219,-0.477349917231616,
  -3.46585266364219e-06,-0.00277745844469224,0.237741882881046,-0.504273591968359,
  -3.48442722819531e-06,-0.00263536788578911,0.246610152803872,-0.531197266705102,
  -3.50300179308149e-06,-0.00249327732688531,0.255478422726699,-0.558120941441846,
  -3.52157635719053e-06,-0.00235118676798152,0.264346692649526,-0.585044616178589,
  -3.54015092218773e-06,-0.00220909620907839,0.273214962572353,-0.611968290915332,
  -3.55872548751801e-06,-0.00206700565017526,0.282083232495179,-0.638891965652076,
  -3.57730005173806e-06,-0.00192491509127146,0.290951502418006,-0.665815640388819,
  -3.5958746168463e-06,-0.00178282453236811,0.299819772340833,-0.692739315125562,
  -3.61444918117737e-06,-0.00164073397346387,0.30868804226366,-0.719662989862305,
  -3.63302374650765e-06,-0.00149864341456096,0.317556312186487,-0.746586664599048,
  -3.6515983107277e-06,-0.00135655285565761,0.326424582109313,-0.773510339335792,
  -3.67017287539184e-06,-0.00121446229675293,0.335292852032141,-0.800434014072535,
  -2.32827667848157e-06,-0.00457026498761604,0.122119613964616,-0.15453138438555,
  -2.33966838714128e-06,-0.0044380134468488,0.130913176657392,-0.181500045523643,
  -2.35106009521813e-06,-0.00430576190608123,0.139706739350168,-0.208468706661736,
  -2.3624518039056e-06,-0.00417351036531433,0.148500302042944,-0.235437367799828,
  -2.37384351248204e-06,-0.00404125882454709,0.15729386473572,-0.262406028937921,
  -2.38523522066991e-06,-0.0039090072837793,0.166087427428497,-0.289374690076014,
  -2.39662692919085e-06,-0.00377675574301195,0.174880990121273,-0.316343351214107,
  -2.4080186377673e-06,-0.00364450420224505,0.183674552814049,-0.343312012352199,
  -2.41941034606619e-06,-0.00351225266147748,0.192468115506825,-0.370280673490292,
  -2.4308020544761e-06,-0.00338000112071013,0.201261678199602,-0.397249334628385,
  -2.44219376299704e-06,-0.00324774957994278,0.210055240892378,-0.424217995766477,
  -2.45358547168451e-06,-0.00311549803917566,0.218848803585154,-0.45118665690457,
  -2.46497717992789e-06,-0.00298324649840853,0.22764236627793,-0.478155318042663,
  -2.47636888839331e-06,-0.00285099495764096,0.236435928970707,-0.505123979180756,
  -2.4877605971918e-06,-0.0027187434168745,0.245229491663482,-0.532092640318848,
  -2.49915230521314e-06,-0.00258649187610605,0.254023054356259,-0.559061301456941,
  -2.51054401390061e-06,-0.00245424033533936,0.262816617049035,-0.586029962595034,
  -2.52193572225501e-06,-0.00232198879457179,0.271610179741811,-0.612998623733127,
  -2.53332743027634e-06,-0.00218973725380378,0.280403742434588,-0.639967284871219,
  -2.5447191394079e-06,-0.00205748571303754,0.289197305127364,-0.666935946009312,
  -2.55611084742924e-06,-0.00192523417226953,0.29799086782014,-0.693904607147405,
  -2.56750255700489e-06,-0.00179298263150374,0.306784430512916,-0.720873268285498,
  -2.5788942649152e-06,-0.00166073109073617,0.315577993205692,-0.747841929423591,
  -2.59028597304756e-06,-0.00152847954996815,0.324371555898468,-0.774810590561683,
  -2.60167768129094e-06,-0.00139622800920058,0.333165118591245,-0.801779251699776,
  -1.67644137261114e-06,-0.00453107958152321,0.121875824737514,-0.154724345946967,
  -1.68357980206979e-06,-0.0044060357095308,0.130615011347768,-0.18172569467229,
  -1.69071823136191e-06,-0.00428099183753794,0.139354197958022,-0.208727043397613,
  -1.69785666087607e-06,-0.00415594796554553,0.148093384568276,-0.235728392122936,
  -1.7049950902237e-06,-0.00403090409355278,0.15683257117853,-0.262729740848259,
  -1.71213351973787e-06,-0.00390586022156025,0.165571757788784,-0.289731089573582,
  -1.71927194902999e-06,-0.0037808163495674,0.174310944399038,-0.316732438298905,
  -1.72641037865517e-06,-0.0036557724775752,0.183050131009291,-0.343733787024228,
  -1.73354880789178e-06,-0.00353072860558257,0.191789317619545,-0.37073513574955,
  -1.74068723712839e-06,-0.00340568473358949,0.2005285042298,-0.397736484474873,
  -1.74782566630949e-06,-0.00328064086159663,0.209267690840053,-0.424737833200196,
  -1.75496409560161e-06,-0.00315559698960377,0.218006877450308,-0.451739181925519,
  -1.76210252567088e-06,-0.00303055311761202,0.226746064060561,-0.478740530650842,
  -1.769240954963e-06,-0.00290550924561916,0.235485250670815,-0.505741879376165,
  -1.77637938436614e-06,-0.00278046537362675,0.244224437281069,-0.532743228101488,
  -1.78351781343622e-06,-0.00265542150163389,0.252963623891323,-0.559744576826811,
  -1.79065624295038e-06,-0.00253037762964103,0.261702810501577,-0.586745925552133,
  -1.79779467246455e-06,-0.00240533375764884,0.270441997111831,-0.613747274277456,
  -1.80493310175667e-06,-0.00228028988565621,0.279181183722085,-0.640748623002779,
  -1.81207153138185e-06,-0.00215524601366379,0.287920370332339,-0.667749971728102,
  -1.81920996067397e-06,-0.00203020214167093,0.296659556942593,-0.694751320453425,
  -1.82634838985507e-06,-0.00190515826967808,0.305398743552847,-0.721752669178748,
  -1.83348681981332e-06,-0.00178011439768611,0.3141379301631,-0.748754017904071,
  -1.84062524877238e-06,-0.0016550705256928,0.322877116773355,-0.775755366629394,
  -1.84776367817552e-06,-0.00153002665369995,0.331616303383609,-0.802756715354716,
  -1.20461177616216e-06,-0.00450290613835991,0.121699209898508,-0.154863910318333,
  -1.20918555218674e-06,-0.00438310611066661,0.130399018822513,-0.181888901174916,
  -1.21375932843337e-06,-0.00426330608297343,0.139098827746517,-0.208913892031499,
  -1.21833310390285e-06,-0.00414350605527936,0.147798636670522,-0.235938882888083,
  -1.22290687998294e-06,-0.00402370602758606,0.156498445594527,-0.262963873744666,
  -1.22748065589651e-06,-0.00390390599989243,0.165198254518532,-0.289988864601249,
  -1.23205443181007e-06,-0.00378410597219925,0.173898063442536,-0.317013855457833,
  -1.23662820789017e-06,-0.00366430594450584,0.182597872366541,-0.344038846314416,
  -1.24120198369271e-06,-0.00354450591681221,0.191297681290545,-0.371063837170999,
  -1.24577575971729e-06,-0.00342470588911881,0.19999749021455,-0.398088828027582,
  -1.25034953579739e-06,-0.00330490586142562,0.208697299138554,-0.425113818884165,
  -1.25492331148891e-06,-0.00318510583373177,0.217397108062559,-0.452138809740749,
  -1.25949708773554e-06,-0.00306530580603881,0.226096916986563,-0.479163800597332,
  -1.26407086342706e-06,-0.00294550577834496,0.234796725910568,-0.506188791453915,
  -1.2686446392296e-06,-0.00282570575065111,0.243496534834573,-0.533213782310498,
  -1.27321841558725e-06,-0.00270590572295837,0.252196343758577,-0.560238773167082,
  -1.27779219138979e-06,-0.00258610569526452,0.260896152682582,-0.587263764023665,
  -1.28236596719233e-06,-0.00246630566757089,0.269595961606587,-0.614288754880248,
  -1.28693974266181e-06,-0.00234650563987682,0.278295770530592,-0.641313745736832,
  -1.29151351868639e-06,-0.00222670561218363,0.286995579454596,-0.668338736593415,
  -1.29608729471098e-06,-0.00210690558449,0.295695388378601,-0.695363727449998,
  -1.30066107051352e-06,-0.00198710555679638,0.304395197302605,-0.722388718306581,
  -1.30523484676015e-06,-0.00186730552910364,0.31309500622661,-0.749413709163165,
  -1.30980862256269e-06,-0.00174750550141001,0.321794815150614,-0.776438700019748,
  -1.31438239836523e-06,-0.00162770547371593,0.330494624074619,-0.803463690876331,
  -9.74813355643089e-05,-0.0141674375286459,0.162402249079949,-0.132751372904114,
  -0.000104267816828707,-0.0135156735364591,0.178340305057565,-0.154321479317847,
  -0.000111054298092883,-0.0128639095442722,0.194278361035181,-0.17589158573158,
  -0.000117840779357337,-0.0122121455520854,0.210216417012796,-0.197461692145313,
  -0.000124627260621624,-0.0115603815598984,0.226154472990412,-0.219031798559046,
  -0.000131413741886022,-0.0109086175677116,0.242092528968028,-0.240601904972779,
  -0.000138200223150531,-0.0102568535755247,0.258030584945644,-0.262172011386512,
  -0.000144986704414818,-0.00960508958333794,0.27396864092326,-0.283742117800245,
  -0.000151773185678716,-0.00895332559115047,0.289906696900876,-0.305312224213978,
  -0.000158559666943503,-0.00830156159896456,0.305844752878491,-0.326882330627711,
  -0.000165346148207846,-0.00764979760677731,0.321782808856107,-0.348452437041444,
  -0.000172132629471466,-0.00699803361458984,0.337720864833723,-0.370022543455177,
  -0.000178919110736309,-0.00634626962240348,0.353658920811339,-0.39159264986891,
  -0.000185705592000263,-0.00569450563021601,0.369596976788955,-0.413162756282643,
  -0.000192492073264772,-0.00504274163802965,0.38553503276657,-0.434732862696375,
  -0.000199278554529281,-0.00439097764584306,0.401473088744186,-0.456302969110108,
  -0.000206065035793346,-0.00373921365365559,0.417411144721802,-0.477873075523841,
  -0.000212851517058077,-0.00308744966146879,0.433349200699418,-0.499443181937574,
  -0.000219637998322253,-0.00243568566928243,0.449287256677033,-0.521013288351307,
  -0.000226424479586318,-0.00178392167709474,0.465225312654649,-0.54258339476504,
  -0.000233210960850716,-0.00113215768490837,0.481163368632265,-0.564153501178773,
  -0.000239997442115225,-0.000480393692722014,0.49710142460988,-0.585723607592506,
  -0.000246783923379956,0.000171370299464346,0.513039480587496,-0.607293714006238,
  -0.000253570404643355,0.000823134291652927,0.528977536565112,-0.628863820419972,
  -0.000260356885907753,0.00147489828383973,0.544915592542728,-0.650433926833705,
  -9.65572740553866e-05,-0.014028497454653,0.162096622487676,-0.133090820295134,
  -0.000103230369417728,-0.0133764810638287,0.177965576355787,-0.154714222971821,
  -0.000109903464780126,-0.0127244646730047,0.193834530223897,-0.176337625648509,
  -0.000116576560142301,-0.0120724482821802,0.209703484092008,-0.197961028325197,
  -0.000123249655504754,-0.0114204318913559,0.225572437960119,-0.219584431001884,
  -0.000129922750866984,-0.0107684155005316,0.24144139182823,-0.241207833678572,
  -0.00013659584622927,-0.0101163991097073,0.25731034569634,-0.262831236355259,
  -0.000143268941591779,-0.00946438271888339,0.273179299564451,-0.284454639031947,
  -0.000149942036954065,-0.00881236632805904,0.289048253432562,-0.306078041708635,
  -0.000156615132316462,-0.00816034993723491,0.304917207300672,-0.327701444385322,
  -0.000163288227678748,-0.00750833354641078,0.320786161168783,-0.34932484706201,
  -0.000169961323041257,-0.00685631715558643,0.336655115036894,-0.370948249738697,
  -0.00017663441840321,-0.00620430076476186,0.352524068905005,-0.392571652415385,
  -0.000183307513765607,-0.00555228437393773,0.368393022773115,-0.414195055092073,
  -0.000189980609127893,-0.0049002679831136,0.384261976641226,-0.43581845776876,
  -0.000196653704490402,-0.00424825159228925,0.400130930509337,-0.457441860445448,
  -0.000203326799852799,-0.00359623520146535,0.415999884377447,-0.479065263122136,
  -0.000209999895215085,-0.00294421881064122,0.431868838245558,-0.500688665798823,
  -0.000216672990577482,-0.00229220241981709,0.447737792113668,-0.52231206847551,
  -0.000223346085939324,-0.00164018602899185,0.463606745981779,-0.543935471152198,
  -0.000230019181302055,-0.000988169638167946,0.47947569984989,-0.565558873828886,
  -0.000236692276664119,-0.00033615324734404,0.495344653718,-0.587182276505574,
  -0.000243365372026849,0.000315863143479866,0.511213607586111,-0.608805679182261,
  -0.000250038467389024,0.000967879534304661,0.527082561454222,-0.630429081858949,
  -0.000256711562751422,0.00161989592512812,0.542951515322332,-0.652052484535637,
  -9.52928558560773e-05,-0.0138401336541844,0.161677504997964,-0.133553902126001,
  -0.000101812081613084,-0.0131879760277055,0.177451846744137,-0.155250012773586,
  -0.00010833130737059,-0.012535818401227,0.193226188490309,-0.176946123421171,
  -0.000114850533127819,-0.0118836607747481,0.209000530236482,-0.198642234068756,
  -0.000121369758885159,-0.0112315031482696,0.224774871982655,-0.220338344716342,
  -0.000127888984642277,-0.0105793455217907,0.240549213728828,-0.242034455363927,
  -0.000134408210399339,-0.00992718789531177,0.256323555475001,-0.263730566011512,
  -0.000140927436156624,-0.00927503026883314,0.272097897221174,-0.285426676659097,
  -0.00014744666191413,-0.00862287264235473,0.287872238967346,-0.307122787306682,
  -0.000153965887671081,-0.00797071501587543,0.303646580713519,-0.328818897954267,
  -0.000160485113428255,-0.00731855738939657,0.319420922459692,-0.350515008601852,
  -0.000167004339185484,-0.00666639976291794,0.335195264205865,-0.372211119249437,
  -0.000173523564942935,-0.00601424213643975,0.350969605952038,-0.393907229897022,
  -0.00018004279069983,-0.00536208450996045,0.366743947698211,-0.415603340544608,
  -0.000186562016457503,-0.00470992688348226,0.382518289444383,-0.437299451192192,
  -0.000193081242214621,-0.00405776925700319,0.398292631190556,-0.458995561839777,
  -0.00019960046797185,-0.00340561163052455,0.414066972936729,-0.480691672487363,
  -0.000206119693728524,-0.00275345400404503,0.429841314682902,-0.502387783134948,
  -0.000212638919486308,-0.00210129637756706,0.445615656429075,-0.524083893782533,
  -0.000219158145243648,-0.00144913875108843,0.461389998175247,-0.545780004430118,
  -0.000225677371000765,-0.000796981124609797,0.47716433992142,-0.567476115077703,
  -0.000232196596757661,-0.000144823498130275,0.492938681667593,-0.589172225725288,
  -0.000238715822515001,0.000507334128347914,0.508713023413766,-0.610868336372873,
  -0.000245235048272341,0.00115949175482699,0.524487365159939,-0.632564447020458,
  -0.00025175427402957,0.00181164938130562,0.540261706906112,-0.654260557668043,
  -9.35773171724386e-05,-0.0135877673676663,0.16110716638979,-0.134179662358041,
  -9.98901491691129e-05,-0.01293579158175,0.176753033212161,-0.155974022934056,
  -0.000106202981165704,-0.0122838157958333,0.192398900034533,-0.177768383510071,
  -0.000112515813162462,-0.0116318400099168,0.208044766856905,-0.199562744086086,
  -0.000118828645158886,-0.0109798642240001,0.223690633679277,-0.221357104662101,
  -0.000125141477155644,-0.0103278884380839,0.239336500501648,-0.243151465238116,
  -0.000131454309152346,-0.00967591265216727,0.25498236732402,-0.264945825814131,
  -0.000137767141149103,-0.00902393686625103,0.270628234146391,-0.286740186390146,
  -0.00014407997314575,-0.00837196108033433,0.286274100968763,-0.308534546966161,
  -0.000150392805142396,-0.00771998529441764,0.301919967791135,-0.330328907542176,
  -0.000156705637138765,-0.00706800950850095,0.317565834613507,-0.35212326811819,
  -0.000163018469135578,-0.00641603372258448,0.333211701435879,-0.373917628694206,
  -0.000169331301132059,-0.00576405793666801,0.34885756825825,-0.39571198927022,
  -0.000175644133128872,-0.00511208215075176,0.364503435080622,-0.417506349846236,
  -0.000181956965125463,-0.00446010636483507,0.380149301902994,-0.43930071042225,
  -0.000188269797122276,-0.0038081305789186,0.395795168725365,-0.461095070998265,
  -0.000194582629118534,-0.00315615479300213,0.411441035547736,-0.48288943157428,
  -0.000200895461115125,-0.00250417900708499,0.427086902370109,-0.504683792150295,
  -0.000207208293111827,-0.00185220322116852,0.442732769192481,-0.52647815272631,
  -0.000213521125108751,-0.00120022743525228,0.458378636014852,-0.548272513302325,
  -0.000219833957105675,-0.000548251649336695,0.474024502837223,-0.57006687387834,
  -0.000226146789102044,0.000103724136580219,0.489670369659595,-0.591861234454355,
  -0.000232459621098746,0.000755699922497133,0.505316236481967,-0.61365559503037,
  -0.000238772453095115,0.00140767570841405,0.520962103304339,-0.635449955606385,
  -0.00024508528509215,0.00205965149432963,0.53660797012671,-0.6572443161824,
  -9.12763325408017e-05,-0.0132549861448596,0.160339171693365,-0.135014457284623,
  -9.73166533757563e-05,-0.012603920691451,0.175812526399135,-0.156939888097433,
  -0.000103356974210655,-0.0119528552380422,0.191285881104906,-0.178865318910243,
  -0.000109397295045666,-0.0113017897846338,0.206759235810677,-0.200790749723053,
  -0.000115437615880509,-0.0106507243312249,0.222232590516448,-0.222716180535863,
  -0.000121477936715408,-0.00999965887781618,0.237705945222219,-0.244641611348672,
  -0.000127518257550474,-0.00934859342440775,0.253179299927989,-0.266567042161482,
  -0.000133558578384985,-0.00869752797099843,0.26865265463376,-0.288492472974292,
  -0.000139598899220106,-0.00804646251759,0.284126009339531,-0.310417903787102,
  -0.000145639220055005,-0.00739539706418135,0.299599364045302,-0.332343334599912,
  -0.000151679540889793,-0.0067443316107727,0.315072718751072,-0.354268765412722,
  -0.000157719861724637,-0.00609326615736361,0.330546073456844,-0.376194196225532,
  -0.00016376018255948,-0.00544220070395474,0.346019428162614,-0.398119627038342,
  -0.000169800503394657,-0.00479113525054675,0.361492782868385,-0.420045057851152,
  -0.000175840824229168,-0.00414006979713699,0.376966137574156,-0.441970488663961,
  -0.000181881145064344,-0.00348900434372923,0.392439492279926,-0.463895919476771,
  -0.000187921465898966,-0.00283793889031991,0.407912846985697,-0.485821350289581,
  -0.000193961786734143,-0.00218687343691171,0.423386201691468,-0.507746781102391,
  -0.000200002107569208,-0.00153580798350306,0.438859556397239,-0.529672211915201,
  -0.000206042428403941,-0.000884742530093963,0.45433291110301,-0.551597642728011,
  -0.000212082749239451,-0.000233677076686423,0.46980626580878,-0.573523073540821,
  -0.00021812307007385,0.000417388376722894,0.485279620514551,-0.595448504353631,
  -0.000224163390908694,0.00106845383013132,0.500752975220321,-0.61737393516644,
  -0.000230203711743759,0.00171951928354064,0.516226329926093,-0.639299365979251,
  -0.000236244032578714,0.00237058473694907,0.531699684631864,-0.66122479679206,
  -8.82374095284577e-05,-0.0128253175285241,0.159319636936119,-0.136109234287343,
  -9.39254667058353e-05,-0.0121766047217775,0.174564812783837,-0.158206554837878,
  -9.9613523883324e-05,-0.011527891915031,0.189809988631556,-0.180303875388413,
  -0.000105301581060924,-0.0108791791082846,0.205055164479274,-0.202401195938947,
  -0.00011098963823819,-0.0102304663015381,0.220300340326992,-0.224498516489482,
  -0.000116677695415845,-0.00958175349479196,0.23554551617471,-0.246595837040017,
  -0.000122365752593112,-0.00893304068804524,0.250790692022428,-0.268693157590552,
  -0.000128053809770712,-0.00828432788129851,0.266035867870147,-0.290790478141087,
  -0.000133741866948089,-0.00763561507455224,0.281281043717865,-0.312887798691621,
  -0.000139429924125523,-0.00698690226780552,0.296526219565583,-0.334985119242156,
  -0.0001451179813029,-0.0063381894610588,0.311771395413301,-0.357082439792691,
  -0.0001508060384805,-0.00568947665431252,0.32701657126102,-0.379179760343226,
  -0.000156494095657767,-0.00504076384756602,0.342261747108738,-0.401277080893761,
  -0.000162182152835366,-0.00439205104081974,0.357506922956456,-0.423374401444295,
  -0.000167870210012744,-0.00374333823407302,0.372752098804174,-0.44547172199483,
  -0.000173558267190344,-0.00309462542732675,0.387997274651892,-0.467569042545365,
  -0.000179246324367499,-0.00244591262058003,0.40324245049961,-0.4896663630959,
  -0.000184934381544877,-0.00179719981383308,0.418487626347329,-0.511763683646435,
  -0.000190622438722476,-0.00114848700708681,0.433732802195047,-0.533861004196969,
  -0.000196310495899743,-0.000499774200339864,0.448977978042766,-0.555958324747504,
  -0.000201998553077343,0.00014893860640619,0.464223153890484,-0.578055645298039,
  -0.000207686610254498,0.000797651413153133,0.479468329738202,-0.600152965848574,
  -0.000213374667432431,0.00144636421989919,0.49471350558592,-0.622250286399108,
  -0.000219062724609587,0.00209507702664569,0.509958681433638,-0.644347606949643,
  -0.000224750781787408,0.00274378983339219,0.525203857281357,-0.666444927500178,
  -8.43049934345363e-05,-0.0122855440681731,0.157991628026262,-0.137513206647351,
  -8.95502806999571e-05,-0.0116417768731061,0.172940957703181,-0.159830963359894,
  -9.47955679653223e-05,-0.010998009678039,0.187890287380099,-0.182148720072438,
  -0.000100040855230688,-0.0103542424829719,0.202839617057018,-0.204466476784981,
  -0.000105286142495997,-0.00971047528790492,0.217788946733937,-0.226784233497524,
  -0.000110531429761307,-0.00906670809283783,0.232738276410855,-0.249101990210067,
  -0.000115776717026672,-0.00842294089777051,0.247687606087774,-0.27141974692261,
  -0.000121022004292204,-0.00777917370270398,0.262636935764693,-0.293737503635154,
  -0.00012626729155768,-0.00713540650763678,0.277586265441612,-0.316055260347697,
  -0.000131512578822324,-0.00649163931256913,0.29253559511853,-0.33837301706024,
  -0.0001367578660878,-0.00584787211750215,0.307484924795449,-0.360690773772783,
  -0.000142003153352888,-0.00520410492243473,0.322434254472368,-0.383008530485326,
  -0.000147248440618641,-0.00456033772736819,0.337383584149286,-0.405326287197869,
  -0.000152493727884173,-0.00391657053230121,0.352332913826205,-0.427644043910413,
  -0.00015773901514915,-0.00327280333723379,0.367282243503124,-0.449961800622956,
  -0.000162984302414571,-0.00262903614216681,0.382231573180043,-0.472279557335499,
  -0.000168229589679658,-0.00198526894709938,0.397180902856961,-0.494597314048042,
  -0.00017347487694519,-0.0013415017520324,0.41213023253388,-0.516915070760586,
  -0.000178720164210611,-0.000697734556965424,0.427079562210799,-0.539232827473128,
  -0.000183965451476253,-5.39673618988878e-05,0.442028891887717,-0.561550584185672,
  -0.00018921073874123,0.000589799833168758,0.456978221564636,-0.583868340898215,
  -0.000194456026006318,0.00123356702823596,0.471927551241555,-0.606186097610758,
  -0.000199701313271627,0.00187733422330361,0.486876880918474,-0.628503854323301,
  -0.000204946600537048,0.00252110141837036,0.501826210595393,-0.650821611035845,
  -0.000210191887802802,0.00316486861343668,0.516775540272311,-0.673139367748388,
  -7.93491674057067e-05,-0.0116305897499808,0.156304265631554,-0.139262949186268,
  -8.40577919143937e-05,-0.0109960276981653,0.170879818105791,-0.161855431057774,
  -8.8766416422692e-05,-0.0103614656463494,0.185455370580027,-0.184447912929279,
  -9.34750409314344e-05,-0.00972690359453376,0.200030923054264,-0.207040394800784,
  -9.81836654398993e-05,-0.00909234154271821,0.214606475528501,-0.22963287667229,
  -0.000102892289948364,-0.00845777949090232,0.229182028002737,-0.252225358543795,
  -0.000107600914456663,-0.00782321743908621,0.243757580476974,-0.274817840415301,
  -0.000112309538965294,-0.00718865538727065,0.258333132951211,-0.297410322286806,
  -0.000117018163473759,-0.00655409333545487,0.272908685425448,-0.320002804158311,
  -0.000121726787982279,-0.00591953128363887,0.287484237899685,-0.342595286029817,
  -0.000126435412490911,-0.00528496923182353,0.302059790373921,-0.365187767901322,
  -0.000131144036999542,-0.00465040718000798,0.316635342848158,-0.387780249772827,
  -0.00013585266150784,-0.00401584512819197,0.331210895322394,-0.410372731644333,
  -0.000140561286016583,-0.00338128307637642,0.345786447796631,-0.432965213515838,
  -0.00014526991052477,-0.00274672102455997,0.360362000270868,-0.455557695387344,
  -0.000149978535033402,-0.00211215897274442,0.374937552745105,-0.478150177258849,
  -0.000154687159542144,-0.00147759692092908,0.389513105219341,-0.500742659130354,
  -0.000159395784050553,-0.000843034869112858,0.404088657693578,-0.52333514100186,
  -0.000164104408558963,-0.0002084728172973,0.418664210167815,-0.545927622873365,
  -0.000168813033067816,0.000426089234518034,0.433239762642051,-0.56852010474487,
  -0.000173521657576226,0.00106065128633359,0.447815315116288,-0.591112586616376,
  -0.000178230282084746,0.00169521333814959,0.462390867590525,-0.613705068487881,
  -0.000182938906593266,0.00232977538996559,0.476966420064761,-0.636297550359386,
  -0.000187647531101343,0.00296433744178204,0.491541972538998,-0.658890032230892,
  -0.000192356155610529,0.00359889949359671,0.506117525013235,-0.681482514102397,
  -7.33084283427998e-05,-0.0108690271586309,0.154227234967652,-0.141367541756875,
  -7.7395808252001e-05,-0.0102500226536285,0.168345754685598,-0.164290463402033,
  -8.14831881611466e-05,-0.00963101814862588,0.182464274403545,-0.187213385047191,
  -8.55705680705143e-05,-0.00901201364362358,0.196582794121492,-0.210136306692349,
  -8.96579479794934e-05,-0.00839300913862084,0.210701313839439,-0.233059228337508,
  -9.37453278886391e-05,-0.00777400463361799,0.224819833557386,-0.255982149982666,
  -9.78327077979513e-05,-0.00715500012861559,0.238938353275333,-0.278905071627824,
  -0.000101920087707263,-0.00653599562361329,0.253056872993279,-0.301827993272982,
  -0.000106007467616687,-0.00591699111861121,0.267175392711226,-0.32475091491814,
  -0.000110094847525444,-0.00529798661360847,0.281293912429172,-0.347673836563299,
  -0.000114182227434312,-0.00467898210860529,0.295412432147119,-0.370596758208457,
  -0.000118269607344068,-0.00405997760360322,0.309530951865066,-0.393519679853615,
  -0.000122356987252714,-0.00344097309860025,0.323649471583013,-0.416442601498773,
  -0.000126444367162137,-0.00282196859359796,0.33776799130096,-0.439365523143932,
  -0.000130531747071783,-0.00220296408859588,0.351886511018906,-0.46228844478909,
  -0.000134619126980651,-0.00158395958359314,0.366005030736853,-0.485211366434248,
  -0.00013870650688963,-0.000964955078589957,0.3801235504548,-0.508134288079406,
  -0.00014279388679872,-0.000345950573587661,0.394242070172747,-0.531057209724564,
  -0.000146881266707699,0.000273053931415079,0.408360589890693,-0.553980131369722,
  -0.000150968646617455,0.000892058436416931,0.42247910960864,-0.576903053014881,
  -0.000155056026526768,0.00151106294141945,0.436597629326587,-0.599825974660039,
  -0.000159143406435525,0.00213006744642241,0.450716149044534,-0.622748896305197,
  -0.000163230786345059,0.00274907195142449,0.46483466876248,-0.645671817950355,
  -0.000167318166253705,0.00336807645642789,0.478953188480428,-0.668594739595514,
  -0.00017140554616335,0.00398708096142952,0.493071708198374,-0.691517661240672,
  -6.62387076846849e-05,-0.0100268952049943,0.151768758559499,-0.143793472285164,
  -6.96463069615461e-05,-0.00943192434013529,0.165350365663682,-0.167097286624643,
  -7.30539062381852e-05,-0.00883695347527602,0.178931972767865,-0.190401100964121,
  -7.64615055150464e-05,-0.00824198261041698,0.192513579872047,-0.2137049153036,
  -7.98691047917965e-05,-0.00764701174555782,0.20609518697623,-0.237008729643079,
  -8.32767040687687e-05,-0.00705204088069888,0.219676794080413,-0.260312543982558,
  -8.66843033453524e-05,-0.00645707001583928,0.233258401184596,-0.283616358322036,
  -9.0091902622158e-05,-0.00586209915098057,0.246840008288779,-0.306920172661515,
  -9.34995018992413e-05,-0.00526712828612164,0.260421615392961,-0.330223987000994,
  -9.69071011758804e-05,-0.0046721574212627,0.274003222497144,-0.353527801340473,
  -0.000100314700452242,-0.00407718655640266,0.287584829601327,-0.376831615679952,
  -0.000103722299729547,-0.00348221569154439,0.30116643670551,-0.400135430019431,
  -0.000107129899006408,-0.00288724482668568,0.314748043809692,-0.423439244358909,
  -0.000110537498283048,-0.00229227396182585,0.328329650913876,-0.446743058698388,
  -0.000113945097559465,-0.00169730309696625,0.341911258018059,-0.470046873037867,
  -0.000117352696836104,-0.00110233223210687,0.355492865122241,-0.493350687377346,
  -0.000120760296113631,-0.000507361367248826,0.369074472226424,-0.516654501716824,
  -0.000124167895390159,8.76094976105524e-05,0.382656079330607,-0.539958316056303,
  -0.000127575494666909,0.000682580362469709,0.39623768643479,-0.563262130395782,
  -0.000130983093942993,0.00127755122732998,0.409819293538973,-0.586565944735261,
  -0.000134390693220521,0.00187252209218736,0.423400900643154,-0.60986975907474,
  -0.00013779829249716,0.00246749295704696,0.436982507747338,-0.633173573414219,
  -0.000141205891773799,0.00306246382190656,0.450564114851521,-0.656477387753697,
  -0.000144613491050771,0.00365743468676527,0.464145721955704,-0.679781202093176,
  -0.000148021090327299,0.00425240555162532,0.477727329059887,-0.703085016432655,
  -5.83493734662988e-05,-0.00914679607477842,0.148990860315642,-0.146456348314583,
  -6.1060915826916e-05,-0.00858576022960544,0.161970663058358,-0.17017825790191,
  -6.37724581875609e-05,-0.00802472438443202,0.174950465801074,-0.193900167489237,
  -6.64840005480949e-05,-0.0074636885392585,0.18793026854379,-0.217622077076563,
  -6.91955429087954e-05,-0.00690265269408552,0.200910071286505,-0.24134398666389,
  -7.19070852696069e-05,-0.00634161684891255,0.213889874029221,-0.265065896251217,
  -7.46186276303629e-05,-0.00578058100373946,0.226869676771936,-0.288787805838544,
  -7.73301699908968e-05,-0.00521954515856615,0.239849479514652,-0.312509715425871,
  -8.00417123514308e-05,-0.00465850931339284,0.252829282257368,-0.336231625013198,
  -8.27532547122423e-05,-0.00409747346821976,0.265809085000084,-0.359953534600524,
  -8.54647970731648e-05,-0.0035364376230469,0.278788887742799,-0.383675444187851,
  -8.81763394339208e-05,-0.00297540177787403,0.291768690485515,-0.407397353775178,
  -9.08878817946768e-05,-0.00241436593270072,0.304748493228231,-0.431119263362505,
  -9.35994241548777e-05,-0.00185333008752675,0.317728295970947,-0.454841172949832,
  -9.63109665156336e-05,-0.00129229424235366,0.330708098713663,-0.478563082537159,
  -9.90225088760566e-05,-0.000731258397180579,0.343687901456378,-0.502284992124486,
  -0.000101734051237257,-0.000170222552007715,0.356667704199094,-0.526006901711812,
  -0.000104445593597458,0.000390813293166037,0.36964750694181,-0.549728811299139,
  -0.000107157135958214,0.000951849138338901,0.382627309684525,-0.573450720886466,
  -0.000109868678319414,0.00151288498351176,0.395607112427241,-0.597172630473793,
  -0.00011258022068017,0.00207392082868463,0.408586915169957,-0.62089454006112,
  -0.000115291763040704,0.00263495667385749,0.421566717912672,-0.644616449648447,
  -0.000118003305400793,0.00319599251903213,0.434546520655388,-0.668338359235773,
  -0.000120714847761549,0.00375702836420455,0.447526323398104,-0.692060268823101,
  -0.000123426390122194,0.0043180642093783,0.46050612614082,-0.715782178410427,
  -5.00008437605282e-05,-0.0082806122605158,0.146012545416299,-0.149226898824529,
  -5.20510459185441e-05,-0.00776331374063288,0.158352378488708,-0.173383809511919,
  -5.41012480767544e-05,-0.00724601522075019,0.170692211561116,-0.19754072019931,
  -5.61514502348537e-05,-0.00672871670086739,0.183032044633524,-0.221697630886701,
  -5.82016523930085e-05,-0.0062114181809847,0.195371877705932,-0.245854541574092,
  -6.02518545513853e-05,-0.005694119661102,0.207711710778341,-0.270011452261483,
  -6.23020567090404e-05,-0.00517682114121887,0.220051543850749,-0.294168362948873,
  -6.43522588675838e-05,-0.00465952262133662,0.232391376923157,-0.318325273636264,
  -6.64024610255165e-05,-0.00414222410145371,0.244731209995565,-0.342482184323655,
  -6.84526631838933e-05,-0.00362492558157146,0.257071043067973,-0.366639095011046,
  -7.05028653420481e-05,-0.00310762706168832,0.269410876140382,-0.390796005698437,
  -7.25530674999808e-05,-0.00259032854180563,0.28175070921279,-0.414952916385828,
  -7.46032696582466e-05,-0.00207303002192294,0.294090542285198,-0.439109827073218,
  -7.66534718161793e-05,-0.00155573150204003,0.306430375357606,-0.463266737760609,
  -7.87036739744451e-05,-0.00103843298215733,0.318770208430015,-0.487423648448,
  -8.07538761323778e-05,-0.00052113446227442,0.331110041502423,-0.511580559135391,
  -8.28040782908657e-05,-3.83594239217189e-06,0.343449874574831,-0.535737469822782,
  -8.48542804487984e-05,0.000513462577490742,0.355789707647239,-0.559894380510173,
  -8.69044826065091e-05,0.0010307610973741,0.368129540719647,-0.584051291197563,
  -8.89546847649969e-05,0.00154805961725657,0.380469373792056,-0.608208201884954,
  -9.10048869232627e-05,0.00206535813713948,0.392809206864464,-0.632365112572345,
  -9.30550890809734e-05,0.00258265665702284,0.405149039936873,-0.656522023259736,
  -9.51052912396833e-05,0.00309995517690442,0.41748887300928,-0.680678933947127,
  -9.7155493397727e-05,0.00361725369678734,0.429828706081689,-0.704835844634518,
  -9.92056955558818e-05,0.00413455221666981,0.442168539154097,-0.728992755321908,
  -4.1649144156386e-05,-0.00747778791928899,0.1429938539503,-0.151953420834266,
  -4.31194110468991e-05,-0.00701196418013939,0.154690116754021,-0.176538419755143,
  -4.45896779373012e-05,-0.00654614044099,0.166386379557741,-0.201123418676019,
  -4.60599448279808e-05,-0.00608031670184073,0.178082642361462,-0.225708417596895,
  -4.75302117183274e-05,-0.00561449296269123,0.189778905165182,-0.250293416517771,
  -4.9000478609118e-05,-0.00514866922354185,0.201475167968903,-0.274878415438647,
  -5.04707454994646e-05,-0.00468284548439235,0.213171430772624,-0.299463414359523,
  -5.19410123900332e-05,-0.00421702174524308,0.224867693576344,-0.324048413280399,
  -5.34112792803243e-05,-0.00375119800609336,0.236563956380065,-0.348633412201276,
  -5.48815461711705e-05,-0.00328537426694431,0.248260219183785,-0.373218411122152,
  -5.6351813061406e-05,-0.00281955052779437,0.259956481987506,-0.397803410043028,
  -5.78220799517526e-05,-0.00235372678864443,0.271652744791227,-0.422388408963904,
  -5.92923468426543e-05,-0.00188790304949538,0.283349007594947,-0.44697340788478,
  -6.07626137333339e-05,-0.00142207931034699,0.295045270398667,-0.471558406805656,
  -6.22328806233474e-05,-0.000956255571196385,0.306741533202388,-0.496143405726533,
  -6.37031475140271e-05,-0.000490431832047111,0.318437796006109,-0.520728404647409,
  -6.51734144045957e-05,-2.46080928978376e-05,0.330134058809829,-0.545313403568285,
  -6.66436812952753e-05,0.000441215646250992,0.341830321613549,-0.569898402489161,
  -6.81139481855109e-05,0.000907039385401376,0.353526584417271,-0.594483401410037,
  -6.95842150765236e-05,0.00137286312454998,0.365222847220991,-0.619068400330913,
  -7.10544819670922e-05,0.00183868686369948,0.376919110024712,-0.64365339925179,
  -7.25247488566616e-05,0.00230451060284986,0.388615372828432,-0.668238398172666,
  -7.39950157475633e-05,0.00277033434199936,0.400311635632153,-0.692823397093541,
  -7.54652826381319e-05,0.00323615808114841,0.412007898435873,-0.717408396014418,
  -7.69355495288115e-05,0.00370198182029746,0.423704161239594,-0.741993394935294,
  -3.37508690498589e-05,-0.00677438140676512,0.140103258196382,-0.154493536871263,
  -3.47523332031585e-05,-0.00636407390783766,0.15118765866025,-0.179477356628077,
  -3.57537973568189e-05,-0.00595376640891054,0.162272059124119,-0.204461176384891,
  -3.67552615102018e-05,-0.00554345890998331,0.173356459587987,-0.229444996141705,
  -3.77567256637512e-05,-0.00513315141105608,0.184440860051856,-0.254428815898518,
  -3.87581898171896e-05,-0.00472284391212874,0.195525260515725,-0.279412635655332,
  -3.97596539704614e-05,-0.00431253641320106,0.206609660979594,-0.304396455412146,
  -4.07611181241219e-05,-0.00390222891427427,0.217694061443462,-0.32938027516896,
  -4.17625822773382e-05,-0.0034919214153466,0.228778461907331,-0.354364094925773,
  -4.27640464311652e-05,-0.00308161391641959,0.239862862371199,-0.379347914682587,
  -4.37655105844925e-05,-0.00267130641749236,0.250947262835068,-0.404331734439401,
  -4.47669747383195e-05,-0.00226099891856557,0.262031663298936,-0.429315554196214,
  -4.57684388915913e-05,-0.0018506914196379,0.273116063762805,-0.454299373953028,
  -4.67699030453073e-05,-0.00144038392071111,0.284200464226674,-0.479283193709842,
  -4.77713671985791e-05,-0.00103007642178388,0.295284864690542,-0.504267013466656,
  -4.8772831352295e-05,-0.000619768922857089,0.30636926515441,-0.529250833223469,
  -4.97742955052338e-05,-0.000209461423928969,0.317453665618279,-0.554234652980283,
  -5.07757596593938e-05,0.000200846074997596,0.328538066082148,-0.579218472737097,
  -5.17772238124437e-05,0.000611153573925272,0.339622466546017,-0.604202292493911,
  -5.27786879659375e-05,0.0010214610728525,0.350706867009885,-0.629186112250724,
  -5.37801521195425e-05,0.00143176857178018,0.361791267473754,-0.654169932007538,
  -5.47816162728143e-05,0.00184207607070741,0.372875667937623,-0.679153751764352,
  -5.57830804270854e-05,0.00225238356963331,0.383960068401491,-0.704137571521165,
  -5.67845445798021e-05,0.00266269106856232,0.39504446886536,-0.729121391277979,
  -5.77860087340731e-05,0.00307299856748777,0.406128869329228,-0.754105211034793,
  -2.6667957315929e-05,-0.00618777214258726,0.137481549880341,-0.156742000544548,
  -2.73189038292321e-05,-0.00583271698214405,0.148014448552917,-0.182078849119217,
  -2.79698503422576e-05,-0.00547766182170062,0.158547347225494,-0.207415697693885,
  -2.86207968553387e-05,-0.00512260666125741,0.16908024589807,-0.232752546268554,
  -2.92717433685863e-05,-0.00476755150081409,0.179613144570646,-0.258089394843222,
  -2.99226898816118e-05,-0.00441249634037066,0.190146043243222,-0.28342624341789,
  -3.05736363946929e-05,-0.00405744117992723,0.200678941915799,-0.308763091992559,
  -3.12245829076074e-05,-0.00370238601948381,0.211211840588375,-0.334099940567227,
  -3.18755294210771e-05,-0.00334733085904082,0.221744739260951,-0.359436789141895,
  -3.25264759336585e-05,-0.00299227569859672,0.232277637933528,-0.384773637716564,
  -3.31774224470172e-05,-0.00263722053815374,0.242810536606104,-0.410110486291232,
  -3.38283689602648e-05,-0.00228216537771053,0.25334343527868,-0.435447334865901,
  -3.44793154735124e-05,-0.0019271102172671,0.263876333951256,-0.460784183440569,
  -3.51302619864269e-05,-0.0015720550568239,0.274409232623832,-0.486121032015237,
  -3.57812084994524e-05,-0.00121699989638069,0.284942131296408,-0.511457880589906,
  -3.64321550127e-05,-0.000861944735937481,0.295475029968985,-0.536794729164574,
  -3.70831015263917e-05,-0.000506889575494718,0.306007928641561,-0.562131577739243,
  -3.77340480390842e-05,-0.0001518344150504,0.316540827314138,-0.587468426313911,
  -3.83849945514436e-05,0.000203220745393473,0.327073725986714,-0.612805274888579,
  -3.90359410652463e-05,0.000558275905836236,0.33760662465929,-0.638142123463248,
  -3.96868875783829e-05,0.000913331066279444,0.348139523331866,-0.663478972037916,
  -4.03378340910754e-05,0.00126838622672309,0.358672422004442,-0.688815820612585,
  -4.09887806041009e-05,0.00162344138716675,0.369205320677019,-0.714152669187253,
  -4.16397271180147e-05,0.00197849654760862,0.379738219349595,-0.739489517761921,
  -4.22906736302631e-05,0.00233355170805405,0.390271118022172,-0.76482636633659,
  -2.06117743312972e-05,-0.00571810715990129,0.135217681313593,-0.158643951709748,
  -2.10185152314524e-05,-0.00541428565188995,0.145276817734889,-0.184279423553027,
  -2.14252561317463e-05,-0.00511046414387861,0.155335954156185,-0.209914895396306,
  -2.18319970321512e-05,-0.00480664263586728,0.165395090577481,-0.235550367239585,
  -2.22387379325006e-05,-0.00450282112785594,0.175454226998777,-0.261185839082864,
  -2.26454788325725e-05,-0.0041989996198446,0.185513363420073,-0.286821310926142,
  -2.30522197330885e-05,-0.00389517811183371,0.195572499841369,-0.312456782769421,
  -2.34589606333269e-05,-0.00359135660382237,0.205631636262665,-0.3380922546127,
  -2.38657015336763e-05,-0.00328753509581126,0.215690772683961,-0.363727726455979,
  -2.42724424338592e-05,-0.0029837135877997,0.225749909105257,-0.389363198299257,
  -2.4679183333931e-05,-0.00267989207978769,0.235809045526554,-0.414998670142536,
  -2.5085924234336e-05,-0.0023760705717768,0.24586818194785,-0.440634141985815,
  -2.54926651341858e-05,-0.0020722490637648,0.255927318369146,-0.466269613829093,
  -2.58994060349238e-05,-0.00176842755575413,0.265986454790442,-0.491905085672372,
  -2.63061469346626e-05,-0.00146460604774235,0.276045591211738,-0.517540557515651,
  -2.67128878348455e-05,-0.00116078453973079,0.286104727633034,-0.54317602935893,
  -2.71196287353614e-05,-0.000856963031720337,0.29616386405433,-0.568811501202208,
  -2.75263696358774e-05,-0.000553141523708556,0.306223000475627,-0.594446973045487,
  -2.79331105359493e-05,-0.000249320015697219,0.316282136896922,-0.620082444888766,
  -2.83398514364652e-05,5.45014923138964e-05,0.326341273318218,-0.645717916732044,
  -2.87465923365371e-05,0.000358323000325456,0.336400409739515,-0.671353388575323,
  -2.9153333236831e-05,0.000662144508337015,0.346459546160811,-0.696988860418602,
  -2.95600741369029e-05,0.00096596601634813,0.356518682582107,-0.722624332261881,
  -2.99668150374188e-05,0.00126978752435924,0.366577819003403,-0.748259804105159,
  -3.03735559383789e-05,0.00157360903236947,0.376636955424698,-0.773895275948438,
  -1.56401730516953e-05,-0.00535386897811518,0.133343846221497,-0.16019196666412,
  -1.5886728459702e-05,-0.00509479837193472,0.14301247643955,-0.18607049063933,
  -1.61332838677364e-05,-0.00483572776575414,0.152681106657604,-0.211949014614541,
  -1.63798392761039e-05,-0.00457665715957412,0.162349736875657,-0.237827538589751,
  -1.66263946840273e-05,-0.00431758655339332,0.172018367093711,-0.263706062564962,
  -1.68729500921727e-05,-0.00405851594721307,0.181686997311764,-0.289584586540172,
  -1.71195055003182e-05,-0.00379944534103283,0.191355627529818,-0.315463110515383,
  -1.73660609084636e-05,-0.00354037473485214,0.201024257747871,-0.341341634490593,
  -1.7612616316609e-05,-0.00328130412867189,0.210692887965925,-0.367220158465803,
  -1.7859171724699e-05,-0.0030222335224912,0.220361518183979,-0.393098682441014,
  -1.81057271327889e-05,-0.00276316291631096,0.230030148402032,-0.418977206416224,
  -1.83522825406568e-05,-0.00250409231013027,0.239698778620085,-0.444855730391435,
  -1.85988379493018e-05,-0.00224502170395069,0.249367408838139,-0.470734254366645,
  -1.88453933576138e-05,-0.00198595109777044,0.259036039056192,-0.496612778341856,
  -1.90919487651486e-05,-0.00172688049158976,0.268704669274245,-0.522491302317066,
  -1.93385041739047e-05,-0.00146780988540973,0.278373299492299,-0.548369826292277,
  -1.95850595816616e-05,-0.0012087392792286,0.288041929710353,-0.574248350267487,
  -1.98316149898625e-05,-0.000949668673048576,0.297710559928406,-0.600126874242698,
  -2.00781703979525e-05,-0.000690598066868109,0.30737919014646,-0.626005398217908,
  -2.03247258061534e-05,-0.000431527460687864,0.317047820364513,-0.651883922193118,
  -2.05712812143544e-05,-0.000172456854507619,0.326716450582567,-0.677762446168329,
  -2.08178366216671e-05,8.66137516739585e-05,0.33638508080062,-0.703640970143539,
  -2.10643920308673e-05,0.000345684357853315,0.346053711018674,-0.72951949411875,
  -2.13109474387352e-05,0.000604754964034004,0.355722341236727,-0.75539801809396,
  -2.1557502846381e-05,0.000863825570214694,0.365390971454781,-0.781276542069171,
  -1.16930969399354e-05,-0.00507804538306245,0.131846195381745,-0.161412865062537,
  -1.18395365694135e-05,-0.00485620558137778,0.141203732622371,-0.187483080957628,
  -1.19859761988916e-05,-0.00463436577969289,0.150561269862996,-0.213553296852719,
  -1.21324158283698e-05,-0.00441252597800801,0.159918807103622,-0.239623512747811,
  -1.22788554581255e-05,-0.00419068617632368,0.169276344344247,-0.265693728642902,
  -1.24252950874371e-05,-0.00396884637463835,0.178633881584873,-0.291763944537993,
  -1.25717347168597e-05,-0.00374700657295346,0.187991418825499,-0.317834160433084,
  -1.27181743465044e-05,-0.00352516677126924,0.197348956066124,-0.343904376328175,
  -1.28646139760935e-05,-0.00330332696958435,0.206706493306749,-0.369974592223267,
  -1.30110536054051e-05,-0.00308148716789947,0.216064030547375,-0.396044808118358,
  -1.31574932349388e-05,-0.0028596473662148,0.225421567788,-0.422115024013449,
  -1.33039328644724e-05,-0.00263780756452947,0.234779105028626,-0.44818523990854,
  -1.3450372494006e-05,-0.00241596776284525,0.244136642269251,-0.474255455803631,
  -1.35968121236507e-05,-0.00219412796116059,0.253494179509877,-0.500325671698722,
  -1.37432517531844e-05,-0.00197228815947548,0.262851716750503,-0.526395887593814,
  -1.3889691382829e-05,-0.00175044835779126,0.272209253991128,-0.552466103488905,
  -1.40361310118076e-05,-0.00152860855610526,0.281566791231754,-0.578536319383996,
  -1.41825706413412e-05,-0.00130676875442082,0.290924328472379,-0.604606535279087,
  -1.43290102712079e-05,-0.0010849289527366,0.300281865713005,-0.630676751174178,
  -1.44754499006305e-05,-0.00086308915105171,0.30963940295363,-0.656746967069269,
  -1.46218895299421e-05,-0.00064124934936638,0.318996940194256,-0.68281718296436,
  -1.47683291598089e-05,-0.000419409547681937,0.328354477434881,-0.708887398859452,
  -1.49147687897866e-05,-0.000197569745997939,0.337712014675507,-0.734957614754543,
  -1.50612084185431e-05,2.42700556878361e-05,0.347069551916133,-0.761027830649634,
  -1.52076480481877e-05,0.000246109857371835,0.356427089156758,-0.787098046544725,
  -8.64146219878292e-06,-0.00487274493939027,0.13068220539379,-0.162352081725297,
  -8.72754007852361e-06,-0.00468071059261466,0.139798559965167,-0.188569762999573,
  -8.81361795840307e-06,-0.00448867624583893,0.148914914536545,-0.214787444273849,
  -8.89969583817152e-06,-0.00429664189906354,0.158031269107922,-0.241005125548125,
  -8.98577371788445e-06,-0.00410460755228781,0.1671476236793,-0.2672228068224,
  -9.0718515977084e-06,-0.0039125732055123,0.176263978250677,-0.293440488096676,
  -9.15792947747684e-06,-0.00372053885873669,0.185380332822054,-0.319658169370952,
  -9.24400735718978e-06,-0.00352850451196107,0.194496687393432,-0.345875850645227,
  -9.33008523701373e-06,-0.00333647016518546,0.203613041964809,-0.372093531919503,
  -9.41616311667115e-06,-0.00314443581840984,0.212729396536187,-0.398311213193779,
  -9.50224099660613e-06,-0.00295240147163445,0.221845751107564,-0.424528894468055,
  -9.58831887598599e-06,-0.00276036712485839,0.230962105678942,-0.45074657574233,
  -9.67439675603199e-06,-0.00256833277808322,0.240078460250319,-0.476964257016606,
  -9.76047463574492e-06,-0.00237629843130738,0.249194814821697,-0.503181938290882,
  -9.84655251534683e-06,-0.00218426408453176,0.258311169393074,-0.529399619565157,
  -9.93263039517078e-06,-0.00199222973775615,0.267427523964451,-0.555617300839433,
  -1.00187082752168e-05,-0.00180019539098142,0.276543878535828,-0.581834982113709,
  -1.01047861549297e-05,-0.00160816104420536,0.285660233107206,-0.608052663387985,
  -1.01908640346426e-05,-0.00141612669742974,0.294776587678584,-0.63427034466226,
  -1.02769419145776e-05,-0.00122409235065435,0.303892942249961,-0.660488025936536,
  -1.03630197941795e-05,-0.00103205800387896,0.313009296821338,-0.686705707210812,
  -1.04490976741145e-05,-0.000840023657103561,0.322125651392715,-0.712923388485088,
  -1.05351755533833e-05,-0.000647989310326835,0.331242005964093,-0.739141069759363,
  -1.06212534334293e-05,-0.000455954963551886,0.340358360535471,-0.765358751033639,
  -1.07073313136974e-05,-0.000263920616776936,0.349474715106848,-0.791576432307915,
  -6.33000884706081e-06,-0.00472178870364792,0.12979697585986,-0.163060852918376,
  -6.38055721335906e-06,-0.00455291819349901,0.138730250963072,-0.189389817581125,
  -6.43110558001814e-06,-0.00438404768335054,0.147663526066284,-0.215718782243874,
  -6.48165394667721e-06,-0.00421517717320241,0.156596801169495,-0.242047746906623,
  -6.53220231316975e-06,-0.00404630666305394,0.165530076272707,-0.268376711569372,
  -6.58275067955127e-06,-0.00387743615290526,0.174463351375918,-0.294705676232121,
  -6.63329904609933e-06,-0.00370856564275646,0.18339662647913,-0.32103464089487,
  -6.68384741286943e-06,-0.00353969513260854,0.192329901582342,-0.347363605557619,
  -6.73439577908441e-06,-0.00337082462245952,0.201263176685553,-0.373692570220368,
  -6.78494414596553e-06,-0.00320195411231161,0.210196451788765,-0.400021534883117,
  -6.83549251234705e-06,-0.00303308360216259,0.219129726891977,-0.426350499545865,
  -6.88604087883959e-06,-0.00286421309201446,0.228063001995188,-0.452679464208614,
  -6.93658924511009e-06,-0.00269534258186543,0.2369962770984,-0.479008428871363,
  -6.98713761171366e-06,-0.00252647207171686,0.245929552201611,-0.505337393534112,
  -7.03768597798415e-06,-0.00235760156156806,0.254862827304823,-0.531666358196861,
  -7.08823434503181e-06,-0.00218873105142081,0.263796102408034,-0.55799532285961,
  -7.13878271152435e-06,-0.00201986054127157,0.272729377511246,-0.584324287522359,
  -7.18933107768382e-06,-0.00185099003112277,0.281662652614458,-0.610653252185108,
  -7.23987944450943e-06,-0.00168211952097463,0.290595927717669,-0.636982216847857,
  -7.290427811113e-06,-0.00151324901082672,0.29952920282088,-0.663311181510606,
  -7.34097617716145e-06,-0.00134437850067659,0.308462477924093,-0.689640146173355,
  -7.39152454387604e-06,-0.00117550799052868,0.317395753027304,-0.715969110836104,
  -7.44207291070165e-06,-0.00100663748038077,0.326329028130516,-0.742298075498853,
  -7.49262127719419e-06,-0.000837766970232412,0.335262303233727,-0.768627040161602,
  -7.54316964357571e-06,-0.000668896460084056,0.344195578336938,-0.794956004824351,
  -4.60617266223595e-06,-0.00461173345207377,0.129134773440109,-0.16358800181086,
  -4.6360770110665e-06,-0.00446046600189209,0.1379312845014,-0.189999733543656,
  -4.6659813601746e-06,-0.00430919855171075,0.146727795562692,-0.216411465276453,
  -4.69588570917168e-06,-0.00415793110152907,0.155524306623983,-0.24282319700925,
  -4.72579005805773e-06,-0.00400666365134761,0.164320817685275,-0.269234928742047,
  -4.75569440705481e-06,-0.00385539620116604,0.173117328746566,-0.295646660474844,
  -4.78559875621842e-06,-0.00370412875098491,0.181913839807858,-0.32205839220764,
  -4.81550310504897e-06,-0.0035528613008029,0.190710350869149,-0.348470123940437,
  -4.84540745371298e-06,-0.00340159385062111,0.199506861930441,-0.374881855673234,
  -4.87531180287659e-06,-0.00325032640043998,0.208303372991732,-0.401293587406031,
  -4.90521615181816e-06,-0.00309905895025842,0.217099884053024,-0.427705319138827,
  -4.93512050103728e-06,-0.00294779150007685,0.225896395114315,-0.454117050871624,
  -4.96502484970129e-06,-0.00279652404989505,0.234692906175607,-0.480528782604421,
  -4.99492919903144e-06,-0.00264525659971415,0.243489417236898,-0.506940514337218,
  -5.02483354802852e-06,-0.0024939891495328,0.25228592829819,-0.533352246070015,
  -5.05473789735866e-06,-0.00234272169935168,0.261082439359481,-0.559763977802811,
  -5.08464224591165e-06,-0.00219145424916989,0.269878950420772,-0.586175709535608,
  -5.11454659557486e-06,-0.00204018679898921,0.278675461482064,-0.612587441268405,
  -5.14445094412785e-06,-0.00188891934880653,0.287471972543356,-0.638999173001202,
  -5.17435529268084e-06,-0.00173765189862474,0.296268483604647,-0.665410904733998,
  -5.20425964178894e-06,-0.00158638444844339,0.305064994665939,-0.691822636466795,
  -5.23416399056398e-06,-0.0014351169982616,0.31386150572723,-0.718234368199592,
  -5.26406834000515e-06,-0.00128384954808025,0.322658016788522,-0.744646099932389,
  -5.29397268922427e-06,-0.00113258209789935,0.331454527849813,-0.771057831665186,
  -5.32387703788828e-06,-0.000981314647717557,0.340251038911105,-0.797469563397983,
  -3.33536137761548e-06,-0.00453197127607574,0.128645489278008,-0.163975845292442,
  -3.35330629214203e-06,-0.00439385947448934,0.137341051779052,-0.190448471905349,
  -3.3712512069739e-06,-0.00425574767290315,0.146036614280096,-0.216921098518255,
  -3.38919612141719e-06,-0.00411763587131653,0.15473217678114,-0.243393725131162,
  -3.40714103619355e-06,-0.00397952406973046,0.163427739282184,-0.269866351744068,
  -3.42508595096991e-06,-0.0038414122681445,0.172123301783228,-0.296338978356975,
  -3.44303086557973e-06,-0.00370330046655787,0.180818864284272,-0.322811604969881,
  -3.46097577996751e-06,-0.00356518866497146,0.189514426785315,-0.349284231582788,
  -3.47892069452183e-06,-0.00342707686338506,0.198209989286359,-0.375756858195695,
  -3.49686560979778e-06,-0.00328896506179954,0.206905551787403,-0.402229484808601,
  -3.51481052418556e-06,-0.00315085326021314,0.215601114288447,-0.428702111421508,
  -3.53275543873988e-06,-0.00301274145862673,0.224296676789491,-0.455174738034414,
  -3.55070035351623e-06,-0.00287462965704055,0.232992239290534,-0.481647364647321,
  -3.5686452678485e-06,-0.0027365178554537,0.241687801791578,-0.508119991260227,
  -3.58659018273588e-06,-0.00259840605386774,0.250383364292622,-0.534592617873134,
  -3.60453509751224e-06,-0.00246029425228222,0.259078926793666,-0.56106524448604,
  -3.6224800122886e-06,-0.00232218245069538,0.26777448929471,-0.587537871098947,
  -3.64042492673189e-06,-0.00218407064910897,0.276470051795754,-0.614010497711853,
  -3.65836984095314e-06,-0.00204595884752257,0.285165614296797,-0.64048312432476,
  -3.67631475572949e-06,-0.00190784704593616,0.293861176797841,-0.666955750937666,
  -3.69425967094994e-06,-0.00176973524435065,0.302556739298885,-0.693428377550573,
  -3.71220458550425e-06,-0.00163162344276424,0.311252301799929,-0.71990100416348,
  -3.73014950005857e-06,-0.00149351164117739,0.319947864300973,-0.746373630776386,
  -3.74809441494595e-06,-0.00135539983959188,0.328643426802016,-0.772846257389292,
  -3.76603932938924e-06,-0.00121728803800547,0.33733898930306,-0.799318884002199,
  -2.40647533106264e-06,-0.00447440157313828,0.128287254317087,-0.164258928304319,
  -2.41745189122344e-06,-0.0043460014150305,0.136908960986774,-0.190776001470766,
  -2.42842845105118e-06,-0.00421760125692239,0.14553066765646,-0.217293074637212,
  -2.43940501060136e-06,-0.00408920109881394,0.154152374326147,-0.243810147803659,
  -2.45038157059563e-06,-0.00396080094070594,0.162774080995833,-0.270327220970106,
  -2.46135813081194e-06,-0.00383240078259828,0.171395787665519,-0.296844294136552,
  -2.47233469019559e-06,-0.00370400062448972,0.180017494335206,-0.323361367302999,
  -2.48331125013435e-06,-0.00357560046638183,0.188639201004892,-0.349878440469445,
  -2.49428781012861e-06,-0.00344720030827372,0.197260907674579,-0.376395513635892,
  -2.50526437001186e-06,-0.00331880015016583,0.205882614344265,-0.402912586802339,
  -2.51624092972857e-06,-0.0031903999920575,0.214504321013952,-0.429429659968785,
  -2.5272174895008e-06,-0.00306199983394961,0.223126027683638,-0.455946733135232,
  -2.53819404938405e-06,-0.00293359967584106,0.231747734353325,-0.482463806301679,
  -2.54917060948934e-06,-0.00280519951773339,0.240369441023011,-0.508980879468125,
  -2.56014716915054e-06,-0.00267679935962506,0.248991147692698,-0.535497952634572,
  -2.57112372914481e-06,-0.00254839920151695,0.257612854362384,-0.562015025801018,
  -2.58210028902806e-06,-0.00241999904340928,0.26623456103207,-0.588532098967465,
  -2.59307684924437e-06,-0.00229159888530139,0.274856267701757,-0.615049172133912,
  -2.60405340890557e-06,-0.00216319872719284,0.283477974371444,-0.641566245300358,
  -2.61502996845575e-06,-0.00203479856908428,0.29209968104113,-0.668083318466805,
  -2.62600652878309e-06,-0.00190639841097662,0.300721387710817,-0.694600391633251,
  -2.63698308833327e-06,-0.00177799825286895,0.309343094380502,-0.721117464799698,
  -2.64795964821651e-06,-0.00164959809476084,0.317964801050189,-0.747634537966145,
  -2.65893620798874e-06,-0.00152119793665273,0.326586507719875,-0.774151611132592,
  -2.66991276809403e-06,-0.00139279777854417,0.335208214389562,-0.800668684299038,
  -1.73173381648462e-06,-0.00443296884346656,0.128026715296367,-0.164464346390841,
  -1.7385968573147e-06,-0.00431167376626507,0.136594736571357,-0.19101367202599,
  -1.74545989839459e-06,-0.0041903786890638,0.145162757846347,-0.217562997661139,
  -1.75232293919692e-06,-0.00406908361186265,0.153730779121336,-0.244112323296288,
  -1.75918597999924e-06,-0.00394778853466127,0.162298800396326,-0.270661648931437,
  -1.76604902096811e-06,-0.00382649345746011,0.170866821671316,-0.297210974566586,
  -1.77291206215902e-06,-0.00370519838025896,0.179434842946306,-0.323760300201735,
  -1.7797751027393e-06,-0.00358390330305736,0.188002864221296,-0.350309625836884,
  -1.78663814376367e-06,-0.0034626082258562,0.196570885496286,-0.376858951472033,
  -1.79350118501009e-06,-0.00334131314865527,0.205138906771276,-0.403408277107182,
  -1.80036422559038e-06,-0.00322001807145345,0.213706928046266,-0.429957602742331,
  -1.80722726617066e-06,-0.00309872299425185,0.222274949321256,-0.456506928377479,
  -1.81409030741708e-06,-0.00297742791705091,0.230842970596246,-0.483056254012628,
  -1.82095334844146e-06,-0.00285613283984976,0.239410991871236,-0.509605579647777,
  -1.82781638924379e-06,-0.00273483776264882,0.247979013146225,-0.536154905282926,
  -1.83467943026816e-06,-0.00261354268544767,0.256547034421215,-0.562704230918075,
  -1.84154247073742e-06,-0.00249224760824562,0.265115055696205,-0.589253556553224,
  -1.8484055117618e-06,-0.00237095253104425,0.273683076971196,-0.615802882188373,
  -1.85526855300822e-06,-0.00224965745384376,0.282251098246185,-0.642352207823522,
  -1.86213159347748e-06,-0.00212836237664105,0.290819119521176,-0.668901533458671,
  -1.86899463494594e-06,-0.002007067299441,0.299387140796165,-0.69545085909382,
  -1.8758576754152e-06,-0.00188577222223918,0.307955162071155,-0.722000184728969,
  -1.88272071677265e-06,-0.00176447714503825,0.316523183346145,-0.748549510364117,
  -1.88958375779702e-06,-0.00164318206783776,0.325091204621134,-0.775098835999267,
  -1.89644679871037e-06,-0.00152188699063638,0.333659225896124,-0.801648161634415,
  -1.24381567481735e-06,-0.00440320973356756,0.127838147741034,-0.164612777327467,
  -1.24820488994759e-06,-0.00428707894052194,0.136367328783441,-0.19118540794135,
  -1.25259410488354e-06,-0.00417094814747587,0.144896509825848,-0.217758038555233,
  -1.25698331998603e-06,-0.00405481735443025,0.153425690868254,-0.244330669169116,
  -1.26137253486647e-06,-0.00393868656138407,0.161954871910661,-0.270903299782999,
  -1.26576175007997e-06,-0.00382255576833823,0.170484052953068,-0.297475930396882,
  -1.27015096473837e-06,-0.00370642497529206,0.179013233995475,-0.324048561010765,
  -1.2745401800629e-06,-0.00359029418224655,0.187542415037882,-0.350621191624647,
  -1.27892939499885e-06,-0.00347416338920081,0.196071596080288,-0.37719382223853,
  -1.28331861010134e-06,-0.00335803259615486,0.204600777122695,-0.403766452852413,
  -1.28770782503729e-06,-0.0032419018031089,0.213129958165102,-0.430339083466296,
  -1.29209704036182e-06,-0.00312577101006362,0.221659139207508,-0.456911714080179,
  -1.29648625513124e-06,-0.00300964021701722,0.230188320249916,-0.483484344694062,
  -1.30087547001168e-06,-0.00289350942397104,0.238717501292323,-0.510056975307944,
  -1.30526468522518e-06,-0.00277737863092575,0.247246682334729,-0.536629605921828,
  -1.30965389977256e-06,-0.00266124783787891,0.255775863377136,-0.56320223653571,
  -1.31404311498606e-06,-0.0025451170448334,0.264305044419543,-0.589774867149593,
  -1.31843233008855e-06,-0.00242898625178789,0.27283422546195,-0.616347497763476,
  -1.32282154530206e-06,-0.00231285545874149,0.281363406504357,-0.642920128377359,
  -1.32721076029352e-06,-0.00219672466569554,0.289892587546764,-0.669492758991242,
  -1.33159997572907e-06,-0.00208059387265047,0.29842176858917,-0.696065389605125,
  -1.33598918983235e-06,-0.00196446307960363,0.306950949631577,-0.722638020219008,
  -1.34037840537893e-06,-0.00184833228655856,0.315480130673984,-0.749210650832891,
  -1.34476762025937e-06,-0.00173220149351216,0.324009311716391,-0.775783281446774,
  -1.34915683547288e-06,-0.0016160707004671,0.332538492758797,-0.802355912060657,
  -0.000109105830328471,-0.01594016039724,0.173284557167582,-0.137133789376549,
  -0.000116700637134093,-0.0153082751560351,0.189553833512804,-0.157869207663768,
  -0.000124295443939881,-0.0146763899148304,0.205823109858027,-0.178604625950987,
  -0.000131890250745614,-0.0140445046736256,0.222092386203249,-0.199340044238205,
  -0.000139485057550959,-0.0134126194324204,0.238361662548472,-0.220075462525424,
  -0.000147079864356747,-0.0127807341912156,0.254630938893694,-0.240810880812643,
  -0.000154674671162314,-0.0121488489500108,0.270900215238916,-0.261546299099862,
  -0.000162269477968269,-0.0115169637088064,0.287169491584139,-0.282281717387081,
  -0.000169864284774002,-0.0108850784676011,0.303438767929361,-0.3030171356743,
  -0.000177459091579402,-0.0102531932263963,0.319708044274584,-0.323752553961518,
  -0.000185053898385412,-0.0096213079851919,0.335977320619806,-0.344487972248737,
  -0.00019264870519109,-0.00898942274398706,0.352246596965028,-0.365223390535956,
  -0.000200243511996878,-0.00835753750278223,0.368515873310251,-0.385958808823175,
  -0.000207838318802556,-0.0077256522615774,0.384785149655473,-0.406694227110394,
  -0.000215433125608011,-0.00709376702037212,0.401054426000696,-0.427429645397613,
  -0.000223027932413689,-0.00646188177916751,0.417323702345918,-0.448165063684831,
  -0.000230622739219033,-0.00582999653796201,0.433592978691141,-0.46890048197205,
  -0.000238217546024933,-0.0051981112967574,0.449862255036363,-0.489635900259269,
  -0.00024581235283061,-0.00456622605555301,0.466131531381585,-0.510371318546488,
  -0.000253407159636398,-0.0039343408143484,0.482400807726808,-0.531106736833707,
  -0.000261001966441965,-0.00330245557314335,0.49867008407203,-0.551842155120926,
  -0.000268596773247864,-0.00267057033193874,0.514939360417253,-0.572577573408145,
  -0.000276191580052987,-0.00203868509073324,0.531208636762475,-0.593312991695363,
  -0.000283786386859997,-0.00140679984952996,0.547477913107697,-0.614048409982582,
  -0.000291381193664564,-0.00077491460832313,0.56374718945292,-0.634783828269801,
  -0.000107986145649386,-0.0157563919054167,0.172910847280786,-0.137563969118022,
  -0.00011544434687738,-0.015122889278699,0.189100722839485,-0.158362325876307,
  -0.00012290254810543,-0.0144893866519814,0.205290598398184,-0.179160682634591,
  -0.000130360749333591,-0.0138558840252641,0.221480473956883,-0.199959039392875,
  -0.000137818950561586,-0.0132223813985465,0.237670349515582,-0.220757396151159,
  -0.00014527715178958,-0.0125888787718289,0.253860225074281,-0.241555752909443,
  -0.000152735353017519,-0.0119553761451112,0.27005010063298,-0.262354109667727,
  -0.000160193554245958,-0.0113218735183942,0.286239976191679,-0.283152466426011,
  -0.000167651755474063,-0.0106883708916767,0.302429851750378,-0.303950823184295,
  -0.000175109956702058,-0.0100548682649593,0.318619727309077,-0.324749179942579,
  -0.000182568157930163,-0.00942136563824159,0.334809602867776,-0.345547536700863,
  -0.000190026359157991,-0.00878786301152368,0.350999478426475,-0.366345893459147,
  -0.000197484560386041,-0.00815436038480599,0.367189353985174,-0.387144250217431,
  -0.000204942761614424,-0.00752085775808897,0.383379229543872,-0.407942606975715,
  -0.000212400962842474,-0.00688735513137151,0.399569105102571,-0.428740963733999,
  -0.000219859164070302,-0.00625385250465382,0.41575898066127,-0.449539320492283,
  -0.000227317365298796,-0.0056203498779368,0.431948856219969,-0.470337677250567,
  -0.000234775566526846,-0.00498684725121934,0.448138731778668,-0.491136034008851,
  -0.000242233767754785,-0.00435334462450143,0.464328607337367,-0.511934390767135,
  -0.000249691968982613,-0.0037198419977833,0.480518482896066,-0.532732747525419,
  -0.000257150170210663,-0.00308633937106562,0.496708358454766,-0.553531104283703,
  -0.000264608371438824,-0.00245283674434882,0.512898234013464,-0.574329461041987,
  -0.000272066572667096,-0.00181933411763158,0.529088109572162,-0.595127817800271,
  -0.000279524773895368,-0.00118583149091389,0.545277985130862,-0.615926174558556,
  -0.000286982975122863,-0.000552328864196205,0.561467860689561,-0.636724531316839,
  -0.000106456655496245,-0.0155080632490269,0.17239894562501,-0.138149426872396,
  -0.000113729904062443,-0.0148726439950433,0.188480277429105,-0.159033440421043,
  -0.000121003152628307,-0.0142372247410596,0.2045616092332,-0.179917453969689,
  -0.000128276401194283,-0.0136018054870759,0.220642941037294,-0.200801467518335,
  -0.000135549649760425,-0.0129663862330924,0.236724272841389,-0.221685481066982,
  -0.000142822898326567,-0.0123309669791092,0.252805604645483,-0.242569494615628,
  -0.00015009614689232,-0.011695547725125,0.268886936449578,-0.263453508164275,
  -0.000157369395458518,-0.0110601284711418,0.284968268253673,-0.284337521712921,
  -0.000164642644024382,-0.0104247092171579,0.301049600057767,-0.305221535261567,
  -0.000171915892590357,-0.00978928996317419,0.317130931861862,-0.326105548810214,
  -0.000179189141156444,-0.00915387070919071,0.333212263665957,-0.34698956235886,
  -0.00018646238972253,-0.00851845145520724,0.349293595470051,-0.367873575907507,
  -0.000193735638288284,-0.00788303220122333,0.365374927274146,-0.388757589456153,
  -0.000201008886854592,-0.00724761294723986,0.381456259078241,-0.409641603004799,
  -0.000208282135420568,-0.00661219369325639,0.397537590882335,-0.430525616553446,
  -0.000215555383986432,-0.00597677443927247,0.41361892268643,-0.451409630102092,
  -0.000222828632552297,-0.00534135518528855,0.429700254490525,-0.472293643650739,
  -0.000230101881118827,-0.00470593593130575,0.445781586294619,-0.493177657199385,
  -0.000237375129684358,-0.00407051667732161,0.461862918098714,-0.514061670748031,
  -0.000244648378250667,-0.00343509742333836,0.477944249902808,-0.534945684296678,
  -0.000251921626816864,-0.00279967816935489,0.494025581706903,-0.555829697845324,
  -0.000259194875382618,-0.00216425891537098,0.510106913510998,-0.576713711393971,
  -0.000266468123948482,-0.00152883966138706,0.526188245315092,-0.597597724942617,
  -0.000273741372515235,-0.000893420407404921,0.542269577119186,-0.618481738491264,
  -0.000281014621080322,-0.000258001153419674,0.558350908923282,-0.63936575203991,
  -0.000104386300676274,-0.0151768206276401,0.171703447155883,-0.138937991401145,
  -0.000111412241128483,-0.0145393389677697,0.187637700220449,-0.159937377760249,
  -0.000118438181580471,-0.0139018573078993,0.203571953285014,-0.180936764119353,
  -0.000125464122032959,-0.0132643756480294,0.21950620634958,-0.201936150478457,
  -0.000132490062485169,-0.0126268939881592,0.235440459414145,-0.222935536837561,
  -0.000139516002937545,-0.0119894123282891,0.25137471247871,-0.243934923196665,
  -0.000146541943389478,-0.0113519306684184,0.267308965543276,-0.264934309555769,
  -0.000153567883841965,-0.0107144490085487,0.283243218607841,-0.285933695914873,
  -0.000160593824293953,-0.010076967348678,0.299177471672407,-0.306933082273977,
  -0.000167619764746607,-0.00943948568880848,0.315111724736972,-0.327932468633081,
  -0.00017464570519854,-0.00880200402893783,0.331045977801538,-0.348931854992185,
  -0.00018167164565086,-0.0081645223690674,0.346980230866104,-0.369931241351289,
  -0.000188697586103181,-0.00752704070919763,0.362914483930669,-0.390930627710393,
  -0.00019572352655528,-0.0068895590493272,0.378848736995234,-0.411930014069497,
  -0.000202749467007712,-0.00625207738945743,0.3947829900598,-0.432929400428601,
  -0.000209775407460033,-0.005614595729587,0.410717243124366,-0.453928786787705,
  -0.00021680134791191,-0.00497711406971635,0.426651496188931,-0.474928173146809,
  -0.000223827288364231,-0.00433963240984636,0.442585749253496,-0.495927559505913,
  -0.000230853228816774,-0.00370215074997637,0.458520002318062,-0.516926945865017,
  -0.00023787916926854,-0.00306466909010572,0.474454255382627,-0.537926332224121,
  -0.000244905109720861,-0.00242718743023529,0.490388508447193,-0.558925718583225,
  -0.000251931050173404,-0.00178970577036575,0.506322761511758,-0.579925104942329,
  -0.000258956990625614,-0.00115222411049531,0.522257014576324,-0.600924491301433,
  -0.000265982931078046,-0.000514742450625771,0.538191267640889,-0.621923877660537,
  -0.000273008871529479,0.000122739209245992,0.554125520705455,-0.642923264019641,
  -0.000101618181613972,-0.0147425973284282,0.170768974501748,-0.139985417343589,
  -0.000108318973942922,-0.0141032990303317,0.186506307265792,-0.161138049848469,
  -0.000115019766271818,-0.013464000732235,0.202243640029836,-0.182290682353348,
  -0.000121720558600491,-0.0128247024341381,0.217980972793881,-0.203443314858227,
  -0.000128421350929386,-0.0121854041360413,0.233718305557925,-0.224595947363106,
  -0.000135122143258115,-0.0115461058379448,0.249455638321969,-0.245748579867986,
  -0.000141822935586899,-0.0109068075398477,0.265192971086014,-0.266901212372865,
  -0.000148523727915739,-0.010267509241751,0.280930303850058,-0.288053844877744,
  -0.000155224520244635,-0.00962821094365451,0.296667636614102,-0.309206477382624,
  -0.00016192531257353,-0.00898891264555779,0.312404969378146,-0.330359109887503,
  -0.000168626104902536,-0.00834961434746107,0.328142302142191,-0.351511742392382,
  -0.00017532689723132,-0.00771031604936456,0.343879634906235,-0.372664374897262,
  -0.000182027689559994,-0.00707101775126762,0.359616967670279,-0.393817007402141,
  -0.000188728481888889,-0.00643171945317045,0.375354300434324,-0.41496963990702,
  -0.000195429274217673,-0.00579242115507395,0.391091633198368,-0.436122272411899,
  -0.000202130066547013,-0.00515312285697811,0.406828965962411,-0.457274904916779,
  -0.000208830858875686,-0.00451382455888139,0.422566298726456,-0.478427537421658,
  -0.000215531651204248,-0.00387452626078399,0.4383036314905,-0.499580169926537,
  -0.000222232443533144,-0.00323522796268749,0.454040964254544,-0.520732802431416,
  -0.000228933235861817,-0.00259592966459055,0.469778297018588,-0.541885434936296,
  -0.000235634028191267,-0.00195663136649493,0.485515629782632,-0.563038067441175,
  -0.000242334820519607,-0.0013173330683971,0.501252962546677,-0.584190699946054,
  -0.00024903561284928,-0.000678034770301039,0.516990295310721,-0.605343332450933,
  -0.000255736405177176,-3.87364722032046e-05,0.532727628074766,-0.626495964955813,
  -0.000262437197506737,0.000600561825892854,0.54846496083881,-0.647648597460692,
  -9.79777821442096e-05,-0.0141862851340914,0.169532192762625,-0.141351208302306,
  -0.00010426064261726,-0.0135462027558207,0.185010077374992,-0.162703666104494,
  -0.000110543503090199,-0.0129061203775498,0.200487961987359,-0.184056123906683,
  -0.000116826363563138,-0.0122660379992791,0.215965846599726,-0.205408581708871,
  -0.000123109224036189,-0.0116259556210084,0.231443731212093,-0.226761039511059,
  -0.00012939208450935,-0.0109858732427379,0.24692161582446,-0.248113497313248,
  -0.000135674944982123,-0.0103457908644669,0.262399500436827,-0.269465955115436,
  -0.000141957805455062,-0.00970570848619601,0.277877385049195,-0.290818412917624,
  -0.000148240665928057,-0.00906562610792538,0.293355269661561,-0.312170870719813,
  -0.000154523526401051,-0.00842554372965476,0.308833154273928,-0.333523328522001,
  -0.000160806386874102,-0.00778546135138392,0.324311038886295,-0.354875786324189,
  -0.000167089247347096,-0.00714537897311307,0.339788923498663,-0.376228244126378,
  -0.000173372107820091,-0.00650529659484267,0.355266808111029,-0.397580701928566,
  -0.000179654968292975,-0.00586521421657138,0.370744692723397,-0.418933159730754,
  -0.00018593782876597,-0.00522513183830053,0.386222577335764,-0.440285617532943,
  -0.000192220689238742,-0.00458504946002991,0.401700461948131,-0.461638075335131,
  -0.000198503549711626,-0.00394496708175884,0.417178346560498,-0.48299053313732,
  -0.000204786410184954,-0.00330488470348889,0.432656231172864,-0.504342990939508,
  -0.000211069270657838,-0.00266480232521782,0.448134115785232,-0.525695448741696,
  -0.000217352131130943,-0.00202471994694742,0.463612000397598,-0.547047906543884,
  -0.000223634991603716,-0.00138463756867635,0.479089885009966,-0.568400364346073,
  -0.0002299178520766,-0.000744555190405727,0.494567769622332,-0.589752822148261,
  -0.000236200712549262,-0.000104472812134215,0.5100456542347,-0.611105279950449,
  -0.000242483573022922,0.00053560956613552,0.525523538847066,-0.632457737752638,
  -0.000248766433494918,0.00117569194440748,0.541001423459434,-0.653810195554826,
  -9.32933258415147e-05,-0.0134943641406834,0.167927850514354,-0.143089848855785,
  -9.90547590565272e-05,-0.0128558854187758,0.1830710808969,-0.164696682602766,
  -0.000104816192271817,-0.0122174066968684,0.198214311279446,-0.186303516349747,
  -0.000110577625486996,-0.0115789279749612,0.213357541661992,-0.207910350096727,
  -0.000116339058702009,-0.0109404492530535,0.228500772044538,-0.229517183843708,
  -0.00012210049191741,-0.0103019705311462,0.243644002427084,-0.251124017590689,
  -0.000127861925132644,-0.00966349180923909,0.258787232809629,-0.27273085133767,
  -0.000133623358347434,-0.00902501308733106,0.273930463192176,-0.294337685084651,
  -0.000139384791562724,-0.00838653436542369,0.289073693574721,-0.315944518831631,
  -0.00014514622477807,-0.00774805564351677,0.304216923957267,-0.337551352578612,
  -0.000150907657993193,-0.00710957692160918,0.319360154339813,-0.359158186325593,
  -0.00015666909120815,-0.00647109819970138,0.334503384722359,-0.380765020072574,
  -0.000162430524423662,-0.00583261947779445,0.349646615104905,-0.402371853819555,
  -0.00016819195763873,-0.00519414075588664,0.364789845487451,-0.423978687566536,
  -0.000173953390853354,-0.00455566203397884,0.379933075869997,-0.445585521313516,
  -0.000179714824068866,-0.00391718331207191,0.395076306252542,-0.467192355060497,
  -0.000185476257284267,-0.00327870459016433,0.410219536635089,-0.488799188807478,
  -0.00019123769049878,-0.0026402258682563,0.425362767017635,-0.510406022554459,
  -0.000196999123714736,-0.00200174714634982,0.44050599740018,-0.53201285630144,
  -0.000202760556929249,-0.00136326842444134,0.455649227782726,-0.55361969004842,
  -0.000208521990144983,-0.000724789702534867,0.470792458165272,-0.575226523795402,
  -0.00021428342335994,-8.63109806270579e-05,0.485935688547818,-0.596833357542382,
  -0.00022004485657523,0.000552167741279863,0.501078918930363,-0.618440191289363,
  -0.000225806289790631,0.00119064646318723,0.51622214931291,-0.640047025036344,
  -0.000231567723006143,0.00182912518509415,0.531365379695455,-0.661653858783325,
  -8.74321996301441e-05,-0.0126652446511913,0.165900610755314,-0.145236662353547,
  -9.25676095201999e-05,-0.0120327796731364,0.180623854433982,-0.167157590759539,
  -9.77030194103667e-05,-0.0114003146950816,0.19534709811265,-0.18907851916553,
  -0.000102838429300367,-0.0107678497170266,0.210070341791318,-0.210999447571521,
  -0.000107973839190256,-0.0101353847389716,0.224793585469987,-0.232920375977512,
  -0.000113109249080201,-0.00950291976091644,0.239516829148655,-0.254841304383503,
  -0.000118244658970479,-0.00887045478286175,0.254240072827323,-0.276762232789494,
  -0.000123380068860479,-0.00823798980480683,0.268963316505992,-0.298683161195486,
  -0.000128515478750646,-0.00760552482675192,0.28368656018466,-0.320604089601477,
  -0.000133650888640258,-0.00697305984869656,0.298409803863328,-0.342525018007468,
  -0.000138786298530258,-0.00634059487064143,0.313133047541997,-0.364445946413459,
  -0.000143921708420591,-0.00570812989258673,0.327856291220665,-0.38636687481945,
  -0.000149057118310703,-0.00507566491453182,0.342579534899333,-0.408287803225441,
  -0.000154192528200481,-0.00444319993647646,0.357302778578002,-0.430208731631433,
  -0.000159327938090703,-0.00381073495842199,0.37202602225667,-0.452129660037424,
  -0.000164463347980814,-0.00317826998036708,0.386749265935338,-0.474050588443415,
  -0.000169598757870371,-0.0025458050023115,0.401472509614007,-0.495971516849406,
  -0.000174734167761037,-0.00191334002425725,0.416195753292675,-0.517892445255397,
  -0.000179869577650926,-0.00128087504620233,0.430918996971343,-0.539813373661388,
  -0.000185004987540704,-0.000648410068146976,0.445642240650011,-0.56173430206738,
  -0.000190140397430705,-1.5945090091396e-05,0.46036548432868,-0.583655230473371,
  -0.00019527580732126,0.000616519887962408,0.475088728007348,-0.605576158879362,
  -0.000200411217210816,0.00124898486601799,0.489811971686016,-0.627497087285353,
  -0.000205546627100706,0.00188144984407357,0.504535215364685,-0.649418015691344,
  -0.000210682036990595,0.00251391482212826,0.519258459043353,-0.671338944097335,
  -8.03522994982098e-05,-0.0117156773980369,0.163423066677582,-0.147789874344073,
  -8.47715379367342e-05,-0.0110961896811264,0.177637083345373,-0.170084356507939,
  -8.91907763753697e-05,-0.0104767019642161,0.191851100013164,-0.192378838671805,
  -9.36100148137831e-05,-0.00985721424730535,0.206065116680955,-0.214673320835671,
  -9.80292532525295e-05,-0.00923772653039512,0.220279133348745,-0.236967802999537,
  -0.000102448491691109,-0.00861823881348456,0.234493150016536,-0.259262285163402,
  -0.000106867730129467,-0.007998751096574,0.248707166684327,-0.281556767327269,
  -0.00011128696856777,-0.00737926337966299,0.262921183352118,-0.303851249491134,
  -0.000115706207006794,-0.00675977566275332,0.277135200019908,-0.326145731655,
  -0.000120125445445096,-0.00614028794584232,0.2913492166877,-0.348440213818866,
  -0.000124544683883454,-0.00552080022893175,0.30556323335549,-0.370734695982732,
  -0.000128963922322312,-0.00490131251202142,0.319777250023281,-0.393029178146598,
  -0.000133383160760614,-0.00428182479511041,0.333991266691072,-0.415323660310464,
  -0.000137802399199249,-0.0036623370782003,0.348205283358863,-0.43761814247433,
  -0.000142221637638107,-0.00304284936128996,0.362419300026654,-0.459912624638195,
  -0.000146640876075965,-0.00242336164437895,0.376633316694444,-0.482207106802061,
  -0.000151060114515045,-0.00180387392746884,0.390847333362235,-0.504501588965927,
  -0.000155479352953347,-0.00118438621055805,0.405061350030026,-0.526796071129793,
  -0.000159898591392205,-0.000564898493647936,0.419275366697816,-0.549090553293658,
  -0.000164317829830507,5.45892232630685e-05,0.433489383365607,-0.571385035457525,
  -0.00016873706826892,0.000674076940173407,0.447703400033398,-0.593679517621391,
  -0.000173156306707778,0.00129356465708375,0.461917416701189,-0.615973999785256,
  -0.000177575545145969,0.00191305237399453,0.47613143336898,-0.638268481949122,
  -0.000181994783584494,0.00253254009090487,0.49034545003677,-0.660562964112988,
  -0.000186414022022685,0.00315202780781609,0.504559466704562,-0.682857446276854,
  -7.21564063035918e-05,-0.0106839855395054,0.16051674839087,-0.150694371754829,
  -7.58030394666376e-05,-0.0100869894380015,0.174138615339031,-0.173413803326167,
  -7.94496726294613e-05,-0.00948999333649747,0.187760482287193,-0.196133234897505,
  -8.30963057922296e-05,-0.00889299723499326,0.201382349235354,-0.218852666468843,
  -8.67429389552199e-05,-0.00829600113348927,0.215004216183516,-0.241572098040181,
  -9.03895721179881e-05,-0.00769900503198517,0.228626083131678,-0.264291529611519,
  -9.40362052809229e-05,-0.00710200893048119,0.242247950079839,-0.287010961182857,
  -9.76828384439687e-05,-0.0065050128289772,0.255869817028001,-0.309730392754196,
  -0.000101329471606626,-0.00590801672747299,0.269491683976163,-0.332449824325534,
  -0.000104976104769783,-0.00531102062596944,0.283113550924324,-0.355169255896872,
  -0.000108622737932884,-0.00471402452446545,0.296735417872486,-0.37788868746821,
  -0.000112269371095208,-0.0041170284229608,0.310357284820648,-0.400608119039548,
  -0.00011591600425831,-0.00352003232145681,0.323979151768809,-0.423327550610886,
  -0.000119562637421078,-0.00292303621995305,0.33760101871697,-0.446046982182224,
  -0.000123209270583957,-0.00232604011844884,0.351222885665132,-0.468766413753562,
  -0.000126855903747169,-0.00172904401694551,0.364844752613293,-0.491485845324901,
  -0.00013050253691016,-0.00113204791544108,0.378466619561455,-0.514205276896239,
  -0.000134149170072262,-0.000535051813936205,0.392088486509617,-0.536924708467577,
  -0.000137795803236029,6.19442875668952e-05,0.405710353457779,-0.559644140038915,
  -0.000141442436398798,0.000658940389070661,0.41933222040594,-0.582363571610253,
  -0.000145089069561788,0.00125593649057487,0.432954087354102,-0.605083003181591,
  -0.000148735702724334,0.00185293259207953,0.446575954302264,-0.627802434752929,
  -0.000152382335887324,0.00244992869358285,0.460197821250425,-0.650521866324267,
  -0.000156028969050426,0.00304692479508706,0.473819688198587,-0.673241297895606,
  -0.000159675602212972,0.00364392089659127,0.487441555146748,-0.695960729466943,
  -6.31249316708771e-05,-0.00962659538787658,0.157267814668057,-0.153836009010444,
  -6.5993282822141e-05,-0.00906323379249774,0.170233775287234,-0.177015085298738,
  -6.8861633973627e-05,-0.0084998721971189,0.183199735906411,-0.200194161587033,
  -7.1729985125224e-05,-0.00793651060174061,0.196165696525587,-0.223373237875327,
  -7.45983362764324e-05,-0.00737314900636155,0.209131657144764,-0.246552314163621,
  -7.74666874279739e-05,-0.00680978741098315,0.222097617763941,-0.269731390451916,
  -8.03350385792378e-05,-0.00624642581560386,0.235063578383118,-0.29291046674021,
  -8.32033897309459e-05,-0.00568306422022569,0.248029539002295,-0.316089543028504,
  -8.60717408822098e-05,-0.00511970262484707,0.260995499621471,-0.339268619316798,
  -8.89400920337513e-05,-0.00455634102946822,0.273961460240648,-0.362447695605093,
  -9.18084431853483e-05,-0.00399297943408983,0.286927420859825,-0.385626771893387,
  -9.46767943366122e-05,-0.00342961783871032,0.299893381479002,-0.408805848181681,
  -9.75451454879872e-05,-0.00286625624333214,0.312859342098179,-0.431984924469975,
  -0.000100413496639362,-0.0023028946479533,0.325825302717356,-0.45516400075827,
  -0.000103281847790404,-0.00173953305257379,0.338791263336533,-0.478343077046564,
  -0.000106150198942334,-0.00117617145719606,0.351757223955709,-0.501522153334859,
  -0.000109018550093376,-0.000612809861816555,0.364723184574886,-0.524701229623152,
  -0.000111886901245306,-4.94482664388229e-05,0.377689145194062,-0.547880305911447,
  -0.000114755252396459,0.000513913328940685,0.39065510581324,-0.571059382199741,
  -0.000117623603548167,0.00107727492431886,0.403621066432416,-0.594238458488035,
  -0.000120491954699542,0.00164063651969792,0.416587027051594,-0.61741753477633,
  -0.000123360305850473,0.00220399811507699,0.42955298767077,-0.640596611064624,
  -0.000126228657002292,0.00276735971045516,0.442518948289947,-0.663775687352918,
  -0.000129097008153445,0.00333072130583423,0.455484908909124,-0.686954763641212,
  -0.000131965359305153,0.00389408290121196,0.4684508695283,-0.710133839929507,
  -5.36989799683751e-05,-0.00860697714783887,0.153826301483036,-0.157054126272231,
  -5.58410042438839e-05,-0.0080881480926922,0.166103784343122,-0.180704036866835,
  -5.79830285193927e-05,-0.00756931903754554,0.178381267203208,-0.204353947461439,
  -6.01250527950126e-05,-0.00705048998239888,0.190658750063294,-0.228003858056044,
  -6.22670770706324e-05,-0.00653166092725233,0.20293623292338,-0.251653768650648,
  -6.44091013461412e-05,-0.00601283187210577,0.215213715783466,-0.275303679245252,
  -6.65511256217055e-05,-0.005494002816959,0.227491198643552,-0.298953589839857,
  -6.86931498969368e-05,-0.00497517376181222,0.239768681503637,-0.322603500434461,
  -7.08351741727231e-05,-0.00445634470666589,0.252046164363723,-0.346253411029066,
  -7.2977198448454e-05,-0.00393751565151934,0.264323647223809,-0.36990332162367,
  -7.51192227238517e-05,-0.00341868659637234,0.276601130083895,-0.393553232218274,
  -7.72612469992495e-05,-0.00289985754122579,0.288878612943981,-0.417203142812879,
  -7.94032712747583e-05,-0.00238102848607946,0.301156095804066,-0.440853053407483,
  -8.15452955508222e-05,-0.00186219943093335,0.313433578664152,-0.464502964002087,
  -8.368731982622e-05,-0.00134337037578613,0.325711061524238,-0.488152874596692,
  -8.58293441013958e-05,-0.00082454132063936,0.337988544384324,-0.511802785191296,
  -8.79713683772376e-05,-0.00030571226549303,0.35026602724441,-0.5354526957859,
  -9.01133926527464e-05,0.0002131167896533,0.362543510104495,-0.559102606380505,
  -9.22554169279222e-05,0.000731945844800741,0.374820992964582,-0.582752516975109,
  -9.43974412039861e-05,0.00125077489994663,0.387098475824667,-0.606402427569713,
  -9.6539465479939e-05,0.00176960395509296,0.399375958684753,-0.630052338164318,
  -9.86814897548927e-05,0.00228843301024018,0.411653441544839,-0.653702248758922,
  -0.000100823514030179,0.00280726206538695,0.423930924404925,-0.677352159353526,
  -0.000102965538306021,0.00332609112053284,0.43620840726501,-0.701002069948131,
  -0.000105107562582085,0.00384492017567917,0.448485890125097,-0.724651980542735,
  -4.44035621398609e-05,-0.00768086929031253,0.150382527841535,-0.160171929786963,
  -4.59204429688609e-05,-0.00721496318449477,0.161976967681695,-0.184277998046331,
  -4.7437323798083e-05,-0.00674905707867723,0.173571407521856,-0.208384066305698,
  -4.89542046269165e-05,-0.00628315097285903,0.185165847362017,-0.232490134565065,
  -5.04710854561941e-05,-0.0058172448670416,0.196760287202177,-0.256596202824433,
  -5.19879662854161e-05,-0.00535133876122384,0.208354727042338,-0.2807022710838,
  -5.35048471145272e-05,-0.0048854326554062,0.219949166882498,-0.304808339343168,
  -5.50217279433607e-05,-0.0044195265495881,0.231543606722659,-0.328914407602535,
  -5.65386087725273e-05,-0.00395362044377046,0.24313804656282,-0.353020475861902,
  -5.80554896018604e-05,-0.00348771433795303,0.25473248640298,-0.37712654412127,
  -5.95723704307494e-05,-0.00302180823213516,0.266326926243141,-0.401232612380637,
  -6.10892512595829e-05,-0.00255590212631707,0.277921366083302,-0.425338680640005,
  -6.26061320891935e-05,-0.00208999602050008,0.289515805923462,-0.449444748899372,
  -6.4123012917805e-05,-0.00162408991468155,0.301110245763623,-0.473550817158739,
  -6.56398937477487e-05,-0.00115818380886457,0.312704685603783,-0.497656885418107,
  -6.71567745762491e-05,-0.000692277703046695,0.324299125443944,-0.521762953677474,
  -6.86736554054157e-05,-0.000226371597228825,0.335893565284104,-0.545869021936842,
  -7.01905362348043e-05,0.000239534508588601,0.347488005124265,-0.569975090196209,
  -7.17074170636378e-05,0.000705440614406694,0.359082444964426,-0.594081158455576,
  -7.32242978928044e-05,0.00117134672022434,0.370676884804586,-0.618187226714944,
  -7.47411787215269e-05,0.00163725282604288,0.382271324644747,-0.642293294974311,
  -7.62580595510265e-05,0.00210315893186008,0.393865764484908,-0.666399363233678,
  -7.777494037986e-05,0.00256906503767729,0.405460204325068,-0.690505431493046,
  -7.92918212088045e-05,0.00303497114349627,0.417054644165229,-0.714611499752413,
  -8.08087020380821e-05,0.00350087724931347,0.42864908400539,-0.738717568011781,
  -3.57351169674724e-05,-0.0068846383866169,0.147126696986295,-0.163033675097257,
  -3.675587589963e-05,-0.00647582090672838,0.158080307984815,-0.187558437816273,
  -3.77766348318431e-05,-0.00606700342684019,0.169033918983334,-0.212083200535288,
  -3.87973937637787e-05,-0.00565818594695144,0.179987529981854,-0.236607963254304,
  -3.98181526960473e-05,-0.00524936846706325,0.190941140980373,-0.26113272597332,
  -4.08389116279828e-05,-0.00484055098717451,0.201894751978893,-0.285657488692335,
  -4.18596705600294e-05,-0.00443173350728587,0.212848362977413,-0.310182251411351,
  -4.28804294919649e-05,-0.00402291602739746,0.223801973975932,-0.334707014130366,
  -4.39011884246221e-05,-0.00361409854750949,0.234755584974452,-0.359231776849382,
  -4.49219473565576e-05,-0.00320528106762108,0.245709195972971,-0.383756539568398,
  -4.59427062884377e-05,-0.002796463587732,0.256662806971491,-0.408281302287413,
  -4.69634652204842e-05,-0.00238764610784359,0.267616417970011,-0.432806065006429,
  -4.79842241528639e-05,-0.00197882862795562,0.27857002896853,-0.457330827725444,
  -4.90049830847994e-05,-0.00157001114806676,0.28952363996705,-0.48185559044446,
  -5.0025742017179e-05,-0.00116119366817857,0.30047725096557,-0.506380353163476,
  -5.10465009491146e-05,-0.000752376188289716,0.311430861964089,-0.530905115882491,
  -5.20672598811611e-05,-0.000343558708401526,0.322384472962609,-0.555429878601507,
  -5.30880188135407e-05,6.52587714866648e-05,0.333338083961128,-0.579954641320523,
  -5.41087777455873e-05,0.000474076251375077,0.344291694959648,-0.604479404039538,
  -5.51295366776339e-05,0.000882893731263934,0.355245305958168,-0.629004166758554,
  -5.61502956092363e-05,0.00129171121115279,0.366198916956687,-0.653528929477569,
  -5.7171054541616e-05,0.0017005286910412,0.377152527955207,-0.678053692196585,
  -5.81918134735515e-05,0.00210934617092962,0.388106138953726,-0.7025784549156,
  -5.92125724054871e-05,0.00251816365081803,0.399059749952246,-0.727103217634616,
  -6.02333313378667e-05,0.002926981130706,0.410013360950765,-0.751627980353632,
  -2.80616207928297e-05,-0.00623162031375268,0.144208856291756,-0.165533033883148,
  -2.87177831424512e-05,-0.00587935717506471,0.154591916809099,-0.190423471238744,
  -2.93739454922948e-05,-0.00552709403637697,0.164974977326443,-0.215313908594339,
  -3.00301078419163e-05,-0.005174830897689,0.175358037843786,-0.240204345949934,
  -3.06862701915378e-05,-0.00482256775900081,0.18574109836113,-0.26509478330553,
  -3.13424325412703e-05,-0.00447030462031317,0.196124158878473,-0.289985220661125,
  -3.19985948911694e-05,-0.00411804148162553,0.206507219395816,-0.314875658016721,
  -3.26547572409019e-05,-0.00376577834293768,0.216890279913159,-0.339766095372316,
  -3.33109195904679e-05,-0.00341351520424982,0.227273340430502,-0.364656532727911,
  -3.39670819403115e-05,-0.00306125206556218,0.237656400947846,-0.389546970083507,
  -3.4623244289822e-05,-0.00270898892687432,0.248039461465189,-0.414437407439102,
  -3.52794066397211e-05,-0.00235672578818669,0.258422521982532,-0.439327844794698,
  -3.59355689892871e-05,-0.00200446264949861,0.268805582499875,-0.464218282150293,
  -3.65917313391861e-05,-0.00165219951081075,0.279188643017219,-0.489108719505888,
  -3.72478936885301e-05,-0.00129993637212289,0.289571703534562,-0.513999156861484,
  -3.79040560385402e-05,-0.000947673233435031,0.299954764051906,-0.538889594217079,
  -3.85602183881062e-05,-0.000595410094747173,0.310337824569249,-0.563780031572675,
  -3.92163807378942e-05,-0.000243146956059759,0.320720885086592,-0.58867046892827,
  -3.98725430877933e-05,0.000109116182628544,0.331103945603936,-0.613560906283865,
  -4.05287054374703e-05,0.000461379321315736,0.341487006121278,-0.638451343639461,
  -4.11848677873694e-05,0.000813642460003816,0.351870066638622,-0.663341780995056,
  -4.18410301369354e-05,0.00116590559869145,0.362253127155965,-0.688232218350652,
  -4.24971924866124e-05,0.00151816873737953,0.372636187673308,-0.713122655706247,
  -4.31533548365115e-05,0.00187043187606761,0.383019248190652,-0.738013093061842,
  -4.38095171861885e-05,0.00222269501475481,0.393402308707995,-0.762903530417438,
  -2.15747166540936e-05,-0.00571608225660958,0.141715902605768,-0.167622889635366,
  -2.19807473527678e-05,-0.00541591788672946,0.151614112640134,-0.192819088311429,
  -2.23867780511644e-05,-0.0051157535168489,0.161512322674499,-0.218015286987492,
  -2.27928087498386e-05,-0.00481558914696845,0.171410532708865,-0.243211485663555,
  -2.31988394482907e-05,-0.00451542477708822,0.18130874274323,-0.268407684339618,
  -2.36048701467428e-05,-0.00421526040720788,0.191206952777595,-0.293603883015681,
  -2.40109008453615e-05,-0.00391509603732754,0.201105162811961,-0.318800081691744,
  -2.44169315438691e-05,-0.0036149316674472,0.211003372846326,-0.343996280367807,
  -2.48229622423213e-05,-0.00331476729756663,0.220901582880691,-0.36919247904387,
  -2.5228992941051e-05,-0.00301460292768652,0.230799792915057,-0.394388677719934,
  -2.563502363917e-05,-0.00271443855780573,0.240698002949422,-0.419584876395997,
  -2.60410543381218e-05,-0.00241427418792584,0.250596212983787,-0.44478107507206,
  -2.64470850361853e-05,-0.00211410981804483,0.260494423018153,-0.469977273748123,
  -2.6853115735137e-05,-0.00181394544816516,0.270392633052518,-0.495173472424186,
  -2.72591464335337e-05,-0.00151378107828504,0.280290843086883,-0.520369671100249,
  -2.76651771315972e-05,-0.00121361670840336,0.290189053121249,-0.545565869776312,
  -2.80712078305489e-05,-0.00091345233852369,0.300087263155614,-0.570762068452375,
  -2.84772385291676e-05,-0.00061328796864335,0.30998547318998,-0.595958267128438,
  -2.88832692273422e-05,-0.00031312359876301,0.319883683224345,-0.621154465804501,
  -2.92892999259609e-05,-1.29592288824476e-05,0.32978189325871,-0.646350664480564,
  -2.96953306242465e-05,0.000287205140998115,0.339680103293076,-0.671546863156627,
  -3.01013613230872e-05,0.000587369510878233,0.349578313327441,-0.69674306183269,
  -3.05073920217058e-05,0.000887533880758351,0.359476523361806,-0.721939260508753,
  -3.09134227202135e-05,0.00118769825063847,0.369374733396172,-0.747135459184816,
  -3.13194534186101e-05,0.00148786262051903,0.379272943430537,-0.77233165786088,
  -1.63001788559547e-05,-0.00532077392692598,0.139670925317938,-0.169307643692151,
  -1.65442853462539e-05,-0.00506580930210265,0.149173110051875,-0.194750334320838,
  -1.6788391836553e-05,-0.00481084467727899,0.158675294785811,-0.220193024949525,
  -1.70324983266856e-05,-0.00455588005245511,0.168177479519748,-0.245635715578211,
  -1.72766048168183e-05,-0.00430091542763145,0.177679664253684,-0.271078406206898,
  -1.75207113071174e-05,-0.0040459508028079,0.187181848987621,-0.296521096835585,
  -1.7764817796917e-05,-0.0037909861779839,0.196684033721557,-0.321963787464272,
  -1.80089242878267e-05,-0.00353602155316124,0.206186218455493,-0.347406478092958,
  -1.82530307779594e-05,-0.00328105692833747,0.21568840318943,-0.372849168721645,
  -1.84971372681475e-05,-0.00302609230351369,0.225190587923366,-0.398291859350332,
  -1.87412437586687e-05,-0.00277112767869059,0.234692772657302,-0.423734549979019,
  -1.89853502483572e-05,-0.00251616305386615,0.244194957391239,-0.449177240607705,
  -1.92294567386009e-05,-0.0022611984290426,0.253697142125175,-0.474619931236392,
  -1.94735632289555e-05,-0.00200623380421949,0.263199326859112,-0.500062621865079,
  -1.97176697189771e-05,-0.00175126917939505,0.272701511593049,-0.525505312493765,
  -1.99617762091098e-05,-0.00149630455457128,0.282203696326985,-0.550948003122452,
  -2.02058826991314e-05,-0.00124133992974795,0.291705881060921,-0.576390693751139,
  -2.04499891895971e-05,-0.000986375304924625,0.301208065794857,-0.601833384379825,
  -2.06940956798407e-05,-0.000731410680101074,0.310710250528794,-0.627276075008513,
  -2.09382021705284e-05,-0.000476446055277524,0.320212435262731,-0.652718765637199,
  -2.11823086608831e-05,-0.000221481430453974,0.329714619996667,-0.678161456265886,
  -2.14264151506827e-05,3.34831943695768e-05,0.339216804730603,-0.703604146894573,
  -2.16705216405932e-05,0.000288447819194015,0.34871898946454,-0.729046837523259,
  -2.1914628131614e-05,0.000543412444016234,0.358221174198476,-0.754489528151946,
  -2.21587346217467e-05,0.000798377068840228,0.367723358932412,-0.779932218780633,
  -1.21448269517765e-05,-0.00502405522464089,0.138048404985096,-0.170626264827203,
  -1.22888283335398e-05,-0.00480646542779262,0.147237416215967,-0.196261879459866,
  -1.24328297151921e-05,-0.00458887563094412,0.156426427446838,-0.221897494092528,
  -1.25768310970664e-05,-0.00437128583409563,0.16561543867771,-0.247533108725191,
  -1.27208324789962e-05,-0.00415369603724758,0.174804449908581,-0.273168723357854,
  -1.2864833860482e-05,-0.00393610624039864,0.183993461139452,-0.298804337990516,
  -1.30088352421898e-05,-0.00371851644355048,0.193182472370323,-0.324439952623179,
  -1.31528366240086e-05,-0.0035009266467021,0.202371483601194,-0.350075567255842,
  -1.32968380054943e-05,-0.00328333684985305,0.211560494832066,-0.375711181888504,
  -1.34408393874796e-05,-0.00306574705300511,0.220749506062937,-0.401346796521167,
  -1.35848407692984e-05,-0.00284815725615672,0.229938517293808,-0.42698241115383,
  -1.37288421505621e-05,-0.00263056745930768,0.23912752852468,-0.452618025786492,
  -1.3872843532492e-05,-0.00241297766245951,0.248316539755551,-0.478253640419155,
  -1.40168449143108e-05,-0.00219538786561113,0.257505550986422,-0.503889255051817,
  -1.41608462963516e-05,-0.00197779806876341,0.266694562217293,-0.52952486968448,
  -1.43048476775043e-05,-0.00176020827191392,0.275883573448165,-0.555160484317143,
  -1.44488490594341e-05,-0.00154261847506576,0.285072584679036,-0.580796098949805,
  -1.4592850441475e-05,-0.00132502867821804,0.294261595909907,-0.606431713582468,
  -1.47368518227387e-05,-0.00110743888136833,0.303450607140779,-0.632067328215131,
  -1.48808532045575e-05,-0.000889849084520389,0.31263961837165,-0.657702942847793,
  -1.50248545867093e-05,-0.00067225928767245,0.321828629602521,-0.683338557480456,
  -1.5168855968084e-05,-0.000454669490823179,0.331017640833392,-0.708974172113119,
  -1.53128573500139e-05,-0.000237079693974795,0.340206652064264,-0.734609786745781,
  -1.54568587319437e-05,-1.94898971273005e-05,0.349395663295134,-0.760245401378444,
  -1.56008601130964e-05,0.000198099899721971,0.358584674526006,-0.785881016011107,
  -8.95157708807881e-06,-0.0048046795498099,0.136794614071217,-0.171634645401195,
  -9.03575203842211e-06,-0.00461685737120388,0.145742230488012,-0.19741779355406,
  -9.11992698859887e-06,-0.00442903519259796,0.154689846904808,-0.223200941706924,
  -9.20410193916421e-06,-0.00424121301399194,0.163637463321604,-0.248984089859788,
  -9.28827688967404e-06,-0.00405339083538625,0.1725850797384,-0.274767238012652,
  -9.37245183979529e-06,-0.00386556865677967,0.181532696155196,-0.300550386165516,
  -9.45662679013859e-06,-0.00367774647817343,0.190480312571992,-0.32633353431838,
  -9.54080174025984e-06,-0.0034899242995674,0.199427928988787,-0.352116682471244,
  -9.6249766904366e-06,-0.00330210212096071,0.208375545405584,-0.377899830624108,
  -9.7091516412795e-06,-0.00311427994235558,0.217323161822379,-0.403682978776972,
  -9.79332659145626e-06,-0.00292645776374933,0.226270778239175,-0.429466126929836,
  -9.87750154191058e-06,-0.00273863558514309,0.235218394655971,-0.4552492750827,
  -9.96167649225388e-06,-0.00255081340653729,0.244166011072767,-0.481032423235564,
  -1.00458514427082e-05,-0.00236299122793127,0.253113627489563,-0.506815571388428,
  -1.01300263929405e-05,-0.0021751690493248,0.262061243906359,-0.532598719541292,
  -1.02142013433948e-05,-0.00198734687071922,0.271008860323154,-0.558381867694156,
  -1.02983762936271e-05,-0.0017995246921132,0.27995647673995,-0.58416501584702,
  -1.03825512443034e-05,-0.0016117025135074,0.288904093156746,-0.609948163999884,
  -1.04667261942026e-05,-0.00142388033490048,0.297851709573542,-0.635731312152748,
  -1.0550901144657e-05,-0.00123605815629535,0.306799325990337,-0.661514460305613,
  -1.06350760952223e-05,-0.00104823597768933,0.315746942407133,-0.687297608458477,
  -1.07192510453435e-05,-0.00086041379908286,0.324694558823929,-0.713080756611341,
  -1.08034259959089e-05,-0.000672591620477281,0.333642175240725,-0.738863904764205,
  -1.08876009466963e-05,-0.000484769441871702,0.342589791657521,-0.764647052917069,
  -1.09717758959293e-05,-0.000296947263264347,0.351537408074317,-0.790430201069933,
  -6.54405703920391e-06,-0.00464417901219771,0.135845304757493,-0.172392176104683,
  -6.59326360402668e-06,-0.00447939661998475,0.144610491681815,-0.198286156590327,
  -6.64247016851638e-06,-0.00431461422777157,0.153375678606136,-0.224180137075972,
  -6.69167673317261e-06,-0.00414983183555828,0.162140865530458,-0.250074117561616,
  -6.7408832976068e-06,-0.00398504944334488,0.17090605245478,-0.275968098047261,
  -6.79008986248508e-06,-0.00382026705113203,0.179671239379102,-0.301862078532905,
  -6.83929642719683e-06,-0.00365548465891896,0.188436426303424,-0.32775605901855,
  -6.88850299124244e-06,-0.003490702266705,0.197201613227746,-0.353650039504194,
  -6.93770955639827e-06,-0.0033259198744926,0.205966800152067,-0.379544019989839,
  -6.98691612105451e-06,-0.00316113748227931,0.214731987076389,-0.405438000475483,
  -7.0361226854887e-06,-0.00299635509006579,0.223497174000711,-0.431331980961128,
  -7.08532925053351e-06,-0.00283157269785339,0.232262360925033,-0.457225961446772,
  -7.1345358144681e-06,-0.00266679030563921,0.241027547849355,-0.483119941932417,
  -7.18374237940189e-06,-0.00250200791342658,0.249792734773677,-0.509013922418061,
  -7.23294894389159e-06,-0.00233722552121307,0.258557921697999,-0.534907902903706,
  -7.28215550860334e-06,-0.00217244312899911,0.267323108622321,-0.56080188338935,
  -7.33136207287099e-06,-0.00200766073678604,0.276088295546643,-0.586695863874995,
  -7.38056863802683e-06,-0.00184287834457386,0.284853482470964,-0.612589844360639,
  -7.42977520329369e-06,-0.00167809595236124,0.293618669395286,-0.638483824846284,
  -7.47898176722828e-06,-0.00151331356014683,0.302383856319608,-0.664377805331928,
  -7.52818833149593e-06,-0.00134853116793376,0.31114904324393,-0.690271785817573,
  -7.57739489587461e-06,-0.00118374877571981,0.319914230168252,-0.716165766303217,
  -7.62660146136351e-06,-0.00101896638350807,0.328679417092573,-0.742059746788862,
  -7.67580802552015e-06,-0.000854183991294111,0.337444604016895,-0.767953727274507,
  -7.72501459012087e-06,-0.000689401599081485,0.346209790941217,-0.793847707760151,
  -4.75483127965193e-06,-0.00452759542177628,0.135137534898178,-0.172953685658474,
  -4.78383286778294e-06,-0.00438026641063038,0.143766897509781,-0.198929819135989,
  -4.81283445530334e-06,-0.00423293739948372,0.152396260121385,-0.224905952613504,
  -4.84183604326782e-06,-0.00408560838833749,0.161025622732988,-0.250882086091019,
  -4.87083763128782e-06,-0.00393827937719138,0.169654985344592,-0.276858219568534,
  -4.89983921914128e-06,-0.00379095036604515,0.178284347956195,-0.302834353046049,
  -4.92884080693923e-06,-0.00364362135489826,0.186913710567799,-0.328810486523564,
  -4.95784239501473e-06,-0.0034962923437527,0.195543073179402,-0.354786620001079,
  -4.98684398253513e-06,-0.00334896333260581,0.204172435791006,-0.380762753478594,
  -5.01584557038859e-06,-0.00320163432145959,0.212801798402609,-0.406738886956109,
  -5.04484715857512e-06,-0.00305430531031337,0.221431161014213,-0.432715020433624,
  -5.07384874637307e-06,-0.00290697629916736,0.230060523625816,-0.458691153911139,
  -5.10285033417102e-06,-0.00275964728802069,0.23868988623742,-0.484667287388654,
  -5.13185192185794e-06,-0.00261231827687425,0.247319248849023,-0.510643420866169,
  -5.16085350998896e-06,-0.00246498926572802,0.255948611460627,-0.536619554343684,
  -5.18985509767589e-06,-0.00231766025458158,0.26457797407223,-0.5625956878212,
  -5.21885668591793e-06,-0.00217033124343602,0.273207336683833,-0.588571821298715,
  -5.24785827338281e-06,-0.00202300223228935,0.281836699295437,-0.61454795477623,
  -5.27685986151383e-06,-0.0018756732211429,0.290466061907041,-0.640524088253745,
  -5.30586144931178e-06,-0.00172834420999646,0.299095424518645,-0.66650022173126,
  -5.33486303722075e-06,-0.00158101519885046,0.307724787130248,-0.692476355208775,
  -5.3638646250187e-06,-0.00143368618770356,0.316354149741852,-0.71845248868629,
  -5.39286621292767e-06,-0.00128635717655756,0.324983512353455,-0.744428622163805,
  -5.4218678006146e-06,-0.00113902816541112,0.333612874965059,-0.77040475564132,
  -5.45086938952277e-06,-0.000991699154266001,0.342242237576662,-0.796380889118835,
  -3.43922470513736e-06,-0.00444332830486172,0.134615878561166,-0.173365776959723,
  -3.456573557159e-06,-0.00430901187057042,0.143145234348802,-0.199402202435999,
  -3.47392240895861e-06,-0.00417469543627902,0.151674590136438,-0.225438627912275,
  -3.49127126109128e-06,-0.00404037900198784,0.160203945924074,-0.251475053388551,
  -3.50862011305741e-06,-0.00390606256769666,0.168733301711709,-0.277511478864826,
  -3.525968964746e-06,-0.00377174613340459,0.177262657499346,-0.303547904341102,
  -3.54331781660111e-06,-0.00363742969911329,0.185792013286981,-0.329584329817378,
  -3.56066666862276e-06,-0.003503113264822,0.194321369074617,-0.355620755293654,
  -3.57801552119952e-06,-0.00336879683053137,0.202850724862253,-0.38165718076993,
  -3.59536437283259e-06,-0.00323448039624008,0.211380080649888,-0.407693606246206,
  -3.61271322479872e-06,-0.00310016396194857,0.219909436437524,-0.433730031722482,
  -3.6300620769314e-06,-0.00296584752765772,0.22843879222516,-0.459766457198758,
  -3.64741092828691e-06,-0.00283153109336509,0.236968148012796,-0.485802882675033,
  -3.6647597805306e-06,-0.00269721465907424,0.245497503800432,-0.511839308151309,
  -3.68210863277429e-06,-0.00256289822478362,0.254026859588067,-0.537875733627585,
  -3.69945748446288e-06,-0.00242858179049144,0.262556215375704,-0.563912159103861,
  -3.71680633626248e-06,-0.00229426535620014,0.271085571163339,-0.589948584580137,
  -3.73415518806208e-06,-0.00215994892190841,0.279614926950975,-0.615985010056413,
  -3.75150403997271e-06,-0.00202563248761711,0.288144282738611,-0.642021435532689,
  -3.76885289155027e-06,-0.00189131605332538,0.296673638526247,-0.668057861008965,
  -3.78620174457112e-06,-0.0017569996190363,0.305202994313881,-0.694094286485241,
  -3.80355059570459e-06,-0.00162268318474323,0.313732350101518,-0.720130711961517,
  -3.82089944783726e-06,-0.00148836675045194,0.322261705889154,-0.746167137437792,
  -3.83824829952584e-06,-0.00135405031616065,0.33079106167679,-0.772203562914068,
  -3.85559715188055e-06,-0.00121973388186936,0.339320417464426,-0.798239988390344,
  -2.47942191083927e-06,-0.00438262522385557,0.13423463834927,-0.173666007356582,
  -2.49000601110216e-06,-0.00425789771663643,0.14269096035358,-0.199746358755731,
  -2.50059011175363e-06,-0.00413317020941784,0.15114728235789,-0.22582671015488,
  -2.51117421229408e-06,-0.00400844270219913,0.1596036043622,-0.251907061554029,
  -2.52175831255697e-06,-0.0038837151949801,0.168059926366511,-0.277987412953179,
  -2.5323424130419e-06,-0.00375898768776128,0.176516248370821,-0.304067764352328,
  -2.54292651363786e-06,-0.0036342601805428,0.184972570375131,-0.330148115751477,
  -2.55351061434483e-06,-0.00350953267332432,0.193428892379441,-0.356228467150626,
  -2.56409471427466e-06,-0.00338480516610473,0.201885214383751,-0.382308818549775,
  -2.57467881437101e-06,-0.00326007765888514,0.210341536388062,-0.408389169948924,
  -2.58526291518901e-06,-0.0031353501516671,0.218797858392372,-0.434469521348073,
  -2.5958470154519e-06,-0.00301062264444774,0.227254180396682,-0.460549872747223,
  -2.60643111593684e-06,-0.00288589513722948,0.235710502400992,-0.486630224146372,
  -2.61701521631075e-06,-0.00276116763001033,0.244166824405302,-0.512710575545521,
  -2.62759931701773e-06,-0.00263644012279163,0.252623146409612,-0.53879092694467,
  -2.63818341694755e-06,-0.00251171261557226,0.261079468413923,-0.564871278343819,
  -2.64876751787657e-06,-0.00238698510835422,0.269535790418233,-0.590951629742968,
  -2.65935161791742e-06,-0.00226225760113508,0.277992112422543,-0.617031981142118,
  -2.66993571862439e-06,-0.00213753009391615,0.286448434426853,-0.643112332541267,
  -2.68051981955342e-06,-0.00201280258669856,0.294904756431163,-0.669192683940416,
  -2.69110391970528e-06,-0.00188807507947875,0.303361078435473,-0.695273035339565,
  -2.70168801930204e-06,-0.00176334757225893,0.311817400439784,-0.721353386738714,
  -2.71227212034209e-06,-0.00163862006504134,0.320273722444093,-0.747433738137863,
  -2.722856220716e-06,-0.00151389255782197,0.328730044448404,-0.773514089537012,
  -2.73344032131195e-06,-0.00138916505060394,0.337186366452713,-0.799594440936162,
  -1.78318752480644e-06,-0.00433899864963383,0.133957736860613,-0.173883578033694,
  -1.78979057968709e-06,-0.00422127725885069,0.142361041414946,-0.199995761628658,
  -1.79639363401263e-06,-0.00410355586806677,0.150764345969279,-0.226107945223622,
  -1.80299668883777e-06,-0.00398583447728329,0.159167650523613,-0.252220128818586,
  -1.80959974349637e-06,-0.00386811308649992,0.167570955077946,-0.278332312413549,
  -1.816202798266e-06,-0.00375039169571623,0.17597425963228,-0.304444496008513,
  -1.82280585298011e-06,-0.00363267030493275,0.184377564186613,-0.330556679603477,
  -1.82940890763872e-06,-0.00351494891414927,0.192780868740946,-0.356668863198441,
  -1.83601196235283e-06,-0.00339722752336558,0.20118417329528,-0.382781046793404,
  -1.84261501723348e-06,-0.00327950613258277,0.209587477849613,-0.408893230388368,
  -1.84921807167004e-06,-0.0031617847417984,0.217990782403947,-0.435005413983332,
  -1.85582112677274e-06,-0.00304406335101559,0.22639408695828,-0.461117597578296,
  -1.86242418098725e-06,-0.00292634196023167,0.234797391512613,-0.487229781173259,
  -1.8690272358679e-06,-0.00280862056944797,0.243200696066947,-0.513341964768223,
  -1.87563029052651e-06,-0.00269089917866472,0.25160400062128,-0.539454148363187,
  -1.8822333456292e-06,-0.00257317778788146,0.260007305175614,-0.56556633195815,
  -1.8888363997327e-06,-0.00245545639709754,0.268410609729947,-0.591678515553114,
  -1.89543945450232e-06,-0.00233773500631429,0.27681391428428,-0.617790699148078,
  -1.90204250860582e-06,-0.00222001361552948,0.285217218838614,-0.643902882743042,
  -1.90864556393056e-06,-0.00210229222474689,0.293620523392947,-0.670015066338005,
  -1.91524861914427e-06,-0.00198457083396431,0.30202382794728,-0.696127249932969,
  -1.92185167358083e-06,-0.00186684944317994,0.310427132501614,-0.722239433527933,
  -1.92845472835046e-06,-0.00174912805239646,0.318830437055948,-0.748351617122897,
  -1.93505778334213e-06,-0.00163140666161343,0.327233741610281,-0.774463800717861,
  -1.94166083788971e-06,-0.00151368527082996,0.335637046164614,-0.800575984312824,
  -1.28023268458621e-06,-0.00430769541124465,0.13375752027218,-0.174040638482477,
  -1.28444787067528e-06,-0.00419506150919025,0.142122504725356,-0.200175801180263,
  -1.28866305693087e-06,-0.00408242760713606,0.150487489178533,-0.226310963878049,
  -1.29287824313096e-06,-0.00396979370508199,0.15885247363171,-0.252446126575835,
  -1.29709342916451e-06,-0.00385715980302748,0.167217458084887,-0.27858128927362,
  -1.3013086154201e-06,-0.00374452590097341,0.175582442538064,-0.304716451971406,
  -1.30552380173121e-06,-0.00363189199891956,0.183947426991241,-0.330851614669192,
  -1.30973898798681e-06,-0.00351925809686526,0.192312411444418,-0.356986777366977,
  -1.31395417385383e-06,-0.0034066241948103,0.200677395897595,-0.383121940064763,
  -1.31816936016493e-06,-0.00329399029275668,0.209042380350771,-0.409257102762549,
  -1.32238454653155e-06,-0.00318135639070261,0.217407364803948,-0.435392265460334,
  -1.32659973217653e-06,-0.00306872248864742,0.225772349257126,-0.46152742815812,
  -1.33081491859866e-06,-0.0029560885865938,0.234137333710302,-0.487662590855906,
  -1.33503010513181e-06,-0.00284345468453995,0.242502318163479,-0.513797753553691,
  -1.33924529055474e-06,-0.00273082078248432,0.250867302616656,-0.539932916251477,
  -1.34346047697687e-06,-0.00261818688043114,0.259232287069832,-0.566068078949263,
  -1.34767566317695e-06,-0.00250555297837662,0.26759727152301,-0.592203241647048,
  -1.35189084937704e-06,-0.00239291907632255,0.275962255976187,-0.618338404344834,
  -1.35610603602121e-06,-0.00228028517426893,0.284327240429363,-0.64447356704262,
  -1.36032122188823e-06,-0.00216765127221441,0.29269222488254,-0.670608729740405,
  -1.36453640819933e-06,-0.0020550173701599,0.301057209335717,-0.696743892438191,
  -1.36875159373329e-06,-0.00194238346810494,0.309422193788894,-0.722879055135977,
  -1.37296678082155e-06,-0.0018297495660522,0.31778717824207,-0.749014217833762,
  -1.37718196691061e-06,-0.00171711566399724,0.326152162695248,-0.775149380531548,
  -1.38139715266661e-06,-0.00160448176194272,0.334517147148425,-0.801284543229334,
  -0.000122614663452481,-0.0182265374582882,0.184700687434548,-0.14020061472181,
  -0.000131218248003218,-0.0176287050077489,0.201397418238037,-0.160027840678904,
  -0.000139821832554121,-0.0170308725572099,0.218094149041525,-0.179855066635997,
  -0.000148425417104747,-0.0164330401066703,0.234790879845014,-0.19968229259309,
  -0.000157029001655817,-0.0158352076561317,0.251487610648502,-0.219509518550184,
  -0.000165632586206443,-0.0152373752055923,0.268184341451991,-0.239336744507277,
  -0.000174236170757125,-0.014639542755053,0.284881072255479,-0.25916397046437,
  -0.000182839755308362,-0.0140417103045141,0.301577803058968,-0.278991196421464,
  -0.000191443339859043,-0.0134438778539749,0.318274533862456,-0.298818422378557,
  -0.000200046924409891,-0.012846045403436,0.334971264665945,-0.31864564833565,
  -0.000208650508960684,-0.0122482129528969,0.351667995469433,-0.338472874292744,
  -0.000217254093511254,-0.0116503805023573,0.368364726272922,-0.358300100249837,
  -0.000225857678061936,-0.0110525480518178,0.38506145707641,-0.37812732620693,
  -0.000234461262613062,-0.0104547156012789,0.401758187879899,-0.397954552164024,
  -0.000243064847163854,-0.00985688315073996,0.418454918683387,-0.417781778121117,
  -0.000251668431714425,-0.00925905070020061,0.435151649486876,-0.43760900407821,
  -0.000260272016265217,-0.00866121824966148,0.451848380290364,-0.457436230035304,
  -0.00026887560081601,-0.00806338579912236,0.468545111093853,-0.477263455992397,
  -0.000277479185367469,-0.0074655533485839,0.485241841897341,-0.49709068194949,
  -0.000286082769917928,-0.00686772089804411,0.50193857270083,-0.516917907906583,
  -0.000294686354469054,-0.00626988844750542,0.518635303504318,-0.536745133863677,
  -0.000303289939019624,-0.00567205599696585,0.535332034307807,-0.55657235982077,
  -0.000311893523570195,-0.00507422354642673,0.552028765111295,-0.576399585777863,
  -0.000320497108121431,-0.00447639109588804,0.568725495914784,-0.596226811734957,
  -0.000329100692672002,-0.00387855864534847,0.585422226718272,-0.61605403769205,
  -0.00012124524057977,-0.0179782783708148,0.18424235710624,-0.140753479772638,
  -0.00012968129392199,-0.0173765912123108,0.200846784262435,-0.160656432524923,
  -0.000138117347264211,-0.0167749040538067,0.217451211418631,-0.180559385277208,
  -0.000146553400606431,-0.0161732168953023,0.234055638574827,-0.200462338029494,
  -0.000154989453948706,-0.0155715297367984,0.250660065731022,-0.220365290781779,
  -0.000163425507290871,-0.0149698425782943,0.267264492887218,-0.240268243534064,
  -0.000171861560632869,-0.0143681554197899,0.283868920043414,-0.260171196286349,
  -0.000180297613975089,-0.0137664682612855,0.30047334719961,-0.280074149038634,
  -0.000188733667317309,-0.0131647811027815,0.317077774355806,-0.299977101790919,
  -0.000197169720659307,-0.0125630939442771,0.333682201512001,-0.319880054543204,
  -0.000205605774001527,-0.0119614067857732,0.350286628668197,-0.339783007295489,
  -0.000214041827343858,-0.011359719627269,0.366891055824393,-0.359685960047774,
  -0.000222477880685967,-0.0107580324687648,0.383495482980589,-0.37958891280006,
  -0.000230913934028076,-0.0101563453102604,0.400099910136784,-0.399491865552345,
  -0.000239349987370407,-0.00955465815175627,0.41670433729298,-0.41939481830463,
  -0.000247786040712406,-0.0089529709932521,0.433308764449176,-0.439297771056915,
  -0.000256222094054626,-0.00835128383474792,0.449913191605372,-0.4592007238092,
  -0.000264658147396735,-0.00774959667624375,0.466517618761567,-0.479103676561485,
  -0.000273094200738955,-0.00714790951773936,0.483122045917763,-0.49900662931377,
  -0.000281530254081508,-0.00654622235923563,0.499726473073959,-0.518909582066055,
  -0.000289966307423395,-0.00594453520073124,0.516330900230155,-0.53881253481834,
  -0.000298402360764616,-0.00534284804222596,0.532935327386351,-0.558715487570626,
  -0.000306838414107946,-0.00474116088372289,0.549539754542546,-0.57861844032291,
  -0.000315274467450166,-0.00413947372521895,0.566144181698742,-0.598521393075196,
  -0.000323710520791942,-0.00353778656671411,0.582748608854938,-0.618424345827481,
  -0.000119378181690943,-0.0176441252191403,0.183615232002131,-0.141503731285682,
  -0.000127588016705371,-0.0170376200221406,0.200093694121303,-0.161509447167207,
  -0.000135797851719244,-0.0164311148251405,0.216572156240475,-0.181515163048732,
  -0.000144007686733449,-0.0158246096281407,0.233050618359647,-0.201520878930258,
  -0.000152217521747489,-0.0152181044311408,0.249529080478819,-0.221526594811783,
  -0.000160427356761805,-0.0146115992341411,0.266007542597991,-0.241532310693308,
  -0.0001686371917759,-0.0140050940371412,0.282486004717163,-0.261538026574833,
  -0.000176847026789773,-0.0133985888401411,0.298964466836335,-0.281543742456359,
  -0.000185056861803923,-0.012792083643141,0.315442928955508,-0.301549458337884,
  -0.000193266696818295,-0.0121855784461413,0.33192139107468,-0.321555174219409,
  -0.000201476531832334,-0.0115790732491414,0.348399853193852,-0.341560890100934,
  -0.000209686366846373,-0.0109725680521415,0.364878315313024,-0.36156660598246,
  -0.000217896201860079,-0.0103660628551412,0.381356777432196,-0.381572321863985,
  -0.000226106036874563,-0.00975955765814196,0.397835239551368,-0.40157803774551,
  -0.000234315871889046,-0.00915305246114251,0.41431370167054,-0.421583753627035,
  -0.000242525706902641,-0.00854654726414172,0.430792163789712,-0.441589469508561,
  -0.000250735541916902,-0.00794004206714205,0.447270625908884,-0.461595185390086,
  -0.000258945376931052,-0.00733353687014215,0.463749088028056,-0.481600901271611,
  -0.000267155211945314,-0.00672703167314248,0.480227550147228,-0.501606617153136,
  -0.000275365046959131,-0.00612052647614236,0.4967060122664,-0.521612333034661,
  -0.000283574881973836,-0.00551402127914269,0.513184474385572,-0.541618048916187,
  -0.00029178471698732,-0.00490751608214213,0.529662936504745,-0.561623764797712,
  -0.00029999455200147,-0.00430101088514245,0.546141398623917,-0.581629480679237,
  -0.000308204387015398,-0.00369450568814234,0.562619860743089,-0.601635196560763,
  -0.000316414222030104,-0.00308800049114355,0.57909832286226,-0.621640912442288,
  -0.000116857500888801,-0.0172007722457338,0.182764509922216,-0.142510314726809,
  -0.000124765947903338,-0.0165885507931877,0.199072691324401,-0.162653903924753,
  -0.000132674394917875,-0.0159763293406416,0.215380872726586,-0.182797493122697,
  -0.000140582841932135,-0.0153641078880949,0.231689054128772,-0.202941082320641,
  -0.000148491288946673,-0.014751886435549,0.247997235530957,-0.223084671518585,
  -0.00015639973596121,-0.014139664983003,0.264305416933141,-0.243228260716529,
  -0.000164308182975581,-0.0135274435304569,0.280613598335327,-0.263371849914473,
  -0.000172216629990285,-0.0129152220779107,0.296921779737512,-0.283515439112417,
  -0.000180125077004878,-0.0123030006253648,0.313229961139696,-0.303659028310361,
  -0.000188033524019304,-0.0116907791728189,0.329538142541881,-0.323802617508305,
  -0.000195941971033564,-0.0110785577202723,0.345846323944066,-0.343946206706248,
  -0.000203850418047935,-0.010466336267726,0.362154505346251,-0.364089795904193,
  -0.00021175886506275,-0.00985411481518028,0.378462686748436,-0.384233385102137,
  -0.000219667312077121,-0.00924189336263415,0.394770868150621,-0.404376974300081,
  -0.000227575759091714,-0.00862967191008779,0.411079049552806,-0.424520563498025,
  -0.000235484206106307,-0.0080174504575421,0.427387230954991,-0.444664152695969,
  -0.000243392653120789,-0.00740522900499574,0.443695412357177,-0.464807741893913,
  -0.000251301100135048,-0.00679300755244938,0.460003593759361,-0.484951331091857,
  -0.000259209547149863,-0.00618078609990369,0.476311775161546,-0.5050949202898,
  -0.000267117994163901,-0.00556856464735755,0.492619956563731,-0.525238509487744,
  -0.000275026441178161,-0.00495634319481031,0.508928137965917,-0.545382098685688,
  -0.000282934888193087,-0.00434412174226528,0.525236319368101,-0.565525687883633,
  -0.000290843335207902,-0.00373190028971937,0.541544500770286,-0.585669277081576,
  -0.000298751782222162,-0.00311967883717301,0.557852682172471,-0.605812866279521,
  -0.000306660229236422,-0.00250745738462665,0.574160863574656,-0.625956455477464,
  -0.000113499264498385,-0.0166236968541382,0.181623997566467,-0.143840374637536,
  -0.000121013399512926,-0.0160052391047554,0.197704930157943,-0.16416614423249,
  -0.000128527534527689,-0.0153867813553729,0.21378586274942,-0.184491913827443,
  -0.000136041669542286,-0.0147683236059902,0.229866795340896,-0.204817683422397,
  -0.000143555804556716,-0.0141498658566074,0.245947727932373,-0.22514345301735,
  -0.000151069939571424,-0.0135314081072249,0.26202866052385,-0.245469222612303,
  -0.000158584074586021,-0.0129129503578422,0.278109593115326,-0.265794992207257,
  -0.000166098209600452,-0.0122944926084594,0.294190525706803,-0.28612076180221,
  -0.000173612344615326,-0.011676034859077,0.310271458298279,-0.306446531397163,
  -0.000181126479629756,-0.0110575771096939,0.326352390889757,-0.326772300992117,
  -0.000188640614644298,-0.0104391193603111,0.342433323481233,-0.34709807058707,
  -0.000196154749659061,-0.00982066161092843,0.35851425607271,-0.367423840182024,
  -0.000203668884673602,-0.0092022038615458,0.374595188664186,-0.387749609776977,
  -0.000211183019688033,-0.00858374611216273,0.390676121255663,-0.408075379371931,
  -0.000218697154702685,-0.00796528836278032,0.40675705384714,-0.428401148966884,
  -0.000226211289717226,-0.00734683061339725,0.422837986438617,-0.448726918561837,
  -0.000233725424731879,-0.00672837286401484,0.438918919030093,-0.469052688156791,
  -0.000241239559746531,-0.00610991511463244,0.454999851621569,-0.489378457751744,
  -0.000248753694761072,-0.00549145736524936,0.471080784213046,-0.509704227346697,
  -0.000256267829775281,-0.00487299961586629,0.487161716804523,-0.530029996941651,
  -0.000263781964790377,-0.00425454186648411,0.503242649396,-0.550355766536604,
  -0.00027129609980503,-0.00363608411710192,0.519323581987476,-0.570681536131558,
  -0.000278810234819682,-0.00301762636771885,0.535404514578953,-0.59100730572651,
  -0.000286324369834112,-0.00239916861833578,0.55148544717043,-0.611333075321464,
  -0.000293838504849098,-0.00178071086895359,0.567566379761906,-0.631658844916418,
  -0.000109103850067294,-0.015891206727496,0.180119204645341,-0.145562895609843,
  -0.000116114444255633,-0.0152669061543458,0.195902033200158,-0.166124601610413,
  -0.000123125038444472,-0.0146426055811961,0.211684861754975,-0.186686307610983,
  -0.000130135632633088,-0.0140183050080465,0.227467690309792,-0.207248013611553,
  -0.000137146226821649,-0.0133940044348966,0.243250518864608,-0.227809719612123,
  -0.000144156821010155,-0.0127697038617467,0.259033347419425,-0.248371425612694,
  -0.000151167415198716,-0.0121454032885968,0.274816175974242,-0.268933131613264,
  -0.000158178009387611,-0.0115211027154469,0.290599004529059,-0.289494837613834,
  -0.00016518860357595,-0.0108968021422968,0.306381833083876,-0.310056543614404,
  -0.0001721991977649,-0.0102725015691476,0.322164661638692,-0.330618249614974,
  -0.000179209791953405,-0.00964820099599795,0.337947490193509,-0.351179955615544,
  -0.000186220386142022,-0.00902390042284784,0.353730318748326,-0.371741661616114,
  -0.000193230980330417,-0.00839959984969796,0.369513147303142,-0.392303367616684,
  -0.000200241574519033,-0.00777529927654808,0.385295975857959,-0.412865073617254,
  -0.000207252168707539,-0.00715099870339819,0.401078804412776,-0.433426779617824,
  -0.000214262762895934,-0.00652669813024809,0.416861632967593,-0.453988485618394,
  -0.000221273357084772,-0.0059023975570982,0.43264446152241,-0.474550191618964,
  -0.000228283951273611,-0.00527809698394899,0.448427290077226,-0.495111897619534,
  -0.000235294545462117,-0.00465379641079888,0.464210118632043,-0.515673603620104,
  -0.000242305139650068,-0.00402949583764878,0.47999294718686,-0.536235309620674,
  -0.000249315733839128,-0.00340519526449912,0.495775775741677,-0.556797015621244,
  -0.000256326328027301,-0.00278089469134857,0.511558604296494,-0.577358721621814,
  -0.000263336922216251,-0.00215659411819979,0.52734143285131,-0.597920427622384,
  -0.000270347516405423,-0.00153229354505013,0.543124261406127,-0.618482133622954,
  -0.000277358110593817,-0.000907992971900029,0.558907089960944,-0.639043839623524,
  -0.000103483394497561,-0.0149909277874961,0.178175621500553,-0.147736534938755,
  -0.000109871070723244,-0.0143628630069459,0.193576152530571,-0.168595967735466,
  -0.000116258746948983,-0.0137347982263959,0.208976683560588,-0.189455400532177,
  -0.000122646423174944,-0.0131067334458459,0.224377214590606,-0.210314833328888,
  -0.000129034099400849,-0.012478668665296,0.239777745620624,-0.231174266125599,
  -0.000135421775626365,-0.0118506038847459,0.255178276650641,-0.25203369892231,
  -0.00014180945185216,-0.0112225391041958,0.270578807680659,-0.272893131719021,
  -0.000148197128078009,-0.0105944743236457,0.285979338710676,-0.293752564515732,
  -0.000154584804303692,-0.0099664095430958,0.301379869740694,-0.314611997312443,
  -0.000160972480529487,-0.00933834476254547,0.316780400770712,-0.335471430109154,
  -0.000167360156755558,-0.00871027998199603,0.332180931800729,-0.356330862905865,
  -0.000173747832981519,-0.00808221520144614,0.347581462830746,-0.377190295702576,
  -0.000180135509207147,-0.00745415042089581,0.362981993860764,-0.398049728499287,
  -0.000186523185432441,-0.00682608564034526,0.378382524890782,-0.418909161295998,
  -0.000192910861658957,-0.00619802085979604,0.393783055920799,-0.439768594092709,
  -0.000199298537884474,-0.00556995607924549,0.409183586950817,-0.46062802688942,
  -0.000205686214110434,-0.00494189129869649,0.424584117980834,-0.481487459686132,
  -0.000212073890336173,-0.00431382651814616,0.439984649010852,-0.502346892482842,
  -0.000218461566561912,-0.00368576173759583,0.455385180040869,-0.523206325279553,
  -0.000224849242787761,-0.0030576969570455,0.470785711070888,-0.544065758076264,
  -0.000231236919014166,-0.00242963217649672,0.486186242100904,-0.564925190872976,
  -0.000237624595239572,-0.00180156739594572,0.501586773130923,-0.585784623669687,
  -0.000244012271465643,-0.0011735026153965,0.516987304160939,-0.606644056466397,
  -0.000250399947690605,-0.000545437834845064,0.532387835190958,-0.627503489263109,
  -0.000256787623916233,8.26269457046003e-05,0.547788366220975,-0.648362922059819,
  -9.65080703466126e-05,-0.0139279477482086,0.175734129785176,-0.150391361531562,
  -0.000102155929316838,-0.0133007690298704,0.190658466457635,-0.171614430100443,
  -0.000107803788287064,-0.0126735903115325,0.205582803130094,-0.192837498669323,
  -0.000113451647257512,-0.0120464115931944,0.220507139802553,-0.214060567238203,
  -0.000119099506227849,-0.0114192328748565,0.235431476475013,-0.235283635807083,
  -0.000124747365197964,-0.0107920541565183,0.250355813147472,-0.256506704375964,
  -0.000130395224168134,-0.01016487543818,0.265280149819931,-0.277729772944844,
  -0.000136043083138415,-0.00953769671984195,0.28020448649239,-0.298952841513724,
  -0.000141690942108696,-0.00891051800150411,0.295128823164849,-0.320175910082604,
  -0.000147338801078978,-0.0082833392831656,0.310053159837308,-0.341398978651484,
  -0.000152986660049148,-0.00765616056482754,0.324977496509767,-0.362622047220365,
  -0.00015863451901954,-0.0070289818464897,0.339901833182226,-0.383845115789245,
  -0.000164282377990155,-0.00640180312815208,0.354826169854685,-0.405068184358125,
  -0.000169930236960325,-0.0057746244098138,0.369750506527144,-0.426291252927005,
  -0.000175578095930828,-0.00514744569147618,0.384674843199603,-0.447514321495886,
  -0.000181225954900999,-0.0045202669731379,0.399599179872063,-0.468737390064766,
  -0.000186873813871058,-0.00389308825479961,0.414523516544522,-0.489960458633646,
  -0.000192521672841117,-0.00326590953646155,0.429447853216981,-0.511183527202526,
  -0.000198169531811732,-0.00263873081812349,0.44437218988944,-0.532406595771406,
  -0.00020381739078168,-0.00201155209978499,0.459296526561899,-0.553629664340286,
  -0.000209465249751961,-0.00138437338144692,0.474220863234358,-0.574852732909167,
  -0.000215113108721687,-0.000757194663108418,0.489145199906817,-0.596075801478047,
  -0.000220760967692302,-0.000130015944771245,0.504069536579276,-0.617298870046927,
  -0.000226408826662916,0.000497162773566817,0.518993873251735,-0.638521938615808,
  -0.000232056685632753,0.00112434149190532,0.533918209924195,-0.659745007184688,
  -8.8167383742177e-05,-0.0127318878404413,0.172773369911458,-0.153507625942697,
  -9.29801404675468e-05,-0.0121134777557286,0.187125744444409,-0.175157534147167,
  -9.77928971929165e-05,-0.0114950676710156,0.201478118977361,-0.196807442351636,
  -0.000102605653918175,-0.0108766575863025,0.215830493510312,-0.218457350556106,
  -0.000107418410643711,-0.0102582475015902,0.230182868043263,-0.240107258760576,
  -0.000112231167369248,-0.00963983741687757,0.244535242576215,-0.261757166965045,
  -0.000117043924094729,-0.00902142733216471,0.258887617109166,-0.283407075169515,
  -0.000121856680820098,-0.00840301724745185,0.273239991642118,-0.305056983373984,
  -0.00012666943754569,-0.00778460716273943,0.287592366175069,-0.326706891578454,
  -0.00013148219427106,-0.00716619707802657,0.30194474070802,-0.348356799782923,
  -0.000136294950996541,-0.00654778699331393,0.316297115240971,-0.370006707987393,
  -0.000141107707721688,-0.00592937690860063,0.330649489773923,-0.391656616191862,
  -0.000145920464447613,-0.00531096682388865,0.345001864306874,-0.413306524396332,
  -0.000150733221172539,-0.0046925567391749,0.359354238839826,-0.434956432600801,
  -0.000155545977898242,-0.00407414665446293,0.373706613372777,-0.456606340805271,
  -0.000160358734623389,-0.00345573656974962,0.388058987905728,-0.47825624900974,
  -0.000165171491349203,-0.00283732648503743,0.402411362438679,-0.49990615721421,
  -0.000169984248074462,-0.00221891640032479,0.41676373697163,-0.521556065418679,
  -0.000174797004800054,-0.00160050631561126,0.431116111504583,-0.543205973623149,
  -0.000179609761525645,-0.000982096230899288,0.445468486037533,-0.564855881827618,
  -0.000184422518250682,-0.000363686146186204,0.459820860570485,-0.586505790032088,
  -0.000189235274976163,0.00025472393852688,0.474173235103436,-0.608155698236558,
  -0.000194048031701421,0.000873134023239963,0.488525609636388,-0.629805606441026,
  -0.000198860788426458,0.00149154410795305,0.502877984169339,-0.651455514645497,
  -0.000203673545152272,0.0021099541926648,0.51723035870229,-0.673105422849966,
  -7.86289681380947e-05,-0.0114584727726581,0.169334019550029,-0.156999449137054,
  -8.25550523894658e-05,-0.0108598557752654,0.18302882216364,-0.179127637854081,
  -8.64811366408369e-05,-0.0102612387778728,0.196723624777251,-0.201255826571108,
  -9.04072208925411e-05,-0.0096626217804805,0.210418427390862,-0.223384015288135,
  -9.43333051438566e-05,-0.00906400478308766,0.224113230004473,-0.245512204005161,
  -9.82593893955053e-05,-0.00846538778569528,0.237808032618083,-0.267640392722188,
  -0.000102185473646876,-0.00786677078830267,0.251502835231694,-0.289768581439215,
  -0.000106111557898247,-0.00726815379091006,0.265197637845305,-0.311896770156242,
  -0.000110037642149785,-0.00666953679351745,0.278892440458916,-0.334024958873268,
  -0.000113963726401156,-0.00607091979612462,0.292587243072527,-0.356153147590295,
  -0.000117889810652638,-0.00547230279873223,0.306282045686137,-0.378281336307322,
  -0.000121815894904453,-0.00487368580133984,0.319976848299748,-0.400409525024349,
  -0.000125741979156158,-0.00427506880394768,0.333671650913359,-0.422537713741375,
  -0.000129668063407085,-0.0036764518065544,0.34736645352697,-0.444665902458402,
  -0.000133594147658234,-0.00307783480916135,0.361061256140581,-0.466794091175429,
  -0.000137520231909716,-0.00247921781176896,0.374756058754192,-0.488922279892456,
  -0.00014144631616142,-0.00188060081437658,0.388450861367802,-0.511050468609482,
  -0.000145372400413013,-0.00128198381698441,0.402145663981413,-0.533178657326509,
  -0.000149298484664273,-0.000683366819591136,0.415840466595024,-0.555306846043536,
  -0.000153224568916088,-8.47498221991927e-05,0.429535269208634,-0.577435034760563,
  -0.000157150653167459,0.000513867175193194,0.443230071822245,-0.59956322347759,
  -0.000161076737418275,0.00111248417258691,0.456924874435856,-0.621691412194616,
  -0.000165002821670424,0.00171110116997841,0.470619677049467,-0.643819600911643,
  -0.000168928905921573,0.00230971816737124,0.484314479663078,-0.66594778962867,
  -0.000172854990173166,0.00290833516476408,0.498009282276689,-0.688075978345696,
  -6.82638380566924e-05,-0.0101818832773357,0.165533897607265,-0.160714117803524,
  -7.13127930284108e-05,-0.0096159520438085,0.178509811924003,-0.183351110527767,
  -7.43617479999625e-05,-0.00905002081028106,0.19148572624074,-0.205988103252009,
  -7.74107029712368e-05,-0.00848408957675328,0.204461640557478,-0.228625095976252,
  -8.04596579429551e-05,-0.00791815834322585,0.217437554874215,-0.251262088700495,
  -8.35086129143958e-05,-0.00735222710969841,0.230413469190953,-0.273899081424738,
  -8.65575678858921e-05,-0.00678629587617108,0.24338938350769,-0.296536074148981,
  -8.96065228574439e-05,-0.00622036464264353,0.256365297824428,-0.319173066873224,
  -9.26554778290511e-05,-0.0056544334091162,0.269341212141165,-0.341810059597467,
  -9.57044328000478e-05,-0.00508850217558798,0.282317126457903,-0.36444705232171,
  -9.87533877719882e-05,-0.0045225709420611,0.29529304077464,-0.387084045045953,
  -0.000101802342743373,-0.00395663970853333,0.308268955091378,-0.409721037770196,
  -0.00010485129771487,-0.003390708475006,0.321244869408115,-0.432358030494439,
  -0.000107900252686366,-0.00282477724147867,0.334220783724852,-0.454995023218682,
  -0.000110949207658084,-0.00225884600795134,0.34719669804159,-0.477632015942924,
  -0.000113998162629358,-0.00169291477442379,0.360172612358327,-0.500269008667167,
  -0.000117047117600966,-0.00112698354089602,0.373148526675065,-0.52290600139141,
  -0.000120096072572351,-0.000561052307368692,0.386124440991802,-0.545542994115653,
  -0.000123145027543736,4.87892615907981e-06,0.39910035530854,-0.568179986839896,
  -0.000126193982515899,0.000570810159685742,0.412076269625277,-0.590816979564139,
  -0.000129242937486951,0.00113674139321418,0.425052183942015,-0.613453972288382,
  -0.000132291892458669,0.00170267262674129,0.438028098258752,-0.636090965012625,
  -0.000135340847430832,0.00226860386026795,0.451004012575489,-0.658727957736868,
  -0.000138389802401662,0.00283453509379639,0.463979926892227,-0.681364950461111,
  -0.000141438757373047,0.00340046632732349,0.476955841208964,-0.704001943185353,
  -5.76086222014993e-05,-0.00897866422883398,0.161561041172487,-0.164453825550056,
  -5.98549438223239e-05,-0.0084578203509732,0.173793070280581,-0.187603051923676,
  -6.2101265443093e-05,-0.00793697647311231,0.186025099388675,-0.210752278297296,
  -6.43475870640287e-05,-0.00741613259525187,0.198257128496769,-0.233901504670916,
  -6.65939086847422e-05,-0.00689528871739109,0.210489157604863,-0.257050731044537,
  -6.88402303057334e-05,-0.00637444483953065,0.222721186712957,-0.280199957418157,
  -7.10865519266135e-05,-0.00585360096167009,0.234953215821051,-0.303349183791777,
  -7.33328735476046e-05,-0.00533275708380976,0.247185244929145,-0.326498410165397,
  -7.55791951681517e-05,-0.00481191320594854,0.259417274037239,-0.349647636539017,
  -7.78255167890318e-05,-0.00429106932808798,0.271649303145333,-0.372796862912638,
  -8.00718384098564e-05,-0.0037702254502272,0.283881332253427,-0.395946089286258,
  -8.2318160030348e-05,-0.00324938157236643,0.296113361361521,-0.419095315659878,
  -8.45644816517277e-05,-0.00272853769450632,0.308345390469615,-0.442244542033498,
  -8.68108032721082e-05,-0.0022076938166451,0.32057741957771,-0.465393768407119,
  -8.90571248933769e-05,-0.00168684993878498,0.332809448685804,-0.488542994780739,
  -9.13034465139795e-05,-0.00116600606092376,0.345041477793898,-0.511692221154359,
  -9.35497681350261e-05,-0.00064516218306343,0.357273506901992,-0.534841447527979,
  -9.57960897559618e-05,-0.000124318305202875,0.369505536010086,-0.557990673901599,
  -9.80424113763423e-05,0.00039652557265768,0.38173756511818,-0.58113990027522,
  -0.000100288732997611,0.000917369450518457,0.393969594226274,-0.60428912664884,
  -0.000102535054617992,0.00143821332837968,0.406201623334368,-0.62743835302246,
  -0.000104781376239038,0.00195905720624001,0.418433652442462,-0.65058757939608,
  -0.000107027697860196,0.00247990108410034,0.430665681550556,-0.6737368057697,
  -0.000109274019480687,0.00300074496196157,0.44289771065865,-0.696886032143321,
  -0.000111520341101068,0.00352158883982234,0.455129739766744,-0.720035258516941,
  -4.72626734265291e-05,-0.00790980246243134,0.157640135075173,-0.168015448572707,
  -4.88320054694569e-05,-0.00744332688314142,0.169144905200348,-0.191652516051101,
  -5.04013375124401e-05,-0.00697685130385139,0.180649675325522,-0.215289583529495,
  -5.19706695553124e-05,-0.00651037572456115,0.192154445450698,-0.238926651007889,
  -5.35400015984067e-05,-0.00604390014527156,0.203659215575872,-0.262563718486283,
  -5.5109333641723e-05,-0.00557742456598165,0.215163985701047,-0.286200785964677,
  -5.66786656842622e-05,-0.00511094898669118,0.226668755826222,-0.309837853443071,
  -5.82479977276895e-05,-0.00464447340740182,0.238173525951397,-0.333474920921464,
  -5.98173297702287e-05,-0.00417799782811112,0.249678296076572,-0.357111988399858,
  -6.1386661813323e-05,-0.00371152224882132,0.261183066201747,-0.380749055878252,
  -6.29559938565283e-05,-0.00324504666953151,0.272687836326922,-0.404386123356646,
  -6.45253258990675e-05,-0.00277857109024127,0.284192606452097,-0.42802319083504,
  -6.60946579422728e-05,-0.00231209551095146,0.295697376577272,-0.451660258313434,
  -6.7663989985367e-05,-0.00184561993166121,0.307202146702447,-0.475297325791828,
  -6.92333220281283e-05,-0.00137914435237096,0.318706916827622,-0.498934393270221,
  -7.08026540713336e-05,-0.000912668773081382,0.330211686952797,-0.522571460748615,
  -7.23719861140948e-05,-0.000446193193791578,0.341716457077972,-0.546208528227009,
  -7.3941318156745e-05,2.02823854995593e-05,0.353221227203147,-0.569845595705403,
  -7.55106502005054e-05,0.00048675796478781,0.364725997328321,-0.593482663183797,
  -7.70799822429336e-05,0.000953233544079168,0.376230767453497,-0.617119730662191,
  -7.86493142861389e-05,0.00141970912336831,0.387735537578671,-0.640756798140585,
  -8.0218646328678e-05,0.00188618470265922,0.399240307703847,-0.664393865618979,
  -8.17879783723274e-05,0.00235266028194836,0.410745077829021,-0.688030933097372,
  -8.33573104147556e-05,0.00281913586123927,0.422249847954197,-0.711668000575766,
  -8.4926642458405e-05,0.00328561144052886,0.433754618079372,-0.73530506805416,
  -3.77579533709094e-05,-0.00700940703286379,0.153983378606066,-0.171232582099896,
  -3.88005017408211e-05,-0.00660167608253526,0.164815467990088,-0.195310305415285,
  -3.98430501106772e-05,-0.00619394513220661,0.17564755737411,-0.219388028730674,
  -4.08855984803114e-05,-0.00578621418187775,0.186479646758132,-0.243465752046064,
  -4.1928146850001e-05,-0.0053784832315491,0.197311736142154,-0.267543475361453,
  -4.29706952199682e-05,-0.00497075228122057,0.208143825526177,-0.291621198676842,
  -4.40132435897134e-05,-0.00456302133089204,0.218975914910199,-0.315698921992231,
  -4.50557919596806e-05,-0.00415529038056328,0.229808004294221,-0.339776645307621,
  -4.60983403293147e-05,-0.00374755943023453,0.240640093678243,-0.36385436862301,
  -4.71408886992819e-05,-0.00333982847990599,0.251472183062265,-0.387932091938399,
  -4.81834370690271e-05,-0.00293209752957768,0.262304272446287,-0.412009815253788,
  -4.92259854384391e-05,-0.00252436657924804,0.27313636183031,-0.436087538569177,
  -5.02685338086284e-05,-0.00211663562891995,0.283968451214332,-0.460165261884566,
  -5.13110821781515e-05,-0.00170890467859097,0.294800540598354,-0.484242985199956,
  -5.23536305482297e-05,-0.00130117372826288,0.305632629982376,-0.508320708515345,
  -5.33961789178639e-05,-0.000893442777933906,0.316464719366399,-0.532398431830734,
  -5.443872728772e-05,-0.000485711827605373,0.327296808750421,-0.556476155146123,
  -5.54812756574652e-05,-7.79808772761736e-05,0.338128898134443,-0.580553878461512,
  -5.65238240276544e-05,0.000329750073051471,0.348960987518465,-0.604631601776902,
  -5.75663723968445e-05,0.000737481023381115,0.359793076902488,-0.62870932509229,
  -5.86089207670337e-05,0.00114521197370943,0.37062516628651,-0.65278704840768,
  -5.96514691363348e-05,0.00155294292403862,0.381457255670532,-0.676864771723069,
  -6.0694017506524e-05,0.00196067387436694,0.392289345054554,-0.700942495038458,
  -6.17365658760471e-05,0.00236840482469569,0.403121434438577,-0.725020218353847,
  -6.27791142463474e-05,0.00277613577502356,0.413953523822598,-0.749097941669236,
  -2.94584137228715e-05,-0.00628396626851779,0.150747391027488,-0.174002534052311,
  -3.01208270984121e-05,-0.00593417615710912,0.160988314506727,-0.198459662041367,
  -3.07832404738972e-05,-0.00558438604570033,0.171229237985966,-0.222916790030424,
  -3.14456538492713e-05,-0.00523459593429121,0.181470161465205,-0.247373918019481,
  -3.21080672247009e-05,-0.00488480582288231,0.191711084944444,-0.271831046008538,
  -3.27704806001305e-05,-0.00453501571147341,0.201952008423683,-0.296288173997594,
  -3.34328939759487e-05,-0.00418522560006473,0.212192931902922,-0.320745301986651,
  -3.40953073512673e-05,-0.00383543548865561,0.222433855382161,-0.345202429975708,
  -3.47577207264749e-05,-0.00348564537724672,0.2326747788614,-0.369659557964765,
  -3.54201341026261e-05,-0.00313585526583848,0.242915702340639,-0.394116685953821,
  -3.60825474780002e-05,-0.00278606515442936,0.253156625819878,-0.418573813942878,
  -3.67449608530412e-05,-0.0024362750430198,0.263397549299118,-0.443030941931935,
  -3.74073742285264e-05,-0.00208648493161134,0.273638472778356,-0.467488069920992,
  -3.80697876042335e-05,-0.00173669482020244,0.283879396257595,-0.491945197910048,
  -3.87322009793856e-05,-0.00138690470879332,0.294120319736835,-0.516402325899105,
  -3.93946143547597e-05,-0.0010371145973842,0.304361243216074,-0.540859453888161,
  -4.00570277303558e-05,-0.000687324485975527,0.314602166695312,-0.565316581877218,
  -4.0719441106063e-05,-0.000337534374566406,0.324843090174552,-0.589773709866275,
  -4.13818544816591e-05,1.22557368418263e-05,0.33508401365379,-0.614230837855332,
  -4.20442678568111e-05,0.000362045848250947,0.345324937133029,-0.638687965844388,
  -4.27066812322963e-05,0.000711835959660068,0.355565860612269,-0.663145093833445,
  -4.33690946081144e-05,0.00106162607106874,0.365806784091508,-0.687602221822502,
  -4.40315079831555e-05,0.00141141618247786,0.376047707570747,-0.712059349811559,
  -4.46939213585296e-05,0.00176120629388699,0.386288631049986,-0.736516477800615,
  -4.53563347346808e-05,0.00211099640529477,0.396529554529224,-0.760973605789672,
  -2.25250364927487e-05,-0.00571963385739138,0.148013139703018,-0.176290723976157,
  -2.29308207982948e-05,-0.00542286590567631,0.157757349089021,-0.201061268936432,
  -2.33366051037298e-05,-0.00512609795396146,0.167501558475022,-0.225831813896707,
  -2.37423894093314e-05,-0.00482933000224683,0.177245767861024,-0.250602358856982,
  -2.41481737149329e-05,-0.0045325620505321,0.186989977247026,-0.275372903817258,
  -2.45539580204235e-05,-0.00423579409881714,0.196734186633028,-0.300143448777533,
  -2.49597423256365e-05,-0.00393902614710195,0.206478396019031,-0.324913993737808,
  -2.53655266314601e-05,-0.00364225819538766,0.216222605405032,-0.349684538698083,
  -2.57713109371172e-05,-0.0033454902436727,0.225966814791035,-0.374455083658358,
  -2.61770952424412e-05,-0.00304872229195752,0.235711024177037,-0.399225628618633,
  -2.65828795481537e-05,-0.002751954340243,0.245455233563038,-0.423996173578908,
  -2.69886638538663e-05,-0.00245518638852849,0.25519944294904,-0.448766718539183,
  -2.73944481592459e-05,-0.0021584184368133,0.264943652335043,-0.473537263499459,
  -2.78002324645144e-05,-0.00186165048509856,0.274687861721044,-0.498307808459734,
  -2.8206016770449e-05,-0.00156488253338405,0.284432071107046,-0.523078353420009,
  -2.86118010754954e-05,-0.0012681145816682,0.294176280493049,-0.547848898380284,
  -2.9017585381208e-05,-0.000971346629953906,0.303920489879051,-0.572619443340559,
  -2.94233696872537e-05,-0.000674578678239168,0.313664699265053,-0.597389988300834,
  -2.98291539919671e-05,-0.000377810726523542,0.323408908651055,-0.622160533261109,
  -3.02349382976796e-05,-8.1042774809692e-05,0.333153118037056,-0.646931078221385,
  -3.06407226035033e-05,0.00021572517690549,0.342897327423059,-0.67170162318166,
  -3.10465069094379e-05,0.00051249312861934,0.35264153680906,-0.696472168141935,
  -3.14522912144843e-05,0.000809261080335411,0.362385746195063,-0.72124271310221,
  -3.18580755203079e-05,0.0011060290320497,0.372129955581065,-0.746013258062485,
  -3.22638598256875e-05,0.00140279698376444,0.381874164967066,-0.77078380302276,
  -1.69427810465805e-05,-0.00529196453517244,0.145791002598509,-0.178117155137419,
  -1.71846844633783e-05,-0.00504087958355992,0.155133302926869,-0.203137869245253,
  -1.74265878804536e-05,-0.00478979463194773,0.164475603255229,-0.228158583353087,
  -1.76684912975844e-05,-0.00453870968033554,0.173817903583589,-0.253179297460921,
  -1.79103947145487e-05,-0.00428762472872313,0.183160203911949,-0.278200011568755,
  -1.81522981316795e-05,-0.00403653977711138,0.192502504240309,-0.303220725676589,
  -1.83942015486438e-05,-0.00378545482549875,0.20184480456867,-0.328241439784423,
  -1.86361049658301e-05,-0.003534369873887,0.211187104897029,-0.353262153892257,
  -1.8878008383072e-05,-0.00328328492227503,0.220529405225389,-0.378282868000091,
  -1.91199117999252e-05,-0.00303219997066262,0.22987170555375,-0.403303582107925,
  -1.93618152167785e-05,-0.00278111501905021,0.23921400588211,-0.428324296215759,
  -1.96037186340758e-05,-0.00253003006743868,0.248556306210469,-0.453345010323593,
  -1.98456220508181e-05,-0.00227894511582583,0.25789860653883,-0.478365724431427,
  -2.00875254680044e-05,-0.00202786016421408,0.26724090686719,-0.503386438539261,
  -2.03294288851907e-05,-0.00177677521260144,0.27658320719555,-0.528407152647095,
  -2.05713323023771e-05,-0.00152569026098992,0.28592550752391,-0.553427866754929,
  -2.08132357187862e-05,-0.00127460530937684,0.29526780785227,-0.578448580862764,
  -2.10551391363056e-05,-0.00102352035776532,0.30461010818063,-0.603469294970598,
  -2.1297042553492e-05,-0.000772435406153349,0.31395240850899,-0.628490009078432,
  -2.15389459705673e-05,-0.000521350454540936,0.32329470883735,-0.653510723186266,
  -2.17808493869764e-05,-0.00027026550292808,0.33263700916571,-0.6785314372941,
  -2.20227528044958e-05,-1.91805513165555e-05,0.34197930949407,-0.703552151401934,
  -2.2264656221016e-05,0.000231904400296301,0.351321609822431,-0.728572865509768,
  -2.25065596389795e-05,0.000482989351906937,0.36066391015079,-0.753593579617602,
  -2.27484630563879e-05,0.000734074303518462,0.37000621047915,-0.778614293725436,
  -1.25796224305641e-05,-0.00497385379081838,0.144041111545111,-0.179535473036997,
  -1.27213375839541e-05,-0.00476030761378166,0.153067982140322,-0.204750456377328,
  -1.28630527372886e-05,-0.00454676143674471,0.162094852735533,-0.229965439717658,
  -1.30047678906786e-05,-0.00433321525970787,0.171121723330744,-0.255180423057988,
  -1.31464830440686e-05,-0.00411966908267081,0.180148593925955,-0.280395406398318,
  -1.32881981972366e-05,-0.00390612290563386,0.189175464521166,-0.305610389738648,
  -1.34299133506266e-05,-0.00369257672859713,0.198202335116377,-0.330825373078978,
  -1.35716285043497e-05,-0.0034790305515604,0.207229205711588,-0.356040356419308,
  -1.37133436574066e-05,-0.00326548437452323,0.216256076306799,-0.381255339759638,
  -1.38550588110187e-05,-0.00305193819748673,0.225282946902009,-0.406470323099968,
  -1.39967739640756e-05,-0.00283839202044955,0.23430981749722,-0.431685306440298,
  -1.41384891176877e-05,-0.00262484584341283,0.243336688092431,-0.456900289780629,
  -1.42802042709667e-05,-0.00241129966637588,0.252363558687642,-0.482115273120959,
  -1.44219194244677e-05,-0.00219775348933915,0.261390429282853,-0.507330256461289,
  -1.45636345776357e-05,-0.0019842073123022,0.270417299878064,-0.532545239801619,
  -1.47053497310257e-05,-0.00177066113526525,0.279444170473275,-0.557760223141949,
  -1.48470648845267e-05,-0.00155711495822808,0.288471041068487,-0.582975206482279,
  -1.49887800380277e-05,-0.0013435687811918,0.297497911663697,-0.608190189822609,
  -1.51304951909736e-05,-0.00113002260415396,0.306524782258909,-0.633405173162939,
  -1.52722103444747e-05,-0.000916476427117452,0.315551652854119,-0.658620156503269,
  -1.54139254983088e-05,-0.000702930250081835,0.32457852344933,-0.683835139843599,
  -1.55556406512547e-05,-0.000489384073043553,0.333605394044542,-0.709050123183929,
  -1.56973558047557e-05,-0.000275837896007047,0.342632264639752,-0.73426510652426,
  -1.58390709580347e-05,-6.22917189705419e-05,0.351659135234963,-0.75948008986459,
  -1.59807861114247e-05,0.000151254458066852,0.360686005830174,-0.78469507320492,
  -9.24725226419953e-06,-0.00474026454069099,0.142696821365599,-0.180613532573666,
  -9.32962552641081e-06,-0.00455646074887239,0.15148198930787,-0.205976179423591,
  -9.41199878878862e-06,-0.00437265695705402,0.16026715725014,-0.231338826273517,
  -9.49437205116643e-06,-0.00418885316523576,0.16905232519241,-0.256701473123442,
  -9.57674531354424e-06,-0.00400504937341717,0.17783749313468,-0.282064119973368,
  -9.65911857586654e-06,-0.00382124558159869,0.18662266107695,-0.307426766823293,
  -9.74149183818884e-06,-0.0036374417897802,0.19540782901922,-0.332789413673219,
  -9.82386510056665e-06,-0.00345363799796172,0.204192996961491,-0.358152060523144,
  -9.90623836272242e-06,-0.00326983420614302,0.212978164903761,-0.383514707373069,
  -9.98861162526676e-06,-0.00308603041432498,0.221763332846031,-0.408877354222995,
  -1.0070984887478e-05,-0.0029022266225065,0.230548500788301,-0.43424000107292,
  -1.01533581498003e-05,-0.00271842283068779,0.239333668730571,-0.459602647922846,
  -1.02357314124557e-05,-0.00253461903886976,0.248118836672841,-0.484965294772771,
  -1.0318104674556e-05,-0.00235081524705083,0.256904004615111,-0.510327941622697,
  -1.04004779368783e-05,-0.00216701145523279,0.265689172557381,-0.535690588472622,
  -1.04828511990895e-05,-0.00198320766341409,0.274474340499651,-0.561053235322547,
  -1.05652244609677e-05,-0.00179940387159494,0.283259508441922,-0.586415882172473,
  -1.06475977237341e-05,-0.00161560007977712,0.292044676384192,-0.611778529022398,
  -1.07299709858344e-05,-0.00143179628795842,0.300829844326462,-0.637141175872324,
  -1.08123442488228e-05,-0.0012479924961406,0.309615012268732,-0.662503822722249,
  -1.08947175113672e-05,-0.00106418870432234,0.318400180211002,-0.687866469572174,
  -1.09770907728013e-05,-0.000880384912502752,0.327185348153273,-0.7132291164221,
  -1.10594640347905e-05,-0.000696581120684048,0.335970516095543,-0.738591763272025,
  -1.11418372986671e-05,-0.000512777328867564,0.344755684037812,-0.763954410121951,
  -1.12242105599902e-05,-0.000328973537047528,0.353540851980083,-0.789317056971876,
  -6.74659235810893e-06,-0.00457022862622525,0.141683554392096,-0.181419697802315,
  -6.79452573076889e-06,-0.00440934959867834,0.15028688080046,-0.206892766371011,
  -6.84245910342884e-06,-0.00424847057113109,0.158890207208824,-0.232365834939707,
  -6.89039247647738e-06,-0.0040875915435844,0.167493533617189,-0.257838903508403,
  -6.93832584935938e-06,-0.00392671251603738,0.176096860025553,-0.283311972077099,
  -6.98625922224139e-06,-0.00376583348849047,0.184700186433918,-0.308785040645795,
  -7.03419259479032e-06,-0.00360495446094311,0.193303512842282,-0.334258109214491,
  -7.08212596745028e-06,-0.00344407543339642,0.201906839250646,-0.359731177783187,
  -7.1300593403878e-06,-0.00328319640584906,0.210510165659011,-0.385204246351883,
  -7.17799271343633e-06,-0.00312231737830282,0.219113492067375,-0.410677314920579,
  -7.22592608604078e-06,-0.00296143835075546,0.227716818475739,-0.436150383489275,
  -7.27385945897829e-06,-0.00280055932320855,0.236320144884104,-0.461623452057971,
  -7.32179283180479e-06,-0.0026396802956612,0.244923471292469,-0.487096520626666,
  -7.36972620463128e-06,-0.00247880126811428,0.253526797700833,-0.512569589195363,
  -7.41765957801288e-06,-0.00231792224056826,0.262130124109197,-0.538042657764059,
  -7.46559295028426e-06,-0.00215704321302068,0.270733450517562,-0.563515726332755,
  -7.51352632311075e-06,-0.00199616418547377,0.279336776925926,-0.588988794901451,
  -7.56145969593724e-06,-0.00183528515792597,0.287940103334291,-0.614461863470147,
  -7.6093930690968e-06,-0.00167440613037995,0.296543429742655,-0.639934932038842,
  -7.65732644147921e-06,-0.00151352710283259,0.305146756151019,-0.665408000607538,
  -7.70525981441672e-06,-0.00135264807528568,0.313750082559384,-0.690881069176234,
  -7.75319318713219e-06,-0.00119176904773877,0.322353408967748,-0.716354137744931,
  -7.80112656051379e-06,-0.0010308900201923,0.330956735376112,-0.741827206313627,
  -7.84905993267415e-06,-0.000870010992644055,0.339560061784477,-0.767300274882323,
  -7.89699330538962e-06,-0.000709131965097143,0.348163388192841,-0.792773343451019,
  -4.89465790221022e-06,-0.00444717617764279,0.140930645269771,-0.182015214934389,
  -4.92280312297533e-06,-0.0043036078697839,0.149399041301859,-0.2075698524209,
  -4.9509483430743e-06,-0.00416003956192423,0.157867437333948,-0.233124489907411,
  -4.97909356389492e-06,-0.00401647125406557,0.166335833366036,-0.258679127393922,
  -5.00723878443798e-06,-0.00387290294620612,0.174804229398124,-0.284233764880433,
  -5.03538400459247e-06,-0.00372933463834646,0.183272625430213,-0.309788402366944,
  -5.06352922508002e-06,-0.00358576633048746,0.191741021462301,-0.335343039853455,
  -5.0916744461782e-06,-0.00344219802262891,0.200209417494389,-0.360897677339966,
  -5.11981966666575e-06,-0.00329862971476969,0.208677813526477,-0.386452314826477,
  -5.14796488682023e-06,-0.0031550614069098,0.217146209558566,-0.412006952312988,
  -5.17611010752983e-06,-0.00301149309905102,0.225614605590654,-0.437561589799499,
  -5.20425532790636e-06,-0.0028679247911918,0.234083001622742,-0.46311622728601,
  -5.23240054794982e-06,-0.00272435648333191,0.242551397654831,-0.488670864772521,
  -5.26054576899249e-06,-0.00258078817547314,0.251019793686919,-0.514225502259032,
  -5.28869098936902e-06,-0.00243721986761392,0.259488189719007,-0.539780139745543,
  -5.31683620974555e-06,-0.00229365155975469,0.267956585751095,-0.565334777232054,
  -5.34498143067719e-06,-0.00215008325189658,0.276424981783183,-0.590889414718565,
  -5.37312665094269e-06,-0.00200651494403692,0.284893377815272,-0.616444052205076,
  -5.40127187143025e-06,-0.00186294663617748,0.29336177384736,-0.641998689691587,
  -5.42941709180678e-06,-0.00171937832831803,0.301830169879449,-0.667553327178098,
  -5.4575623126274e-06,-0.00157581002045948,0.310298565911536,-0.693107964664609,
  -5.48570753344801e-06,-0.00143224171260004,0.318766961943625,-0.71866260215112,
  -5.51385275349148e-06,-0.00128867340474059,0.327235357975714,-0.744217239637631,
  -5.54199797353494e-06,-0.00114510509688071,0.335703754007802,-0.769771877124142,
  -5.57014319502169e-06,-0.00100153678902304,0.34417215003989,-0.795326514610653,
  -3.53647106743349e-06,-0.00435847277562251,0.14037710526267,-0.182451163104266,
  -3.55325512529925e-06,-0.00422777956714671,0.148746400502972,-0.208065513096975,
  -3.57003918277643e-06,-0.00409708635867012,0.157115695743273,-0.233679863089684,
  -3.58682324047566e-06,-0.00396639315019387,0.165484990983575,-0.259294213082394,
  -3.60360729800835e-06,-0.00383569994171773,0.173854286223876,-0.284908563075103,
  -3.62039135559655e-06,-0.00370500673324137,0.182223581464178,-0.310522913067813,
  -3.63717541373987e-06,-0.00357431352476589,0.190592876704479,-0.336137263060522,
  -3.65395947093949e-06,-0.00344362031628886,0.198962171944781,-0.361751613053232,
  -3.67074352863872e-06,-0.00331292710781272,0.207331467185082,-0.387365963045941,
  -3.68752758628244e-06,-0.00318223389933658,0.215700762425383,-0.412980313038651,
  -3.70431164398166e-06,-0.00305154069086044,0.224070057665685,-0.43859466303136,
  -3.72109570168089e-06,-0.00292084748238408,0.232439352905986,-0.46420901302407,
  -3.73787975938011e-06,-0.00279015427390772,0.240808648146288,-0.489823363016779,
  -3.75466381696832e-06,-0.00265946106543136,0.24917794338659,-0.515437713009489,
  -3.7714478744455e-06,-0.00252876785695499,0.257547238626891,-0.541052063002198,
  -3.78823193236677e-06,-0.00239807464847908,0.265916533867192,-0.566666412994908,
  -3.80501598973293e-06,-0.00226738144000271,0.274285829107494,-0.592280762987617,
  -3.82180004732113e-06,-0.00213668823152657,0.282655124347795,-0.617895112980327,
  -3.83858410557547e-06,-0.00200599502305066,0.291024419588097,-0.643509462973036,
  -3.85536816294163e-06,-0.00187530181457429,0.299393714828398,-0.669123812965746,
  -3.87215222064086e-06,-0.00174460860609837,0.3077630100687,-0.694738162958455,
  -3.88893627867315e-06,-0.00161391539762201,0.316132305309001,-0.720352512951165,
  -3.9057203354842e-06,-0.00148322218914521,0.324501600549303,-0.745966862943874,
  -3.92250439329445e-06,-0.00135252898066929,0.332870895789604,-0.771581212936584,
  -3.93928845110469e-06,-0.00122183577219293,0.341240191029906,-0.797195562929293,
  -2.54748546552053e-06,-0.0042946983083828,0.139973305081111,-0.182768189419938,
  -2.55769820090013e-06,-0.0041734757392542,0.148270360578211,-0.208425963005514,
  -2.56791093650177e-06,-0.0040522531701257,0.156567416075312,-0.234083736591091,
  -2.57812367215893e-06,-0.00393103060099742,0.164864471572412,-0.259741510176667,
  -2.58833640753853e-06,-0.0038098080318687,0.173161527069512,-0.285399283762243,
  -2.59854914314017e-06,-0.00368858546274065,0.181458582566612,-0.311057057347819,
  -2.60876187913039e-06,-0.00356736289361259,0.189755638063712,-0.336714830933395,
  -2.61897461462102e-06,-0.00344614032448387,0.198052693560812,-0.362372604518971,
  -2.62918735005613e-06,-0.00332491775535537,0.206349749057912,-0.388030378104547,
  -2.63940008571328e-06,-0.00320369518622687,0.214646804555013,-0.413688151690124,
  -2.64961282137044e-06,-0.0030824726170986,0.222943860052113,-0.4393459252757,
  -2.65982555647248e-06,-0.00296125004796988,0.231240915549213,-0.465003698861276,
  -2.67003829257373e-06,-0.0028400274788416,0.239537971046313,-0.490661472446852,
  -2.68025102823088e-06,-0.00271880490971355,0.247835026543413,-0.516319246032428,
  -2.69046376344395e-06,-0.00259758234058483,0.256132082040514,-0.541977019618004,
  -2.70067649910111e-06,-0.00247635977145677,0.264429137537613,-0.56763479320358,
  -2.71088923453622e-06,-0.00235513720232738,0.272726193034714,-0.593292566789157,
  -2.72110197041542e-06,-0.00223391463319977,0.281023248531814,-0.618950340374733,
  -2.73131470596155e-06,-0.00211269206407128,0.289320304028914,-0.644608113960309,
  -2.74152744139666e-06,-0.00199146949494278,0.297617359526014,-0.670265887545885,
  -2.75174017660973e-06,-0.00187024692581339,0.305914415023115,-0.695923661131461,
  -2.76195291215586e-06,-0.00174902435668489,0.314211470520215,-0.721581434717037,
  -2.77216564825711e-06,-0.00162780178755728,0.322508526017315,-0.747239208302614,
  -2.78237838402529e-06,-0.00150657921842923,0.330805581514415,-0.77289698188819,
  -2.79259111923835e-06,-0.00138535664929984,0.339102637011516,-0.798554755473766,
  -1.83107347795364e-06,-0.00424892861948079,0.139680409510101,-0.182997624279129,
  -1.83743084986032e-06,-0.00413461664548964,0.147925093811305,-0.208686823918072,
  -1.8437882217115e-06,-0.00402030467149883,0.156169778112509,-0.234376023557014,
  -1.85014559356267e-06,-0.00390599269750769,0.164414462413714,-0.260065223195957,
  -1.85650296535833e-06,-0.00379168072351677,0.172659146714918,-0.2857544228349,
  -1.86286033698746e-06,-0.00367736874952551,0.180903831016122,-0.311443622473842,
  -1.86921770861659e-06,-0.00356305677553426,0.189148515317326,-0.337132822112785,
  -1.8755750806343e-06,-0.00344874480154367,0.19739319961853,-0.362822021751728,
  -1.88193245231894e-06,-0.00333443282755241,0.205637883919735,-0.38851122139067,
  -1.88828982417011e-06,-0.00322012085356138,0.213882568220939,-0.414200421029613,
  -1.89464719557719e-06,-0.0031058088795699,0.222127252522143,-0.439889620668555,
  -1.90100456731734e-06,-0.00299149690557887,0.230371936823347,-0.465578820307498,
  -1.90736193916852e-06,-0.00287718493158806,0.238616621124551,-0.491268019946441,
  -1.91371931101969e-06,-0.00276287295759681,0.246861305425756,-0.516957219585383,
  -1.92007668275984e-06,-0.00264856098360577,0.25510598972696,-0.542646419224326,
  -1.92643405449999e-06,-0.00253424900961474,0.263350674028164,-0.568335618863268,
  -1.93279142635117e-06,-0.00241993703562349,0.271595358329368,-0.594024818502211,
  -1.93914879820234e-06,-0.00230562506163245,0.279840042630573,-0.619714018141154,
  -1.94550617016453e-06,-0.00219131308764187,0.288084726931777,-0.645403217780096,
  -1.95186354234878e-06,-0.00207700111365128,0.296329411232981,-0.671092417419039,
  -1.95822091320075e-06,-0.00196268913965891,0.304574095534185,-0.696781617057982,
  -1.96457828538499e-06,-0.00184837716566877,0.312818779835389,-0.722470816696924,
  -1.97093565723616e-06,-0.00173406519167818,0.321063464136593,-0.748160016335867,
  -1.9772930284212e-06,-0.00161975321768582,0.329308148437798,-0.773849215974809,
  -1.98365040060544e-06,-0.00150544124369567,0.337552832739001,-0.799538415613752,
  -1.31406032644055e-06,-0.00421612072135213,0.139468833153718,-0.183163088966447,
  -1.31811125458903e-06,-0.00410682206736301,0.147675700967806,-0.208874952563745,
  -1.32216218279302e-06,-0.003997523413374,0.155882568781895,-0.234586816161043,
  -1.32621311105252e-06,-0.00388822475938511,0.164089436595984,-0.260298679758341,
  -1.33026403914549e-06,-0.00377892610539576,0.172296304410073,-0.286010543355639,
  -1.33431496718295e-06,-0.00366962745140631,0.180503172224162,-0.311722406952936,
  -1.33836589555347e-06,-0.00356032879741774,0.18871004003825,-0.337434270550234,
  -1.34241682353542e-06,-0.00345103014342829,0.196916907852339,-0.363146134147532,
  -1.34646775207248e-06,-0.0033417314894395,0.205123775666428,-0.38885799774483,
  -1.35051867988789e-06,-0.00323243283545027,0.213330643480517,-0.414569861342128,
  -1.35456960825842e-06,-0.00312313418146104,0.221537511294606,-0.440281724939426,
  -1.35862053629587e-06,-0.00301383552747203,0.229744379108695,-0.465993588536723,
  -1.36267146444435e-06,-0.00290453687348302,0.237951246922783,-0.491705452134021,
  -1.36672239237079e-06,-0.00279523821949357,0.246158114736872,-0.517417315731319,
  -1.37077332085234e-06,-0.00268593956550434,0.254364982550962,-0.543129179328617,
  -1.37482424944491e-06,-0.00257664091151621,0.26257185036505,-0.568841042925915,
  -1.37887517748236e-06,-0.00246734225752698,0.270778718179139,-0.594552906523212,
  -1.38292610518675e-06,-0.00235804360353686,0.278985585993228,-0.62026477012051,
  -1.38697703377932e-06,-0.00224874494954852,0.287192453807317,-0.645976633717808,
  -1.3910279619278e-06,-0.00213944629555929,0.295399321621405,-0.671688497315106,
  -1.39507888974322e-06,-0.00203014764157006,0.303606189435494,-0.697400360912404,
  -1.39912981811374e-06,-0.00192084898758083,0.311813057249583,-0.723112224509702,
  -1.40318074648427e-06,-0.00181155033359248,0.320019925063671,-0.748824088107,
  -1.40723167463275e-06,-0.00170225167960325,0.32822679287776,-0.774535951704297,
  -1.41128260289225e-06,-0.00159295302561402,0.336433660691849,-0.800247815301595,
  -0.000138568490530733,-0.0212571188369073,0.196837434248721,-0.141601576221728,
  -0.000148453772764845,-0.0207171610154719,0.214081530925473,-0.160415225126397,
  -0.000158339054999124,-0.0201772031940368,0.231325627602226,-0.179228874031065,
  -0.000168224337233347,-0.0196372453726016,0.248569724278979,-0.198042522935734,
  -0.00017810961946757,-0.0190972875511665,0.265813820955731,-0.216856171840402,
  -0.000187994901702071,-0.0185573297297315,0.283057917632484,-0.23566982074507,
  -0.000197880183935739,-0.0180173719082957,0.300302014309237,-0.254483469649739,
  -0.000207765466170351,-0.0174774140868612,0.31754611098599,-0.273297118554407,
  -0.000217650748404574,-0.0169374562654259,0.334790207662742,-0.292110767459076,
  -0.000227536030638853,-0.0163974984439905,0.352034304339495,-0.310924416363744,
  -0.000237421312873187,-0.0158575406225556,0.369278401016248,-0.329738065268413,
  -0.000247306595107633,-0.0153175828011205,0.386522497693001,-0.348551714173081,
  -0.000257191877341079,-0.0147776249796845,0.403766594369753,-0.36736536307775,
  -0.000267077159575413,-0.0142376671582494,0.421010691046506,-0.386179011982418,
  -0.000276962441809858,-0.0136977093368145,0.438254787723259,-0.404992660887087,
  -0.000286847724044081,-0.01315775151538,0.455498884400011,-0.423806309791755,
  -0.000296733006278638,-0.0126177936939447,0.472742981076764,-0.442619958696424,
  -0.000306618288512639,-0.0120778358725095,0.489987077753516,-0.461433607601092,
  -0.000316503570747084,-0.0115378780510744,0.507231174430269,-0.48024725650576,
  -0.000326388852981307,-0.0109979202296393,0.524475271107022,-0.499060905410429,
  -0.000336274135215531,-0.010457962408204,0.541719367783775,-0.517874554315097,
  -0.00034615941744931,-0.00991800458676861,0.558963464460527,-0.536688203219766,
  -0.000356044699683755,-0.00937804676533327,0.57620756113728,-0.555501852124434,
  -0.000365929981918089,-0.00883808894389793,0.593451657814033,-0.574315501029102,
  -0.000375815264152646,-0.00829813112246391,0.610695754490785,-0.593129149933771,
  -0.000136874769601947,-0.0209124407958453,0.196273770192236,-0.142325544723687,
  -0.000146550319085836,-0.0203648595511365,0.213409188946912,-0.161232408717505,
  -0.000156225868569337,-0.0198172783064275,0.230544607701589,-0.180139272711322,
  -0.000165901418053227,-0.0192696970617188,0.247680026456265,-0.19904613670514,
  -0.000175576967537006,-0.0187221158170098,0.264815445210941,-0.217953000698957,
  -0.000185252517020618,-0.0181745345723008,0.281950863965617,-0.236859864692775,
  -0.000194928066504507,-0.0176269533275921,0.299086282720293,-0.255766728686592,
  -0.000204603615988008,-0.017079372082883,0.31622170147497,-0.27467359268041,
  -0.000214279165472453,-0.0165317908381748,0.333357120229646,-0.293580456674227,
  -0.000223954714955732,-0.0159842095934655,0.350492538984322,-0.312487320668044,
  -0.000233630264439677,-0.0154366283487568,0.367627957738998,-0.331394184661862,
  -0.000243305813923289,-0.0148890471040477,0.384763376493674,-0.350301048655679,
  -0.000252981363406901,-0.0143414658593388,0.40189879524835,-0.369207912649497,
  -0.000262656912890735,-0.0137938846146299,0.419034214003027,-0.388114776643314,
  -0.000272332462374458,-0.0132463033699208,0.436169632757703,-0.407021640637132,
  -0.000282008011858181,-0.0126987221252115,0.45330505151238,-0.425928504630949,
  -0.000291683561341793,-0.0121511408805028,0.470440470267056,-0.444835368624767,
  -0.000301359110825516,-0.0116035596357937,0.487575889021732,-0.463742232618584,
  -0.000311034660309351,-0.0110559783910851,0.504711307776408,-0.482649096612401,
  -0.000320710209792852,-0.010508397146376,0.521846726531084,-0.501555960606219,
  -0.000330385759276908,-0.00996081590166709,0.53898214528576,-0.520462824600036,
  -0.000340061308760742,-0.00941323465695865,0.556117564040436,-0.539369688593853,
  -0.000349736858243799,-0.00886565341224888,0.573252982795113,-0.558276552587671,
  -0.000359412407728299,-0.00831807216754044,0.590388401549789,-0.577183416581488,
  -0.000369087957212244,-0.007770490922832,0.607523820304465,-0.596090280575306,
  -0.000134570459241534,-0.0204507692890145,0.195503189223776,-0.143304481362205,
  -0.000143963687516679,-0.0198935046999725,0.212490573537839,-0.162337389052376,
  -0.000153356915791991,-0.0193362401109307,0.229477957851903,-0.181370296742547,
  -0.000162750144066914,-0.0187789755218889,0.246465342165966,-0.200403204432718,
  -0.000172143372342115,-0.0182217109328471,0.263452726480029,-0.219436112122889,
  -0.000181536600617038,-0.0176644463438049,0.280440110794092,-0.23846901981306,
  -0.000190929828892183,-0.0171071817547632,0.297427495108155,-0.257501927503231,
  -0.000200323057167218,-0.0165499171657213,0.314414879422218,-0.276534835193402,
  -0.000209716285442751,-0.0159926525766798,0.331402263736281,-0.295567742883573,
  -0.000219109513717619,-0.0154353879876377,0.348389648050344,-0.314600650573744,
  -0.000228502741992598,-0.0148781233985955,0.365377032364407,-0.333633558263915,
  -0.00023789597026791,-0.0143208588095538,0.382364416678471,-0.352666465954087,
  -0.000247289198542888,-0.0137635942205119,0.399351800992534,-0.371699373644258,
  -0.000256682426818311,-0.0132063296314704,0.416339185306597,-0.390732281334429,
  -0.000266075655093179,-0.0126490650424285,0.43332656962066,-0.4097651890246,
  -0.000275468883368268,-0.0120918004533861,0.450313953934723,-0.428798096714771,
  -0.000284862111643691,-0.0115345358643453,0.467301338248785,-0.447831004404942,
  -0.000294255339918448,-0.0109772712753027,0.484288722562849,-0.466863912095113,
  -0.000303648568193426,-0.0104200066862608,0.501276106876912,-0.485896819785284,
  -0.000313041796468183,-0.00986274209721816,0.518263491190975,-0.504929727475455,
  -0.000322435024743606,-0.00930547750817645,0.535250875505038,-0.523962635165626,
  -0.00033182825301914,-0.00874821291913541,0.552238259819101,-0.542995542855797,
  -0.000341221481294229,-0.00819094833009348,0.569225644133164,-0.562028450545968,
  -0.000350614709568986,-0.00763368374105111,0.586213028447228,-0.58106135823614,
  -0.000360007937844409,-0.00707641915200963,0.603200412761291,-0.600094265926311,
  -0.000131468518038691,-0.0198422353376262,0.194459226113996,-0.144611580285915,
  -0.000140487205163964,-0.0192731635396821,0.211247011635563,-0.163812784445297,
  -0.000149505892289348,-0.0187040917417384,0.228034797157131,-0.18301398860468,
  -0.000158524579414621,-0.0181350199437945,0.244822582678699,-0.202215192764063,
  -0.000167543266540116,-0.017565948145851,0.261610368200266,-0.221416396923446,
  -0.000176561953665277,-0.0169968763479069,0.278398153721834,-0.240617601082828,
  -0.000185580640790883,-0.0164278045499635,0.295185939243402,-0.259818805242211,
  -0.000194599327915934,-0.0158587327520194,0.311973724764969,-0.279020009401594,
  -0.000203618015041873,-0.0152896609540762,0.328761510286537,-0.298221213560976,
  -0.000212636702166979,-0.0147205891561322,0.345549295808105,-0.317422417720359,
  -0.000221655389292197,-0.0141515173581883,0.362337081329672,-0.336623621879742,
  -0.000230674076417636,-0.0135824455602447,0.37912486685124,-0.355824826039124,
  -0.000239692763542854,-0.0130133737623008,0.395912652372807,-0.375026030198507,
  -0.000248711450668737,-0.0124443019643576,0.412700437894375,-0.39422723435789,
  -0.000257730137793843,-0.0118752301664133,0.429488223415943,-0.413428438517273,
  -0.000266748824919505,-0.0113061583684702,0.44627600893751,-0.432629642676655,
  -0.000275767512044278,-0.0107370865705256,0.463063794459078,-0.451830846836038,
  -0.000284786199169829,-0.010168014772582,0.479851579980646,-0.471032050995421,
  -0.000293804886295268,-0.00959894297463837,0.496639365502213,-0.490233255154803,
  -0.000302823573420485,-0.00902987117669429,0.513427151023781,-0.509434459314186,
  -0.000311842260545481,-0.00846079937875066,0.530214936545348,-0.528635663473569,
  -0.000320860947671697,-0.00789172758080792,0.547002722066916,-0.547836867632951,
  -0.000329879634796804,-0.00732265578286384,0.563790507588483,-0.567038071792334,
  -0.00033889832192191,-0.00675358398491932,0.580578293110052,-0.586239275951717,
  -0.00034791700904746,-0.00618451218697613,0.597366078631619,-0.6054404801111,
  -0.000127352300467731,-0.0190570233465511,0.19306238696977,-0.146327746292757,
  -0.000135883755368549,-0.0184744025881373,0.209584739482984,-0.165749916650102,
  -0.000144415210269588,-0.0178917818297237,0.226107091996198,-0.185172087007447,
  -0.000152946665170073,-0.0173091610713094,0.242629444509412,-0.204594257364791,
  -0.000161478120071001,-0.0167265403128957,0.259151797022626,-0.224016427722136,
  -0.000170009574971486,-0.0161439195544817,0.275674149535839,-0.243438598079481,
  -0.000178541029872525,-0.0155612987960678,0.292196502049054,-0.262860768436826,
  -0.00018707248477362,-0.0149786780376544,0.308718854562267,-0.282282938794171,
  -0.000195603939674216,-0.0143960572792401,0.325241207075481,-0.301705109151515,
  -0.000204135394574756,-0.0138134365208258,0.341763559588696,-0.32112727950886,
  -0.000212666849475518,-0.0132308157624117,0.35828591210191,-0.340549449866205,
  -0.00022119830437628,-0.0126481950039981,0.374808264615123,-0.35997162022355,
  -0.000229729759277597,-0.0120655742455851,0.391330617128337,-0.379393790580894,
  -0.000238261214178359,-0.0114829534871708,0.407852969641551,-0.398815960938239,
  -0.000246792669079121,-0.0109003327287573,0.424375322154765,-0.418238131295584,
  -0.000255324123979883,-0.0103177119703433,0.440897674667978,-0.437660301652929,
  -0.000263855578880978,-0.00973509121192961,0.457420027181193,-0.457082472010274,
  -0.000272387033781407,-0.00915247045351486,0.473942379694407,-0.476504642367618,
  -0.000280918488682058,-0.00856984969510122,0.49046473220762,-0.495926812724963,
  -0.00028944994358282,-0.00798722893668735,0.506987084720834,-0.515348983082308,
  -0.000297981398483804,-0.00740460817827371,0.523509437234048,-0.534771153439653,
  -0.00030651285338501,-0.00682198741986006,0.540031789747262,-0.554193323796997,
  -0.000315044308285661,-0.00623936666144598,0.556554142260476,-0.573615494154342,
  -0.000323575763186756,-0.00565674590303278,0.573076494773689,-0.593037664511687,
  -0.000332107218087407,-0.00507412514461869,0.589598847286904,-0.612459834869032,
  -0.000121993621610639,-0.0180715621396583,0.191224773067189,-0.148531923754783,
  -0.000129907561818077,-0.0174748032975077,0.207400604084888,-0.168237894578677,
  -0.000137821502025792,-0.0168780444553571,0.223576435102588,-0.187943865402571,
  -0.000145735442233175,-0.0162812856132063,0.239752266120288,-0.207649836226464,
  -0.000153649382440724,-0.0156845267710557,0.255928097137988,-0.227355807050358,
  -0.000161563322648328,-0.015087767928905,0.272103928155688,-0.247061777874252,
  -0.000169477262855822,-0.0144910090867545,0.288279759173387,-0.266767748698146,
  -0.000177391203063426,-0.0138942502446036,0.304455590191087,-0.28647371952204,
  -0.000185305143270864,-0.0132974914024528,0.320631421208787,-0.306179690345934,
  -0.000193219083478358,-0.0127007325603024,0.336807252226487,-0.325885661169828,
  -0.00020113302368574,-0.0121039737181516,0.352983083244186,-0.345591631993721,
  -0.000209046963893122,-0.0115072148760007,0.369158914261887,-0.365297602817615,
  -0.000216960904100505,-0.0109104560338498,0.385334745279586,-0.385003573641509,
  -0.000224874844308331,-0.0103136971916993,0.401510576297286,-0.404709544465403,
  -0.000232788784515825,-0.00971693834954879,0.417686407314986,-0.424415515289297,
  -0.000240702724723318,-0.00912017950739807,0.433862238332686,-0.444121486113191,
  -0.000248616664930923,-0.00852342066524758,0.450038069350385,-0.463827456937085,
  -0.000256530605138194,-0.00792666182309665,0.466213900368085,-0.483533427760978,
  -0.000264444545345688,-0.00732990298094571,0.482389731385785,-0.503239398584872,
  -0.00027235848555307,-0.00673314413879433,0.498565562403485,-0.522945369408766,
  -0.000280272425761008,-0.00613638529664451,0.514741393421185,-0.54265134023266,
  -0.000288186365968501,-0.0055396264544938,0.530917224438884,-0.562357311056553,
  -0.000296100306175773,-0.00494286761234264,0.547093055456584,-0.582063281880447,
  -0.000304014246383266,-0.00434610877019193,0.563268886474284,-0.601769252704341,
  -0.000311928186590538,-0.00374934992804121,0.579444717491984,-0.621475223528236,
  -0.000115189896055634,-0.0168776345346261,0.188861450544414,-0.151284179268307,
  -0.000122347392235655,-0.016268394858554,0.204595740450284,-0.171344518745477,
  -0.000129504888415732,-0.0156591551824822,0.220330030356154,-0.191404858222648,
  -0.000136662384595754,-0.0150499155064102,0.236064320262024,-0.211465197699818,
  -0.00014381988077572,-0.0144406758303383,0.251798610167894,-0.231525537176989,
  -0.000150977376955963,-0.0138314361542664,0.267532900073764,-0.251585876654159,
  -0.000158134873135984,-0.0132221964781944,0.283267189979634,-0.271646216131329,
  -0.000165292369315617,-0.012612956802122,0.299001479885504,-0.2917065556085,
  -0.000172449865495916,-0.0120037171260503,0.314735769791374,-0.31176689508567,
  -0.000179607361676215,-0.0113944774499786,0.330470059697245,-0.33182723456284,
  -0.000186764857855737,-0.0107852377739062,0.346204349603115,-0.351887574040011,
  -0.000193922354035814,-0.0101759980978344,0.361938639508985,-0.371947913517181,
  -0.000201079850216113,-0.00956675842176291,0.377672929414854,-0.392008252994351,
  -0.000208237346395745,-0.00895751874569051,0.393407219320725,-0.412068592471522,
  -0.000215394842575822,-0.00834827906961833,0.409141509226595,-0.432128931948692,
  -0.000222552338755899,-0.00773903939354637,0.424875799132465,-0.452189271425862,
  -0.000229709834936309,-0.00712979971747485,0.440610089038335,-0.472249610903033,
  -0.00023686733111572,-0.00652056004140245,0.456344378944205,-0.492309950380203,
  -0.000244024827295686,-0.00591132036533049,0.472078668850075,-0.512370289857373,
  -0.000251182323475763,-0.0053020806892583,0.487812958755945,-0.532430629334544,
  -0.000258339819655951,-0.00469284101318657,0.503547248661815,-0.552490968811714,
  -0.000265497315836249,-0.00408360133711438,0.519281538567686,-0.572551308288884,
  -0.000272654812015771,-0.00347436166104265,0.535015828473555,-0.592611647766055,
  -0.00027981230819607,-0.00286512198497091,0.550750118379425,-0.612671987243225,
  -0.000286969804376258,-0.00225588230889917,0.566484408285295,-0.632732326720396,
  -0.000106823067110629,-0.015492604428486,0.18591066072162,-0.154602313414574,
  -0.000113093272265052,-0.014875992531985,0.201099550434247,-0.175089881658487,
  -0.000119363477419476,-0.0142593806354839,0.216288440146875,-0.1955774499024,
  -0.000125633682573734,-0.0136427687389827,0.231477329859503,-0.216065018146313,
  -0.000131903887728102,-0.0130261568424817,0.246666219572131,-0.236552586390226,
  -0.000138174092882415,-0.0124095449459802,0.261855109284759,-0.257040154634139,
  -0.000144444298036672,-0.011792933049479,0.277043998997386,-0.277527722878051,
  -0.000150714503191096,-0.0111763211529778,0.292232888710014,-0.298015291121964,
  -0.000156984708345465,-0.0105597092564769,0.307421778422642,-0.318502859365877,
  -0.000163254913499777,-0.00994309735997545,0.32261066813527,-0.33899042760979,
  -0.000169525118653979,-0.00932648546347403,0.337799557847898,-0.359477995853703,
  -0.000175795323808292,-0.00870987356697328,0.352988447560525,-0.379965564097616,
  -0.000182065528962716,-0.00809326167047186,0.368177337273153,-0.400453132341529,
  -0.000188335734116918,-0.00747664977397067,0.383366226985781,-0.420940700585442,
  -0.00019460593927112,-0.00686003787746947,0.398555116698409,-0.441428268829355,
  -0.000200876144425655,-0.00624342598096828,0.413744006411036,-0.461915837073267,
  -0.000207146349579856,-0.00562681408446708,0.428932896123664,-0.48240340531718,
  -0.00021341655473428,-0.00501020218796588,0.444121785836292,-0.502890973561093,
  -0.000219686759888704,-0.00439359029146491,0.45931067554892,-0.523378541805006,
  -0.000225956965043017,-0.00377697839496349,0.474499565261548,-0.543866110048919,
  -0.000232227170197219,-0.00316036649846207,0.489688454974176,-0.564353678292832,
  -0.000238497375351199,-0.00254375460196021,0.504877344686804,-0.584841246536745,
  -0.000244767580505734,-0.00192714270546013,0.520066234399431,-0.605328814780658,
  -0.000251037785660047,-0.00131053080895782,0.53525512411206,-0.62581638302457,
  -0.00025730799081447,-0.000693918912457736,0.550444013824687,-0.646303951268484,
  -9.69322386731308e-05,-0.0139663759823091,0.182361673096866,-0.158437570616758,
  -0.000102216042004166,-0.0133517550950321,0.196902353270231,-0.179418950181251,
  -0.000107499845335479,-0.0127371342077555,0.211443033443595,-0.200400329745744,
  -0.000112783648666626,-0.0121225133204786,0.22598371361696,-0.221381709310236,
  -0.00011806745199755,-0.0115078924332014,0.240524393790325,-0.242363088874729,
  -0.000123351255328974,-0.0108932715459247,0.25506507396369,-0.263344468439222,
  -0.000128635058660009,-0.0102786506586479,0.269605754137054,-0.284325848003715,
  -0.000133918861991322,-0.00966402977137104,0.284146434310419,-0.305307227568208,
  -0.000139202665322413,-0.00904940888409422,0.298687114483783,-0.3262886071327,
  -0.000144486468653726,-0.00843478799681763,0.313227794657148,-0.347269986697193,
  -0.000149770271984373,-0.00782016710953992,0.327768474830513,-0.368251366261686,
  -0.000155054075316241,-0.00720554622226421,0.342309155003877,-0.389232745826179,
  -0.00016033787864711,-0.00659092533498673,0.356849835177242,-0.410214125390672,
  -0.000165621681978201,-0.00597630444770969,0.371390515350607,-0.431195504955165,
  -0.000170905485309403,-0.00536168356043287,0.385931195523971,-0.452176884519658,
  -0.000176189288640938,-0.00474706267315672,0.400471875697336,-0.47315826408415,
  -0.000181473091971918,-0.0041324417858799,0.4150125558707,-0.494139643648643,
  -0.000186756895302453,-0.0035178208986022,0.429553236044065,-0.515121023213136,
  -0.000192040698633988,-0.00290320001132582,0.444093916217429,-0.536102402777629,
  -0.000197324501965301,-0.00228857912404923,0.458634596390794,-0.557083782342121,
  -0.000202608305296281,-0.00167395823677241,0.473175276564158,-0.578065161906614,
  -0.000207892108627816,-0.00105933734949515,0.487715956737524,-0.599046541471107,
  -0.000213175911958685,-0.000444716462218775,0.502256636910888,-0.6200279210356,
  -0.000218459715289998,0.000169904425058043,0.516797317084252,-0.641009300600093,
  -0.000223743518620534,0.000784525312336193,0.531337997257618,-0.661990680164586,
  -8.57746917162783e-05,-0.0123793191099448,0.178282454778791,-0.162660423089042,
  -9.00298535422839e-05,-0.0117800103967033,0.192087326528341,-0.184185519084017,
  -9.4285015368345e-05,-0.0111807016834615,0.205892198277892,-0.205710615078992,
  -9.85401771945726e-05,-0.0105813929702202,0.219697070027442,-0.227235711073967,
  -0.000102795339020634,-0.00998208425697877,0.233501941776992,-0.248760807068943,
  -0.00010705050084675,-0.00938277554373723,0.247306813526542,-0.270285903063918,
  -0.000111305662672812,-0.00878346683049558,0.261111685276093,-0.291810999058893,
  -0.00011556082449915,-0.00818415811725459,0.274916557025643,-0.313336095053868,
  -0.0001198159863251,-0.00758484940401272,0.288721428775193,-0.334861191048843,
  -0.000124071148151161,-0.00698554069077106,0.302526300524744,-0.356386287043818,
  -0.000128326309977056,-0.00638623197752941,0.316331172274294,-0.377911383038793,
  -0.000132581471803062,-0.00578692326428798,0.330136044023844,-0.399436479033768,
  -0.000136836633629622,-0.00518761455104655,0.343940915773395,-0.420961575028744,
  -0.000141091795455295,-0.00458830583780445,0.357745787522945,-0.442486671023718,
  -0.000145346957281633,-0.00398899712456369,0.371550659272495,-0.464011767018694,
  -0.000149602119107417,-0.00338968841132159,0.385355531022045,-0.485536863013669,
  -0.0001538572809342,-0.00279037969808082,0.399160402771596,-0.507061959008644,
  -0.000158112442760205,-0.00219107098483917,0.412965274521146,-0.528587055003619,
  -0.000162367604586322,-0.00159176227159774,0.426770146270696,-0.550112150998594,
  -0.000166622766412217,-0.00099245355835631,0.440575018020246,-0.571637246993569,
  -0.000170877928237667,-0.000393144845113991,0.454379889769796,-0.593162342988544,
  -0.000175133090064561,0.000206163868126552,0.468184761519346,-0.614687438983519,
  -0.000179388251890789,0.000805472581367539,0.481989633268896,-0.636212534978495,
  -0.000183643413716683,0.00140478129460986,0.495794505018447,-0.65773763097347,
  -0.000187898575543022,0.00200409000785129,0.509599376767998,-0.679262726968445,
  -7.38370526889853e-05,-0.0108280480267909,0.173832451924669,-0.167068536715419,
  -7.70950515421309e-05,-0.0102594896346754,0.186844535993324,-0.189161202575035,
  -8.035305039511e-05,-0.00969093124255982,0.199856620061979,-0.211253868434651,
  -8.36110492481446e-05,-0.00912237285044426,0.212868704130633,-0.233346534294267,
  -8.68690481011791e-05,-0.00855381445832859,0.225880788199288,-0.255439200153884,
  -9.01270469540472e-05,-0.00798525606621281,0.238892872267943,-0.2775318660135,
  -9.33850458071928e-05,-0.00741669767409725,0.251904956336598,-0.299624531873116,
  -9.66430446603384e-05,-0.00684813928198169,0.264917040405252,-0.321717197732732,
  -9.9901043513595e-05,-0.00627958088986635,0.277929124473907,-0.343809863592349,
  -0.000103159042366574,-0.0057110224977508,0.290941208542562,-0.365902529451965,
  -0.00010641704121972,-0.00514246410563524,0.303953292611216,-0.387995195311581,
  -0.000109675040072643,-0.00457390571351945,0.316965376679871,-0.410087861171198,
  -0.0001129330389259,-0.00400534732140412,0.329977460748526,-0.432180527030814,
  -0.000116191037778934,-0.00343678892928834,0.34298954481718,-0.45427319289043,
  -0.000119449036632302,-0.00286823053717322,0.356001628885835,-0.476365858750047,
  -0.000122707035485115,-0.00229967214505744,0.36901371295449,-0.498458524609663,
  -0.00012596503433826,-0.00173111375294188,0.382025797023144,-0.520551190469279,
  -0.000129223033191295,-0.00116255536082654,0.395037881091799,-0.542643856328895,
  -0.000132481032043774,-0.000593996968710098,0.408049965160454,-0.564736522188511,
  -0.000135739030897031,-2.54385765949827e-05,0.421062049229108,-0.586829188048128,
  -0.000138997029750954,0.000543119815519688,0.434074133297763,-0.608921853907744,
  -0.000142255028603877,0.00111167820763569,0.447086217366418,-0.63101451976736,
  -0.000145513027456246,0.00168023659975214,0.460098301435073,-0.653107185626976,
  -0.000148771026310057,0.00224879499186681,0.473110385503727,-0.675199851486593,
  -0.000152029025162981,0.00281735338398237,0.486122469572382,-0.697292517346209,
  -6.17683071474917e-05,-0.00940294183231072,0.169246257044863,-0.171421115161163,
  -6.41334024594209e-05,-0.00887964466982916,0.181450787364694,-0.19407420041299,
  -6.64984977712946e-05,-0.00835634750734748,0.193655317684524,-0.216727285664817,
  -6.88635930831683e-05,-0.00783305034486592,0.205859848004355,-0.239380370916645,
  -7.1228688395264e-05,-0.00730975318238425,0.218064378324185,-0.262033456168472,
  -7.35937837069156e-05,-0.00678645601990224,0.230268908644016,-0.284686541420299,
  -7.59588790186227e-05,-0.00626315885742068,0.242473438963847,-0.307339626672126,
  -7.83239743304964e-05,-0.0057398616949389,0.254677969283677,-0.329992711923954,
  -8.06890696423146e-05,-0.00521656453245711,0.266882499603508,-0.352645797175781,
  -8.30541649542438e-05,-0.00469326736997533,0.279087029923339,-0.375298882427608,
  -8.54192602656179e-05,-0.0041699702074931,0.291291560243169,-0.397951967679435,
  -8.77843555781022e-05,-0.00364667304501221,0.303496090563,-0.420605052931263,
  -9.01494508894762e-05,-0.00312337588252998,0.315700620882831,-0.44325813818309,
  -9.25145462017385e-05,-0.00260007872004908,0.327905151202661,-0.465911223434917,
  -9.48796415134456e-05,-0.00207678155756708,0.340109681522492,-0.488564308686744,
  -9.72447368254858e-05,-0.00155348439508551,0.352314211842322,-0.511217393938571,
  -9.96098321375261e-05,-0.00103018723260417,0.364518742162153,-0.533870479190399,
  -0.000101974927449122,-0.000506890070122168,0.376723272481983,-0.556523564442226,
  -0.000104340022760718,1.64070923598381e-05,0.388927802801814,-0.579176649694053,
  -0.000106705118072981,0.000539704254840956,0.401132333121644,-0.601829734945881,
  -0.000109070213384355,0.00106300141732341,0.413336863441475,-0.624482820197708,
  -0.000111435308696173,0.00158629857980497,0.425541393761306,-0.647135905449535,
  -0.000113800404008102,0.00210959574228653,0.437745924081136,-0.669788990701362,
  -0.000116165499320364,0.00263289290476809,0.449950454400967,-0.69244207595319,
  -0.000118530594632293,0.00315619006724965,0.462154984720798,-0.715095161205017,
  -5.02457493531949e-05,-0.00816761850920722,0.164787179220487,-0.175489138843553,
  -5.18740934261075e-05,-0.00770009295342611,0.176214713051117,-0.198666005432811,
  -5.35024374995752e-05,-0.00723256739764577,0.187642246881747,-0.221842872022069,
  -5.51307815720992e-05,-0.00676504184186411,0.199069780712377,-0.245019738611328,
  -5.67591256454558e-05,-0.00629751628608344,0.210497314543007,-0.268196605200586,
  -5.83874697183684e-05,-0.0058299907303021,0.221924848373637,-0.291373471789844,
  -6.0015813791725e-05,-0.00536246517452166,0.233352382204267,-0.314550338379102,
  -6.16441578645266e-05,-0.00489493961874055,0.244779916034897,-0.337727204968361,
  -6.32725019376612e-05,-0.00442741406295966,0.256207449865527,-0.360904071557619,
  -6.49008460109624e-05,-0.00395988850717854,0.267634983696157,-0.384080938146877,
  -6.65291900837639e-05,-0.00349236295139765,0.279062517526787,-0.407257804736135,
  -6.81575341571206e-05,-0.00302483739561721,0.290490051357417,-0.430434671325393,
  -6.97858782299221e-05,-0.0025573118398361,0.301917585188047,-0.453611537914652,
  -7.14142223033898e-05,-0.00208978628405476,0.313345119018677,-0.47678840450391,
  -7.30425663758583e-05,-0.00162226072827343,0.324772652849307,-0.499965271093168,
  -7.46709104492149e-05,-0.0011547351724932,0.336200186679937,-0.523142137682426,
  -7.62992545226826e-05,-0.000687209616712536,0.347627720510567,-0.546319004271684,
  -7.79275985953731e-05,-0.000219684060930758,0.359055254341197,-0.569495870860942,
  -7.95559426683967e-05,0.000247841494849688,0.370482788171827,-0.592672737450201,
  -8.11842867418644e-05,0.000715367050630356,0.381910322002457,-0.615849604039459,
  -8.2812630814777e-05,0.00118289260641147,0.393337855833087,-0.639026470628717,
  -8.44409748874675e-05,0.00165041816219302,0.404765389663717,-0.662203337217975,
  -8.60693189610462e-05,0.00211794371797325,0.416192923494346,-0.685380203807234,
  -8.76976630342918e-05,0.00258546927375392,0.427620457324976,-0.708557070396492,
  -8.93260071060942e-05,0.0030529948295368,0.439047991155607,-0.73173393698575,
  -3.98286669491266e-05,-0.00714976942538137,0.16068871371924,-0.179100605803067,
  -4.08957117294384e-05,-0.00674272518123153,0.171408449587027,-0.202742469438024,
  -4.19627565096947e-05,-0.00633568093708159,0.182128185454815,-0.22638433307298,
  -4.30298012898955e-05,-0.00592863669293209,0.192847921322602,-0.250026196707937,
  -4.40968460703739e-05,-0.00552159244878214,0.203567657190389,-0.273668060342893,
  -4.51638908506857e-05,-0.00511454820463264,0.214287393058177,-0.29730992397785,
  -4.6230935630831e-05,-0.00470750396048247,0.225007128925964,-0.320951787612806,
  -4.72979804109208e-05,-0.00430045971633253,0.235726864793751,-0.344593651247763,
  -4.83650251914547e-05,-0.00389341547218303,0.246446600661539,-0.36823551488272,
  -4.94320699717665e-05,-0.00348637122803308,0.257166336529326,-0.391877378517676,
  -5.04991147518563e-05,-0.00307932698388336,0.267886072397113,-0.415519242152632,
  -5.15661595321681e-05,-0.00267228273973319,0.278605808264901,-0.439161105787589,
  -5.26332043121469e-05,-0.00226523849558302,0.289325544132689,-0.462802969422546,
  -5.37002490923477e-05,-0.00185819425143308,0.300045280000476,-0.486444833057502,
  -5.47672938733257e-05,-0.00145115000728424,0.310765015868263,-0.510086696692459,
  -5.58343386533044e-05,-0.00104410576313407,0.32148475173605,-0.533728560327415,
  -5.69013834336163e-05,-0.000637061518984128,0.332204487603838,-0.557370423962372,
  -5.79684282138171e-05,-0.00023001727483396,0.342924223471625,-0.581012287597328,
  -5.90354729941289e-05,0.000177026969315541,0.353643959339413,-0.604654151232285,
  -6.01025177747738e-05,0.000584071213464821,0.3643636952072,-0.628296014867241,
  -6.11695625541975e-05,0.000991115457615432,0.375083431074987,-0.651937878502198,
  -6.22366073348424e-05,0.00139815970176516,0.385803166942775,-0.675579742137154,
  -6.33036521147101e-05,0.00180520394591532,0.396522902810562,-0.699221605772111,
  -6.4370696895466e-05,0.00221224819006505,0.407242638678349,-0.722863469407067,
  -6.54377416753338e-05,0.00261929243421477,0.417962374546136,-0.746505333042024,
  -3.08630215203887e-05,-0.00634508766070307,0.157110012297973,-0.182163256815249,
  -3.15327649793029e-05,-0.00599745926084072,0.167216241223128,-0.206199454300863,
  -3.22025084378286e-05,-0.00564983086097781,0.177322470148283,-0.230235651786478,
  -3.28722518966873e-05,-0.00530220246111524,0.187428699073438,-0.254271849272092,
  -3.35419953556015e-05,-0.00495457406125288,0.197534927998593,-0.278308046757706,
  -3.42117388142937e-05,-0.00460694566139019,0.207641156923748,-0.302344244243321,
  -3.48814822726529e-05,-0.00425931726152706,0.217747385848903,-0.326380441728935,
  -3.55512257316781e-05,-0.00391168886166482,0.227853614774057,-0.35041663921455,
  -3.62209691905369e-05,-0.00356406046180191,0.237959843699213,-0.374452836700164,
  -3.68907126495621e-05,-0.00321643206194011,0.248066072624367,-0.398489034185779,
  -3.75604561083653e-05,-0.00286880366207765,0.258172301549522,-0.422525231671393,
  -3.82301995670575e-05,-0.00252117526221451,0.268278530474677,-0.446561429157007,
  -3.88999430260828e-05,-0.00217354686235205,0.278384759399832,-0.470597626642622,
  -3.95696864842199e-05,-0.00182591846248914,0.288490988324987,-0.494633824128236,
  -4.02394299429121e-05,-0.00147829006262623,0.298597217250142,-0.518670021613851,
  -4.09091734019373e-05,-0.00113066166276399,0.308703446175297,-0.542706219099465,
  -4.15789168606295e-05,-0.0007830332629013,0.318809675100452,-0.56674241658508,
  -4.22486603195438e-05,-0.000435404863039057,0.328915904025607,-0.590778614070694,
  -4.29184037781249e-05,-8.7776463176148e-05,0.339022132950762,-0.614814811556309,
  -4.35881472364841e-05,0.000259851936687205,0.349128361875917,-0.638851009041923,
  -4.42578906960645e-05,0.000607480336548782,0.359234590801072,-0.662887206527538,
  -4.49276341543126e-05,0.000955108736412136,0.369340819726227,-0.686923404013152,
  -4.55973776126717e-05,0.00130273713627505,0.379447048651382,-0.710959601498766,
  -4.6267121071808e-05,0.00165036553613751,0.389553277576537,-0.734995798984381,
  -4.69368645303891e-05,0.00199799393599998,0.399659506501691,-0.759031996469996,
  -2.34654365861009e-05,-0.00572873408547392,0.154121093793554,-0.184661237270783,
  -2.38714375595528e-05,-0.00543511228029048,0.163717912761929,-0.209019064040303,
  -2.42774385328937e-05,-0.00514149047510659,0.173314731730304,-0.233376890809823,
  -2.46834395060125e-05,-0.00484786866992226,0.182911550698678,-0.257734717579342,
  -2.50894404796309e-05,-0.00455424686473882,0.192508369667053,-0.282092544348862,
  -2.54954414533048e-05,-0.0042606250595556,0.202105188635427,-0.306450371118381,
  -2.59014424264237e-05,-0.00396700325437127,0.211702007603802,-0.330808197887901,
  -2.63074433996535e-05,-0.00367338144918739,0.221298826572177,-0.355166024657421,
  -2.67134443730499e-05,-0.0033797596440035,0.230895645540552,-0.37952385142694,
  -2.71194453466128e-05,-0.00308613783882028,0.240492464508926,-0.40388167819646,
  -2.75254463197872e-05,-0.00279251603363617,0.250089283477301,-0.428239504965979,
  -2.79314472934056e-05,-0.00249889422845251,0.259686102445676,-0.452597331735499,
  -2.8337448266913e-05,-0.00220527242326884,0.26928292141405,-0.476955158505019,
  -2.87434492396432e-05,-0.00191165061808407,0.278879740382425,-0.501312985274538,
  -2.91494502137057e-05,-0.0016180288129013,0.288476559350799,-0.525670812044058,
  -2.9555451186658e-05,-0.00132440700771697,0.298073378319174,-0.550028638813577,
  -2.99614521601654e-05,-0.0010307852025333,0.307670197287549,-0.574386465583097,
  -3.03674531336728e-05,-0.00073716339734986,0.317267016255923,-0.598744292352617,
  -3.07734541065141e-05,-0.000443541592165086,0.326863835224298,-0.623102119122136,
  -3.11794550801325e-05,-0.000149919786981645,0.336460654192673,-0.647459945891656,
  -3.1585456054084e-05,0.000143702018201353,0.346057473161048,-0.671817772661175,
  -3.19914570269253e-05,0.000437323823386127,0.355654292129422,-0.696175599430695,
  -3.23974580007658e-05,0.000730945628569568,0.365251111097797,-0.720533426200214,
  -3.2803458973385e-05,0.0010245674337539,0.374847930066172,-0.744891252969734,
  -3.32094599468924e-05,0.00131818923893734,0.384444749034546,-0.769249079739254,
  -1.75698002736757e-05,-0.00526730203784365,0.151715287091405,-0.186634700644663,
  -1.78097376261621e-05,-0.0050198819015348,0.160903931766359,-0.211246622121108,
  -1.8049674978371e-05,-0.00477246176522572,0.170092576441312,-0.235858543597553,
  -1.82896123306908e-05,-0.00452504162891643,0.179281221116265,-0.260470465073998,
  -1.85295496830107e-05,-0.00427762149260746,0.188469865791218,-0.285082386550442,
  -1.87694870354971e-05,-0.00403020135629872,0.197658510466171,-0.309694308026887,
  -1.90094243879835e-05,-0.00378278121998954,0.206847155141125,-0.334306229503332,
  -1.92493617401923e-05,-0.0035353610836808,0.216035799816078,-0.358918150979777,
  -1.94892990925677e-05,-0.00328794094737161,0.225224444491031,-0.383530072456222,
  -1.97292364448876e-05,-0.00304052081106199,0.234413089165985,-0.408141993932666,
  -1.99691737972074e-05,-0.00279310067475325,0.243601733840938,-0.432753915409111,
  -2.02091111494163e-05,-0.00254568053844384,0.252790378515891,-0.457365836885556,
  -2.04490485019582e-05,-0.0022982604021351,0.261979023190845,-0.481977758362001,
  -2.0688985853945e-05,-0.00205084026582614,0.271167667865797,-0.506589679838446,
  -2.09289232065979e-05,-0.00180342012951695,0.280356312540751,-0.531201601314891,
  -2.11688605592508e-05,-0.00155599999320799,0.289544957215705,-0.555813522791335,
  -2.14087979112376e-05,-0.00130857985689925,0.298733601890657,-0.58042544426778,
  -2.16487352634465e-05,-0.00106115972059007,0.307922246565611,-0.605037365744225,
  -2.18886726162104e-05,-0.000813739584281326,0.317110891240564,-0.62964928722067,
  -2.21286099686413e-05,-0.000566319447972141,0.326299535915517,-0.654261208697115,
  -2.23685473206281e-05,-0.000318899311662069,0.335488180590471,-0.678873130173559,
  -2.26084846736141e-05,-7.14791753546606e-05,0.344676825265423,-0.703485051650004,
  -2.28484220258229e-05,0.000175940960955412,0.353865469940378,-0.728096973126449,
  -2.30883593773656e-05,0.00042336109726504,0.363054114615331,-0.752708894602894,
  -2.33282967300186e-05,0.000670781233573337,0.372242759290283,-0.777320816079339,
  -1.29988369886869e-05,-0.00492726123474363,0.14983531434508,-0.188154861990617,
  -1.31384097043497e-05,-0.00471756382775512,0.15870609417851,-0.212962512942861,
  -1.32779824197904e-05,-0.0045078664207665,0.16757687401194,-0.237770163895106,
  -1.34175551355642e-05,-0.00429816901377789,0.176447653845371,-0.26257781484735,
  -1.35571278511715e-05,-0.00408847160678949,0.185318433678801,-0.287385465799594,
  -1.36967005668343e-05,-0.00387877419980098,0.194189213512232,-0.312193116751839,
  -1.38362732826081e-05,-0.00366907679281248,0.203059993345662,-0.337000767704083,
  -1.39758459979933e-05,-0.00345937938582375,0.211930773179092,-0.361808418656327,
  -1.41154187138781e-05,-0.00324968197883568,0.220801553012523,-0.386616069608572,
  -1.42549914290413e-05,-0.00303998457184651,0.229672332845953,-0.411423720560816,
  -1.43945641449816e-05,-0.00283028716485845,0.238543112679384,-0.436231371513061,
  -1.45341368604779e-05,-0.0026205897578695,0.247413892512814,-0.461039022465305,
  -1.46737095763072e-05,-0.00241089235088165,0.256284672346244,-0.485846673417549,
  -1.48132822920255e-05,-0.0022011949438927,0.265155452179675,-0.510654324369794,
  -1.49528550076328e-05,-0.0019914975369042,0.274026232013105,-0.535461975322038,
  -1.50924277234621e-05,-0.00178180012991591,0.282897011846536,-0.560269626274282,
  -1.52320004380702e-05,-0.00157210272292652,0.291767791679966,-0.585077277226527,
  -1.53715731545656e-05,-0.00136240531593845,0.300638571513397,-0.609884928178771,
  -1.55111458700619e-05,-0.00115270790894995,0.309509351346827,-0.634692579131016,
  -1.56507185856691e-05,-0.000943010501961439,0.318380131180257,-0.65950023008326,
  -1.57902913018315e-05,-0.00073331309497382,0.327250911013687,-0.684307881035504,
  -1.59298640171057e-05,-0.000523615687984869,0.336121690847118,-0.709115531987749,
  -1.60694367321579e-05,-0.000313918280995473,0.344992470680549,-0.733923182939993,
  -1.62090094482092e-05,-0.00010422087400741,0.353863250513979,-0.758730833892237,
  -1.63485821641496e-05,0.000105476532980653,0.362734030347409,-0.783538484844482,
  -9.52952976085442e-06,-0.00467930274466644,0.148399727317786,-0.18930319644232,
  -9.61019634404536e-06,-0.00449933484683085,0.15702840182311,-0.214258702029122,
  -9.69086292679222e-06,-0.0043193669489946,0.165657076328434,-0.239214207615924,
  -9.77152950942806e-06,-0.00413939905115812,0.174285750833759,-0.264169713202726,
  -9.85219609250798e-06,-0.0039594311533222,0.182914425339083,-0.289125218789528,
  -9.93286267508831e-06,-0.00377946325548595,0.191543099844407,-0.31408072437633,
  -1.00135292576686e-05,-0.00359949535764947,0.200171774349731,-0.339036229963132,
  -1.00941958409151e-05,-0.00341952745981389,0.208800448855055,-0.363991735549934,
  -1.0174862423773e-05,-0.00323955956197763,0.217429123360379,-0.388947241136736,
  -1.02555290061312e-05,-0.00305959166414094,0.226057797865703,-0.413902746723538,
  -1.03361955895442e-05,-0.00287962376630535,0.234686472371027,-0.43885825231034,
  -1.04168621722911e-05,-0.00269965586846954,0.243315146876351,-0.463813757897141,
  -1.04975287549269e-05,-0.00251968797063262,0.251943821381676,-0.488769263483943,
  -1.05781953376738e-05,-0.00233972007279681,0.260572495886999,-0.513724769070745,
  -1.06588619205317e-05,-0.00215975217496078,0.269201170392323,-0.538680274657547,
  -1.07395285028344e-05,-0.00197978427712342,0.277829844897648,-0.563635780244349,
  -1.08201950864695e-05,-0.00179981637928828,0.286458519402972,-0.588591285831151,
  -1.09008616695494e-05,-0.00161984848145291,0.295087193908296,-0.613546791417953,
  -1.09815282514081e-05,-0.00143988058361488,0.303715868413621,-0.638502297004755,
  -1.10621948348211e-05,-0.00125991268577952,0.312344542918944,-0.663457802591557,
  -1.11428614174569e-05,-0.00107994478794371,0.320973217424268,-0.688413308178359,
  -1.12235280003148e-05,-0.000899976890107457,0.329601891929592,-0.713368813765161,
  -1.13041945828396e-05,-0.000720008992271204,0.338230566434916,-0.738324319351963,
  -1.13848611661416e-05,-0.000540041094434951,0.346859240940241,-0.763279824938765,
  -1.14655277494435e-05,-0.000360073196599586,0.355487915445565,-0.788235330525567,
  -6.93841706522758e-06,-0.00449973119030489,0.1473225677922,-0.190157917874099,
  -6.98514141661555e-06,-0.00434258173950808,0.155769928491412,-0.215223473738289,
  -7.0318657683921e-06,-0.00418543228871182,0.164217289190624,-0.240289029602479,
  -7.07859011983558e-06,-0.00402828283791501,0.172664649889836,-0.265354585466668,
  -7.12531447155662e-06,-0.00387113338711842,0.181112010589048,-0.290420141330858,
  -7.17203882294459e-06,-0.00371398393632161,0.189559371288261,-0.315485697195048,
  -7.2187631744991e-06,-0.00355683448552502,0.198006731987473,-0.340551253059238,
  -7.26548752577605e-06,-0.00339968503472821,0.206454092686685,-0.365616808923428,
  -7.31221187760811e-06,-0.00324253558393162,0.214901453385898,-0.390682364787618,
  -7.35893622894057e-06,-0.00308538613313503,0.223348814085109,-0.415747920651808,
  -7.40566058066161e-06,-0.00292823668233888,0.231796174784321,-0.440813476515998,
  -7.45238493216061e-06,-0.00277108723154229,0.240243535483533,-0.465879032380188,
  -7.49910928377062e-06,-0.00261393778074548,0.248690896182746,-0.490944588244377,
  -7.54583363526962e-06,-0.00245678832994889,0.257138256881958,-0.516010144108567,
  -7.59255798665759e-06,-0.00229963887915186,0.265585617581171,-0.541075699972757,
  -7.63928233860067e-06,-0.00214248942835571,0.274032978280383,-0.566141255836947,
  -7.68600668998864e-06,-0.0019853399775589,0.282480338979595,-0.591206811701137,
  -7.73273104182071e-06,-0.00182819052676297,0.290927699678807,-0.616272367565327,
  -7.77945539343072e-06,-0.00167104107596616,0.299375060378019,-0.641337923429517,
  -7.82617974415256e-06,-0.00151389162516891,0.307822421077231,-0.666403479293707,
  -7.87290409598462e-06,-0.00135674217437254,0.316269781776443,-0.691469035157897,
  -7.91962844748362e-06,-0.00119959272357528,0.324717142475656,-0.716534591022087,
  -7.96635279931568e-06,-0.0010424432727798,0.333164503174867,-0.741600146886277,
  -8.01307715114774e-06,-0.000885293821983435,0.34161186387408,-0.766665702750467,
  -8.05980150186958e-06,-0.000728144371186179,0.350059224573292,-0.791731258614656,
  -5.02626280407537e-06,-0.0043702633250704,0.146524908328217,-0.190787121784692,
  -5.05359496510982e-06,-0.00423028864211605,0.154838188589072,-0.215933691254391,
  -5.08092712597774e-06,-0.00409031395916126,0.163151468849927,-0.24108026072409,
  -5.10825928679015e-06,-0.0039503392762068,0.171464749110782,-0.266226830193789,
  -5.13559144760256e-06,-0.00381036459325235,0.179778029371637,-0.291373399663488,
  -5.16292360847048e-06,-0.00367038991029767,0.188091309632492,-0.316519969133187,
  -5.19025576917187e-06,-0.00353041522734276,0.196404589893347,-0.341666538602886,
  -5.21758792992877e-06,-0.00339044054438853,0.204717870154201,-0.366813108072586,
  -5.24492009107425e-06,-0.00325046586143407,0.213031150415056,-0.391959677542285,
  -5.27225225188666e-06,-0.00311049117847939,0.221344430675911,-0.417106247011984,
  -5.29958441275458e-06,-0.00297051649552493,0.229657710936766,-0.442252816481683,
  -5.3269165736225e-06,-0.0028305418125707,0.237970991197621,-0.467399385951382,
  -5.3542487343794e-06,-0.00269056712961557,0.246284271458476,-0.492545955421081,
  -5.3815808951363e-06,-0.00255059244666134,0.254597551719331,-0.51769252489078,
  -5.40891305611524e-06,-0.00241061776370666,0.262910831980186,-0.542839094360479,
  -5.43624521653907e-06,-0.00227064308075198,0.271224112241041,-0.567985663830178,
  -5.46357737762904e-06,-0.00213066839779774,0.279537392501896,-0.593132233299878,
  -5.49090953838594e-06,-0.00199069371484306,0.287850672762751,-0.618278802769577,
  -5.5182416994759e-06,-0.00185071903188883,0.296163953023605,-0.643425372239276,
  -5.54557386045484e-06,-0.00171074434893415,0.304477233284461,-0.668571941708974,
  -5.57290602054561e-06,-0.00157076966597858,0.312790513545316,-0.693718511178674,
  -5.60023818163558e-06,-0.0014307949830239,0.321103793806171,-0.718865080648373,
  -5.62757034272554e-06,-0.00129082030007011,0.329417074067025,-0.744011650118072,
  -5.65490250359346e-06,-0.00115084561711587,0.33773035432788,-0.769158219587771,
  -5.68223466412832e-06,-0.0010108709341603,0.346043634588736,-0.79430478905747,
  -3.62755830696226e-06,-0.0042771878494583,0.145939943446299,-0.191246560306296,
  -3.64380671474818e-06,-0.00414995611860303,0.15415499479461,-0.216452285115811,
  -3.66005512225653e-06,-0.00402272438774809,0.162370046142922,-0.241658009925327,
  -3.67630353009796e-06,-0.00389549265689337,0.170585097491233,-0.266863734734842,
  -3.69255193793938e-06,-0.00376826092603855,0.178800148839545,-0.292069459544358,
  -3.70880034550325e-06,-0.00364102919518361,0.187015200187856,-0.317275184353873,
  -3.72504875323365e-06,-0.00351379746432889,0.195230251536167,-0.342480909163389,
  -3.74129716124161e-06,-0.00338656573347418,0.203445302884479,-0.367686633972904,
  -3.75754556847241e-06,-0.0032593340026188,0.21166035423279,-0.39289235878242,
  -3.77379397620281e-06,-0.00313210227176408,0.219875405581101,-0.418098083591935,
  -3.79004238360015e-06,-0.00300487054090848,0.228090456929413,-0.443303808401451,
  -3.80629079166361e-06,-0.00287763881005398,0.236305508277725,-0.468509533210966,
  -3.82253919950504e-06,-0.00275040707919927,0.244520559626036,-0.493715258020482,
  -3.83878760701339e-06,-0.00262317534834411,0.252735610974347,-0.518920982829997,
  -3.85503601518788e-06,-0.00249594361748984,0.260950662322659,-0.544126707639513,
  -3.87128442269624e-06,-0.00236871188663446,0.26916571367097,-0.569332432449028,
  -3.88753283009358e-06,-0.00224148015577974,0.277380765019281,-0.594538157258544,
  -3.90378123782398e-06,-0.0021142484249248,0.285595816367593,-0.619743882068059,
  -3.92002964588745e-06,-0.00198701669406987,0.293810867715905,-0.644949606877575,
  -3.93627805361785e-06,-0.00185978496321493,0.302025919064216,-0.67015533168709,
  -3.95252646123723e-06,-0.00173255323236043,0.310240970412527,-0.695361056496606,
  -3.96877486852354e-06,-0.00160532150150461,0.318456021760839,-0.720566781306121,
  -3.98502327647599e-06,-0.00147808977065012,0.32667107310915,-0.745772506115637,
  -4.00127168398434e-06,-0.00135085803979562,0.334886124457461,-0.770978230925152,
  -4.01752009193679e-06,-0.00122362630894068,0.343101175805773,-0.796183955734667,
  -2.61100534154624e-06,-0.00421040060462718,0.145514005514239,-0.191580049986481,
  -2.62086634805758e-06,-0.00409252543945515,0.153657584412099,-0.216828713501458,
  -2.63072735451342e-06,-0.00397465027428312,0.161801163309958,-0.242077377016434,
  -2.64058836130232e-06,-0.00385677510911131,0.169944742207818,-0.267326040531411,
  -2.65044936753611e-06,-0.00373889994393917,0.178088321105677,-0.292574704046388,
  -2.66031037399195e-06,-0.00362102477876713,0.186231900003537,-0.317823367561364,
  -2.67017138078085e-06,-0.00350314961359532,0.194375478901397,-0.343072031076341,
  -2.6800323872922e-06,-0.00338527444842329,0.202519057799256,-0.368320694591317,
  -2.68989339347048e-06,-0.00326739928325082,0.210662636697116,-0.393569358106294,
  -2.69975440014836e-06,-0.00314952411807901,0.218806215594975,-0.418818021621271,
  -2.70961540638215e-06,-0.00303164895290631,0.226949794492835,-0.444066685136247,
  -2.71947641294901e-06,-0.00291377378773494,0.235093373390695,-0.469315348651224,
  -2.72933741940484e-06,-0.00279589862256291,0.243236952288554,-0.4945640121662,
  -2.73919842586068e-06,-0.00267802345739065,0.251380531186414,-0.519812675681177,
  -2.74905943253856e-06,-0.00256014829221884,0.259524110084273,-0.545061339196154,
  -2.75892043855031e-06,-0.00244227312704615,0.267667688982133,-0.57031000271113,
  -2.76878144533921e-06,-0.00232439796187478,0.275811267879992,-0.595558666226107,
  -2.77864245190607e-06,-0.00220652279670253,0.283954846777852,-0.620807329741083,
  -2.78850345847292e-06,-0.00208864763153072,0.292098425675712,-0.64605599325606,
  -2.79836446503978e-06,-0.00197077246635891,0.300242004573571,-0.671304656771037,
  -2.80822547149562e-06,-0.00185289730118665,0.308385583471431,-0.696553320286013,
  -2.81808647784043e-06,-0.00173502213601395,0.316529162369291,-0.72180198380099,
  -2.82794748451831e-06,-0.00161714697084303,0.32467274126715,-0.747050647315967,
  -2.8378084907521e-06,-0.00149927180567033,0.33281632016501,-0.772299310830943,
  -2.84766949720794e-06,-0.00138139664049808,0.34095989906287,-0.79754797434592,
  -1.87564079440206e-06,-0.00416253595712757,0.145205466442737,-0.191821075165852,
  -1.88176578169719e-06,-0.00405147914047299,0.153297299696321,-0.217100772052476,
  -1.88789076921436e-06,-0.00394042232381853,0.161389132949905,-0.2423804689391,
  -1.894015756565e-06,-0.00382936550716395,0.169480966203489,-0.267660165825724,
  -1.90014074441525e-06,-0.00371830869050993,0.177572799457073,-0.292939862712348,
  -1.90626573176589e-06,-0.00360725187385547,0.185664632710657,-0.318219559598971,
  -1.91239071928306e-06,-0.00349619505720078,0.193756465964242,-0.343499256485595,
  -1.91851570668922e-06,-0.00338513824054631,0.201848299217826,-0.368778953372219,
  -1.92464069398435e-06,-0.00327408142389163,0.20994013247141,-0.394058650258843,
  -1.93076568111294e-06,-0.00316302460723672,0.218031965724994,-0.419338347145467,
  -1.93689066885216e-06,-0.00305196779058226,0.226123798978578,-0.444618044032091,
  -1.94301565670241e-06,-0.00294091097392868,0.234215632232162,-0.469897740918715,
  -1.94914064421958e-06,-0.00282985415727421,0.242307465485746,-0.495177437805338,
  -1.95526563140369e-06,-0.00271879734061931,0.25039929873933,-0.520457134691962,
  -1.96139061903189e-06,-0.00260774052396484,0.258491131992915,-0.545736831578586,
  -1.967515606216e-06,-0.00249668370730993,0.266582965246499,-0.57101652846521,
  -1.97364059362215e-06,-0.00238562689065569,0.274674798500083,-0.596296225351834,
  -1.97976558136137e-06,-0.00227457007400167,0.282766631753667,-0.621575922238458,
  -1.98589056954468e-06,-0.00216351325734809,0.29085846500725,-0.646855619125081,
  -1.99201555639572e-06,-0.0020524564406923,0.298950298260835,-0.672135316011705,
  -1.99814054357983e-06,-0.00194139962403783,0.307042131514419,-0.697415012898329,
  -2.00426553131905e-06,-0.00183034280738381,0.315133964768003,-0.722694709784953,
  -2.01039051850316e-06,-0.0017192859907289,0.323225798021587,-0.747974406671577,
  -2.01651550657544e-06,-0.00160822917407533,0.331317631275171,-0.773254103558201,
  -2.02264049375955e-06,-0.00149717235742042,0.339409464528755,-0.798533800444825,
  -1.3454801545687e-06,-0.00412826093108687,0.144982806035451,-0.191994729850861,
  -1.34937590040574e-06,-0.00402214576337145,0.153037310654293,-0.217296785772305,
  -1.35327164613175e-06,-0.00391603059565615,0.161091815273134,-0.24259884169375,
  -1.35716739207981e-06,-0.00380991542794085,0.169146319891976,-0.267900897615194,
  -1.3610631381944e-06,-0.00370380026022588,0.177200824510817,-0.293202953536638,
  -1.36495888403143e-06,-0.00359768509251079,0.185255329129659,-0.318505009458083,
  -1.36885462981295e-06,-0.00349156992479527,0.193309833748501,-0.343807065379527,
  -1.37275037603857e-06,-0.00338545475708041,0.201364338367342,-0.369109121300971,
  -1.37664612170907e-06,-0.00327933958936466,0.209418842986184,-0.394411177222416,
  -1.38054186749059e-06,-0.00317322442164958,0.217473347605025,-0.41971323314386,
  -1.38443761388274e-06,-0.00306710925393472,0.225527852223867,-0.445015289065304,
  -1.38833335949773e-06,-0.00296099408621919,0.233582356842708,-0.470317344986749,
  -1.39222910533476e-06,-0.00285487891850411,0.24163686146155,-0.495619400908193,
  -1.3961248511718e-06,-0.00274876375078881,0.249691366080391,-0.520921456829637,
  -1.40002059689781e-06,-0.00264264858307306,0.257745870699233,-0.546223512751082,
  -1.40391634295689e-06,-0.00253653341535798,0.265800375318075,-0.571525568672526,
  -1.40781208912699e-06,-0.00243041824764334,0.273854879936916,-0.59682762459397,
  -1.411707834853e-06,-0.00232430307992759,0.281909384555758,-0.622129680515415,
  -1.41560358113413e-06,-0.00221818791221295,0.289963889174599,-0.647431736436859,
  -1.4194993266381e-06,-0.00211207274449698,0.298018393793441,-0.672733792358303,
  -1.42339507303024e-06,-0.00200595757678235,0.306072898412283,-0.698035848279748,
  -1.42729081886728e-06,-0.00189984240906771,0.314127403031124,-0.723337904201192,
  -1.43118656459329e-06,-0.00179372724135174,0.322181907649966,-0.748639960122636,
  -1.43508230998624e-06,-0.00168761207363577,0.330236412268808,-0.773942016044081,
  -1.43897805582327e-06,-0.00158149690592069,0.338290916887649,-0.799244071965525,
  -0.000157740819841989,-0.0254151520084142,0.209918431044634,-0.14078812449481,
  -0.000169289483192614,-0.0249743980106578,0.227861594053555,-0.158434063167546,
  -0.000180838146542961,-0.024533644012901,0.245804757062477,-0.176080001840282,
  -0.000192386809893585,-0.0240928900151447,0.263747920071397,-0.193725940513019,
  -0.00020393547324421,-0.0236521360173881,0.281691083080319,-0.211371879185755,
  -0.000215484136594613,-0.0232113820196314,0.29963424608924,-0.229017817858491,
  -0.000227032799945515,-0.0227706280218753,0.317577409098161,-0.246663756531227,
  -0.000238581463295862,-0.0223298740241187,0.335520572107082,-0.264309695203964,
  -0.000250130126646653,-0.0218891200263625,0.353463735116003,-0.2819556338767,
  -0.000261678789996944,-0.0214483660286056,0.371406898124924,-0.299601572549436,
  -0.00027322745334768,-0.0210076120308493,0.389350061133845,-0.317247511222172,
  -0.000284776116698082,-0.0205668580330929,0.407293224142766,-0.334893449894909,
  -0.000296324780048485,-0.0201261040353362,0.425236387151687,-0.352539388567645,
  -0.000307873443399664,-0.0196853500375802,0.443179550160609,-0.370185327240381,
  -0.000319422106749956,-0.0192445960398235,0.46112271316953,-0.387831265913117,
  -0.000330970770100247,-0.0188038420420666,0.479065876178451,-0.405477204585854,
  -0.00034251943345065,-0.0183630880443097,0.497009039187372,-0.42312314325859,
  -0.000354068096801941,-0.0179223340465546,0.514952202196293,-0.440769081931326,
  -0.000365616760151788,-0.0174815800487969,0.532895365205215,-0.458415020604062,
  -0.000377165423502857,-0.0170408260510411,0.550838528214135,-0.476060959276798,
  -0.000388714086853481,-0.0166000720532851,0.568781691223056,-0.493706897949535,
  -0.00040026275020455,-0.0161593180555291,0.586724854231977,-0.511352836622271,
  -0.000411811413554508,-0.0157185640577717,0.604668017240898,-0.528998775295007,
  -0.000423360076905133,-0.0152778100600148,0.62261118024982,-0.546644713967744,
  -0.000434908740255535,-0.0148370560622584,0.640554343258741,-0.56429065264048,
  -0.000155619073621271,-0.0249192899988971,0.209225139844652,-0.141760038219477,
  -0.000166898779435931,-0.0244643115463761,0.22703863488966,-0.159524034970541,
  -0.000178178485250369,-0.0240093330938547,0.244852129934667,-0.177288031721605,
  -0.000189458191065361,-0.0235543546413336,0.262665624979675,-0.195052028472669,
  -0.000200737896880188,-0.0230993761888126,0.280479120024683,-0.212816025223733,
  -0.000212017602694792,-0.0226443977362916,0.29829261506969,-0.230580021974797,
  -0.000223297308509895,-0.0221894192837706,0.316106110114698,-0.248344018725861,
  -0.000234577014323945,-0.0217344408312488,0.333919605159706,-0.266108015476925,
  -0.000245856720138937,-0.021279462378728,0.351733100204713,-0.283872012227989,
  -0.000257136425953486,-0.0208244839262066,0.369546595249721,-0.301636008979053,
  -0.000268416131768423,-0.0203695054736857,0.387360090294729,-0.319400005730116,
  -0.000279695837582916,-0.0199145270211645,0.405173585339736,-0.337164002481181,
  -0.000290975543398075,-0.0194595485686433,0.422987080384744,-0.354927999232245,
  -0.000302255249212569,-0.0190045701161221,0.440800575429752,-0.372691995983309,
  -0.000313534955027284,-0.0185495916636009,0.458614070474759,-0.390455992734372,
  -0.000324814660841888,-0.0180946132110797,0.476427565519767,-0.408219989485436,
  -0.000336094366656936,-0.0176396347585588,0.494241060564775,-0.425983986236501,
  -0.000347374072471429,-0.0171846563060376,0.512054555609782,-0.443747982987564,
  -0.000358653778286033,-0.0167296778535164,0.52986805065479,-0.461511979738628,
  -0.000369933484101304,-0.0162746994009959,0.547681545699797,-0.479275976489692,
  -0.000381213189915464,-0.0158197209484738,0.565495040744805,-0.497039973240756,
  -0.000392492895730401,-0.0153647424959531,0.583308535789813,-0.51480396999182,
  -0.000403772601545227,-0.0149097640434319,0.601122030834821,-0.532567966742884,
  -0.000415052307359276,-0.0144547855909103,0.618935525879829,-0.550331963493948,
  -0.000426332013173991,-0.0139998071383887,0.636749020924837,-0.568095960245012,
  -0.000152738951035625,-0.0242592096479013,0.208277499919437,-0.14306830791397,
  -0.000163657938009709,-0.023786080281894,0.225914700769516,-0.160991219805489,
  -0.000174576924983849,-0.0233129509158867,0.243551901619595,-0.178914131697008,
  -0.000185495911958045,-0.0228398215498797,0.261189102469674,-0.196837043588528,
  -0.00019641489893224,-0.0223666921838725,0.278826303319754,-0.214759955480047,
  -0.000207333885906491,-0.0218935628178656,0.296463504169833,-0.232682867371567,
  -0.000218252872880409,-0.0214204334518582,0.314100705019912,-0.250605779263086,
  -0.000229171859855104,-0.0209473040858514,0.331737905869991,-0.268528691154606,
  -0.000240090846829022,-0.0204741747198443,0.34937510672007,-0.286451603046125,
  -0.00025100983380355,-0.0200010453538373,0.367012307570149,-0.304374514937644,
  -0.000261928820777357,-0.0195279159878297,0.384649508420229,-0.322297426829163,
  -0.000272847807751608,-0.0190547866218225,0.402286709270308,-0.340220338720683,
  -0.000283766794725526,-0.0185816572558153,0.419923910120387,-0.358143250612203,
  -0.000294685781699999,-0.0181085278898083,0.437561110970466,-0.376066162503722,
  -0.000305604768674361,-0.0176353985238016,0.455198311820545,-0.393989074395241,
  -0.00031652375564839,-0.0171622691577942,0.472835512670625,-0.411911986286761,
  -0.000327442742622419,-0.0166891397917868,0.490472713520704,-0.429834898178281,
  -0.000338361729596892,-0.0162160104257802,0.508109914370783,-0.4477578100698,
  -0.000349280716570921,-0.0157428810597726,0.525747115220862,-0.465680721961319,
  -0.000360199703545505,-0.0152697516937661,0.543384316070941,-0.483603633852838,
  -0.000371118690519534,-0.0147966223277587,0.56102151692102,-0.501526545744358,
  -0.000382037677493785,-0.0143234929617519,0.578658717771099,-0.519449457635877,
  -0.000392956664468702,-0.0138503635957452,0.596295918621178,-0.537372369527396,
  -0.000403875651442287,-0.0133772342297376,0.613933119471258,-0.555295281418916,
  -0.000414794638415761,-0.0129041048637295,0.631570320321337,-0.573218193310436,
  -0.000148874044137715,-0.0233963192889641,0.206994283818034,-0.144804588498605,
  -0.00015931686130527,-0.0229008707888062,0.224394411085606,-0.162938405889304,
  -0.00016975967847277,-0.0224054222886481,0.241794538353179,-0.181072223280002,
  -0.000180202495640269,-0.0219099737884899,0.259194665620751,-0.1992060406707,
  -0.000190645312807269,-0.0214145252883313,0.276594792888324,-0.217339858061399,
  -0.000201088129974991,-0.0209190767881733,0.293994920155897,-0.235473675452097,
  -0.000211530947142269,-0.0204236282880148,0.311395047423469,-0.253607492842795,
  -0.00022197376430988,-0.019928179787857,0.328795174691042,-0.271741310233494,
  -0.000232416581477046,-0.0194327312876985,0.346195301958614,-0.289875127624192,
  -0.000242859398644546,-0.0189372827875405,0.363595429226186,-0.30800894501489,
  -0.000253302215811657,-0.018441834287382,0.380995556493759,-0.326142762405588,
  -0.000263745032979545,-0.0179463857872242,0.398395683761331,-0.344276579796287,
  -0.000274187850147212,-0.0174509372870661,0.415795811028904,-0.362410397186985,
  -0.000284630667314323,-0.0169554887869077,0.433195938296477,-0.380544214577683,
  -0.000295073484481656,-0.0164600402867496,0.450596065564049,-0.398678031968382,
  -0.0003055163016491,-0.0159645917865912,0.467996192831621,-0.41681184935908,
  -0.000315959118816211,-0.0154691432864327,0.485396320099194,-0.434945666749778,
  -0.000326401935983989,-0.0149736947862746,0.502796447366767,-0.453079484140476,
  -0.0003368447531511,-0.0144782462861164,0.520196574634339,-0.471213301531175,
  -0.000347287570318655,-0.0139827977859581,0.537596701901911,-0.489347118921873,
  -0.000357730387485655,-0.0134873492857999,0.554996829169484,-0.507480936312572,
  -0.000368173204653433,-0.0129919007856421,0.572396956437056,-0.525614753703269,
  -0.000378616021820877,-0.0124964522854834,0.589797083704629,-0.543748571093968,
  -0.000389058838988765,-0.012001003785326,0.607197210972201,-0.561882388484667,
  -0.000399501656155654,-0.0115055552851673,0.624597338239774,-0.580016205875365,
  -0.000143767577879483,-0.0222949748027097,0.205279176829357,-0.147066123530159,
  -0.000153595085932656,-0.0217734926577877,0.222365203957992,-0.165474648925405,
  -0.000163422593985829,-0.0212520105128657,0.239451231086628,-0.183883174320652,
  -0.000173250102039002,-0.0207305283679439,0.256537258215264,-0.202291699715898,
  -0.000183077610092119,-0.0202090462230217,0.2736232853439,-0.220700225111144,
  -0.000192905118145292,-0.0196875640781,0.290709312472536,-0.23910875050639,
  -0.000202732626198465,-0.019166081933178,0.307795339601172,-0.257517275901636,
  -0.000212560134251527,-0.0186445997882558,0.324881366729808,-0.275925801296882,
  -0.000222387642304978,-0.0181231176433343,0.341967393858443,-0.294334326692128,
  -0.000232215150358095,-0.0176016354984121,0.359053420987079,-0.312742852087375,
  -0.000242042658411212,-0.0170801533534903,0.376139448115715,-0.331151377482621,
  -0.000251870166463886,-0.0165586712085677,0.393225475244351,-0.349559902877867,
  -0.000261697674517114,-0.0160371890636457,0.410311502372987,-0.367968428273113,
  -0.00027152518257012,-0.0155157069187235,0.427397529501623,-0.386376953668359,
  -0.000281352690623349,-0.0149942247738015,0.444483556630259,-0.404785479063605,
  -0.000291180198676577,-0.0144727426288798,0.461569583758895,-0.423194004458851,
  -0.000301007706729917,-0.0139512604839578,0.478655610887531,-0.441602529854098,
  -0.000310835214782812,-0.0134297783390358,0.495741638016166,-0.460011055249344,
  -0.00032066272283604,-0.012908296194114,0.512827665144802,-0.47841958064459,
  -0.000330490230889713,-0.0123868140491923,0.529913692273438,-0.496828106039836,
  -0.000340317738942386,-0.0118653319042701,0.546999719402074,-0.515236631435082,
  -0.000350145246994948,-0.011343849759347,0.56408574653071,-0.533645156830328,
  -0.000359972755048621,-0.0108223676144257,0.581171773659346,-0.552053682225574,
  -0.000369800263101849,-0.0103008854695039,0.598257800787982,-0.570462207620821,
  -0.000379627771154745,-0.00977940332458127,0.615343827916618,-0.588870733016067,
  -0.000137158942421445,-0.0209320675868468,0.203027578081791,-0.149940972376525,
  -0.000146213478226576,-0.0203824734448916,0.219705654351263,-0.168698704827573,
  -0.000155268014031817,-0.0198328793029362,0.236383730620736,-0.187456437278621,
  -0.000164322549837226,-0.0192832851609813,0.253061806890209,-0.206214169729669,
  -0.000173377085642634,-0.0187336910190264,0.269739883159681,-0.224971902180717,
  -0.000182431621448154,-0.0181840968770717,0.286417959429154,-0.243729634631765,
  -0.000191486157253395,-0.0176345027351161,0.303096035698627,-0.262487367082813,
  -0.000200540693058582,-0.017084908593161,0.319774111968099,-0.281245099533861,
  -0.000209595228863824,-0.0165353144512057,0.336452188237572,-0.300002831984909,
  -0.000218649764669121,-0.0159857203092506,0.353130264507045,-0.318760564435957,
  -0.000227704300474696,-0.0154361261672955,0.369808340776517,-0.337518296887005,
  -0.000236758836279938,-0.0148865320253406,0.38648641704599,-0.356276029338054,
  -0.000245813372085513,-0.014336937883386,0.403164493315462,-0.375033761789102,
  -0.000254867907890532,-0.0137873437414302,0.419842569584935,-0.39379149424015,
  -0.000263922443695663,-0.0132377495994751,0.436520645854408,-0.412549226691198,
  -0.000272976979501349,-0.0126881554575204,0.45319872212388,-0.431306959142246,
  -0.000282031515306702,-0.0121385613155651,0.469876798393353,-0.450064691593294,
  -0.000291086051111722,-0.0115889671736098,0.486554874662826,-0.468822424044342,
  -0.000300140586917186,-0.0110393730316551,0.503232950932298,-0.48758015649539,
  -0.000309195122722428,-0.0104897788896996,0.519911027201771,-0.506337888946438,
  -0.000318249658527781,-0.0099401847477445,0.536589103471244,-0.525095621397486,
  -0.000327304194333355,-0.00939059060578984,0.553267179740716,-0.543853353848534,
  -0.000336358730138264,-0.00884099646383385,0.569945256010189,-0.562611086299582,
  -0.000345413265943395,-0.00829140232187919,0.586623332279661,-0.58136881875063,
  -0.000354467801749303,-0.00774180817992454,0.603301408549134,-0.600126551201678,
  -0.000128834306842018,-0.019309768269802,0.200142372870624,-0.15348446737709,
  -0.000136952745200314,-0.0187332368399949,0.216304263304367,-0.172672627138416,
  -0.000145071183558554,-0.0181567054101879,0.23246615373811,-0.191860786899741,
  -0.000153189621917016,-0.0175801739803813,0.248628044171853,-0.211048946661067,
  -0.000161308060275256,-0.0170036425505741,0.264789934605596,-0.230237106422392,
  -0.000169426498633607,-0.0164271111207674,0.280951825039339,-0.249425266183718,
  -0.000177544936992013,-0.0158505796909605,0.297113715473082,-0.268613425945044,
  -0.000185663375350253,-0.0152740482611535,0.313275605906825,-0.287801585706369,
  -0.000193781813708493,-0.0146975168313463,0.329437496340568,-0.306989745467695,
  -0.000201900252066567,-0.0141209854015389,0.345599386774311,-0.32617790522902,
  -0.000210018690425029,-0.0135444539717324,0.361761277208054,-0.345366064990346,
  -0.000218137128783269,-0.0129679225419252,0.377923167641797,-0.364554224751672,
  -0.000226255567141842,-0.0123913911121187,0.39408505807554,-0.383742384512997,
  -0.000234374005499749,-0.0118148596823111,0.410246948509283,-0.402930544274323,
  -0.000242492443858211,-0.0112383282525046,0.426408838943026,-0.422118704035649,
  -0.000250610882216562,-0.0106617968226979,0.442570729376769,-0.441306863796974,
  -0.000258729320574802,-0.0100852653928905,0.458732619810512,-0.4604950235583,
  -0.000266847758933042,-0.00950873396308349,0.474894510244255,-0.479683183319626,
  -0.000274966197290727,-0.00893220253327587,0.491056400677998,-0.498871343080951,
  -0.0002830846356493,-0.00835567110346913,0.507218291111741,-0.518059502842277,
  -0.00029120307400754,-0.00777913967366217,0.523380181545484,-0.537247662603602,
  -0.000299321512365558,-0.00720260824385477,0.539542071979227,-0.556435822364928,
  -0.000307439950724908,-0.00662607681404914,0.55570396241297,-0.575623982126254,
  -0.000315558389082371,-0.00604954538424129,0.571865852846714,-0.59481214188758,
  -0.000323676827441055,-0.00547301395443478,0.588027743280456,-0.614000301648905,
  -0.000118701970086121,-0.0174677468674611,0.196560823501357,-0.157689764045413,
  -0.000125738109483686,-0.0168703668319528,0.212090992493522,-0.177388739973708,
  -0.00013277424888114,-0.0162729867964442,0.227621161485688,-0.197087715902004,
  -0.000139810388278538,-0.0156756067609354,0.243151330477853,-0.216786691830299,
  -0.000146846527676103,-0.0150782267254269,0.258681499470019,-0.236485667758595,
  -0.000153882667073335,-0.014480846689918,0.274211668462184,-0.25618464368689,
  -0.000160918806470622,-0.0138834666544092,0.28974183745435,-0.275883619615186,
  -0.000167954945868132,-0.0132860866189006,0.305272006446516,-0.295582595543481,
  -0.000174991085265641,-0.0126887065833921,0.320802175438681,-0.315281571471777,
  -0.000182027224663539,-0.0120913265478839,0.336332344430846,-0.334980547400072,
  -0.000189063364060771,-0.0114939465123749,0.351862513423012,-0.354679523328368,
  -0.000196099503458336,-0.0108965664768665,0.367392682415178,-0.374378499256664,
  -0.00020313564285579,-0.010299186441358,0.382922851407343,-0.394077475184959,
  -0.000210171782252688,-0.0097018064058485,0.398453020399509,-0.413776451113255,
  -0.000217207921650586,-0.00910442637034037,0.413983189391674,-0.43347542704155,
  -0.00022424406104804,-0.00850704633483179,0.42951335838384,-0.453174402969846,
  -0.000231280200445494,-0.00790966629932321,0.445043527376005,-0.472873378898142,
  -0.000238316339842726,-0.00731228626381419,0.460573696368171,-0.492572354826437,
  -0.000245352479240513,-0.00671490622830628,0.476103865360336,-0.512271330754732,
  -0.000252388618637633,-0.00611752619279748,0.491634034352501,-0.531970306683028,
  -0.000259424758034865,-0.00552014615728824,0.507164203344667,-0.551669282611323,
  -0.000266460897432985,-0.00492276612177989,0.522694372336833,-0.571368258539619,
  -0.000273497036830106,-0.00432538608627153,0.538224541328998,-0.591067234467914,
  -0.000280533176227338,-0.00372800605076229,0.553754710321164,-0.61076621039621,
  -0.00028756931562457,-0.00313062601525305,0.56928487931333,-0.630465186324506,
  -0.000106877472319467,-0.0154880544387747,0.1922895394295,-0.162461810789138,
  -0.000112731347651218,-0.01488173791601,0.207077699558768,-0.182740445851733,
  -0.000118585222982803,-0.0142754213932447,0.221865859688037,-0.203019080914328,
  -0.000124439098314388,-0.0136691048704799,0.236654019817305,-0.223297715976922,
  -0.000130292973646029,-0.0130627883477149,0.251442179946573,-0.243576351039517,
  -0.00013614684897767,-0.01245647182495,0.266230340075841,-0.263854986102112,
  -0.000142000724309532,-0.0118501553021853,0.28101850020511,-0.284133621164707,
  -0.000147854599641173,-0.0112438387794203,0.295806660334378,-0.304412256227301,
  -0.000153708474972702,-0.010637522256655,0.310594820463647,-0.324690891289896,
  -0.000159562350304565,-0.0100312057338903,0.325382980592915,-0.344969526352491,
  -0.000165416225635817,-0.00942488921112505,0.340171140722183,-0.365248161415085,
  -0.000171270100967957,-0.00881857268836073,0.354959300851451,-0.38552679647768,
  -0.000177123976299431,-0.00821225616559507,0.36974746098072,-0.405805431540275,
  -0.000182977851631128,-0.00760593964283074,0.384535621109988,-0.42608406660287,
  -0.000188831726962602,-0.00699962312006552,0.399323781239256,-0.446362701665464,
  -0.00019468560229452,-0.00639330659730097,0.414111941368524,-0.466641336728059,
  -0.000200539477626216,-0.00578699007453576,0.428900101497793,-0.486919971790654,
  -0.000206393352957801,-0.00518067355177099,0.443688261627061,-0.507198606853248,
  -0.000212247228289497,-0.00457435702900599,0.458476421756329,-0.527477241915843,
  -0.00021810110362086,-0.00396804050624056,0.473264581885598,-0.547755876978438,
  -0.000223954978953,-0.00336172398347623,0.488052742014866,-0.568034512041033,
  -0.000229808854284697,-0.00275540746071146,0.502840902144134,-0.588313147103627,
  -0.000235662729615949,-0.00214909093794535,0.517629062273403,-0.608591782166222,
  -0.000241516604947534,-0.00154277441518103,0.53241722240267,-0.628870417228817,
  -0.000247370480279341,-0.000936457892416254,0.547205382531939,-0.649149052291412,
  -9.37423703483709e-05,-0.0134858253268317,0.187435391011737,-0.167609344359392,
  -9.83883413782083e-05,-0.0128875503826037,0.201393181293224,-0.188513248832232,
  -0.000103034312408656,-0.0122892754383762,0.215350971574711,-0.209417153305071,
  -0.000107680283438494,-0.0116910004941481,0.229308761856198,-0.23032105777791,
  -0.000112326254468664,-0.0110927255499205,0.243266552137685,-0.25122496225075,
  -0.000116972225498502,-0.0104944506056923,0.257224342419172,-0.272128866723589,
  -0.000121618196528783,-0.00989617566146483,0.271182132700659,-0.293032771196428,
  -0.000126264167558898,-0.00929790071723713,0.285139922982146,-0.313936675669268,
  -0.000130910138588625,-0.00869962577300898,0.299097713263633,-0.334840580142107,
  -0.000135556109619128,-0.0081013508287815,0.31305550354512,-0.355744484614946,
  -0.000140202080649243,-0.00750307588455401,0.327013293826606,-0.376648389087786,
  -0.000144848051679247,-0.00690480094032608,0.340971084108094,-0.397552293560625,
  -0.000149494022709584,-0.0063065259960986,0.35492887438958,-0.418456198033465,
  -0.000154139993739588,-0.00570825105187067,0.368886664671067,-0.439360102506304,
  -0.000158785964769814,-0.00510997610764297,0.382844454952554,-0.460264006979143,
  -0.000163431935799707,-0.00451170116341504,0.396802245234041,-0.481167911451983,
  -0.0001680779068296,-0.00391342621918711,0.410760035515528,-0.502071815924822,
  -0.000172723877859937,-0.0033151512749594,0.424717825797015,-0.522975720397661,
  -0.000177369848889941,-0.00271687633073192,0.438675616078502,-0.543879624870501,
  -0.000182015819919501,-0.00211860138650355,0.452633406359989,-0.56478352934334,
  -0.000186661790949949,-0.00152032644227607,0.466591196641476,-0.58568743381618,
  -0.000191307761980064,-0.000922051498048138,0.480548986922963,-0.606591338289019,
  -0.000195953733010179,-0.000323776553820654,0.49450677720445,-0.627495242761858,
  -0.000200599704040072,0.000274498390407718,0.508464567485937,-0.648399147234698,
  -0.000205245675070409,0.000872773334635202,0.522422357767424,-0.669303051707537,
  -7.99310319722357e-05,-0.0115850845897552,0.182212969751726,-0.172867027973653,
  -8.3432421549845e-05,-0.0110141164450552,0.195290504735669,-0.194409581750645,
  -8.69338111273432e-05,-0.0104431483003549,0.208368039719613,-0.215952135527636,
  -9.04352007047859e-05,-0.0098721801556545,0.221445574703557,-0.237494689304628,
  -9.39365902821176e-05,-0.00930121201095435,0.234523109687501,-0.259037243081619,
  -9.74379798595604e-05,-0.00873024386625398,0.247600644671445,-0.280579796858611,
  -0.00010093936943717,-0.00815927572155406,0.260678179655388,-0.302122350635602,
  -0.000104440759014612,-0.00758830757685369,0.273755714639332,-0.323664904412594,
  -0.000107942148591667,-0.00701733943215288,0.286833249623276,-0.345207458189585,
  -0.000111443538169387,-0.00644637128745318,0.29991078460722,-0.366750011966577,
  -0.000114944927746774,-0.00587540314275281,0.312988319591164,-0.388292565743568,
  -0.000118446317324494,-0.00530443499805311,0.326065854575107,-0.40983511952056,
  -0.000121947706901882,-0.00473346685335274,0.339143389559051,-0.431377673297551,
  -0.00012544909647938,-0.00416249870865304,0.352220924542995,-0.452920227074543,
  -0.000128950486056767,-0.00359153056395245,0.365298459526939,-0.474462780851534,
  -0.000132451875634154,-0.00302056241925186,0.378375994510883,-0.496005334628525,
  -0.000135953265211652,-0.00244959427455149,0.391453529494827,-0.517547888405517,
  -0.000139454654788707,-0.00187862612985068,0.404531064478771,-0.539090442182508,
  -0.000142956044366316,-0.00130765798515142,0.417608599462714,-0.5606329959595,
  -0.000146457433944147,-0.000736689840451277,0.430686134446658,-0.582175549736491,
  -0.000149958823521423,-0.000165721695751131,0.443763669430601,-0.603718103513483,
  -0.000153460213099033,0.000405246448949015,0.456841204414545,-0.625260657290474,
  -0.000156961602676309,0.000976214593649161,0.469918739398489,-0.646803211067466,
  -0.000160462992253363,0.00154718273834975,0.482996274382433,-0.668345764844457,
  -0.000163964381831305,0.0021181508830499,0.496073809366377,-0.689888318621449,
  -6.62232921073147e-05,-0.00988886630486607,0.17691406364501,-0.177946250147048,
  -6.87240975152381e-05,-0.00936274368892565,0.18911039895448,-0.200105775568715,
  -7.1224902923217e-05,-0.00883662107298555,0.20130673426395,-0.222265300990382,
  -7.37257083307519e-05,-0.00831049845704479,0.213503069573419,-0.244424826412048,
  -7.62265137384532e-05,-0.00778437584110425,0.225699404882889,-0.266584351833715,
  -7.87273191462101e-05,-0.00725825322516349,0.237895740192359,-0.288743877255381,
  -8.12281245538005e-05,-0.00673213060922295,0.250092075501828,-0.310903402677048,
  -8.37289299616684e-05,-0.00620600799328241,0.262288410811298,-0.333062928098715,
  -8.62297353697028e-05,-0.00567988537734254,0.274484746120767,-0.355222453520381,
  -8.87305407771821e-05,-0.00515376276140134,0.286681081430238,-0.377381978942048,
  -9.12313461846059e-05,-0.00462764014546058,0.298877416739707,-0.399541504363715,
  -9.37321515922518e-05,-0.00410151752951982,0.311073752049177,-0.421701029785381,
  -9.62329570006748e-05,-0.00357539491358017,0.323270087358646,-0.443860555207048,
  -9.87337624080986e-05,-0.00304927229763896,0.335466422668116,-0.466020080628714,
  -0.000101234567815855,-0.00252314968169842,0.347662757977586,-0.488179606050381,
  -0.000103735373223501,-0.00199702706575811,0.359859093287056,-0.510339131472048,
  -0.000106236178631369,-0.00147090444981779,0.372055428596525,-0.532498656893715,
  -0.000108736984039126,-0.000944781833877251,0.384251763905995,-0.554658182315381,
  -0.000111237789446883,-0.00041865921793649,0.396448099215465,-0.576817707737048,
  -0.000113738594854751,0.000107463398003826,0.408644434524934,-0.598977233158714,
  -0.00011623940026273,0.000633586013944143,0.420840769834404,-0.621136758580381,
  -0.000118740205670265,0.00115970862988446,0.433037105143873,-0.643296284002048,
  -0.000121241011078244,0.00168583124582522,0.445233440453343,-0.665455809423714,
  -0.000123741816485223,0.00221195386176642,0.457429775762813,-0.687615334845381,
  -0.000126242621893868,0.0027380764777063,0.469626111072283,-0.709774860267048,
  -5.33744927950219e-05,-0.00845796150272471,0.171844843222908,-0.1825957572992,
  -5.506927210569e-05,-0.00798891394834234,0.183207975456313,-0.205320057006508,
  -5.67640514163026e-05,-0.00751986639396007,0.194571107689718,-0.228044356713816,
  -5.84588307267486e-05,-0.00705081883957748,0.205934239923124,-0.250768656421124,
  -6.01536100370836e-05,-0.00658177128519477,0.217297372156529,-0.273492956128431,
  -6.18483893479183e-05,-0.00611272373081273,0.228660504389935,-0.296217255835739,
  -6.35431686584753e-05,-0.00564367617643025,0.24002363662334,-0.318941555543047,
  -6.52379479690324e-05,-0.00517462862204798,0.251386768856745,-0.341665855250355,
  -6.69327272793119e-05,-0.00470558106766505,0.262749901090151,-0.364390154957663,
  -6.8627506590202e-05,-0.00423653351328324,0.274113033323556,-0.38711445466497,
  -7.0322285900537e-05,-0.00376748595890031,0.285476165556962,-0.409838754372278,
  -7.20170652116492e-05,-0.00329843840451871,0.296839297790366,-0.432563054079586,
  -7.37118445216511e-05,-0.00282939085013512,0.308202430023772,-0.455287353786894,
  -7.54066238325413e-05,-0.00236034329575352,0.319565562257177,-0.478011653494202,
  -7.71014031432093e-05,-0.0018912957413717,0.330928694490582,-0.50073595320151,
  -7.87961824537664e-05,-0.00142224818698877,0.342291826723988,-0.523460252908817,
  -8.04909617643235e-05,-0.000953200632606288,0.353654958957394,-0.546184552616125,
  -8.21857410746585e-05,-0.000484153078224026,0.365018091190799,-0.568908852323433,
  -8.38805203851045e-05,-1.51055238410969e-05,0.376381223424204,-0.591633152030741,
  -8.55752996959946e-05,0.000453942030540944,0.387744355657609,-0.614357451738049,
  -8.72700790065517e-05,0.000922989584923428,0.399107487891015,-0.637081751445357,
  -8.89648583171088e-05,0.00139203713930591,0.41047062012442,-0.659806051152664,
  -9.06596376273328e-05,0.00186108469368884,0.421833752357826,-0.682530350859972,
  -9.23544169381119e-05,0.00233013224807044,0.433196884591231,-0.70525465056728,
  -9.40491962486689e-05,0.00279917980245337,0.444560016824637,-0.727978950274588,
  -4.19572267271184e-05,-0.00730700058508948,0.167257896503593,-0.186646686184674,
  -4.30517227855698e-05,-0.0069002456101086,0.177874401383225,-0.209863051049128,
  -4.41462188444097e-05,-0.00649349063512827,0.188490906262858,-0.233079415913582,
  -4.52407149028056e-05,-0.00608673566014739,0.19910741114249,-0.256295780778036,
  -4.6335210961479e-05,-0.00567998068516706,0.209723916022123,-0.279512145642491,
  -4.74297070200413e-05,-0.00527322571018618,0.220340420901755,-0.302728510506945,
  -4.85242030786037e-05,-0.00486647073520552,0.230956925781388,-0.325944875371399,
  -4.96186991369996e-05,-0.00445971576022464,0.241573430661021,-0.349161240235853,
  -5.07131951956175e-05,-0.0040529607852442,0.252189935540653,-0.372377605100308,
  -5.18076912542353e-05,-0.00364620581026354,0.262806440420286,-0.395593969964762,
  -5.29021873127977e-05,-0.00323945083528288,0.273422945299918,-0.418810334829216,
  -5.39966833713601e-05,-0.00283269586030177,0.284039450179551,-0.44202669969367,
  -5.50911794302555e-05,-0.00242594088532155,0.294655955059184,-0.465243064558125,
  -5.61856754883738e-05,-0.00201918591034045,0.305272459938816,-0.488459429422579,
  -5.72801715476023e-05,-0.00161243093536068,0.315888964818448,-0.511675794287033,
  -5.83746676054986e-05,-0.00120567596037868,0.326505469698082,-0.534892159151487,
  -5.9469163664283e-05,-0.000798920985398688,0.337121974577714,-0.558108524015941,
  -6.05636597230674e-05,-0.000392166010418471,0.347738479457346,-0.581324888880396,
  -6.16581557811857e-05,1.45889645630781e-05,0.358354984336979,-0.60454125374485,
  -6.2752651839304e-05,0.000421343939544627,0.368971489216612,-0.627757618609304,
  -6.38471478986435e-05,0.0008280989145244,0.379587994096245,-0.650973983473758,
  -6.4941643957428e-05,0.00123485388950417,0.390204498975877,-0.674190348338212,
  -6.60361400157683e-05,0.00164160886448528,0.400821003855509,-0.697406713202667,
  -6.71306360742197e-05,0.00204836383946638,0.411437508735142,-0.720623078067121,
  -6.82251321330041e-05,0.0024551188144466,0.422054013614775,-0.743839442931575,
  -3.228021332502e-05,-0.00641532403135203,0.163309010493678,-0.19002690310177,
  -3.29584181856246e-05,-0.00606955243326501,0.173287760665244,-0.213653861935045,
  -3.36366230463403e-05,-0.00572378083517799,0.183266510836809,-0.237280820768321,
  -3.4314827906945e-05,-0.00537800923709075,0.193245261008375,-0.260907779601596,
  -3.49930327672721e-05,-0.00503223763900329,0.203224011179941,-0.284534738434872,
  -3.56712376280988e-05,-0.00468646604091649,0.213202761351506,-0.308161697268148,
  -3.63494424887589e-05,-0.0043406944428297,0.223181511523072,-0.331788656101423,
  -3.70276473493636e-05,-0.00399492284474245,0.233160261694638,-0.355415614934699,
  -3.77058522095797e-05,-0.00364915124665455,0.243139011866204,-0.379042573767974,
  -3.83840570703509e-05,-0.00330337964856797,0.253117762037769,-0.40266953260125,
  -3.90622619308445e-05,-0.00295760805048095,0.263096512209334,-0.426296491434525,
  -3.97404667922263e-05,-0.0026118364523946,0.2730752623809,-0.449923450267801,
  -4.04186716520538e-05,-0.00226606485430669,0.283054012552466,-0.473550409101076,
  -4.10968765128805e-05,-0.0019202932562199,0.293032762724031,-0.497177367934352,
  -4.17750813735962e-05,-0.00157452165813265,0.303011512895597,-0.520804326767628,
  -4.24532862336457e-05,-0.00122875006004497,0.312990263067163,-0.544431285600903,
  -4.31314910949165e-05,-0.000882978461958617,0.322969013238728,-0.568058244434179,
  -4.38096959555212e-05,-0.00053720686387182,0.332947763410294,-0.591685203267454,
  -4.44879008154597e-05,-0.000191435265783468,0.34292651358186,-0.61531216210073,
  -4.51661056768415e-05,0.000154336332302663,0.352905263753425,-0.638939120934005,
  -4.5844310536558e-05,0.00050010793039057,0.362884013924991,-0.662566079767281,
  -4.65225153973847e-05,0.000845879528477145,0.372862764096556,-0.686193038600556,
  -4.72007202584335e-05,0.00119165112656416,0.382841514268123,-0.709819997433832,
  -4.7878925118594e-05,0.00153742272465163,0.392820264439688,-0.733446956267108,
  -4.85571299797538e-05,0.00188319432273865,0.402799014611254,-0.757073915100383,
  -2.43985397578306e-05,-0.00574338065697311,0.160050779482165,-0.192747267398463,
  -2.48052220699901e-05,-0.00545266413771017,0.169506528338644,-0.216704668094085,
  -2.52119043824828e-05,-0.00516194761844779,0.178962277195123,-0.240662068789706,
  -2.56185866945313e-05,-0.00487123109918475,0.188418026051603,-0.264619469485328,
  -2.60252690066909e-05,-0.00458051457992181,0.197873774908082,-0.28857687018095,
  -2.64319513194611e-05,-0.00428979806065977,0.207329523764561,-0.312534270876571,
  -2.68386336318427e-05,-0.00399908154139728,0.21678527262104,-0.336491671572193,
  -2.72453159438912e-05,-0.00370836502213412,0.22624102147752,-0.360449072267815,
  -2.76519982566059e-05,-0.00341764850287185,0.235696770333999,-0.384406472963436,
  -2.80586805690985e-05,-0.00312693198360936,0.245152519190478,-0.408363873659058,
  -2.84653628811471e-05,-0.00283621546434643,0.254608268046957,-0.43232127435468,
  -2.88720451937508e-05,-0.00254549894508371,0.264064016903437,-0.456278675050302,
  -2.92787275054662e-05,-0.00225478242582078,0.273519765759916,-0.480236075745923,
  -2.96854098182919e-05,-0.00196406590655895,0.282975514616395,-0.504193476441545,
  -3.00920921303405e-05,-0.00167334938729535,0.292431263472875,-0.528150877137167,
  -3.04987744429441e-05,-0.00138263286803353,0.301887012329353,-0.552108277832788,
  -3.09054567555478e-05,-0.00109191634877059,0.311342761185833,-0.57606567852841,
  -3.13121390678184e-05,-0.000801199829508104,0.320798510042312,-0.600023079224032,
  -3.17188213802e-05,-0.000510483310245835,0.330254258898791,-0.623980479919653,
  -3.21255036921375e-05,-0.000219766790982678,0.33971000775527,-0.647937880615275,
  -3.25321860048522e-05,7.09497282795901e-05,0.34916575661175,-0.671895281310897,
  -3.29388683173448e-05,0.000361666247541859,0.358621505468229,-0.695852682006519,
  -3.33455506292824e-05,0.000652382766805459,0.368077254324708,-0.71981008270214,
  -3.3752232941664e-05,0.000943099286068172,0.377533003181188,-0.743767483397762,
  -3.41589152541566e-05,0.00123381580533044,0.386988752037667,-0.767724884093383,
  -1.81829505269682e-05,-0.00524666434754717,0.157454266876236,-0.194873565063733,
  -1.84211510676491e-05,-0.0050027046970138,0.166495176237537,-0.219089246520232,
  -1.8659351608219e-05,-0.00475874504648033,0.175536085598838,-0.243304927976732,
  -1.88975521489554e-05,-0.00451478539594707,0.184576994960139,-0.267520609433231,
  -1.91357526897473e-05,-0.00427082574541382,0.19361790432144,-0.29173629088973,
  -1.93739532300397e-05,-0.00402686609488012,0.202658813682741,-0.31595197234623,
  -1.96121537707206e-05,-0.00378290644434687,0.211699723044042,-0.340167653802729,
  -1.98503543111794e-05,-0.00353894679381339,0.220740632405343,-0.364383335259228,
  -2.00885548519159e-05,-0.00329498714328014,0.229781541766644,-0.388599016715727,
  -2.03267553925413e-05,-0.0030510274927471,0.238822451127945,-0.412814698172227,
  -2.05649559330556e-05,-0.00280706784221318,0.247863360489246,-0.437030379628726,
  -2.08031564737921e-05,-0.00256310819167949,0.256904269850547,-0.461246061085225,
  -2.10413570141954e-05,-0.00231914854114601,0.265945179211848,-0.485461742541724,
  -2.12795575551539e-05,-0.00207518889061298,0.274986088573149,-0.509677423998224,
  -2.15177580954462e-05,-0.00183122924007906,0.28402699793445,-0.533893105454723,
  -2.17559586360716e-05,-0.00158726958954603,0.293067907295751,-0.558108786911222,
  -2.1994159176697e-05,-0.00134330993901277,0.302108816657052,-0.582324468367722,
  -2.22323597178775e-05,-0.00109935028847996,0.311149726018353,-0.606540149824221,
  -2.24705602578368e-05,-0.000855390637945597,0.320190635379654,-0.63075583128072,
  -2.27087607982401e-05,-0.00061143098741212,0.329231544740955,-0.654971512737219,
  -2.29469613391986e-05,-0.000367471336879532,0.338272454102255,-0.679187194193719,
  -2.31851618793799e-05,-0.000123511686345612,0.347313363463556,-0.703402875650218,
  -2.34233624196722e-05,0.000120447964188752,0.356354272824858,-0.727618557106717,
  -2.36615629608528e-05,0.000364407614720896,0.365395182186158,-0.751834238563217,
  -2.38997635013671e-05,0.000608367265254373,0.374436091547459,-0.776049920019716,
  -1.34037275033028e-05,-0.00488411261732169,0.155441284111603,-0.196497895335566,
  -1.35412940485691e-05,-0.00467807979522517,0.164161710994076,-0.220910883719208,
  -1.36788605941685e-05,-0.00447204697312842,0.17288213787655,-0.245323872102851,
  -1.38164271393793e-05,-0.00426601415103145,0.181602564759025,-0.269736860486493,
  -1.39539936848121e-05,-0.00405998132893481,0.190322991641499,-0.294149848870135,
  -1.40915602301894e-05,-0.00385394850683807,0.199043418523973,-0.318562837253777,
  -1.42291267754557e-05,-0.0036479156847411,0.207763845406447,-0.342975825637419,
  -1.43666933209441e-05,-0.00344188286264413,0.216484272288921,-0.367388814021061,
  -1.45042598661549e-05,-0.00323585004054738,0.225204699171395,-0.391801802404704,
  -1.46418264117543e-05,-0.00302981721845086,0.233925126053869,-0.416214790788346,
  -1.47793929570206e-05,-0.00282378439635433,0.242645552936343,-0.440627779171988,
  -1.491695950262e-05,-0.00261775157425759,0.251365979818817,-0.46504076755563,
  -1.50545260474422e-05,-0.00241171875216062,0.260086406701291,-0.489453755939272,
  -1.51920925927085e-05,-0.00220568593006321,0.268806833583765,-0.513866744322914,
  -1.53296591381968e-05,-0.00199965310796668,0.277527260466239,-0.538279732706556,
  -1.54672256836852e-05,-0.00179362028587016,0.286247687348713,-0.562692721090199,
  -1.56047922290625e-05,-0.00158758746377297,0.294968114231188,-0.587105709473841,
  -1.57423587745509e-05,-0.00138155464167644,0.303688541113662,-0.611518697857483,
  -1.58799253199282e-05,-0.00117552181957992,0.312408967996135,-0.635931686241125,
  -1.60174918654166e-05,-0.000969488997482948,0.32112939487861,-0.660344674624767,
  -1.61550584103498e-05,-0.000763456175385979,0.329849821761084,-0.684757663008409,
  -1.62926249561712e-05,-0.00055742335328901,0.338570248643558,-0.709170651392051,
  -1.64301915013265e-05,-0.000351390531192042,0.347290675526032,-0.733583639775694,
  -1.65677580462598e-05,-0.000145357709094629,0.356011102408507,-0.757996628159336,
  -1.67053245919702e-05,6.06751130014516e-05,0.36473152929098,-0.782409616542978,
  -9.79937217493454e-06,-0.00462161183197185,0.153913503309736,-0.197717181411202,
  -9.87842135719008e-06,-0.00444530778400654,0.162391328004467,-0.222278276120918,
  -9.95747053961216e-06,-0.00426900373604122,0.170869152699199,-0.246839370830634,
  -1.00365197216457e-05,-0.00409269968807568,0.179346977393931,-0.27140046554035,
  -1.01155689035681e-05,-0.00391639564010959,0.187824802088662,-0.295961560250066,
  -1.01946180861012e-05,-0.00374009159214483,0.196302626783394,-0.320522654959782,
  -1.02736672682457e-05,-0.00356378754417896,0.204780451478126,-0.345083749669498,
  -1.03527164501127e-05,-0.0033874834962131,0.213258276172857,-0.369644844379214,
  -1.04317656323683e-05,-0.00321117944824811,0.221736100867589,-0.39420593908893,
  -1.05108148146238e-05,-0.00303487540028269,0.23021392556232,-0.418767033798646,
  -1.05898639967128e-05,-0.00285857135231682,0.238691750257052,-0.443328128508362,
  -1.06689131789128e-05,-0.00268226730435162,0.247169574951783,-0.467889223218078,
  -1.07479623613349e-05,-0.00250596325638663,0.255647399646515,-0.492450317927794,
  -1.08270115429798e-05,-0.0023296592084201,0.264125224341247,-0.51701141263751,
  -1.0906060725735e-05,-0.00215335516045578,0.272603049035978,-0.541572507347226,
  -1.09851099076019e-05,-0.00197705111248925,0.28108087373071,-0.566133602056942,
  -1.1064159089913e-05,-0.00180074706452449,0.289558698425441,-0.590694696766658,
  -1.11432082723351e-05,-0.00162444301655906,0.298036523120173,-0.615255791476374,
  -1.1222257454313e-05,-0.00144813896859386,0.306514347814904,-0.63981688618609,
  -1.13013066358469e-05,-0.00127183492062732,0.314992172509637,-0.664377980895806,
  -1.138035581838e-05,-0.00109553087266256,0.323469997204368,-0.688939075605522,
  -1.14594050009131e-05,-0.000919226824697805,0.331947821899099,-0.713500170315238,
  -1.15384541830021e-05,-0.000742922776731714,0.340425646593831,-0.738061265024954,
  -1.16175033654242e-05,-0.00056661872876651,0.348903471288563,-0.76262235973467,
  -1.16965525469581e-05,-0.000390314680799975,0.357381295983295,-0.787183454444386,
  -7.12027086441358e-06,-0.00443249546210334,0.152772460993502,-0.198620425851387,
  -7.165846283963e-06,-0.00427891194980523,0.16106944102443,-0.223291237401355,
  -7.21142170356792e-06,-0.00412532843750735,0.169366421055358,-0.247962048951324,
  -7.25699712311734e-06,-0.00397174492520924,0.177663401086287,-0.272632860501292,
  -7.30257254311084e-06,-0.0038181614129118,0.185960381117215,-0.297303672051261,
  -7.34814796260475e-06,-0.00366457790061392,0.194257361148143,-0.321974483601229,
  -7.39372338215416e-06,-0.00351099438831559,0.202554341179072,-0.346645295151198,
  -7.43929880220318e-06,-0.00335741087601815,0.21085132121,-0.371316106701166,
  -7.48487422175259e-06,-0.00320382736372027,0.219148301240928,-0.395986918251134,
  -7.53044964107996e-06,-0.00305024385142194,0.227445281271857,-0.420657729801103,
  -7.57602506151756e-06,-0.00289666033912539,0.235742261302784,-0.445328541351071,
  -7.62160048062288e-06,-0.0027430768268264,0.244039241333713,-0.46999935290104,
  -7.66717590061639e-06,-0.0025894933145294,0.252336221364641,-0.494670164451008,
  -7.71275131994376e-06,-0.00243590980223107,0.260633201395569,-0.519340976000977,
  -7.75832673982624e-06,-0.00228232628993341,0.268930181426497,-0.544011787550945,
  -7.80390215937565e-06,-0.00212874277763508,0.277227161457426,-0.568682599100913,
  -7.84947757925814e-06,-0.00197515926533764,0.285524141488354,-0.593353410650882,
  -7.89505299825244e-06,-0.00182157575303865,0.293821121519283,-0.61802422220085,
  -7.94062841869003e-06,-0.00166799224074188,0.302118101550211,-0.642695033750819,
  -7.9862038380174e-06,-0.00151440872844377,0.310415081581139,-0.667365845300787,
  -8.03177925767784e-06,-0.00136082521614522,0.318712061612068,-0.692036656850755,
  -8.07735467789339e-06,-0.00120724170384845,0.327009041642996,-0.716707468400724,
  -8.12293009699872e-06,-0.00105365819155034,0.335306021673924,-0.741378279950692,
  -8.16850551654813e-06,-0.00090007467925135,0.343603001704853,-0.766049091500661,
  -8.21408093643061e-06,-0.000746491166954577,0.351899981735781,-0.790719903050629,
  -5.15020821351131e-06,-0.00429665988542394,0.151930402708798,-0.199283026385069,
  -5.17676778843956e-06,-0.00416012161111801,0.160094109920119,-0.224034323829742,
  -5.20332736314577e-06,-0.00402358333681185,0.168257817131441,-0.248785621274415,
  -5.22988693807402e-06,-0.00388704506250603,0.176421524342762,-0.273536918719088,
  -5.25644651289126e-06,-0.00375050678819999,0.184585231554083,-0.298288216163761,
  -5.28300608743093e-06,-0.0036139685138934,0.192748938765405,-0.323039513608434,
  -5.30956566263674e-06,-0.00347743023958791,0.200912645976726,-0.347790811053106,
  -5.33612523723193e-06,-0.00334089196528153,0.209076353188047,-0.372542108497779,
  -5.36268481182711e-06,-0.00320435369097516,0.217240060399368,-0.397293405942452,
  -5.38924438675537e-06,-0.00306781541666923,0.22540376761069,-0.422044703387125,
  -5.41580396173913e-06,-0.00293127714236352,0.233567474822011,-0.446796000831798,
  -5.44236353650085e-06,-0.00279473886805759,0.241731182033332,-0.471547298276471,
  -5.46892311181768e-06,-0.00265820059375188,0.249894889244653,-0.496298595721144,
  -5.49548268591327e-06,-0.00252166231944484,0.258058596455975,-0.521049893165817,
  -5.52204226111908e-06,-0.00238512404513957,0.266222303667295,-0.54580119061049,
  -5.5486018358808e-06,-0.00224858577083342,0.274386010878617,-0.570552488055163,
  -5.57516141042047e-06,-0.00211204749652683,0.282549718089939,-0.595303785499836,
  -5.60172098584832e-06,-0.00197550922222156,0.29071342530126,-0.620055082944509,
  -5.62828056016595e-06,-0.00183897094791474,0.298877132512581,-0.644806380389181,
  -5.65484013481665e-06,-0.00170243267360837,0.307040839723903,-0.669557677833854,
  -5.68139971002246e-06,-0.00156589439930288,0.315204546935224,-0.694308975278527,
  -5.7079592848952e-06,-0.00142935612499695,0.323368254146545,-0.7190602727232,
  -5.73451885932386e-06,-0.00129281785069102,0.331531961357866,-0.743811570167873,
  -5.76107843430762e-06,-0.00115627957638464,0.339695668569187,-0.768562867612546,
  -5.78763800929138e-06,-0.00101974130207871,0.347859375780509,-0.793314165057218,
  -3.71290802991808e-06,-0.00419927236427542,0.151314443675528,-0.199765611750166,
  -3.72864798375838e-06,-0.00407534997793668,0.159380761157111,-0.224575528699211,
  -3.74438793754317e-06,-0.00395142759159828,0.167447078638693,-0.249385445648256,
  -3.76012789138347e-06,-0.00382750520525965,0.175513396120276,-0.274195362597301,
  -3.77586784511275e-06,-0.00370358281892091,0.183579713601859,-0.299005279546346,
  -3.79160779939713e-06,-0.00357966043258329,0.191646031083441,-0.323815196495391,
  -3.80734775279334e-06,-0.00345573804624411,0.199712348565024,-0.348625113444436,
  -3.82308770652262e-06,-0.00333181565990515,0.207778666046607,-0.373435030393481,
  -3.8388276607515e-06,-0.00320789327356752,0.215844983528189,-0.398244947342527,
  -3.8545676140922e-06,-0.00308397088722812,0.223911301009772,-0.423054864291572,
  -3.87030756821005e-06,-0.00296004850089004,0.231977618491355,-0.447864781240616,
  -3.8860475217728e-06,-0.00283612611455131,0.240043935972938,-0.472674698189662,
  -3.90178747600167e-06,-0.00271220372821346,0.24811025345452,-0.497484615138706,
  -3.91752742956442e-06,-0.00258828134187428,0.256176570936103,-0.522294532087751,
  -3.93326738357125e-06,-0.00246435895553621,0.264242888417686,-0.547104449036796,
  -3.94900733724501e-06,-0.00234043656919769,0.272309205899268,-0.571914365985841,
  -3.96474729069674e-06,-0.00221651418285829,0.280375523380851,-0.596724282934887,
  -3.98048724448152e-06,-0.00209259179651955,0.288441840862434,-0.621534199883932,
  -3.99622719804427e-06,-0.00196866941018081,0.296508158344017,-0.646344116832977,
  -4.01196715260621e-06,-0.00184474702384341,0.304574475825599,-0.671154033782022,
  -4.027707106391e-06,-0.00172082463750467,0.312640793307182,-0.695963950731067,
  -4.04344706017579e-06,-0.00159690225116593,0.320707110788765,-0.720773867680112,
  -4.05918701362751e-06,-0.0014729798648272,0.328773428270347,-0.745583784629157,
  -4.07492696719025e-06,-0.0013490574784889,0.33683974575193,-0.770393701578202,
  -4.09066692119708e-06,-0.00122513509214972,0.344906063233513,-0.795203618527247,
  -2.67029393397067e-06,-0.00412952777607445,0.15086676848874,-0.200115249996913,
  -2.67982151025414e-06,-0.00401485189495598,0.15886235524972,-0.224967637402412,
  -2.68934908675966e-06,-0.00390017601383774,0.166857942010699,-0.249820024807911,
  -2.69887666343172e-06,-0.00378550013271939,0.174853528771679,-0.27467241221341,
  -2.70840423982621e-06,-0.00367082425160126,0.182849115532658,-0.29952479961891,
  -2.71793181605418e-06,-0.00355614837048268,0.190844702293637,-0.324377187024409,
  -2.72745939278174e-06,-0.00344147248936499,0.198840289054616,-0.349229574429908,
  -2.73698696934277e-06,-0.00332679660824642,0.206835875815596,-0.374081961835407,
  -2.7465145454042e-06,-0.00321212072712784,0.214831462576575,-0.398934349240907,
  -2.75604212196523e-06,-0.00309744484600971,0.222827049337555,-0.423786736646406,
  -2.7655696982487e-06,-0.00298276896489114,0.230822636098534,-0.448639124051905,
  -2.77509727475422e-06,-0.00286809308377278,0.238818222859513,-0.473491511457404,
  -2.78462485137076e-06,-0.00275341720265465,0.246813809620493,-0.498343898862904,
  -2.79415242787628e-06,-0.00263874132153652,0.254809396381472,-0.523196286268403,
  -2.80368000449283e-06,-0.00252406544041861,0.262804983142451,-0.548048673673902,
  -2.81320758044323e-06,-0.00240938955929937,0.270800569903431,-0.572901061079401,
  -2.82273515750386e-06,-0.00229471367818213,0.27879615666441,-0.597753448484901,
  -2.83226273323223e-06,-0.00218003779706288,0.286791743425389,-0.6226058358904,
  -2.84179031018184e-06,-0.0020653619159452,0.294787330186369,-0.647458223295899,
  -2.8513178869094e-06,-0.00195068603482706,0.302782916947348,-0.672310610701398,
  -2.86084546297083e-06,-0.00183601015370805,0.310778503708328,-0.697162998106898,
  -2.8703730392543e-06,-0.00172133427258991,0.318774090469307,-0.722015385512397,
  -2.87990061598187e-06,-0.00160665839147223,0.326769677230286,-0.746867772917896,
  -2.88942819237636e-06,-0.00149198251035365,0.334765263991265,-0.771720160323396,
  -2.89895576865984e-06,-0.00137730662923508,0.342760850752245,-0.796572547728895,
  -1.91711875047185e-06,-0.00407961391361322,0.150542919746702,-0.200367605278461,
  -1.92302373297482e-06,-0.00397166725137255,0.158487366641278,-0.225250646206839,
  -1.92892871531125e-06,-0.0038637205891312,0.166431813535854,-0.250133687135217,
  -1.93483369753666e-06,-0.00375577392688964,0.174376260430431,-0.275016728063596,
  -1.94073867998412e-06,-0.00364782726464852,0.182320707325007,-0.299899768991974,
  -1.94664366243158e-06,-0.00353988060240762,0.190265154219583,-0.324782809920352,
  -1.95254864476802e-06,-0.0034319339401665,0.19820960111416,-0.34966585084873,
  -1.95845362699343e-06,-0.00332398727792493,0.206154048008736,-0.374548891777109,
  -1.96435860927435e-06,-0.00321604061568381,0.214098494903312,-0.399431932705487,
  -1.97026359172181e-06,-0.00310809395344269,0.222042941797889,-0.424314973633865,
  -1.97616857389171e-06,-0.00300014729120113,0.229987388692465,-0.449198014562243,
  -1.98207355639468e-06,-0.00289220062896045,0.237931835587041,-0.474081055490621,
  -1.98797853867561e-06,-0.00278425396671889,0.245876282481618,-0.498964096418999,
  -1.99388352073449e-06,-0.00267630730447754,0.253820729376194,-0.523847137347378,
  -1.99978850323745e-06,-0.0025683606422362,0.261765176270771,-0.548730178275756,
  -2.00569348585145e-06,-0.00246041397999552,0.269709623165347,-0.573613219204134,
  -2.01159846802135e-06,-0.00235246731775418,0.277654070059923,-0.598496260132512,
  -2.01750345041329e-06,-0.00224452065551306,0.2855985169545,-0.62337930106089,
  -2.02340843291626e-06,-0.00213657399327172,0.293542963849076,-0.648262341989269,
  -2.02931341519719e-06,-0.00202862733103037,0.301487410743653,-0.673145382917647,
  -2.03521839703402e-06,-0.00192068066878903,0.309431857638229,-0.698028423846025,
  -2.0411233800921e-06,-0.00181273400654902,0.317376304532805,-0.722911464774403,
  -2.04702836203996e-06,-0.00170478734430679,0.325320751427382,-0.747794505702781,
  -2.05293334465395e-06,-0.00159684068206589,0.333265198321958,-0.772677546631159,
  -2.05883832649079e-06,-0.00148889401982411,0.341209645216535,-0.797560587559538,
  -1.37465923455427e-06,-0.00404390747655059,0.150309438262744,-0.200549246064803,
  -1.37840823793978e-06,-0.003940833169086,0.158217029323549,-0.225454350846831,
  -1.38215724149182e-06,-0.00383775886162163,0.166124620384354,-0.250359455628859,
  -1.38590624476631e-06,-0.00373468455415704,0.174032211445159,-0.275264560410887,
  -1.38965524848489e-06,-0.0036316102466929,0.181939802505964,-0.300169665192915,
  -1.39340425220347e-06,-0.00352853593922875,0.189847393566769,-0.325074769974944,
  -1.3971532557e-06,-0.00342546163176438,0.197754984627574,-0.349979874756972,
  -1.40090225941858e-06,-0.00332238732430024,0.205662575688379,-0.374884979539,
  -1.40465126247102e-06,-0.00321931301683542,0.213570166749184,-0.399790084321028,
  -1.4084002661896e-06,-0.00311623870937128,0.221477757809989,-0.424695189103056,
  -1.41214927007471e-06,-0.00301316440190735,0.229385348870794,-0.449600293885084,
  -1.41589827351574e-06,-0.00291009009444299,0.237292939931598,-0.474505398667112,
  -1.41964727695676e-06,-0.0028070157869784,0.245200530992403,-0.499410503449141,
  -1.42339628061983e-06,-0.00270394147951425,0.253108122053208,-0.524315608231169,
  -1.42714528428289e-06,-0.0026008671720501,0.261015713114013,-0.549220713013197,
  -1.43089428783494e-06,-0.00249779286458574,0.268923304174818,-0.574125817795225,
  -1.43464329105392e-06,-0.0023947185571207,0.276830895235624,-0.599030922577253,
  -1.43839229493903e-06,-0.00229164424965722,0.284738486296428,-0.623936027359281,
  -1.44214129815801e-06,-0.00218856994219285,0.292646077357233,-0.648841132141309,
  -1.44589030171005e-06,-0.00208549563472804,0.300553668418038,-0.673746236923337,
  -1.44963930581721e-06,-0.00198242132726456,0.308461259478843,-0.698651341705366,
  -1.45338830892516e-06,-0.00187934701979975,0.316368850539648,-0.723556446487394,
  -1.4571373129213e-06,-0.00177627271233627,0.324276441600452,-0.748461551269422,
  -1.46088631669539e-06,-0.00167319840487146,0.332184032661258,-0.77336665605145,
  -1.46463531969232e-06,-0.00157012409740709,0.340091623722063,-0.798271760833478,
  -0.000181201626823391,-0.0313793041347652,0.224181556802017,-0.136858951696573,
  -0.000194964032887435,-0.031112869119811,0.243017255725212,-0.153104187665781,
  -0.00020872643895159,-0.030846434104857,0.261852954648408,-0.169349423634989,
  -0.000222488845015745,-0.0305799990899031,0.280688653571603,-0.185594659604197,
  -0.0002362512510799,-0.030313564074949,0.299524352494798,-0.201839895573404,
  -0.000250013657144055,-0.0300471290599948,0.318360051417994,-0.218085131542612,
  -0.000263776063208598,-0.0297806940450411,0.337195750341189,-0.23433036751182,
  -0.000277538469272531,-0.029514259030087,0.356031449264384,-0.250575603481028,
  -0.000291300875336686,-0.029247824015133,0.374867148187579,-0.266820839450235,
  -0.000305063281400786,-0.0289813890001784,0.393702847110775,-0.283066075419443,
  -0.000318825687464996,-0.0287149539852243,0.41253854603397,-0.29931131138865,
  -0.000332588093529096,-0.0284485189702708,0.431374244957165,-0.315556547357858,
  -0.00034635049959364,-0.0281820839553166,0.450209943880361,-0.331801783327066,
  -0.00036011290565785,-0.0279156489403627,0.469045642803556,-0.348047019296274,
  -0.000373875311721616,-0.0276492139254083,0.487881341726751,-0.364292255265481,
  -0.000387637717786271,-0.027382778910455,0.506717040649946,-0.380537491234689,
  -0.000401400123849927,-0.0271163438955002,0.525552739573142,-0.396782727203897,
  -0.000415162529914359,-0.0268499088805465,0.544388438496337,-0.413027963173104,
  -0.000428924935978126,-0.0265834738655919,0.563224137419533,-0.429273199142312,
  -0.000442687342042336,-0.026317038850638,0.582059836342728,-0.44551843511152,
  -0.000456449748106991,-0.0260506038356842,0.600895535265924,-0.461763671080728,
  -0.000470212154170868,-0.0257841688207301,0.619731234189118,-0.478008907049935,
  -0.000483974560234968,-0.0255177338057759,0.638566933112314,-0.494254143019143,
  -0.0004977369662994,-0.0252512987908222,0.657402632035509,-0.510499378988351,
  -0.000511499372363722,-0.0249848637758681,0.676238330958705,-0.526744614957558,
  -0.000178508613633555,-0.0306316557916103,0.223336230760757,-0.138208101102135,
  -0.000191916250282753,-0.0303387950758676,0.242015347908285,-0.154608440860078,
  -0.000205323886931452,-0.0300459343601241,0.260694465055813,-0.171008780618022,
  -0.000218731523580595,-0.0297530736443813,0.279373582203341,-0.187409120375965,
  -0.000232139160229516,-0.0294602129286381,0.298052699350868,-0.203809460133909,
  -0.000245546796878326,-0.029167352212895,0.316731816498396,-0.220209799891852,
  -0.000258954433527248,-0.0288744914971517,0.335410933645924,-0.236610139649796,
  -0.000272362070176391,-0.0285816307814089,0.354090050793452,-0.253010479407739,
  -0.00028576970682509,-0.0282887700656653,0.37276916794098,-0.269410819165682,
  -0.000299177343474288,-0.0279959093499227,0.391448285088507,-0.285811158923626,
  -0.000312584980123209,-0.0277030486341792,0.410127402236035,-0.302211498681569,
  -0.000325992616772464,-0.0274101879184367,0.428806519383563,-0.318611838439513,
  -0.000339400253421052,-0.0271173272026932,0.447485636531091,-0.335012178197456,
  -0.000352807890069973,-0.0268244664869499,0.466164753678619,-0.3514125179554,
  -0.000366215526718894,-0.0265316057712066,0.484843870826147,-0.367812857713343,
  -0.000379623163367926,-0.0262387450554642,0.503522987973674,-0.384213197471287,
  -0.000393030800017069,-0.0259458843397209,0.522202105121202,-0.40061353722923,
  -0.00040643843666599,-0.025653023623978,0.540881222268729,-0.417013876987174,
  -0.000419846073314911,-0.025360162908235,0.559560339416257,-0.433414216745117,
  -0.000433253709963721,-0.0250673021924912,0.578239456563785,-0.449814556503061,
  -0.000446661346612531,-0.0247744414767479,0.596918573711313,-0.466214896261004,
  -0.000460068983261896,-0.0244815807610053,0.615597690858841,-0.482615236018947,
  -0.000473476619910262,-0.0241887200452622,0.634276808006368,-0.499015575776891,
  -0.000486884256560072,-0.0238958593295195,0.652955925153896,-0.515415915534835,
  -0.000500291893208882,-0.0236029986137765,0.671635042301424,-0.531816255292778,
  -0.000174860756161854,-0.0296443738569953,0.222178602899426,-0.140013454245716,
  -0.000187794628576432,-0.0293178478489339,0.240645149278726,-0.156621344858606,
  -0.000200728500990788,-0.0289913218408724,0.259111695658025,-0.173229235471497,
  -0.000213662373405477,-0.0286647958328111,0.277578242037325,-0.189837126084387,
  -0.000226596245819721,-0.0283382698247495,0.296044788416624,-0.206445016697278,
  -0.000239530118234355,-0.0280117438166885,0.314511334795923,-0.223052907310168,
  -0.000252463990649043,-0.0276852178086273,0.332977881175223,-0.239660797923059,
  -0.000265397863063677,-0.0273586918005659,0.351444427554522,-0.256268688535949,
  -0.000278331735477699,-0.0270321657925039,0.369910973933822,-0.272876579148839,
  -0.00029126560789261,-0.026705639784443,0.388377520313121,-0.28948446976173,
  -0.000304199480307021,-0.0263791137763816,0.406844066692421,-0.306092360374621,
  -0.000317133352721433,-0.02605258776832,0.425310613071721,-0.322700250987511,
  -0.000330067225136066,-0.0257260617602588,0.44377715945102,-0.339308141600401,
  -0.000343001097550477,-0.0253995357521974,0.462243705830319,-0.355916032213292,
  -0.000355934969965555,-0.0250730097441367,0.480710252209618,-0.372523922826182,
  -0.000368868842379744,-0.0247464837360749,0.499176798588918,-0.389131813439073,
  -0.000381802714794155,-0.0244199577280133,0.517643344968218,-0.405739704051963,
  -0.00039473658720901,-0.0240934317199522,0.536109891347517,-0.422347594664854,
  -0.000407670459623422,-0.023766905711891,0.554576437726816,-0.438955485277744,
  -0.000420604332037944,-0.0234403797038298,0.573042984106116,-0.455563375890635,
  -0.000433538204452133,-0.0231138536957678,0.591509530485416,-0.472171266503525,
  -0.000446472076866433,-0.022787327687706,0.609976076864715,-0.488779157116416,
  -0.0004594059492814,-0.022460801679645,0.628442623244015,-0.505387047729306,
  -0.000472339821695922,-0.0221342756715841,0.646909169623314,-0.521994938342197,
  -0.000485273694110555,-0.0218077496635227,0.665375716002613,-0.538602828955087,
  -0.00016998050449446,-0.0283674951077179,0.220608085680564,-0.142390670383804,
  -0.000182292630499015,-0.0279996121384419,0.238789416158635,-0.159271855583745,
  -0.000194604756503736,-0.0276317291691663,0.256970746636706,-0.176153040783685,
  -0.000206916882508346,-0.0272638461998902,0.275152077114777,-0.193034225983625,
  -0.000219229008512956,-0.0268959632306144,0.293333407592848,-0.209915411183566,
  -0.000231541134517677,-0.0265280802613386,0.311514738070919,-0.226796596383506,
  -0.000243853260522064,-0.0261601972920624,0.32969606854899,-0.243677781583446,
  -0.000256165386526952,-0.0257923143227867,0.347877399027061,-0.260558966783387,
  -0.000268477512531506,-0.0254244313535108,0.366058729505132,-0.277440151983327,
  -0.000280789638536394,-0.0250565483842353,0.384240059983203,-0.294321337183267,
  -0.000293101764541004,-0.0246886654149594,0.402421390461274,-0.311202522383208,
  -0.000305413890545725,-0.0243207824456837,0.420602720939345,-0.328083707583148,
  -0.000317726016550224,-0.0239528994764078,0.438784051417416,-0.344964892783088,
  -0.000330038142554612,-0.0235850165071316,0.456965381895487,-0.361846077983029,
  -0.000342350268559333,-0.0232171335378559,0.475146712373557,-0.378727263182969,
  -0.000354662394563943,-0.02284925056858,0.493328042851629,-0.395608448382909,
  -0.000366974520568997,-0.022481367599305,0.511509373329699,-0.41248963358285,
  -0.000379286646573385,-0.0221134846300288,0.52969070380777,-0.42937081878279,
  -0.000391598772577995,-0.0217456016607529,0.547872034285841,-0.44625200398273,
  -0.000403910898582716,-0.021377718691477,0.566053364763912,-0.463133189182671,
  -0.000416223024587326,-0.0210098357222011,0.584234695241983,-0.480014374382611,
  -0.000428535150591602,-0.0206419527529245,0.602416025720055,-0.496895559582551,
  -0.000440847276595879,-0.0202740697836483,0.620597356198125,-0.513776744782491,
  -0.000453159402601044,-0.0199061868143735,0.638778686676196,-0.530657929982432,
  -0.000465471528605543,-0.0195383038450974,0.656960017154267,-0.547539115182373,
  -0.000163560643764105,-0.026760430442765,0.218505891058895,-0.145455363009714,
  -0.000175075641198785,-0.026344239466899,0.236310613971572,-0.162688877933575,
  -0.00018659063863341,-0.0259280484910333,0.254115336884249,-0.179922392857436,
  -0.00019810563606798,-0.0255118575151669,0.271920059796926,-0.197155907781297,
  -0.00020962063350255,-0.025095666539301,0.289724782709604,-0.214389422705158,
  -0.000221135630937397,-0.0246794755634354,0.30752950562228,-0.231622937629019,
  -0.000232650628371578,-0.024263284587569,0.325334228534958,-0.248856452552881,
  -0.000244165625806148,-0.0238470936117028,0.343138951447635,-0.266089967476742,
  -0.000255680623240828,-0.023430902635837,0.360943674360312,-0.283323482400603,
  -0.000267195620675342,-0.0230147116599706,0.37874839727299,-0.300556997324464,
  -0.000278710618110023,-0.0225985206841048,0.396553120185666,-0.317790512248325,
  -0.000290225615544482,-0.0221823297082386,0.414357843098344,-0.335024027172186,
  -0.000301740612979273,-0.0217661387323729,0.432162566011021,-0.352257542096047,
  -0.000313255610413621,-0.0213499477565064,0.449967288923698,-0.369491057019908,
  -0.00032477060784819,-0.0209337567806405,0.467772011836375,-0.386724571943769,
  -0.000336285605282982,-0.0205175658047749,0.485576734749052,-0.40395808686763,
  -0.000347800602717663,-0.0201013748289094,0.503381457661729,-0.421191601791491,
  -0.000359315600152232,-0.019685183853043,0.521186180574406,-0.438425116715352,
  -0.00037083059758658,-0.0192689928771768,0.538990903487083,-0.455658631639213,
  -0.000382345595021372,-0.0188528019013103,0.556795626399761,-0.472892146563074,
  -0.000393860592456052,-0.0184366109254448,0.574600349312438,-0.490125661486936,
  -0.000405375589889956,-0.0180204199495781,0.592405072225115,-0.507359176410797,
  -0.000416890587324747,-0.0176042289737124,0.610209795137792,-0.524592691334657,
  -0.000428405584759317,-0.0171880379978462,0.62801451805047,-0.541826206258519,
  -0.000439920582194331,-0.0167718470219809,0.645819240963146,-0.55905972118238,
  -0.000155303464255907,-0.0248069936288694,0.215745010319136,-0.149300356239133,
  -0.000165827440043398,-0.0243382219842224,0.233063045746992,-0.166975907467563,
  -0.000176351415830944,-0.0238694503395758,0.250381081174847,-0.184651458695993,
  -0.000186875391618713,-0.0234006786949291,0.267699116602703,-0.202327009924424,
  -0.000197399367406148,-0.0229319070502826,0.285017152030558,-0.220002561152854,
  -0.000207923343193583,-0.0224631354056357,0.302335187458413,-0.237678112381285,
  -0.000218447318981296,-0.021994363760989,0.319653222886269,-0.255353663609715,
  -0.000228971294768954,-0.0215255921163426,0.336971258314124,-0.273029214838146,
  -0.000239495270556667,-0.0210568204716959,0.35428929374198,-0.290704766066576,
  -0.000250019246343824,-0.0205880488270487,0.371607329169835,-0.308380317295006,
  -0.000260543222131537,-0.0201192771824024,0.38892536459769,-0.326055868523437,
  -0.000271067197919028,-0.0196505055377556,0.406243400025546,-0.343731419751867,
  -0.00028159117370663,-0.0191817338931091,0.423561435453401,-0.361406970980298,
  -0.000292115149494343,-0.0187129622484625,0.440879470881257,-0.379082522208728,
  -0.000302639125281945,-0.018244190603816,0.458197506309112,-0.396758073437158,
  -0.000313163101069325,-0.017775418959169,0.475515541736967,-0.414433624665589,
  -0.00032368707685726,-0.0173066473145227,0.492833577164823,-0.432109175894019,
  -0.000334211052644418,-0.0168378756698753,0.510151612592678,-0.44978472712245,
  -0.000344735028431797,-0.0163691040252287,0.527469648020533,-0.46746027835088,
  -0.000355259004219399,-0.0159003323805817,0.544787683448389,-0.485135829579311,
  -0.000365782980007445,-0.0154315607359363,0.562105718876244,-0.502811380807741,
  -0.000376306955794714,-0.0149627890912889,0.5794237543041,-0.520486932036171,
  -0.000386830931582427,-0.0144940174466424,0.596741789731955,-0.538162483264601,
  -0.000397354907369474,-0.0140252458019949,0.614059825159811,-0.555838034493032,
  -0.000407878883157298,-0.0135564741573484,0.631377860587666,-0.573513585721463,
  -0.000144990681892998,-0.022532879574928,0.212212649733898,-0.153963066158947,
  -0.000154330511624501,-0.0220124161465299,0.228919303189943,-0.172174661780502,
  -0.000163670341356059,-0.0214919527181319,0.245625956645989,-0.190386257402058,
  -0.000173010171087895,-0.0209714892897342,0.262332610102034,-0.208597853023613,
  -0.000182350000819287,-0.0204510258613363,0.279039263558079,-0.226809448645169,
  -0.000191689830550901,-0.0199305624329382,0.295745917014124,-0.245021044266724,
  -0.00020102966028257,-0.0194100990045405,0.31245257047017,-0.26323263988828,
  -0.000210369490014406,-0.0188896355761425,0.329159223926215,-0.281444235509835,
  -0.000219709319745798,-0.0183691721477446,0.34586587738226,-0.299655831131391,
  -0.000229049149477745,-0.0178487087193469,0.362572530838305,-0.317867426752946,
  -0.00023838897920947,-0.0173282452909491,0.379279184294351,-0.336079022374502,
  -0.000247728808940972,-0.0168077818625512,0.395985837750396,-0.354290617996057,
  -0.000257068638672475,-0.0162873184341532,0.412692491206441,-0.372502213617613,
  -0.000266408468403867,-0.0157668550057548,0.429399144662487,-0.390713809239169,
  -0.000275748298135703,-0.0152463915773573,0.446105798118532,-0.408925404860724,
  -0.000285088127867317,-0.0147259281489593,0.462812451574577,-0.427137000482279,
  -0.000294427957598931,-0.0142054647205616,0.479519105030622,-0.445348596103835,
  -0.000303767787330766,-0.0136850012921639,0.496225758486667,-0.463560191725391,
  -0.00031310761706238,-0.0131645378637661,0.512932411942712,-0.481771787346946,
  -0.000322447446793994,-0.012644074435368,0.529639065398758,-0.499983382968502,
  -0.000331787276525164,-0.0121236110069698,0.546345718854803,-0.518194978590057,
  -0.000341127106256889,-0.0116031475785721,0.563052372310848,-0.536406574211612,
  -0.000350466935988725,-0.0110826841501743,0.579759025766893,-0.554618169833168,
  -0.000359806765720672,-0.0105622207217766,0.596465679222939,-0.572829765454724,
  -0.000369146595452174,-0.0100417572933784,0.613172332678984,-0.591041361076279,
  -0.00013258055994525,-0.020018509793014,0.20784707051382,-0.159389803808523,
  -0.000140574176482944,-0.0194546836470862,0.223812913552605,-0.178225279607066,
  -0.00014856779302036,-0.0188908575011577,0.239778756591391,-0.197060755405609,
  -0.000156561409557943,-0.0183270313552296,0.255744599630176,-0.215896231204152,
  -0.000164555026095636,-0.0177632052093015,0.271710442668962,-0.234731707002696,
  -0.000172548642633163,-0.0171993790633733,0.287676285707748,-0.253567182801239,
  -0.000180542259170413,-0.0166355529174447,0.303642128746534,-0.272402658599782,
  -0.00018853587570844,-0.0160717267715171,0.319607971785319,-0.291238134398325,
  -0.000196529492245856,-0.0155079006255887,0.335573814824105,-0.310073610196868,
  -0.000204523108783827,-0.0149440744796612,0.35153965786289,-0.328909085995412,
  -0.000212516725320744,-0.0143802483337321,0.367505500901676,-0.347744561793955,
  -0.00022051034185866,-0.0138164221878043,0.383471343940462,-0.366580037592498,
  -0.000228503958396353,-0.0132525960418759,0.399437186979248,-0.385415513391041,
  -0.000236497574933825,-0.0126887698959479,0.415403030018034,-0.404250989189584,
  -0.000244491191471297,-0.0121249437500197,0.431368873056819,-0.423086464988127,
  -0.000252484808008546,-0.0115611176040911,0.447334716095605,-0.44192194078667,
  -0.000260478424546906,-0.0109972914581642,0.46330055913439,-0.460757416585214,
  -0.000268472041083934,-0.0104334653122353,0.479266402173176,-0.479592892383757,
  -0.000276465657621405,-0.00986963916630645,0.495232245211962,-0.4984283681823,
  -0.000284459274158988,-0.00930581302037803,0.511198088250748,-0.517263843980843,
  -0.000292452890696904,-0.00874198687445071,0.527163931289533,-0.536099319779386,
  -0.000300446507234264,-0.00817816072852251,0.543129774328319,-0.554934795577929,
  -0.000308440123772069,-0.00761433458259431,0.559095617367105,-0.573770271376472,
  -0.000316433740308875,-0.00705050843666521,0.575061460405891,-0.592605747175016,
  -0.000324427356847345,-0.00648668229073834,0.591027303444676,-0.611441222973559,
  -0.000118305920004058,-0.0173972325122059,0.202682264387483,-0.165411819387931,
  -0.000124858604172773,-0.0168066339551569,0.217789206015731,-0.184939610973252,
  -0.00013141128834121,-0.0162160353981077,0.232896147643979,-0.204467402558573,
  -0.000137963972509647,-0.0156254368410583,0.248003089272226,-0.223995194143894,
  -0.000144516656678251,-0.0150348382840091,0.263110030900474,-0.243522985729215,
  -0.000151069340846799,-0.0144442397269602,0.278216972528722,-0.263050777314536,
  -0.000157622025015458,-0.0138536411699113,0.293323914156969,-0.282578568899857,
  -0.000164174709183951,-0.0132630426128617,0.308430855785217,-0.302106360485178,
  -0.00017072739335261,-0.0126724440558126,0.323537797413465,-0.321634152070499,
  -0.000177280077521158,-0.0120818454987637,0.338644739041713,-0.34116194365582,
  -0.000183832761689873,-0.0114912469417148,0.35375168066996,-0.360689735241141,
  -0.000190385445858254,-0.0109006483846652,0.368858622298208,-0.380217526826462,
  -0.000196938130026636,-0.0103100498276161,0.383965563926456,-0.399745318411784,
  -0.00020349081419524,-0.00971945127056695,0.399072505554704,-0.419273109997105,
  -0.000210043498363843,-0.00912885271351782,0.414179447182951,-0.438800901582426,
  -0.000216596182532669,-0.00853825415646892,0.429286388811199,-0.458328693167747,
  -0.000223148866701162,-0.00794765559941979,0.444393330439447,-0.477856484753068,
  -0.000229701550869876,-0.00735705704237066,0.459500272067695,-0.497384276338389,
  -0.000236254235038147,-0.00676645848532109,0.474607213695942,-0.51691206792371,
  -0.000242806919206418,-0.00617585992827152,0.48971415532419,-0.536439859509031,
  -0.000249359603375243,-0.00558526137122239,0.504821096952438,-0.555967651094352,
  -0.000255912287543847,-0.00499466281417371,0.519928038580686,-0.575495442679673,
  -0.000262464971712006,-0.00440406425712414,0.535034980208933,-0.595023234264994,
  -0.000269017655880943,-0.0038134657000759,0.550141921837181,-0.614551025850316,
  -0.000275570340049325,-0.00322286714302589,0.565248863465429,-0.634078817435636,
  -0.000102721984339249,-0.0148324973710203,0.196881300534295,-0.171751042899428,
  -0.00010783666674502,-0.0142382113384385,0.211042239576902,-0.192007617805724,
  -0.000112951349151125,-0.0136439253058569,0.225203178619509,-0.21226419271202,
  -0.000118066031557229,-0.0130496392732753,0.239364117662116,-0.232520767618316,
  -0.000123180713963111,-0.0124553532406937,0.253525056704723,-0.252777342524612,
  -0.000128295396369438,-0.0118610672081121,0.26768599574733,-0.273033917430908,
  -0.000133410078774987,-0.0112667811755298,0.281846934789937,-0.293290492337204,
  -0.000138524761181258,-0.0106724951429484,0.296007873832544,-0.3135470672435,
  -0.000143639443587362,-0.0100782091103671,0.310168812875151,-0.333803642149796,
  -0.000148754125993356,-0.00948392307778523,0.324329751917758,-0.354060217056092,
  -0.00015386880839896,-0.00888963704520