/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassCorrector
implements Transformer {
    protected ClassHierarchy classHierarchy = null;
    private Log log;
    private static Logger logger = Logger.getLogger((class$com$sun$tdk$signaturetest$core$ClassCorrector == null ? (class$com$sun$tdk$signaturetest$core$ClassCorrector = ClassCorrector.class$("com.sun.tdk.signaturetest.core.ClassCorrector")) : class$com$sun$tdk$signaturetest$core$ClassCorrector).getName());
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$core$ClassCorrector == null ? (class$com$sun$tdk$signaturetest$core$ClassCorrector = ClassCorrector.class$("com.sun.tdk.signaturetest.core.ClassCorrector")) : class$com$sun$tdk$signaturetest$core$ClassCorrector);
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$core$ClassCorrector;

    public ClassCorrector(Log log) {
        this.log = log;
        if (logger.getLevel() == null) {
            logger.setLevel(Level.OFF);
        }
    }

    public ClassDescription transform(ClassDescription cl) throws ClassNotFoundException {
        this.classHierarchy = cl.getClassHierarchy();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(">>>> ClassCorrector for class " + cl.getQualifiedName());
        }
        this.replaceInvisibleExceptions(cl);
        this.replaceInvisibleInMembers(cl);
        this.fixMethods(cl);
        this.removeInvisibleInterfaces(cl);
        this.fixInvisibleSuperclasses(cl);
        this.removeDuplicatedConstants(cl);
        this.checkClassTypeParameters(cl);
        this.removeInvisibleAnnotations(cl);
        this.additionalChecks(cl);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("<<<< ClassCorrector for class " + cl.getQualifiedName());
        }
        return cl;
    }

    private void additionalChecks(ClassDescription cl) throws ClassNotFoundException {
        if (this.classHierarchy.isClassVisibleOutside(cl)) {
            if (!cl.hasModifier(Modifier.ABSTRACT)) {
                return;
            }
            boolean ctorExists = false;
            ConstructorDescr[] ctors = cl.getDeclaredConstructors();
            int i = 0;
            while (i < ctors.length) {
                ConstructorDescr c = ctors[i];
                if (c.hasModifier(Modifier.PUBLIC) || c.hasModifier(Modifier.PROTECTED)) {
                    ctorExists = true;
                    break;
                }
                ++i;
            }
            if (!ctorExists) {
                return;
            }
            MethodDescr[] methods = cl.getDeclaredMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                MethodDescr mr = methods[i2];
                if (mr.isMethod() && !mr.hasModifier(Modifier.PUBLIC) && !mr.hasModifier(Modifier.PROTECTED) && mr.hasModifier(Modifier.ABSTRACT)) {
                    Object[] invargs = new String[]{cl.getQualifiedName(), mr.toString()};
                    this.log.storeWarning(i18n.getString("ClassCorrector.error.class.useless_abst_public_class", invargs), null);
                }
                ++i2;
            }
        }
    }

    private void replaceInvisibleExceptions(ClassDescription c) throws ClassNotFoundException {
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isMethod() && !mr.isConstructor()) continue;
            this.replaceInvisibleExceptions(mr);
        }
    }

    private void replaceInvisibleExceptions(MemberDescription mr) throws ClassNotFoundException {
        String throwables = mr.getThrowables();
        if (!"".equals(throwables)) {
            int pos;
            boolean mustCorrect = false;
            StringBuffer sb = new StringBuffer();
            int startPos = 0;
            do {
                String exceptionName;
                if (sb.length() != 0) {
                    sb.append(",");
                }
                if ((pos = throwables.indexOf(",", startPos)) != -1) {
                    exceptionName = throwables.substring(startPos, pos);
                    startPos = pos + 1;
                } else {
                    exceptionName = throwables.substring(startPos);
                }
                if (this.isInvisibleClass(exceptionName)) {
                    List supers = this.classHierarchy.getSuperClasses(exceptionName);
                    exceptionName = this.findVisibleReplacement(exceptionName, supers, "java.lang.Throwable", true);
                    mustCorrect = true;
                }
                sb.append(exceptionName);
            } while (pos != -1);
            if (mustCorrect) {
                Object[] invargs = new String[]{mr.getQualifiedName(), throwables, sb.toString()};
                this.log.storeWarning(i18n.getString("ClassCorrector.message.throwslist.changed", invargs), null);
                mr.setThrowables(sb.toString());
            }
        }
    }

    private String findVisibleReplacementAndCheckInterfaces(String clName, List supers, String replaceWithClassName) throws ClassNotFoundException {
        if (this.isPublicInner(clName)) {
            return null;
        }
        String replacement = this.findVisibleReplacement(clName, supers, replaceWithClassName, true);
        Set oldInt = this.classHierarchy.getAllImplementedInterfaces(clName);
        if (oldInt.size() != 0) {
            Set newInt = this.classHierarchy.getAllImplementedInterfaces(replacement);
            oldInt.removeAll(newInt);
            this.removeSuperInterfaces(oldInt);
            int visibleInterfaces = 0;
            String iName = null;
            Iterator it = oldInt.iterator();
            while (it.hasNext()) {
                String nextInt = (String)it.next();
                if (this.isInvisibleClass(nextInt)) continue;
                ++visibleInterfaces;
                iName = nextInt;
            }
            if ("java.lang.Object".equals(replacement) && visibleInterfaces == 1) {
                return iName;
            }
            if (visibleInterfaces > 0) {
                return null;
            }
        }
        return replacement;
    }

    private String findVisibleReplacement(String clName, List supers, String replaceWithClassName, boolean findToSuper) {
        block7: {
            if (supers.size() <= 0) break block7;
            if (!findToSuper) {
                int i = supers.indexOf(clName);
                if (i <= 0) {
                    return replaceWithClassName;
                }
                int pos = i - 1;
                while (pos >= 0) {
                    String name = (String)supers.get(pos);
                    if (!this.isInvisibleClass(name)) {
                        return name;
                    }
                    --pos;
                }
            } else {
                int pos = 0;
                while (pos < supers.size()) {
                    String name = (String)supers.get(pos);
                    if (!this.isInvisibleClass(name)) {
                        return name;
                    }
                    ++pos;
                }
            }
        }
        return replaceWithClassName;
    }

    private void fixMethods(ClassDescription cl) throws ClassNotFoundException {
        Iterator e = cl.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (mr.isMethod() || mr.isField()) {
                this.fixType(cl, mr);
            }
            if (!mr.isConstructor() && !mr.isMethod()) continue;
            this.checkMethodParameters(cl, mr);
        }
    }

    private void fixType(ClassDescription cl, MemberDescription mr) throws ClassNotFoundException {
        String returnType = mr.getType();
        if (!"".equals(returnType) && this.isInvisibleClass(returnType)) {
            String newName;
            returnType = ClassCorrector.stripArrays(returnType);
            List supers = Collections.EMPTY_LIST;
            if (!this.classHierarchy.isInterface(returnType)) {
                supers = this.classHierarchy.getSuperClasses(returnType);
            }
            if ((newName = this.findVisibleReplacementAndCheckInterfaces(returnType, supers, "java.lang.Object")) != null) {
                newName = ClassCorrector.wrapArray(returnType, newName);
                mr.setType(newName);
                if (!mr.isField()) {
                    Object[] invargs = new String[]{cl.getName(), mr.getName(), returnType, newName};
                    this.log.storeWarning(i18n.getString("ClassCorrector.message.returntype.changed", invargs), logger);
                } else {
                    Object[] invargs = new String[]{cl.getName(), mr.getName(), returnType, newName};
                    this.log.storeWarning(i18n.getString("ClassCorrector.message.fieldtype.changed", invargs), logger);
                }
            } else if (!mr.isField()) {
                Object[] invargs = new String[]{returnType, mr.toString()};
                this.log.storeError(i18n.getString("ClassCorrector.error.returntype.hidden", invargs), logger);
            } else {
                Object[] invargs = new String[]{returnType, mr.toString()};
                this.log.storeError(i18n.getString("ClassCorrector.error.fieldtype.hidden", invargs), logger);
            }
        }
        this.checkType(cl, mr);
    }

    private void checkMethodParameters(ClassDescription cl, MemberDescription mr) {
        String args = mr.getArgs();
        if ("".equals(args)) {
            return;
        }
        this.checkActualParameters(cl, mr, args);
    }

    private void checkType(ClassDescription cl, MemberDescription mr) {
        String type = mr.getType();
        int pos = type.indexOf(60);
        if (pos != -1) {
            this.checkActualParameters(cl, mr, type.substring(pos));
        }
    }

    private void checkActualParameters(ClassDescription cl, MemberDescription mr, String actualParameters) {
        StringTokenizer tz = new StringTokenizer(actualParameters, ",<>[]&", false);
        boolean firstParameter = true;
        while (tz.hasMoreTokens()) {
            boolean isInner;
            String param = tz.nextToken().trim();
            if (param.length() <= 0) continue;
            String prefix = "? super ";
            if (param.indexOf(prefix) == 0) {
                param = param.substring(prefix.length());
            }
            if (param.indexOf(prefix = "? extends ") == 0) {
                param = param.substring(prefix.length());
            }
            if (!this.isInvisibleClass(param)) continue;
            boolean bl = isInner = cl.getQualifiedName().indexOf(36) >= 0;
            if (mr.isConstructor() && isInner && !cl.hasModifier(Modifier.STATIC) && firstParameter) {
                firstParameter = false;
                continue;
            }
            Object[] invargs = new String[]{param, mr.toString(), cl.getQualifiedName()};
            this.log.storeError(i18n.getString("ClassCorrector.error.parametertype.hidden", invargs), logger);
        }
    }

    private void replaceInvisibleInMembers(ClassDescription c) throws ClassNotFoundException {
        String className = c.getQualifiedName();
        List supers = this.classHierarchy.getSuperClasses(c.getQualifiedName());
        ArrayList<MemberDescription> newMembers = new ArrayList<MemberDescription>();
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            Object[] invargs;
            MemberDescription mr = (MemberDescription)e.next();
            if (mr.isSuperClass() || mr.isSuperInterface() || !this.isInvisibleClass(mr.getDeclaringClassName())) continue;
            String newPar = this.findVisibleReplacement(mr.getDeclaringClassName(), supers, className, false);
            MemberDescription newMember = (MemberDescription)mr.clone();
            newMember.setDeclaringClass(newPar);
            e.remove();
            if (!c.containsMember(newMember)) {
                newMembers.add(newMember);
                if (!logger.isLoggable(Level.FINE)) continue;
                invargs = new String[]{mr.getQualifiedName(), mr.getDeclaringClassName(), newMember.getDeclaringClassName()};
                logger.fine(i18n.getString("ClassCorrector.message.member.moved", invargs));
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            invargs = new String[]{mr.getQualifiedName(), mr.getDeclaringClassName(), newMember.getDeclaringClassName()};
            logger.fine(i18n.getString("ClassCorrector.message.member.removed", invargs));
        }
        int i = 0;
        while (i < newMembers.size()) {
            c.add((MemberDescription)newMembers.get(i));
            ++i;
        }
    }

    private void removeInvisibleInterfaces(ClassDescription c) throws ClassNotFoundException {
        ArrayList<String> makeThemDirect = null;
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isSuperInterface()) continue;
            SuperInterface si = (SuperInterface)mr;
            String siName = si.getQualifiedName();
            if (this.isInvisibleClass(siName)) {
                if (logger.isLoggable(Level.FINE)) {
                    Object[] invargs = new String[]{mr.getQualifiedName(), c.getQualifiedName()};
                    logger.fine(i18n.getString("ClassCorrector.message.interface.removed", invargs));
                }
                e.remove();
                if (si.isDirect()) {
                    if (makeThemDirect == null) {
                        makeThemDirect = new ArrayList<String>();
                    }
                    String[] intfs = this.classHierarchy.getSuperInterfaces(siName);
                    int i = 0;
                    while (i < intfs.length) {
                        makeThemDirect.add(intfs[i]);
                        ++i;
                    }
                }
            }
            if (mr.getTypeParameters() == null) continue;
            this.checkActualParameters(c, mr, mr.getTypeParameters());
        }
        if (makeThemDirect != null) {
            Iterator it = c.getMembersIterator();
            while (it.hasNext()) {
                MemberDescription mr = (MemberDescription)it.next();
                if (!mr.isSuperInterface() || !makeThemDirect.contains(mr.getQualifiedName())) continue;
                ((SuperInterface)mr).setDirect(true);
            }
        }
    }

    private void fixInvisibleSuperclasses(ClassDescription c) throws ClassNotFoundException {
        SuperInterface[] intfs = null;
        MemberDescription newMember = null;
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isSuperClass()) continue;
            if (this.isInvisibleClass(mr.getQualifiedName())) {
                ClassDescription cS = this.classHierarchy.load(mr.getQualifiedName());
                List supers = this.classHierarchy.getSuperClasses(cS.getQualifiedName());
                String newName = this.findVisibleReplacement(mr.getQualifiedName(), supers, "java.lang.Object", true);
                newMember = (MemberDescription)mr.clone();
                newMember.setupClassName(newName);
                if (logger.isLoggable(Level.FINE)) {
                    Object[] invargs = new String[]{c.getQualifiedName(), mr.getQualifiedName(), newName};
                    logger.fine(i18n.getString("ClassCorrector.message.super.changed", invargs));
                }
                e.remove();
                intfs = cS.getInterfaces();
            }
            if (mr.getTypeParameters() == null) break;
            this.checkActualParameters(c, mr, mr.getTypeParameters());
            break;
        }
        if (newMember != null) {
            c.add(newMember);
        }
        if (intfs != null) {
            int i = 0;
            while (i < intfs.length) {
                SuperInterface m = (SuperInterface)c.findMember((MemberDescription)intfs[i]);
                if (m != null) {
                    m.setDirect(true);
                    m.setDeclaringClass(c.getQualifiedName());
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void removeSuperInterfaces(Set interfaces) throws ClassNotFoundException {
        intfs = new ArrayList<E>(interfaces);
        su = new ArrayList<E>();
        i = 0;
        while (i < intfs.size()) {
            block5: {
                intfName = (String)intfs.get(i);
                if (intfName == null || this.isInvisibleClass(intfName)) break block5;
                su.clear();
                su.addAll(this.classHierarchy.getAllImplementedInterfaces(intfName));
                j = 0;
                while (j < su.size()) {
                    block6: {
                        sui = (String)su.get(j);
                        if (!sui.equals(intfName)) ** GOTO lbl17
                        break block6;
lbl-1000:
                        // 1 sources

                        {
                            intfs.set((int)var8_9, null);
lbl17:
                            // 2 sources

                            ** while ((pos = intfs.indexOf((Object)sui)) >= 0)
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        interfaces.clear();
        i = 0;
        while (i < intfs.size()) {
            if (intfs.get(i) != null && !interfaces.contains(intfs.get(i))) {
                interfaces.add(intfs.get(i));
            }
            ++i;
        }
    }

    private void removeDuplicatedConstants(ClassDescription c) {
        HashSet<String> constantNames = new HashSet<String>();
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            String constName;
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isField() || !mr.isPublic() || !((FieldDescr)mr).isConstant() || c.getMembersCount(MemberType.FIELD, constName = mr.getQualifiedName()) <= 1) continue;
            constantNames.add(constName);
        }
        Iterator e2 = c.getMembersIterator();
        while (e2.hasNext()) {
            MemberDescription mr = (MemberDescription)e2.next();
            if (!mr.isField() || !((FieldDescr)mr).isConstant() || !constantNames.contains(mr.getQualifiedName())) continue;
            e2.remove();
            if (!logger.isLoggable(Level.FINE)) continue;
            Object[] invargs = new String[]{mr.getQualifiedName(), c.getQualifiedName()};
            logger.fine(i18n.getString("ClassCorrector.message.const.removed", invargs));
        }
    }

    private void checkClassTypeParameters(ClassDescription cl) {
        this.checkTypeParameters(cl, cl);
        Iterator e = cl.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isMethod() && !mr.isConstructor()) continue;
            this.checkTypeParameters(cl, mr);
        }
    }

    private void checkTypeParameters(ClassDescription cl, MemberDescription mr) {
        String ext = "extends";
        String typeparams = mr.getTypeParameters();
        if (typeparams != null) {
            ArrayList params = Erasurator.splitParameters(typeparams);
            int i = 0;
            while (i < params.size()) {
                String param = (String)params.get(i);
                String temp = param.substring(param.indexOf("extends") + "extends".length());
                StringTokenizer st = new StringTokenizer(temp, "&");
                while (st.hasMoreTokens()) {
                    Object[] invargs;
                    String className = st.nextToken().trim();
                    int pos = className.indexOf(60);
                    if (pos != -1) {
                        this.checkActualParameters(cl, mr, className.substring(pos));
                    }
                    if (!this.isInvisibleClass(className) || className.equals(mr.getDeclaringClassName())) continue;
                    if (mr.isMethod() || mr.isConstructor()) {
                        invargs = new String[]{className, mr.toString(), mr.getDeclaringClassName()};
                        this.log.storeError(i18n.getString("ClassCorrector.error.parametertype.hidden", invargs), logger);
                        continue;
                    }
                    invargs = new String[]{className, mr.getQualifiedName()};
                    this.log.storeError(i18n.getString("ClassCorrector.error.parametertype.hidden2", invargs), logger);
                }
                ++i;
            }
        }
    }

    private static String wrapArray(String oldT, String newT) {
        int pos = oldT.indexOf(91);
        if (pos != -1) {
            return newT + oldT.substring(pos);
        }
        return newT;
    }

    private static String stripArrays(String name) {
        int pos = name.indexOf(91);
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    private static String stripGenerics(String name) {
        int pos = name.indexOf(60);
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    private boolean isPublicInner(String clName) throws ClassNotFoundException {
        if (clName.indexOf(36) < 0) {
            return false;
        }
        ClassDescription cd = this.classHierarchy.load(clName);
        return cd.isPublic() || cd.isProtected();
    }

    private boolean isInvisibleClass(String fqname) {
        if (fqname.length() == 0) {
            return false;
        }
        if (fqname.startsWith("{")) {
            return false;
        }
        if (fqname.startsWith("?")) {
            return false;
        }
        String pname = ClassCorrector.stripArrays(ClassCorrector.stripGenerics(fqname));
        if (PrimitiveTypes.isPrimitive(pname)) {
            return false;
        }
        boolean accessible = true;
        try {
            accessible = this.classHierarchy.isAccessible(pname);
        }
        catch (ClassNotFoundException e) {
            this.log.storeError(i18n.getString("ClassCorrector.error.missingclass", new String[]{pname}), logger);
        }
        return !accessible;
    }

    private void removeInvisibleAnnotations(ClassDescription cl) throws ClassNotFoundException {
        int count = 0;
        AnnotationItem[] annotations = cl.getAnnoList();
        int len = annotations.length;
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            String annoName = annotations[i].getName();
            boolean documented = this.classHierarchy.isDocumentedAnnotation(annoName);
            if (this.isInvisibleClass(annoName)) {
                if (documented && logger.isLoggable(Level.WARNING)) {
                    logger.warning(i18n.getString("ClassCorrector.error.invisible_documented_annotation", annoName));
                }
                annotations[i] = null;
            } else {
                ++count;
            }
            ++i;
        }
        if (count == len) {
            return;
        }
        AnnotationItem[] visibleAnnotations = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        if (count != 0) {
            visibleAnnotations = new AnnotationItem[count];
            count = 0;
            int i2 = 0;
            while (i2 < len) {
                if (annotations[i2] != null) {
                    visibleAnnotations[count++] = annotations[i2];
                }
                ++i2;
            }
        }
        cl.setAnnoList(visibleAnnotations);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

