#!/bin/sh

set -e

DESTDIR=${DESTDIR:-../tarballs}
MODULE=CGI-Application-Plugin-ViewCode
PACKAGE=libcgi-application-plugin-viewcode-perl
VERSION=1.02
DEBUG_VERS=1.00
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC=-"-watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/ds/watch ${FD} ${NS} ${DD} ${US} ${DEBUG_VERS} && true;
    cd ${DESTDIR}
    DEBUG=`ls CGI-Application-Plugin-DebugScreen*.tar.gz`
    mv ${DEBUG} ${PACKAGE}_${VERSION}.orig-ds.tar.gz
    cd -
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/ds/watch ${RS} ${DD} ${US} ${DEBUG_VERS} && true;
fi
